
// from lpcsp.c http://elm-chan.org/works/sp78k/lpcsp.zip

/* Create an uuencoded asciz string from a byte array */
void uuencode (
    const void* src,    /* Pointer to the input data */
    int srcsize,        /* Size of input data (0 to 45) */
    char* dst           /* Pointer to the output buffer */
)
{
    const unsigned char *bin = (const unsigned char*)src;
    unsigned char c1, c2, c3;
    char c;
    int cc;


    if (srcsize >= 0 || srcsize <= 45) {
        c = srcsize + 0x20;
        *dst++ = (c == ' ') ? '`' : c;

        for (cc = 1; srcsize > 0; srcsize -= 3, cc += 4) {
            c1 = *bin++;
            c2 = c3 = 0;
            if (srcsize >= 2) {
                c2 = *bin++;
                if (srcsize >= 3) {
                    c3 = *bin++;
                }
            }
            c = (c1 >> 2) + 0x20;
            *dst++ = (c == ' ') ? '`' : c;
            c = ((c1 & 3) << 4) + (c2 >> 4) + 0x20;
            *dst++ = (c == ' ') ? '`' : c;
            c = ((c2 & 15) << 2) + (c3 >> 6) + 0x20;
            *dst++ = (c == ' ') ? '`' : c;
            c = (c3 & 63) + 0x20;
            *dst++ = (c == ' ') ? '`' : c;
        }
    }
    *dst = 0;
}
