#ifdef TARGET_KL46Z
#include "USBLocalFileSystem.h"
#include "BaseLpcIsp.h"
#include "SLCD.h"

DigitalOut led_sw(PTD5);
DigitalOut led_tx(PTE29);
#define LED_ON  0
#define LED_OFF 1

InterruptIn sw1(SW1);
InterruptIn sw3(SW3);
RawSerial pc(USBTX,USBRX);
SLCD slcd;

class lpc81isp : public BaseLpcIsp {
public:
    lpc81isp(PinName txd, PinName rxd, PinName reset, PinName isp):BaseLpcIsp(txd, rxd, reset, isp){}
    virtual void infoLED(int select, int value) {
        switch(select) {
            case LED_TX: led_tx = value ? LED_ON : LED_OFF; break;
        }
    }
    virtual void infoSLCD(const char* s) { slcd.puts(s); }
} lpc(PTE22, PTE23, D6, D8); // TX,RX,nRESET,nISP

__IO bool write_start = false;
void swIRQ() {
    led_sw = LED_ON;
    wait_ms(100);
    led_sw = LED_OFF;
    write_start = true;
}

int main() {
    pc.baud(9600);
    pc.printf("%s", __FILE__);
    led_sw = LED_OFF;
    led_tx = LED_OFF;

    sw1.rise(swIRQ);
    sw3.rise(swIRQ);
    
    USBLocalFileSystem* usb_local = new USBLocalFileSystem(); // RamDisk(64KB)
    slcd.puts("REDY");
    write_start = false;
    while(1) {
        if (write_start) {
            usb_local->remount();
            mystring filename;
            if (LocalStorage::find_bin(filename)) {
                pc.printf("bin filename=[%s]\n", filename.c_str());
                lpc.baud(9600);
                lpc.Reset(true); // ISP mode
                lpc.Sync();
                lpc.FlashWrite(filename.c_str());
                lpc.Reset(false); // Reset
            }    
            write_start = false;
        }
        if (usb_local->readable()) {
            lpc.putc(usb_local->getc());
        }
        if (lpc.readable()) {
            usb_local->putc(lpc.getc());
        }
        if (pc.readable()) {
            switch(pc.getc()) {
                case 'w':
                case 'W': 
                    write_start = true;
                    break;
                default:
                    break;
            }
        } 
    }
}
#endif // TARGET_KL46Z

