#include "USBHostGPS.h"
#include "SLCD.h"

DigitalOut led1(LED_GREEN);
DigitalOut led2(LED_RED);
#define LED_OFF 1
#define LED_ON  0

SLCD slcd;

void callback_gps(char* buf, int size) {
    for(int i = 0; i < size; i++) {
        char c = buf[i];
        printf("%c", c);
    }
    led2 = !led2;
}

int main() {
    // GT-730F/L 38400bps
    // Gosget SD-200 GPS DONGLE 4800bps
     USBHostGPS gps(4800);
    if (!gps.connect()) {
        error("GPS not found.\n");
    }
    gps.attachEventRaw(callback_gps);

    time_t prev = gps.nmea.update_t;
    while(1) {
        USBHost::poll();
        if (prev != gps.nmea.update_t) {
            struct tm * timeinfo;
            timeinfo = localtime(&gps.nmea.update_t);
            char buf[5];
            strftime(buf, sizeof(buf), "%M%S", timeinfo);
            slcd.printf("%.4s", buf);
            prev = gps.nmea.update_t;
            led1 = !led1;
        }
    }
}
