/* HTTPNull.cpp */
//Debug is disabled by default
#if 1
//Enable debug
#include <cstdio>
#define DBG(x, ...) std::printf("[HTTPNull : DBG]"x"\r\n", ##__VA_ARGS__); 
//#define DBG(x, ...) 
#define WARN(x, ...) std::printf("[HTTPNull : WARN]"x"\r\n", ##__VA_ARGS__); 
#define ERR(x, ...) std::printf("[HTTPNull : ERR]"x"\r\n", ##__VA_ARGS__); 

#else
//Disable debug
#define DBG(x, ...) 
#define WARN(x, ...)
#define ERR(x, ...) 

#endif

#include "HTTPNull.h"

#define OK 0

HTTPNull::HTTPNull()
{

}

//IHTTPDataOut
/*virtual*/ int HTTPNull::write(const char* buf, size_t len)
{
    DBG("write(%p, %d)", buf, len);
    return OK;
}

/*virtual*/ void HTTPNull::setDataType(const char* type) //Internet media type from Content-Type header
{
    DBG("setDataType(%s)", type);
}

/*virtual*/ void HTTPNull::setIsChunked(bool chunked) //From Transfer-Encoding header
{

}

/*virtual*/ void HTTPNull::setDataLen(size_t len) //From Content-Length header, or if the transfer is chunked, next chunk length
{
    DBG("setDataLen(%d)", len);   
}
