#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"
#include "HTTPPoster.h"
#include "HTTPNull.h"

Serial pc(USBTX, USBRX);

LocalFileSystem local("local"); 

EthernetInterface eth;
HTTPClient http;

int main() {
    pc.baud(921600);
    printf("%s\n", __FILE__);

    eth.init(); //Use DHCP
    eth.connect();

    HTTPPoster data;
    HTTPNull text_null;
    data.addFile("image", "/local/image1.jpg");
    data.add("title", "hello");
    string url = "http://va009039.appspot.com/mbed/upload/";
    
    HTTPResult ret = http.post(url.c_str(), data, &text_null);
    if (!ret) {
      printf("Executed POST successfully\n");
    } else {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }

    exit(1);    
}
