/* HTTPPoster.h */
#ifndef HTTP_POSTER_H
#define HTTP_POSTER_H

#include "../IHTTPData.h"

#include "mbed.h"
#include <string>
#include <vector>

/** HTTPPoster HTTP Client data container for form(multipart/form-data)
 *
 *@code
 *HTTPClient client;
 *HTTPPoster data;
 *data.addFile("image", "/local/image.jpg");
 *data.add("title", "hello");
 *string url = "http://va009039.appspot.com/mbed/upload/";
 *HTTPResult r = client.post(url.c_str(), data, NULL);
 *printf("result:%d HTTPResponseCode: %d\n", r, client.getHTTPResponseCode());
 *@endcode
 */
 
struct stpost {
    bool file;
    string head;
    string value;
    int length;
};

///HTTPPoster HTTP Client data container for form(multipart/form-data)
class HTTPPoster : public IHTTPDataOut
{
public:
  ///Instantiates the object.
  HTTPPoster();
  ///put file
  bool addFile(const char* name, const char* path);
  ///put param
  bool add(const char* name, const char* value);

  virtual ~HTTPPoster();
protected:
  //IHTTPDataOut
  virtual int read(char* buf, size_t len, size_t* pReadLen);
  virtual int getDataType(char* type, size_t maxTypeLen); //Internet media type for Content-Type header
  virtual bool getIsChunked(); //For Transfer-Encoding header
  virtual size_t getDataLen(); //For Content-Length header

private:
  int m_seq;
  int m_cur;
  int m_pos;
  vector <stpost> m_post_data;
  FILE* m_fp;
  int m_len;
  int m_send_len;
  string m_buf;
  string m_ContentType;
  char* m_boundary;
};

#endif // HTTP_POSTER_H
