// STARTFONT 2.1
// FONT -Misaki-Gothic-Medium-R-Normal--8-80-75-75-C-80-jisx0208.1990-0
// SIZE 8 75 75
// FONTBOUNDINGBOX 8 8 0 -2
// STARTPROPERTIES 19
// FONTNAME_REGISTRY ""
// FOUNDRY "Misaki"
// FAMILY_NAME "Gothic"
// WEIGHT_NAME "Medium"
// SLANT "R"
// SETWIDTH_NAME "Normal"
// ADD_STYLE_NAME ""
// PIXEL_SIZE 8
// POINT_SIZE 80
// RESOLUTION_X 75
// RESOLUTION_Y 75
// SPACING "C"
// AVERAGE_WIDTH 80
// CHARSET_REGISTRY "jisx0208.1990"
// CHARSET_ENCODING "0"
// DEFAULT_CHAR 8481
// FONT_DESCENT 2
// FONT_ASCENT 6
// COPYRIGHT "Copyright(C) 2002-2012 Num Kadoma"
// ENDPROPERTIES

#include "GraphicOLED.h"

struct stfont {
    uint16_t unicode;
    uint8_t bitmap[8];
};

static const struct stfont misaki_gothic[] = {
{0x00a2,{0x00,0x1c,0x62,0x32,0x2e,0x23,0x14}}, // \xc2\xa2
{0x00a3,{0x20,0x54,0x5e,0x25,0x41,0x42,0x20}}, // \xc2\xa3
{0x00a7,{0x00,0x00,0x4a,0x55,0x55,0x29,0x00}}, // \xc2\xa7
{0x00a8,{0x00,0x00,0x01,0x00,0x01,0x00,0x00}}, // \xc2\xa8
{0x00ac,{0x08,0x08,0x08,0x08,0x08,0x08,0x38}}, // \xc2\xac
{0x00b0,{0x02,0x05,0x02,0x00,0x00,0x00,0x00}}, // \xc2\xb0
{0x00b1,{0x44,0x44,0x44,0x5f,0x44,0x44,0x44}}, // \xc2\xb1
{0x00b4,{0x00,0x00,0x00,0x02,0x01,0x00,0x00}}, // \xc2\xb4
{0x00b6,{0x00,0x06,0x0f,0x7f,0x01,0x7f,0x00}}, // \xc2\xb6
{0x00d7,{0x41,0x22,0x14,0x08,0x14,0x22,0x41}}, // \xc3\x97
{0x00f7,{0x08,0x08,0x08,0x2a,0x08,0x08,0x08}}, // \xc3\xb7
{0x0391,{0x60,0x18,0x16,0x11,0x16,0x18,0x60}}, // \xce\x91
{0x0392,{0x00,0x7f,0x49,0x49,0x49,0x49,0x36}}, // \xce\x92
{0x0393,{0x00,0x7f,0x01,0x01,0x01,0x01,0x01}}, // \xce\x93
{0x0394,{0x60,0x58,0x46,0x41,0x46,0x58,0x60}}, // \xce\x94
{0x0395,{0x00,0x7f,0x49,0x49,0x49,0x49,0x41}}, // \xce\x95
{0x0396,{0x00,0x41,0x61,0x51,0x49,0x45,0x43}}, // \xce\x96
{0x0397,{0x00,0x7f,0x08,0x08,0x08,0x08,0x7f}}, // \xce\x97
{0x0398,{0x1c,0x22,0x49,0x49,0x49,0x22,0x1c}}, // \xce\x98
{0x0399,{0x00,0x00,0x41,0x7f,0x41,0x00,0x00}}, // \xce\x99
{0x039a,{0x00,0x7f,0x10,0x08,0x14,0x22,0x41}}, // \xce\x9a
{0x039b,{0x60,0x18,0x06,0x01,0x06,0x18,0x60}}, // \xce\x9b
{0x039c,{0x7f,0x02,0x0c,0x30,0x0c,0x02,0x7f}}, // \xce\x9c
{0x039d,{0x00,0x7f,0x02,0x04,0x08,0x10,0x7f}}, // \xce\x9d
{0x039e,{0x00,0x41,0x49,0x49,0x49,0x49,0x41}}, // \xce\x9e
{0x039f,{0x00,0x1c,0x22,0x41,0x41,0x22,0x1c}}, // \xce\x9f
{0x03a0,{0x00,0x7f,0x01,0x01,0x01,0x01,0x7f}}, // \xce\xa0
{0x03a1,{0x00,0x7f,0x09,0x09,0x09,0x09,0x06}}, // \xce\xa1
{0x03a3,{0x00,0x41,0x63,0x55,0x49,0x41,0x41}}, // \xce\xa3
{0x03a4,{0x01,0x01,0x01,0x7f,0x01,0x01,0x01}}, // \xce\xa4
{0x03a5,{0x01,0x02,0x04,0x78,0x04,0x02,0x01}}, // \xce\xa5
{0x03a6,{0x1c,0x22,0x22,0x7f,0x22,0x22,0x1c}}, // \xce\xa6
{0x03a7,{0x41,0x22,0x14,0x08,0x14,0x22,0x41}}, // \xce\xa7
{0x03a8,{0x01,0x06,0x08,0x7f,0x08,0x06,0x01}}, // \xce\xa8
{0x03a9,{0x4c,0x52,0x61,0x01,0x61,0x52,0x4c}}, // \xce\xa9
{0x03b1,{0x00,0x30,0x48,0x44,0x34,0x48,0x24}}, // \xce\xb1
{0x03b2,{0x00,0x60,0x1c,0x12,0x25,0x25,0x1a}}, // \xce\xb2
{0x03b3,{0x00,0x04,0x64,0x38,0x08,0x04,0x00}}, // \xce\xb3
{0x03b4,{0x00,0x30,0x4a,0x45,0x39,0x02,0x00}}, // \xce\xb4
{0x03b5,{0x00,0x20,0x58,0x54,0x44,0x28,0x00}}, // \xce\xb5
{0x03b6,{0x00,0x00,0x0d,0x52,0x51,0x21,0x00}}, // \xce\xb6
{0x03b7,{0x00,0x08,0x24,0x18,0x04,0x64,0x18}}, // \xce\xb7
{0x03b8,{0x00,0x38,0x4e,0x49,0x39,0x0e,0x00}}, // \xce\xb8
{0x03b9,{0x00,0x00,0x30,0x4c,0x20,0x00,0x00}}, // \xce\xb9
{0x03ba,{0x00,0x60,0x1c,0x30,0x48,0x44,0x00}}, // \xce\xba
{0x03bb,{0x00,0x40,0x30,0x09,0x3e,0x40,0x00}}, // \xce\xbb
{0x03bc,{0x00,0x40,0x30,0x2c,0x20,0x10,0x2c}}, // \xce\xbc
{0x03bd,{0x00,0x04,0x78,0x20,0x10,0x0c,0x00}}, // \xce\xbd
{0x03be,{0x00,0x08,0x16,0x55,0x55,0x25,0x00}}, // \xce\xbe
{0x03bf,{0x00,0x30,0x48,0x44,0x24,0x18,0x00}}, // \xce\xbf
{0x03c0,{0x00,0x48,0x24,0x1c,0x04,0x7c,0x44}}, // \xcf\x80
{0x03c1,{0x00,0x60,0x18,0x24,0x24,0x24,0x18}}, // \xcf\x81
{0x03c3,{0x00,0x30,0x48,0x44,0x24,0x1c,0x04}}, // \xcf\x83
{0x03c4,{0x00,0x08,0x04,0x34,0x4c,0x24,0x04}}, // \xcf\x84
{0x03c5,{0x00,0x08,0x34,0x4c,0x40,0x20,0x1c}}, // \xcf\x85
{0x03c6,{0x00,0x18,0x24,0x64,0x3c,0x27,0x18}}, // \xcf\x86
{0x03c7,{0x00,0x40,0x24,0x34,0x48,0x44,0x00}}, // \xcf\x87
{0x03c8,{0x00,0x14,0x2c,0x60,0x3c,0x23,0x18}}, // \xcf\x88
{0x03c9,{0x00,0x38,0x44,0x20,0x38,0x40,0x3c}}, // \xcf\x89
{0x0401,{0x00,0x7e,0x4b,0x4a,0x4a,0x4b,0x42}}, // \xd0\x81
{0x0410,{0x60,0x18,0x16,0x11,0x16,0x18,0x60}}, // \xd0\x90
{0x0411,{0x00,0x7f,0x49,0x49,0x49,0x49,0x31}}, // \xd0\x91
{0x0412,{0x00,0x7f,0x49,0x49,0x49,0x49,0x36}}, // \xd0\x92
{0x0413,{0x00,0x7f,0x01,0x01,0x01,0x01,0x01}}, // \xd0\x93
{0x0414,{0x60,0x30,0x2f,0x21,0x21,0x3f,0x60}}, // \xd0\x94
{0x0415,{0x00,0x7f,0x49,0x49,0x49,0x49,0x41}}, // \xd0\x95
{0x0416,{0x41,0x36,0x08,0x7f,0x08,0x36,0x41}}, // \xd0\x96
{0x0417,{0x00,0x22,0x41,0x49,0x49,0x49,0x36}}, // \xd0\x97
{0x0418,{0x00,0x7f,0x20,0x10,0x08,0x04,0x7f}}, // \xd0\x98
{0x0419,{0x00,0x7e,0x21,0x12,0x0a,0x05,0x7e}}, // \xd0\x99
{0x041a,{0x00,0x7f,0x08,0x08,0x16,0x21,0x41}}, // \xd0\x9a
{0x041b,{0x40,0x40,0x3f,0x01,0x01,0x01,0x7f}}, // \xd0\x9b
{0x041c,{0x78,0x07,0x18,0x60,0x18,0x07,0x78}}, // \xd0\x9c
{0x041d,{0x00,0x7f,0x08,0x08,0x08,0x08,0x7f}}, // \xd0\x9d
{0x041e,{0x00,0x1c,0x22,0x41,0x41,0x22,0x1c}}, // \xd0\x9e
{0x041f,{0x00,0x7f,0x01,0x01,0x01,0x01,0x7f}}, // \xd0\x9f
{0x0420,{0x00,0x7f,0x09,0x09,0x09,0x09,0x06}}, // \xd0\xa0
{0x0421,{0x00,0x1c,0x22,0x41,0x41,0x41,0x22}}, // \xd0\xa1
{0x0422,{0x01,0x01,0x01,0x7f,0x01,0x01,0x01}}, // \xd0\xa2
{0x0423,{0x00,0x41,0x46,0x28,0x18,0x06,0x01}}, // \xd0\xa3
{0x0424,{0x1c,0x22,0x22,0x7f,0x22,0x22,0x1c}}, // \xd0\xa4
{0x0425,{0x41,0x22,0x14,0x08,0x14,0x22,0x41}}, // \xd0\xa5
{0x0426,{0x00,0x3f,0x20,0x20,0x20,0x3f,0x60}}, // \xd0\xa6
{0x0427,{0x00,0x0f,0x10,0x10,0x10,0x10,0x7f}}, // \xd0\xa7
{0x0428,{0x7f,0x40,0x40,0x7f,0x40,0x40,0x7f}}, // \xd0\xa8
{0x0429,{0x3f,0x20,0x20,0x3f,0x20,0x20,0x7f}}, // \xd0\xa9
{0x042a,{0x00,0x01,0x7f,0x48,0x48,0x48,0x30}}, // \xd0\xaa
{0x042b,{0x00,0x7f,0x48,0x48,0x30,0x00,0x7f}}, // \xd0\xab
{0x042c,{0x00,0x00,0x7f,0x48,0x48,0x48,0x30}}, // \xd0\xac
{0x042d,{0x00,0x22,0x49,0x49,0x49,0x2a,0x1c}}, // \xd0\xad
{0x042e,{0x7f,0x08,0x3e,0x41,0x41,0x41,0x3e}}, // \xd0\xae
{0x042f,{0x00,0x46,0x39,0x09,0x09,0x09,0x7f}}, // \xd0\xaf
{0x0430,{0x00,0x20,0x54,0x54,0x54,0x78,0x00}}, // \xd0\xb0
{0x0431,{0x00,0x3c,0x46,0x45,0x45,0x39,0x00}}, // \xd0\xb1
{0x0432,{0x00,0x7c,0x54,0x54,0x54,0x28,0x00}}, // \xd0\xb2
{0x0433,{0x00,0x7c,0x04,0x04,0x04,0x04,0x00}}, // \xd0\xb3
{0x0434,{0x00,0x60,0x3c,0x24,0x3c,0x60,0x00}}, // \xd0\xb4
{0x0435,{0x00,0x38,0x54,0x54,0x54,0x18,0x00}}, // \xd0\xb5
{0x0436,{0x44,0x28,0x10,0x7c,0x10,0x28,0x44}}, // \xd0\xb6
{0x0437,{0x00,0x28,0x44,0x54,0x54,0x28,0x00}}, // \xd0\xb7
{0x0438,{0x00,0x7c,0x20,0x10,0x08,0x7c,0x00}}, // \xd0\xb8
{0x0439,{0x00,0x7c,0x21,0x12,0x09,0x7c,0x00}}, // \xd0\xb9
{0x043a,{0x00,0x7c,0x10,0x18,0x24,0x44,0x00}}, // \xd0\xba
{0x043b,{0x40,0x40,0x3c,0x04,0x04,0x7c,0x00}}, // \xd0\xbb
{0x043c,{0x00,0x7c,0x08,0x30,0x08,0x7c,0x00}}, // \xd0\xbc
{0x043d,{0x00,0x7c,0x10,0x10,0x10,0x7c,0x00}}, // \xd0\xbd
{0x043e,{0x00,0x38,0x44,0x44,0x44,0x38,0x00}}, // \xd0\xbe
{0x043f,{0x00,0x7c,0x04,0x04,0x04,0x7c,0x00}}, // \xd0\xbf
{0x0440,{0x00,0x7c,0x14,0x14,0x14,0x08,0x00}}, // \xd1\x80
{0x0441,{0x00,0x38,0x44,0x44,0x44,0x28,0x00}}, // \xd1\x81
{0x0442,{0x00,0x04,0x04,0x7c,0x04,0x04,0x00}}, // \xd1\x82
{0x0443,{0x00,0x44,0x58,0x20,0x18,0x04,0x00}}, // \xd1\x83
{0x0444,{0x00,0x18,0x24,0x7f,0x24,0x18,0x00}}, // \xd1\x84
{0x0445,{0x00,0x44,0x28,0x10,0x28,0x44,0x00}}, // \xd1\x85
{0x0446,{0x00,0x3c,0x20,0x20,0x3c,0x60,0x00}}, // \xd1\x86
{0x0447,{0x00,0x1c,0x20,0x20,0x20,0x7c,0x00}}, // \xd1\x87
{0x0448,{0x00,0x7c,0x40,0x7c,0x40,0x7c,0x00}}, // \xd1\x88
{0x0449,{0x00,0x3c,0x20,0x3c,0x20,0x3c,0x60}}, // \xd1\x89
{0x044a,{0x00,0x04,0x7c,0x50,0x50,0x50,0x20}}, // \xd1\x8a
{0x044b,{0x00,0x7c,0x50,0x50,0x20,0x7c,0x00}}, // \xd1\x8b
{0x044c,{0x00,0x7c,0x50,0x50,0x50,0x20,0x00}}, // \xd1\x8c
{0x044d,{0x00,0x28,0x44,0x54,0x54,0x38,0x00}}, // \xd1\x8d
{0x044e,{0x00,0x7c,0x10,0x38,0x44,0x44,0x38}}, // \xd1\x8e
{0x044f,{0x00,0x48,0x34,0x14,0x14,0x7c,0x00}}, // \xd1\x8f
{0x0451,{0x00,0x38,0x55,0x54,0x55,0x18,0x00}}, // \xd1\x91
{0x2010,{0x00,0x00,0x08,0x08,0x08,0x00,0x00}}, // \xe2\x80\x90
{0x2015,{0x08,0x08,0x08,0x08,0x08,0x08,0x08}}, // \xe2\x80\x95
{0x2016,{0x00,0x00,0x7f,0x00,0x7f,0x00,0x00}}, // \xe2\x80\x96
{0x2018,{0x00,0x00,0x00,0x00,0x00,0x06,0x05}}, // \xe2\x80\x98
{0x2019,{0x05,0x03,0x00,0x00,0x00,0x00,0x00}}, // \xe2\x80\x99
{0x201c,{0x00,0x00,0x06,0x05,0x00,0x06,0x05}}, // \xe2\x80\x9c
{0x201d,{0x05,0x03,0x00,0x05,0x03,0x00,0x00}}, // \xe2\x80\x9d
{0x2020,{0x00,0x00,0x02,0x7f,0x02,0x00,0x00}}, // \xe2\x80\xa0
{0x2021,{0x00,0x00,0x22,0x7f,0x22,0x00,0x00}}, // \xe2\x80\xa1
{0x2025,{0x00,0x08,0x00,0x00,0x00,0x08,0x00}}, // \xe2\x80\xa5
{0x2026,{0x08,0x00,0x00,0x08,0x00,0x00,0x08}}, // \xe2\x80\xa6
{0x2030,{0x22,0x15,0x2a,0x54,0x22,0x51,0x20}}, // \xe2\x80\xb0
{0x2032,{0x04,0x03,0x00,0x00,0x00,0x00,0x00}}, // \xe2\x80\xb2
{0x2033,{0x04,0x03,0x04,0x03,0x00,0x00,0x00}}, // \xe2\x80\xb3
{0x203b,{0x49,0x22,0x14,0x49,0x14,0x22,0x49}}, // \xe2\x80\xbb
{0x2103,{0x02,0x05,0x02,0x3c,0x42,0x42,0x24}}, // \xe2\x84\x83
{0x212b,{0x40,0x30,0x2a,0x25,0x2a,0x30,0x40}}, // \xe2\x84\xab
{0x2190,{0x08,0x1c,0x2a,0x08,0x08,0x08,0x08}}, // \xe2\x86\x90
{0x2191,{0x00,0x04,0x02,0x7f,0x02,0x04,0x00}}, // \xe2\x86\x91
{0x2192,{0x08,0x08,0x08,0x08,0x2a,0x1c,0x08}}, // \xe2\x86\x92
{0x2193,{0x00,0x10,0x20,0x7f,0x20,0x10,0x00}}, // \xe2\x86\x93
{0x21d2,{0x14,0x14,0x14,0x14,0x36,0x14,0x08}}, // \xe2\x87\x92
{0x21d4,{0x08,0x14,0x36,0x14,0x36,0x14,0x08}}, // \xe2\x87\x94
{0x2200,{0x03,0x0c,0x34,0x44,0x34,0x0c,0x03}}, // \xe2\x88\x80
{0x2202,{0x00,0x30,0x4a,0x49,0x31,0x0e,0x00}}, // \xe2\x88\x82
{0x2203,{0x00,0x49,0x49,0x49,0x49,0x49,0x7f}}, // \xe2\x88\x83
{0x2207,{0x03,0x0d,0x31,0x41,0x31,0x0d,0x03}}, // \xe2\x88\x87
{0x2208,{0x00,0x1c,0x2a,0x2a,0x2a,0x2a,0x2a}}, // \xe2\x88\x88
{0x220b,{0x00,0x2a,0x2a,0x2a,0x2a,0x2a,0x1c}}, // \xe2\x88\x8b
{0x2212,{0x08,0x08,0x08,0x08,0x08,0x08,0x08}}, // \xe2\x88\x92
{0x221a,{0x10,0x70,0x1c,0x03,0x01,0x01,0x01}}, // \xe2\x88\x9a
{0x221d,{0x1c,0x22,0x22,0x1c,0x22,0x22,0x14}}, // \xe2\x88\x9d
{0x221e,{0x1c,0x22,0x22,0x1c,0x22,0x22,0x1c}}, // \xe2\x88\x9e
{0x2220,{0x00,0x40,0x60,0x50,0x48,0x44,0x42}}, // \xe2\x88\xa0
{0x2227,{0x40,0x30,0x0c,0x03,0x0c,0x30,0x40}}, // \xe2\x88\xa7
{0x2228,{0x01,0x06,0x18,0x60,0x18,0x06,0x01}}, // \xe2\x88\xa8
{0x2229,{0x00,0x7c,0x02,0x02,0x02,0x02,0x7c}}, // \xe2\x88\xa9
{0x222a,{0x00,0x1f,0x20,0x20,0x20,0x20,0x1f}}, // \xe2\x88\xaa
{0x222b,{0x00,0x00,0x46,0x49,0x31,0x00,0x00}}, // \xe2\x88\xab
{0x222c,{0x00,0x46,0x49,0x31,0x46,0x49,0x31}}, // \xe2\x88\xac
{0x2234,{0x00,0x20,0x00,0x02,0x00,0x20,0x00}}, // \xe2\x88\xb4
{0x2235,{0x00,0x02,0x00,0x20,0x00,0x02,0x00}}, // \xe2\x88\xb5
{0x223d,{0x1c,0x22,0x20,0x1c,0x02,0x22,0x1c}}, // \xe2\x88\xbd
{0x2252,{0x14,0x15,0x14,0x14,0x14,0x54,0x14}}, // \xe2\x89\x92
{0x2260,{0x14,0x34,0x14,0x1c,0x14,0x16,0x14}}, // \xe2\x89\xa0
{0x2261,{0x00,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a}}, // \xe2\x89\xa1
{0x2266,{0x44,0x44,0x4a,0x4a,0x4a,0x51,0x51}}, // \xe2\x89\xa6
{0x2267,{0x51,0x51,0x4a,0x4a,0x4a,0x44,0x44}}, // \xe2\x89\xa7
{0x226a,{0x08,0x14,0x22,0x08,0x14,0x22,0x00}}, // \xe2\x89\xaa
{0x226b,{0x00,0x22,0x14,0x08,0x22,0x14,0x08}}, // \xe2\x89\xab
{0x2282,{0x00,0x1c,0x22,0x22,0x22,0x22,0x22}}, // \xe2\x8a\x82
{0x2283,{0x00,0x22,0x22,0x22,0x22,0x22,0x1c}}, // \xe2\x8a\x83
{0x2286,{0x00,0x4e,0x51,0x51,0x51,0x51,0x51}}, // \xe2\x8a\x86
{0x2287,{0x00,0x51,0x51,0x51,0x51,0x51,0x4e}}, // \xe2\x8a\x87
{0x22a5,{0x40,0x40,0x40,0x7e,0x40,0x40,0x40}}, // \xe2\x8a\xa5
{0x2312,{0x02,0x01,0x01,0x01,0x01,0x01,0x02}}, // \xe2\x8c\x92
{0x2500,{0x08,0x08,0x08,0x08,0x08,0x08,0x08}}, // \xe2\x94\x80
{0x2501,{0x18,0x18,0x18,0x18,0x18,0x18,0x18}}, // \xe2\x94\x81
{0x2502,{0x00,0x00,0x00,0xff,0x00,0x00,0x00}}, // \xe2\x94\x82
{0x2503,{0x00,0x00,0x00,0xff,0xff,0x00,0x00}}, // \xe2\x94\x83
{0x250c,{0x00,0x00,0x00,0xf8,0x08,0x08,0x08}}, // \xe2\x94\x8c
{0x250f,{0x00,0x00,0x00,0xf8,0xf8,0x18,0x18}}, // \xe2\x94\x8f
{0x2510,{0x08,0x08,0x08,0xf8,0x00,0x00,0x00}}, // \xe2\x94\x90
{0x2513,{0x18,0x18,0x18,0xf8,0xf8,0x00,0x00}}, // \xe2\x94\x93
{0x2514,{0x00,0x00,0x00,0x0f,0x08,0x08,0x08}}, // \xe2\x94\x94
{0x2517,{0x00,0x00,0x00,0x1f,0x1f,0x18,0x18}}, // \xe2\x94\x97
{0x2518,{0x08,0x08,0x08,0x0f,0x00,0x00,0x00}}, // \xe2\x94\x98
{0x251b,{0x18,0x18,0x18,0x1f,0x1f,0x00,0x00}}, // \xe2\x94\x9b
{0x251c,{0x00,0x00,0x00,0xff,0x08,0x08,0x08}}, // \xe2\x94\x9c
{0x251d,{0x00,0x00,0x00,0xff,0x18,0x18,0x18}}, // \xe2\x94\x9d
{0x2520,{0x00,0x00,0x00,0xff,0xff,0x08,0x08}}, // \xe2\x94\xa0
{0x2523,{0x00,0x00,0x00,0xff,0xff,0x18,0x18}}, // \xe2\x94\xa3
{0x2524,{0x08,0x08,0x08,0xff,0x00,0x00,0x00}}, // \xe2\x94\xa4
{0x2525,{0x18,0x18,0x18,0xff,0x00,0x00,0x00}}, // \xe2\x94\xa5
{0x2528,{0x08,0x08,0x08,0xff,0xff,0x00,0x00}}, // \xe2\x94\xa8
{0x252b,{0x18,0x18,0x18,0xff,0xff,0x00,0x00}}, // \xe2\x94\xab
{0x252c,{0x08,0x08,0x08,0xf8,0x08,0x08,0x08}}, // \xe2\x94\xac
{0x252f,{0x18,0x18,0x18,0xf8,0x18,0x18,0x18}}, // \xe2\x94\xaf
{0x2530,{0x08,0x08,0x08,0xf8,0xf8,0x08,0x08}}, // \xe2\x94\xb0
{0x2533,{0x18,0x18,0x18,0xf8,0xf8,0x18,0x18}}, // \xe2\x94\xb3
{0x2534,{0x08,0x08,0x08,0x0f,0x08,0x08,0x08}}, // \xe2\x94\xb4
{0x2537,{0x18,0x18,0x18,0x1f,0x18,0x18,0x18}}, // \xe2\x94\xb7
{0x2538,{0x08,0x08,0x08,0x0f,0x0f,0x08,0x08}}, // \xe2\x94\xb8
{0x253b,{0x18,0x18,0x18,0x1f,0x1f,0x18,0x18}}, // \xe2\x94\xbb
{0x253c,{0x08,0x08,0x08,0xff,0x08,0x08,0x08}}, // \xe2\x94\xbc
{0x253f,{0x18,0x18,0x18,0xff,0x18,0x18,0x18}}, // \xe2\x94\xbf
{0x2542,{0x08,0x08,0x08,0xff,0xff,0x08,0x08}}, // \xe2\x95\x82
{0x254b,{0x18,0x18,0x18,0xff,0xff,0x18,0x18}}, // \xe2\x95\x8b
{0x25a0,{0x7f,0x7f,0x7f,0x7f,0x7f,0x7f,0x7f}}, // \xe2\x96\xa0
{0x25a1,{0x7f,0x41,0x41,0x41,0x41,0x41,0x7f}}, // \xe2\x96\xa1
{0x25b2,{0x40,0x70,0x7c,0x7f,0x7c,0x70,0x40}}, // \xe2\x96\xb2
{0x25b3,{0x40,0x70,0x4c,0x43,0x4c,0x70,0x40}}, // \xe2\x96\xb3
{0x25bc,{0x01,0x07,0x1f,0x7f,0x1f,0x07,0x01}}, // \xe2\x96\xbc
{0x25bd,{0x01,0x07,0x19,0x61,0x19,0x07,0x01}}, // \xe2\x96\xbd
{0x25c6,{0x08,0x1c,0x3e,0x7f,0x3e,0x1c,0x08}}, // \xe2\x97\x86
{0x25c7,{0x08,0x14,0x22,0x41,0x22,0x14,0x08}}, // \xe2\x97\x87
{0x25cb,{0x1c,0x22,0x41,0x41,0x41,0x22,0x1c}}, // \xe2\x97\x8b
{0x25ce,{0x1c,0x22,0x5d,0x55,0x5d,0x22,0x1c}}, // \xe2\x97\x8e
{0x25cf,{0x1c,0x3e,0x7f,0x7f,0x7f,0x3e,0x1c}}, // \xe2\x97\x8f
{0x25ef,{0x3e,0x41,0x41,0x41,0x41,0x41,0x3e}}, // \xe2\x97\xaf
{0x2605,{0x04,0x64,0x3c,0x1f,0x3c,0x64,0x04}}, // \xe2\x98\x85
{0x2606,{0x04,0x64,0x3c,0x17,0x3c,0x64,0x04}}, // \xe2\x98\x86
{0x2640,{0x00,0x26,0x29,0x79,0x29,0x26,0x00}}, // \xe2\x99\x80
{0x2642,{0x30,0x48,0x48,0x39,0x05,0x03,0x0f}}, // \xe2\x99\x82
{0x266a,{0x00,0x60,0x70,0x3f,0x02,0x0c,0x00}}, // \xe2\x99\xaa
{0x266d,{0x00,0x00,0x7f,0x48,0x24,0x18,0x00}}, // \xe2\x99\xad
{0x266f,{0x00,0x28,0x7e,0x14,0x14,0x3f,0x0a}}, // \xe2\x99\xaf
{0x3000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // \xe3\x80\x80
{0x3001,{0x20,0x40,0x00,0x00,0x00,0x00,0x00}}, // \xe3\x80\x81
{0x3002,{0x20,0x50,0x20,0x00,0x00,0x00,0x00}}, // \xe3\x80\x82
{0x3003,{0x00,0x20,0x1c,0x00,0x20,0x1c,0x00}}, // \xe3\x80\x83
{0x3005,{0x10,0x08,0x16,0x24,0x54,0x0c,0x00}}, // \xe3\x80\x85
{0x3006,{0x78,0x24,0x12,0x0a,0x04,0x1a,0x01}}, // \xe3\x80\x86
{0x3007,{0x18,0x24,0x42,0x42,0x42,0x24,0x18}}, // \xe3\x80\x87
{0x3008,{0x00,0x00,0x00,0x08,0x14,0x22,0x41}}, // \xe3\x80\x88
{0x3009,{0x41,0x22,0x14,0x08,0x00,0x00,0x00}}, // \xe3\x80\x89
{0x300a,{0x00,0x08,0x14,0x2a,0x55,0x22,0x41}}, // \xe3\x80\x8a
{0x300b,{0x41,0x22,0x55,0x2a,0x14,0x08,0x00}}, // \xe3\x80\x8b
{0x300c,{0x00,0x00,0x00,0x3f,0x01,0x01,0x01}}, // \xe3\x80\x8c
{0x300d,{0x40,0x40,0x40,0x7e,0x00,0x00,0x00}}, // \xe3\x80\x8d
{0x300e,{0x00,0x00,0x3f,0x21,0x3d,0x05,0x07}}, // \xe3\x80\x8e
{0x300f,{0x70,0x50,0x5e,0x42,0x7e,0x00,0x00}}, // \xe3\x80\x8f
{0x3010,{0x00,0x00,0x00,0x00,0x7f,0x63,0x41}}, // \xe3\x80\x90
{0x3011,{0x41,0x63,0x7f,0x00,0x00,0x00,0x00}}, // \xe3\x80\x91
{0x3012,{0x05,0x05,0x05,0x7d,0x05,0x05,0x05}}, // \xe3\x80\x92
{0x3013,{0x36,0x36,0x36,0x36,0x36,0x36,0x36}}, // \xe3\x80\x93
{0x3014,{0x00,0x00,0x00,0x3e,0x22,0x41,0x41}}, // \xe3\x80\x94
{0x3015,{0x41,0x41,0x22,0x3e,0x00,0x00,0x00}}, // \xe3\x80\x95
{0x301c,{0x08,0x04,0x04,0x08,0x10,0x10,0x08}}, // \xe3\x80\x9c
{0x3041,{0x00,0x20,0x54,0x7e,0x34,0x14,0x60}}, // \xe3\x81\x81
{0x3042,{0x20,0x52,0x7f,0x2a,0x1a,0x4a,0x30}}, // \xe3\x81\x82
{0x3043,{0x00,0x3c,0x40,0x20,0x04,0x18,0x00}}, // \xe3\x81\x83
{0x3044,{0x1e,0x20,0x40,0x20,0x02,0x04,0x18}}, // \xe3\x81\x84
{0x3045,{0x00,0x10,0x4a,0x4a,0x2a,0x10,0x00}}, // \xe3\x81\x85
{0x3046,{0x00,0x08,0x45,0x45,0x45,0x25,0x18}}, // \xe3\x81\x86
{0x3047,{0x00,0x48,0x2a,0x3a,0x4a,0x40,0x00}}, // \xe3\x81\x87
{0x3048,{0x00,0x44,0x25,0x15,0x3d,0x45,0x40}}, // \xe3\x81\x88
{0x3049,{0x00,0x24,0x7e,0x14,0x50,0x24,0x00}}, // \xe3\x81\x89
{0x304a,{0x22,0x52,0x7f,0x0a,0x48,0x4a,0x34}}, // \xe3\x81\x8a
{0x304b,{0x44,0x34,0x4f,0x44,0x38,0x04,0x18}}, // \xe3\x81\x8b
{0x304c,{0x44,0x34,0x4f,0x44,0x39,0x04,0x19}}, // \xe3\x81\x8c
{0x304d,{0x00,0x2a,0x5a,0x4b,0x4e,0x5a,0x08}}, // \xe3\x81\x8d
{0x304e,{0x00,0x2a,0x5a,0x4b,0x4e,0x5b,0x08}}, // \xe3\x81\x8e
{0x304f,{0x00,0x08,0x14,0x14,0x22,0x41,0x00}}, // \xe3\x81\x8f
{0x3050,{0x00,0x08,0x14,0x14,0x22,0x45,0x04}}, // \xe3\x81\x90
{0x3051,{0x3f,0x00,0x04,0x44,0x3f,0x04,0x04}}, // \xe3\x81\x91
{0x3052,{0x3f,0x00,0x04,0x44,0x3f,0x04,0x05}}, // \xe3\x81\x92
{0x3053,{0x00,0x20,0x52,0x42,0x42,0x42,0x40}}, // \xe3\x81\x93
{0x3054,{0x00,0x20,0x52,0x42,0x43,0x42,0x41}}, // \xe3\x81\x94
{0x3055,{0x00,0x24,0x54,0x44,0x47,0x5c,0x04}}, // \xe3\x81\x95
{0x3056,{0x00,0x24,0x54,0x44,0x47,0x5c,0x05}}, // \xe3\x81\x96
{0x3057,{0x00,0x00,0x3f,0x40,0x40,0x40,0x20}}, // \xe3\x81\x97
{0x3058,{0x00,0x00,0x3f,0x40,0x41,0x40,0x21}}, // \xe3\x81\x98
{0x3059,{0x02,0x02,0x0a,0x56,0x3f,0x02,0x02}}, // \xe3\x81\x99
{0x305a,{0x02,0x02,0x0a,0x56,0x3f,0x02,0x03}}, // \xe3\x81\x9a
{0x305b,{0x04,0x04,0x3f,0x44,0x54,0x5f,0x44}}, // \xe3\x81\x9b
{0x305c,{0x04,0x04,0x3f,0x44,0x54,0x5f,0x45}}, // \xe3\x81\x9c
{0x305d,{0x00,0x08,0x09,0x3d,0x4b,0x49,0x08}}, // \xe3\x81\x9d
{0x305e,{0x00,0x08,0x09,0x3d,0x4b,0x49,0x0a}}, // \xe3\x81\x9e
{0x305f,{0x42,0x3a,0x07,0x22,0x54,0x44,0x44}}, // \xe3\x81\x9f
{0x3060,{0x42,0x3a,0x07,0x22,0x55,0x44,0x45}}, // \xe3\x81\xa0
{0x3061,{0x00,0x02,0x12,0x4e,0x4b,0x4a,0x32}}, // \xe3\x81\xa1
{0x3062,{0x00,0x02,0x12,0x4e,0x4b,0x4a,0x33}}, // \xe3\x81\xa2
{0x3063,{0x00,0x10,0x10,0x48,0x48,0x30,0x00}}, // \xe3\x81\xa3
{0x3064,{0x04,0x04,0x02,0x22,0x22,0x22,0x1c}}, // \xe3\x81\xa4
{0x3065,{0x04,0x04,0x02,0x22,0x23,0x22,0x1d}}, // \xe3\x81\xa5
{0x3066,{0x00,0x02,0x02,0x1a,0x25,0x43,0x41}}, // \xe3\x81\xa6
{0x3067,{0x00,0x02,0x02,0x1a,0x25,0x43,0x45}}, // \xe3\x81\xa7
{0x3068,{0x00,0x20,0x57,0x48,0x48,0x44,0x44}}, // \xe3\x81\xa8
{0x3069,{0x00,0x20,0x57,0x48,0x49,0x44,0x45}}, // \xe3\x81\xa9
{0x306a,{0x12,0x0a,0x27,0x52,0x50,0x3a,0x24}}, // \xe3\x81\xaa
{0x306b,{0x7f,0x00,0x20,0x52,0x42,0x42,0x40}}, // \xe3\x81\xab
{0x306c,{0x30,0x4e,0x38,0x54,0x0f,0x64,0x78}}, // \xe3\x81\xac
{0x306d,{0x24,0x14,0x7f,0x04,0x22,0x52,0x3c}}, // \xe3\x81\xad
{0x306e,{0x18,0x24,0x12,0x4e,0x42,0x24,0x18}}, // \xe3\x81\xae
{0x306f,{0x7f,0x00,0x24,0x54,0x54,0x3f,0x44}}, // \xe3\x81\xaf
{0x3070,{0x7f,0x00,0x24,0x54,0x54,0x3f,0x45}}, // \xe3\x81\xb0
{0x3071,{0x7f,0x00,0x24,0x54,0x56,0x3d,0x46}}, // \xe3\x81\xb1
{0x3072,{0x02,0x3a,0x47,0x40,0x41,0x3e,0x04}}, // \xe3\x81\xb2
{0x3073,{0x02,0x3a,0x47,0x40,0x41,0x3e,0x05}}, // \xe3\x81\xb3
{0x3074,{0x02,0x3a,0x47,0x40,0x43,0x3d,0x06}}, // \xe3\x81\xb4
{0x3075,{0x40,0x30,0x40,0x4d,0x32,0x10,0x60}}, // \xe3\x81\xb5
{0x3076,{0x40,0x30,0x40,0x4d,0x32,0x11,0x61}}, // \xe3\x81\xb6
{0x3077,{0x40,0x30,0x40,0x4d,0x32,0x15,0x62}}, // \xe3\x81\xb7
{0x3078,{0x08,0x04,0x02,0x04,0x08,0x10,0x10}}, // \xe3\x81\xb8
{0x3079,{0x08,0x04,0x02,0x04,0x09,0x10,0x11}}, // \xe3\x81\xb9
{0x307a,{0x08,0x04,0x02,0x04,0x0a,0x15,0x12}}, // \xe3\x81\xba
{0x307b,{0x7f,0x00,0x6a,0x6a,0x7e,0x2a,0x4a}}, // \xe3\x81\xbb
{0x307c,{0x7f,0x00,0x6a,0x6a,0x7f,0x2a,0x4b}}, // \xe3\x81\xbc
{0x307d,{0x7f,0x00,0x6a,0x6a,0x7e,0x2d,0x4a}}, // \xe3\x81\xbd
{0x307e,{0x00,0x6a,0x6a,0x6a,0x7f,0x2a,0x4a}}, // \xe3\x81\xbe
{0x307f,{0x30,0x29,0x1d,0x4b,0x48,0x3c,0x10}}, // \xe3\x81\xbf
{0x3080,{0x12,0x2a,0x7f,0x42,0x40,0x42,0x24}}, // \xe3\x82\x80
{0x3081,{0x30,0x4e,0x38,0x54,0x0f,0x44,0x38}}, // \xe3\x82\x81
{0x3082,{0x00,0x0a,0x3e,0x4b,0x4a,0x4a,0x30}}, // \xe3\x82\x82
{0x3083,{0x00,0x08,0x0e,0x38,0x46,0x14,0x08}}, // \xe3\x82\x83
{0x3084,{0x04,0x07,0x1c,0x62,0x03,0x0a,0x04}}, // \xe3\x82\x84
{0x3085,{0x00,0x1c,0x48,0x3e,0x24,0x18,0x00}}, // \xe3\x82\x85
{0x3086,{0x1e,0x04,0x52,0x3f,0x12,0x12,0x0c}}, // \xe3\x82\x86
{0x3087,{0x00,0x20,0x50,0x50,0x3e,0x48,0x00}}, // \xe3\x82\x87
{0x3088,{0x00,0x20,0x50,0x50,0x3f,0x24,0x44}}, // \xe3\x82\x88
{0x3089,{0x00,0x1c,0x51,0x49,0x4a,0x48,0x30}}, // \xe3\x82\x89
{0x308a,{0x00,0x0f,0x42,0x41,0x21,0x1e,0x00}}, // \xe3\x82\x8a
{0x308b,{0x00,0x10,0x69,0x6d,0x4b,0x49,0x30}}, // \xe3\x82\x8b
{0x308c,{0x24,0x14,0x7f,0x04,0x02,0x3e,0x40}}, // \xe3\x82\x8c
{0x308d,{0x00,0x10,0x49,0x4d,0x4b,0x49,0x30}}, // \xe3\x82\x8d
{0x308e,{0x00,0x28,0x18,0x7e,0x08,0x44,0x38}}, // \xe3\x82\x8e
{0x308f,{0x24,0x14,0x7f,0x04,0x42,0x42,0x3c}}, // \xe3\x82\x8f
{0x3090,{0x30,0x49,0x25,0x1f,0x24,0x54,0x38}}, // \xe3\x82\x90
{0x3091,{0x40,0x28,0x25,0x57,0x35,0x28,0x40}}, // \xe3\x82\x91
{0x3092,{0x10,0x0a,0x2e,0x5b,0x72,0x4a,0x48}}, // \xe3\x82\x92
{0x3093,{0x40,0x30,0x0c,0x33,0x40,0x40,0x20}}, // \xe3\x82\x93
{0x309b,{0x01,0x02,0x01,0x02,0x00,0x00,0x00}}, // \xe3\x82\x9b
{0x309c,{0x02,0x05,0x02,0x00,0x00,0x00,0x00}}, // \xe3\x82\x9c
{0x309d,{0x00,0x00,0x22,0x24,0x18,0x10,0x00}}, // \xe3\x82\x9d
{0x309e,{0x00,0x00,0x22,0x24,0x19,0x10,0x01}}, // \xe3\x82\x9e
{0x30a1,{0x00,0x04,0x44,0x3c,0x14,0x0c,0x00}}, // \xe3\x82\xa1
{0x30a2,{0x00,0x01,0x41,0x3d,0x09,0x05,0x03}}, // \xe3\x82\xa2
{0x30a3,{0x00,0x20,0x20,0x10,0x78,0x04,0x00}}, // \xe3\x82\xa3
{0x30a4,{0x00,0x10,0x10,0x08,0x7c,0x02,0x01}}, // \xe3\x82\xa4
{0x30a5,{0x00,0x18,0x48,0x4c,0x28,0x18,0x00}}, // \xe3\x82\xa5
{0x30a6,{0x00,0x06,0x42,0x43,0x22,0x12,0x0e}}, // \xe3\x82\xa6
{0x30a7,{0x00,0x40,0x48,0x78,0x48,0x40,0x00}}, // \xe3\x82\xa7
{0x30a8,{0x20,0x22,0x22,0x3e,0x22,0x22,0x20}}, // \xe3\x82\xa8
{0x30a9,{0x00,0x28,0x28,0x58,0x7c,0x08,0x00}}, // \xe3\x82\xa9
{0x30aa,{0x22,0x22,0x12,0x4a,0x7f,0x02,0x02}}, // \xe3\x82\xaa
{0x30ab,{0x00,0x42,0x22,0x1f,0x02,0x42,0x7e}}, // \xe3\x82\xab
{0x30ac,{0x00,0x42,0x22,0x1f,0x02,0x42,0x7f}}, // \xe3\x82\xac
{0x30ad,{0x00,0x12,0x12,0x1f,0x72,0x12,0x10}}, // \xe3\x82\xad
{0x30ae,{0x00,0x12,0x12,0x1f,0x72,0x13,0x10}}, // \xe3\x82\xae
{0x30af,{0x00,0x08,0x44,0x43,0x22,0x12,0x0e}}, // \xe3\x82\xaf
{0x30b0,{0x00,0x08,0x44,0x43,0x22,0x12,0x0f}}, // \xe3\x82\xb0
{0x30b1,{0x08,0x07,0x42,0x22,0x1e,0x02,0x02}}, // \xe3\x82\xb1
{0x30b2,{0x08,0x07,0x42,0x22,0x1f,0x02,0x03}}, // \xe3\x82\xb2
{0x30b3,{0x00,0x42,0x42,0x42,0x42,0x42,0x7e}}, // \xe3\x82\xb3
{0x30b4,{0x00,0x42,0x42,0x42,0x43,0x42,0x7f}}, // \xe3\x82\xb4
{0x30b5,{0x02,0x02,0x4f,0x42,0x22,0x1f,0x02}}, // \xe3\x82\xb5
{0x30b6,{0x02,0x02,0x4f,0x42,0x23,0x1e,0x03}}, // \xe3\x82\xb6
{0x30b7,{0x00,0x45,0x4a,0x40,0x20,0x10,0x0c}}, // \xe3\x82\xb7
{0x30b8,{0x00,0x45,0x4a,0x40,0x21,0x10,0x0d}}, // \xe3\x82\xb8
{0x30b9,{0x40,0x42,0x22,0x22,0x1a,0x26,0x40}}, // \xe3\x82\xb9
{0x30ba,{0x40,0x42,0x22,0x22,0x1b,0x26,0x41}}, // \xe3\x82\xba
{0x30bb,{0x04,0x04,0x3f,0x44,0x44,0x54,0x4c}}, // \xe3\x82\xbb
{0x30bc,{0x04,0x04,0x3f,0x44,0x45,0x54,0x4d}}, // \xe3\x82\xbc
{0x30bd,{0x00,0x01,0x46,0x40,0x20,0x10,0x0f}}, // \xe3\x82\xbd
{0x30be,{0x00,0x01,0x46,0x40,0x20,0x11,0x0f}}, // \xe3\x82\xbe
{0x30bf,{0x00,0x08,0x44,0x4b,0x2a,0x12,0x0e}}, // \xe3\x82\xbf
{0x30c0,{0x00,0x08,0x44,0x4b,0x2a,0x12,0x0f}}, // \xe3\x83\x80
{0x30c1,{0x08,0x0a,0x4a,0x3e,0x09,0x09,0x08}}, // \xe3\x83\x81
{0x30c2,{0x08,0x0a,0x4a,0x3e,0x09,0x08,0x09}}, // \xe3\x83\x82
{0x30c3,{0x00,0x18,0x40,0x58,0x20,0x18,0x00}}, // \xe3\x83\x83
{0x30c4,{0x02,0x0c,0x42,0x4c,0x20,0x10,0x0e}}, // \xe3\x83\x84
{0x30c5,{0x02,0x0c,0x42,0x4c,0x21,0x10,0x0d}}, // \xe3\x83\x85
{0x30c6,{0x04,0x05,0x45,0x3d,0x05,0x05,0x04}}, // \xe3\x83\x86
{0x30c7,{0x04,0x05,0x45,0x3d,0x05,0x04,0x05}}, // \xe3\x83\x87
{0x30c8,{0x00,0x00,0x7f,0x08,0x08,0x10,0x00}}, // \xe3\x83\x88
{0x30c9,{0x00,0x00,0x7f,0x08,0x09,0x10,0x01}}, // \xe3\x83\x89
{0x30ca,{0x04,0x44,0x24,0x1f,0x04,0x04,0x04}}, // \xe3\x83\x8a
{0x30cb,{0x20,0x22,0x22,0x22,0x22,0x22,0x20}}, // \xe3\x83\x8b
{0x30cc,{0x40,0x41,0x25,0x15,0x19,0x27,0x00}}, // \xe3\x83\x8c
{0x30cd,{0x20,0x22,0x12,0x7b,0x06,0x12,0x20}}, // \xe3\x83\x8d
{0x30ce,{0x40,0x40,0x20,0x10,0x08,0x07,0x00}}, // \xe3\x83\x8e
{0x30cf,{0x40,0x30,0x0e,0x00,0x02,0x0c,0x70}}, // \xe3\x83\x8f
{0x30d0,{0x40,0x30,0x0e,0x00,0x02,0x0d,0x71}}, // \xe3\x83\x90
{0x30d1,{0x40,0x30,0x0e,0x00,0x02,0x0d,0x72}}, // \xe3\x83\x91
{0x30d2,{0x00,0x3f,0x48,0x48,0x48,0x44,0x44}}, // \xe3\x83\x92
{0x30d3,{0x00,0x3f,0x48,0x48,0x49,0x44,0x45}}, // \xe3\x83\x93
{0x30d4,{0x00,0x3f,0x48,0x48,0x4a,0x45,0x46}}, // \xe3\x83\x94
{0x30d5,{0x00,0x02,0x42,0x42,0x22,0x12,0x0e}}, // \xe3\x83\x95
{0x30d6,{0x00,0x02,0x42,0x42,0x23,0x12,0x0f}}, // \xe3\x83\x96
{0x30d7,{0x00,0x02,0x42,0x42,0x22,0x15,0x0e}}, // \xe3\x83\x97
{0x30d8,{0x08,0x04,0x02,0x04,0x08,0x10,0x20}}, // \xe3\x83\x98
{0x30d9,{0x08,0x04,0x02,0x04,0x09,0x10,0x21}}, // \xe3\x83\x99
{0x30da,{0x08,0x04,0x02,0x04,0x0a,0x15,0x22}}, // \xe3\x83\x9a
{0x30db,{0x24,0x14,0x44,0x7f,0x04,0x14,0x24}}, // \xe3\x83\x9b
{0x30dc,{0x24,0x14,0x44,0x7f,0x05,0x14,0x25}}, // \xe3\x83\x9c
{0x30dd,{0x24,0x14,0x44,0x7f,0x06,0x15,0x22}}, // \xe3\x83\x9d
{0x30de,{0x02,0x02,0x12,0x22,0x52,0x0a,0x06}}, // \xe3\x83\x9e
{0x30df,{0x00,0x21,0x25,0x29,0x4a,0x42,0x00}}, // \xe3\x83\x9f
{0x30e0,{0x40,0x70,0x4c,0x43,0x50,0x20,0x40}}, // \xe3\x83\xa0
{0x30e1,{0x40,0x44,0x24,0x14,0x08,0x37,0x00}}, // \xe3\x83\xa1
{0x30e2,{0x00,0x08,0x09,0x3f,0x49,0x49,0x48}}, // \xe3\x83\xa2
{0x30e3,{0x00,0x10,0x1c,0x68,0x08,0x18,0x00}}, // \xe3\x83\xa3
{0x30e4,{0x04,0x04,0x0f,0x74,0x02,0x0a,0x06}}, // \xe3\x83\xa4
{0x30e5,{0x00,0x40,0x48,0x48,0x78,0x40,0x00}}, // \xe3\x83\xa5
{0x30e6,{0x20,0x22,0x22,0x22,0x3e,0x20,0x20}}, // \xe3\x83\xa6
{0x30e7,{0x00,0x00,0x44,0x54,0x54,0x7c,0x00}}, // \xe3\x83\xa7
{0x30e8,{0x00,0x42,0x4a,0x4a,0x4a,0x4a,0x7e}}, // \xe3\x83\xa8
{0x30e9,{0x00,0x04,0x45,0x45,0x25,0x15,0x0c}}, // \xe3\x83\xa9
{0x30ea,{0x00,0x0f,0x40,0x40,0x20,0x1f,0x00}}, // \xe3\x83\xaa
{0x30eb,{0x40,0x20,0x1e,0x00,0x7f,0x20,0x10}}, // \xe3\x83\xab
{0x30ec,{0x00,0x00,0x7f,0x40,0x20,0x10,0x08}}, // \xe3\x83\xac
{0x30ed,{0x00,0x7e,0x42,0x42,0x42,0x42,0x7e}}, // \xe3\x83\xad
{0x30ee,{0x00,0x0c,0x44,0x44,0x24,0x1c,0x00}}, // \xe3\x83\xae
{0x30ef,{0x00,0x06,0x42,0x42,0x22,0x12,0x0e}}, // \xe3\x83\xaf
{0x30f0,{0x10,0x12,0x1e,0x12,0x12,0x7f,0x12}}, // \xe3\x83\xb0
{0x30f1,{0x20,0x22,0x22,0x3a,0x26,0x22,0x20}}, // \xe3\x83\xb1
{0x30f2,{0x00,0x01,0x45,0x45,0x25,0x15,0x0f}}, // \xe3\x83\xb2
{0x30f3,{0x00,0x41,0x42,0x40,0x20,0x10,0x0c}}, // \xe3\x83\xb3
{0x30f4,{0x00,0x06,0x42,0x43,0x22,0x12,0x0f}}, // \xe3\x83\xb4
{0x30f5,{0x00,0x48,0x28,0x1c,0x48,0x78,0x00}}, // \xe3\x83\xb5
{0x30f6,{0x00,0x10,0x0c,0x48,0x38,0x08,0x00}}, // \xe3\x83\xb6
{0x30fb,{0x00,0x00,0x18,0x18,0x00,0x00,0x00}}, // \xe3\x83\xbb
{0x30fc,{0x04,0x08,0x08,0x08,0x08,0x08,0x08}}, // \xe3\x83\xbc
{0x30fd,{0x00,0x00,0x04,0x08,0x30,0x00,0x00}}, // \xe3\x83\xbd
{0x30fe,{0x00,0x00,0x04,0x08,0x31,0x00,0x01}}, // \xe3\x83\xbe
{0x4e00,{0x08,0x08,0x08,0x08,0x08,0x0c,0x08}}, // \xe4\xb8\x80
{0x4e01,{0x01,0x01,0x41,0x7f,0x01,0x01,0x01}}, // \xe4\xb8\x81
{0x4e03,{0x08,0x08,0x3f,0x48,0x44,0x44,0x64}}, // \xe4\xb8\x83
{0x4e07,{0x41,0x21,0x1f,0x05,0x45,0x7d,0x01}}, // \xe4\xb8\x87
{0x4e08,{0x42,0x42,0x2a,0x1f,0x22,0x42,0x42}}, // \xe4\xb8\x88
{0x4e09,{0x40,0x42,0x4a,0x4a,0x4a,0x42,0x40}}, // \xe4\xb8\x89
{0x4e0a,{0x40,0x40,0x40,0x7f,0x44,0x44,0x40}}, // \xe4\xb8\x8a
{0x4e0b,{0x01,0x01,0x01,0x7f,0x05,0x09,0x01}}, // \xe4\xb8\x8b
{0x4e0d,{0x11,0x11,0x09,0x7f,0x01,0x09,0x11}}, // \xe4\xb8\x8d
{0x4e0e,{0x10,0x10,0x1f,0x5a,0x7a,0x12,0x10}}, // \xe4\xb8\x8e
{0x4e10,{0x01,0x1d,0x11,0x1f,0x15,0x55,0x71}}, // \xe4\xb8\x90
{0x4e11,{0x48,0x49,0x79,0x4f,0x49,0x7f,0x48}}, // \xe4\xb8\x91
{0x4e14,{0x40,0x7f,0x55,0x55,0x55,0x7f,0x40}}, // \xe4\xb8\x94
{0x4e15,{0x49,0x49,0x45,0x7f,0x41,0x45,0x49}}, // \xe4\xb8\x95
{0x4e16,{0x04,0x7f,0x44,0x5f,0x54,0x5f,0x44}}, // \xe4\xb8\x96
{0x4e17,{0x04,0x7f,0x44,0x7f,0x44,0x7f,0x04}}, // \xe4\xb8\x97
{0x4e18,{0x40,0x7e,0x4a,0x4a,0x79,0x49,0x40}}, // \xe4\xb8\x98
{0x4e19,{0x7d,0x25,0x15,0x0f,0x15,0x45,0x7d}}, // \xe4\xb8\x99
{0x4e1e,{0x54,0x4d,0x61,0x7d,0x43,0x49,0x54}}, // \xe4\xb8\x9e
{0x4e21,{0x7d,0x35,0x25,0x3f,0x25,0x35,0x7d}}, // \xe4\xb8\xa1
{0x4e26,{0x42,0x5a,0x7f,0x42,0x7e,0x53,0x4a}}, // \xe4\xb8\xa6
{0x4e2a,{0x04,0x04,0x02,0x7d,0x02,0x04,0x04}}, // \xe4\xb8\xaa
{0x4e2d,{0x1e,0x12,0x12,0x7f,0x12,0x12,0x1e}}, // \xe4\xb8\xad
{0x4e31,{0x1e,0x50,0x3f,0x00,0x7f,0x10,0x1e}}, // \xe4\xb8\xb1
{0x4e32,{0x30,0x36,0x36,0x7f,0x36,0x36,0x30}}, // \xe4\xb8\xb2
{0x4e36,{0x00,0x00,0x02,0x04,0x18,0x00,0x00}}, // \xe4\xb8\xb6
{0x4e38,{0x42,0x2a,0x1f,0x12,0x7e,0x40,0x60}}, // \xe4\xb8\xb8
{0x4e39,{0x50,0x3f,0x11,0x15,0x51,0x7f,0x10}}, // \xe4\xb8\xb9
{0x4e3b,{0x44,0x54,0x55,0x7e,0x54,0x54,0x44}}, // \xe4\xb8\xbb
{0x4e3c,{0x12,0x52,0x3f,0x16,0x12,0x7f,0x12}}, // \xe4\xb8\xbc
{0x4e3f,{0x00,0x40,0x40,0x20,0x1f,0x00,0x00}}, // \xe4\xb8\xbf
{0x4e42,{0x40,0x43,0x2c,0x10,0x2c,0x43,0x40}}, // \xe4\xb9\x82
{0x4e43,{0x41,0x31,0x0f,0x01,0x07,0x44,0x7c}}, // \xe4\xb9\x83
{0x4e45,{0x48,0x44,0x23,0x22,0x1a,0x26,0x40}}, // \xe4\xb9\x85
{0x4e4b,{0x40,0x32,0x22,0x53,0x4a,0x46,0x40}}, // \xe4\xb9\x8b
{0x4e4d,{0x08,0x04,0x03,0x7e,0x2a,0x2a,0x2a}}, // \xe4\xb9\x8d
{0x4e4e,{0x12,0x16,0x52,0x7e,0x11,0x15,0x11}}, // \xe4\xb9\x8e
{0x4e4f,{0x40,0x35,0x25,0x57,0x4d,0x45,0x40}}, // \xe4\xb9\x8f
{0x4e55,{0x40,0x3e,0x6e,0x2e,0x7e,0x2d,0x6d}}, // \xe4\xb9\x95
{0x4e56,{0x2c,0x3e,0x06,0x7e,0x05,0x3d,0x2c}}, // \xe4\xb9\x96
{0x4e57,{0x54,0x5e,0x36,0x7e,0x35,0x5d,0x54}}, // \xe4\xb9\x97
{0x4e58,{0x54,0x5e,0x26,0x7e,0x25,0x5d,0x54}}, // \xe4\xb9\x98
{0x4e59,{0x20,0x51,0x49,0x45,0x43,0x40,0x60}}, // \xe4\xb9\x99
{0x4e5d,{0x42,0x32,0x0f,0x02,0x7e,0x40,0x60}}, // \xe4\xb9\x9d
{0x4e5e,{0x04,0x23,0x56,0x56,0x4e,0x42,0x62}}, // \xe4\xb9\x9e
{0x4e5f,{0x08,0x08,0x3e,0x44,0x5f,0x44,0x6c}}, // \xe4\xb9\x9f
{0x4e62,{0x38,0x20,0x3f,0x20,0x7f,0x40,0x60}}, // \xe4\xb9\xa2
{0x4e71,{0x04,0x76,0x5e,0x75,0x7f,0x40,0x60}}, // \xe4\xb9\xb1
{0x4e73,{0x22,0x2a,0x69,0x3b,0x21,0x7f,0x40}}, // \xe4\xb9\xb3
{0x4e7e,{0x2d,0x77,0x2d,0x23,0x56,0x4e,0x62}}, // \xe4\xb9\xbe
{0x4e80,{0x32,0x2e,0x2d,0x3d,0x6f,0x7c,0x40}}, // \xe4\xba\x80
{0x4e82,{0x72,0x55,0x37,0x7d,0x02,0x7f,0x40}}, // \xe4\xba\x82
{0x4e85,{0x00,0x00,0x40,0x7f,0x00,0x00,0x00}}, // \xe4\xba\x85
{0x4e86,{0x01,0x01,0x41,0x7d,0x05,0x03,0x01}}, // \xe4\xba\x86
{0x4e88,{0x08,0x09,0x4b,0x7d,0x0b,0x09,0x18}}, // \xe4\xba\x88
{0x4e89,{0x0a,0x2a,0x6d,0x7d,0x2f,0x3c,0x08}}, // \xe4\xba\x89
{0x4e8a,{0x12,0x16,0x5a,0x7f,0x3a,0x3e,0x12}}, // \xe4\xba\x8a
{0x4e8b,{0x2a,0x2e,0x6a,0x7f,0x2a,0x3e,0x12}}, // \xe4\xba\x8b
{0x4e8c,{0x40,0x42,0x42,0x42,0x42,0x42,0x40}}, // \xe4\xba\x8c
{0x4e8e,{0x08,0x09,0x49,0x7f,0x09,0x09,0x08}}, // \xe4\xba\x8e
{0x4e91,{0x44,0x45,0x65,0x5d,0x45,0x25,0x44}}, // \xe4\xba\x91
{0x4e92,{0x41,0x51,0x5f,0x55,0x75,0x4d,0x41}}, // \xe4\xba\x92
{0x4e94,{0x40,0x49,0x79,0x4f,0x49,0x79,0x40}}, // \xe4\xba\x94
{0x4e95,{0x12,0x52,0x3f,0x12,0x12,0x7f,0x12}}, // \xe4\xba\x95
{0x4e98,{0x41,0x7f,0x6b,0x6b,0x6b,0x7f,0x41}}, // \xe4\xba\x98
{0x4e99,{0x41,0x51,0x4f,0x55,0x6d,0x5d,0x41}}, // \xe4\xba\x99
{0x4e9b,{0x4e,0x58,0x5f,0x5a,0x50,0x5f,0x4a}}, // \xe4\xba\x9b
{0x4e9c,{0x5d,0x55,0x7f,0x55,0x7f,0x55,0x5d}}, // \xe4\xba\x9c
{0x4e9e,{0x5d,0x55,0x77,0x41,0x77,0x55,0x5d}}, // \xe4\xba\x9e
{0x4e9f,{0x59,0x59,0x67,0x7d,0x6d,0x55,0x6d}}, // \xe4\xba\x9f
{0x4ea0,{0x08,0x08,0x08,0x0e,0x08,0x08,0x08}}, // \xe4\xba\xa0
{0x4ea1,{0x02,0x3e,0x42,0x43,0x42,0x42,0x42}}, // \xe4\xba\xa1
{0x4ea2,{0x42,0x42,0x3a,0x0b,0x7a,0x42,0x62}}, // \xe4\xba\xa2
{0x4ea4,{0x4a,0x4a,0x56,0x23,0x56,0x4a,0x4a}}, // \xe4\xba\xa4
{0x4ea5,{0x42,0x4a,0x56,0x2b,0x12,0x2a,0x42}}, // \xe4\xba\xa5
{0x4ea6,{0x22,0x5a,0x3e,0x43,0x7e,0x0a,0x32}}, // \xe4\xba\xa6
{0x4ea8,{0x02,0x0e,0x4a,0x6b,0x1a,0x0e,0x02}}, // \xe4\xba\xa8
{0x4eab,{0x22,0x2e,0x2a,0x6b,0x3a,0x2e,0x22}}, // \xe4\xba\xab
{0x4eac,{0x42,0x2e,0x4a,0x7b,0x0a,0x2e,0x42}}, // \xe4\xba\xac
{0x4ead,{0x1a,0x0e,0x5a,0x7b,0x1a,0x0e,0x1a}}, // \xe4\xba\xad
{0x4eae,{0x5a,0x4e,0x2a,0x0b,0x6a,0x4e,0x5a}}, // \xe4\xba\xae
{0x4eb0,{0x42,0x3e,0x5a,0x7b,0x1a,0x3e,0x42}}, // \xe4\xba\xb0
{0x4eb3,{0x1a,0x2e,0x2a,0x7b,0x5a,0x4e,0x5a}}, // \xe4\xba\xb3
{0x4eb6,{0x42,0x4e,0x7e,0x5b,0x7e,0x4e,0x42}}, // \xe4\xba\xb6
{0x4eba,{0x40,0x20,0x18,0x07,0x18,0x20,0x40}}, // \xe4\xba\xba
{0x4ec0,{0x04,0x7e,0x05,0x04,0x7f,0x04,0x04}}, // \xe4\xbb\x80
{0x4ec1,{0x04,0x7e,0x01,0x40,0x42,0x42,0x42}}, // \xe4\xbb\x81
{0x4ec2,{0x04,0x7e,0x01,0x42,0x3f,0x42,0x7e}}, // \xe4\xbb\x82
{0x4ec4,{0x40,0x3f,0x41,0x21,0x1f,0x21,0x41}}, // \xe4\xbb\x84
{0x4ec6,{0x04,0x7e,0x01,0x00,0x7f,0x08,0x10}}, // \xe4\xbb\x86
{0x4ec7,{0x04,0x7e,0x43,0x3e,0x03,0x7e,0x40}}, // \xe4\xbb\x87
{0x4eca,{0x04,0x14,0x52,0x55,0x36,0x14,0x04}}, // \xe4\xbb\x8a
{0x4ecb,{0x04,0x44,0x3a,0x01,0x7a,0x04,0x04}}, // \xe4\xbb\x8b
{0x4ecd,{0x04,0x7e,0x41,0x3f,0x01,0x47,0x7c}}, // \xe4\xbb\x8d
{0x4ece,{0x40,0x30,0x0f,0x50,0x20,0x1f,0x60}}, // \xe4\xbb\x8e
{0x4ecf,{0x04,0x7e,0x41,0x70,0x4f,0x20,0x40}}, // \xe4\xbb\x8f
{0x4ed4,{0x04,0x7e,0x09,0x49,0x7d,0x0b,0x08}}, // \xe4\xbb\x94
{0x4ed5,{0x04,0x7e,0x05,0x44,0x7f,0x44,0x04}}, // \xe4\xbb\x95
{0x4ed6,{0x04,0x7e,0x09,0x7e,0x44,0x5f,0x6c}}, // \xe4\xbb\x96
{0x4ed7,{0x04,0x7e,0x43,0x2a,0x1f,0x22,0x42}}, // \xe4\xbb\x97
{0x4ed8,{0x04,0x7e,0x01,0x0a,0x52,0x7f,0x02}}, // \xe4\xbb\x98
{0x4ed9,{0x04,0x7e,0x7d,0x40,0x7f,0x40,0x7c}}, // \xe4\xbb\x99
{0x4edd,{0x44,0x4c,0x4a,0x79,0x4a,0x4c,0x44}}, // \xe4\xbb\x9d
{0x4ede,{0x04,0x7e,0x11,0x4d,0x3f,0x41,0x7f}}, // \xe4\xbb\x9e
{0x4edf,{0x04,0x7e,0x09,0x0a,0x7e,0x09,0x08}}, // \xe4\xbb\x9f
{0x4ee3,{0x04,0x7e,0x01,0x04,0x0f,0x34,0x45}}, // \xe4\xbb\xa3
{0x4ee4,{0x14,0x14,0x12,0x75,0x16,0x14,0x34}}, // \xe4\xbb\xa4
{0x4ee5,{0x20,0x1f,0x50,0x42,0x24,0x3f,0x40}}, // \xe4\xbb\xa5
{0x4eed,{0x04,0x7e,0x01,0x45,0x3f,0x51,0x7f}}, // \xe4\xbb\xad
{0x4eee,{0x04,0x7e,0x21,0x5f,0x5d,0x25,0x5d}}, // \xe4\xbb\xae
{0x4ef0,{0x0c,0x7f,0x3e,0x11,0x7e,0x02,0x1e}}, // \xe4\xbb\xb0
{0x4ef2,{0x04,0x7e,0x1f,0x12,0x7f,0x12,0x1e}}, // \xe4\xbb\xb2
{0x4ef6,{0x04,0x7e,0x01,0x14,0x13,0x7f,0x12}}, // \xe4\xbb\xb6
{0x4ef7,{0x04,0x7e,0x45,0x3a,0x01,0x7a,0x04}}, // \xe4\xbb\xb7
{0x4efb,{0x04,0x7e,0x09,0x4a,0x7e,0x49,0x08}}, // \xe4\xbb\xbb
{0x4f01,{0x44,0x74,0x42,0x7d,0x52,0x54,0x44}}, // \xe4\xbc\x81
{0x4f09,{0x04,0x7e,0x43,0x3a,0x0b,0x7a,0x42}}, // \xe4\xbc\x89
{0x4f0a,{0x04,0x7e,0x05,0x55,0x3f,0x15,0x1f}}, // \xe4\xbc\x8a
{0x4f0d,{0x04,0x7e,0x49,0x79,0x4f,0x79,0x40}}, // \xe4\xbc\x8d
{0x4f0e,{0x04,0x7e,0x4b,0x5a,0x2f,0x5a,0x42}}, // \xe4\xbc\x8e
{0x4f0f,{0x04,0x7e,0x45,0x24,0x1f,0x24,0x45}}, // \xe4\xbc\x8f
{0x4f10,{0x04,0x7e,0x01,0x44,0x5f,0x24,0x55}}, // \xe4\xbc\x90
{0x4f11,{0x04,0x7e,0x23,0x1a,0x7f,0x1a,0x22}}, // \xe4\xbc\x91
{0x4f1a,{0x54,0x54,0x72,0x55,0x56,0x34,0x54}}, // \xe4\xbc\x9a
{0x4f1c,{0x04,0x7e,0x2b,0x26,0x73,0x2e,0x28}}, // \xe4\xbc\x9c
{0x4f1d,{0x04,0x7e,0x45,0x65,0x5d,0x25,0x44}}, // \xe4\xbc\x9d
{0x4f2f,{0x04,0x7e,0x01,0x7e,0x4b,0x4a,0x7e}}, // \xe4\xbc\xaf
{0x4f30,{0x04,0x7e,0x05,0x74,0x5f,0x74,0x04}}, // \xe4\xbc\xb0
{0x4f34,{0x04,0x7e,0x01,0x2a,0x28,0x7f,0x2a}}, // \xe4\xbc\xb4
{0x4f36,{0x04,0x7e,0x15,0x12,0x75,0x16,0x34}}, // \xe4\xbc\xb6
{0x4f38,{0x04,0x7e,0x3f,0x2a,0x7f,0x2a,0x3e}}, // \xe4\xbc\xb8
{0x4f3a,{0x04,0x7e,0x01,0x35,0x35,0x41,0x7f}}, // \xe4\xbc\xba
{0x4f3c,{0x04,0x7e,0x11,0x5f,0x48,0x22,0x5f}}, // \xe4\xbc\xbc
{0x4f3d,{0x0c,0x7f,0x62,0x1f,0x7e,0x42,0x7e}}, // \xe4\xbc\xbd
{0x4f43,{0x04,0x7e,0x7f,0x49,0x7f,0x49,0x7f}}, // \xe4\xbd\x83
{0x4f46,{0x04,0x7e,0x01,0x5f,0x55,0x55,0x5f}}, // \xe4\xbd\x86
{0x4f47,{0x04,0x7e,0x01,0x06,0x4a,0x7b,0x0e}}, // \xe4\xbd\x87
{0x4f4d,{0x04,0x7e,0x43,0x7e,0x63,0x5e,0x42}}, // \xe4\xbd\x8d
{0x4f4e,{0x04,0x7e,0x01,0x7e,0x4a,0x5e,0x69}}, // \xe4\xbd\x8e
{0x4f4f,{0x04,0x7e,0x01,0x44,0x55,0x7e,0x54}}, // \xe4\xbd\x8f
{0x4f50,{0x04,0x7e,0x23,0x5e,0x4b,0x7a,0x4a}}, // \xe4\xbd\x90
{0x4f51,{0x04,0x7e,0x01,0x12,0x7f,0x4a,0x7a}}, // \xe4\xbd\x91
{0x4f53,{0x04,0x7e,0x13,0x2a,0x7f,0x2a,0x12}}, // \xe4\xbd\x93
{0x4f55,{0x04,0x7e,0x01,0x1d,0x15,0x5d,0x7f}}, // \xe4\xbd\x95
{0x4f57,{0x04,0x7e,0x07,0x7a,0x53,0x4a,0x66}}, // \xe4\xbd\x97
{0x4f59,{0x54,0x34,0x56,0x7d,0x16,0x34,0x54}}, // \xe4\xbd\x99
{0x4f5a,{0x04,0x7e,0x01,0x4c,0x4b,0x3f,0x4a}}, // \xe4\xbd\x9a
{0x4f5b,{0x0c,0x7f,0x5a,0x3f,0x16,0x7f,0x36}}, // \xe4\xbd\x9b
{0x4f5c,{0x04,0x7e,0x01,0x04,0x7f,0x2a,0x2a}}, // \xe4\xbd\x9c
{0x4f5d,{0x04,0x7e,0x01,0x04,0x1b,0x5a,0x7e}}, // \xe4\xbd\x9d
{0x4f5e,{0x04,0x7e,0x01,0x54,0x7d,0x35,0x54}}, // \xe4\xbd\x9e
{0x4f69,{0x04,0x7e,0x7f,0x35,0x7d,0x35,0x7f}}, // \xe4\xbd\xa9
{0x4f6f,{0x04,0x7e,0x01,0x22,0x2b,0x7e,0x2b}}, // \xe4\xbd\xaf
{0x4f70,{0x04,0x7e,0x01,0x7d,0x57,0x55,0x7d}}, // \xe4\xbd\xb0
{0x4f73,{0x04,0x7e,0x49,0x5a,0x7f,0x5a,0x48}}, // \xe4\xbd\xb3
{0x4f75,{0x04,0x7e,0x55,0x3d,0x14,0x7d,0x14}}, // \xe4\xbd\xb5
{0x4f76,{0x04,0x7e,0x03,0x6a,0x6f,0x6a,0x02}}, // \xe4\xbd\xb6
{0x4f7b,{0x0c,0x7f,0x4a,0x3f,0x00,0x7f,0x4a}}, // \xe4\xbd\xbb
{0x4f7c,{0x04,0x7e,0x4b,0x56,0x23,0x56,0x4a}}, // \xe4\xbd\xbc
{0x4f7f,{0x04,0x7e,0x53,0x5e,0x3f,0x4a,0x4e}}, // \xe4\xbd\xbf
{0x4f83,{0x04,0x7e,0x41,0x37,0x75,0x05,0x77}}, // \xe4\xbe\x83
{0x4f86,{0x52,0x4e,0x32,0x7f,0x32,0x4e,0x52}}, // \xe4\xbe\x86
{0x4f88,{0x04,0x7e,0x09,0x4a,0x55,0x2b,0x18}}, // \xe4\xbe\x88
{0x4f8b,{0x04,0x7e,0x49,0x37,0x1d,0x4e,0x7f}}, // \xe4\xbe\x8b
{0x4f8d,{0x04,0x7e,0x29,0x6a,0x2f,0x7a,0x28}}, // \xe4\xbe\x8d
{0x4f8f,{0x04,0x7e,0x4d,0x2b,0x7f,0x2a,0x48}}, // \xe4\xbe\x8f
{0x4f91,{0x04,0x7e,0x01,0x12,0x7f,0x2a,0x7a}}, // \xe4\xbe\x91
{0x4f96,{0x74,0x34,0x72,0x35,0x76,0x34,0x74}}, // \xe4\xbe\x96
{0x4f98,{0x04,0x7e,0x17,0x1a,0x7b,0x56,0x56}}, // \xe4\xbe\x98
{0x4f9b,{0x0c,0x7f,0x52,0x1f,0x12,0x1f,0x52}}, // \xe4\xbe\x9b
{0x4f9d,{0x04,0x7e,0x13,0x7a,0x4f,0x32,0x4a}}, // \xe4\xbe\x9d
{0x4fa0,{0x04,0x7e,0x5b,0x52,0x3f,0x52,0x5a}}, // \xe4\xbe\xa0
{0x4fa1,{0x04,0x7e,0x01,0x7d,0x7f,0x45,0x7d}}, // \xe4\xbe\xa1
{0x4fab,{0x04,0x7e,0x53,0x7e,0x5b,0x3a,0x52}}, // \xe4\xbe\xab
{0x4fad,{0x04,0x7e,0x11,0x0f,0x55,0x4d,0x13}}, // \xe4\xbe\xad
{0x4fae,{0x04,0x7e,0x09,0x3b,0x2e,0x7e,0x2a}}, // \xe4\xbe\xae
{0x4faf,{0x04,0x7e,0x01,0x54,0x5d,0x37,0x54}}, // \xe4\xbe\xaf
{0x4fb5,{0x04,0x7e,0x59,0x5d,0x2d,0x5f,0x58}}, // \xe4\xbe\xb5
{0x4fb6,{0x04,0x7e,0x01,0x77,0x5d,0x55,0x77}}, // \xe4\xbe\xb6
{0x4fbf,{0x04,0x7e,0x41,0x57,0x3f,0x47,0x41}}, // \xe4\xbe\xbf
{0x4fc2,{0x04,0x7e,0x51,0x15,0x7b,0x11,0x59}}, // \xe4\xbf\x82
{0x4fc3,{0x04,0x7e,0x41,0x37,0x45,0x7d,0x57}}, // \xe4\xbf\x83
{0x4fc4,{0x0c,0x7f,0x26,0x7e,0x25,0x3f,0x55}}, // \xe4\xbf\x84
{0x4fca,{0x04,0x7e,0x2b,0x57,0x32,0x5e,0x4b}}, // \xe4\xbf\x8a
{0x4fce,{0x44,0x33,0x44,0x7f,0x55,0x7f,0x40}}, // \xe4\xbf\x8e
{0x4fd0,{0x04,0x7e,0x35,0x7f,0x15,0x4e,0x7f}}, // \xe4\xbf\x90
{0x4fd1,{0x04,0x7e,0x7d,0x15,0x7d,0x17,0x7d}}, // \xe4\xbf\x91
{0x4fd4,{0x04,0x7e,0x01,0x5f,0x35,0x75,0x5f}}, // \xe4\xbf\x94
{0x4fd7,{0x0c,0x7f,0x12,0x69,0x64,0x69,0x12}}, // \xe4\xbf\x97
{0x4fd8,{0x04,0x7e,0x23,0x29,0x6b,0x39,0x22}}, // \xe4\xbf\x98
{0x4fda,{0x04,0x7e,0x5f,0x55,0x7f,0x55,0x5f}}, // \xe4\xbf\x9a
{0x4fdb,{0x04,0x7e,0x5d,0x36,0x1d,0x77,0x5c}}, // \xe4\xbf\x9b
{0x4fdd,{0x04,0x7e,0x51,0x37,0x7d,0x37,0x50}}, // \xe4\xbf\x9d
{0x4fdf,{0x04,0x7e,0x01,0x56,0x5d,0x34,0x56}}, // \xe4\xbf\x9f
{0x4fe1,{0x04,0x7e,0x01,0x62,0x6b,0x6b,0x62}}, // \xe4\xbf\xa1
{0x4fe3,{0x04,0x7e,0x45,0x57,0x3d,0x57,0x44}}, // \xe4\xbf\xa3
{0x4fe4,{0x0c,0x7f,0x5a,0x2b,0x7e,0x2b,0x6e}}, // \xe4\xbf\xa4
{0x4fe5,{0x04,0x7e,0x23,0x3e,0x7f,0x3e,0x22}}, // \xe4\xbf\xa5
{0x4fee,{0x04,0x7e,0x3f,0x04,0x4b,0x56,0x2a}}, // \xe4\xbf\xae
{0x4fef,{0x04,0x7e,0x3f,0x72,0x0b,0x52,0x7a}}, // \xe4\xbf\xaf
{0x4ff3,{0x0c,0x7f,0x2a,0x7f,0x00,0x7f,0x2a}}, // \xe4\xbf\xb3
{0x4ff5,{0x04,0x7e,0x2b,0x7a,0x5f,0x2a,0x52}}, // \xe4\xbf\xb5
{0x4ff6,{0x04,0x7e,0x29,0x7f,0x4a,0x31,0x4f}}, // \xe4\xbf\xb6
{0x4ff8,{0x04,0x7e,0x15,0x2e,0x77,0x2e,0x14}}, // \xe4\xbf\xb8
{0x4ffa,{0x04,0x7e,0x0b,0x36,0x3b,0x76,0x4a}}, // \xe4\xbf\xba
{0x4ffe,{0x04,0x7e,0x2f,0x3a,0x2f,0x7a,0x2e}}, // \xe4\xbf\xbe
{0x5005,{0x04,0x7e,0x33,0x2e,0x73,0x2e,0x32}}, // \xe5\x80\x85
{0x5006,{0x04,0x7e,0x7d,0x35,0x7f,0x35,0x7d}}, // \xe5\x80\x86
{0x5009,{0x44,0x24,0x1e,0x6d,0x6e,0x64,0x04}}, // \xe5\x80\x89
{0x500b,{0x04,0x7e,0x7f,0x75,0x6f,0x75,0x7f}}, // \xe5\x80\x8b
{0x500d,{0x04,0x7e,0x0b,0x6e,0x6b,0x6e,0x0a}}, // \xe5\x80\x8d
{0x500f,{0x04,0x7e,0x5f,0x5a,0x35,0x5b,0x50}}, // \xe5\x80\x8f
{0x5011,{0x04,0x7e,0x7f,0x07,0x00,0x47,0x7f}}, // \xe5\x80\x91
{0x5012,{0x04,0x7e,0x2d,0x3b,0x29,0x4e,0x7f}}, // \xe5\x80\x92
{0x5014,{0x04,0x7e,0x3f,0x65,0x4d,0x7d,0x6f}}, // \xe5\x80\x94
{0x5016,{0x04,0x7e,0x15,0x3e,0x77,0x3e,0x14}}, // \xe5\x80\x96
{0x5019,{0x04,0x7e,0x3f,0x54,0x5d,0x37,0x54}}, // \xe5\x80\x99
{0x501a,{0x04,0x7e,0x13,0x5a,0x17,0x7a,0x12}}, // \xe5\x80\x9a
{0x501f,{0x0c,0x7f,0x0a,0x7f,0x5a,0x7f,0x0a}}, // \xe5\x80\x9f
{0x5021,{0x04,0x7e,0x01,0x7c,0x57,0x57,0x7c}}, // \xe5\x80\xa1
{0x5023,{0x0c,0x7f,0x62,0x1f,0x7a,0x3f,0x5e}}, // \xe5\x80\xa3
{0x5024,{0x04,0x7e,0x01,0x7a,0x42,0x5f,0x5a}}, // \xe5\x80\xa4
{0x5025,{0x04,0x7e,0x47,0x56,0x73,0x56,0x46}}, // \xe5\x80\xa5
{0x5026,{0x04,0x7e,0x15,0x6e,0x57,0x4e,0x15}}, // \xe5\x80\xa6
{0x5028,{0x04,0x7e,0x21,0x1f,0x6b,0x5f,0x6b}}, // \xe5\x80\xa8
{0x5029,{0x04,0x7e,0x09,0x7a,0x3f,0x7a,0x08}}, // \xe5\x80\xa9
{0x502a,{0x04,0x7e,0x5f,0x35,0x10,0x75,0x5f}}, // \xe5\x80\xaa
{0x502b,{0x04,0x7e,0x75,0x32,0x75,0x36,0x74}}, // \xe5\x80\xab
{0x502c,{0x04,0x7e,0x21,0x3c,0x77,0x3e,0x22}}, // \xe5\x80\xac
{0x502d,{0x0c,0x7f,0x5a,0x77,0x5f,0x37,0x5a}}, // \xe5\x80\xad
{0x5036,{0x04,0x7e,0x51,0x1f,0x15,0x1f,0x50}}, // \xe5\x80\xb6
{0x5039,{0x04,0x7e,0x5d,0x56,0x3d,0x56,0x5c}}, // \xe5\x80\xb9
{0x5043,{0x04,0x7e,0x7f,0x49,0x6f,0x57,0x69}}, // \xe5\x81\x83
{0x5047,{0x04,0x7e,0x7f,0x2b,0x58,0x2d,0x5f}}, // \xe5\x81\x87
{0x5048,{0x04,0x7e,0x11,0x3f,0x2d,0x4f,0x78}}, // \xe5\x81\x88
{0x5049,{0x04,0x7e,0x29,0x3a,0x2f,0x7a,0x2e}}, // \xe5\x81\x89
{0x504f,{0x04,0x7e,0x21,0x1f,0x75,0x37,0x71}}, // \xe5\x81\x8f
{0x5050,{0x04,0x7e,0x21,0x1a,0x4e,0x5f,0x2a}}, // \xe5\x81\x90
{0x5055,{0x04,0x7e,0x0f,0x6a,0x70,0x6f,0x0a}}, // \xe5\x81\x95
{0x5056,{0x04,0x7e,0x29,0x1a,0x6f,0x7a,0x69}}, // \xe5\x81\x96
{0x505a,{0x0c,0x7f,0x3a,0x2f,0x7a,0x3f,0x5e}}, // \xe5\x81\x9a
{0x505c,{0x04,0x7e,0x0b,0x5e,0x7b,0x1e,0x1a}}, // \xe5\x81\x9c
{0x5065,{0x04,0x7e,0x55,0x3b,0x56,0x7f,0x56}}, // \xe5\x81\xa5
{0x506c,{0x04,0x7e,0x65,0x2b,0x4e,0x52,0x6e}}, // \xe5\x81\xac
{0x5072,{0x04,0x7e,0x61,0x2f,0x4f,0x4d,0x6f}}, // \xe5\x81\xb2
{0x5074,{0x04,0x7e,0x5f,0x15,0x5f,0x0e,0x7f}}, // \xe5\x81\xb4
{0x5075,{0x04,0x7e,0x41,0x3c,0x37,0x3e,0x42}}, // \xe5\x81\xb5
{0x5076,{0x04,0x7e,0x79,0x4b,0x7f,0x2b,0x78}}, // \xe5\x81\xb6
{0x5078,{0x04,0x7e,0x05,0x73,0x75,0x26,0x54}}, // \xe5\x81\xb8
{0x507d,{0x0c,0x7f,0x52,0x1b,0x56,0x1f,0x70}}, // \xe5\x81\xbd
{0x5080,{0x04,0x7e,0x5f,0x2a,0x7f,0x6a,0x5e}}, // \xe5\x82\x80
{0x5085,{0x04,0x7e,0x13,0x3e,0x57,0x7e,0x13}}, // \xe5\x82\x85
{0x508d,{0x04,0x7e,0x1b,0x4e,0x3b,0x6e,0x1a}}, // \xe5\x82\x8d
{0x5091,{0x0c,0x7f,0x5a,0x35,0x7b,0x36,0x5f}}, // \xe5\x82\x91
{0x5098,{0x24,0x34,0x2a,0x7d,0x2a,0x34,0x24}}, // \xe5\x82\x98
{0x5099,{0x0c,0x7f,0x1a,0x6f,0x2a,0x6f,0x6a}}, // \xe5\x82\x99
{0x509a,{0x0c,0x7f,0x56,0x23,0x56,0x3f,0x5e}}, // \xe5\x82\x9a
{0x50ac,{0x04,0x7e,0x13,0x7e,0x4b,0x7e,0x4b}}, // \xe5\x82\xac
{0x50ad,{0x04,0x7e,0x3f,0x7a,0x2e,0x7f,0x7a}}, // \xe5\x82\xad
{0x50b2,{0x0c,0x7f,0x4a,0x3f,0x6a,0x3f,0x5e}}, // \xe5\x82\xb2
{0x50b3,{0x04,0x7e,0x13,0x3e,0x5f,0x76,0x1a}}, // \xe5\x82\xb3
{0x50b4,{0x04,0x7e,0x7f,0x71,0x47,0x77,0x71}}, // \xe5\x82\xb4
{0x50b5,{0x04,0x7e,0x49,0x3a,0x3f,0x3a,0x48}}, // \xe5\x82\xb5
{0x50b7,{0x04,0x7e,0x25,0x5f,0x3a,0x5e,0x72}}, // \xe5\x82\xb7
{0x50be,{0x04,0x7e,0x3f,0x24,0x5d,0x17,0x5d}}, // \xe5\x82\xbe
{0x50c2,{0x04,0x7e,0x55,0x7e,0x5b,0x3e,0x54}}, // \xe5\x83\x82
{0x50c5,{0x0c,0x7f,0x5a,0x5f,0x7a,0x5f,0x5a}}, // \xe5\x83\x85
{0x50c9,{0x5c,0x34,0x5e,0x05,0x5e,0x34,0x5c}}, // \xe5\x83\x89
{0x50ca,{0x04,0x7e,0x15,0x6f,0x57,0x4f,0x15}}, // \xe5\x83\x8a
{0x50cd,{0x04,0x7e,0x2d,0x3f,0x62,0x1f,0x7e}}, // \xe5\x83\x8d
{0x50cf,{0x04,0x7e,0x23,0x5e,0x7d,0x2f,0x50}}, // \xe5\x83\x8f
{0x50d1,{0x0c,0x7f,0x7a,0x17,0x5b,0x17,0x7a}}, // \xe5\x83\x91
{0x50d5,{0x04,0x7e,0x4b,0x5e,0x3b,0x5e,0x4b}}, // \xe5\x83\x95
{0x50d6,{0x04,0x7e,0x13,0x7e,0x57,0x7e,0x12}}, // \xe5\x83\x96
{0x50da,{0x04,0x7e,0x4b,0x1e,0x6b,0x1e,0x4a}}, // \xe5\x83\x9a
{0x50de,{0x04,0x7e,0x53,0x1d,0x57,0x1d,0x72}}, // \xe5\x83\x9e
{0x50e3,{0x0c,0x7f,0x0a,0x77,0x5a,0x77,0x0a}}, // \xe5\x83\xa3
{0x50e5,{0x04,0x7e,0x5d,0x3e,0x17,0x7e,0x5c}}, // \xe5\x83\xa5
{0x50e7,{0x0c,0x7f,0x0e,0x7b,0x5e,0x7b,0x0e}}, // \xe5\x83\xa7
{0x50ed,{0x0c,0x7f,0x14,0x6f,0x76,0x6f,0x16}}, // \xe5\x83\xad
{0x50ee,{0x04,0x7e,0x4b,0x5e,0x7b,0x5e,0x4a}}, // \xe5\x83\xae
{0x50f5,{0x04,0x7e,0x01,0x49,0x7f,0x7f,0x49}}, // \xe5\x83\xb5
{0x50f9,{0x04,0x7e,0x41,0x3b,0x3b,0x3b,0x41}}, // \xe5\x83\xb9
{0x50fb,{0x04,0x7e,0x3f,0x36,0x2e,0x7b,0x2e}}, // \xe5\x83\xbb
{0x5100,{0x0c,0x7f,0x2a,0x7b,0x2e,0x3b,0x5a}}, // \xe5\x84\x80
{0x5101,{0x0c,0x7f,0x74,0x1f,0x2a,0x1f,0x7a}}, // \xe5\x84\x81
{0x5102,{0x04,0x7e,0x21,0x76,0x57,0x36,0x57}}, // \xe5\x84\x82
{0x5104,{0x04,0x7e,0x6b,0x3e,0x5b,0x5e,0x6a}}, // \xe5\x84\x84
{0x5109,{0x04,0x7e,0x5d,0x36,0x5d,0x36,0x5c}}, // \xe5\x84\x89
{0x5112,{0x0c,0x7f,0x66,0x2b,0x7f,0x2b,0x66}}, // \xe5\x84\x92
{0x5114,{0x04,0x7e,0x35,0x36,0x5f,0x76,0x14}}, // \xe5\x84\x94
{0x5115,{0x04,0x7e,0x4b,0x36,0x2b,0x76,0x0a}}, // \xe5\x84\x95
{0x5116,{0x04,0x7e,0x4f,0x69,0x60,0x6b,0x4a}}, // \xe5\x84\x96
{0x5118,{0x04,0x7e,0x51,0x6a,0x7f,0x6e,0x54}}, // \xe5\x84\x98
{0x511a,{0x0c,0x7f,0x1a,0x4f,0x5e,0x3f,0x1a}}, // \xe5\x84\x9a
{0x511f,{0x04,0x7e,0x45,0x3e,0x3b,0x3e,0x45}}, // \xe5\x84\x9f
{0x5121,{0x04,0x7e,0x71,0x77,0x07,0x77,0x70}}, // \xe5\x84\xa1
{0x512a,{0x04,0x7e,0x59,0x5f,0x2f,0x5f,0x59}}, // \xe5\x84\xaa
{0x5132,{0x04,0x7e,0x6b,0x62,0x1a,0x6f,0x6a}}, // \xe5\x84\xb2
{0x5137,{0x04,0x7e,0x7f,0x55,0x1e,0x7d,0x57}}, // \xe5\x84\xb7
{0x513a,{0x04,0x7e,0x5b,0x3e,0x5b,0x7e,0x55}}, // \xe5\x84\xba
{0x513b,{0x04,0x7e,0x57,0x1a,0x5f,0x1a,0x57}}, // \xe5\x84\xbb
{0x513c,{0x04,0x7e,0x7f,0x3f,0x7a,0x2f,0x5b}}, // \xe5\x84\xbc
{0x513f,{0x40,0x20,0x1f,0x00,0x7f,0x40,0x60}}, // \xe5\x84\xbf
{0x5140,{0x41,0x21,0x1f,0x01,0x7f,0x41,0x61}}, // \xe5\x85\x80
{0x5141,{0x44,0x24,0x1e,0x05,0x7c,0x42,0x64}}, // \xe5\x85\x81
{0x5143,{0x44,0x25,0x1d,0x05,0x7d,0x45,0x64}}, // \xe5\x85\x83
{0x5144,{0x40,0x4f,0x39,0x09,0x79,0x4f,0x60}}, // \xe5\x85\x84
{0x5145,{0x42,0x4a,0x3e,0x0b,0x76,0x4a,0x62}}, // \xe5\x85\x85
{0x5146,{0x52,0x48,0x3f,0x00,0x7f,0x4c,0x52}}, // \xe5\x85\x86
{0x5147,{0x40,0x5f,0x35,0x12,0x75,0x5f,0x60}}, // \xe5\x85\x87
{0x5148,{0x4c,0x4b,0x3a,0x0f,0x7a,0x4a,0x68}}, // \xe5\x85\x88
{0x5149,{0x48,0x4a,0x38,0x0f,0x78,0x4a,0x68}}, // \xe5\x85\x89
{0x514b,{0x42,0x5e,0x36,0x17,0x76,0x5e,0x62}}, // \xe5\x85\x8b
{0x514c,{0x44,0x5e,0x35,0x14,0x75,0x5e,0x64}}, // \xe5\x85\x8c
{0x514d,{0x42,0x5e,0x35,0x1d,0x77,0x5c,0x60}}, // \xe5\x85\x8d
{0x514e,{0x42,0x5e,0x36,0x1e,0x75,0x5d,0x60}}, // \xe5\x85\x8e
{0x5150,{0x40,0x5f,0x20,0x1f,0x75,0x5f,0x60}}, // \xe5\x85\x90
{0x5152,{0x40,0x5e,0x35,0x10,0x75,0x5f,0x60}}, // \xe5\x85\x92
{0x5154,{0x42,0x5e,0x35,0x7d,0x57,0x74,0x5c}}, // \xe5\x85\x94
{0x515a,{0x46,0x43,0x3e,0x17,0x7e,0x43,0x66}}, // \xe5\x85\x9a
{0x515c,{0x5e,0x51,0x3e,0x15,0x7e,0x51,0x5f}}, // \xe5\x85\x9c
{0x5162,{0x42,0x3a,0x77,0x5a,0x3a,0x77,0x5a}}, // \xe5\x85\xa2
{0x5165,{0x40,0x21,0x19,0x07,0x18,0x20,0x40}}, // \xe5\x85\xa5
{0x5168,{0x44,0x54,0x56,0x7d,0x56,0x54,0x44}}, // \xe5\x85\xa8
{0x5169,{0x7d,0x1d,0x25,0x7f,0x1d,0x25,0x7d}}, // \xe5\x85\xa9
{0x516a,{0x74,0x35,0x73,0x25,0x56,0x24,0x54}}, // \xe5\x85\xaa
{0x516b,{0x40,0x30,0x0f,0x00,0x0f,0x30,0x40}}, // \xe5\x85\xab
{0x516c,{0x48,0x44,0x63,0x58,0x43,0x24,0x48}}, // \xe5\x85\xac
{0x516d,{0x42,0x22,0x1a,0x03,0x1a,0x22,0x42}}, // \xe5\x85\xad
{0x516e,{0x04,0x06,0x1d,0x54,0x55,0x72,0x04}}, // \xe5\x85\xae
{0x5171,{0x50,0x52,0x1f,0x12,0x1f,0x52,0x50}}, // \xe5\x85\xb1
{0x5175,{0x50,0x5e,0x16,0x16,0x1d,0x55,0x50}}, // \xe5\x85\xb5
{0x5176,{0x52,0x52,0x1f,0x1a,0x1f,0x52,0x52}}, // \xe5\x85\xb6
{0x5177,{0x50,0x5f,0x15,0x15,0x15,0x5f,0x50}}, // \xe5\x85\xb7
{0x5178,{0x50,0x5e,0x1f,0x1a,0x1f,0x5e,0x50}}, // \xe5\x85\xb8
{0x517c,{0x52,0x36,0x7f,0x16,0x7e,0x2b,0x4a}}, // \xe5\x85\xbc
{0x5180,{0x2a,0x6a,0x3f,0x38,0x3f,0x6a,0x2a}}, // \xe5\x86\x80
{0x5182,{0x7f,0x01,0x01,0x01,0x01,0x41,0x7f}}, // \xe5\x86\x82
{0x5185,{0x7e,0x12,0x0a,0x07,0x0a,0x52,0x7e}}, // \xe5\x86\x85
{0x5186,{0x7f,0x09,0x09,0x0f,0x09,0x49,0x7f}}, // \xe5\x86\x86
{0x5189,{0x20,0x7e,0x2a,0x3f,0x2a,0x7e,0x20}}, // \xe5\x86\x89
{0x518a,{0x08,0x7f,0x3f,0x09,0x3f,0x09,0x7f}}, // \xe5\x86\x8a
{0x518c,{0x48,0x3f,0x49,0x7f,0x3f,0x49,0x7f}}, // \xe5\x86\x8c
{0x518d,{0x11,0x7f,0x15,0x1f,0x55,0x7f,0x11}}, // \xe5\x86\x8d
{0x518f,{0x7f,0x05,0x3b,0x29,0x3f,0x45,0x7f}}, // \xe5\x86\x8f
{0x5190,{0x07,0x79,0x2d,0x2d,0x2d,0x79,0x07}}, // \xe5\x86\x90
{0x5191,{0x0e,0x7a,0x0a,0x2f,0x2a,0x7a,0x0e}}, // \xe5\x86\x91
{0x5192,{0x07,0x7d,0x55,0x55,0x55,0x7d,0x07}}, // \xe5\x86\x92
{0x5193,{0x2a,0x7a,0x2f,0x3a,0x2f,0x7a,0x2a}}, // \xe5\x86\x93
{0x5195,{0x48,0x5b,0x35,0x1d,0x75,0x5f,0x60}}, // \xe5\x86\x95
{0x5196,{0x0c,0x04,0x04,0x04,0x04,0x04,0x0c}}, // \xe5\x86\x96
{0x5197,{0x43,0x21,0x1d,0x05,0x7d,0x41,0x63}}, // \xe5\x86\x97
{0x5199,{0x13,0x11,0x1f,0x55,0x75,0x15,0x13}}, // \xe5\x86\x99
{0x51a0,{0x53,0x35,0x75,0x51,0x69,0x7d,0x4b}}, // \xe5\x86\xa0
{0x51a2,{0x2b,0x29,0x57,0x4f,0x3b,0x11,0x2b}}, // \xe5\x86\xa2
{0x51a4,{0x4b,0x59,0x37,0x1f,0x77,0x5d,0x63}}, // \xe5\x86\xa4
{0x51a5,{0x53,0x51,0x1f,0x1b,0x1f,0x51,0x53}}, // \xe5\x86\xa5
{0x51a6,{0x53,0x35,0x75,0x41,0x6d,0x57,0x6b}}, // \xe5\x86\xa6
{0x51a8,{0x03,0x71,0x5f,0x7b,0x5f,0x71,0x03}}, // \xe5\x86\xa8
{0x51a9,{0x23,0x5d,0x1b,0x59,0x1f,0x51,0x73}}, // \xe5\x86\xa9
{0x51aa,{0x53,0x35,0x7f,0x7d,0x3f,0x75,0x33}}, // \xe5\x86\xaa
{0x51ab,{0x00,0x00,0x61,0x12,0x08,0x00,0x00}}, // \xe5\x86\xab
{0x51ac,{0x10,0x12,0x2a,0x35,0x4b,0x50,0x10}}, // \xe5\x86\xac
{0x51b0,{0x71,0x00,0x14,0x4c,0x7f,0x14,0x22}}, // \xe5\x86\xb0
{0x51b1,{0x71,0x00,0x41,0x59,0x57,0x75,0x4d}}, // \xe5\x86\xb1
{0x51b2,{0x71,0x00,0x1e,0x12,0x7f,0x12,0x1e}}, // \xe5\x86\xb2
{0x51b3,{0x71,0x00,0x48,0x4a,0x3f,0x4e,0x48}}, // \xe5\x86\xb3
{0x51b4,{0x71,0x00,0x28,0x2f,0x59,0x7f,0x09}}, // \xe5\x86\xb4
{0x51b5,{0x71,0x00,0x4f,0x39,0x09,0x79,0x4f}}, // \xe5\x86\xb5
{0x51b6,{0x71,0x00,0x08,0x6c,0x6b,0x64,0x08}}, // \xe5\x86\xb6
{0x51b7,{0x71,0x00,0x14,0x12,0x75,0x16,0x34}}, // \xe5\x86\xb7
{0x51bd,{0x71,0x00,0x49,0x37,0x1d,0x4e,0x7f}}, // \xe5\x86\xbd
{0x51c4,{0x71,0x00,0x52,0x7a,0x5f,0x3e,0x52}}, // \xe5\x87\x84
{0x51c5,{0x71,0x00,0x7f,0x75,0x6f,0x75,0x7f}}, // \xe5\x87\x85
{0x51c6,{0x71,0x00,0x04,0x7f,0x4a,0x7f,0x4a}}, // \xe5\x87\x86
{0x51c9,{0x71,0x00,0x22,0x4e,0x7b,0x0e,0x22}}, // \xe5\x87\x89
{0x51cb,{0x71,0x00,0x7f,0x35,0x2f,0x35,0x7f}}, // \xe5\x87\x8b
{0x51cc,{0x71,0x40,0x28,0x5a,0x2f,0x5a,0x48}}, // \xe5\x87\x8c
{0x51cd,{0x71,0x00,0x42,0x2e,0x7f,0x2e,0x42}}, // \xe5\x87\x8d
{0x51d6,{0x29,0x20,0x24,0x7f,0x2a,0x2f,0x2a}}, // \xe5\x87\x96
{0x51db,{0x71,0x00,0x52,0x1e,0x7b,0x1e,0x52}}, // \xe5\x87\x9b
{0x51dc,{0x71,0x00,0x52,0x3e,0x7b,0x3e,0x52}}, // \xe5\x87\x9c
{0x51dd,{0x71,0x00,0x57,0x3a,0x5a,0x3d,0x57}}, // \xe5\x87\x9d
{0x51e0,{0x40,0x3f,0x01,0x01,0x01,0x7f,0x40}}, // \xe5\x87\xa0
{0x51e1,{0x40,0x3f,0x05,0x19,0x01,0x7f,0x40}}, // \xe5\x87\xa1
{0x51e6,{0x48,0x2f,0x12,0x2e,0x42,0x5e,0x50}}, // \xe5\x87\xa6
{0x51e7,{0x40,0x3f,0x19,0x7d,0x19,0x7f,0x40}}, // \xe5\x87\xa7
{0x51e9,{0x40,0x3f,0x29,0x7d,0x29,0x7f,0x40}}, // \xe5\x87\xa9
{0x51ea,{0x40,0x3f,0x31,0x3d,0x29,0x7f,0x40}}, // \xe5\x87\xaa
{0x51ed,{0x44,0x4e,0x35,0x16,0x7e,0x55,0x44}}, // \xe5\x87\xad
{0x51f0,{0x40,0x3f,0x5d,0x77,0x5d,0x7f,0x40}}, // \xe5\x87\xb0
{0x51f1,{0x4b,0x5a,0x6b,0x5a,0x3f,0x01,0x7f}}, // \xe5\x87\xb1
{0x51f5,{0x7f,0x40,0x40,0x40,0x40,0x40,0x7f}}, // \xe5\x87\xb5
{0x51f6,{0x7f,0x60,0x54,0x48,0x56,0x40,0x7f}}, // \xe5\x87\xb6
{0x51f8,{0x78,0x48,0x4f,0x41,0x4f,0x48,0x78}}, // \xe5\x87\xb8
{0x51f9,{0x7f,0x41,0x4f,0x48,0x4f,0x41,0x7f}}, // \xe5\x87\xb9
{0x51fa,{0x70,0x4e,0x48,0x7f,0x48,0x4e,0x70}}, // \xe5\x87\xba
{0x51fd,{0x7d,0x69,0x57,0x7d,0x51,0x69,0x7d}}, // \xe5\x87\xbd
{0x51fe,{0x7c,0x79,0x69,0x7d,0x57,0x69,0x7c}}, // \xe5\x87\xbe
{0x5200,{0x41,0x21,0x19,0x07,0x01,0x41,0x7f}}, // \xe5\x88\x80
{0x5203,{0x41,0x25,0x15,0x0f,0x11,0x41,0x7f}}, // \xe5\x88\x83
{0x5204,{0x41,0x25,0x19,0x0f,0x11,0x51,0x7f}}, // \xe5\x88\x84
{0x5206,{0x48,0x44,0x2b,0x18,0x4b,0x7c,0x08}}, // \xe5\x88\x86
{0x5207,{0x04,0x3f,0x24,0x41,0x3f,0x41,0x7f}}, // \xe5\x88\x87
{0x5208,{0x40,0x24,0x18,0x27,0x0e,0x40,0x7f}}, // \xe5\x88\x88
{0x520a,{0x08,0x09,0x7f,0x09,0x0e,0x40,0x7f}}, // \xe5\x88\x8a
{0x520b,{0x0a,0x4a,0x3e,0x09,0x0e,0x40,0x7f}}, // \xe5\x88\x8b
{0x520e,{0x24,0x53,0x2e,0x5e,0x7e,0x00,0x7f}}, // \xe5\x88\x8e
{0x5211,{0x49,0x3f,0x09,0x7f,0x09,0x4e,0x7f}}, // \xe5\x88\x91
{0x5214,{0x48,0x2a,0x1f,0x2e,0x0e,0x40,0x7f}}, // \xe5\x88\x94
{0x5217,{0x49,0x37,0x1d,0x01,0x0e,0x40,0x7f}}, // \xe5\x88\x97
{0x521d,{0x12,0x7b,0x36,0x41,0x3f,0x41,0x7f}}, // \xe5\x88\x9d
{0x5224,{0x2a,0x28,0x7f,0x28,0x2a,0x40,0x7f}}, // \xe5\x88\xa4
{0x5225,{0x47,0x3d,0x55,0x77,0x0e,0x40,0x7f}}, // \xe5\x88\xa5
{0x5227,{0x6a,0x5f,0x2a,0x41,0x3f,0x41,0x7f}}, // \xe5\x88\xa7
{0x5229,{0x24,0x15,0x7f,0x15,0x0e,0x40,0x7f}}, // \xe5\x88\xa9
{0x522a,{0x08,0x7f,0x3f,0x09,0x7f,0x0e,0x7f}}, // \xe5\x88\xaa
{0x522e,{0x04,0x76,0x5e,0x75,0x0e,0x40,0x7f}}, // \xe5\x88\xae
{0x5230,{0x49,0x5d,0x3b,0x2d,0x0e,0x40,0x7f}}, // \xe5\x88\xb0
{0x5233,{0x0a,0x16,0x1b,0x56,0x6a,0x00,0x7f}}, // \xe5\x88\xb3
{0x5236,{0x64,0x2b,0x7f,0x2a,0x6e,0x00,0x7f}}, // \xe5\x88\xb6
{0x5237,{0x40,0x3f,0x15,0x7d,0x37,0x40,0x7f}}, // \xe5\x88\xb7
{0x5238,{0x14,0x4d,0x56,0x37,0x56,0x7d,0x14}}, // \xe5\x88\xb8
{0x5239,{0x54,0x35,0x7a,0x35,0x5e,0x00,0x7f}}, // \xe5\x88\xb9
{0x523a,{0x5a,0x2a,0x7f,0x2a,0x5a,0x00,0x7f}}, // \xe5\x88\xba
{0x523b,{0x4a,0x56,0x2b,0x52,0x0e,0x40,0x7f}}, // \xe5\x88\xbb
{0x5243,{0x5a,0x2b,0x7e,0x2b,0x6e,0x00,0x7f}}, // \xe5\x89\x83
{0x5244,{0x55,0x5b,0x75,0x5b,0x51,0x0e,0x7f}}, // \xe5\x89\x84
{0x5247,{0x5f,0x15,0x5f,0x00,0x0e,0x40,0x7f}}, // \xe5\x89\x87
{0x524a,{0x7d,0x14,0x57,0x7d,0x0e,0x40,0x7f}}, // \xe5\x89\x8a
{0x524b,{0x5a,0x37,0x5a,0x40,0x4e,0x60,0x7f}}, // \xe5\x89\x8b
{0x524c,{0x42,0x2e,0x7f,0x2a,0x4e,0x00,0x7f}}, // \xe5\x89\x8c
{0x524d,{0x7a,0x2a,0x7b,0x02,0x1a,0x43,0x7a}}, // \xe5\x89\x8d
{0x524f,{0x55,0x3e,0x7d,0x45,0x3f,0x51,0x7f}}, // \xe5\x89\x8f
{0x5254,{0x27,0x5d,0x35,0x77,0x0e,0x40,0x7f}}, // \xe5\x89\x94
{0x5256,{0x0a,0x6e,0x6b,0x6e,0x0e,0x40,0x7f}}, // \xe5\x89\x96
{0x525b,{0x7f,0x35,0x29,0x35,0x7f,0x0e,0x7f}}, // \xe5\x89\x9b
{0x525e,{0x12,0x5a,0x17,0x7a,0x1e,0x40,0x7f}}, // \xe5\x89\x9e
{0x5263,{0x5c,0x56,0x3d,0x56,0x5c,0x0e,0x7f}}, // \xe5\x89\xa3
{0x5264,{0x52,0x36,0x2b,0x76,0x1e,0x40,0x7f}}, // \xe5\x89\xa4
{0x5265,{0x54,0x25,0x7f,0x24,0x5e,0x00,0x7f}}, // \xe5\x89\xa5
{0x5269,{0x4a,0x2f,0x73,0x2f,0x4a,0x00,0x7f}}, // \xe5\x89\xa9
{0x526a,{0x52,0x5e,0x37,0x1e,0x12,0x5f,0x72}}, // \xe5\x89\xaa
{0x526f,{0x71,0x57,0x75,0x57,0x71,0x0e,0x7f}}, // \xe5\x89\xaf
{0x5270,{0x54,0x3e,0x76,0x3d,0x54,0x0e,0x7f}}, // \xe5\x89\xb0
{0x5271,{0x5c,0x56,0x3d,0x5e,0x65,0x1f,0x7f}}, // \xe5\x89\xb1
{0x5272,{0x26,0x6a,0x7f,0x6a,0x2e,0x40,0x7f}}, // \xe5\x89\xb2
{0x5273,{0x12,0x7b,0x56,0x7b,0x1e,0x40,0x7f}}, // \xe5\x89\xb3
{0x5274,{0x4b,0x5a,0x6b,0x3a,0x2f,0x40,0x7f}}, // \xe5\x89\xb4
{0x5275,{0x44,0x3e,0x6d,0x62,0x0e,0x40,0x7f}}, // \xe5\x89\xb5
{0x527d,{0x51,0x17,0x77,0x17,0x51,0x0e,0x7f}}, // \xe5\x89\xbd
{0x527f,{0x52,0x3d,0x7e,0x3d,0x5e,0x00,0x7f}}, // \xe5\x89\xbf
{0x5283,{0x4a,0x7a,0x7f,0x3e,0x24,0x40,0x7f}}, // \xe5\x8a\x83
{0x5287,{0x7c,0x2c,0x57,0x7a,0x2e,0x40,0x7f}}, // \xe5\x8a\x87
{0x5288,{0x54,0x5f,0x3b,0x10,0x16,0x5b,0x76}}, // \xe5\x8a\x88
{0x5289,{0x56,0x6d,0x74,0x6b,0x57,0x00,0x7f}}, // \xe5\x8a\x89
{0x528d,{0x5c,0x36,0x5d,0x36,0x5e,0x00,0x7f}}, // \xe5\x8a\x8d
{0x5291,{0x4a,0x36,0x2b,0x76,0x0e,0x40,0x7f}}, // \xe5\x8a\x91
{0x5292,{0x5c,0x36,0x5d,0x3e,0x69,0x1f,0x7f}}, // \xe5\x8a\x92
{0x5294,{0x5c,0x36,0x5d,0x3e,0x65,0x1f,0x7f}}, // \xe5\x8a\x94
{0x529b,{0x42,0x22,0x1a,0x07,0x02,0x42,0x7e}}, // \xe5\x8a\x9b
{0x529f,{0x22,0x3e,0x12,0x42,0x3f,0x42,0x7e}}, // \xe5\x8a\x9f
{0x52a0,{0x42,0x3f,0x42,0x7e,0x7e,0x42,0x7e}}, // \xe5\x8a\xa0
{0x52a3,{0x54,0x52,0x38,0x1f,0x14,0x52,0x74}}, // \xe5\x8a\xa3
{0x52a9,{0x40,0x7f,0x55,0x3f,0x62,0x1f,0x7e}}, // \xe5\x8a\xa9
{0x52aa,{0x12,0x4e,0x5b,0x36,0x5b,0x75,0x0b}}, // \xe5\x8a\xaa
{0x52ab,{0x48,0x6a,0x5f,0x6a,0x3f,0x42,0x7e}}, // \xe5\x8a\xab
{0x52ac,{0x04,0x1b,0x5a,0x7e,0x62,0x1f,0x7e}}, // \xe5\x8a\xac
{0x52ad,{0x75,0x53,0x77,0x42,0x3f,0x42,0x7e}}, // \xe5\x8a\xad
{0x52b1,{0x7f,0x65,0x1d,0x75,0x62,0x1f,0x7e}}, // \xe5\x8a\xb1
{0x52b4,{0x46,0x4b,0x2a,0x1f,0x4a,0x7b,0x06}}, // \xe5\x8a\xb4
{0x52b5,{0x12,0x55,0x4c,0x37,0x5c,0x75,0x12}}, // \xe5\x8a\xb5
{0x52b9,{0x4a,0x56,0x23,0x56,0x3f,0x42,0x7e}}, // \xe5\x8a\xb9
{0x52bc,{0x6a,0x6f,0x6a,0x42,0x3f,0x42,0x7e}}, // \xe5\x8a\xbc
{0x52be,{0x4a,0x56,0x2b,0x52,0x3f,0x42,0x7e}}, // \xe5\x8a\xbe
{0x52c1,{0x55,0x5b,0x75,0x5b,0x62,0x1f,0x7e}}, // \xe5\x8b\x81
{0x52c3,{0x2c,0x66,0x77,0x2c,0x62,0x1f,0x7e}}, // \xe5\x8b\x83
{0x52c5,{0x42,0x2e,0x7f,0x2a,0x6e,0x1f,0x7e}}, // \xe5\x8b\x85
{0x52c7,{0x50,0x5d,0x35,0x1d,0x17,0x5d,0x70}}, // \xe5\x8b\x87
{0x52c9,{0x42,0x2d,0x7f,0x4c,0x72,0x4f,0x7e}}, // \xe5\x8b\x89
{0x52cd,{0x22,0x4e,0x7b,0x0e,0x62,0x1f,0x7e}}, // \xe5\x8b\x8d
{0x52d2,{0x37,0x7e,0x37,0x42,0x3f,0x42,0x7e}}, // \xe5\x8b\x92
{0x52d5,{0x5d,0x7f,0x5d,0x42,0x3f,0x42,0x7e}}, // \xe5\x8b\x95
{0x52d7,{0x40,0x7f,0x57,0x3f,0x4b,0x3f,0x78}}, // \xe5\x8b\x97
{0x52d8,{0x72,0x5f,0x72,0x5f,0x62,0x1f,0x7e}}, // \xe5\x8b\x98
{0x52d9,{0x29,0x5d,0x7b,0x54,0x3b,0x56,0x7a}}, // \xe5\x8b\x99
{0x52dd,{0x7f,0x15,0x7f,0x55,0x3c,0x5f,0x75}}, // \xe5\x8b\x9d
{0x52de,{0x4d,0x56,0x35,0x1c,0x55,0x76,0x0d}}, // \xe5\x8b\x9e
{0x52df,{0x2a,0x5a,0x3f,0x5e,0x7f,0x1a,0x2a}}, // \xe5\x8b\x9f
{0x52e0,{0x11,0x4b,0x55,0x2b,0x62,0x1f,0x7e}}, // \xe5\x8b\xa0
{0x52e2,{0x14,0x4e,0x5f,0x3a,0x57,0x7e,0x08}}, // \xe5\x8b\xa2
{0x52e3,{0x4a,0x3a,0x3f,0x4a,0x3f,0x42,0x7e}}, // \xe5\x8b\xa3
{0x52e4,{0x5a,0x5f,0x7a,0x5f,0x62,0x1f,0x7e}}, // \xe5\x8b\xa4
{0x52e6,{0x52,0x3d,0x7e,0x3d,0x62,0x1f,0x7e}}, // \xe5\x8b\xa6
{0x52e7,{0x14,0x7b,0x7e,0x4a,0x3f,0x42,0x7e}}, // \xe5\x8b\xa7
{0x52f2,{0x52,0x1f,0x5f,0x12,0x4f,0x12,0x5e}}, // \xe5\x8b\xb2
{0x52f3,{0x52,0x1f,0x5f,0x12,0x62,0x1f,0x7e}}, // \xe5\x8b\xb3
{0x52f5,{0x7f,0x6d,0x3f,0x6d,0x62,0x1f,0x7e}}, // \xe5\x8b\xb5
{0x52f8,{0x26,0x7f,0x7a,0x57,0x66,0x1f,0x7e}}, // \xe5\x8b\xb8
{0x52f9,{0x08,0x04,0x03,0x02,0x02,0x42,0x7e}}, // \xe5\x8b\xb9
{0x52fa,{0x08,0x04,0x0b,0x12,0x02,0x42,0x7e}}, // \xe5\x8b\xba
{0x52fe,{0x08,0x24,0x33,0x2e,0x12,0x22,0x7e}}, // \xe5\x8b\xbe
{0x52ff,{0x24,0x13,0x4e,0x22,0x1e,0x42,0x7e}}, // \xe5\x8b\xbf
{0x5301,{0x48,0x44,0x2b,0x1e,0x12,0x52,0x7e}}, // \xe5\x8c\x81
{0x5302,{0x08,0x04,0x3f,0x2a,0x2a,0x42,0x7e}}, // \xe5\x8c\x82
{0x5305,{0x04,0x73,0x56,0x56,0x5e,0x42,0x5e}}, // \xe5\x8c\x85
{0x5306,{0x24,0x13,0x4e,0x2a,0x1e,0x52,0x7e}}, // \xe5\x8c\x86
{0x5308,{0x04,0x3b,0x36,0x2a,0x36,0x42,0x7e}}, // \xe5\x8c\x88
{0x530d,{0x04,0x6b,0x2a,0x7e,0x6a,0x02,0x7e}}, // \xe5\x8c\x8d
{0x530f,{0x0a,0x1e,0x57,0x6a,0x04,0x7b,0x5e}}, // \xe5\x8c\x8f
{0x5310,{0x04,0x6b,0x7a,0x7a,0x6a,0x02,0x7e}}, // \xe5\x8c\x90
{0x5315,{0x08,0x3f,0x48,0x44,0x44,0x42,0x60}}, // \xe5\x8c\x95
{0x5316,{0x04,0x7e,0x01,0x7f,0x48,0x48,0x64}}, // \xe5\x8c\x96
{0x5317,{0x24,0x14,0x7f,0x00,0x7f,0x48,0x64}}, // \xe5\x8c\x97
{0x5319,{0x44,0x37,0x3f,0x54,0x7f,0x64,0x72}}, // \xe5\x8c\x99
{0x531a,{0x7f,0x41,0x41,0x41,0x41,0x41,0x41}}, // \xe5\x8c\x9a
{0x531d,{0x7f,0x41,0x5d,0x45,0x7f,0x45,0x5d}}, // \xe5\x8c\x9d
{0x5320,{0x7f,0x61,0x5d,0x4d,0x7b,0x4b,0x49}}, // \xe5\x8c\xa0
{0x5321,{0x7f,0x41,0x63,0x6b,0x7f,0x6b,0x41}}, // \xe5\x8c\xa1
{0x5323,{0x7f,0x41,0x5f,0x55,0x7f,0x55,0x5f}}, // \xe5\x8c\xa3
{0x532a,{0x7f,0x55,0x75,0x5f,0x41,0x7f,0x55}}, // \xe5\x8c\xaa
{0x532f,{0x7f,0x6b,0x45,0x7f,0x55,0x7f,0x55}}, // \xe5\x8c\xaf
{0x5331,{0x7f,0x41,0x65,0x5f,0x5f,0x65,0x41}}, // \xe5\x8c\xb1
{0x5333,{0x7f,0x41,0x69,0x5d,0x6f,0x5d,0x69}}, // \xe5\x8c\xb3
{0x5338,{0x01,0x3f,0x41,0x41,0x41,0x41,0x41}}, // \xe5\x8c\xb8
{0x5339,{0x7f,0x51,0x4f,0x41,0x5f,0x51,0x59}}, // \xe5\x8c\xb9
{0x533a,{0x7f,0x41,0x65,0x55,0x49,0x57,0x41}}, // \xe5\x8c\xba
{0x533b,{0x7f,0x41,0x69,0x6f,0x5d,0x6d,0x69}}, // \xe5\x8c\xbb
{0x533f,{0x7f,0x55,0x4f,0x7d,0x57,0x75,0x45}}, // \xe5\x8c\xbf
{0x5340,{0x7f,0x41,0x71,0x77,0x45,0x77,0x71}}, // \xe5\x8d\x80
{0x5341,{0x04,0x04,0x04,0x7f,0x04,0x04,0x04}}, // \xe5\x8d\x81
{0x5343,{0x08,0x0a,0x0a,0x7e,0x09,0x09,0x08}}, // \xe5\x8d\x83
{0x5345,{0x48,0x3f,0x08,0x7f,0x08,0x7f,0x08}}, // \xe5\x8d\x85
{0x5346,{0x28,0x2a,0x27,0x72,0x2e,0x28,0x2c}}, // \xe5\x8d\x86
{0x5347,{0x0a,0x4a,0x3e,0x09,0x08,0x7f,0x08}}, // \xe5\x8d\x87
{0x5348,{0x14,0x13,0x12,0x7e,0x12,0x12,0x10}}, // \xe5\x8d\x88
{0x5349,{0x50,0x3a,0x12,0x17,0x12,0x7a,0x10}}, // \xe5\x8d\x89
{0x534a,{0x20,0x2a,0x28,0x7f,0x28,0x2a,0x20}}, // \xe5\x8d\x8a
{0x534d,{0x79,0x09,0x09,0x7f,0x48,0x48,0x4f}}, // \xe5\x8d\x8d
{0x5351,{0x20,0x2e,0x3a,0x2f,0x7a,0x2e,0x20}}, // \xe5\x8d\x91
{0x5352,{0x32,0x2e,0x32,0x63,0x32,0x2e,0x32}}, // \xe5\x8d\x92
{0x5353,{0x20,0x3c,0x34,0x77,0x36,0x3e,0x22}}, // \xe5\x8d\x93
{0x5354,{0x04,0x7f,0x24,0x62,0x37,0x62,0x76}}, // \xe5\x8d\x94
{0x5357,{0x7a,0x2a,0x3a,0x6f,0x3a,0x2a,0x7a}}, // \xe5\x8d\x97
{0x5358,{0x20,0x3f,0x2a,0x7f,0x2a,0x3f,0x20}}, // \xe5\x8d\x98
{0x535a,{0x04,0x7f,0x12,0x3e,0x5f,0x7e,0x13}}, // \xe5\x8d\x9a
{0x535c,{0x00,0x00,0x7f,0x04,0x08,0x10,0x00}}, // \xe5\x8d\x9c
{0x535e,{0x02,0x02,0x02,0x7f,0x0a,0x12,0x02}}, // \xe5\x8d\x9e
{0x5360,{0x00,0x70,0x50,0x5f,0x54,0x54,0x74}}, // \xe5\x8d\xa0
{0x5366,{0x48,0x5a,0x3f,0x2a,0x7f,0x08,0x10}}, // \xe5\x8d\xa6
{0x5369,{0x00,0x00,0x7f,0x01,0x11,0x1f,0x00}}, // \xe5\x8d\xa9
{0x536e,{0x40,0x3e,0x06,0x7e,0x4d,0x5d,0x64}}, // \xe5\x8d\xae
{0x536f,{0x1e,0x52,0x3d,0x00,0x7f,0x01,0x1f}}, // \xe5\x8d\xaf
{0x5370,{0x3e,0x2a,0x29,0x00,0x7f,0x01,0x1f}}, // \xe5\x8d\xb0
{0x5371,{0x42,0x3e,0x05,0x7d,0x4f,0x5c,0x64}}, // \xe5\x8d\xb1
{0x5373,{0x7f,0x55,0x5f,0x20,0x7f,0x01,0x1f}}, // \xe5\x8d\xb3
{0x5374,{0x48,0x6a,0x5f,0x2a,0x7f,0x01,0x1f}}, // \xe5\x8d\xb4
{0x5375,{0x1e,0x56,0x3d,0x00,0x7f,0x05,0x1f}}, // \xe5\x8d\xb5
{0x5377,{0x2a,0x19,0x7c,0x4b,0x5c,0x19,0x2a}}, // \xe5\x8d\xb7
{0x5378,{0x6c,0x4b,0x3e,0x2a,0x7f,0x01,0x1f}}, // \xe5\x8d\xb8
{0x537b,{0x12,0x69,0x64,0x09,0x7f,0x01,0x1f}}, // \xe5\x8d\xbb
{0x537f,{0x5e,0x31,0x7e,0x4a,0x2e,0x7f,0x1f}}, // \xe5\x8d\xbf
{0x5382,{0x40,0x3f,0x01,0x01,0x01,0x01,0x01}}, // \xe5\x8e\x82
{0x5384,{0x40,0x3f,0x01,0x7d,0x45,0x5d,0x61}}, // \xe5\x8e\x84
{0x5396,{0x40,0x3f,0x45,0x3f,0x45,0x69,0x55}}, // \xe5\x8e\x96
{0x5398,{0x40,0x3f,0x5f,0x55,0x7f,0x55,0x5f}}, // \xe5\x8e\x98
{0x539a,{0x40,0x3f,0x11,0x57,0x77,0x1f,0x11}}, // \xe5\x8e\x9a
{0x539f,{0x40,0x3f,0x21,0x4d,0x7f,0x0d,0x21}}, // \xe5\x8e\x9f
{0x53a0,{0x40,0x3f,0x5f,0x15,0x5f,0x01,0x7d}}, // \xe5\x8e\xa0
{0x53a5,{0x40,0x3f,0x5b,0x35,0x4b,0x3d,0x4d}}, // \xe5\x8e\xa5
{0x53a6,{0x40,0x3f,0x41,0x53,0x2f,0x5f,0x43}}, // \xe5\x8e\xa6
{0x53a8,{0x40,0x3f,0x5d,0x75,0x2d,0x49,0x7d}}, // \xe5\x8e\xa8
{0x53a9,{0x40,0x3f,0x2d,0x53,0x3f,0x73,0x5f}}, // \xe5\x8e\xa9
{0x53ad,{0x40,0x3f,0x7b,0x7b,0x45,0x3f,0x45}}, // \xe5\x8e\xad
{0x53ae,{0x40,0x3f,0x55,0x1f,0x5f,0x3d,0x73}}, // \xe5\x8e\xae
{0x53b0,{0x40,0x3f,0x7d,0x3b,0x7d,0x27,0x5d}}, // \xe5\x8e\xb0
{0x53b3,{0x40,0x3f,0x2e,0x7b,0x52,0x2b,0x5a}}, // \xe5\x8e\xb3
{0x53b6,{0x40,0x60,0x58,0x47,0x50,0x20,0x40}}, // \xe5\x8e\xb6
{0x53bb,{0x48,0x4a,0x6a,0x5f,0x4a,0x2a,0x48}}, // \xe5\x8e\xbb
{0x53c2,{0x14,0x4e,0x57,0x4e,0x25,0x0e,0x14}}, // \xe5\x8f\x82
{0x53c3,{0x2c,0x1a,0x4f,0x5a,0x2d,0x1a,0x2c}}, // \xe5\x8f\x83
{0x53c8,{0x40,0x41,0x2d,0x11,0x29,0x47,0x40}}, // \xe5\x8f\x88
{0x53c9,{0x40,0x45,0x29,0x13,0x29,0x47,0x40}}, // \xe5\x8f\x89
{0x53ca,{0x41,0x31,0x4f,0x51,0x27,0x5c,0x40}}, // \xe5\x8f\x8a
{0x53cb,{0x42,0x32,0x4f,0x5a,0x2a,0x5a,0x42}}, // \xe5\x8f\x8b
{0x53cc,{0x41,0x25,0x19,0x27,0x4d,0x31,0x4f}}, // \xe5\x8f\x8c
{0x53cd,{0x40,0x3f,0x45,0x5d,0x25,0x5d,0x41}}, // \xe5\x8f\x8d
{0x53ce,{0x3e,0x20,0x7f,0x10,0x4d,0x31,0x4f}}, // \xe5\x8f\x8e
{0x53d4,{0x28,0x48,0x7f,0x2a,0x4d,0x31,0x4f}}, // \xe5\x8f\x94
{0x53d6,{0x21,0x3f,0x2d,0x7f,0x2a,0x12,0x2e}}, // \xe5\x8f\x96
{0x53d7,{0x4d,0x47,0x5d,0x2f,0x5d,0x47,0x4d}}, // \xe5\x8f\x97
{0x53d9,{0x54,0x16,0x7d,0x16,0x4d,0x31,0x4f}}, // \xe5\x8f\x99
{0x53db,{0x55,0x3e,0x15,0x20,0x5f,0x25,0x5d}}, // \xe5\x8f\x9b
{0x53df,{0x4e,0x4d,0x58,0x2f,0x58,0x4d,0x4f}}, // \xe5\x8f\x9f
{0x53e1,{0x2c,0x14,0x6f,0x76,0x4d,0x31,0x4f}}, // \xe5\x8f\xa1
{0x53e2,{0x2b,0x3a,0x7f,0x1a,0x5f,0x2a,0x5b}}, // \xe5\x8f\xa2
{0x53e3,{0x00,0x7e,0x22,0x22,0x22,0x22,0x7e}}, // \xe5\x8f\xa3
{0x53e4,{0x04,0x74,0x54,0x5f,0x54,0x74,0x04}}, // \xe5\x8f\xa4
{0x53e5,{0x08,0x04,0x3b,0x2a,0x3a,0x42,0x7e}}, // \xe5\x8f\xa5
{0x53e8,{0x1e,0x12,0x5e,0x21,0x1f,0x41,0x7f}}, // \xe5\x8f\xa8
{0x53e9,{0x1e,0x12,0x1e,0x7f,0x01,0x11,0x1f}}, // \xe5\x8f\xa9
{0x53ea,{0x40,0x4f,0x29,0x09,0x29,0x4f,0x40}}, // \xe5\x8f\xaa
{0x53eb,{0x1e,0x1e,0x20,0x3e,0x20,0x7f,0x10}}, // \xe5\x8f\xab
{0x53ec,{0x09,0x79,0x55,0x53,0x51,0x79,0x0f}}, // \xe5\x8f\xac
{0x53ed,{0x1e,0x1e,0x40,0x3f,0x00,0x3f,0x40}}, // \xe5\x8f\xad
{0x53ee,{0x1e,0x12,0x1e,0x01,0x41,0x7f,0x01}}, // \xe5\x8f\xae
{0x53ef,{0x01,0x1d,0x15,0x1d,0x41,0x7f,0x01}}, // \xe5\x8f\xaf
{0x53f0,{0x08,0x68,0x6c,0x6b,0x68,0x64,0x08}}, // \xe5\x8f\xb0
{0x53f1,{0x1e,0x12,0x1e,0x7f,0x48,0x48,0x64}}, // \xe5\x8f\xb1
{0x53f2,{0x40,0x4e,0x5a,0x3f,0x4a,0x4e,0x40}}, // \xe5\x8f\xb2
{0x53f3,{0x12,0x0a,0x7f,0x4a,0x4a,0x7a,0x02}}, // \xe5\x8f\xb3
{0x53f6,{0x1e,0x12,0x1e,0x04,0x04,0x7f,0x04}}, // \xe5\x8f\xb6
{0x53f7,{0x04,0x04,0x1f,0x55,0x57,0x74,0x04}}, // \xe5\x8f\xb7
{0x53f8,{0x01,0x35,0x35,0x35,0x35,0x41,0x7f}}, // \xe5\x8f\xb8
{0x53fa,{0x1e,0x12,0x5e,0x31,0x0f,0x30,0x40}}, // \xe5\x8f\xba
{0x5401,{0x1e,0x12,0x1e,0x09,0x49,0x7f,0x09}}, // \xe5\x90\x81
{0x5403,{0x1e,0x1e,0x04,0x23,0x56,0x4e,0x62}}, // \xe5\x90\x83
{0x5404,{0x10,0x12,0x6a,0x65,0x6b,0x10,0x10}}, // \xe5\x90\x84
{0x5408,{0x04,0x74,0x52,0x55,0x56,0x74,0x04}}, // \xe5\x90\x88
{0x5409,{0x02,0x6a,0x6a,0x6f,0x6a,0x6a,0x02}}, // \xe5\x90\x89
{0x540a,{0x38,0x0f,0x0d,0x7d,0x0d,0x2f,0x38}}, // \xe5\x90\x8a
{0x540b,{0x1e,0x12,0x1e,0x0a,0x52,0x7f,0x02}}, // \xe5\x90\x8b
{0x540c,{0x7f,0x01,0x75,0x55,0x75,0x01,0x7f}}, // \xe5\x90\x8c
{0x540d,{0x20,0x24,0x13,0x7d,0x55,0x53,0x70}}, // \xe5\x90\x8d
{0x540e,{0x40,0x3e,0x0a,0x6a,0x69,0x69,0x08}}, // \xe5\x90\x8e
{0x540f,{0x42,0x4e,0x5a,0x3f,0x4a,0x4e,0x42}}, // \xe5\x90\x8f
{0x5410,{0x1e,0x12,0x1e,0x44,0x44,0x7f,0x44}}, // \xe5\x90\x90
{0x5411,{0x7e,0x02,0x3a,0x2b,0x3a,0x42,0x7e}}, // \xe5\x90\x91
{0x541b,{0x24,0x25,0x75,0x5f,0x55,0x5f,0x74}}, // \xe5\x90\x9b
{0x541d,{0x12,0x72,0x76,0x6b,0x76,0x72,0x12}}, // \xe5\x90\x9d
{0x541f,{0x1e,0x12,0x1e,0x52,0x55,0x36,0x14}}, // \xe5\x90\x9f
{0x5420,{0x1e,0x12,0x5e,0x24,0x1f,0x24,0x45}}, // \xe5\x90\xa0
{0x5426,{0x09,0x79,0x55,0x5f,0x51,0x75,0x09}}, // \xe5\x90\xa6
{0x5429,{0x1e,0x1e,0x44,0x3b,0x48,0x7b,0x04}}, // \xe5\x90\xa9
{0x542b,{0x04,0x74,0x56,0x55,0x5e,0x74,0x04}}, // \xe5\x90\xab
{0x542c,{0x1e,0x1e,0x40,0x3e,0x0a,0x79,0x08}}, // \xe5\x90\xac
{0x542d,{0x1e,0x1e,0x42,0x3a,0x0b,0x7a,0x42}}, // \xe5\x90\xad
{0x542e,{0x1e,0x1e,0x44,0x3e,0x05,0x7c,0x46}}, // \xe5\x90\xae
{0x5436,{0x1e,0x12,0x7e,0x15,0x0f,0x54,0x7c}}, // \xe5\x90\xb6
{0x5438,{0x1e,0x5e,0x31,0x4f,0x51,0x27,0x5c}}, // \xe5\x90\xb8
{0x5439,{0x1e,0x1e,0x44,0x23,0x1e,0x22,0x46}}, // \xe5\x90\xb9
{0x543b,{0x3e,0x22,0x3e,0x53,0x2e,0x5e,0x7e}}, // \xe5\x90\xbb
{0x543c,{0x1e,0x1e,0x51,0x7d,0x0b,0x7f,0x40}}, // \xe5\x90\xbc
{0x543d,{0x1e,0x12,0x1e,0x14,0x13,0x7f,0x12}}, // \xe5\x90\xbd
{0x543e,{0x10,0x75,0x5d,0x57,0x5d,0x71,0x10}}, // \xe5\x90\xbe
{0x5440,{0x1e,0x1e,0x28,0x2f,0x59,0x7f,0x09}}, // \xe5\x91\x80
{0x5442,{0x00,0x70,0x57,0x5d,0x55,0x57,0x70}}, // \xe5\x91\x82
{0x5446,{0x50,0x57,0x35,0x7d,0x35,0x57,0x50}}, // \xe5\x91\x86
{0x5448,{0x44,0x57,0x55,0x7d,0x55,0x57,0x44}}, // \xe5\x91\x88
{0x5449,{0x56,0x54,0x17,0x15,0x1d,0x57,0x50}}, // \xe5\x91\x89
{0x544a,{0x0c,0x6b,0x6a,0x6f,0x6a,0x6a,0x08}}, // \xe5\x91\x8a
{0x544e,{0x1e,0x1e,0x40,0x3f,0x05,0x1d,0x67}}, // \xe5\x91\x8e
{0x5451,{0x14,0x0e,0x76,0x56,0x75,0x0d,0x14}}, // \xe5\x91\x91
{0x545f,{0x1e,0x1e,0x4a,0x6e,0x53,0x2a,0x42}}, // \xe5\x91\x9f
{0x5468,{0x40,0x3f,0x75,0x5f,0x75,0x11,0x7f}}, // \xe5\x91\xa8
{0x546a,{0x1e,0x52,0x5f,0x39,0x09,0x79,0x4f}}, // \xe5\x91\xaa
{0x5470,{0x0e,0x78,0x5f,0x5a,0x50,0x7f,0x0a}}, // \xe5\x91\xb0
{0x5471,{0x1e,0x1e,0x40,0x3e,0x42,0x3e,0x61}}, // \xe5\x91\xb1
{0x5473,{0x1e,0x12,0x5e,0x2a,0x7f,0x2a,0x48}}, // \xe5\x91\xb3
{0x5475,{0x1e,0x1e,0x01,0x1d,0x15,0x5d,0x7f}}, // \xe5\x91\xb5
{0x5476,{0x1e,0x1e,0x5c,0x37,0x4c,0x31,0x4f}}, // \xe5\x91\xb6
{0x5477,{0x1e,0x12,0x1f,0x15,0x7f,0x15,0x1f}}, // \xe5\x91\xb7
{0x547b,{0x1e,0x12,0x3e,0x2a,0x7f,0x2a,0x3e}}, // \xe5\x91\xbb
{0x547c,{0x1e,0x1e,0x16,0x52,0x7e,0x11,0x15}}, // \xe5\x91\xbc
{0x547d,{0x34,0x34,0x32,0x05,0x76,0x14,0x34}}, // \xe5\x91\xbd
{0x5480,{0x1e,0x1e,0x40,0x7f,0x55,0x7f,0x40}}, // \xe5\x92\x80
{0x5484,{0x1e,0x1e,0x76,0x44,0x7f,0x44,0x76}}, // \xe5\x92\x84
{0x5486,{0x1e,0x1e,0x04,0x7b,0x5a,0x42,0x5e}}, // \xe5\x92\x86
{0x548b,{0x1e,0x12,0x1e,0x04,0x7f,0x2a,0x2a}}, // \xe5\x92\x8b
{0x548c,{0x24,0x15,0x7f,0x15,0x7e,0x42,0x7e}}, // \xe5\x92\x8c
{0x548e,{0x0a,0x7b,0x55,0x5b,0x54,0x73,0x14}}, // \xe5\x92\x8e
{0x548f,{0x1e,0x1e,0x28,0x5d,0x7d,0x10,0x28}}, // \xe5\x92\x8f
{0x5490,{0x1e,0x1e,0x04,0x7e,0x09,0x42,0x7f}}, // \xe5\x92\x90
{0x5492,{0x47,0x45,0x3f,0x08,0x7f,0x45,0x67}}, // \xe5\x92\x92
{0x54a2,{0x0b,0x0b,0x1f,0x5c,0x5f,0x7b,0x0b}}, // \xe5\x92\xa2
{0x54a4,{0x1e,0x1e,0x16,0x1a,0x7b,0x56,0x56}}, // \xe5\x92\xa4
{0x54a5,{0x1e,0x1e,0x45,0x57,0x7d,0x53,0x45}}, // \xe5\x92\xa5
{0x54a8,{0x09,0x70,0x54,0x5b,0x56,0x7a,0x06}}, // \xe5\x92\xa8
{0x54ab,{0x40,0x3f,0x19,0x27,0x50,0x47,0x57}}, // \xe5\x92\xab
{0x54ac,{0x1e,0x1e,0x4a,0x56,0x23,0x56,0x4a}}, // \xe5\x92\xac
{0x54af,{0x1e,0x1e,0x10,0x6a,0x65,0x6b,0x10}}, // \xe5\x92\xaf
{0x54b2,{0x1e,0x12,0x5e,0x55,0x3c,0x55,0x54}}, // \xe5\x92\xb2
{0x54b3,{0x1e,0x12,0x1e,0x4a,0x56,0x2b,0x52}}, // \xe5\x92\xb3
{0x54b8,{0x40,0x3e,0x6a,0x6a,0x42,0x3f,0x52}}, // \xe5\x92\xb8
{0x54bc,{0x78,0x0f,0x79,0x5f,0x7b,0x0f,0x78}}, // \xe5\x92\xbc
{0x54bd,{0x1e,0x12,0x7f,0x55,0x4f,0x55,0x7f}}, // \xe5\x92\xbd
{0x54be,{0x1e,0x1e,0x28,0x1a,0x6f,0x5a,0x49}}, // \xe5\x92\xbe
{0x54c0,{0x22,0x2e,0x7a,0x4b,0x1a,0x2e,0x52}}, // \xe5\x93\x80
{0x54c1,{0x70,0x57,0x75,0x05,0x75,0x57,0x70}}, // \xe5\x93\x81
{0x54c2,{0x1e,0x12,0x7d,0x5f,0x45,0x5f,0x7d}}, // \xe5\x93\x82
{0x54c4,{0x1e,0x1e,0x52,0x1f,0x12,0x1f,0x52}}, // \xe5\x93\x84
{0x54c7,{0x1e,0x1e,0x48,0x5a,0x7f,0x5a,0x48}}, // \xe5\x93\x87
{0x54c8,{0x1e,0x1e,0x04,0x72,0x55,0x76,0x04}}, // \xe5\x93\x88
{0x54c9,{0x08,0x6a,0x6f,0x0a,0x4f,0x38,0x5a}}, // \xe5\x93\x89
{0x54d8,{0x1e,0x1e,0x0a,0x7d,0x00,0x45,0x7d}}, // \xe5\x93\x98
{0x54e1,{0x40,0x7c,0x2f,0x2d,0x2f,0x7c,0x40}}, // \xe5\x93\xa1
{0x54e2,{0x1e,0x1e,0x55,0x3d,0x17,0x7d,0x15}}, // \xe5\x93\xa2
{0x54e5,{0x09,0x7f,0x5d,0x7f,0x09,0x7f,0x09}}, // \xe5\x93\xa5
{0x54e6,{0x1e,0x1e,0x26,0x7e,0x25,0x3f,0x55}}, // \xe5\x93\xa6
{0x54e8,{0x1e,0x12,0x1e,0x7d,0x14,0x57,0x7d}}, // \xe5\x93\xa8
{0x54e9,{0x1e,0x12,0x5f,0x55,0x7f,0x55,0x5f}}, // \xe5\x93\xa9
{0x54ed,{0x57,0x55,0x57,0x38,0x57,0x5d,0x57}}, // \xe5\x93\xad
{0x54ee,{0x1e,0x1e,0x28,0x1a,0x2f,0x7a,0x29}}, // \xe5\x93\xae
{0x54f2,{0x0a,0x7f,0x50,0x5e,0x56,0x7d,0x04}}, // \xe5\x93\xb2
{0x54fa,{0x1e,0x12,0x7e,0x2a,0x7f,0x2a,0x7b}}, // \xe5\x93\xba
{0x54fd,{0x1e,0x1e,0x41,0x57,0x3f,0x47,0x41}}, // \xe5\x93\xbd
{0x5504,{0x1e,0x12,0x1e,0x5f,0x15,0x15,0x5f}}, // \xe5\x94\x84
{0x5506,{0x1e,0x1e,0x2a,0x57,0x32,0x5e,0x4b}}, // \xe5\x94\x86
{0x5507,{0x10,0x0f,0x7d,0x77,0x6f,0x77,0x15}}, // \xe5\x94\x87
{0x550f,{0x1e,0x1e,0x48,0x2d,0x7a,0x2d,0x68}}, // \xe5\x94\x8f
{0x5510,{0x40,0x3e,0x12,0x76,0x5f,0x7e,0x0a}}, // \xe5\x94\x90
{0x5514,{0x1e,0x1e,0x14,0x7d,0x57,0x7d,0x10}}, // \xe5\x94\x94
{0x5516,{0x1e,0x12,0x5d,0x7f,0x55,0x7f,0x5d}}, // \xe5\x94\x96
{0x552e,{0x08,0x04,0x7f,0x5a,0x5f,0x7a,0x0a}}, // \xe5\x94\xae
{0x552f,{0x1e,0x1e,0x04,0x7f,0x4a,0x7f,0x4a}}, // \xe5\x94\xaf
{0x5531,{0x1e,0x12,0x7e,0x57,0x55,0x57,0x7c}}, // \xe5\x94\xb1
{0x5533,{0x1e,0x1e,0x21,0x5f,0x55,0x3d,0x57}}, // \xe5\x94\xb3
{0x5538,{0x1e,0x1e,0x64,0x2a,0x4d,0x5e,0x64}}, // \xe5\x94\xb8
{0x5539,{0x1e,0x1e,0x62,0x1f,0x7a,0x29,0x52}}, // \xe5\x94\xb9
{0x553e,{0x1e,0x1e,0x54,0x5d,0x77,0x5d,0x54}}, // \xe5\x94\xbe
{0x5540,{0x1e,0x52,0x3f,0x41,0x55,0x7f,0x55}}, // \xe5\x95\x80
{0x5544,{0x1e,0x1e,0x29,0x57,0x7d,0x19,0x25}}, // \xe5\x95\x84
{0x5545,{0x1e,0x1e,0x20,0x3c,0x77,0x3e,0x22}}, // \xe5\x95\x85
{0x5546,{0x7a,0x2a,0x1e,0x6b,0x7a,0x2e,0x7a}}, // \xe5\x95\x86
{0x554c,{0x1e,0x1e,0x46,0x56,0x73,0x56,0x46}}, // \xe5\x95\x8c
{0x554f,{0x7f,0x05,0x77,0x50,0x77,0x05,0x7f}}, // \xe5\x95\x8f
{0x5553,{0x09,0x77,0x55,0x57,0x5a,0x75,0x0b}}, // \xe5\x95\x93
{0x5556,{0x1e,0x1e,0x55,0x22,0x19,0x22,0x55}}, // \xe5\x95\x96
{0x5557,{0x1e,0x1e,0x70,0x6a,0x41,0x6d,0x7b}}, // \xe5\x95\x97
{0x555c,{0x1e,0x12,0x5d,0x2b,0x5d,0x2b,0x5d}}, // \xe5\x95\x9c
{0x555d,{0x1e,0x5e,0x25,0x7f,0x15,0x2e,0x4e}}, // \xe5\x95\x9d
{0x5563,{0x1e,0x1e,0x33,0x3e,0x2a,0x7f,0x1f}}, // \xe5\x95\xa3
{0x557b,{0x1a,0x6a,0x7e,0x6b,0x7a,0x6e,0x1a}}, // \xe5\x95\xbb
{0x557c,{0x1e,0x1e,0x1a,0x6e,0x3b,0x6e,0x1a}}, // \xe5\x95\xbc
{0x557e,{0x1e,0x1e,0x35,0x7f,0x4c,0x3f,0x44}}, // \xe5\x95\xbe
{0x5580,{0x1e,0x1e,0x26,0x6a,0x57,0x6e,0x26}}, // \xe5\x96\x80
{0x5583,{0x1e,0x1e,0x7a,0x2a,0x77,0x2a,0x7a}}, // \xe5\x96\x83
{0x5584,{0x2a,0x7a,0x6b,0x7e,0x6a,0x7b,0x2a}}, // \xe5\x96\x84
{0x5587,{0x1e,0x52,0x2e,0x7f,0x2a,0x4e,0x7f}}, // \xe5\x96\x87
{0x5589,{0x1e,0x12,0x7f,0x54,0x5d,0x37,0x54}}, // \xe5\x96\x89
{0x558a,{0x1e,0x52,0x3e,0x6a,0x6a,0x3f,0x52}}, // \xe5\x96\x8a
{0x558b,{0x1e,0x12,0x5f,0x32,0x77,0x36,0x57}}, // \xe5\x96\x8b
{0x5598,{0x1e,0x1e,0x6b,0x3a,0x6b,0x2a,0x6b}}, // \xe5\x96\x98
{0x5599,{0x1e,0x1e,0x2c,0x56,0x7d,0x27,0x55}}, // \xe5\x96\x99
{0x559a,{0x1e,0x1e,0x52,0x5d,0x3d,0x5f,0x50}}, // \xe5\x96\x9a
{0x559c,{0x12,0x76,0x5e,0x57,0x5e,0x76,0x12}}, // \xe5\x96\x9c
{0x559d,{0x1e,0x1e,0x10,0x3f,0x2d,0x4f,0x78}}, // \xe5\x96\x9d
{0x559e,{0x1e,0x12,0x7e,0x2b,0x0e,0x7f,0x1f}}, // \xe5\x96\x9e
{0x559f,{0x1e,0x12,0x1f,0x7d,0x2f,0x7d,0x0f}}, // \xe5\x96\x9f
{0x55a7,{0x1e,0x1e,0x46,0x72,0x57,0x76,0x46}}, // \xe5\x96\xa7
{0x55a8,{0x1e,0x1e,0x5a,0x2e,0x0b,0x6e,0x5a}}, // \xe5\x96\xa8
{0x55a9,{0x1e,0x1e,0x75,0x33,0x75,0x26,0x54}}, // \xe5\x96\xa9
{0x55aa,{0x52,0x36,0x76,0x5f,0x32,0x56,0x56}}, // \xe5\x96\xaa
{0x55ab,{0x1e,0x1e,0x4a,0x5f,0x3a,0x57,0x4f}}, // \xe5\x96\xab
{0x55ac,{0x7a,0x1a,0x77,0x5b,0x77,0x1a,0x7a}}, // \xe5\x96\xac
{0x55ae,{0x27,0x3d,0x37,0x7c,0x37,0x3d,0x27}}, // \xe5\x96\xae
{0x55b0,{0x1e,0x1e,0x44,0x7a,0x5d,0x22,0x54}}, // \xe5\x96\xb0
{0x55b6,{0x06,0x63,0x6e,0x7b,0x6e,0x63,0x06}}, // \xe5\x96\xb6
{0x55c4,{0x1e,0x1e,0x51,0x5f,0x2f,0x5f,0x41}}, // \xe5\x97\x84
{0x55c5,{0x1e,0x1e,0x50,0x5e,0x3b,0x5e,0x50}}, // \xe5\x97\x85
{0x55c7,{0x1a,0x76,0x7a,0x5f,0x7a,0x76,0x1a}}, // \xe5\x97\x87
{0x55d4,{0x1e,0x1e,0x58,0x13,0x1e,0x1e,0x52}}, // \xe5\x97\x94
{0x55da,{0x1e,0x1e,0x40,0x1e,0x5b,0x1e,0x70}}, // \xe5\x97\x9a
{0x55dc,{0x1e,0x1e,0x14,0x6e,0x7f,0x76,0x15}}, // \xe5\x97\x9c
{0x55df,{0x1e,0x1e,0x4a,0x3b,0x5e,0x7b,0x5a}}, // \xe5\x97\x9f
{0x55e3,{0x78,0x3b,0x1b,0x78,0x35,0x35,0x7f}}, // \xe5\x97\xa3
{0x55e4,{0x1e,0x1e,0x4b,0x5a,0x7f,0x5a,0x6b}}, // \xe5\x97\xa4
{0x55f7,{0x1e,0x1e,0x4a,0x3f,0x6a,0x3f,0x5e}}, // \xe5\x97\xb7
{0x55f9,{0x1e,0x1e,0x65,0x52,0x5e,0x7f,0x52}}, // \xe5\x97\xb9
{0x55fd,{0x1e,0x52,0x2e,0x7f,0x4e,0x3b,0x46}}, // \xe5\x97\xbd
{0x55fe,{0x1e,0x1e,0x62,0x1f,0x7a,0x3f,0x56}}, // \xe5\x97\xbe
{0x5606,{0x1e,0x12,0x5e,0x5b,0x3e,0x5b,0x5e}}, // \xe5\x98\x86
{0x5609,{0x52,0x36,0x5e,0x77,0x7e,0x56,0x72}}, // \xe5\x98\x89
{0x5614,{0x1e,0x12,0x7f,0x71,0x47,0x77,0x71}}, // \xe5\x98\x94
{0x5616,{0x1e,0x1e,0x48,0x3a,0x3f,0x3a,0x48}}, // \xe5\x98\x96
{0x5617,{0x06,0x7b,0x56,0x57,0x56,0x73,0x16}}, // \xe5\x98\x97
{0x5618,{0x1e,0x52,0x3e,0x64,0x4f,0x6a,0x4a}}, // \xe5\x98\x98
{0x561b,{0x5e,0x3e,0x3a,0x7e,0x3b,0x7e,0x3a}}, // \xe5\x98\x9b
{0x5629,{0x1e,0x1e,0x2a,0x3f,0x7e,0x3f,0x2a}}, // \xe5\x98\xa9
{0x562f,{0x1e,0x5e,0x38,0x6a,0x07,0x6e,0x74}}, // \xe5\x98\xaf
{0x5631,{0x1e,0x52,0x3f,0x73,0x5b,0x3f,0x73}}, // \xe5\x98\xb1
{0x5632,{0x1e,0x12,0x2d,0x7f,0x3f,0x15,0x7f}}, // \xe5\x98\xb2
{0x5634,{0x1e,0x1e,0x4f,0x3a,0x38,0x7f,0x0a}}, // \xe5\x98\xb4
{0x5636,{0x1e,0x12,0x5f,0x1a,0x5f,0x3e,0x79}}, // \xe5\x98\xb6
{0x5638,{0x1e,0x1e,0x6b,0x3e,0x6a,0x3e,0x6a}}, // \xe5\x98\xb8
{0x5642,{0x1e,0x12,0x1e,0x37,0x52,0x77,0x1e}}, // \xe5\x99\x82
{0x564c,{0x1e,0x12,0x1e,0x7b,0x5e,0x7b,0x0e}}, // \xe5\x99\x8c
{0x564e,{0x1e,0x1e,0x5a,0x6a,0x5f,0x6a,0x5a}}, // \xe5\x99\x8e
{0x5650,{0x14,0x77,0x77,0x1c,0x77,0x77,0x14}}, // \xe5\x99\x90
{0x565b,{0x1e,0x12,0x7e,0x6f,0x54,0x6f,0x7a}}, // \xe5\x99\x9b
{0x5664,{0x1e,0x1e,0x52,0x1f,0x78,0x1a,0x57}}, // \xe5\x99\xa4
{0x5668,{0x28,0x6b,0x6b,0x1c,0x6b,0x6b,0x28}}, // \xe5\x99\xa8
{0x566a,{0x1e,0x12,0x5e,0x37,0x7d,0x37,0x5c}}, // \xe5\x99\xaa
{0x566b,{0x1e,0x1e,0x6a,0x3e,0x5b,0x5e,0x6a}}, // \xe5\x99\xab
{0x566c,{0x1e,0x1e,0x6b,0x5e,0x78,0x5b,0x6e}}, // \xe5\x99\xac
{0x5674,{0x1e,0x1e,0x4a,0x3e,0x2b,0x3e,0x4a}}, // \xe5\x99\xb4
{0x5678,{0x1e,0x12,0x3f,0x2a,0x4d,0x1f,0x5d}}, // \xe5\x99\xb8
{0x567a,{0x1e,0x5e,0x36,0x7b,0x3e,0x0a,0x79}}, // \xe5\x99\xba
{0x5680,{0x1e,0x12,0x1e,0x56,0x7f,0x1a,0x16}}, // \xe5\x9a\x80
{0x5686,{0x1e,0x1e,0x72,0x1f,0x56,0x1f,0x72}}, // \xe5\x9a\x86
{0x5687,{0x1e,0x5e,0x3a,0x7f,0x4a,0x3f,0x7a}}, // \xe5\x9a\x87
{0x568a,{0x1e,0x1e,0x38,0x6e,0x3b,0x6e,0x38}}, // \xe5\x9a\x8a
{0x568f,{0x1e,0x1e,0x4c,0x2e,0x7f,0x5e,0x5c}}, // \xe5\x9a\x8f
{0x5694,{0x1e,0x1e,0x4c,0x2e,0x7f,0x5e,0x4c}}, // \xe5\x9a\x94
{0x56a0,{0x1e,0x1e,0x26,0x55,0x6a,0x57,0x7f}}, // \xe5\x9a\xa0
{0x56a2,{0x5a,0x3e,0x7a,0x5f,0x3a,0x5e,0x5a}}, // \xe5\x9a\xa2
{0x56a5,{0x1e,0x1e,0x52,0x1f,0x56,0x1f,0x52}}, // \xe5\x9a\xa5
{0x56ae,{0x7a,0x15,0x7f,0x5b,0x70,0x1f,0x77}}, // \xe5\x9a\xae
{0x56b4,{0x40,0x3f,0x2f,0x7a,0x53,0x2b,0x5a}}, // \xe5\x9a\xb4
{0x56b6,{0x1e,0x1e,0x57,0x7b,0x54,0x33,0x57}}, // \xe5\x9a\xb6
{0x56bc,{0x1e,0x12,0x7e,0x2d,0x0f,0x5d,0x7e}}, // \xe5\x9a\xbc
{0x56c0,{0x1e,0x12,0x2d,0x7f,0x2e,0x5f,0x7e}}, // \xe5\x9b\x80
{0x56c1,{0x1e,0x12,0x3e,0x75,0x27,0x3f,0x75}}, // \xe5\x9b\x81
{0x56c2,{0x24,0x67,0x7f,0x1c,0x7f,0x67,0x24}}, // \xe5\x9b\x82
{0x56c3,{0x1e,0x5e,0x36,0x7b,0x36,0x7e,0x55}}, // \xe5\x9b\x83
{0x56c8,{0x1e,0x1e,0x52,0x7f,0x5a,0x37,0x5a}}, // \xe5\x9b\x88
{0x56ce,{0x1e,0x5f,0x15,0x5f,0x02,0x6d,0x6e}}, // \xe5\x9b\x8e
{0x56d1,{0x1e,0x52,0x3f,0x5b,0x7f,0x3b,0x77}}, // \xe5\x9b\x91
{0x56d3,{0x1e,0x1e,0x0a,0x7f,0x5e,0x6b,0x7f}}, // \xe5\x9b\x93
{0x56d7,{0x7f,0x41,0x41,0x41,0x41,0x41,0x7f}}, // \xe5\x9b\x97
{0x56d8,{0x7f,0x01,0x3f,0x2b,0x2f,0x41,0x7f}}, // \xe5\x9b\x98
{0x56da,{0x7f,0x61,0x51,0x4f,0x51,0x61,0x7f}}, // \xe5\x9b\x9a
{0x56db,{0x7f,0x51,0x4f,0x41,0x4f,0x49,0x7f}}, // \xe5\x9b\x9b
{0x56de,{0x7f,0x41,0x5d,0x55,0x5d,0x41,0x7f}}, // \xe5\x9b\x9e
{0x56e0,{0x7f,0x65,0x55,0x4f,0x55,0x65,0x7f}}, // \xe5\x9b\xa0
{0x56e3,{0x7f,0x45,0x4d,0x65,0x7f,0x45,0x7f}}, // \xe5\x9b\xa3
{0x56ee,{0x7f,0x49,0x7d,0x43,0x7f,0x65,0x7f}}, // \xe5\x9b\xae
{0x56f0,{0x7f,0x55,0x4d,0x7f,0x4d,0x55,0x7f}}, // \xe5\x9b\xb0
{0x56f2,{0x7f,0x55,0x7f,0x55,0x7f,0x55,0x7f}}, // \xe5\x9b\xb2
{0x56f3,{0x7f,0x43,0x69,0x53,0x59,0x65,0x7f}}, // \xe5\x9b\xb3
{0x56f9,{0x7f,0x49,0x4d,0x7b,0x4d,0x59,0x7f}}, // \xe5\x9b\xb9
{0x56fa,{0x7f,0x41,0x75,0x6f,0x75,0x41,0x7f}}, // \xe5\x9b\xba
{0x56fd,{0x7f,0x41,0x6b,0x7f,0x6b,0x51,0x7f}}, // \xe5\x9b\xbd
{0x56ff,{0x7f,0x55,0x4f,0x75,0x75,0x41,0x7f}}, // \xe5\x9b\xbf
{0x5700,{0x7f,0x45,0x6b,0x59,0x7f,0x4d,0x7f}}, // \xe5\x9c\x80
{0x5703,{0x7f,0x45,0x7d,0x5f,0x7d,0x47,0x7f}}, // \xe5\x9c\x83
{0x5704,{0x7f,0x55,0x7f,0x77,0x7b,0x51,0x7f}}, // \xe5\x9c\x84
{0x5708,{0x7f,0x55,0x7f,0x7d,0x6f,0x55,0x7f}}, // \xe5\x9c\x88
{0x5709,{0x7f,0x55,0x5d,0x77,0x5d,0x55,0x7f}}, // \xe5\x9c\x89
{0x570b,{0x7f,0x6d,0x6d,0x45,0x5f,0x65,0x7f}}, // \xe5\x9c\x8b
{0x570d,{0x7f,0x55,0x5d,0x57,0x7f,0x55,0x7f}}, // \xe5\x9c\x8d
{0x570f,{0x7f,0x55,0x4f,0x7d,0x6f,0x55,0x7f}}, // \xe5\x9c\x8f
{0x5712,{0x7f,0x65,0x5f,0x77,0x5f,0x65,0x7f}}, // \xe5\x9c\x92
{0x5713,{0x7f,0x61,0x5f,0x5b,0x5f,0x61,0x7f}}, // \xe5\x9c\x93
{0x5716,{0x7f,0x49,0x7f,0x6d,0x7f,0x49,0x7f}}, // \xe5\x9c\x96
{0x5718,{0x7f,0x55,0x5d,0x5f,0x7d,0x55,0x7f}}, // \xe5\x9c\x98
{0x571c,{0x7f,0x55,0x7f,0x6f,0x5f,0x65,0x7f}}, // \xe5\x9c\x9c
{0x571f,{0x40,0x44,0x44,0x7f,0x44,0x44,0x40}}, // \xe5\x9c\x9f
{0x5726,{0x24,0x3f,0x44,0x31,0x0f,0x30,0x40}}, // \xe5\x9c\xa6
{0x5727,{0x40,0x3f,0x41,0x49,0x7f,0x49,0x41}}, // \xe5\x9c\xa7
{0x5728,{0x12,0x7a,0x47,0x4a,0x7e,0x4a,0x42}}, // \xe5\x9c\xa8
{0x572d,{0x48,0x5a,0x5a,0x7f,0x5a,0x5a,0x48}}, // \xe5\x9c\xad
{0x5730,{0x24,0x3f,0x08,0x7e,0x44,0x5f,0x6c}}, // \xe5\x9c\xb0
{0x5737,{0x24,0x3f,0x14,0x01,0x7f,0x05,0x09}}, // \xe5\x9c\xb7
{0x5738,{0x24,0x3f,0x7c,0x40,0x7f,0x40,0x7c}}, // \xe5\x9c\xb8
{0x573b,{0x24,0x3f,0x40,0x3e,0x0a,0x79,0x08}}, // \xe5\x9c\xbb
{0x5740,{0x24,0x3f,0x40,0x7c,0x40,0x7f,0x44}}, // \xe5\x9d\x80
{0x5742,{0x24,0x3f,0x24,0x5f,0x5d,0x25,0x5d}}, // \xe5\x9d\x82
{0x5747,{0x24,0x3f,0x14,0x23,0x2a,0x52,0x7e}}, // \xe5\x9d\x87
{0x574a,{0x24,0x3f,0x14,0x42,0x3e,0x4b,0x7a}}, // \xe5\x9d\x8a
{0x574e,{0x24,0x3f,0x44,0x23,0x1e,0x22,0x46}}, // \xe5\x9d\x8e
{0x574f,{0x24,0x3f,0x11,0x09,0x7f,0x09,0x11}}, // \xe5\x9d\x8f
{0x5750,{0x44,0x53,0x54,0x7f,0x54,0x53,0x44}}, // \xe5\x9d\x90
{0x5751,{0x24,0x3f,0x42,0x3a,0x0b,0x7a,0x42}}, // \xe5\x9d\x91
{0x5761,{0x24,0x3f,0x7e,0x5a,0x2f,0x5a,0x46}}, // \xe5\x9d\xa1
{0x5764,{0x24,0x3f,0x3e,0x2a,0x7f,0x2a,0x3e}}, // \xe5\x9d\xa4
{0x5766,{0x24,0x3f,0x14,0x5f,0x55,0x55,0x5f}}, // \xe5\x9d\xa6
{0x5769,{0x24,0x3f,0x02,0x7f,0x4a,0x7f,0x02}}, // \xe5\x9d\xa9
{0x576a,{0x24,0x3f,0x15,0x11,0x7f,0x11,0x15}}, // \xe5\x9d\xaa
{0x577f,{0x24,0x3f,0x14,0x7e,0x09,0x42,0x7f}}, // \xe5\x9d\xbf
{0x5782,{0x54,0x5e,0x56,0x7e,0x55,0x5d,0x54}}, // \xe5\x9e\x82
{0x5788,{0x44,0x5e,0x51,0x7a,0x53,0x56,0x4b}}, // \xe5\x9e\x88
{0x5789,{0x24,0x3f,0x04,0x7b,0x5a,0x42,0x5e}}, // \xe5\x9e\x89
{0x578b,{0x55,0x4f,0x55,0x7f,0x55,0x46,0x5f}}, // \xe5\x9e\x8b
{0x5793,{0x24,0x3f,0x4a,0x56,0x2b,0x32,0x4a}}, // \xe5\x9e\x93
{0x57a0,{0x24,0x3f,0x14,0x7f,0x55,0x35,0x5f}}, // \xe5\x9e\xa0
{0x57a2,{0x24,0x3f,0x40,0x3e,0x0a,0x6a,0x69}}, // \xe5\x9e\xa2
{0x57a3,{0x24,0x3f,0x41,0x7f,0x6b,0x7f,0x41}}, // \xe5\x9e\xa3
{0x57a4,{0x24,0x3f,0x45,0x57,0x7d,0x53,0x45}}, // \xe5\x9e\xa4
{0x57aa,{0x24,0x3f,0x54,0x3d,0x14,0x7d,0x14}}, // \xe5\x9e\xaa
{0x57b0,{0x24,0x3f,0x14,0x08,0x7f,0x1a,0x2a}}, // \xe5\x9e\xb0
{0x57b3,{0x24,0x3f,0x0a,0x7d,0x00,0x45,0x7d}}, // \xe5\x9e\xb3
{0x57c0,{0x54,0x5e,0x66,0x7e,0x65,0x5d,0x54}}, // \xe5\x9f\x80
{0x57c3,{0x24,0x3f,0x54,0x5e,0x35,0x54,0x56}}, // \xe5\x9f\x83
{0x57c6,{0x24,0x3f,0x42,0x3e,0x1d,0x57,0x7c}}, // \xe5\x9f\x86
{0x57cb,{0x24,0x3f,0x5f,0x55,0x7f,0x55,0x5f}}, // \xe5\x9f\x8b
{0x57ce,{0x24,0x3f,0x7e,0x2a,0x5a,0x3f,0x52}}, // \xe5\x9f\x8e
{0x57d2,{0x24,0x3f,0x0a,0x29,0x4b,0x7d,0x0a}}, // \xe5\x9f\x92
{0x57d3,{0x24,0x3f,0x08,0x2a,0x4d,0x7b,0x08}}, // \xe5\x9f\x93
{0x57d4,{0x24,0x3f,0x7a,0x2a,0x7f,0x2a,0x7b}}, // \xe5\x9f\x94
{0x57d6,{0x24,0x3f,0x12,0x7b,0x02,0x7f,0x52}}, // \xe5\x9f\x96
{0x57dc,{0x4a,0x56,0x5f,0x7a,0x56,0x5f,0x4a}}, // \xe5\x9f\x9c
{0x57df,{0x24,0x3f,0x5a,0x5a,0x22,0x3f,0x52}}, // \xe5\x9f\x9f
{0x57e0,{0x24,0x3f,0x24,0x3e,0x6b,0x2e,0x38}}, // \xe5\x9f\xa0
{0x57e3,{0x24,0x3f,0x32,0x2e,0x73,0x2e,0x32}}, // \xe5\x9f\xa3
{0x57f4,{0x24,0x3f,0x14,0x7a,0x42,0x5f,0x5a}}, // \xe5\x9f\xb4
{0x57f7,{0x14,0x3e,0x77,0x3e,0x13,0x7e,0x40}}, // \xe5\x9f\xb7
{0x57f9,{0x24,0x3f,0x0a,0x6e,0x6b,0x6e,0x0a}}, // \xe5\x9f\xb9
{0x57fa,{0x28,0x1a,0x4f,0x6a,0x4f,0x1a,0x28}}, // \xe5\x9f\xba
{0x57fc,{0x24,0x3f,0x12,0x5a,0x17,0x7a,0x12}}, // \xe5\x9f\xbc
{0x5800,{0x24,0x3f,0x1f,0x65,0x4d,0x7d,0x6f}}, // \xe5\xa0\x80
{0x5802,{0x46,0x53,0x5e,0x7b,0x5e,0x53,0x46}}, // \xe5\xa0\x82
{0x5805,{0x47,0x57,0x55,0x78,0x5b,0x55,0x4b}}, // \xe5\xa0\x85
{0x5806,{0x24,0x3f,0x14,0x7f,0x4a,0x7f,0x4a}}, // \xe5\xa0\x86
{0x580a,{0x51,0x5f,0x5b,0x71,0x5b,0x5f,0x51}}, // \xe5\xa0\x8a
{0x580b,{0x24,0x7f,0x3f,0x55,0x3f,0x55,0x7f}}, // \xe5\xa0\x8b
{0x5815,{0x5f,0x4b,0x40,0x6a,0x47,0x5a,0x5a}}, // \xe5\xa0\x95
{0x5819,{0x24,0x3f,0x14,0x5d,0x5f,0x7f,0x5d}}, // \xe5\xa0\x99
{0x581d,{0x24,0x3f,0x14,0x78,0x6f,0x09,0x7f}}, // \xe5\xa0\x9d
{0x5821,{0x44,0x5e,0x55,0x6f,0x5d,0x4f,0x54}}, // \xe5\xa0\xa1
{0x5824,{0x24,0x3f,0x44,0x34,0x47,0x7f,0x54}}, // \xe5\xa0\xa4
{0x582a,{0x24,0x3f,0x72,0x5f,0x72,0x5f,0x52}}, // \xe5\xa0\xaa
{0x582f,{0x54,0x5e,0x3e,0x17,0x7e,0x5e,0x54}}, // \xe5\xa0\xaf
{0x5830,{0x24,0x3f,0x7f,0x49,0x6f,0x57,0x69}}, // \xe5\xa0\xb0
{0x5831,{0x14,0x3e,0x77,0x3e,0x5f,0x29,0x5b}}, // \xe5\xa0\xb1
{0x5834,{0x24,0x3f,0x24,0x5f,0x35,0x57,0x74}}, // \xe5\xa0\xb4
{0x5835,{0x24,0x3f,0x28,0x1a,0x6f,0x6a,0x69}}, // \xe5\xa0\xb5
{0x583a,{0x24,0x3f,0x2f,0x75,0x1f,0x75,0x2f}}, // \xe5\xa0\xba
{0x583d,{0x24,0x3f,0x00,0x77,0x47,0x7d,0x57}}, // \xe5\xa0\xbd
{0x5840,{0x24,0x3f,0x3f,0x6d,0x35,0x7d,0x27}}, // \xe5\xa1\x80
{0x5841,{0x28,0x57,0x45,0x67,0x45,0x57,0x28}}, // \xe5\xa1\x81
{0x584a,{0x24,0x3f,0x5e,0x2a,0x7f,0x6a,0x5e}}, // \xe5\xa1\x8a
{0x584b,{0x4d,0x46,0x55,0x7c,0x55,0x46,0x4d}}, // \xe5\xa1\x8b
{0x5851,{0x57,0x5e,0x4b,0x6e,0x5f,0x45,0x5f}}, // \xe5\xa1\x91
{0x5852,{0x24,0x3f,0x3e,0x6a,0x2f,0x7a,0x28}}, // \xe5\xa1\x92
{0x5854,{0x24,0x3f,0x12,0x7b,0x56,0x7b,0x12}}, // \xe5\xa1\x94
{0x5857,{0x55,0x40,0x54,0x76,0x5d,0x46,0x54}}, // \xe5\xa1\x97
{0x5858,{0x24,0x3f,0x7e,0x12,0x77,0x5e,0x6a}}, // \xe5\xa1\x98
{0x5859,{0x24,0x3f,0x72,0x1e,0x5b,0x1e,0x72}}, // \xe5\xa1\x99
{0x585a,{0x24,0x3f,0x2b,0x5d,0x7d,0x35,0x4b}}, // \xe5\xa1\x9a
{0x585e,{0x56,0x3a,0x5e,0x7b,0x5e,0x3a,0x56}}, // \xe5\xa1\x9e
{0x5862,{0x24,0x3f,0x40,0x1e,0x5b,0x1e,0x70}}, // \xe5\xa1\xa2
{0x5869,{0x24,0x3f,0x44,0x6f,0x6a,0x6e,0x42}}, // \xe5\xa1\xa9
{0x586b,{0x24,0x3f,0x52,0x1e,0x1f,0x1e,0x52}}, // \xe5\xa1\xab
{0x5870,{0x55,0x40,0x4b,0x7e,0x5e,0x5e,0x4a}}, // \xe5\xa1\xb0
{0x5872,{0x24,0x3f,0x24,0x5f,0x3a,0x5e,0x72}}, // \xe5\xa1\xb2
{0x5875,{0x40,0x3e,0x5a,0x56,0x67,0x5e,0x52}}, // \xe5\xa1\xb5
{0x5879,{0x4a,0x4e,0x5f,0x6a,0x47,0x5d,0x45}}, // \xe5\xa1\xb9
{0x587e,{0x52,0x4e,0x5b,0x6e,0x5f,0x5e,0x50}}, // \xe5\xa1\xbe
{0x5883,{0x24,0x3f,0x4a,0x3e,0x3b,0x7e,0x4a}}, // \xe5\xa2\x83
{0x5885,{0x57,0x5f,0x57,0x60,0x55,0x5f,0x4d}}, // \xe5\xa2\x85
{0x5893,{0x2a,0x1a,0x4f,0x6e,0x4f,0x1a,0x2a}}, // \xe5\xa2\x93
{0x5897,{0x24,0x3f,0x0e,0x7b,0x5e,0x7b,0x0e}}, // \xe5\xa2\x97
{0x589c,{0x5f,0x4b,0x4a,0x77,0x5e,0x4b,0x56}}, // \xe5\xa2\x9c
{0x589f,{0x24,0x3f,0x40,0x3c,0x44,0x6f,0x4a}}, // \xe5\xa2\x9f
{0x58a8,{0x54,0x47,0x55,0x67,0x55,0x47,0x54}}, // \xe5\xa2\xa8
{0x58ab,{0x24,0x3f,0x1e,0x3d,0x54,0x7d,0x1e}}, // \xe5\xa2\xab
{0x58ae,{0x5f,0x4b,0x40,0x6a,0x5f,0x5a,0x5a}}, // \xe5\xa2\xae
{0x58b3,{0x24,0x3f,0x4a,0x3e,0x2b,0x3e,0x4a}}, // \xe5\xa2\xb3
{0x58b8,{0x24,0x3f,0x52,0x37,0x7e,0x7f,0x12}}, // \xe5\xa2\xb8
{0x58b9,{0x24,0x3f,0x7f,0x03,0x38,0x3b,0x7f}}, // \xe5\xa2\xb9
{0x58ba,{0x24,0x3f,0x50,0x5e,0x3f,0x56,0x5e}}, // \xe5\xa2\xba
{0x58bb,{0x24,0x3f,0x7a,0x76,0x5b,0x76,0x7a}}, // \xe5\xa2\xbb
{0x58be,{0x4a,0x56,0x5d,0x62,0x5f,0x4b,0x54}}, // \xe5\xa2\xbe
{0x58c1,{0x48,0x5f,0x5b,0x6a,0x4e,0x5b,0x4e}}, // \xe5\xa3\x81
{0x58c5,{0x56,0x4a,0x42,0x6b,0x5e,0x5e,0x56}}, // \xe5\xa3\x85
{0x58c7,{0x24,0x3f,0x4e,0x7e,0x5b,0x7e,0x4e}}, // \xe5\xa3\x87
{0x58ca,{0x24,0x3f,0x32,0x7e,0x5f,0x3a,0x5e}}, // \xe5\xa3\x8a
{0x58cc,{0x24,0x3f,0x1a,0x7e,0x53,0x3e,0x5a}}, // \xe5\xa3\x8c
{0x58d1,{0x56,0x5b,0x5f,0x6a,0x57,0x49,0x57}}, // \xe5\xa3\x91
{0x58d3,{0x50,0x4f,0x5b,0x7b,0x55,0x4f,0x55}}, // \xe5\xa3\x93
{0x58d5,{0x24,0x3f,0x2a,0x5e,0x7b,0x2e,0x5a}}, // \xe5\xa3\x95
{0x58d7,{0x24,0x3f,0x50,0x6a,0x7f,0x6e,0x54}}, // \xe5\xa3\x97
{0x58d8,{0x58,0x5f,0x5d,0x67,0x5d,0x5f,0x58}}, // \xe5\xa3\x98
{0x58d9,{0x24,0x3f,0x3e,0x4a,0x3f,0x3e,0x4a}}, // \xe5\xa3\x99
{0x58dc,{0x24,0x3f,0x4c,0x6f,0x55,0x3f,0x4c}}, // \xe5\xa3\x9c
{0x58de,{0x24,0x3f,0x2a,0x6e,0x5f,0x2a,0x4e}}, // \xe5\xa3\x9e
{0x58df,{0x4a,0x5e,0x4b,0x7e,0x42,0x5b,0x55}}, // \xe5\xa3\x9f
{0x58e4,{0x24,0x3f,0x36,0x7e,0x5b,0x3e,0x56}}, // \xe5\xa3\xa4
{0x58e5,{0x24,0x3f,0x24,0x5f,0x4b,0x63,0x49}}, // \xe5\xa3\xa5
{0x58eb,{0x04,0x44,0x44,0x7f,0x44,0x44,0x04}}, // \xe5\xa3\xab
{0x58ec,{0x08,0x4a,0x4a,0x7e,0x49,0x49,0x08}}, // \xe5\xa3\xac
{0x58ee,{0x14,0x7f,0x04,0x44,0x7f,0x44,0x04}}, // \xe5\xa3\xae
{0x58ef,{0x57,0x34,0x7f,0x04,0x44,0x7f,0x44}}, // \xe5\xa3\xaf
{0x58f0,{0x42,0x3a,0x2a,0x3f,0x2a,0x3a,0x02}}, // \xe5\xa3\xb0
{0x58f1,{0x1a,0x0a,0x7a,0x5f,0x5a,0x4a,0x1a}}, // \xe5\xa3\xb1
{0x58f2,{0x5a,0x4a,0x2a,0x0f,0x6a,0x4a,0x5a}}, // \xe5\xa3\xb2
{0x58f7,{0x5a,0x6a,0x7a,0x6f,0x7a,0x6a,0x5a}}, // \xe5\xa3\xb7
{0x58f9,{0x5a,0x4a,0x7a,0x5f,0x7a,0x4a,0x5a}}, // \xe5\xa3\xb9
{0x58fa,{0x5a,0x6a,0x7a,0x4f,0x7a,0x6a,0x5a}}, // \xe5\xa3\xba
{0x58fb,{0x24,0x3f,0x14,0x09,0x77,0x2d,0x7b}}, // \xe5\xa3\xbb
{0x58fc,{0x5a,0x6a,0x7a,0x5f,0x7a,0x6a,0x5a}}, // \xe5\xa3\xbc
{0x58fd,{0x14,0x76,0x76,0x1f,0x56,0x76,0x14}}, // \xe5\xa3\xbd
{0x5902,{0x48,0x44,0x2b,0x12,0x2a,0x46,0x40}}, // \xe5\xa4\x82
{0x5909,{0x4a,0x52,0x5e,0x2b,0x5e,0x42,0x4a}}, // \xe5\xa4\x89
{0x590a,{0x4a,0x44,0x2b,0x12,0x2a,0x46,0x40}}, // \xe5\xa4\x8a
{0x590f,{0x41,0x51,0x5f,0x2f,0x5f,0x41,0x41}}, // \xe5\xa4\x8f
{0x5910,{0x42,0x52,0x5d,0x2f,0x5f,0x4e,0x40}}, // \xe5\xa4\x90
{0x5915,{0x08,0x48,0x44,0x4b,0x2a,0x12,0x0e}}, // \xe5\xa4\x95
{0x5916,{0x48,0x47,0x2a,0x1e,0x7f,0x08,0x10}}, // \xe5\xa4\x96
{0x5918,{0x48,0x47,0x2a,0x1e,0x7f,0x01,0x1f}}, // \xe5\xa4\x98
{0x5919,{0x40,0x3f,0x53,0x2f,0x1b,0x7f,0x40}}, // \xe5\xa4\x99
{0x591a,{0x08,0x4a,0x5a,0x55,0x2b,0x28,0x18}}, // \xe5\xa4\x9a
{0x591b,{0x44,0x54,0x55,0x2d,0x2f,0x1c,0x04}}, // \xe5\xa4\x9b
{0x591c,{0x12,0x7a,0x06,0x53,0x5e,0x2a,0x5a}}, // \xe5\xa4\x9c
{0x5922,{0x1a,0x4e,0x5b,0x6e,0x3b,0x0e,0x1a}}, // \xe5\xa4\xa2
{0x5925,{0x57,0x35,0x7f,0x37,0x52,0x2d,0x1b}}, // \xe5\xa4\xa5
{0x5927,{0x44,0x44,0x24,0x1f,0x24,0x44,0x44}}, // \xe5\xa4\xa7
{0x5929,{0x41,0x45,0x25,0x1f,0x25,0x45,0x41}}, // \xe5\xa4\xa9
{0x592a,{0x44,0x44,0x24,0x5f,0x24,0x44,0x44}}, // \xe5\xa4\xaa
{0x592b,{0x48,0x4a,0x2a,0x1f,0x2a,0x4a,0x48}}, // \xe5\xa4\xab
{0x592c,{0x48,0x4a,0x2a,0x1f,0x2a,0x4e,0x48}}, // \xe5\xa4\xac
{0x592d,{0x48,0x4a,0x2a,0x1e,0x29,0x49,0x48}}, // \xe5\xa4\xad
{0x592e,{0x48,0x4e,0x2a,0x1f,0x2a,0x4e,0x48}}, // \xe5\xa4\xae
{0x5931,{0x4c,0x4b,0x2a,0x1f,0x2a,0x4a,0x48}}, // \xe5\xa4\xb1
{0x5932,{0x2a,0x2a,0x26,0x73,0x26,0x2a,0x2a}}, // \xe5\xa4\xb2
{0x5937,{0x42,0x5e,0x56,0x3f,0x56,0x76,0x42}}, // \xe5\xa4\xb7
{0x5938,{0x0a,0x1a,0x16,0x53,0x56,0x7a,0x0a}}, // \xe5\xa4\xb8
{0x593e,{0x52,0x4e,0x52,0x3f,0x52,0x4e,0x52}}, // \xe5\xa4\xbe
{0x5944,{0x0a,0x3a,0x36,0x3b,0x76,0x7a,0x4a}}, // \xe5\xa5\x84
{0x5947,{0x10,0x72,0x5a,0x77,0x1a,0x72,0x10}}, // \xe5\xa5\x87
{0x5948,{0x4a,0x3a,0x56,0x73,0x16,0x3a,0x4a}}, // \xe5\xa5\x88
{0x5949,{0x28,0x1a,0x2e,0x7f,0x2e,0x1a,0x28}}, // \xe5\xa5\x89
{0x594e,{0x4a,0x4a,0x56,0x7b,0x56,0x4a,0x4a}}, // \xe5\xa5\x8e
{0x594f,{0x28,0x1a,0x4e,0x3f,0x4e,0x1a,0x28}}, // \xe5\xa5\x8f
{0x5950,{0x52,0x5e,0x5d,0x35,0x5f,0x5c,0x50}}, // \xe5\xa5\x90
{0x5951,{0x4a,0x5f,0x5a,0x39,0x57,0x59,0x4f}}, // \xe5\xa5\x91
{0x5954,{0x2a,0x6a,0x36,0x3b,0x76,0x2a,0x2a}}, // \xe5\xa5\x94
{0x5955,{0x4a,0x52,0x5e,0x33,0x5e,0x52,0x4a}}, // \xe5\xa5\x95
{0x5957,{0x5a,0x56,0x7e,0x5b,0x52,0x36,0x5a}}, // \xe5\xa5\x97
{0x5958,{0x4b,0x56,0x5f,0x32,0x5a,0x5f,0x4a}}, // \xe5\xa5\x98
{0x595a,{0x54,0x53,0x55,0x3b,0x51,0x59,0x52}}, // \xe5\xa5\x9a
{0x5960,{0x52,0x5e,0x5d,0x34,0x5d,0x5e,0x52}}, // \xe5\xa5\xa0
{0x5962,{0x4a,0x5a,0x36,0x7b,0x56,0x7a,0x1a}}, // \xe5\xa5\xa2
{0x5965,{0x50,0x5e,0x5a,0x3f,0x56,0x5e,0x50}}, // \xe5\xa5\xa5
{0x5967,{0x50,0x5e,0x5e,0x3f,0x56,0x5e,0x50}}, // \xe5\xa5\xa7
{0x5968,{0x4a,0x5f,0x50,0x35,0x57,0x5d,0x57}}, // \xe5\xa5\xa8
{0x5969,{0x0a,0x7a,0x66,0x7b,0x5a,0x66,0x6a}}, // \xe5\xa5\xa9
{0x596a,{0x1a,0x16,0x3e,0x5f,0x7a,0x16,0x1a}}, // \xe5\xa5\xaa
{0x596c,{0x5b,0x56,0x5f,0x36,0x5d,0x5f,0x54}}, // \xe5\xa5\xac
{0x596e,{0x0a,0x76,0x5e,0x7f,0x5a,0x76,0x0a}}, // \xe5\xa5\xae
{0x5973,{0x44,0x54,0x5c,0x27,0x34,0x4c,0x44}}, // \xe5\xa5\xb3
{0x5974,{0x44,0x5c,0x37,0x2c,0x4d,0x31,0x4f}}, // \xe5\xa5\xb4
{0x5978,{0x44,0x5c,0x37,0x2c,0x09,0x7f,0x09}}, // \xe5\xa5\xb8
{0x597d,{0x44,0x5c,0x37,0x2c,0x49,0x7d,0x0b}}, // \xe5\xa5\xbd
{0x5981,{0x44,0x5c,0x37,0x2c,0x0b,0x52,0x7e}}, // \xe5\xa6\x81
{0x5982,{0x44,0x5c,0x37,0x2c,0x7e,0x42,0x7e}}, // \xe5\xa6\x82
{0x5983,{0x44,0x5c,0x37,0x2c,0x79,0x49,0x6f}}, // \xe5\xa6\x83
{0x5984,{0x52,0x5e,0x7a,0x5b,0x3a,0x5a,0x52}}, // \xe5\xa6\x84
{0x598a,{0x44,0x5c,0x37,0x2c,0x4a,0x7e,0x49}}, // \xe5\xa6\x8a
{0x598d,{0x5f,0x3c,0x49,0x3f,0x09,0x7f,0x09}}, // \xe5\xa6\x8d
{0x5993,{0x44,0x5c,0x37,0x4c,0x5a,0x2f,0x5a}}, // \xe5\xa6\x93
{0x5996,{0x44,0x5c,0x37,0x2c,0x4a,0x3e,0x49}}, // \xe5\xa6\x96
{0x5999,{0x5c,0x37,0x2c,0x46,0x5f,0x22,0x14}}, // \xe5\xa6\x99
{0x599b,{0x54,0x57,0x76,0x5f,0x36,0x57,0x54}}, // \xe5\xa6\x9b
{0x599d,{0x57,0x34,0x7f,0x44,0x5c,0x37,0x4c}}, // \xe5\xa6\x9d
{0x59a3,{0x5c,0x37,0x4c,0x7f,0x24,0x7f,0x44}}, // \xe5\xa6\xa3
{0x59a5,{0x4a,0x4e,0x5a,0x2e,0x39,0x4d,0x49}}, // \xe5\xa6\xa5
{0x59a8,{0x5c,0x37,0x2c,0x42,0x3e,0x4b,0x7a}}, // \xe5\xa6\xa8
{0x59ac,{0x5c,0x37,0x2c,0x11,0x7f,0x49,0x79}}, // \xe5\xa6\xac
{0x59b2,{0x44,0x5c,0x37,0x2c,0x5f,0x55,0x5f}}, // \xe5\xa6\xb2
{0x59b9,{0x5c,0x37,0x4c,0x2a,0x7f,0x2a,0x48}}, // \xe5\xa6\xb9
{0x59bb,{0x52,0x5a,0x7a,0x5f,0x3a,0x5e,0x52}}, // \xe5\xa6\xbb
{0x59be,{0x48,0x5a,0x7e,0x5b,0x3e,0x5a,0x48}}, // \xe5\xa6\xbe
{0x59c6,{0x5c,0x37,0x2c,0x3f,0x69,0x7f,0x28}}, // \xe5\xa7\x86
{0x59c9,{0x5c,0x37,0x2c,0x3a,0x0a,0x7f,0x3a}}, // \xe5\xa7\x89
{0x59cb,{0x44,0x5c,0x37,0x2c,0x6c,0x6b,0x6c}}, // \xe5\xa7\x8b
{0x59d0,{0x5c,0x37,0x4c,0x7f,0x55,0x7f,0x40}}, // \xe5\xa7\x90
{0x59d1,{0x44,0x5c,0x37,0x2c,0x74,0x5f,0x74}}, // \xe5\xa7\x91
{0x59d3,{0x44,0x5c,0x37,0x4c,0x53,0x7f,0x52}}, // \xe5\xa7\x93
{0x59d4,{0x4a,0x5a,0x77,0x5f,0x37,0x5a,0x4a}}, // \xe5\xa7\x94
{0x59d9,{0x5f,0x3c,0x7e,0x01,0x4a,0x7e,0x49}}, // \xe5\xa7\x99
{0x59da,{0x5f,0x3c,0x4a,0x3f,0x00,0x7f,0x4a}}, // \xe5\xa7\x9a
{0x59dc,{0x52,0x56,0x77,0x5e,0x36,0x57,0x52}}, // \xe5\xa7\x9c
{0x59e5,{0x5c,0x37,0x2c,0x1a,0x6f,0x5a,0x49}}, // \xe5\xa7\xa5
{0x59e6,{0x52,0x3a,0x5e,0x3b,0x56,0x3a,0x52}}, // \xe5\xa7\xa6
{0x59e8,{0x5f,0x3c,0x42,0x5e,0x3f,0x56,0x72}}, // \xe5\xa7\xa8
{0x59ea,{0x5c,0x37,0x2c,0x45,0x57,0x7d,0x55}}, // \xe5\xa7\xaa
{0x59eb,{0x5c,0x37,0x2c,0x7f,0x55,0x77,0x5d}}, // \xe5\xa7\xab
{0x59f6,{0x44,0x5c,0x37,0x2c,0x76,0x55,0x76}}, // \xe5\xa7\xb6
{0x59fb,{0x5f,0x3c,0x7f,0x55,0x4f,0x55,0x7f}}, // \xe5\xa7\xbb
{0x59ff,{0x55,0x50,0x74,0x5b,0x36,0x5a,0x56}}, // \xe5\xa7\xbf
{0x5a01,{0x40,0x3e,0x56,0x2e,0x56,0x3f,0x52}}, // \xe5\xa8\x81
{0x5a03,{0x44,0x5c,0x37,0x4c,0x5a,0x7f,0x5a}}, // \xe5\xa8\x83
{0x5a09,{0x44,0x5c,0x37,0x2c,0x1e,0x5f,0x6e}}, // \xe5\xa8\x89
{0x5a11,{0x55,0x50,0x7a,0x58,0x37,0x54,0x52}}, // \xe5\xa8\x91
{0x5a18,{0x5c,0x37,0x2c,0x7e,0x5a,0x3b,0x5e}}, // \xe5\xa8\x98
{0x5a1a,{0x5c,0x37,0x2c,0x5f,0x35,0x5f,0x7f}}, // \xe5\xa8\x9a
{0x5a1c,{0x5f,0x3c,0x55,0x3f,0x55,0x7f,0x1b}}, // \xe5\xa8\x9c
{0x5a1f,{0x5c,0x37,0x2c,0x78,0x2b,0x2b,0x78}}, // \xe5\xa8\x9f
{0x5a20,{0x5c,0x37,0x2c,0x7f,0x51,0x35,0x55}}, // \xe5\xa8\xa0
{0x5a25,{0x5f,0x3c,0x26,0x7e,0x25,0x3f,0x55}}, // \xe5\xa8\xa5
{0x5a29,{0x5c,0x37,0x2c,0x5e,0x3d,0x77,0x5c}}, // \xe5\xa8\xa9
{0x5a2f,{0x5c,0x37,0x2c,0x56,0x14,0x1f,0x53}}, // \xe5\xa8\xaf
{0x5a35,{0x5f,0x3c,0x21,0x3f,0x7f,0x12,0x2e}}, // \xe5\xa8\xb5
{0x5a36,{0x55,0x57,0x7f,0x55,0x3b,0x55,0x5b}}, // \xe5\xa8\xb6
{0x5a3c,{0x5c,0x37,0x2c,0x7c,0x57,0x57,0x7c}}, // \xe5\xa8\xbc
{0x5a40,{0x5f,0x3c,0x7f,0x1b,0x1d,0x55,0x7f}}, // \xe5\xa9\x80
{0x5a41,{0x54,0x5e,0x76,0x5f,0x36,0x5e,0x54}}, // \xe5\xa9\x81
{0x5a46,{0x55,0x50,0x78,0x56,0x3a,0x57,0x5a}}, // \xe5\xa9\x86
{0x5a49,{0x5f,0x3c,0x56,0x2a,0x7b,0x4a,0x5e}}, // \xe5\xa9\x89
{0x5a5a,{0x5c,0x37,0x2c,0x1f,0x75,0x6f,0x15}}, // \xe5\xa9\x9a
{0x5a62,{0x5f,0x3c,0x2e,0x3a,0x2f,0x7a,0x2e}}, // \xe5\xa9\xa2
{0x5a66,{0x5c,0x37,0x2c,0x35,0x7d,0x37,0x0c}}, // \xe5\xa9\xa6
{0x5a6a,{0x4a,0x56,0x7f,0x5a,0x36,0x5f,0x4a}}, // \xe5\xa9\xaa
{0x5a6c,{0x5f,0x3c,0x4a,0x59,0x7b,0x59,0x4a}}, // \xe5\xa9\xac
{0x5a7f,{0x5c,0x37,0x2c,0x09,0x77,0x2d,0x7b}}, // \xe5\xa9\xbf
{0x5a92,{0x5f,0x3c,0x52,0x3f,0x7a,0x3f,0x52}}, // \xe5\xaa\x92
{0x5a9a,{0x5c,0x37,0x4c,0x3f,0x05,0x77,0x77}}, // \xe5\xaa\x9a
{0x5a9b,{0x5c,0x37,0x4c,0x2a,0x5e,0x29,0x5d}}, // \xe5\xaa\x9b
{0x5abc,{0x5c,0x37,0x2c,0x4f,0x6d,0x6b,0x4f}}, // \xe5\xaa\xbc
{0x5abd,{0x5c,0x37,0x2c,0x5f,0x15,0x5f,0x75}}, // \xe5\xaa\xbd
{0x5abe,{0x5f,0x3c,0x2a,0x7f,0x3a,0x7f,0x2a}}, // \xe5\xaa\xbe
{0x5ac1,{0x5f,0x3c,0x26,0x5a,0x7b,0x2a,0x56}}, // \xe5\xab\x81
{0x5ac2,{0x5f,0x3c,0x4e,0x59,0x2e,0x59,0x4f}}, // \xe5\xab\x82
{0x5ac9,{0x5f,0x3c,0x54,0x3e,0x5a,0x33,0x52}}, // \xe5\xab\x89
{0x5acb,{0x5c,0x37,0x2c,0x5d,0x77,0x5d,0x77}}, // \xe5\xab\x8b
{0x5acc,{0x5f,0x3c,0x52,0x37,0x7e,0x3f,0x4a}}, // \xe5\xab\x8c
{0x5ad0,{0x5f,0x3c,0x47,0x3f,0x76,0x3f,0x5c}}, // \xe5\xab\x90
{0x5ad6,{0x5f,0x3c,0x51,0x17,0x77,0x17,0x51}}, // \xe5\xab\x96
{0x5ad7,{0x5f,0x3c,0x7f,0x71,0x47,0x77,0x71}}, // \xe5\xab\x97
{0x5ae1,{0x5f,0x3c,0x7a,0x6e,0x5b,0x6e,0x7a}}, // \xe5\xab\xa1
{0x5ae3,{0x5c,0x37,0x2c,0x5d,0x19,0x5f,0x75}}, // \xe5\xab\xa3
{0x5ae6,{0x5f,0x3c,0x35,0x1e,0x7b,0x1e,0x35}}, // \xe5\xab\xa6
{0x5ae9,{0x5f,0x3c,0x2e,0x7f,0x2a,0x3f,0x5e}}, // \xe5\xab\xa9
{0x5afa,{0x5f,0x3c,0x7f,0x23,0x18,0x3b,0x7f}}, // \xe5\xab\xba
{0x5afb,{0x5f,0x3c,0x7f,0x2b,0x7c,0x2b,0x7f}}, // \xe5\xab\xbb
{0x5b09,{0x5f,0x3c,0x12,0x7e,0x57,0x7e,0x12}}, // \xe5\xac\x89
{0x5b0b,{0x5f,0x3c,0x23,0x3f,0x7c,0x3f,0x23}}, // \xe5\xac\x8b
{0x5b0c,{0x5f,0x3c,0x7a,0x17,0x5b,0x17,0x7a}}, // \xe5\xac\x8c
{0x5b16,{0x54,0x5f,0x7b,0x50,0x36,0x5b,0x56}}, // \xe5\xac\x96
{0x5b22,{0x5f,0x3c,0x1a,0x7e,0x53,0x3e,0x5a}}, // \xe5\xac\xa2
{0x5b2a,{0x5f,0x3c,0x4e,0x3a,0x37,0x3a,0x46}}, // \xe5\xac\xaa
{0x5b2c,{0x5f,0x3c,0x66,0x2b,0x7f,0x2b,0x66}}, // \xe5\xac\xac
{0x5b30,{0x54,0x53,0x7b,0x54,0x33,0x53,0x54}}, // \xe5\xac\xb0
{0x5b32,{0x57,0x3f,0x5c,0x37,0x4c,0x3f,0x77}}, // \xe5\xac\xb2
{0x5b36,{0x5c,0x37,0x3c,0x6e,0x3b,0x6e,0x38}}, // \xe5\xac\xb6
{0x5b3e,{0x5f,0x3c,0x2e,0x7f,0x5a,0x19,0x5b}}, // \xe5\xac\xbe
{0x5b40,{0x5f,0x3c,0x26,0x73,0x27,0x73,0x76}}, // \xe5\xad\x80
{0x5b43,{0x5f,0x3c,0x36,0x7e,0x5b,0x3e,0x56}}, // \xe5\xad\x83
{0x5b45,{0x5f,0x3c,0x55,0x7e,0x55,0x3f,0x54}}, // \xe5\xad\x85
{0x5b50,{0x08,0x09,0x49,0x7d,0x0b,0x09,0x08}}, // \xe5\xad\x90
{0x5b51,{0x10,0x11,0x51,0x7d,0x0b,0x09,0x08}}, // \xe5\xad\x91
{0x5b54,{0x51,0x7d,0x0b,0x00,0x7f,0x40,0x60}}, // \xe5\xad\x94
{0x5b55,{0x28,0x29,0x27,0x69,0x3b,0x2a,0x26}}, // \xe5\xad\x95
{0x5b57,{0x16,0x12,0x56,0x77,0x1e,0x12,0x16}}, // \xe5\xad\x97
{0x5b58,{0x12,0x7a,0x17,0x52,0x76,0x1e,0x12}}, // \xe5\xad\x98
{0x5b5a,{0x14,0x13,0x55,0x77,0x1d,0x11,0x12}}, // \xe5\xad\x9a
{0x5b5b,{0x2c,0x26,0x2e,0x6f,0x3e,0x26,0x2c}}, // \xe5\xad\x9b
{0x5b5c,{0x51,0x7d,0x0b,0x44,0x5f,0x22,0x5e}}, // \xe5\xad\x9c
{0x5b5d,{0x28,0x2a,0x1a,0x2f,0x6e,0x3a,0x29}}, // \xe5\xad\x9d
{0x5b5f,{0x44,0x75,0x55,0x7d,0x57,0x75,0x44}}, // \xe5\xad\x9f
{0x5b63,{0x2a,0x2a,0x27,0x6f,0x3f,0x26,0x2a}}, // \xe5\xad\xa3
{0x5b64,{0x51,0x7d,0x4b,0x3e,0x42,0x3e,0x61}}, // \xe5\xad\xa4
{0x5b65,{0x2a,0x2e,0x2b,0x6e,0x3b,0x25,0x2b}}, // \xe5\xad\xa5
{0x5b66,{0x16,0x13,0x56,0x77,0x1e,0x13,0x16}}, // \xe5\xad\xa6
{0x5b69,{0x51,0x7d,0x4b,0x56,0x2b,0x32,0x4a}}, // \xe5\xad\xa9
{0x5b6b,{0x51,0x7d,0x0b,0x50,0x15,0x7b,0x51}}, // \xe5\xad\xab
{0x5b70,{0x22,0x2e,0x6b,0x3e,0x13,0x7e,0x40}}, // \xe5\xad\xb0
{0x5b71,{0x40,0x3f,0x6b,0x3b,0x0f,0x6f,0x3b}}, // \xe5\xad\xb1
{0x5b73,{0x22,0x2a,0x37,0x72,0x3a,0x37,0x22}}, // \xe5\xad\xb3
{0x5b75,{0x5e,0x3d,0x7e,0x21,0x6b,0x39,0x22}}, // \xe5\xad\xb5
{0x5b78,{0x2c,0x26,0x2d,0x6e,0x3d,0x27,0x2c}}, // \xe5\xad\xb8
{0x5b7a,{0x51,0x7d,0x0b,0x66,0x2b,0x7f,0x6e}}, // \xe5\xad\xba
{0x5b80,{0x0c,0x04,0x04,0x06,0x04,0x04,0x0c}}, // \xe5\xae\x80
{0x5b83,{0x06,0x3a,0x52,0x53,0x4a,0x4a,0x66}}, // \xe5\xae\x83
{0x5b85,{0x16,0x12,0x16,0x7f,0x56,0x52,0x56}}, // \xe5\xae\x85
{0x5b87,{0x16,0x12,0x56,0x7f,0x16,0x12,0x16}}, // \xe5\xae\x87
{0x5b88,{0x16,0x12,0x32,0x53,0x7a,0x12,0x16}}, // \xe5\xae\x88
{0x5b89,{0x46,0x4a,0x5a,0x2f,0x3a,0x4a,0x46}}, // \xe5\xae\x89
{0x5b8b,{0x46,0x4a,0x2a,0x7f,0x2a,0x4a,0x46}}, // \xe5\xae\x8b
{0x5b8c,{0x56,0x52,0x36,0x17,0x76,0x52,0x56}}, // \xe5\xae\x8c
{0x5b8d,{0x56,0x52,0x12,0x1b,0x12,0x52,0x56}}, // \xe5\xae\x8d
{0x5b8f,{0x2e,0x5a,0x6e,0x5b,0x4a,0x2a,0x46}}, // \xe5\xae\x8f
{0x5b95,{0x2e,0x1a,0x6a,0x6b,0x6a,0x6a,0x06}}, // \xe5\xae\x95
{0x5b97,{0x56,0x32,0x56,0x77,0x16,0x32,0x56}}, // \xe5\xae\x97
{0x5b98,{0x06,0x02,0x7e,0x57,0x5e,0x72,0x06}}, // \xe5\xae\x98
{0x5b99,{0x06,0x7a,0x5a,0x7f,0x5a,0x7a,0x06}}, // \xe5\xae\x99
{0x5b9a,{0x46,0x32,0x46,0x7f,0x56,0x52,0x46}}, // \xe5\xae\x9a
{0x5b9b,{0x56,0x5a,0x2a,0x1b,0x7a,0x4a,0x5e}}, // \xe5\xae\x9b
{0x5b9c,{0x46,0x42,0x7e,0x57,0x7e,0x42,0x46}}, // \xe5\xae\x9c
{0x5b9d,{0x46,0x42,0x56,0x7f,0x56,0x62,0x46}}, // \xe5\xae\x9d
{0x5b9f,{0x56,0x52,0x56,0x3f,0x56,0x52,0x56}}, // \xe5\xae\x9f
{0x5ba2,{0x26,0x2a,0x6a,0x57,0x6e,0x22,0x26}}, // \xe5\xae\xa2
{0x5ba3,{0x46,0x42,0x76,0x57,0x76,0x42,0x46}}, // \xe5\xae\xa3
{0x5ba4,{0x46,0x52,0x5e,0x77,0x4a,0x52,0x46}}, // \xe5\xae\xa4
{0x5ba5,{0x2e,0x1a,0x7e,0x2b,0x2a,0x7a,0x0e}}, // \xe5\xae\xa5
{0x5ba6,{0x06,0x7e,0x56,0x77,0x5e,0x42,0x06}}, // \xe5\xae\xa6
{0x5bae,{0x06,0x62,0x6e,0x7b,0x6e,0x62,0x06}}, // \xe5\xae\xae
{0x5bb0,{0x26,0x2a,0x3a,0x6f,0x3a,0x2a,0x26}}, // \xe5\xae\xb0
{0x5bb3,{0x26,0x2a,0x6a,0x7f,0x6a,0x2a,0x26}}, // \xe5\xae\xb3
{0x5bb4,{0x56,0x52,0x7e,0x5b,0x3e,0x52,0x56}}, // \xe5\xae\xb4
{0x5bb5,{0x06,0x7a,0x2e,0x2f,0x2a,0x7e,0x06}}, // \xe5\xae\xb5
{0x5bb6,{0x56,0x52,0x2e,0x5f,0x76,0x22,0x56}}, // \xe5\xae\xb6
{0x5bb8,{0x46,0x3e,0x76,0x57,0x36,0x52,0x46}}, // \xe5\xae\xb8
{0x5bb9,{0x26,0x2a,0x76,0x6b,0x76,0x2a,0x26}}, // \xe5\xae\xb9
{0x5bbf,{0x16,0x7a,0x02,0x6b,0x7a,0x6a,0x6e}}, // \xe5\xae\xbf
{0x5bc2,{0x56,0x12,0x7e,0x17,0x5a,0x2a,0x5e}}, // \xe5\xaf\x82
{0x5bc3,{0x4e,0x5a,0x36,0x1f,0x76,0x5e,0x66}}, // \xe5\xaf\x83
{0x5bc4,{0x16,0x72,0x5a,0x77,0x1a,0x72,0x16}}, // \xe5\xaf\x84
{0x5bc5,{0x46,0x7a,0x2e,0x3f,0x2e,0x7a,0x46}}, // \xe5\xaf\x85
{0x5bc6,{0x16,0x6a,0x5e,0x73,0x56,0x62,0x16}}, // \xe5\xaf\x86
{0x5bc7,{0x56,0x36,0x56,0x63,0x5e,0x6a,0x46}}, // \xe5\xaf\x87
{0x5bc9,{0x26,0x12,0x7e,0x5b,0x7e,0x5a,0x56}}, // \xe5\xaf\x89
{0x5bcc,{0x06,0x72,0x5e,0x7b,0x5e,0x72,0x06}}, // \xe5\xaf\x8c
{0x5bd0,{0x56,0x36,0x7e,0x2b,0x7e,0x2a,0x46}}, // \xe5\xaf\x90
{0x5bd2,{0x26,0x1a,0x3e,0x3b,0x5e,0x1a,0x26}}, // \xe5\xaf\x92
{0x5bd3,{0x76,0x12,0x5e,0x7f,0x3e,0x52,0x76}}, // \xe5\xaf\x93
{0x5bd4,{0x46,0x2a,0x4e,0x7b,0x5e,0x4a,0x46}}, // \xe5\xaf\x94
{0x5bdb,{0x46,0x4a,0x3e,0x3b,0x7e,0x4a,0x66}}, // \xe5\xaf\x9b
{0x5bdd,{0x2e,0x7a,0x02,0x5b,0x5a,0x2e,0x5e}}, // \xe5\xaf\x9d
{0x5bde,{0x56,0x5a,0x5e,0x3b,0x5e,0x5a,0x56}}, // \xe5\xaf\x9e
{0x5bdf,{0x56,0x2e,0x56,0x73,0x16,0x2a,0x56}}, // \xe5\xaf\x9f
{0x5be1,{0x56,0x32,0x5e,0x3b,0x7e,0x32,0x56}}, // \xe5\xaf\xa1
{0x5be2,{0x56,0x36,0x7e,0x03,0x5a,0x2a,0x5e}}, // \xe5\xaf\xa2
{0x5be4,{0x56,0x36,0x7e,0x2b,0x7e,0x7a,0x26}}, // \xe5\xaf\xa4
{0x5be5,{0x16,0x12,0x4e,0x57,0x2a,0x16,0x16}}, // \xe5\xaf\xa5
{0x5be6,{0x46,0x4a,0x3e,0x37,0x3e,0x4a,0x46}}, // \xe5\xaf\xa6
{0x5be7,{0x16,0x1a,0x56,0x7b,0x1e,0x1a,0x16}}, // \xe5\xaf\xa7
{0x5be8,{0x36,0x5a,0x3e,0x7b,0x3e,0x5a,0x36}}, // \xe5\xaf\xa8
{0x5be9,{0x56,0x3a,0x76,0x7f,0x76,0x3a,0x56}}, // \xe5\xaf\xa9
{0x5beb,{0x26,0x5a,0x16,0x53,0x1e,0x52,0x76}}, // \xe5\xaf\xab
{0x5bee,{0x56,0x0a,0x3e,0x6b,0x3e,0x0a,0x56}}, // \xe5\xaf\xae
{0x5bf0,{0x26,0x2a,0x7e,0x5f,0x3e,0x5a,0x46}}, // \xe5\xaf\xb0
{0x5bf3,{0x56,0x7e,0x36,0x3b,0x36,0x7a,0x46}}, // \xe5\xaf\xb3
{0x5bf5,{0x0e,0x7a,0x2e,0x7b,0x0a,0x6e,0x56}}, // \xe5\xaf\xb5
{0x5bf6,{0x56,0x7e,0x36,0x33,0x3e,0x7a,0x46}}, // \xe5\xaf\xb6
{0x5bf8,{0x02,0x02,0x0a,0x52,0x7f,0x02,0x02}}, // \xe5\xaf\xb8
{0x5bfa,{0x28,0x2a,0x6a,0x2f,0x7a,0x2a,0x28}}, // \xe5\xaf\xba
{0x5bfe,{0x42,0x2a,0x13,0x2e,0x0a,0x52,0x7f}}, // \xe5\xaf\xbe
{0x5bff,{0x54,0x36,0x1e,0x57,0x16,0x7e,0x14}}, // \xe5\xaf\xbf
{0x5c01,{0x48,0x5a,0x3f,0x2a,0x0a,0x52,0x7f}}, // \xe5\xb0\x81
{0x5c02,{0x12,0x12,0x3e,0x5f,0x7e,0x12,0x12}}, // \xe5\xb0\x82
{0x5c04,{0x50,0x5e,0x2b,0x7e,0x0a,0x52,0x7f}}, // \xe5\xb0\x84
{0x5c05,{0x5a,0x37,0x5a,0x40,0x4a,0x62,0x7f}}, // \xe5\xb0\x85
{0x5c06,{0x14,0x7f,0x16,0x32,0x56,0x79,0x15}}, // \xe5\xb0\x86
{0x5c07,{0x57,0x34,0x7f,0x08,0x2a,0x4d,0x7b}}, // \xe5\xb0\x87
{0x5c08,{0x12,0x12,0x3e,0x5f,0x76,0x1a,0x12}}, // \xe5\xb0\x88
{0x5c09,{0x40,0x3f,0x6b,0x2b,0x02,0x5a,0x7f}}, // \xe5\xb0\x89
{0x5c0a,{0x12,0x1e,0x3b,0x56,0x7e,0x1f,0x12}}, // \xe5\xb0\x8a
{0x5c0b,{0x14,0x1d,0x35,0x51,0x7d,0x17,0x1c}}, // \xe5\xb0\x8b
{0x5c0d,{0x4b,0x5e,0x3b,0x2e,0x09,0x52,0x7f}}, // \xe5\xb0\x8d
{0x5c0e,{0x14,0x1d,0x32,0x5f,0x7e,0x1f,0x12}}, // \xe5\xb0\x8e
{0x5c0f,{0x10,0x0c,0x40,0x7f,0x00,0x04,0x18}}, // \xe5\xb0\x8f
{0x5c11,{0x48,0x46,0x50,0x3f,0x20,0x12,0x04}}, // \xe5\xb0\x91
{0x5c13,{0x24,0x1b,0x42,0x7e,0x02,0x0a,0x32}}, // \xe5\xb0\x93
{0x5c16,{0x54,0x52,0x58,0x3f,0x50,0x52,0x54}}, // \xe5\xb0\x96
{0x5c1a,{0x7c,0x05,0x74,0x57,0x74,0x05,0x7c}}, // \xe5\xb0\x9a
{0x5c20,{0x72,0x5f,0x72,0x5f,0x46,0x2f,0x14}}, // \xe5\xb0\xa0
{0x5c22,{0x42,0x42,0x22,0x1f,0x7a,0x42,0x62}}, // \xe5\xb0\xa2
{0x5c24,{0x42,0x42,0x22,0x1f,0x7a,0x43,0x62}}, // \xe5\xb0\xa4
{0x5c28,{0x42,0x3f,0x7a,0x43,0x40,0x6a,0x55}}, // \xe5\xb0\xa8
{0x5c2d,{0x54,0x56,0x3e,0x17,0x7e,0x56,0x54}}, // \xe5\xb0\xad
{0x5c31,{0x22,0x4e,0x7b,0x2e,0x44,0x3f,0x45}}, // \xe5\xb0\xb1
{0x5c38,{0x40,0x3f,0x05,0x05,0x05,0x05,0x07}}, // \xe5\xb0\xb8
{0x5c39,{0x44,0x55,0x35,0x1f,0x15,0x1f,0x04}}, // \xe5\xb0\xb9
{0x5c3a,{0x40,0x3f,0x05,0x0d,0x15,0x27,0x40}}, // \xe5\xb0\xba
{0x5c3b,{0x40,0x3f,0x55,0x3d,0x15,0x75,0x47}}, // \xe5\xb0\xbb
{0x5c3c,{0x40,0x3f,0x05,0x7d,0x55,0x55,0x57}}, // \xe5\xb0\xbc
{0x5c3d,{0x20,0x1f,0x25,0x2d,0x45,0x1b,0x20}}, // \xe5\xb0\xbd
{0x5c3e,{0x40,0x3f,0x2b,0x2b,0x7f,0x57,0x53}}, // \xe5\xb0\xbe
{0x5c3f,{0x40,0x3f,0x55,0x35,0x7d,0x25,0x57}}, // \xe5\xb0\xbf
{0x5c40,{0x40,0x3f,0x75,0x55,0x75,0x07,0x7c}}, // \xe5\xb1\x80
{0x5c41,{0x40,0x3f,0x7d,0x55,0x05,0x7d,0x57}}, // \xe5\xb1\x81
{0x5c45,{0x40,0x3f,0x0b,0x6b,0x7f,0x6b,0x0b}}, // \xe5\xb1\x85
{0x5c46,{0x40,0x3f,0x7b,0x53,0x7f,0x53,0x7b}}, // \xe5\xb1\x86
{0x5c48,{0x40,0x3f,0x65,0x4d,0x7d,0x4d,0x67}}, // \xe5\xb1\x88
{0x5c4a,{0x40,0x3f,0x75,0x55,0x7d,0x55,0x77}}, // \xe5\xb1\x8a
{0x5c4b,{0x40,0x3f,0x55,0x5d,0x75,0x4d,0x57}}, // \xe5\xb1\x8b
{0x5c4d,{0x40,0x3f,0x55,0x2d,0x1d,0x7d,0x57}}, // \xe5\xb1\x8d
{0x5c4e,{0x40,0x3f,0x53,0x37,0x7f,0x33,0x57}}, // \xe5\xb1\x8e
{0x5c4f,{0x40,0x3f,0x6b,0x3f,0x2b,0x7f,0x2b}}, // \xe5\xb1\x8f
{0x5c50,{0x40,0x3f,0x2b,0x77,0x5b,0x2f,0x5b}}, // \xe5\xb1\x90
{0x5c51,{0x40,0x3f,0x07,0x7b,0x2f,0x2b,0x7f}}, // \xe5\xb1\x91
{0x5c53,{0x40,0x3f,0x43,0x3f,0x2b,0x3f,0x43}}, // \xe5\xb1\x93
{0x5c55,{0x40,0x3f,0x75,0x5d,0x35,0x5d,0x57}}, // \xe5\xb1\x95
{0x5c5e,{0x40,0x3f,0x73,0x5b,0x7f,0x3f,0x73}}, // \xe5\xb1\x9e
{0x5c60,{0x40,0x3f,0x53,0x37,0x7f,0x77,0x13}}, // \xe5\xb1\xa0
{0x5c61,{0x40,0x3f,0x57,0x7b,0x5f,0x3b,0x57}}, // \xe5\xb1\xa1
{0x5c64,{0x40,0x3f,0x1b,0x77,0x5b,0x77,0x1b}}, // \xe5\xb1\xa4
{0x5c65,{0x40,0x3f,0x2b,0x77,0x5f,0x2b,0x5b}}, // \xe5\xb1\xa5
{0x5c6c,{0x40,0x3f,0x57,0x7b,0x3f,0x4b,0x7f}}, // \xe5\xb1\xac
{0x5c6e,{0x5e,0x50,0x30,0x1f,0x10,0x10,0x1e}}, // \xe5\xb1\xae
{0x5c6f,{0x02,0x1a,0x12,0x7f,0x52,0x51,0x59}}, // \xe5\xb1\xaf
{0x5c71,{0x7c,0x40,0x40,0x7f,0x40,0x40,0x7c}}, // \xe5\xb1\xb1
{0x5c76,{0x48,0x4f,0x2c,0x1f,0x0c,0x4f,0x78}}, // \xe5\xb1\xb6
{0x5c79,{0x38,0x3f,0x04,0x23,0x56,0x4e,0x62}}, // \xe5\xb1\xb9
{0x5c8c,{0x43,0x32,0x4e,0x53,0x26,0x5e,0x43}}, // \xe5\xb2\x8c
{0x5c90,{0x38,0x3f,0x38,0x42,0x5a,0x2f,0x5a}}, // \xe5\xb2\x90
{0x5c91,{0x0b,0x1a,0x56,0x53,0x36,0x1a,0x0b}}, // \xe5\xb2\x91
{0x5c94,{0x64,0x52,0x55,0x6c,0x55,0x5e,0x64}}, // \xe5\xb2\x94
{0x5ca1,{0x7f,0x35,0x27,0x3d,0x27,0x35,0x7f}}, // \xe5\xb2\xa1
{0x5ca8,{0x38,0x3f,0x40,0x7f,0x55,0x7f,0x40}}, // \xe5\xb2\xa8
{0x5ca9,{0x28,0x1b,0x6a,0x6b,0x6a,0x6b,0x08}}, // \xe5\xb2\xa9
{0x5cab,{0x38,0x3f,0x7e,0x4a,0x7f,0x4a,0x7e}}, // \xe5\xb2\xab
{0x5cac,{0x38,0x3f,0x3f,0x15,0x7f,0x15,0x1f}}, // \xe5\xb2\xac
{0x5cb1,{0x64,0x4e,0x41,0x72,0x43,0x46,0x6b}}, // \xe5\xb2\xb1
{0x5cb3,{0x10,0x7e,0x56,0x76,0x5d,0x75,0x10}}, // \xe5\xb2\xb3
{0x5cb6,{0x38,0x3f,0x38,0x7e,0x4b,0x4a,0x7e}}, // \xe5\xb2\xb6
{0x5cb7,{0x38,0x3f,0x38,0x7f,0x55,0x3d,0x57}}, // \xe5\xb2\xb7
{0x5cb8,{0x43,0x3e,0x22,0x2b,0x7a,0x2a,0x23}}, // \xe5\xb2\xb8
{0x5cbb,{0x38,0x3f,0x38,0x7e,0x4a,0x5e,0x69}}, // \xe5\xb2\xbb
{0x5cbc,{0x38,0x3f,0x15,0x13,0x7f,0x13,0x15}}, // \xe5\xb2\xbc
{0x5cbe,{0x38,0x3f,0x38,0x70,0x5f,0x54,0x74}}, // \xe5\xb2\xbe
{0x5cc5,{0x38,0x3f,0x54,0x3e,0x15,0x7c,0x16}}, // \xe5\xb3\x85
{0x5cc7,{0x13,0x12,0x6a,0x6f,0x6a,0x12,0x13}}, // \xe5\xb3\x87
{0x5cd9,{0x38,0x3f,0x28,0x6a,0x2f,0x7a,0x28}}, // \xe5\xb3\x99
{0x5ce0,{0x38,0x3f,0x38,0x08,0x7f,0x1a,0x2a}}, // \xe5\xb3\xa0
{0x5ce1,{0x38,0x3f,0x5a,0x52,0x3f,0x52,0x5a}}, // \xe5\xb3\xa1
{0x5ce8,{0x38,0x3f,0x26,0x7e,0x25,0x3f,0x55}}, // \xe5\xb3\xa8
{0x5ce9,{0x2b,0x2e,0x7e,0x0b,0x5e,0x2a,0x57}}, // \xe5\xb3\xa9
{0x5cea,{0x38,0x3f,0x12,0x69,0x64,0x69,0x12}}, // \xe5\xb3\xaa
{0x5ced,{0x38,0x3f,0x02,0x7d,0x2a,0x7d,0x02}}, // \xe5\xb3\xad
{0x5cef,{0x13,0x16,0x2e,0x7b,0x2e,0x12,0x13}}, // \xe5\xb3\xaf
{0x5cf0,{0x38,0x3f,0x28,0x2a,0x75,0x2b,0x28}}, // \xe5\xb3\xb0
{0x5cf6,{0x60,0x5e,0x76,0x57,0x76,0x16,0x70}}, // \xe5\xb3\xb6
{0x5cfa,{0x38,0x3f,0x41,0x57,0x3f,0x47,0x41}}, // \xe5\xb3\xba
{0x5cfb,{0x38,0x3f,0x2a,0x57,0x32,0x5e,0x4b}}, // \xe5\xb3\xbb
{0x5cfd,{0x38,0x3f,0x52,0x4e,0x3f,0x4e,0x52}}, // \xe5\xb3\xbd
{0x5d07,{0x4c,0x37,0x5e,0x7f,0x1e,0x37,0x4c}}, // \xe5\xb4\x87
{0x5d0b,{0x2b,0x3e,0x2a,0x7f,0x2a,0x3e,0x2b}}, // \xe5\xb4\x8b
{0x5d0e,{0x38,0x3f,0x12,0x5a,0x17,0x7a,0x12}}, // \xe5\xb4\x8e
{0x5d11,{0x43,0x7e,0x5a,0x0b,0x7a,0x5e,0x53}}, // \xe5\xb4\x91
{0x5d14,{0x13,0x0a,0x7e,0x57,0x7e,0x56,0x43}}, // \xe5\xb4\x94
{0x5d15,{0x38,0x3f,0x40,0x3f,0x55,0x7f,0x55}}, // \xe5\xb4\x95
{0x5d16,{0x43,0x3e,0x42,0x57,0x7e,0x56,0x43}}, // \xe5\xb4\x96
{0x5d17,{0x7f,0x32,0x26,0x3b,0x26,0x32,0x7f}}, // \xe5\xb4\x97
{0x5d18,{0x38,0x3f,0x74,0x32,0x75,0x36,0x74}}, // \xe5\xb4\x98
{0x5d19,{0x0b,0x7a,0x36,0x73,0x36,0x7a,0x0b}}, // \xe5\xb4\x99
{0x5d1a,{0x38,0x3f,0x28,0x5a,0x2f,0x5a,0x48}}, // \xe5\xb4\x9a
{0x5d1b,{0x38,0x3f,0x1f,0x65,0x4d,0x7d,0x6f}}, // \xe5\xb4\x9b
{0x5d1f,{0x4b,0x6a,0x5a,0x77,0x5a,0x6a,0x4b}}, // \xe5\xb4\x9f
{0x5d22,{0x38,0x3f,0x12,0x55,0x7f,0x3d,0x12}}, // \xe5\xb4\xa2
{0x5d29,{0x43,0x3e,0x56,0x7f,0x3e,0x56,0x7f}}, // \xe5\xb4\xa9
{0x5d4b,{0x38,0x3f,0x40,0x3f,0x05,0x77,0x77}}, // \xe5\xb5\x8b
{0x5d4c,{0x13,0x7a,0x52,0x7b,0x4e,0x3a,0x5b}}, // \xe5\xb5\x8c
{0x5d4e,{0x38,0x3f,0x78,0x4b,0x7f,0x2b,0x78}}, // \xe5\xb5\x8e
{0x5d50,{0x43,0x3e,0x5a,0x7f,0x3a,0x7e,0x43}}, // \xe5\xb5\x90
{0x5d52,{0x1c,0x74,0x5f,0x65,0x5f,0x74,0x1c}}, // \xe5\xb5\x92
{0x5d5c,{0x0b,0x7a,0x5e,0x7b,0x0a,0x7e,0x0b}}, // \xe5\xb5\x9c
{0x5d69,{0x73,0x12,0x7e,0x5b,0x7e,0x12,0x73}}, // \xe5\xb5\xa9
{0x5d6c,{0x43,0x5a,0x3a,0x1f,0x7a,0x5a,0x63}}, // \xe5\xb5\xac
{0x5d6f,{0x38,0x3f,0x4a,0x3b,0x5e,0x7b,0x5a}}, // \xe5\xb5\xaf
{0x5d73,{0x4b,0x3a,0x4a,0x5f,0x7a,0x5a,0x4b}}, // \xe5\xb5\xb3
{0x5d76,{0x38,0x3f,0x38,0x5d,0x77,0x5d,0x77}}, // \xe5\xb5\xb6
{0x5d82,{0x38,0x3f,0x2a,0x3e,0x7b,0x3e,0x2a}}, // \xe5\xb6\x82
{0x5d84,{0x2b,0x3a,0x7e,0x2b,0x1e,0x76,0x13}}, // \xe5\xb6\x84
{0x5d87,{0x38,0x3f,0x7f,0x71,0x47,0x77,0x71}}, // \xe5\xb6\x87
{0x5d8b,{0x38,0x3f,0x40,0x1e,0x57,0x16,0x70}}, // \xe5\xb6\x8b
{0x5d8c,{0x43,0x1e,0x56,0x17,0x56,0x16,0x73}}, // \xe5\xb6\x8c
{0x5d90,{0x7f,0x36,0x52,0x57,0x6a,0x56,0x53}}, // \xe5\xb6\x90
{0x5d9d,{0x38,0x3f,0x45,0x5b,0x69,0x5a,0x45}}, // \xe5\xb6\x9d
{0x5da2,{0x38,0x3f,0x5c,0x3e,0x17,0x7e,0x5c}}, // \xe5\xb6\xa2
{0x5dac,{0x38,0x3f,0x2a,0x7b,0x2e,0x3b,0x5a}}, // \xe5\xb6\xac
{0x5dae,{0x38,0x3f,0x5c,0x36,0x5d,0x36,0x5c}}, // \xe5\xb6\xae
{0x5db7,{0x5f,0x3a,0x5a,0x77,0x36,0x5e,0x57}}, // \xe5\xb6\xb7
{0x5dba,{0x17,0x72,0x36,0x43,0x1a,0x1e,0x5b}}, // \xe5\xb6\xba
{0x5dbc,{0x38,0x3f,0x5e,0x11,0x16,0x1d,0x5f}}, // \xe5\xb6\xbc
{0x5dbd,{0x57,0x4a,0x36,0x6b,0x6a,0x3e,0x4b}}, // \xe5\xb6\xbd
{0x5dc9,{0x38,0x3f,0x52,0x5e,0x2d,0x7f,0x56}}, // \xe5\xb7\x89
{0x5dcc,{0x43,0x3e,0x2a,0x7f,0x5a,0x2e,0x5b}}, // \xe5\xb7\x8c
{0x5dcd,{0x5b,0x76,0x3e,0x57,0x3a,0x7e,0x5b}}, // \xe5\xb7\x8d
{0x5dd2,{0x0a,0x7d,0x4a,0x77,0x4a,0x7d,0x08}}, // \xe5\xb7\x92
{0x5dd3,{0x4f,0x1a,0x5a,0x03,0x5a,0x1e,0x5b}}, // \xe5\xb7\x93
{0x5dd6,{0x43,0x3e,0x2e,0x7b,0x5e,0x2e,0x5b}}, // \xe5\xb7\x96
{0x5ddb,{0x08,0x14,0x6b,0x14,0x6b,0x14,0x63}}, // \xe5\xb7\x9b
{0x5ddd,{0x40,0x3f,0x00,0x1e,0x00,0x00,0x7f}}, // \xe5\xb7\x9d
{0x5dde,{0x4c,0x3f,0x0c,0x7f,0x00,0x0c,0x7f}}, // \xe5\xb7\x9e
{0x5de1,{0x49,0x3c,0x5b,0x44,0x5b,0x44,0x5b}}, // \xe5\xb7\xa1
{0x5de3,{0x50,0x57,0x36,0x7f,0x36,0x57,0x50}}, // \xe5\xb7\xa3
{0x5de5,{0x40,0x42,0x42,0x7e,0x42,0x42,0x40}}, // \xe5\xb7\xa5
{0x5de6,{0x22,0x52,0x4f,0x4a,0x7a,0x4a,0x42}}, // \xe5\xb7\xa6
{0x5de7,{0x22,0x3e,0x12,0x01,0x0f,0x49,0x79}}, // \xe5\xb7\xa7
{0x5de8,{0x7f,0x55,0x55,0x55,0x55,0x5d,0x41}}, // \xe5\xb7\xa8
{0x5deb,{0x50,0x4d,0x51,0x7f,0x51,0x4d,0x50}}, // \xe5\xb7\xab
{0x5dee,{0x4a,0x3a,0x4b,0x5e,0x7a,0x5b,0x4a}}, // \xe5\xb7\xae
{0x5df1,{0x39,0x49,0x49,0x49,0x49,0x4f,0x60}}, // \xe5\xb7\xb1
{0x5df2,{0x3d,0x49,0x49,0x49,0x49,0x4f,0x60}}, // \xe5\xb7\xb2
{0x5df3,{0x3f,0x49,0x49,0x49,0x49,0x4f,0x60}}, // \xe5\xb7\xb3
{0x5df4,{0x3f,0x49,0x49,0x4f,0x49,0x4f,0x60}}, // \xe5\xb7\xb4
{0x5df5,{0x40,0x3e,0x7e,0x56,0x5d,0x55,0x5c}}, // \xe5\xb7\xb5
{0x5df7,{0x28,0x1a,0x7f,0x5a,0x4f,0x1a,0x28}}, // \xe5\xb7\xb7
{0x5dfb,{0x14,0x0d,0x76,0x57,0x5e,0x4d,0x14}}, // \xe5\xb7\xbb
{0x5dfd,{0x51,0x55,0x1f,0x18,0x1d,0x55,0x57}}, // \xe5\xb7\xbd
{0x5dfe,{0x3e,0x02,0x02,0x7f,0x02,0x22,0x3e}}, // \xe5\xb7\xbe
{0x5e02,{0x02,0x3a,0x0a,0x7f,0x0a,0x3a,0x02}}, // \xe5\xb8\x82
{0x5e03,{0x12,0x0a,0x3f,0x0a,0x7e,0x0a,0x3a}}, // \xe5\xb8\x83
{0x5e06,{0x0e,0x7f,0x40,0x3f,0x09,0x7f,0x40}}, // \xe5\xb8\x86
{0x5e0b,{0x10,0x7e,0x36,0x66,0x2d,0x75,0x10}}, // \xe5\xb8\x8b
{0x5e0c,{0x28,0x19,0x6d,0x2a,0x7a,0x2d,0x68}}, // \xe5\xb8\x8c
{0x5e11,{0x0a,0x3e,0x1b,0x76,0x1b,0x35,0x0b}}, // \xe5\xb8\x91
{0x5e16,{0x0e,0x7f,0x0e,0x70,0x5f,0x54,0x74}}, // \xe5\xb8\x96
{0x5e19,{0x0e,0x7f,0x4c,0x2b,0x1f,0x2a,0x48}}, // \xe5\xb8\x99
{0x5e1a,{0x1a,0x6a,0x2f,0x7f,0x2f,0x6f,0x1a}}, // \xe5\xb8\x9a
{0x5e1b,{0x30,0x1e,0x1a,0x7b,0x1a,0x1e,0x30}}, // \xe5\xb8\x9b
{0x5e1d,{0x1a,0x6a,0x2e,0x7b,0x2a,0x6e,0x1a}}, // \xe5\xb8\x9d
{0x5e25,{0x3e,0x37,0x3e,0x02,0x7f,0x02,0x3e}}, // \xe5\xb8\xa5
{0x5e2b,{0x3e,0x37,0x3e,0x05,0x7f,0x05,0x3d}}, // \xe5\xb8\xab
{0x5e2d,{0x40,0x3e,0x6a,0x2e,0x7b,0x2e,0x6a}}, // \xe5\xb8\xad
{0x5e2f,{0x1a,0x6f,0x2a,0x7f,0x2a,0x6f,0x1a}}, // \xe5\xb8\xaf
{0x5e30,{0x4e,0x3f,0x0c,0x35,0x7d,0x37,0x0c}}, // \xe5\xb8\xb0
{0x5e33,{0x0e,0x7f,0x10,0x7f,0x55,0x35,0x51}}, // \xe5\xb8\xb3
{0x5e36,{0x1a,0x77,0x3f,0x7a,0x37,0x7f,0x1a}}, // \xe5\xb8\xb6
{0x5e37,{0x0e,0x7f,0x04,0x7f,0x4a,0x7f,0x4a}}, // \xe5\xb8\xb7
{0x5e38,{0x06,0x33,0x1e,0x7b,0x1e,0x33,0x06}}, // \xe5\xb8\xb8
{0x5e3d,{0x0e,0x7f,0x07,0x7d,0x55,0x7d,0x07}}, // \xe5\xb8\xbd
{0x5e40,{0x0e,0x7f,0x40,0x3c,0x37,0x3e,0x42}}, // \xe5\xb9\x80
{0x5e43,{0x0e,0x7f,0x28,0x3a,0x2f,0x7a,0x2e}}, // \xe5\xb9\x83
{0x5e44,{0x0e,0x7f,0x20,0x5f,0x5b,0x77,0x53}}, // \xe5\xb9\x84
{0x5e45,{0x0e,0x7f,0x71,0x57,0x75,0x57,0x71}}, // \xe5\xb9\x85
{0x5e47,{0x0a,0x3f,0x1a,0x70,0x16,0x3a,0x0f}}, // \xe5\xb9\x87
{0x5e4c,{0x0e,0x7f,0x54,0x33,0x1f,0x73,0x54}}, // \xe5\xb9\x8c
{0x5e4e,{0x0e,0x7f,0x53,0x1d,0x15,0x1d,0x53}}, // \xe5\xb9\x8e
{0x5e54,{0x0e,0x7f,0x4c,0x5f,0x2d,0x5f,0x4c}}, // \xe5\xb9\x94
{0x5e55,{0x2a,0x1a,0x6f,0x7e,0x2f,0x7a,0x1a}}, // \xe5\xb9\x95
{0x5e57,{0x0e,0x7f,0x7f,0x6d,0x4f,0x55,0x7f}}, // \xe5\xb9\x97
{0x5e5f,{0x0e,0x7f,0x0a,0x6f,0x6e,0x3f,0x55}}, // \xe5\xb9\x9f
{0x5e61,{0x0e,0x7f,0x15,0x6f,0x7d,0x6f,0x15}}, // \xe5\xb9\xa1
{0x5e62,{0x0e,0x7f,0x4a,0x5e,0x7b,0x5e,0x4a}}, // \xe5\xb9\xa2
{0x5e63,{0x0d,0x36,0x1e,0x75,0x1a,0x35,0x0b}}, // \xe5\xb9\xa3
{0x5e64,{0x02,0x3d,0x1e,0x75,0x1a,0x35,0x0b}}, // \xe5\xb9\xa4
{0x5e72,{0x08,0x09,0x09,0x7f,0x09,0x09,0x08}}, // \xe5\xb9\xb2
{0x5e73,{0x11,0x13,0x15,0x7f,0x15,0x13,0x11}}, // \xe5\xb9\xb3
{0x5e74,{0x24,0x3b,0x2a,0x7e,0x2a,0x2a,0x22}}, // \xe5\xb9\xb4
{0x5e75,{0x09,0x7f,0x09,0x00,0x09,0x7f,0x09}}, // \xe5\xb9\xb5
{0x5e76,{0x10,0x54,0x3d,0x14,0x16,0x7d,0x14}}, // \xe5\xb9\xb6
{0x5e78,{0x14,0x36,0x3e,0x77,0x3e,0x36,0x14}}, // \xe5\xb9\xb8
{0x5e79,{0x2d,0x77,0x2d,0x00,0x2a,0x79,0x2a}}, // \xe5\xb9\xb9
{0x5e7a,{0x40,0x44,0x6c,0x53,0x48,0x24,0x40}}, // \xe5\xb9\xba
{0x5e7b,{0x44,0x6c,0x5b,0x64,0x01,0x41,0x3f}}, // \xe5\xb9\xbb
{0x5e7c,{0x44,0x6c,0x5b,0x64,0x3f,0x42,0x7e}}, // \xe5\xb9\xbc
{0x5e7d,{0x7e,0x5a,0x55,0x7f,0x5a,0x55,0x7e}}, // \xe5\xb9\xbd
{0x5e7e,{0x4a,0x3d,0x28,0x4f,0x5a,0x2d,0x50}}, // \xe5\xb9\xbe
{0x5e7f,{0x40,0x3e,0x02,0x02,0x03,0x02,0x02}}, // \xe5\xb9\xbf
{0x5e81,{0x40,0x3e,0x0a,0x4a,0x7b,0x0a,0x0a}}, // \xe5\xba\x81
{0x5e83,{0x40,0x3e,0x42,0x62,0x5b,0x22,0x42}}, // \xe5\xba\x83
{0x5e84,{0x40,0x3e,0x42,0x4a,0x7f,0x4a,0x42}}, // \xe5\xba\x84
{0x5e87,{0x40,0x3e,0x7a,0x52,0x03,0x7a,0x52}}, // \xe5\xba\x87
{0x5e8a,{0x40,0x3e,0x4a,0x2a,0x7f,0x2a,0x4a}}, // \xe5\xba\x8a
{0x5e8f,{0x40,0x3e,0x12,0x56,0x77,0x1e,0x32}}, // \xe5\xba\x8f
{0x5e95,{0x40,0x3e,0x42,0x7e,0x57,0x3e,0x56}}, // \xe5\xba\x95
{0x5e96,{0x40,0x3e,0x0a,0x76,0x5f,0x46,0x5e}}, // \xe5\xba\x96
{0x5e97,{0x40,0x3e,0x02,0x62,0x7f,0x6a,0x6a}}, // \xe5\xba\x97
{0x5e9a,{0x40,0x3e,0x42,0x56,0x3f,0x56,0x5e}}, // \xe5\xba\x9a
{0x5e9c,{0x40,0x3e,0x12,0x7e,0x2b,0x4a,0x7e}}, // \xe5\xba\x9c
{0x5ea0,{0x40,0x3e,0x2a,0x2e,0x7b,0x2e,0x2a}}, // \xe5\xba\xa0
{0x5ea6,{0x40,0x3e,0x4a,0x5e,0x2b,0x5e,0x4a}}, // \xe5\xba\xa6
{0x5ea7,{0x40,0x3e,0x4a,0x56,0x7b,0x56,0x4a}}, // \xe5\xba\xa7
{0x5eab,{0x40,0x3e,0x2a,0x3a,0x7f,0x3a,0x2a}}, // \xe5\xba\xab
{0x5ead,{0x40,0x3e,0x56,0x2e,0x53,0x7a,0x56}}, // \xe5\xba\xad
{0x5eb5,{0x40,0x3e,0x0a,0x36,0x3b,0x76,0x4a}}, // \xe5\xba\xb5
{0x5eb6,{0x40,0x3e,0x4a,0x1e,0x5b,0x1e,0x4a}}, // \xe5\xba\xb6
{0x5eb7,{0x40,0x3e,0x5a,0x2a,0x7f,0x2e,0x56}}, // \xe5\xba\xb7
{0x5eb8,{0x40,0x3e,0x7a,0x2e,0x7f,0x2e,0x7a}}, // \xe5\xba\xb8
{0x5ec1,{0x40,0x3e,0x5e,0x16,0x5f,0x02,0x7a}}, // \xe5\xbb\x81
{0x5ec2,{0x40,0x3e,0x7e,0x2a,0x7f,0x56,0x7e}}, // \xe5\xbb\x82
{0x5ec3,{0x40,0x3e,0x56,0x3e,0x17,0x7a,0x56}}, // \xe5\xbb\x83
{0x5ec8,{0x40,0x3e,0x42,0x56,0x2f,0x5e,0x46}}, // \xe5\xbb\x88
{0x5ec9,{0x40,0x3e,0x52,0x36,0x7f,0x3e,0x5a}}, // \xe5\xbb\x89
{0x5eca,{0x40,0x3e,0x7a,0x5e,0x23,0x7e,0x36}}, // \xe5\xbb\x8a
{0x5ecf,{0x40,0x3e,0x3a,0x2e,0x5f,0x36,0x5e}}, // \xe5\xbb\x8f
{0x5ed0,{0x40,0x3e,0x3a,0x2e,0x57,0x3e,0x56}}, // \xe5\xbb\x90
{0x5ed3,{0x40,0x3e,0x3a,0x6e,0x3b,0x7e,0x36}}, // \xe5\xbb\x93
{0x5ed6,{0x40,0x3e,0x16,0x4a,0x57,0x2a,0x16}}, // \xe5\xbb\x96
{0x5eda,{0x40,0x3e,0x56,0x6e,0x37,0x4a,0x7e}}, // \xe5\xbb\x9a
{0x5edb,{0x40,0x3e,0x5a,0x5e,0x6f,0x5e,0x5a}}, // \xe5\xbb\x9b
{0x5edd,{0x40,0x3e,0x5e,0x16,0x5f,0x3a,0x76}}, // \xe5\xbb\x9d
{0x5edf,{0x40,0x3e,0x7e,0x36,0x7b,0x2a,0x7a}}, // \xe5\xbb\x9f
{0x5ee0,{0x40,0x3e,0x76,0x3a,0x77,0x2e,0x5a}}, // \xe5\xbb\xa0
{0x5ee1,{0x40,0x3e,0x6e,0x3a,0x6b,0x3a,0x6a}}, // \xe5\xbb\xa1
{0x5ee2,{0x40,0x3e,0x56,0x2e,0x5f,0x2a,0x56}}, // \xe5\xbb\xa2
{0x5ee3,{0x40,0x3e,0x4a,0x3e,0x3b,0x3e,0x4a}}, // \xe5\xbb\xa3
{0x5ee8,{0x40,0x7e,0x36,0x7e,0x2b,0x76,0x2e}}, // \xe5\xbb\xa8
{0x5ee9,{0x40,0x3e,0x52,0x3e,0x7b,0x3e,0x52}}, // \xe5\xbb\xa9
{0x5eec,{0x40,0x7e,0x3a,0x4a,0x7f,0x76,0x52}}, // \xe5\xbb\xac
{0x5ef0,{0x40,0x3e,0x3e,0x7e,0x2b,0x5e,0x6a}}, // \xe5\xbb\xb0
{0x5ef1,{0x40,0x3e,0x6a,0x76,0x4b,0x7e,0x56}}, // \xe5\xbb\xb1
{0x5ef3,{0x40,0x3e,0x36,0x7e,0x2b,0x5e,0x6a}}, // \xe5\xbb\xb3
{0x5ef4,{0x51,0x25,0x5b,0x40,0x40,0x40,0x40}}, // \xe5\xbb\xb4
{0x5ef6,{0x55,0x3b,0x40,0x5a,0x52,0x5e,0x55}}, // \xe5\xbb\xb6
{0x5ef7,{0x55,0x3b,0x48,0x6a,0x7e,0x69,0x48}}, // \xe5\xbb\xb7
{0x5ef8,{0x55,0x3b,0x40,0x7e,0x6a,0x7f,0x7e}}, // \xe5\xbb\xb8
{0x5efa,{0x55,0x3b,0x40,0x55,0x7f,0x57,0x52}}, // \xe5\xbb\xba
{0x5efb,{0x55,0x3b,0x40,0x7f,0x5d,0x55,0x7f}}, // \xe5\xbb\xbb
{0x5efc,{0x55,0x3b,0x40,0x7d,0x6f,0x67,0x7d}}, // \xe5\xbb\xbc
{0x5efe,{0x08,0x48,0x3f,0x08,0x08,0x7f,0x08}}, // \xe5\xbb\xbe
{0x5eff,{0x04,0x7f,0x44,0x44,0x44,0x7f,0x04}}, // \xe5\xbb\xbf
{0x5f01,{0x14,0x54,0x3e,0x15,0x7c,0x12,0x14}}, // \xe5\xbc\x81
{0x5f03,{0x12,0x5a,0x3e,0x1b,0x76,0x1a,0x12}}, // \xe5\xbc\x83
{0x5f04,{0x10,0x55,0x3d,0x17,0x7d,0x15,0x10}}, // \xe5\xbc\x84
{0x5f09,{0x1b,0x56,0x3f,0x12,0x7a,0x1f,0x1a}}, // \xe5\xbc\x89
{0x5f0a,{0x1d,0x56,0x3e,0x15,0x7a,0x15,0x1b}}, // \xe5\xbc\x8a
{0x5f0b,{0x04,0x04,0x04,0x1f,0x24,0x45,0x64}}, // \xe5\xbc\x8b
{0x5f0c,{0x12,0x12,0x12,0x12,0x0f,0x32,0x43}}, // \xe5\xbc\x8c
{0x5f0d,{0x42,0x4a,0x4a,0x42,0x0f,0x32,0x43}}, // \xe5\xbc\x8d
{0x5f0f,{0x42,0x4a,0x3a,0x2a,0x0f,0x32,0x43}}, // \xe5\xbc\x8f
{0x5f10,{0x44,0x4d,0x2d,0x24,0x0f,0x34,0x45}}, // \xe5\xbc\x90
{0x5f11,{0x54,0x35,0x7a,0x55,0x74,0x3f,0x45}}, // \xe5\xbc\x91
{0x5f13,{0x10,0x1d,0x15,0x15,0x55,0x57,0x70}}, // \xe5\xbc\x93
{0x5f14,{0x10,0x1d,0x15,0x7f,0x15,0x57,0x70}}, // \xe5\xbc\x94
{0x5f15,{0x1d,0x15,0x55,0x77,0x00,0x00,0x7f}}, // \xe5\xbc\x95
{0x5f16,{0x40,0x41,0x5d,0x55,0x55,0x77,0x40}}, // \xe5\xbc\x96
{0x5f17,{0x5a,0x5a,0x3f,0x16,0x7f,0x16,0x36}}, // \xe5\xbc\x97
{0x5f18,{0x5d,0x77,0x40,0x70,0x4f,0x20,0x40}}, // \xe5\xbc\x98
{0x5f1b,{0x5d,0x77,0x08,0x7e,0x44,0x5f,0x6c}}, // \xe5\xbc\x9b
{0x5f1f,{0x42,0x5a,0x2b,0x7e,0x2a,0x2b,0x6e}}, // \xe5\xbc\x9f
{0x5f25,{0x5d,0x77,0x24,0x5b,0x7e,0x0a,0x32}}, // \xe5\xbc\xa5
{0x5f26,{0x5d,0x77,0x4a,0x6e,0x53,0x2a,0x42}}, // \xe5\xbc\xa6
{0x5f27,{0x5d,0x77,0x40,0x3e,0x42,0x3e,0x61}}, // \xe5\xbc\xa7
{0x5f29,{0x0a,0x3e,0x3b,0x36,0x3b,0x25,0x6b}}, // \xe5\xbc\xa9
{0x5f2d,{0x5d,0x77,0x21,0x3f,0x2d,0x7f,0x21}}, // \xe5\xbc\xad
{0x5f2f,{0x0a,0x32,0x3e,0x33,0x3e,0x22,0x6a}}, // \xe5\xbc\xaf
{0x5f31,{0x2d,0x55,0x77,0x00,0x2d,0x55,0x77}}, // \xe5\xbc\xb1
{0x5f35,{0x5d,0x77,0x10,0x7f,0x55,0x35,0x51}}, // \xe5\xbc\xb5
{0x5f37,{0x5d,0x77,0x44,0x5e,0x7d,0x5c,0x66}}, // \xe5\xbc\xb7
{0x5f38,{0x5d,0x77,0x3f,0x55,0x3f,0x55,0x7f}}, // \xe5\xbc\xb8
{0x5f3c,{0x5d,0x77,0x3a,0x2e,0x3a,0x5d,0x77}}, // \xe5\xbc\xbc
{0x5f3e,{0x5d,0x77,0x2d,0x2c,0x7d,0x2e,0x2d}}, // \xe5\xbc\xbe
{0x5f41,{0x5d,0x77,0x09,0x2d,0x49,0x7f,0x09}}, // \xe5\xbd\x81
{0x5f48,{0x5d,0x77,0x23,0x3f,0x7c,0x3f,0x23}}, // \xe5\xbd\x88
{0x5f4a,{0x5d,0x77,0x00,0x49,0x7f,0x7f,0x49}}, // \xe5\xbd\x8a
{0x5f4c,{0x5d,0x77,0x7d,0x2b,0x7f,0x2b,0x7d}}, // \xe5\xbd\x8c
{0x5f4e,{0x0a,0x3d,0x3a,0x37,0x3a,0x3d,0x68}}, // \xe5\xbd\x8e
{0x5f51,{0x40,0x58,0x57,0x52,0x72,0x4e,0x40}}, // \xe5\xbd\x91
{0x5f53,{0x00,0x45,0x56,0x57,0x54,0x56,0x7d}}, // \xe5\xbd\x93
{0x5f56,{0x54,0x54,0x2e,0x5d,0x77,0x25,0x54}}, // \xe5\xbd\x96
{0x5f57,{0x2a,0x6f,0x6a,0x68,0x6a,0x7f,0x2a}}, // \xe5\xbd\x97
{0x5f59,{0x4c,0x54,0x3e,0x7d,0x3f,0x55,0x4c}}, // \xe5\xbd\x99
{0x5f5c,{0x24,0x6c,0x3e,0x25,0x77,0x2d,0x3c}}, // \xe5\xbd\x9c
{0x5f5d,{0x24,0x6c,0x3e,0x25,0x77,0x3d,0x34}}, // \xe5\xbd\x9d
{0x5f61,{0x00,0x54,0x54,0x4a,0x2a,0x25,0x10}}, // \xe5\xbd\xa1
{0x5f62,{0x49,0x3f,0x09,0x7f,0x09,0x4a,0x25}}, // \xe5\xbd\xa2
{0x5f66,{0x42,0x3a,0x0e,0x5b,0x5a,0x4e,0x2a}}, // \xe5\xbd\xa6
{0x5f69,{0x52,0x36,0x7a,0x35,0x51,0x4a,0x25}}, // \xe5\xbd\xa9
{0x5f6a,{0x7c,0x44,0x2f,0x6a,0x40,0x6a,0x55}}, // \xe5\xbd\xaa
{0x5f6b,{0x7f,0x35,0x2f,0x35,0x7f,0x4a,0x25}}, // \xe5\xbd\xab
{0x5f6c,{0x1a,0x7f,0x1a,0x7f,0x1a,0x4a,0x25}}, // \xe5\xbd\xac
{0x5f6d,{0x42,0x5a,0x6f,0x5a,0x00,0x4a,0x25}}, // \xe5\xbd\xad
{0x5f70,{0x2a,0x3e,0x7b,0x3e,0x2a,0x4a,0x25}}, // \xe5\xbd\xb0
{0x5f71,{0x44,0x1f,0x75,0x1f,0x44,0x4a,0x25}}, // \xe5\xbd\xb1
{0x5f73,{0x00,0x00,0x14,0x14,0x7a,0x05,0x00}}, // \xe5\xbd\xb3
{0x5f77,{0x0a,0x7d,0x42,0x3e,0x0b,0x4a,0x7a}}, // \xe5\xbd\xb7
{0x5f79,{0x0a,0x7d,0x44,0x5b,0x29,0x5f,0x44}}, // \xe5\xbd\xb9
{0x5f7c,{0x0a,0x7d,0x3e,0x5a,0x2f,0x5a,0x46}}, // \xe5\xbd\xbc
{0x5f7f,{0x0a,0x7d,0x5a,0x3f,0x16,0x7f,0x36}}, // \xe5\xbd\xbf
{0x5f80,{0x0a,0x7d,0x44,0x55,0x7e,0x54,0x44}}, // \xe5\xbe\x80
{0x5f81,{0x0a,0x7d,0x40,0x79,0x41,0x7f,0x49}}, // \xe5\xbe\x81
{0x5f82,{0x0a,0x7d,0x40,0x7f,0x55,0x7f,0x40}}, // \xe5\xbe\x82
{0x5f83,{0x0a,0x7d,0x44,0x53,0x7f,0x52,0x42}}, // \xe5\xbe\x83
{0x5f84,{0x0a,0x7d,0x49,0x5b,0x75,0x5b,0x48}}, // \xe5\xbe\x84
{0x5f85,{0x0a,0x7d,0x28,0x6a,0x2f,0x7a,0x28}}, // \xe5\xbe\x85
{0x5f87,{0x0a,0x7d,0x04,0x3f,0x2a,0x3e,0x7e}}, // \xe5\xbe\x87
{0x5f88,{0x0a,0x7d,0x00,0x7f,0x55,0x35,0x5f}}, // \xe5\xbe\x88
{0x5f8a,{0x0a,0x7d,0x7f,0x5d,0x55,0x5d,0x7f}}, // \xe5\xbe\x8a
{0x5f8b,{0x0a,0x7d,0x2a,0x2a,0x7f,0x2e,0x24}}, // \xe5\xbe\x8b
{0x5f8c,{0x0a,0x7d,0x48,0x5a,0x2d,0x58,0x4c}}, // \xe5\xbe\x8c
{0x5f90,{0x0a,0x7d,0x54,0x16,0x7d,0x16,0x54}}, // \xe5\xbe\x90
{0x5f91,{0x0a,0x7d,0x00,0x55,0x5b,0x75,0x5b}}, // \xe5\xbe\x91
{0x5f92,{0x0a,0x7d,0x48,0x2a,0x7f,0x5a,0x48}}, // \xe5\xbe\x92
{0x5f93,{0x0a,0x7d,0x42,0x3a,0x43,0x7e,0x4b}}, // \xe5\xbe\x93
{0x5f97,{0x0a,0x7d,0x14,0x37,0x55,0x7f,0x14}}, // \xe5\xbe\x97
{0x5f98,{0x0a,0x7d,0x2a,0x7f,0x00,0x7f,0x2a}}, // \xe5\xbe\x98
{0x5f99,{0x0a,0x7d,0x48,0x2e,0x48,0x7f,0x5a}}, // \xe5\xbe\x99
{0x5f9e,{0x0a,0x7d,0x44,0x33,0x44,0x7b,0x54}}, // \xe5\xbe\x9e
{0x5fa0,{0x0a,0x7d,0x4a,0x26,0x7f,0x26,0x4a}}, // \xe5\xbe\xa0
{0x5fa1,{0x0a,0x7d,0x33,0x3e,0x2a,0x7f,0x1f}}, // \xe5\xbe\xa1
{0x5fa8,{0x0a,0x7d,0x50,0x5e,0x7b,0x5e,0x50}}, // \xe5\xbe\xa8
{0x5fa9,{0x0a,0x7d,0x44,0x53,0x2e,0x5e,0x42}}, // \xe5\xbe\xa9
{0x5faa,{0x0a,0x7d,0x20,0x1e,0x76,0x7e,0x75}}, // \xe5\xbe\xaa
{0x5fad,{0x0a,0x7d,0x10,0x6a,0x4d,0x7b,0x68}}, // \xe5\xbe\xad
{0x5fae,{0x0a,0x7d,0x4a,0x3b,0x4a,0x3f,0x5e}}, // \xe5\xbe\xae
{0x5fb3,{0x0a,0x7d,0x62,0x2e,0x4f,0x4e,0x62}}, // \xe5\xbe\xb3
{0x5fb4,{0x0a,0x7d,0x2a,0x3b,0x6a,0x3f,0x5e}}, // \xe5\xbe\xb4
{0x5fb9,{0x0a,0x7d,0x0a,0x77,0x72,0x3f,0x5e}}, // \xe5\xbe\xb9
{0x5fbc,{0x0a,0x7d,0x2e,0x5f,0x7c,0x23,0x5e}}, // \xe5\xbe\xbc
{0x5fbd,{0x0a,0x7d,0x2a,0x77,0x2a,0x3f,0x5e}}, // \xe5\xbe\xbd
{0x5fc3,{0x20,0x18,0x7d,0x42,0x40,0x68,0x10}}, // \xe5\xbf\x83
{0x5fc5,{0x58,0x40,0x3d,0x52,0x48,0x46,0x58}}, // \xe5\xbf\x85
{0x5fcc,{0x60,0x3d,0x55,0x55,0x75,0x17,0x60}}, // \xe5\xbf\x8c
{0x5fcd,{0x60,0x29,0x4b,0x55,0x6b,0x0f,0x60}}, // \xe5\xbf\x8d
{0x5fd6,{0x06,0x7f,0x02,0x0a,0x52,0x7f,0x02}}, // \xe5\xbf\x96
{0x5fd7,{0x62,0x2a,0x4a,0x4f,0x6a,0x0a,0x62}}, // \xe5\xbf\x97
{0x5fd8,{0x62,0x3e,0x4a,0x5b,0x6a,0x1a,0x62}}, // \xe5\xbf\x98
{0x5fd9,{0x06,0x7f,0x02,0x3e,0x43,0x42,0x42}}, // \xe5\xbf\x99
{0x5fdc,{0x40,0x3e,0x22,0x76,0x4b,0x62,0x22}}, // \xe5\xbf\x9c
{0x5fdd,{0x54,0x16,0x6e,0x06,0x4d,0x15,0x54}}, // \xe5\xbf\x9d
{0x5fe0,{0x60,0x2e,0x4a,0x5f,0x6a,0x0e,0x60}}, // \xe5\xbf\xa0
{0x5fe4,{0x06,0x7f,0x14,0x13,0x7e,0x12,0x10}}, // \xe5\xbf\xa4
{0x5feb,{0x06,0x7f,0x48,0x4a,0x3f,0x4e,0x48}}, // \xe5\xbf\xab
{0x5ff0,{0x06,0x7f,0x2a,0x27,0x72,0x2e,0x28}}, // \xe5\xbf\xb0
{0x5ff1,{0x06,0x7f,0x46,0x22,0x1f,0x7a,0x46}}, // \xe5\xbf\xb1
{0x5ff5,{0x64,0x24,0x4a,0x4d,0x5e,0x04,0x64}}, // \xe5\xbf\xb5
{0x5ff8,{0x06,0x7f,0x49,0x7f,0x49,0x7f,0x48}}, // \xe5\xbf\xb8
{0x5ffb,{0x06,0x7f,0x40,0x3e,0x0a,0x79,0x08}}, // \xe5\xbf\xbb
{0x5ffd,{0x64,0x33,0x4e,0x52,0x6e,0x12,0x6e}}, // \xe5\xbf\xbd
{0x5fff,{0x64,0x32,0x55,0x4c,0x75,0x1e,0x64}}, // \xe5\xbf\xbf
{0x600e,{0x64,0x34,0x43,0x5e,0x6a,0x0a,0x6a}}, // \xe6\x80\x8e
{0x600f,{0x06,0x7f,0x48,0x4e,0x3b,0x4e,0x48}}, // \xe6\x80\x8f
{0x6010,{0x06,0x7f,0x04,0x1b,0x1a,0x42,0x7e}}, // \xe6\x80\x90
{0x6012,{0x6a,0x2e,0x4b,0x46,0x6b,0x05,0x6b}}, // \xe6\x80\x92
{0x6015,{0x06,0x7f,0x02,0x7e,0x4b,0x4a,0x7e}}, // \xe6\x80\x95
{0x6016,{0x06,0x7f,0x0a,0x37,0x12,0x7a,0x32}}, // \xe6\x80\x96
{0x6019,{0x06,0x7f,0x04,0x74,0x5f,0x74,0x04}}, // \xe6\x80\x99
{0x601b,{0x06,0x7f,0x00,0x5f,0x55,0x55,0x5f}}, // \xe6\x80\x9b
{0x601c,{0x06,0x7f,0x14,0x12,0x75,0x16,0x34}}, // \xe6\x80\x9c
{0x601d,{0x60,0x3f,0x55,0x5f,0x75,0x1f,0x60}}, // \xe6\x80\x9d
{0x6020,{0x64,0x3c,0x56,0x55,0x74,0x1a,0x64}}, // \xe6\x80\xa0
{0x6021,{0x06,0x7f,0x08,0x6c,0x6b,0x64,0x08}}, // \xe6\x80\xa1
{0x6025,{0x62,0x36,0x55,0x55,0x77,0x1c,0x60}}, // \xe6\x80\xa5
{0x6026,{0x06,0x7f,0x15,0x13,0x7f,0x13,0x15}}, // \xe6\x80\xa6
{0x6027,{0x06,0x7f,0x44,0x53,0x7f,0x52,0x42}}, // \xe6\x80\xa7
{0x6028,{0x6a,0x2b,0x45,0x53,0x6f,0x09,0x6b}}, // \xe6\x80\xa8
{0x6029,{0x06,0x7f,0x40,0x3f,0x05,0x7d,0x57}}, // \xe6\x80\xa9
{0x602a,{0x06,0x7f,0x49,0x5b,0x75,0x5b,0x48}}, // \xe6\x80\xaa
{0x602b,{0x06,0x7f,0x5a,0x3f,0x16,0x7f,0x36}}, // \xe6\x80\xab
{0x602f,{0x06,0x7f,0x48,0x6a,0x5f,0x2a,0x48}}, // \xe6\x80\xaf
{0x6031,{0x64,0x2b,0x4e,0x5a,0x6e,0x12,0x6e}}, // \xe6\x80\xb1
{0x603a,{0x06,0x7f,0x28,0x5d,0x7d,0x10,0x28}}, // \xe6\x80\xba
{0x6041,{0x64,0x3e,0x45,0x56,0x5e,0x15,0x44}}, // \xe6\x81\x81
{0x6042,{0x06,0x7f,0x04,0x3f,0x2a,0x3e,0x7e}}, // \xe6\x81\x82
{0x6043,{0x06,0x7f,0x28,0x6a,0x2f,0x7a,0x28}}, // \xe6\x81\x83
{0x6046,{0x06,0x7f,0x51,0x4f,0x75,0x5d,0x41}}, // \xe6\x81\x86
{0x604a,{0x06,0x7f,0x20,0x62,0x37,0x62,0x76}}, // \xe6\x81\x8a
{0x604b,{0x6a,0x22,0x4e,0x43,0x6e,0x02,0x6a}}, // \xe6\x81\x8b
{0x604d,{0x06,0x7f,0x4a,0x38,0x0f,0x78,0x4a}}, // \xe6\x81\x8d
{0x6050,{0x69,0x2f,0x45,0x48,0x67,0x0f,0x68}}, // \xe6\x81\x90
{0x6052,{0x06,0x7f,0x41,0x7f,0x6b,0x7f,0x41}}, // \xe6\x81\x92
{0x6055,{0x6a,0x2e,0x4b,0x46,0x6f,0x09,0x6f}}, // \xe6\x81\x95
{0x6059,{0x6a,0x3a,0x4b,0x5e,0x6a,0x1b,0x6a}}, // \xe6\x81\x99
{0x605a,{0x54,0x36,0x56,0x5f,0x76,0x16,0x54}}, // \xe6\x81\x9a
{0x605f,{0x06,0x7f,0x04,0x37,0x2a,0x36,0x7e}}, // \xe6\x81\x9f
{0x6060,{0x06,0x7f,0x0a,0x7e,0x53,0x7a,0x52}}, // \xe6\x81\xa0
{0x6062,{0x06,0x7f,0x40,0x3f,0x4d,0x3f,0x45}}, // \xe6\x81\xa2
{0x6063,{0x69,0x20,0x44,0x4b,0x66,0x0a,0x66}}, // \xe6\x81\xa3
{0x6064,{0x06,0x7f,0x40,0x7e,0x43,0x7e,0x7e}}, // \xe6\x81\xa4
{0x6065,{0x21,0x3f,0x7f,0x18,0x7d,0x42,0x68}}, // \xe6\x81\xa5
{0x6068,{0x06,0x7f,0x02,0x7f,0x55,0x35,0x5f}}, // \xe6\x81\xa8
{0x6069,{0x60,0x3f,0x4d,0x5b,0x6d,0x1f,0x60}}, // \xe6\x81\xa9
{0x606a,{0x06,0x7f,0x10,0x6a,0x65,0x6b,0x10}}, // \xe6\x81\xaa
{0x606b,{0x06,0x7f,0x02,0x7f,0x35,0x35,0x7f}}, // \xe6\x81\xab
{0x606c,{0x06,0x7f,0x04,0x76,0x5e,0x75,0x04}}, // \xe6\x81\xac
{0x606d,{0x48,0x1a,0x6f,0x0a,0x4f,0x1a,0x48}}, // \xe6\x81\xad
{0x606f,{0x60,0x3e,0x5a,0x5b,0x7a,0x1e,0x60}}, // \xe6\x81\xaf
{0x6070,{0x06,0x7f,0x04,0x72,0x55,0x76,0x04}}, // \xe6\x81\xb0
{0x6075,{0x62,0x3e,0x56,0x5f,0x76,0x1e,0x62}}, // \xe6\x81\xb5
{0x6077,{0x64,0x3e,0x53,0x4a,0x5f,0x0a,0x52}}, // \xe6\x81\xb7
{0x6081,{0x06,0x7f,0x02,0x78,0x2b,0x2b,0x78}}, // \xe6\x82\x81
{0x6083,{0x06,0x7f,0x7f,0x55,0x7f,0x55,0x7f}}, // \xe6\x82\x83
{0x6084,{0x06,0x7f,0x02,0x7d,0x2a,0x7d,0x02}}, // \xe6\x82\x84
{0x6089,{0x55,0x37,0x4d,0x5f,0x6d,0x17,0x55}}, // \xe6\x82\x89
{0x608b,{0x06,0x7f,0x12,0x76,0x6b,0x76,0x12}}, // \xe6\x82\x8b
{0x608c,{0x06,0x7f,0x5a,0x2b,0x7e,0x2b,0x6e}}, // \xe6\x82\x8c
{0x608d,{0x06,0x7f,0x28,0x2f,0x7d,0x2f,0x28}}, // \xe6\x82\x8d
{0x6092,{0x06,0x7f,0x3c,0x57,0x5d,0x57,0x5c}}, // \xe6\x82\x92
{0x6094,{0x06,0x7f,0x08,0x3b,0x2e,0x7e,0x2a}}, // \xe6\x82\x94
{0x6096,{0x06,0x7f,0x2c,0x26,0x6f,0x3e,0x2c}}, // \xe6\x82\x96
{0x6097,{0x06,0x7f,0x5c,0x36,0x1d,0x77,0x5c}}, // \xe6\x82\x97
{0x609a,{0x06,0x7f,0x42,0x2e,0x7f,0x2a,0x4e}}, // \xe6\x82\x9a
{0x609b,{0x06,0x7f,0x2a,0x57,0x32,0x5e,0x4b}}, // \xe6\x82\x9b
{0x609f,{0x06,0x7f,0x14,0x7d,0x57,0x7d,0x10}}, // \xe6\x82\x9f
{0x60a0,{0x64,0x2e,0x41,0x4e,0x6a,0x05,0x6b}}, // \xe6\x82\xa0
{0x60a3,{0x60,0x38,0x5e,0x5f,0x7e,0x18,0x60}}, // \xe6\x82\xa3
{0x60a6,{0x06,0x7f,0x4e,0x3b,0x0a,0x7b,0x4e}}, // \xe6\x82\xa6
{0x60a7,{0x06,0x7f,0x35,0x7f,0x15,0x4e,0x7f}}, // \xe6\x82\xa7
{0x60a9,{0x06,0x7f,0x79,0x54,0x49,0x54,0x7b}}, // \xe6\x82\xa9
{0x60aa,{0x69,0x3f,0x4f,0x5f,0x6f,0x1f,0x69}}, // \xe6\x82\xaa
{0x60b2,{0x6a,0x2a,0x5f,0x40,0x5f,0x0a,0x6a}}, // \xe6\x82\xb2
{0x60b3,{0x60,0x3a,0x52,0x5f,0x7e,0x12,0x60}}, // \xe6\x82\xb3
{0x60b4,{0x06,0x7f,0x32,0x2e,0x73,0x2e,0x32}}, // \xe6\x82\xb4
{0x60b5,{0x06,0x7f,0x10,0x7f,0x55,0x35,0x51}}, // \xe6\x82\xb5
{0x60b6,{0x7f,0x25,0x77,0x48,0x67,0x25,0x7f}}, // \xe6\x82\xb6
{0x60b8,{0x06,0x7f,0x2a,0x27,0x6f,0x37,0x2a}}, // \xe6\x82\xb8
{0x60bc,{0x06,0x7f,0x20,0x3c,0x77,0x3e,0x22}}, // \xe6\x82\xbc
{0x60bd,{0x06,0x7f,0x52,0x7a,0x5f,0x3e,0x52}}, // \xe6\x82\xbd
{0x60c5,{0x06,0x7f,0x08,0x7a,0x2f,0x7a,0x08}}, // \xe6\x83\x85
{0x60c6,{0x06,0x7f,0x7f,0x35,0x2f,0x35,0x7f}}, // \xe6\x83\x86
{0x60c7,{0x06,0x7f,0x22,0x2e,0x6b,0x3e,0x22}}, // \xe6\x83\x87
{0x60d1,{0x6a,0x2e,0x4e,0x42,0x6b,0x06,0x6b}}, // \xe6\x83\x91
{0x60d3,{0x06,0x7f,0x16,0x6d,0x56,0x4d,0x16}}, // \xe6\x83\x93
{0x60d8,{0x06,0x7f,0x7f,0x0d,0x39,0x2d,0x7f}}, // \xe6\x83\x98
{0x60da,{0x06,0x7f,0x64,0x33,0x4e,0x52,0x6e}}, // \xe6\x83\x9a
{0x60dc,{0x06,0x7f,0x0a,0x7f,0x5a,0x7f,0x0a}}, // \xe6\x83\x9c
{0x60df,{0x06,0x7f,0x04,0x7f,0x4a,0x7f,0x4a}}, // \xe6\x83\x9f
{0x60e0,{0x62,0x3e,0x5a,0x5f,0x6a,0x1e,0x62}}, // \xe6\x83\xa0
{0x60e1,{0x69,0x3f,0x4b,0x59,0x6b,0x1f,0x69}}, // \xe6\x83\xa1
{0x60e3,{0x6b,0x3f,0x4a,0x54,0x6b,0x16,0x5e}}, // \xe6\x83\xa3
{0x60e7,{0x06,0x7f,0x50,0x1f,0x15,0x1f,0x50}}, // \xe6\x83\xa7
{0x60e8,{0x06,0x7f,0x14,0x4e,0x55,0x2a,0x14}}, // \xe6\x83\xa8
{0x60f0,{0x06,0x7f,0x0a,0x77,0x3a,0x7e,0x0a}}, // \xe6\x83\xb0
{0x60f1,{0x06,0x7f,0x00,0x7a,0x6d,0x5a,0x7d}}, // \xe6\x83\xb1
{0x60f3,{0x6a,0x26,0x5f,0x4a,0x5f,0x15,0x5f}}, // \xe6\x83\xb3
{0x60f4,{0x06,0x7f,0x6b,0x3a,0x6b,0x2a,0x6b}}, // \xe6\x83\xb4
{0x60f6,{0x06,0x7f,0x50,0x5e,0x7b,0x5e,0x50}}, // \xe6\x83\xb6
{0x60f7,{0x6a,0x2a,0x47,0x5b,0x7b,0x06,0x6a}}, // \xe6\x83\xb7
{0x60f9,{0x6a,0x3a,0x4f,0x5a,0x7b,0x1a,0x6a}}, // \xe6\x83\xb9
{0x60fa,{0x06,0x7f,0x48,0x57,0x7d,0x57,0x44}}, // \xe6\x83\xba
{0x60fb,{0x06,0x7f,0x5f,0x15,0x5f,0x0e,0x7f}}, // \xe6\x83\xbb
{0x6100,{0x06,0x7f,0x35,0x7f,0x4c,0x3f,0x44}}, // \xe6\x84\x80
{0x6101,{0x6a,0x27,0x4f,0x47,0x6a,0x07,0x6a}}, // \xe6\x84\x81
{0x6103,{0x06,0x7f,0x46,0x72,0x57,0x76,0x46}}, // \xe6\x84\x83
{0x6106,{0x6a,0x3d,0x40,0x55,0x60,0x15,0x5d}}, // \xe6\x84\x86
{0x6108,{0x64,0x3c,0x5a,0x5d,0x66,0x1c,0x64}}, // \xe6\x84\x88
{0x6109,{0x06,0x7f,0x04,0x72,0x75,0x06,0x74}}, // \xe6\x84\x89
{0x610d,{0x6f,0x2b,0x47,0x4b,0x6a,0x05,0x6b}}, // \xe6\x84\x8d
{0x610e,{0x06,0x7f,0x44,0x53,0x2e,0x5e,0x42}}, // \xe6\x84\x8e
{0x610f,{0x68,0x2a,0x5e,0x5b,0x7e,0x0a,0x68}}, // \xe6\x84\x8f
{0x6115,{0x06,0x7f,0x0b,0x1f,0x1c,0x5f,0x6b}}, // \xe6\x84\x95
{0x611a,{0x60,0x3c,0x57,0x5f,0x6f,0x1c,0x60}}, // \xe6\x84\x9a
{0x611b,{0x4d,0x57,0x2d,0x57,0x3d,0x57,0x4d}}, // \xe6\x84\x9b
{0x611f,{0x68,0x26,0x4e,0x4e,0x62,0x07,0x6a}}, // \xe6\x84\x9f
{0x6121,{0x06,0x7f,0x64,0x2b,0x4e,0x52,0x6e}}, // \xe6\x84\xa1
{0x6127,{0x06,0x7f,0x5e,0x2a,0x7f,0x6a,0x5e}}, // \xe6\x84\xa7
{0x6128,{0x62,0x2e,0x47,0x4e,0x6b,0x05,0x6b}}, // \xe6\x84\xa8
{0x612c,{0x57,0x2e,0x47,0x48,0x67,0x05,0x6f}}, // \xe6\x84\xac
{0x6134,{0x06,0x7f,0x24,0x1e,0x6d,0x62,0x04}}, // \xe6\x84\xb4
{0x613c,{0x06,0x7f,0x58,0x13,0x1e,0x1e,0x52}}, // \xe6\x84\xbc
{0x613d,{0x06,0x7f,0x12,0x3e,0x57,0x7e,0x13}}, // \xe6\x84\xbd
{0x613e,{0x06,0x7f,0x5b,0x2e,0x7e,0x2e,0x7a}}, // \xe6\x84\xbe
{0x613f,{0x50,0x2f,0x49,0x57,0x7f,0x07,0x69}}, // \xe6\x84\xbf
{0x6142,{0x55,0x20,0x5d,0x4d,0x5d,0x0f,0x5d}}, // \xe6\x85\x82
{0x6144,{0x06,0x7f,0x51,0x37,0x7f,0x37,0x51}}, // \xe6\x85\x84
{0x6147,{0x6e,0x26,0x4d,0x40,0x6b,0x05,0x6b}}, // \xe6\x85\x87
{0x6148,{0x62,0x2a,0x57,0x42,0x6a,0x17,0x62}}, // \xe6\x85\x88
{0x614a,{0x06,0x7f,0x52,0x37,0x7e,0x3f,0x4a}}, // \xe6\x85\x8a
{0x614b,{0x62,0x3f,0x4a,0x5f,0x60,0x1b,0x52}}, // \xe6\x85\x8b
{0x614c,{0x06,0x7f,0x42,0x2f,0x6a,0x0b,0x62}}, // \xe6\x85\x8c
{0x614d,{0x06,0x7f,0x02,0x4f,0x6d,0x6b,0x4f}}, // \xe6\x85\x8d
{0x614e,{0x06,0x7f,0x52,0x1e,0x1f,0x1e,0x52}}, // \xe6\x85\x8e
{0x6153,{0x06,0x7f,0x51,0x17,0x77,0x17,0x51}}, // \xe6\x85\x93
{0x6155,{0x4a,0x1a,0x6f,0x0e,0x4f,0x1a,0x4a}}, // \xe6\x85\x95
{0x6158,{0x06,0x7f,0x1a,0x4f,0x5a,0x2d,0x1a}}, // \xe6\x85\x98
{0x6159,{0x6a,0x2e,0x5f,0x4a,0x67,0x1d,0x45}}, // \xe6\x85\x99
{0x615a,{0x06,0x7f,0x2d,0x7f,0x3e,0x0a,0x79}}, // \xe6\x85\x9a
{0x615d,{0x5f,0x35,0x5f,0x5d,0x77,0x1d,0x55}}, // \xe6\x85\x9d
{0x615f,{0x06,0x7f,0x2d,0x3f,0x62,0x1f,0x7e}}, // \xe6\x85\x9f
{0x6162,{0x06,0x7f,0x4c,0x5f,0x2d,0x5f,0x4c}}, // \xe6\x85\xa2
{0x6163,{0x06,0x7f,0x42,0x3f,0x3d,0x3f,0x42}}, // \xe6\x85\xa3
{0x6165,{0x06,0x7f,0x75,0x48,0x7b,0x6f,0x7a}}, // \xe6\x85\xa5
{0x6167,{0x6a,0x2f,0x5a,0x58,0x7a,0x1f,0x6a}}, // \xe6\x85\xa7
{0x6168,{0x06,0x7f,0x3e,0x2e,0x49,0x3f,0x4f}}, // \xe6\x85\xa8
{0x616b,{0x6a,0x3d,0x52,0x4d,0x5e,0x15,0x52}}, // \xe6\x85\xab
{0x616e,{0x40,0x3c,0x64,0x3c,0x5f,0x5a,0x6a}}, // \xe6\x85\xae
{0x616f,{0x06,0x7f,0x24,0x5f,0x3a,0x5e,0x72}}, // \xe6\x85\xaf
{0x6170,{0x50,0x2f,0x5b,0x4b,0x66,0x12,0x5f}}, // \xe6\x85\xb0
{0x6171,{0x06,0x7f,0x12,0x3e,0x5f,0x76,0x1a}}, // \xe6\x85\xb1
{0x6173,{0x06,0x7f,0x47,0x57,0x7b,0x55,0x4b}}, // \xe6\x85\xb3
{0x6174,{0x06,0x7f,0x09,0x65,0x6f,0x75,0x6f}}, // \xe6\x85\xb4
{0x6175,{0x06,0x7f,0x3e,0x7a,0x2e,0x7f,0x7a}}, // \xe6\x85\xb5
{0x6176,{0x40,0x3e,0x5a,0x5e,0x3b,0x6e,0x5a}}, // \xe6\x85\xb6
{0x6177,{0x06,0x7f,0x3e,0x52,0x7f,0x2e,0x56}}, // \xe6\x85\xb7
{0x617e,{0x64,0x3d,0x5a,0x45,0x53,0x0e,0x56}}, // \xe6\x85\xbe
{0x6182,{0x59,0x59,0x5f,0x2f,0x5f,0x59,0x59}}, // \xe6\x86\x82
{0x6187,{0x65,0x2f,0x4d,0x42,0x6f,0x0a,0x6f}}, // \xe6\x86\x87
{0x618a,{0x64,0x3f,0x4a,0x5f,0x6a,0x1f,0x5a}}, // \xe6\x86\x8a
{0x618e,{0x06,0x7f,0x0e,0x7b,0x5e,0x7b,0x0e}}, // \xe6\x86\x8e
{0x6190,{0x06,0x7f,0x55,0x32,0x27,0x72,0x25}}, // \xe6\x86\x90
{0x6191,{0x69,0x20,0x57,0x45,0x57,0x05,0x5d}}, // \xe6\x86\x91
{0x6194,{0x06,0x7f,0x44,0x1f,0x52,0x1f,0x52}}, // \xe6\x86\x94
{0x6196,{0x52,0x2e,0x5f,0x4e,0x52,0x0f,0x52}}, // \xe6\x86\x96
{0x6199,{0x6a,0x3a,0x5e,0x5f,0x7e,0x1a,0x6a}}, // \xe6\x86\x99
{0x619a,{0x06,0x7f,0x23,0x3f,0x7c,0x3f,0x23}}, // \xe6\x86\x9a
{0x61a4,{0x06,0x7f,0x4a,0x3e,0x2b,0x3e,0x4a}}, // \xe6\x86\xa4
{0x61a7,{0x06,0x7f,0x4a,0x5e,0x7b,0x5e,0x4a}}, // \xe6\x86\xa7
{0x61a9,{0x65,0x2f,0x4d,0x45,0x6e,0x0b,0x6e}}, // \xe6\x86\xa9
{0x61ab,{0x06,0x7f,0x7f,0x5b,0x2c,0x5b,0x7f}}, // \xe6\x86\xab
{0x61ac,{0x06,0x7f,0x44,0x1f,0x75,0x1f,0x44}}, // \xe6\x86\xac
{0x61ae,{0x06,0x7f,0x6b,0x3e,0x6a,0x3e,0x6a}}, // \xe6\x86\xae
{0x61b2,{0x66,0x2a,0x5a,0x5f,0x7a,0x0a,0x66}}, // \xe6\x86\xb2
{0x61b6,{0x06,0x7f,0x6a,0x3e,0x5b,0x5e,0x6a}}, // \xe6\x86\xb6
{0x61ba,{0x06,0x7f,0x3c,0x2e,0x75,0x7f,0x2c}}, // \xe6\x86\xba
{0x61be,{0x06,0x7f,0x6e,0x2e,0x42,0x47,0x6a}}, // \xe6\x86\xbe
{0x61c3,{0x52,0x37,0x5e,0x57,0x6a,0x07,0x6e}}, // \xe6\x87\x83
{0x61c6,{0x06,0x7f,0x5c,0x37,0x7d,0x37,0x5c}}, // \xe6\x87\x86
{0x61c7,{0x6a,0x36,0x5d,0x42,0x5f,0x0b,0x54}}, // \xe6\x87\x87
{0x61c8,{0x06,0x7f,0x42,0x3d,0x7f,0x31,0x7b}}, // \xe6\x87\x88
{0x61c9,{0x40,0x3e,0x5a,0x26,0x5b,0x5e,0x76}}, // \xe6\x87\x89
{0x61ca,{0x06,0x7f,0x50,0x5e,0x3f,0x56,0x5e}}, // \xe6\x87\x8a
{0x61cb,{0x6a,0x3f,0x49,0x5d,0x6b,0x1f,0x6a}}, // \xe6\x87\x8b
{0x61cc,{0x06,0x7f,0x2b,0x3b,0x6f,0x3b,0x2b}}, // \xe6\x87\x8c
{0x61cd,{0x06,0x7f,0x52,0x3e,0x7b,0x3e,0x52}}, // \xe6\x87\x8d
{0x61d0,{0x06,0x7f,0x32,0x7e,0x5f,0x3a,0x5e}}, // \xe6\x87\x90
{0x61e3,{0x55,0x20,0x5a,0x4f,0x5a,0x0f,0x5a}}, // \xe6\x87\xa3
{0x61e6,{0x06,0x7f,0x66,0x2b,0x7f,0x2b,0x66}}, // \xe6\x87\xa6
{0x61f2,{0x6a,0x3d,0x4a,0x5b,0x6a,0x0f,0x56}}, // \xe6\x87\xb2
{0x61f4,{0x06,0x7f,0x54,0x7f,0x54,0x3f,0x55}}, // \xe6\x87\xb4
{0x61f6,{0x06,0x7f,0x2e,0x7f,0x5a,0x19,0x5b}}, // \xe6\x87\xb6
{0x61f7,{0x06,0x7f,0x2a,0x6e,0x5f,0x2a,0x4e}}, // \xe6\x87\xb7
{0x61f8,{0x6e,0x3b,0x4b,0x50,0x6d,0x1b,0x69}}, // \xe6\x87\xb8
{0x61fa,{0x06,0x7f,0x55,0x7e,0x55,0x3f,0x55}}, // \xe6\x87\xba
{0x61fc,{0x06,0x7f,0x23,0x7b,0x50,0x7b,0x53}}, // \xe6\x87\xbc
{0x61fd,{0x06,0x7f,0x26,0x7f,0x52,0x7f,0x56}}, // \xe6\x87\xbd
{0x61fe,{0x06,0x7f,0x30,0x75,0x27,0x3f,0x75}}, // \xe6\x87\xbe
{0x61ff,{0x5a,0x77,0x5a,0x65,0x2b,0x46,0x6a}}, // \xe6\x87\xbf
{0x6200,{0x6a,0x3d,0x4a,0x57,0x6a,0x1d,0x68}}, // \xe6\x88\x80
{0x6208,{0x42,0x42,0x42,0x2f,0x32,0x4b,0x62}}, // \xe6\x88\x88
{0x6209,{0x20,0x3e,0x12,0x42,0x5f,0x22,0x53}}, // \xe6\x88\x89
{0x620a,{0x40,0x3e,0x42,0x42,0x2f,0x32,0x4b}}, // \xe6\x88\x8a
{0x620c,{0x40,0x3e,0x0a,0x4a,0x5f,0x22,0x53}}, // \xe6\x88\x8c
{0x620d,{0x40,0x3e,0x0a,0x52,0x5f,0x22,0x53}}, // \xe6\x88\x8d
{0x620e,{0x52,0x3a,0x12,0x42,0x5f,0x22,0x53}}, // \xe6\x88\x8e
{0x6210,{0x40,0x3e,0x4a,0x3a,0x42,0x3f,0x52}}, // \xe6\x88\x90
{0x6211,{0x14,0x56,0x7e,0x15,0x5f,0x24,0x55}}, // \xe6\x88\x91
{0x6212,{0x52,0x3a,0x12,0x7a,0x52,0x3f,0x52}}, // \xe6\x88\x92
{0x6214,{0x12,0x5a,0x5a,0x37,0x36,0x5b,0x6c}}, // \xe6\x88\x94
{0x6216,{0x42,0x5a,0x1a,0x42,0x5f,0x22,0x53}}, // \xe6\x88\x96
{0x621a,{0x40,0x3e,0x22,0x7e,0x2a,0x3f,0x52}}, // \xe6\x88\x9a
{0x621b,{0x11,0x51,0x5f,0x3b,0x3b,0x5f,0x69}}, // \xe6\x88\x9b
{0x621d,{0x5f,0x15,0x5f,0x04,0x5f,0x24,0x55}}, // \xe6\x88\x9d
{0x621e,{0x19,0x49,0x5f,0x3f,0x3f,0x49,0x59}}, // \xe6\x88\x9e
{0x621f,{0x2d,0x77,0x2d,0x44,0x5f,0x24,0x55}}, // \xe6\x88\x9f
{0x6221,{0x72,0x5f,0x72,0x5f,0x44,0x3f,0x55}}, // \xe6\x88\xa1
{0x6226,{0x2d,0x2c,0x7d,0x2c,0x47,0x3c,0x55}}, // \xe6\x88\xa6
{0x622a,{0x24,0x76,0x5f,0x76,0x5f,0x24,0x55}}, // \xe6\x88\xaa
{0x622e,{0x11,0x4b,0x55,0x2b,0x44,0x3f,0x55}}, // \xe6\x88\xae
{0x622f,{0x7c,0x44,0x7f,0x2a,0x44,0x3f,0x55}}, // \xe6\x88\xaf
{0x6230,{0x23,0x3f,0x7c,0x3f,0x23,0x3f,0x55}}, // \xe6\x88\xb0
{0x6232,{0x7c,0x5c,0x6f,0x5a,0x44,0x3f,0x55}}, // \xe6\x88\xb2
{0x6233,{0x21,0x7b,0x71,0x5b,0x44,0x3f,0x55}}, // \xe6\x88\xb3
{0x6234,{0x54,0x1e,0x5f,0x16,0x5f,0x24,0x55}}, // \xe6\x88\xb4
{0x6238,{0x41,0x3d,0x15,0x15,0x15,0x1d,0x01}}, // \xe6\x88\xb8
{0x623b,{0x41,0x3f,0x55,0x55,0x3d,0x57,0x51}}, // \xe6\x88\xbb
{0x623f,{0x41,0x3f,0x55,0x35,0x5d,0x77,0x11}}, // \xe6\x88\xbf
{0x6240,{0x41,0x3d,0x15,0x5d,0x3e,0x0a,0x79}}, // \xe6\x89\x80
{0x6241,{0x41,0x3f,0x75,0x35,0x75,0x37,0x71}}, // \xe6\x89\x81
{0x6247,{0x41,0x3f,0x5b,0x2b,0x7b,0x2b,0x79}}, // \xe6\x89\x87
{0x6248,{0x41,0x3f,0x7d,0x55,0x5d,0x57,0x5d}}, // \xe6\x89\x88
{0x6249,{0x41,0x3f,0x6d,0x3d,0x05,0x7f,0x29}}, // \xe6\x89\x89
{0x624b,{0x14,0x16,0x56,0x7e,0x15,0x15,0x14}}, // \xe6\x89\x8b
{0x624d,{0x22,0x22,0x22,0x52,0x7f,0x0a,0x02}}, // \xe6\x89\x8d
{0x624e,{0x52,0x7f,0x0a,0x00,0x7f,0x40,0x60}}, // \xe6\x89\x8e
{0x6253,{0x52,0x7f,0x0a,0x01,0x41,0x7f,0x01}}, // \xe6\x89\x93
{0x6255,{0x52,0x7f,0x4a,0x70,0x4f,0x20,0x40}}, // \xe6\x89\x95
{0x6258,{0x52,0x7f,0x08,0x0a,0x7e,0x49,0x68}}, // \xe6\x89\x98
{0x625b,{0x52,0x7f,0x0a,0x40,0x42,0x7e,0x42}}, // \xe6\x89\x9b
{0x625e,{0x52,0x7f,0x08,0x09,0x7f,0x09,0x08}}, // \xe6\x89\x9e
{0x6260,{0x52,0x7f,0x44,0x29,0x13,0x29,0x47}}, // \xe6\x89\xa0
{0x6263,{0x52,0x7f,0x0a,0x7e,0x42,0x42,0x7e}}, // \xe6\x89\xa3
{0x6268,{0x52,0x7f,0x0a,0x45,0x3f,0x51,0x7f}}, // \xe6\x89\xa8
{0x626e,{0x52,0x7f,0x44,0x3b,0x48,0x7b,0x04}}, // \xe6\x89\xae
{0x6271,{0x52,0x7f,0x21,0x5f,0x51,0x27,0x5c}}, // \xe6\x89\xb1
{0x6276,{0x52,0x7f,0x48,0x2a,0x1f,0x2a,0x48}}, // \xe6\x89\xb6
{0x6279,{0x52,0x7f,0x40,0x7f,0x24,0x7f,0x44}}, // \xe6\x89\xb9
{0x627c,{0x52,0x7f,0x20,0x1f,0x7d,0x45,0x5d}}, // \xe6\x89\xbc
{0x627e,{0x52,0x7f,0x0a,0x44,0x5f,0x24,0x55}}, // \xe6\x89\xbe
{0x627f,{0x24,0x1c,0x29,0x7d,0x2b,0x18,0x24}}, // \xe6\x89\xbf
{0x6280,{0x52,0x7f,0x4a,0x5a,0x2f,0x5a,0x42}}, // \xe6\x8a\x80
{0x6282,{0x52,0x7f,0x0a,0x41,0x49,0x7f,0x49}}, // \xe6\x8a\x82
{0x6283,{0x52,0x7f,0x02,0x02,0x7f,0x0a,0x12}}, // \xe6\x8a\x83
{0x6284,{0x52,0x7f,0x08,0x46,0x5f,0x22,0x14}}, // \xe6\x8a\x84
{0x6289,{0x52,0x7f,0x48,0x4a,0x3f,0x4e,0x48}}, // \xe6\x8a\x89
{0x628a,{0x52,0x7f,0x3f,0x49,0x4f,0x49,0x6f}}, // \xe6\x8a\x8a
{0x6291,{0x52,0x7f,0x3e,0x11,0x7e,0x02,0x1e}}, // \xe6\x8a\x91
{0x6292,{0x52,0x7f,0x09,0x4b,0x7d,0x0b,0x18}}, // \xe6\x8a\x92
{0x6293,{0x52,0x7f,0x3e,0x02,0x7e,0x3d,0x40}}, // \xe6\x8a\x93
{0x6294,{0x52,0x7f,0x11,0x09,0x7f,0x09,0x11}}, // \xe6\x8a\x94
{0x6295,{0x52,0x7f,0x44,0x5b,0x29,0x5f,0x44}}, // \xe6\x8a\x95
{0x6296,{0x52,0x7f,0x20,0x2a,0x20,0x7f,0x10}}, // \xe6\x8a\x96
{0x6297,{0x52,0x7f,0x42,0x3a,0x0b,0x7a,0x42}}, // \xe6\x8a\x97
{0x6298,{0x52,0x7f,0x20,0x1e,0x0a,0x79,0x08}}, // \xe6\x8a\x98
{0x629b,{0x52,0x7f,0x42,0x3f,0x52,0x4f,0x5e}}, // \xe6\x8a\x9b
{0x629c,{0x52,0x7f,0x22,0x5f,0x2a,0x5a,0x42}}, // \xe6\x8a\x9c
{0x629e,{0x52,0x7f,0x40,0x3f,0x05,0x1d,0x67}}, // \xe6\x8a\x9e
{0x62ab,{0x52,0x7f,0x3e,0x5a,0x2f,0x5a,0x46}}, // \xe6\x8a\xab
{0x62ac,{0x52,0x7f,0x08,0x6c,0x6b,0x64,0x08}}, // \xe6\x8a\xac
{0x62b1,{0x52,0x7f,0x04,0x77,0x5e,0x42,0x5e}}, // \xe6\x8a\xb1
{0x62b5,{0x52,0x7f,0x00,0x7e,0x4a,0x5e,0x69}}, // \xe6\x8a\xb5
{0x62b9,{0x52,0x7f,0x42,0x2a,0x7f,0x2a,0x42}}, // \xe6\x8a\xb9
{0x62bb,{0x52,0x7f,0x3e,0x2a,0x7f,0x2a,0x3e}}, // \xe6\x8a\xbb
{0x62bc,{0x52,0x7f,0x1f,0x15,0x7f,0x15,0x1f}}, // \xe6\x8a\xbc
{0x62bd,{0x52,0x7f,0x7e,0x4a,0x7f,0x4a,0x7e}}, // \xe6\x8a\xbd
{0x62c2,{0x52,0x7f,0x5a,0x3f,0x16,0x7f,0x36}}, // \xe6\x8b\x82
{0x62c5,{0x52,0x7f,0x0a,0x5f,0x55,0x55,0x5f}}, // \xe6\x8b\x85
{0x62c6,{0x52,0x7f,0x40,0x3e,0x1a,0x79,0x28}}, // \xe6\x8b\x86
{0x62c7,{0x52,0x7f,0x38,0x2f,0x69,0x7f,0x28}}, // \xe6\x8b\x87
{0x62c8,{0x52,0x7f,0x0a,0x70,0x5f,0x54,0x74}}, // \xe6\x8b\x88
{0x62c9,{0x52,0x7f,0x42,0x7e,0x63,0x5e,0x42}}, // \xe6\x8b\x89
{0x62ca,{0x52,0x7f,0x04,0x7e,0x09,0x42,0x7f}}, // \xe6\x8b\x8a
{0x62cc,{0x52,0x7f,0x2a,0x29,0x7c,0x29,0x2a}}, // \xe6\x8b\x8c
{0x62cd,{0x52,0x7f,0x0a,0x7e,0x4b,0x4a,0x7e}}, // \xe6\x8b\x8d
{0x62cf,{0x2a,0x3e,0x7b,0x76,0x3b,0x35,0x2b}}, // \xe6\x8b\x8f
{0x62d0,{0x52,0x7f,0x0a,0x57,0x35,0x55,0x77}}, // \xe6\x8b\x90
{0x62d1,{0x52,0x7f,0x02,0x7f,0x4a,0x7f,0x02}}, // \xe6\x8b\x91
{0x62d2,{0x52,0x7f,0x0a,0x7f,0x55,0x55,0x5d}}, // \xe6\x8b\x92
{0x62d3,{0x52,0x7f,0x0a,0x11,0x7f,0x49,0x79}}, // \xe6\x8b\x93
{0x62d4,{0x52,0x7f,0x0a,0x22,0x5f,0x22,0x5b}}, // \xe6\x8b\x94
{0x62d7,{0x52,0x7f,0x64,0x5b,0x64,0x1f,0x7e}}, // \xe6\x8b\x97
{0x62d8,{0x52,0x7f,0x04,0x1b,0x1a,0x42,0x7e}}, // \xe6\x8b\x98
{0x62d9,{0x52,0x7f,0x76,0x44,0x7f,0x44,0x76}}, // \xe6\x8b\x99
{0x62db,{0x52,0x7f,0x0a,0x75,0x53,0x59,0x7f}}, // \xe6\x8b\x9b
{0x62dc,{0x56,0x3e,0x15,0x21,0x2b,0x7f,0x2b}}, // \xe6\x8b\x9c
{0x62dd,{0x52,0x7f,0x21,0x2b,0x7f,0x2b,0x21}}, // \xe6\x8b\x9d
{0x62e0,{0x52,0x7f,0x4c,0x33,0x5e,0x42,0x5e}}, // \xe6\x8b\xa0
{0x62e1,{0x52,0x7f,0x20,0x1e,0x62,0x5b,0x62}}, // \xe6\x8b\xa1
{0x62ec,{0x52,0x7f,0x04,0x76,0x5e,0x75,0x04}}, // \xe6\x8b\xac
{0x62ed,{0x52,0x7f,0x54,0x74,0x57,0x3c,0x45}}, // \xe6\x8b\xad
{0x62ee,{0x52,0x7f,0x02,0x6a,0x6f,0x6a,0x02}}, // \xe6\x8b\xae
{0x62ef,{0x52,0x7f,0x54,0x4d,0x7d,0x4b,0x54}}, // \xe6\x8b\xaf
{0x62f1,{0x52,0x7f,0x52,0x1f,0x12,0x1f,0x52}}, // \xe6\x8b\xb1
{0x62f3,{0x14,0x2d,0x76,0x77,0x36,0x2d,0x14}}, // \xe6\x8b\xb3
{0x62f5,{0x52,0x7f,0x0a,0x7e,0x23,0x76,0x2e}}, // \xe6\x8b\xb5
{0x62f6,{0x52,0x7f,0x0a,0x52,0x5d,0x2a,0x1d}}, // \xe6\x8b\xb6
{0x62f7,{0x52,0x7f,0x28,0x1a,0x3f,0x2a,0x69}}, // \xe6\x8b\xb7
{0x62fe,{0x52,0x7f,0x04,0x72,0x55,0x76,0x04}}, // \xe6\x8b\xbe
{0x62ff,{0x24,0x34,0x7e,0x7d,0x3e,0x34,0x24}}, // \xe6\x8b\xbf
{0x6301,{0x52,0x7f,0x28,0x6a,0x2f,0x7a,0x28}}, // \xe6\x8c\x81
{0x6302,{0x52,0x7f,0x48,0x5a,0x7f,0x5a,0x48}}, // \xe6\x8c\x82
{0x6307,{0x52,0x7f,0x00,0x6f,0x6a,0x6a,0x6d}}, // \xe6\x8c\x87
{0x6308,{0x2a,0x3f,0x76,0x70,0x39,0x37,0x2f}}, // \xe6\x8c\x88
{0x6309,{0x52,0x7f,0x4e,0x5a,0x2f,0x3a,0x4e}}, // \xe6\x8c\x89
{0x630c,{0x52,0x7f,0x10,0x6a,0x65,0x6b,0x10}}, // \xe6\x8c\x8c
{0x6311,{0x52,0x7f,0x4a,0x3f,0x00,0x7f,0x4a}}, // \xe6\x8c\x91
{0x6319,{0x2a,0x37,0x7a,0x7b,0x3a,0x37,0x2a}}, // \xe6\x8c\x99
{0x631f,{0x52,0x7f,0x5a,0x52,0x3f,0x52,0x5a}}, // \xe6\x8c\x9f
{0x6327,{0x52,0x7f,0x29,0x15,0x7f,0x15,0x7f}}, // \xe6\x8c\xa7
{0x6328,{0x52,0x7f,0x0a,0x56,0x5d,0x34,0x56}}, // \xe6\x8c\xa8
{0x632b,{0x52,0x7f,0x44,0x53,0x7c,0x53,0x44}}, // \xe6\x8c\xab
{0x632f,{0x52,0x7f,0x20,0x7f,0x51,0x35,0x55}}, // \xe6\x8c\xaf
{0x633a,{0x52,0x7f,0x55,0x3b,0x6a,0x7e,0x69}}, // \xe6\x8c\xba
{0x633d,{0x52,0x7f,0x5c,0x36,0x1d,0x77,0x5c}}, // \xe6\x8c\xbd
{0x633e,{0x52,0x7f,0x52,0x4e,0x3f,0x4e,0x52}}, // \xe6\x8c\xbe
{0x633f,{0x52,0x7f,0x3a,0x2a,0x7e,0x29,0x39}}, // \xe6\x8c\xbf
{0x6349,{0x52,0x7f,0x40,0x37,0x45,0x7d,0x57}}, // \xe6\x8d\x89
{0x634c,{0x52,0x7f,0x67,0x1d,0x77,0x0e,0x7f}}, // \xe6\x8d\x8c
{0x634d,{0x52,0x7f,0x28,0x2f,0x7d,0x2f,0x28}}, // \xe6\x8d\x8d
{0x634f,{0x52,0x7f,0x0a,0x47,0x55,0x7d,0x57}}, // \xe6\x8d\x8f
{0x6350,{0x52,0x7f,0x0a,0x78,0x2b,0x2b,0x78}}, // \xe6\x8d\x90
{0x6355,{0x52,0x7f,0x7a,0x2a,0x7f,0x2a,0x7b}}, // \xe6\x8d\x95
{0x6357,{0x52,0x7f,0x18,0x4e,0x58,0x2f,0x1a}}, // \xe6\x8d\x97
{0x635c,{0x52,0x7f,0x4e,0x5a,0x2f,0x5a,0x4e}}, // \xe6\x8d\x9c
{0x6367,{0x52,0x7f,0x14,0x2e,0x77,0x2e,0x14}}, // \xe6\x8d\xa7
{0x6368,{0x52,0x7f,0x14,0x7a,0x5d,0x7a,0x14}}, // \xe6\x8d\xa8
{0x6369,{0x52,0x7f,0x21,0x5f,0x55,0x3d,0x57}}, // \xe6\x8d\xa9
{0x636b,{0x52,0x7f,0x7f,0x07,0x00,0x47,0x7f}}, // \xe6\x8d\xab
{0x636e,{0x52,0x7f,0x20,0x1f,0x6b,0x5f,0x6b}}, // \xe6\x8d\xae
{0x6372,{0x52,0x7f,0x15,0x6e,0x57,0x4e,0x15}}, // \xe6\x8d\xb2
{0x6376,{0x52,0x7f,0x54,0x5d,0x77,0x5d,0x54}}, // \xe6\x8d\xb6
{0x6377,{0x52,0x7f,0x40,0x2a,0x4a,0x7f,0x56}}, // \xe6\x8d\xb7
{0x637a,{0x52,0x7f,0x4a,0x16,0x73,0x16,0x4a}}, // \xe6\x8d\xba
{0x637b,{0x52,0x7f,0x64,0x2a,0x4d,0x5e,0x64}}, // \xe6\x8d\xbb
{0x6380,{0x52,0x7f,0x1e,0x7d,0x44,0x3b,0x46}}, // \xe6\x8e\x80
{0x6383,{0x52,0x7f,0x0c,0x35,0x7d,0x37,0x0c}}, // \xe6\x8e\x83
{0x6388,{0x52,0x7f,0x4d,0x57,0x35,0x57,0x4d}}, // \xe6\x8e\x88
{0x6389,{0x52,0x7f,0x2a,0x3c,0x77,0x3e,0x22}}, // \xe6\x8e\x89
{0x638c,{0x26,0x33,0x7e,0x7b,0x3e,0x33,0x26}}, // \xe6\x8e\x8c
{0x638e,{0x52,0x7f,0x12,0x5a,0x17,0x7a,0x12}}, // \xe6\x8e\x8e
{0x638f,{0x52,0x7f,0x64,0x4b,0x7e,0x6a,0x7e}}, // \xe6\x8e\x8f
{0x6392,{0x52,0x7f,0x2a,0x7f,0x00,0x7f,0x2a}}, // \xe6\x8e\x92
{0x6396,{0x52,0x7f,0x0a,0x7e,0x53,0x2a,0x5a}}, // \xe6\x8e\x96
{0x6398,{0x52,0x7f,0x1f,0x65,0x4d,0x7d,0x6f}}, // \xe6\x8e\x98
{0x639b,{0x52,0x7f,0x2a,0x3f,0x2a,0x7f,0x08}}, // \xe6\x8e\x9b
{0x639f,{0x52,0x7f,0x46,0x32,0x46,0x7f,0x56}}, // \xe6\x8e\x9f
{0x63a0,{0x52,0x7f,0x22,0x4e,0x7b,0x0e,0x22}}, // \xe6\x8e\xa0
{0x63a1,{0x52,0x7f,0x56,0x32,0x76,0x39,0x55}}, // \xe6\x8e\xa1
{0x63a2,{0x52,0x7f,0x5b,0x35,0x71,0x3d,0x5b}}, // \xe6\x8e\xa2
{0x63a3,{0x24,0x3b,0x7f,0x7a,0x36,0x30,0x2f}}, // \xe6\x8e\xa3
{0x63a5,{0x52,0x7f,0x4a,0x5e,0x2b,0x3e,0x4a}}, // \xe6\x8e\xa5
{0x63a7,{0x52,0x7f,0x46,0x56,0x73,0x56,0x46}}, // \xe6\x8e\xa7
{0x63a8,{0x52,0x7f,0x04,0x7f,0x4a,0x7f,0x4a}}, // \xe6\x8e\xa8
{0x63a9,{0x52,0x7f,0x0a,0x36,0x3b,0x76,0x4a}}, // \xe6\x8e\xa9
{0x63aa,{0x52,0x7f,0x0a,0x7f,0x5a,0x7f,0x0a}}, // \xe6\x8e\xaa
{0x63ab,{0x52,0x7f,0x21,0x3f,0x7f,0x12,0x2e}}, // \xe6\x8e\xab
{0x63ac,{0x52,0x7f,0x04,0x57,0x3a,0x56,0x7e}}, // \xe6\x8e\xac
{0x63b2,{0x52,0x7f,0x10,0x3f,0x2d,0x4f,0x78}}, // \xe6\x8e\xb2
{0x63b4,{0x52,0x7f,0x41,0x6b,0x7f,0x6b,0x7f}}, // \xe6\x8e\xb4
{0x63b5,{0x52,0x7f,0x34,0x32,0x05,0x76,0x34}}, // \xe6\x8e\xb5
{0x63bb,{0x52,0x7f,0x49,0x5b,0x7d,0x5b,0x68}}, // \xe6\x8e\xbb
{0x63be,{0x52,0x7f,0x2c,0x56,0x7d,0x27,0x55}}, // \xe6\x8e\xbe
{0x63c0,{0x52,0x7f,0x42,0x2e,0x7f,0x2e,0x4e}}, // \xe6\x8f\x80
{0x63c3,{0x52,0x7f,0x7a,0x2b,0x7a,0x03,0x7a}}, // \xe6\x8f\x83
{0x63c4,{0x52,0x7f,0x05,0x73,0x75,0x26,0x54}}, // \xe6\x8f\x84
{0x63c6,{0x52,0x7f,0x55,0x5b,0x39,0x5a,0x55}}, // \xe6\x8f\x86
{0x63c9,{0x52,0x7f,0x5a,0x37,0x7f,0x33,0x56}}, // \xe6\x8f\x89
{0x63cf,{0x52,0x7f,0x7a,0x5f,0x7a,0x5f,0x7a}}, // \xe6\x8f\x8f
{0x63d0,{0x52,0x7f,0x42,0x34,0x47,0x7f,0x54}}, // \xe6\x8f\x90
{0x63d2,{0x52,0x7f,0x74,0x56,0x7e,0x55,0x74}}, // \xe6\x8f\x92
{0x63d6,{0x52,0x7f,0x24,0x3f,0x2d,0x7f,0x24}}, // \xe6\x8f\x96
{0x63da,{0x52,0x7f,0x24,0x5f,0x35,0x57,0x74}}, // \xe6\x8f\x9a
{0x63db,{0x52,0x7f,0x52,0x5d,0x3d,0x5f,0x50}}, // \xe6\x8f\x9b
{0x63e1,{0x52,0x7f,0x20,0x5f,0x5b,0x77,0x53}}, // \xe6\x8f\xa1
{0x63e3,{0x52,0x7f,0x6b,0x3a,0x6b,0x2a,0x6b}}, // \xe6\x8f\xa3
{0x63e9,{0x52,0x7f,0x0f,0x6a,0x70,0x6f,0x0a}}, // \xe6\x8f\xa9
{0x63ee,{0x52,0x7f,0x27,0x3d,0x7f,0x3d,0x27}}, // \xe6\x8f\xae
{0x63f4,{0x52,0x7f,0x46,0x2a,0x5e,0x29,0x5d}}, // \xe6\x8f\xb4
{0x63f6,{0x52,0x7f,0x21,0x3f,0x2d,0x7f,0x1b}}, // \xe6\x8f\xb6
{0x63fa,{0x52,0x7f,0x68,0x4a,0x7e,0x49,0x6b}}, // \xe6\x8f\xba
{0x6406,{0x52,0x7f,0x2a,0x7f,0x3a,0x7f,0x2a}}, // \xe6\x90\x86
{0x640d,{0x52,0x7f,0x0a,0x5c,0x17,0x17,0x5c}}, // \xe6\x90\x8d
{0x640f,{0x52,0x7f,0x12,0x3e,0x57,0x7e,0x13}}, // \xe6\x90\x8f
{0x6413,{0x52,0x7f,0x4a,0x3b,0x5e,0x7b,0x5a}}, // \xe6\x90\x93
{0x6416,{0x52,0x7f,0x10,0x6a,0x4d,0x7b,0x68}}, // \xe6\x90\x96
{0x6417,{0x52,0x7f,0x0a,0x5e,0x77,0x56,0x70}}, // \xe6\x90\x97
{0x641c,{0x52,0x7f,0x4e,0x59,0x2e,0x59,0x4f}}, // \xe6\x90\x9c
{0x6426,{0x52,0x7f,0x0a,0x5d,0x77,0x5d,0x77}}, // \xe6\x90\xa6
{0x6428,{0x52,0x7f,0x48,0x2f,0x7d,0x2f,0x78}}, // \xe6\x90\xa8
{0x642c,{0x52,0x7f,0x7e,0x13,0x7e,0x29,0x5b}}, // \xe6\x90\xac
{0x642d,{0x52,0x7f,0x12,0x7b,0x56,0x7b,0x12}}, // \xe6\x90\xad
{0x6434,{0x16,0x2a,0x7e,0x7b,0x3e,0x2a,0x16}}, // \xe6\x90\xb4
{0x6436,{0x52,0x7f,0x24,0x1e,0x6d,0x62,0x04}}, // \xe6\x90\xb6
{0x643a,{0x52,0x7f,0x54,0x3f,0x1a,0x3f,0x6a}}, // \xe6\x90\xba
{0x643e,{0x52,0x7f,0x26,0x1e,0x73,0x36,0x26}}, // \xe6\x90\xbe
{0x6442,{0x52,0x7f,0x59,0x2f,0x09,0x2f,0x59}}, // \xe6\x91\x82
{0x644e,{0x52,0x7f,0x11,0x4b,0x54,0x29,0x13}}, // \xe6\x91\x8e
{0x6458,{0x52,0x7f,0x7a,0x6e,0x5b,0x6e,0x7a}}, // \xe6\x91\x98
{0x6467,{0x52,0x7f,0x13,0x7e,0x4b,0x7e,0x4b}}, // \xe6\x91\xa7
{0x6469,{0x40,0x3e,0x2a,0x7e,0x6b,0x3e,0x2a}}, // \xe6\x91\xa9
{0x646f,{0x24,0x2e,0x7f,0x7a,0x37,0x3e,0x28}}, // \xe6\x91\xaf
{0x6476,{0x52,0x7f,0x12,0x3e,0x5f,0x76,0x1a}}, // \xe6\x91\xb6
{0x6478,{0x52,0x7f,0x52,0x5f,0x36,0x5f,0x52}}, // \xe6\x91\xb8
{0x647a,{0x52,0x7f,0x05,0x6f,0x70,0x65,0x0f}}, // \xe6\x91\xba
{0x6483,{0x2a,0x2e,0x7f,0x76,0x3b,0x35,0x2b}}, // \xe6\x92\x83
{0x6488,{0x52,0x7f,0x4d,0x36,0x5d,0x76,0x0d}}, // \xe6\x92\x88
{0x6492,{0x52,0x7f,0x0a,0x7f,0x7e,0x23,0x5e}}, // \xe6\x92\x92
{0x6493,{0x52,0x7f,0x5c,0x3e,0x17,0x7e,0x5c}}, // \xe6\x92\x93
{0x6495,{0x52,0x7f,0x5f,0x1a,0x5f,0x3e,0x79}}, // \xe6\x92\x95
{0x649a,{0x52,0x7f,0x54,0x0b,0x56,0x0f,0x52}}, // \xe6\x92\x9a
{0x649e,{0x52,0x7f,0x4a,0x5e,0x7b,0x5e,0x4a}}, // \xe6\x92\x9e
{0x64a4,{0x52,0x7f,0x0a,0x77,0x72,0x3f,0x5e}}, // \xe6\x92\xa4
{0x64a5,{0x52,0x7f,0x55,0x3b,0x59,0x2a,0x5d}}, // \xe6\x92\xa5
{0x64a9,{0x52,0x7f,0x4a,0x1e,0x6b,0x1e,0x4a}}, // \xe6\x92\xa9
{0x64ab,{0x52,0x7f,0x6b,0x3e,0x6a,0x3e,0x6a}}, // \xe6\x92\xab
{0x64ad,{0x52,0x7f,0x15,0x6f,0x7d,0x6f,0x15}}, // \xe6\x92\xad
{0x64ae,{0x52,0x7f,0x24,0x3f,0x7d,0x2f,0x5c}}, // \xe6\x92\xae
{0x64b0,{0x52,0x7f,0x4d,0x1b,0x10,0x1d,0x4b}}, // \xe6\x92\xb0
{0x64b2,{0x52,0x7f,0x4b,0x5e,0x3b,0x5e,0x4b}}, // \xe6\x92\xb2
{0x64b9,{0x52,0x7f,0x45,0x3a,0x3b,0x7a,0x45}}, // \xe6\x92\xb9
{0x64bb,{0x52,0x7f,0x69,0x54,0x5e,0x77,0x5e}}, // \xe6\x92\xbb
{0x64bc,{0x52,0x7f,0x6e,0x2e,0x42,0x47,0x6a}}, // \xe6\x92\xbc
{0x64c1,{0x52,0x7f,0x5a,0x36,0x0b,0x7e,0x56}}, // \xe6\x93\x81
{0x64c2,{0x52,0x7f,0x76,0x53,0x77,0x53,0x76}}, // \xe6\x93\x82
{0x64c5,{0x52,0x7f,0x4e,0x7e,0x5b,0x7e,0x4e}}, // \xe6\x93\x85
{0x64c7,{0x52,0x7f,0x2b,0x3b,0x6f,0x3b,0x2b}}, // \xe6\x93\x87
{0x64cd,{0x52,0x7f,0x5c,0x37,0x7d,0x37,0x5c}}, // \xe6\x93\x8d
{0x64d2,{0x52,0x7f,0x7a,0x4e,0x7d,0x2e,0x7a}}, // \xe6\x93\x92
{0x64d4,{0x52,0x7f,0x3c,0x2e,0x75,0x7f,0x2c}}, // \xe6\x93\x94
{0x64d8,{0x24,0x3f,0x7b,0x70,0x36,0x3b,0x26}}, // \xe6\x93\x98
{0x64da,{0x52,0x7f,0x7c,0x2c,0x57,0x7a,0x2a}}, // \xe6\x93\x9a
{0x64e0,{0x52,0x7f,0x4a,0x36,0x2b,0x76,0x0a}}, // \xe6\x93\xa0
{0x64e1,{0x52,0x7f,0x5a,0x6e,0x7f,0x6e,0x5a}}, // \xe6\x93\xa1
{0x64e2,{0x52,0x7f,0x25,0x7f,0x50,0x7d,0x57}}, // \xe6\x93\xa2
{0x64e3,{0x52,0x7f,0x34,0x36,0x5f,0x76,0x14}}, // \xe6\x93\xa3
{0x64e6,{0x52,0x7f,0x56,0x2a,0x67,0x2a,0x56}}, // \xe6\x93\xa6
{0x64e7,{0x28,0x1e,0x69,0x7e,0x2d,0x1f,0x28}}, // \xe6\x93\xa7
{0x64ec,{0x52,0x7f,0x57,0x3a,0x5a,0x3d,0x57}}, // \xe6\x93\xac
{0x64ef,{0x52,0x7f,0x4e,0x3a,0x37,0x3a,0x46}}, // \xe6\x93\xaf
{0x64f1,{0x52,0x7f,0x7f,0x2b,0x74,0x6f,0x7f}}, // \xe6\x93\xb1
{0x64f2,{0x52,0x7f,0x5a,0x39,0x5a,0x7f,0x1b}}, // \xe6\x93\xb2
{0x64f4,{0x52,0x7f,0x3e,0x4a,0x3e,0x3f,0x4a}}, // \xe6\x93\xb4
{0x64f6,{0x52,0x7f,0x7b,0x2e,0x78,0x0b,0x7e}}, // \xe6\x93\xb6
{0x64fa,{0x52,0x7f,0x7b,0x77,0x03,0x6f,0x4b}}, // \xe6\x93\xba
{0x64fd,{0x52,0x7f,0x5a,0x35,0x7f,0x3a,0x55}}, // \xe6\x93\xbd
{0x64fe,{0x52,0x7f,0x59,0x5f,0x2f,0x5f,0x59}}, // \xe6\x93\xbe
{0x6500,{0x2a,0x1f,0x6a,0x7d,0x2a,0x1f,0x2a}}, // \xe6\x94\x80
{0x6505,{0x52,0x7f,0x4a,0x37,0x3a,0x37,0x4a}}, // \xe6\x94\x85
{0x6518,{0x52,0x7f,0x36,0x7e,0x5b,0x3e,0x56}}, // \xe6\x94\x98
{0x651c,{0x52,0x7f,0x6b,0x3e,0x57,0x3e,0x77}}, // \xe6\x94\x9c
{0x651d,{0x52,0x7f,0x30,0x75,0x27,0x3f,0x75}}, // \xe6\x94\x9d
{0x6523,{0x2a,0x3d,0x6a,0x77,0x2a,0x3d,0x28}}, // \xe6\x94\xa3
{0x6524,{0x52,0x7f,0x5b,0x3e,0x5b,0x7e,0x55}}, // \xe6\x94\xa4
{0x652a,{0x52,0x7f,0x4e,0x35,0x36,0x75,0x4f}}, // \xe6\x94\xaa
{0x652b,{0x52,0x7f,0x43,0x5f,0x2c,0x5f,0x4b}}, // \xe6\x94\xab
{0x652c,{0x52,0x7f,0x47,0x3d,0x38,0x7f,0x46}}, // \xe6\x94\xac
{0x652f,{0x42,0x4a,0x5a,0x2f,0x5a,0x42,0x42}}, // \xe6\x94\xaf
{0x6534,{0x40,0x48,0x58,0x2f,0x5a,0x42,0x40}}, // \xe6\x94\xb4
{0x6535,{0x48,0x44,0x2b,0x12,0x2e,0x42,0x40}}, // \xe6\x94\xb5
{0x6536,{0x3e,0x20,0x7f,0x44,0x5f,0x22,0x5e}}, // \xe6\x94\xb6
{0x6537,{0x01,0x4f,0x79,0x44,0x5f,0x22,0x5e}}, // \xe6\x94\xb7
{0x6538,{0x04,0x7e,0x3f,0x44,0x5f,0x22,0x5e}}, // \xe6\x94\xb8
{0x6539,{0x3d,0x25,0x37,0x44,0x5f,0x22,0x5e}}, // \xe6\x94\xb9
{0x653b,{0x22,0x3e,0x12,0x44,0x5f,0x22,0x5e}}, // \xe6\x94\xbb
{0x653e,{0x42,0x3e,0x4b,0x7a,0x5c,0x23,0x5e}}, // \xe6\x94\xbe
{0x653f,{0x79,0x41,0x3f,0x29,0x5c,0x23,0x5e}}, // \xe6\x94\xbf
{0x6545,{0x3a,0x2f,0x3a,0x44,0x5f,0x22,0x5e}}, // \xe6\x95\x85
{0x6548,{0x4a,0x56,0x23,0x56,0x5c,0x23,0x5e}}, // \xe6\x95\x88
{0x654d,{0x54,0x16,0x7d,0x16,0x58,0x2f,0x5a}}, // \xe6\x95\x8d
{0x654f,{0x33,0x2e,0x7e,0x2a,0x5c,0x23,0x5e}}, // \xe6\x95\x8f
{0x6551,{0x2a,0x52,0x7f,0x2a,0x5c,0x23,0x5e}}, // \xe6\x95\x91
{0x6555,{0x42,0x2e,0x7f,0x2e,0x5c,0x23,0x5e}}, // \xe6\x95\x95
{0x6556,{0x4a,0x3f,0x6a,0x44,0x5f,0x22,0x5e}}, // \xe6\x95\x96
{0x6557,{0x5f,0x15,0x5f,0x04,0x5f,0x22,0x5e}}, // \xe6\x95\x97
{0x6558,{0x54,0x16,0x7d,0x16,0x5c,0x23,0x5e}}, // \xe6\x95\x98
{0x6559,{0x28,0x1a,0x6f,0x3a,0x5c,0x23,0x5e}}, // \xe6\x95\x99
{0x655d,{0x7a,0x29,0x7f,0x7a,0x5c,0x23,0x5e}}, // \xe6\x95\x9d
{0x655e,{0x7a,0x09,0x6f,0x7a,0x5c,0x23,0x5e}}, // \xe6\x95\x9e
{0x6562,{0x24,0x3d,0x27,0x7d,0x5c,0x23,0x5e}}, // \xe6\x95\xa2
{0x6563,{0x0a,0x7f,0x2a,0x7f,0x5c,0x23,0x5e}}, // \xe6\x95\xa3
{0x6566,{0x22,0x2e,0x7b,0x1e,0x5c,0x23,0x5e}}, // \xe6\x95\xa6
{0x656c,{0x12,0x2f,0x4a,0x7f,0x5c,0x23,0x5e}}, // \xe6\x95\xac
{0x6570,{0x55,0x7a,0x57,0x32,0x5d,0x23,0x5e}}, // \xe6\x95\xb0
{0x6572,{0x72,0x1e,0x5b,0x1e,0x78,0x2f,0x5a}}, // \xe6\x95\xb2
{0x6574,{0x5a,0x76,0x5f,0x76,0x7a,0x75,0x5b}}, // \xe6\x95\xb4
{0x6575,{0x7a,0x6e,0x5b,0x6e,0x7c,0x23,0x5e}}, // \xe6\x95\xb5
{0x6577,{0x52,0x3e,0x7f,0x12,0x5c,0x23,0x5e}}, // \xe6\x95\xb7
{0x6578,{0x54,0x7e,0x5b,0x36,0x5c,0x23,0x5e}}, // \xe6\x95\xb8
{0x6582,{0x5c,0x36,0x5d,0x36,0x5c,0x23,0x5e}}, // \xe6\x96\x82
{0x6583,{0x52,0x7d,0x36,0x1d,0x7a,0x55,0x5b}}, // \xe6\x96\x83
{0x6587,{0x42,0x42,0x2e,0x13,0x2e,0x42,0x42}}, // \xe6\x96\x87
{0x6588,{0x22,0x32,0x36,0x6b,0x36,0x32,0x22}}, // \xe6\x96\x88
{0x6589,{0x12,0x52,0x36,0x2b,0x76,0x12,0x12}}, // \xe6\x96\x89
{0x658c,{0x4a,0x33,0x4e,0x75,0x65,0x3e,0x45}}, // \xe6\x96\x8c
{0x658e,{0x4a,0x3a,0x2e,0x77,0x2e,0x7a,0x0a}}, // \xe6\x96\x8e
{0x6590,{0x4a,0x4a,0x5f,0x28,0x5f,0x4a,0x4a}}, // \xe6\x96\x90
{0x6591,{0x29,0x3f,0x4a,0x33,0x4e,0x7f,0x49}}, // \xe6\x96\x91
{0x6597,{0x20,0x25,0x2a,0x20,0x7f,0x10,0x10}}, // \xe6\x96\x97
{0x6599,{0x35,0x7e,0x25,0x2a,0x20,0x7f,0x10}}, // \xe6\x96\x99
{0x659b,{0x42,0x3d,0x5f,0x7c,0x2a,0x20,0x7f}}, // \xe6\x96\x9b
{0x659c,{0x54,0x16,0x7d,0x56,0x2a,0x20,0x7f}}, // \xe6\x96\x9c
{0x659f,{0x72,0x5f,0x72,0x5f,0x2a,0x20,0x7f}}, // \xe6\x96\x9f
{0x65a1,{0x2d,0x77,0x2d,0x2a,0x21,0x7e,0x24}}, // \xe6\x96\xa1
{0x65a4,{0x40,0x3e,0x0a,0x0a,0x79,0x09,0x08}}, // \xe6\x96\xa4
{0x65a5,{0x40,0x3e,0x0a,0x1a,0x79,0x29,0x08}}, // \xe6\x96\xa5
{0x65a7,{0x4a,0x3a,0x15,0x14,0x75,0x1a,0x0a}}, // \xe6\x96\xa7
{0x65ab,{0x09,0x37,0x31,0x40,0x3e,0x0a,0x79}}, // \xe6\x96\xab
{0x65ac,{0x2d,0x7f,0x2d,0x1e,0x0a,0x79,0x08}}, // \xe6\x96\xac
{0x65ad,{0x7f,0x55,0x4e,0x55,0x3e,0x0a,0x79}}, // \xe6\x96\xad
{0x65af,{0x52,0x1f,0x1a,0x5f,0x3e,0x0a,0x79}}, // \xe6\x96\xaf
{0x65b0,{0x52,0x36,0x7b,0x36,0x5e,0x0a,0x79}}, // \xe6\x96\xb0
{0x65b7,{0x7f,0x6a,0x5d,0x6a,0x5d,0x3e,0x79}}, // \xe6\x96\xb7
{0x65b9,{0x42,0x22,0x1e,0x0b,0x4a,0x7a,0x02}}, // \xe6\x96\xb9
{0x65bc,{0x42,0x3e,0x4b,0x7a,0x02,0x29,0x52}}, // \xe6\x96\xbc
{0x65bd,{0x62,0x1f,0x7a,0x14,0x7f,0x4a,0x5a}}, // \xe6\x96\xbd
{0x65c1,{0x5a,0x4a,0x3e,0x2b,0x2a,0x6e,0x1a}}, // \xe6\x97\x81
{0x65c3,{0x62,0x1f,0x7a,0x24,0x7b,0x2a,0x7a}}, // \xe6\x97\x83
{0x65c4,{0x62,0x1f,0x7a,0x04,0x2b,0x7e,0x56}}, // \xe6\x97\x84
{0x65c5,{0x62,0x1f,0x7a,0x14,0x7b,0x26,0x52}}, // \xe6\x97\x85
{0x65c6,{0x62,0x1f,0x7a,0x0c,0x3b,0x7e,0x3a}}, // \xe6\x97\x86
{0x65cb,{0x62,0x1f,0x7a,0x44,0x2b,0x7a,0x5a}}, // \xe6\x97\x8b
{0x65cc,{0x62,0x1f,0x7a,0x24,0x5b,0x7a,0x52}}, // \xe6\x97\x8c
{0x65cf,{0x62,0x1f,0x7a,0x14,0x5f,0x3a,0x52}}, // \xe6\x97\x8f
{0x65d2,{0x62,0x1f,0x7a,0x04,0x63,0x0e,0x6a}}, // \xe6\x97\x92
{0x65d7,{0x62,0x1f,0x7a,0x54,0x1f,0x1e,0x52}}, // \xe6\x97\x97
{0x65d9,{0x62,0x1f,0x7a,0x15,0x6f,0x7f,0x15}}, // \xe6\x97\x99
{0x65db,{0x62,0x1f,0x7a,0x14,0x6f,0x7e,0x16}}, // \xe6\x97\x9b
{0x65e0,{0x48,0x49,0x29,0x1f,0x79,0x49,0x68}}, // \xe6\x97\xa0
{0x65e1,{0x4d,0x49,0x29,0x1f,0x79,0x49,0x68}}, // \xe6\x97\xa1
{0x65e2,{0x7f,0x55,0x5f,0x49,0x2f,0x79,0x4f}}, // \xe6\x97\xa2
{0x65e5,{0x00,0x7f,0x49,0x49,0x49,0x49,0x7f}}, // \xe6\x97\xa5
{0x65e6,{0x40,0x5f,0x55,0x55,0x55,0x5f,0x40}}, // \xe6\x97\xa6
{0x65e7,{0x7f,0x00,0x7f,0x49,0x49,0x49,0x7f}}, // \xe6\x97\xa7
{0x65e8,{0x07,0x7a,0x5a,0x5a,0x59,0x79,0x0c}}, // \xe6\x97\xa8
{0x65e9,{0x20,0x3f,0x35,0x75,0x35,0x3f,0x20}}, // \xe6\x97\xa9
{0x65ec,{0x08,0x04,0x3f,0x2a,0x3e,0x42,0x7e}}, // \xe6\x97\xac
{0x65ed,{0x42,0x3f,0x02,0x7e,0x5f,0x55,0x5f}}, // \xe6\x97\xad
{0x65f1,{0x28,0x2f,0x2d,0x7d,0x2d,0x2f,0x28}}, // \xe6\x97\xb1
{0x65fa,{0x3e,0x2a,0x3e,0x41,0x49,0x7f,0x49}}, // \xe6\x97\xba
{0x65fb,{0x48,0x4f,0x5d,0x2d,0x5d,0x4f,0x48}}, // \xe6\x97\xbb
{0x6602,{0x30,0x2f,0x25,0x05,0x7d,0x0f,0x38}}, // \xe6\x98\x82
{0x6603,{0x40,0x38,0x4f,0x4d,0x3d,0x4f,0x48}}, // \xe6\x98\x83
{0x6606,{0x40,0x7f,0x55,0x05,0x7d,0x57,0x50}}, // \xe6\x98\x86
{0x6607,{0x10,0x57,0x3d,0x15,0x7d,0x17,0x10}}, // \xe6\x98\x87
{0x660a,{0x44,0x57,0x55,0x3d,0x55,0x57,0x44}}, // \xe6\x98\x8a
{0x660c,{0x7c,0x57,0x55,0x55,0x55,0x57,0x7c}}, // \xe6\x98\x8c
{0x660e,{0x1f,0x15,0x5f,0x20,0x1f,0x55,0x7f}}, // \xe6\x98\x8e
{0x660f,{0x10,0x7e,0x76,0x66,0x6d,0x75,0x10}}, // \xe6\x98\x8f
{0x6613,{0x20,0x57,0x3d,0x55,0x35,0x57,0x70}}, // \xe6\x98\x93
{0x6614,{0x08,0x7a,0x5f,0x5a,0x5f,0x7a,0x08}}, // \xe6\x98\x94
{0x661c,{0x24,0x57,0x3d,0x55,0x35,0x57,0x74}}, // \xe6\x98\x9c
{0x661f,{0x50,0x4f,0x55,0x7d,0x55,0x57,0x44}}, // \xe6\x98\x9f
{0x6620,{0x3e,0x2a,0x7e,0x4e,0x3b,0x4e,0x48}}, // \xe6\x98\xa0
{0x6625,{0x28,0x1a,0x6e,0x6f,0x6e,0x1a,0x28}}, // \xe6\x98\xa5
{0x6627,{0x3e,0x2a,0x5e,0x2a,0x7f,0x2a,0x48}}, // \xe6\x98\xa7
{0x6628,{0x3e,0x2a,0x3e,0x04,0x7f,0x2a,0x2a}}, // \xe6\x98\xa8
{0x662d,{0x3e,0x2a,0x3e,0x75,0x53,0x59,0x7f}}, // \xe6\x98\xad
{0x662f,{0x44,0x37,0x45,0x7d,0x55,0x57,0x44}}, // \xe6\x98\xaf
{0x6634,{0x38,0x6f,0x35,0x05,0x7d,0x0f,0x38}}, // \xe6\x98\xb4
{0x6635,{0x3e,0x2a,0x7e,0x3f,0x05,0x7d,0x57}}, // \xe6\x98\xb5
{0x6636,{0x28,0x5d,0x7d,0x28,0x5f,0x55,0x5f}}, // \xe6\x98\xb6
{0x663c,{0x50,0x4f,0x75,0x55,0x75,0x4b,0x50}}, // \xe6\x98\xbc
{0x663f,{0x3e,0x2a,0x3e,0x1e,0x62,0x5b,0x62}}, // \xe6\x98\xbf
{0x6641,{0x54,0x5b,0x3f,0x03,0x7f,0x4b,0x54}}, // \xe6\x99\x81
{0x6642,{0x3e,0x2a,0x3e,0x6a,0x2f,0x7a,0x28}}, // \xe6\x99\x82
{0x6643,{0x50,0x5b,0x33,0x1f,0x73,0x5b,0x50}}, // \xe6\x99\x83
{0x6644,{0x3e,0x2a,0x3e,0x4a,0x38,0x7f,0x4a}}, // \xe6\x99\x84
{0x6649,{0x09,0x7f,0x5d,0x59,0x5f,0x7d,0x09}}, // \xe6\x99\x89
{0x664b,{0x09,0x7b,0x5f,0x59,0x5f,0x7b,0x09}}, // \xe6\x99\x8b
{0x664f,{0x4c,0x57,0x75,0x5d,0x35,0x57,0x4c}}, // \xe6\x99\x8f
{0x6652,{0x3e,0x2a,0x7d,0x5f,0x45,0x5f,0x7d}}, // \xe6\x99\x92
{0x665d,{0x50,0x7a,0x5a,0x5f,0x5a,0x7e,0x54}}, // \xe6\x99\x9d
{0x665e,{0x3e,0x2a,0x7e,0x2d,0x7a,0x2d,0x68}}, // \xe6\x99\x9e
{0x665f,{0x40,0x3c,0x57,0x35,0x45,0x3f,0x54}}, // \xe6\x99\x9f
{0x6662,{0x0a,0x7f,0x70,0x7e,0x76,0x7d,0x04}}, // \xe6\x99\xa2
{0x6664,{0x3e,0x2a,0x3e,0x14,0x7d,0x57,0x7d}}, // \xe6\x99\xa4
{0x6666,{0x3e,0x2a,0x3e,0x33,0x2e,0x7e,0x2a}}, // \xe6\x99\xa6
{0x6667,{0x3e,0x2a,0x3e,0x0c,0x6b,0x7f,0x6a}}, // \xe6\x99\xa7
{0x6668,{0x40,0x3c,0x77,0x5d,0x3d,0x5f,0x54}}, // \xe6\x99\xa8
{0x6669,{0x3e,0x2a,0x5e,0x36,0x1d,0x77,0x5c}}, // \xe6\x99\xa9
{0x666e,{0x12,0x76,0x5f,0x52,0x5e,0x77,0x12}}, // \xe6\x99\xae
{0x666f,{0x44,0x3f,0x55,0x75,0x15,0x3f,0x44}}, // \xe6\x99\xaf
{0x6670,{0x3e,0x2a,0x3e,0x1a,0x7f,0x0e,0x79}}, // \xe6\x99\xb0
{0x6674,{0x3e,0x2a,0x3e,0x08,0x7a,0x2f,0x7a}}, // \xe6\x99\xb4
{0x6676,{0x7c,0x57,0x7d,0x05,0x7d,0x57,0x7c}}, // \xe6\x99\xb6
{0x667a,{0x14,0x7b,0x56,0x5a,0x5e,0x7a,0x0e}}, // \xe6\x99\xba
{0x6681,{0x3e,0x2a,0x5e,0x3e,0x17,0x7e,0x54}}, // \xe6\x9a\x81
{0x6683,{0x28,0x6f,0x3d,0x05,0x7d,0x2f,0x28}}, // \xe6\x9a\x83
{0x6684,{0x3e,0x2a,0x3e,0x46,0x72,0x77,0x46}}, // \xe6\x9a\x84
{0x6687,{0x3e,0x2a,0x7f,0x2b,0x58,0x2d,0x5f}}, // \xe6\x9a\x87
{0x6688,{0x2c,0x27,0x3d,0x7d,0x3d,0x27,0x2c}}, // \xe6\x9a\x88
{0x6689,{0x3e,0x2a,0x3e,0x27,0x3d,0x7f,0x27}}, // \xe6\x9a\x89
{0x668e,{0x3e,0x2a,0x5e,0x57,0x3a,0x57,0x5a}}, // \xe6\x9a\x8e
{0x6691,{0x50,0x57,0x3d,0x7d,0x5d,0x77,0x10}}, // \xe6\x9a\x91
{0x6696,{0x3e,0x2a,0x7e,0x2a,0x5e,0x29,0x5d}}, // \xe6\x9a\x96
{0x6697,{0x3e,0x2a,0x3e,0x0e,0x6b,0x6e,0x0a}}, // \xe6\x9a\x97
{0x6698,{0x3e,0x2a,0x3e,0x24,0x5f,0x35,0x77}}, // \xe6\x9a\x98
{0x669d,{0x3e,0x2a,0x3e,0x53,0x1d,0x1d,0x53}}, // \xe6\x9a\x9d
{0x66a2,{0x3e,0x6b,0x3e,0x24,0x5f,0x35,0x77}}, // \xe6\x9a\xa2
{0x66a6,{0x40,0x3f,0x75,0x5f,0x55,0x5f,0x75}}, // \xe6\x9a\xa6
{0x66ab,{0x0a,0x6e,0x7f,0x6a,0x67,0x7d,0x05}}, // \xe6\x9a\xab
{0x66ae,{0x2a,0x1a,0x6f,0x6e,0x6f,0x1a,0x2a}}, // \xe6\x9a\xae
{0x66b4,{0x48,0x5b,0x2f,0x7b,0x2f,0x5b,0x48}}, // \xe6\x9a\xb4
{0x66b8,{0x3e,0x2a,0x5e,0x1e,0x6b,0x1e,0x4a}}, // \xe6\x9a\xb8
{0x66b9,{0x55,0x30,0x53,0x7f,0x6b,0x7f,0x6b}}, // \xe6\x9a\xb9
{0x66bc,{0x02,0x7d,0x56,0x5d,0x5a,0x75,0x0b}}, // \xe6\x9a\xbc
{0x66be,{0x3e,0x3e,0x2e,0x7b,0x56,0x3f,0x5e}}, // \xe6\x9a\xbe
{0x66c1,{0x4e,0x7f,0x56,0x59,0x57,0x7f,0x49}}, // \xe6\x9b\x81
{0x66c4,{0x3e,0x2a,0x3e,0x3f,0x7e,0x3f,0x2a}}, // \xe6\x9b\x84
{0x66c7,{0x4c,0x57,0x7d,0x5d,0x55,0x2f,0x4c}}, // \xe6\x9b\x87
{0x66c9,{0x3e,0x2a,0x5e,0x3e,0x17,0x7e,0x5c}}, // \xe6\x9b\x89
{0x66d6,{0x3e,0x2a,0x5d,0x2f,0x55,0x37,0x4d}}, // \xe6\x9b\x96
{0x66d9,{0x3e,0x2a,0x5f,0x35,0x7f,0x5d,0x77}}, // \xe6\x9b\x99
{0x66da,{0x3e,0x2a,0x3e,0x5f,0x7a,0x2f,0x5a}}, // \xe6\x9b\x9a
{0x66dc,{0x3e,0x2a,0x3e,0x25,0x77,0x7d,0x57}}, // \xe6\x9b\x9c
{0x66dd,{0x3e,0x2a,0x5e,0x2b,0x7f,0x2f,0x5b}}, // \xe6\x9b\x9d
{0x66e0,{0x3e,0x2a,0x7e,0x4a,0x3f,0x3e,0x4a}}, // \xe6\x9b\xa0
{0x66e6,{0x3e,0x2a,0x3e,0x5b,0x6e,0x3b,0x5a}}, // \xe6\x9b\xa6
{0x66e9,{0x54,0x3f,0x7d,0x55,0x3d,0x5f,0x54}}, // \xe6\x9b\xa9
{0x66f0,{0x00,0x7f,0x49,0x49,0x49,0x41,0x7f}}, // \xe6\x9b\xb0
{0x66f2,{0x7e,0x4a,0x7f,0x4a,0x7f,0x4a,0x7e}}, // \xe6\x9b\xb2
{0x66f3,{0x40,0x4e,0x4a,0x4f,0x5a,0x2e,0x50}}, // \xe6\x9b\xb3
{0x66f4,{0x41,0x5f,0x35,0x3f,0x55,0x5f,0x41}}, // \xe6\x9b\xb4
{0x66f5,{0x4e,0x4a,0x4f,0x5a,0x2e,0x51,0x40}}, // \xe6\x9b\xb5
{0x66f7,{0x10,0x77,0x6d,0x5d,0x6d,0x0f,0x78}}, // \xe6\x9b\xb7
{0x66f8,{0x28,0x6a,0x6a,0x7f,0x6a,0x6e,0x24}}, // \xe6\x9b\xb8
{0x66f9,{0x1e,0x76,0x5f,0x56,0x5f,0x76,0x1e}}, // \xe6\x9b\xb9
{0x66fc,{0x4c,0x4f,0x5d,0x2d,0x5d,0x4f,0x4c}}, // \xe6\x9b\xbc
{0x66fd,{0x0e,0x7a,0x5b,0x5e,0x5a,0x7b,0x0e}}, // \xe6\x9b\xbd
{0x66fe,{0x04,0x7e,0x55,0x5c,0x55,0x7e,0x04}}, // \xe6\x9b\xbe
{0x66ff,{0x0a,0x77,0x5a,0x50,0x5a,0x77,0x0a}}, // \xe6\x9b\xbf
{0x6700,{0x24,0x3f,0x25,0x7d,0x55,0x27,0x5c}}, // \xe6\x9c\x80
{0x6703,{0x04,0x7c,0x56,0x5d,0x56,0x7c,0x04}}, // \xe6\x9c\x83
{0x6708,{0x40,0x20,0x1f,0x15,0x15,0x55,0x7f}}, // \xe6\x9c\x88
{0x6709,{0x12,0x0a,0x7f,0x2a,0x2a,0x7a,0x02}}, // \xe6\x9c\x89
{0x670b,{0x40,0x3f,0x55,0x7f,0x3f,0x55,0x7f}}, // \xe6\x9c\x8b
{0x670d,{0x40,0x3f,0x55,0x7f,0x59,0x29,0x5b}}, // \xe6\x9c\x8d
{0x670f,{0x7f,0x15,0x7f,0x76,0x44,0x7f,0x76}}, // \xe6\x9c\x8f
{0x6714,{0x5a,0x33,0x1e,0x53,0x3f,0x55,0x7f}}, // \xe6\x9c\x94
{0x6715,{0x7f,0x15,0x7f,0x40,0x55,0x3c,0x55}}, // \xe6\x9c\x95
{0x6716,{0x7f,0x15,0x7f,0x7e,0x5a,0x3b,0x5e}}, // \xe6\x9c\x96
{0x6717,{0x7e,0x4b,0x2e,0x40,0x3f,0x55,0x7f}}, // \xe6\x9c\x97
{0x671b,{0x52,0x5e,0x5b,0x7a,0x57,0x55,0x5f}}, // \xe6\x9c\x9b
{0x671d,{0x2d,0x77,0x2d,0x40,0x3f,0x55,0x7f}}, // \xe6\x9c\x9d
{0x671e,{0x28,0x1a,0x4f,0x3a,0x7f,0x1a,0x28}}, // \xe6\x9c\x9e
{0x671f,{0x52,0x1f,0x1a,0x5f,0x3f,0x55,0x7f}}, // \xe6\x9c\x9f
{0x6726,{0x7f,0x15,0x7e,0x5f,0x7a,0x2f,0x5a}}, // \xe6\x9c\xa6
{0x6727,{0x7f,0x15,0x7e,0x2b,0x7e,0x77,0x5d}}, // \xe6\x9c\xa7
{0x6728,{0x22,0x12,0x0a,0x7f,0x0a,0x12,0x22}}, // \xe6\x9c\xa8
{0x672a,{0x48,0x4a,0x2a,0x7f,0x2a,0x4a,0x48}}, // \xe6\x9c\xaa
{0x672b,{0x42,0x4a,0x2a,0x7f,0x2a,0x4a,0x42}}, // \xe6\x9c\xab
{0x672c,{0x22,0x12,0x2a,0x7f,0x2a,0x12,0x22}}, // \xe6\x9c\xac
{0x672d,{0x22,0x1a,0x7f,0x0a,0x7f,0x40,0x60}}, // \xe6\x9c\xad
{0x672e,{0x42,0x3a,0x02,0x7f,0x02,0x7b,0x42}}, // \xe6\x9c\xae
{0x6731,{0x4c,0x4b,0x2a,0x7f,0x2a,0x4a,0x48}}, // \xe6\x9c\xb1
{0x6734,{0x22,0x1a,0x7f,0x0a,0x7f,0x08,0x10}}, // \xe6\x9c\xb4
{0x6736,{0x54,0x55,0x33,0x79,0x33,0x52,0x56}}, // \xe6\x9c\xb6
{0x6737,{0x1a,0x7f,0x0a,0x41,0x3f,0x41,0x7f}}, // \xe6\x9c\xb7
{0x6738,{0x1a,0x7f,0x0a,0x42,0x3f,0x42,0x7e}}, // \xe6\x9c\xb8
{0x673a,{0x1a,0x7f,0x40,0x3f,0x01,0x7f,0x40}}, // \xe6\x9c\xba
{0x673d,{0x1a,0x7f,0x0a,0x01,0x0f,0x49,0x79}}, // \xe6\x9c\xbd
{0x673f,{0x42,0x4e,0x26,0x7f,0x26,0x4e,0x42}}, // \xe6\x9c\xbf
{0x6741,{0x1a,0x7f,0x40,0x31,0x0f,0x30,0x40}}, // \xe6\x9d\x81
{0x6746,{0x1a,0x7f,0x08,0x09,0x7f,0x09,0x08}}, // \xe6\x9d\x86
{0x6749,{0x22,0x1a,0x7f,0x0a,0x40,0x4a,0x25}}, // \xe6\x9d\x89
{0x674e,{0x2a,0x2a,0x26,0x6f,0x3e,0x26,0x2a}}, // \xe6\x9d\x8e
{0x674f,{0x0a,0x7a,0x56,0x5f,0x56,0x7a,0x0a}}, // \xe6\x9d\x8f
{0x6750,{0x1a,0x7f,0x22,0x22,0x52,0x7f,0x0a}}, // \xe6\x9d\x90
{0x6751,{0x22,0x1a,0x7f,0x0a,0x52,0x7f,0x02}}, // \xe6\x9d\x91
{0x6753,{0x1a,0x7f,0x04,0x0b,0x12,0x42,0x7e}}, // \xe6\x9d\x93
{0x6756,{0x1a,0x7f,0x42,0x2a,0x1f,0x22,0x42}}, // \xe6\x9d\x96
{0x6759,{0x1a,0x7f,0x0a,0x04,0x0f,0x34,0x45}}, // \xe6\x9d\x99
{0x675c,{0x1a,0x7f,0x0a,0x44,0x44,0x7f,0x44}}, // \xe6\x9d\x9c
{0x675e,{0x1a,0x7f,0x0a,0x79,0x49,0x49,0x6f}}, // \xe6\x9d\x9e
{0x675f,{0x42,0x4e,0x2a,0x7f,0x2a,0x4e,0x42}}, // \xe6\x9d\x9f
{0x6760,{0x1a,0x7f,0x0a,0x40,0x42,0x7e,0x42}}, // \xe6\x9d\xa0
{0x6761,{0x48,0x5a,0x3a,0x75,0x3b,0x58,0x48}}, // \xe6\x9d\xa1
{0x6762,{0x4a,0x5a,0x56,0x7f,0x56,0x5a,0x4a}}, // \xe6\x9d\xa2
{0x6763,{0x1a,0x7f,0x7c,0x40,0x7f,0x40,0x7c}}, // \xe6\x9d\xa3
{0x6764,{0x1a,0x7f,0x0a,0x41,0x3f,0x45,0x7d}}, // \xe6\x9d\xa4
{0x6765,{0x52,0x56,0x32,0x7f,0x32,0x56,0x52}}, // \xe6\x9d\xa5
{0x676a,{0x1a,0x7f,0x08,0x46,0x5f,0x22,0x14}}, // \xe6\x9d\xaa
{0x676d,{0x1a,0x7f,0x42,0x3a,0x0b,0x7a,0x42}}, // \xe6\x9d\xad
{0x676f,{0x1a,0x7f,0x11,0x09,0x7f,0x09,0x11}}, // \xe6\x9d\xaf
{0x6770,{0x52,0x12,0x4a,0x1f,0x4a,0x12,0x52}}, // \xe6\x9d\xb0
{0x6771,{0x42,0x5e,0x2a,0x7f,0x2a,0x5e,0x42}}, // \xe6\x9d\xb1
{0x6772,{0x48,0x4f,0x2d,0x7d,0x2d,0x4f,0x48}}, // \xe6\x9d\xb2
{0x6773,{0x0a,0x7a,0x76,0x7f,0x76,0x7a,0x0a}}, // \xe6\x9d\xb3
{0x6775,{0x1a,0x7f,0x14,0x13,0x7e,0x12,0x10}}, // \xe6\x9d\xb5
{0x6777,{0x1a,0x7f,0x3f,0x49,0x4f,0x49,0x6f}}, // \xe6\x9d\xb7
{0x677c,{0x1a,0x7f,0x09,0x4b,0x7d,0x0b,0x18}}, // \xe6\x9d\xbc
{0x677e,{0x1a,0x7f,0x44,0x63,0x58,0x23,0x44}}, // \xe6\x9d\xbe
{0x677f,{0x1a,0x7f,0x20,0x5f,0x5d,0x25,0x5d}}, // \xe6\x9d\xbf
{0x6785,{0x1a,0x7f,0x49,0x3f,0x09,0x7f,0x09}}, // \xe6\x9e\x85
{0x6787,{0x1a,0x7f,0x40,0x7f,0x24,0x7f,0x44}}, // \xe6\x9e\x87
{0x6789,{0x1a,0x7f,0x0a,0x41,0x49,0x7f,0x49}}, // \xe6\x9e\x89
{0x678b,{0x1a,0x7f,0x0a,0x42,0x3e,0x4b,0x7a}}, // \xe6\x9e\x8b
{0x678c,{0x1a,0x7f,0x44,0x3b,0x48,0x7b,0x04}}, // \xe6\x9e\x8c
{0x6790,{0x1a,0x7f,0x40,0x3e,0x0a,0x79,0x08}}, // \xe6\x9e\x90
{0x6795,{0x1a,0x7f,0x46,0x22,0x1f,0x7a,0x46}}, // \xe6\x9e\x95
{0x6797,{0x22,0x1a,0x7f,0x12,0x0a,0x7f,0x12}}, // \xe6\x9e\x97
{0x679a,{0x1a,0x7f,0x44,0x5f,0x22,0x5e,0x42}}, // \xe6\x9e\x9a
{0x679c,{0x50,0x5f,0x35,0x7f,0x35,0x5f,0x50}}, // \xe6\x9e\x9c
{0x679d,{0x1a,0x7f,0x4a,0x5a,0x2f,0x5a,0x42}}, // \xe6\x9e\x9d
{0x67a0,{0x1a,0x7f,0x2a,0x27,0x72,0x2e,0x28}}, // \xe6\x9e\xa0
{0x67a1,{0x1a,0x7f,0x4a,0x3e,0x09,0x7f,0x08}}, // \xe6\x9e\xa1
{0x67a2,{0x1a,0x7f,0x0a,0x7f,0x55,0x49,0x55}}, // \xe6\x9e\xa2
{0x67a6,{0x1a,0x7f,0x0a,0x41,0x3d,0x15,0x1d}}, // \xe6\x9e\xa6
{0x67a9,{0x2a,0x2a,0x56,0x6f,0x4e,0x56,0x2a}}, // \xe6\x9e\xa9
{0x67af,{0x1a,0x7f,0x04,0x74,0x5f,0x74,0x04}}, // \xe6\x9e\xaf
{0x67b3,{0x1a,0x7f,0x4f,0x29,0x09,0x29,0x4f}}, // \xe6\x9e\xb3
{0x67b4,{0x1a,0x7f,0x0a,0x57,0x35,0x55,0x77}}, // \xe6\x9e\xb4
{0x67b6,{0x5a,0x57,0x3a,0x7e,0x3e,0x5a,0x5e}}, // \xe6\x9e\xb6
{0x67b7,{0x1a,0x7f,0x62,0x1f,0x7e,0x42,0x7e}}, // \xe6\x9e\xb7
{0x67b8,{0x1a,0x7f,0x0a,0x04,0x1b,0x5a,0x7e}}, // \xe6\x9e\xb8
{0x67b9,{0x1a,0x7f,0x0a,0x04,0x7b,0x5a,0x5e}}, // \xe6\x9e\xb9
{0x67c1,{0x1a,0x7f,0x0a,0x06,0x7a,0x53,0x56}}, // \xe6\x9f\x81
{0x67c4,{0x1a,0x7f,0x7d,0x15,0x0f,0x55,0x7d}}, // \xe6\x9f\x84
{0x67c6,{0x1a,0x7f,0x42,0x7e,0x63,0x5e,0x42}}, // \xe6\x9f\x86
{0x67ca,{0x1a,0x7f,0x08,0x0a,0x55,0x4b,0x08}}, // \xe6\x9f\x8a
{0x67ce,{0x1a,0x7f,0x04,0x7e,0x09,0x42,0x7f}}, // \xe6\x9f\x8e
{0x67cf,{0x1a,0x7f,0x0a,0x7e,0x4b,0x4a,0x7e}}, // \xe6\x9f\x8f
{0x67d0,{0x52,0x52,0x3f,0x7a,0x3f,0x52,0x52}}, // \xe6\x9f\x90
{0x67d1,{0x1a,0x7f,0x02,0x7f,0x4a,0x7f,0x02}}, // \xe6\x9f\x91
{0x67d3,{0x55,0x50,0x3a,0x77,0x32,0x5e,0x58}}, // \xe6\x9f\x93
{0x67d4,{0x5a,0x56,0x3b,0x7f,0x33,0x52,0x56}}, // \xe6\x9f\x94
{0x67d8,{0x1a,0x7f,0x0a,0x11,0x7f,0x49,0x79}}, // \xe6\x9f\x98
{0x67da,{0x1a,0x7f,0x7e,0x4a,0x7f,0x4a,0x7e}}, // \xe6\x9f\x9a
{0x67dd,{0x1a,0x7f,0x40,0x3e,0x1a,0x79,0x28}}, // \xe6\x9f\x9d
{0x67de,{0x1a,0x7f,0x0a,0x04,0x7f,0x2a,0x2a}}, // \xe6\x9f\x9e
{0x67e2,{0x1a,0x7f,0x00,0x7e,0x4a,0x5e,0x69}}, // \xe6\x9f\xa2
{0x67e4,{0x1a,0x7f,0x40,0x7f,0x55,0x7f,0x40}}, // \xe6\x9f\xa4
{0x67e7,{0x1a,0x7f,0x40,0x3e,0x42,0x3e,0x61}}, // \xe6\x9f\xa7
{0x67e9,{0x1a,0x7f,0x0a,0x7f,0x65,0x53,0x6f}}, // \xe6\x9f\xa9
{0x67ec,{0x42,0x5e,0x3e,0x7f,0x3e,0x5e,0x42}}, // \xe6\x9f\xac
{0x67ee,{0x1a,0x7f,0x76,0x44,0x7f,0x44,0x76}}, // \xe6\x9f\xae
{0x67ef,{0x1a,0x7f,0x0a,0x1d,0x15,0x5d,0x7f}}, // \xe6\x9f\xaf
{0x67f1,{0x1a,0x7f,0x44,0x55,0x7e,0x54,0x44}}, // \xe6\x9f\xb1
{0x67f3,{0x1a,0x7f,0x5e,0x3d,0x00,0x7f,0x1f}}, // \xe6\x9f\xb3
{0x67f4,{0x5e,0x58,0x3f,0x7a,0x30,0x5f,0x5a}}, // \xe6\x9f\xb4
{0x67f5,{0x1a,0x7f,0x08,0x7f,0x3f,0x09,0x7f}}, // \xe6\x9f\xb5
{0x67fb,{0x4a,0x7a,0x56,0x5f,0x56,0x7a,0x4a}}, // \xe6\x9f\xbb
{0x67fe,{0x1a,0x7f,0x0a,0x79,0x41,0x7f,0x49}}, // \xe6\x9f\xbe
{0x67ff,{0x1a,0x7f,0x3a,0x0a,0x7f,0x0a,0x3a}}, // \xe6\x9f\xbf
{0x6802,{0x1a,0x7f,0x38,0x2f,0x69,0x7f,0x28}}, // \xe6\xa0\x82
{0x6803,{0x1a,0x7f,0x20,0x1f,0x65,0x1d,0x75}}, // \xe6\xa0\x83
{0x6804,{0x46,0x4b,0x2a,0x7f,0x2a,0x4b,0x46}}, // \xe6\xa0\x84
{0x6813,{0x1a,0x7f,0x44,0x56,0x7d,0x56,0x44}}, // \xe6\xa0\x93
{0x6816,{0x1a,0x7f,0x7d,0x5f,0x45,0x5f,0x7d}}, // \xe6\xa0\x96
{0x6817,{0x51,0x57,0x35,0x7f,0x35,0x57,0x51}}, // \xe6\xa0\x97
{0x681e,{0x55,0x5f,0x35,0x78,0x35,0x5f,0x55}}, // \xe6\xa0\x9e
{0x6821,{0x1a,0x7f,0x4a,0x56,0x23,0x56,0x4a}}, // \xe6\xa0\xa1
{0x6822,{0x1a,0x7f,0x0a,0x7d,0x57,0x55,0x7d}}, // \xe6\xa0\xa2
{0x6829,{0x1a,0x7f,0x29,0x15,0x7f,0x15,0x7f}}, // \xe6\xa0\xa9
{0x682a,{0x1a,0x7f,0x4c,0x2b,0x7f,0x2a,0x48}}, // \xe6\xa0\xaa
{0x682b,{0x1a,0x7f,0x0a,0x7e,0x23,0x76,0x2e}}, // \xe6\xa0\xab
{0x6832,{0x1a,0x7f,0x28,0x1a,0x3f,0x2a,0x69}}, // \xe6\xa0\xb2
{0x6834,{0x1a,0x7f,0x24,0x7b,0x2a,0x7a,0x22}}, // \xe6\xa0\xb4
{0x6838,{0x1a,0x7f,0x4a,0x56,0x2b,0x32,0x4a}}, // \xe6\xa0\xb8
{0x6839,{0x1a,0x7f,0x0a,0x7f,0x55,0x35,0x5f}}, // \xe6\xa0\xb9
{0x683c,{0x1a,0x7f,0x10,0x6a,0x65,0x6b,0x10}}, // \xe6\xa0\xbc
{0x683d,{0x48,0x2a,0x7f,0x2a,0x4f,0x38,0x5a}}, // \xe6\xa0\xbd
{0x6840,{0x4a,0x5b,0x35,0x7b,0x34,0x5f,0x46}}, // \xe6\xa1\x80
{0x6841,{0x1a,0x7f,0x0a,0x7d,0x00,0x45,0x7d}}, // \xe6\xa1\x81
{0x6842,{0x1a,0x7f,0x48,0x5a,0x7f,0x5a,0x48}}, // \xe6\xa1\x82
{0x6843,{0x1a,0x7f,0x4a,0x3f,0x00,0x7f,0x4a}}, // \xe6\xa1\x83
{0x6846,{0x1a,0x7f,0x7f,0x41,0x6b,0x7f,0x6b}}, // \xe6\xa1\x86
{0x6848,{0x56,0x5a,0x3e,0x7b,0x36,0x5a,0x56}}, // \xe6\xa1\x88
{0x684d,{0x1a,0x7f,0x0a,0x16,0x1b,0x56,0x6a}}, // \xe6\xa1\x8d
{0x684e,{0x1a,0x7f,0x45,0x57,0x7d,0x53,0x45}}, // \xe6\xa1\x8e
{0x6850,{0x1a,0x7f,0x0a,0x7f,0x35,0x35,0x7f}}, // \xe6\xa1\x90
{0x6851,{0x54,0x54,0x2d,0x71,0x33,0x54,0x4c}}, // \xe6\xa1\x91
{0x6853,{0x1a,0x7f,0x41,0x7f,0x6b,0x7f,0x41}}, // \xe6\xa1\x93
{0x6854,{0x1a,0x7f,0x02,0x6a,0x6f,0x6a,0x02}}, // \xe6\xa1\x94
{0x6859,{0x1a,0x7f,0x34,0x2e,0x7d,0x2c,0x26}}, // \xe6\xa1\x99
{0x685c,{0x1a,0x7f,0x49,0x58,0x2d,0x3a,0x49}}, // \xe6\xa1\x9c
{0x685d,{0x1a,0x7f,0x44,0x2b,0x1e,0x12,0x7f}}, // \xe6\xa1\x9d
{0x685f,{0x1a,0x7f,0x0a,0x4a,0x5f,0x2a,0x53}}, // \xe6\xa1\x9f
{0x6863,{0x1a,0x7f,0x45,0x54,0x57,0x54,0x7d}}, // \xe6\xa1\xa3
{0x6867,{0x1a,0x7f,0x54,0x72,0x55,0x36,0x54}}, // \xe6\xa1\xa7
{0x6874,{0x1a,0x7f,0x22,0x29,0x6b,0x39,0x22}}, // \xe6\xa1\xb4
{0x6876,{0x1a,0x7f,0x7c,0x15,0x7d,0x17,0x7d}}, // \xe6\xa1\xb6
{0x6877,{0x1a,0x7f,0x42,0x3e,0x1d,0x57,0x7c}}, // \xe6\xa1\xb7
{0x687e,{0x1a,0x7f,0x0a,0x25,0x7f,0x75,0x6f}}, // \xe6\xa1\xbe
{0x687f,{0x1a,0x7f,0x28,0x2f,0x7d,0x2f,0x28}}, // \xe6\xa1\xbf
{0x6881,{0x55,0x50,0x39,0x77,0x39,0x5f,0x54}}, // \xe6\xa2\x81
{0x6883,{0x1a,0x7f,0x55,0x3b,0x6a,0x7e,0x69}}, // \xe6\xa2\x83
{0x6885,{0x1a,0x7f,0x08,0x3b,0x2e,0x7e,0x2a}}, // \xe6\xa2\x85
{0x688d,{0x1a,0x7f,0x10,0x16,0x7f,0x56,0x50}}, // \xe6\xa2\x8d
{0x688f,{0x1a,0x7f,0x0c,0x6b,0x7f,0x6a,0x08}}, // \xe6\xa2\x8f
{0x6893,{0x1a,0x7f,0x2a,0x2e,0x7b,0x2e,0x2a}}, // \xe6\xa2\x93
{0x6894,{0x1a,0x7f,0x40,0x3e,0x7e,0x56,0x5d}}, // \xe6\xa2\x94
{0x6897,{0x1a,0x7f,0x41,0x57,0x3f,0x47,0x41}}, // \xe6\xa2\x97
{0x689b,{0x1a,0x7f,0x55,0x3f,0x55,0x7f,0x1b}}, // \xe6\xa2\x9b
{0x689d,{0x04,0x7e,0x5f,0x3a,0x75,0x3b,0x50}}, // \xe6\xa2\x9d
{0x689f,{0x50,0x56,0x36,0x7f,0x36,0x54,0x5c}}, // \xe6\xa2\x9f
{0x68a0,{0x1a,0x7f,0x0a,0x77,0x5d,0x55,0x77}}, // \xe6\xa2\xa0
{0x68a2,{0x1a,0x7f,0x0a,0x7d,0x14,0x57,0x7d}}, // \xe6\xa2\xa2
{0x68a6,{0x4a,0x56,0x5f,0x2a,0x2e,0x1f,0x0a}}, // \xe6\xa2\xa6
{0x68a7,{0x1a,0x7f,0x14,0x7d,0x57,0x7d,0x10}}, // \xe6\xa2\xa7
{0x68a8,{0x5a,0x57,0x3f,0x7a,0x37,0x50,0x5f}}, // \xe6\xa2\xa8
{0x68ad,{0x1a,0x7f,0x2a,0x57,0x32,0x5e,0x4b}}, // \xe6\xa2\xad
{0x68af,{0x1a,0x7f,0x5a,0x2b,0x7e,0x2b,0x6e}}, // \xe6\xa2\xaf
{0x68b0,{0x1a,0x7f,0x0a,0x3e,0x4a,0x3f,0x52}}, // \xe6\xa2\xb0
{0x68b1,{0x1a,0x7f,0x7f,0x55,0x7f,0x55,0x7f}}, // \xe6\xa2\xb1
{0x68b3,{0x1a,0x7f,0x4a,0x3e,0x7b,0x06,0x6a}}, // \xe6\xa2\xb3
{0x68b5,{0x4a,0x26,0x1f,0x2a,0x0e,0x7f,0x4a}}, // \xe6\xa2\xb5
{0x68b6,{0x1a,0x7f,0x40,0x3f,0x2b,0x7f,0x57}}, // \xe6\xa2\xb6
{0x68b9,{0x1a,0x7f,0x50,0x1e,0x16,0x1d,0x54}}, // \xe6\xa2\xb9
{0x68ba,{0x1a,0x16,0x1f,0x7a,0x36,0x5f,0x1a}}, // \xe6\xa2\xba
{0x68bc,{0x1a,0x7f,0x34,0x5e,0x17,0x7e,0x14}}, // \xe6\xa2\xbc
{0x68c4,{0x52,0x5a,0x3e,0x7b,0x36,0x5a,0x52}}, // \xe6\xa3\x84
{0x68c6,{0x1a,0x7f,0x74,0x32,0x75,0x36,0x74}}, // \xe6\xa3\x86
{0x68c9,{0x1a,0x7f,0x30,0x1e,0x7b,0x1e,0x30}}, // \xe6\xa3\x89
{0x68ca,{0x48,0x5a,0x2f,0x7a,0x2f,0x5a,0x48}}, // \xe6\xa3\x8a
{0x68cb,{0x1a,0x7f,0x52,0x1f,0x1a,0x1f,0x52}}, // \xe6\xa3\x8b
{0x68cd,{0x1a,0x7f,0x7f,0x55,0x05,0x7d,0x57}}, // \xe6\xa3\x8d
{0x68d2,{0x1a,0x7f,0x14,0x2e,0x77,0x2e,0x14}}, // \xe6\xa3\x92
{0x68d4,{0x1a,0x7f,0x0a,0x7f,0x75,0x6f,0x15}}, // \xe6\xa3\x94
{0x68d5,{0x1a,0x7f,0x56,0x12,0x77,0x16,0x56}}, // \xe6\xa3\x95
{0x68d7,{0x52,0x56,0x2a,0x7f,0x2a,0x56,0x52}}, // \xe6\xa3\x97
{0x68d8,{0x5a,0x2a,0x7f,0x5a,0x2a,0x7f,0x5a}}, // \xe6\xa3\x98
{0x68da,{0x1a,0x7f,0x3f,0x55,0x3f,0x55,0x7f}}, // \xe6\xa3\x9a
{0x68df,{0x1a,0x7f,0x42,0x2e,0x7f,0x2e,0x42}}, // \xe6\xa3\x9f
{0x68e0,{0x56,0x53,0x3e,0x7b,0x3e,0x53,0x56}}, // \xe6\xa3\xa0
{0x68e1,{0x1a,0x7f,0x7f,0x35,0x29,0x35,0x7f}}, // \xe6\xa3\xa1
{0x68e3,{0x1a,0x7f,0x5a,0x2a,0x7f,0x2e,0x54}}, // \xe6\xa3\xa3
{0x68e7,{0x1a,0x7f,0x0a,0x52,0x5b,0x36,0x5b}}, // \xe6\xa3\xa7
{0x68ee,{0x50,0x3a,0x76,0x5f,0x36,0x7a,0x50}}, // \xe6\xa3\xae
{0x68ef,{0x1a,0x7f,0x64,0x2a,0x4d,0x5e,0x64}}, // \xe6\xa3\xaf
{0x68f2,{0x1a,0x7f,0x52,0x7a,0x5f,0x3e,0x52}}, // \xe6\xa3\xb2
{0x68f9,{0x1a,0x7f,0x20,0x3c,0x77,0x3e,0x22}}, // \xe6\xa3\xb9
{0x68fa,{0x1a,0x7f,0x06,0x7a,0x5b,0x5a,0x76}}, // \xe6\xa3\xba
{0x6900,{0x1a,0x7f,0x56,0x2a,0x7b,0x4a,0x5e}}, // \xe6\xa4\x80
{0x6901,{0x1a,0x7f,0x22,0x2e,0x6b,0x3e,0x22}}, // \xe6\xa4\x81
{0x6904,{0x1a,0x7f,0x4a,0x5e,0x2b,0x3e,0x4a}}, // \xe6\xa4\x84
{0x6905,{0x1a,0x7f,0x12,0x5a,0x17,0x7a,0x12}}, // \xe6\xa4\x85
{0x6908,{0x1a,0x7f,0x04,0x57,0x3a,0x56,0x7e}}, // \xe6\xa4\x88
{0x690b,{0x1a,0x7f,0x22,0x4e,0x7b,0x0e,0x22}}, // \xe6\xa4\x8b
{0x690c,{0x1a,0x7f,0x46,0x56,0x73,0x56,0x46}}, // \xe6\xa4\x8c
{0x690d,{0x1a,0x7f,0x00,0x7a,0x42,0x5f,0x5a}}, // \xe6\xa4\x8d
{0x690e,{0x1a,0x7f,0x04,0x7f,0x4a,0x7f,0x4a}}, // \xe6\xa4\x8e
{0x690f,{0x1a,0x7f,0x5d,0x77,0x41,0x77,0x5d}}, // \xe6\xa4\x8f
{0x6912,{0x1a,0x7f,0x28,0x7f,0x4a,0x31,0x4f}}, // \xe6\xa4\x92
{0x6919,{0x1a,0x7f,0x0a,0x7c,0x57,0x57,0x7c}}, // \xe6\xa4\x99
{0x691a,{0x1a,0x7f,0x7f,0x07,0x00,0x47,0x7f}}, // \xe6\xa4\x9a
{0x691b,{0x1a,0x7f,0x12,0x7b,0x02,0x7f,0x52}}, // \xe6\xa4\x9b
{0x691c,{0x1a,0x7f,0x5c,0x56,0x3d,0x56,0x5c}}, // \xe6\xa4\x9c
{0x6921,{0x1a,0x7f,0x2d,0x3b,0x29,0x4e,0x7f}}, // \xe6\xa4\xa1
{0x6922,{0x1a,0x7f,0x41,0x6b,0x7f,0x6b,0x7f}}, // \xe6\xa4\xa2
{0x6923,{0x1a,0x7f,0x10,0x5e,0x1f,0x1a,0x5f}}, // \xe6\xa4\xa3
{0x6925,{0x1a,0x7f,0x4b,0x3f,0x4a,0x3e,0x3e}}, // \xe6\xa4\xa5
{0x6926,{0x1a,0x7f,0x56,0x2d,0x36,0x6d,0x16}}, // \xe6\xa4\xa6
{0x6928,{0x1a,0x7f,0x3e,0x72,0x0b,0x52,0x7a}}, // \xe6\xa4\xa8
{0x692a,{0x1a,0x7f,0x5a,0x7f,0x42,0x7f,0x5a}}, // \xe6\xa4\xaa
{0x6930,{0x1a,0x7f,0x21,0x3f,0x2d,0x7f,0x1b}}, // \xe6\xa4\xb0
{0x6934,{0x1a,0x7f,0x7e,0x15,0x5b,0x29,0x5b}}, // \xe6\xa4\xb4
{0x6936,{0x1a,0x7f,0x2f,0x5d,0x2a,0x5d,0x4f}}, // \xe6\xa4\xb6
{0x6939,{0x1a,0x7f,0x72,0x5f,0x72,0x5f,0x52}}, // \xe6\xa4\xb9
{0x693d,{0x1a,0x7f,0x2c,0x56,0x7d,0x27,0x55}}, // \xe6\xa4\xbd
{0x693f,{0x1a,0x7f,0x2a,0x1e,0x6f,0x7e,0x2a}}, // \xe6\xa4\xbf
{0x694a,{0x1a,0x7f,0x24,0x5f,0x35,0x57,0x74}}, // \xe6\xa5\x8a
{0x6953,{0x1a,0x7f,0x3f,0x4d,0x7f,0x2d,0x7f}}, // \xe6\xa5\x93
{0x6954,{0x1a,0x7f,0x56,0x5f,0x36,0x53,0x57}}, // \xe6\xa5\x94
{0x6955,{0x1a,0x7f,0x0a,0x77,0x3a,0x7e,0x0a}}, // \xe6\xa5\x95
{0x6959,{0x1a,0x7f,0x29,0x7d,0x1b,0x7f,0x1a}}, // \xe6\xa5\x99
{0x695a,{0x5a,0x36,0x5f,0x7a,0x76,0x5f,0x4a}}, // \xe6\xa5\x9a
{0x695c,{0x1a,0x7f,0x3a,0x2f,0x7a,0x3f,0x7f}}, // \xe6\xa5\x9c
{0x695d,{0x1a,0x7f,0x42,0x2e,0x7f,0x2e,0x4e}}, // \xe6\xa5\x9d
{0x695e,{0x1a,0x7f,0x00,0x4b,0x3b,0x2f,0x6b}}, // \xe6\xa5\x9e
{0x6960,{0x1a,0x7f,0x7a,0x2a,0x77,0x2a,0x7a}}, // \xe6\xa5\xa0
{0x6961,{0x1a,0x7f,0x05,0x73,0x75,0x26,0x54}}, // \xe6\xa5\xa1
{0x6962,{0x1a,0x7f,0x7a,0x5f,0x4a,0x5f,0x7a}}, // \xe6\xa5\xa2
{0x696a,{0x1a,0x7f,0x5f,0x32,0x77,0x36,0x57}}, // \xe6\xa5\xaa
{0x696b,{0x1a,0x7f,0x24,0x3f,0x2d,0x7f,0x24}}, // \xe6\xa5\xab
{0x696d,{0x53,0x5a,0x3f,0x7a,0x3f,0x5a,0x53}}, // \xe6\xa5\xad
{0x696e,{0x1a,0x7f,0x28,0x1a,0x6f,0x7a,0x69}}, // \xe6\xa5\xae
{0x696f,{0x1a,0x7f,0x20,0x1e,0x76,0x7e,0x75}}, // \xe6\xa5\xaf
{0x6973,{0x1a,0x7f,0x52,0x3f,0x7a,0x3f,0x52}}, // \xe6\xa5\xb3
{0x6974,{0x1a,0x7f,0x1a,0x6e,0x3b,0x6e,0x1a}}, // \xe6\xa5\xb4
{0x6975,{0x1a,0x7f,0x0a,0x59,0x47,0x7d,0x59}}, // \xe6\xa5\xb5
{0x6977,{0x1a,0x7f,0x0f,0x6a,0x70,0x6f,0x0a}}, // \xe6\xa5\xb7
{0x6978,{0x1a,0x7f,0x35,0x7f,0x4c,0x3f,0x44}}, // \xe6\xa5\xb8
{0x6979,{0x1a,0x7f,0x49,0x77,0x75,0x7b,0x4e}}, // \xe6\xa5\xb9
{0x697c,{0x1a,0x7f,0x55,0x7a,0x57,0x32,0x55}}, // \xe6\xa5\xbc
{0x697d,{0x55,0x52,0x36,0x7d,0x36,0x52,0x55}}, // \xe6\xa5\xbd
{0x697e,{0x1a,0x7f,0x50,0x3e,0x7b,0x2e,0x50}}, // \xe6\xa5\xbe
{0x6981,{0x1a,0x7f,0x56,0x5a,0x77,0x4a,0x56}}, // \xe6\xa6\x81
{0x6982,{0x1a,0x7f,0x3e,0x2e,0x49,0x3f,0x4f}}, // \xe6\xa6\x82
{0x698a,{0x1a,0x7f,0x0a,0x77,0x3e,0x6b,0x3e}}, // \xe6\xa6\x8a
{0x698e,{0x1a,0x7f,0x51,0x5f,0x2f,0x5f,0x41}}, // \xe6\xa6\x8e
{0x6991,{0x1a,0x7f,0x12,0x3e,0x57,0x7e,0x13}}, // \xe6\xa6\x91
{0x6994,{0x1a,0x7f,0x7e,0x4b,0x2e,0x7f,0x1b}}, // \xe6\xa6\x94
{0x6995,{0x1a,0x7f,0x26,0x16,0x6b,0x76,0x26}}, // \xe6\xa6\x95
{0x699b,{0x1a,0x7f,0x52,0x2a,0x77,0x2a,0x52}}, // \xe6\xa6\x9b
{0x699c,{0x1a,0x7f,0x1a,0x4e,0x3b,0x6e,0x1a}}, // \xe6\xa6\x9c
{0x69a0,{0x1a,0x7f,0x53,0x1d,0x15,0x1d,0x53}}, // \xe6\xa6\xa0
{0x69a7,{0x1a,0x7f,0x55,0x7f,0x41,0x7f,0x55}}, // \xe6\xa6\xa7
{0x69ae,{0x4d,0x56,0x35,0x7c,0x35,0x56,0x4d}}, // \xe6\xa6\xae
{0x69b1,{0x1a,0x7f,0x2a,0x7e,0x57,0x3e,0x4a}}, // \xe6\xa6\xb1
{0x69b2,{0x1a,0x7f,0x02,0x4f,0x6d,0x6b,0x4f}}, // \xe6\xa6\xb2
{0x69b4,{0x1a,0x7f,0x0e,0x7a,0x79,0x77,0x0f}}, // \xe6\xa6\xb4
{0x69bb,{0x1a,0x7f,0x48,0x2f,0x7d,0x2f,0x78}}, // \xe6\xa6\xbb
{0x69be,{0x1a,0x7f,0x0c,0x77,0x35,0x77,0x0c}}, // \xe6\xa6\xbe
{0x69bf,{0x1a,0x7f,0x5b,0x6a,0x6b,0x6a,0x5b}}, // \xe6\xa6\xbf
{0x69c1,{0x1a,0x7f,0x72,0x1e,0x5b,0x1e,0x72}}, // \xe6\xa7\x81
{0x69c3,{0x5c,0x57,0x3f,0x74,0x3b,0x55,0x5b}}, // \xe6\xa7\x83
{0x69c7,{0x1a,0x7f,0x58,0x13,0x1e,0x1e,0x52}}, // \xe6\xa7\x87
{0x69ca,{0x57,0x5e,0x37,0x78,0x37,0x55,0x5f}}, // \xe6\xa7\x8a
{0x69cb,{0x1a,0x7f,0x2a,0x7f,0x3a,0x7f,0x2a}}, // \xe6\xa7\x8b
{0x69cc,{0x1a,0x7f,0x4a,0x39,0x40,0x7e,0x77}}, // \xe6\xa7\x8c
{0x69cd,{0x1a,0x7f,0x24,0x1e,0x6d,0x62,0x04}}, // \xe6\xa7\x8d
{0x69ce,{0x1a,0x7f,0x4a,0x3b,0x5e,0x7b,0x5a}}, // \xe6\xa7\x8e
{0x69d0,{0x1a,0x7f,0x5e,0x2a,0x7f,0x6a,0x5e}}, // \xe6\xa7\x90
{0x69d3,{0x1a,0x7f,0x44,0x3d,0x2f,0x3d,0x44}}, // \xe6\xa7\x93
{0x69d8,{0x1a,0x7f,0x5a,0x2f,0x7e,0x2f,0x5a}}, // \xe6\xa7\x98
{0x69d9,{0x1a,0x7f,0x52,0x1e,0x1f,0x1e,0x52}}, // \xe6\xa7\x99
{0x69dd,{0x1a,0x7f,0x0a,0x5e,0x77,0x56,0x70}}, // \xe6\xa7\x9d
{0x69de,{0x1a,0x7f,0x0a,0x3e,0x3b,0x7e,0x4a}}, // \xe6\xa7\x9e
{0x69e7,{0x5a,0x5e,0x3f,0x7a,0x37,0x5d,0x55}}, // \xe6\xa7\xa7
{0x69e8,{0x1a,0x7f,0x2e,0x7b,0x2e,0x7f,0x1b}}, // \xe6\xa7\xa8
{0x69eb,{0x1a,0x7f,0x12,0x3e,0x5f,0x76,0x1a}}, // \xe6\xa7\xab
{0x69ed,{0x1a,0x7f,0x22,0x7e,0x2a,0x3f,0x52}}, // \xe6\xa7\xad
{0x69f2,{0x1a,0x7f,0x42,0x3d,0x7f,0x2a,0x7f}}, // \xe6\xa7\xb2
{0x69f9,{0x1a,0x7f,0x28,0x2e,0x77,0x2e,0x28}}, // \xe6\xa7\xb9
{0x69fb,{0x1a,0x7f,0x4a,0x3f,0x4a,0x3f,0x5f}}, // \xe6\xa7\xbb
{0x69fd,{0x1a,0x7f,0x1a,0x7f,0x5a,0x7f,0x1a}}, // \xe6\xa7\xbd
{0x69ff,{0x1a,0x7f,0x5a,0x5f,0x7a,0x5f,0x5a}}, // \xe6\xa7\xbf
{0x6a02,{0x5a,0x55,0x3e,0x7b,0x3e,0x5a,0x55}}, // \xe6\xa8\x82
{0x6a05,{0x1a,0x7f,0x0a,0x7d,0x22,0x79,0x52}}, // \xe6\xa8\x85
{0x6a0a,{0x4a,0x5f,0x5a,0x35,0x5a,0x5f,0x4a}}, // \xe6\xa8\x8a
{0x6a0b,{0x1a,0x7f,0x49,0x38,0x5d,0x4f,0x5c}}, // \xe6\xa8\x8b
{0x6a0c,{0x1a,0x7f,0x42,0x3f,0x3d,0x3f,0x42}}, // \xe6\xa8\x8c
{0x6a12,{0x1a,0x7f,0x16,0x6a,0x77,0x5a,0x66}}, // \xe6\xa8\x92
{0x6a13,{0x1a,0x7f,0x54,0x7e,0x5b,0x3e,0x54}}, // \xe6\xa8\x93
{0x6a14,{0x1a,0x7f,0x52,0x3d,0x7e,0x3d,0x50}}, // \xe6\xa8\x94
{0x6a17,{0x1a,0x7f,0x06,0x1b,0x1f,0x5b,0x76}}, // \xe6\xa8\x97
{0x6a19,{0x1a,0x7f,0x51,0x17,0x77,0x17,0x51}}, // \xe6\xa8\x99
{0x6a1b,{0x1a,0x7f,0x11,0x4b,0x54,0x29,0x13}}, // \xe6\xa8\x9b
{0x6a1e,{0x1a,0x7f,0x7f,0x71,0x47,0x77,0x71}}, // \xe6\xa8\x9e
{0x6a1f,{0x1a,0x7f,0x2a,0x3e,0x7b,0x3e,0x2a}}, // \xe6\xa8\x9f
{0x6a21,{0x1a,0x7f,0x52,0x5f,0x36,0x5f,0x52}}, // \xe6\xa8\xa1
{0x6a22,{0x1a,0x7f,0x0a,0x5e,0x17,0x56,0x70}}, // \xe6\xa8\xa2
{0x6a23,{0x1a,0x7f,0x52,0x37,0x7e,0x27,0x52}}, // \xe6\xa8\xa3
{0x6a29,{0x1a,0x7f,0x0a,0x14,0x7b,0x7e,0x4a}}, // \xe6\xa8\xa9
{0x6a2a,{0x1a,0x7f,0x4a,0x3f,0x3a,0x3f,0x4a}}, // \xe6\xa8\xaa
{0x6a2b,{0x1a,0x7f,0x47,0x57,0x7b,0x55,0x4b}}, // \xe6\xa8\xab
{0x6a2e,{0x1a,0x7f,0x51,0x47,0x37,0x47,0x51}}, // \xe6\xa8\xae
{0x6a35,{0x1a,0x7f,0x44,0x1f,0x52,0x1f,0x52}}, // \xe6\xa8\xb5
{0x6a36,{0x1a,0x7f,0x24,0x3f,0x7d,0x2f,0x5c}}, // \xe6\xa8\xb6
{0x6a38,{0x1a,0x7f,0x4b,0x5e,0x3b,0x5e,0x4b}}, // \xe6\xa8\xb8
{0x6a39,{0x1a,0x7f,0x5a,0x6f,0x5a,0x12,0x7f}}, // \xe6\xa8\xb9
{0x6a3a,{0x1a,0x7f,0x2a,0x3f,0x7e,0x3f,0x2a}}, // \xe6\xa8\xba
{0x6a3d,{0x1a,0x7f,0x1e,0x37,0x52,0x77,0x1e}}, // \xe6\xa8\xbd
{0x6a44,{0x1a,0x7f,0x3d,0x27,0x7d,0x3f,0x5e}}, // \xe6\xa9\x84
{0x6a47,{0x1a,0x7f,0x72,0x52,0x07,0x75,0x54}}, // \xe6\xa9\x87
{0x6a48,{0x1a,0x7f,0x5c,0x3e,0x17,0x7e,0x5c}}, // \xe6\xa9\x88
{0x6a4b,{0x1a,0x7f,0x7a,0x17,0x5b,0x17,0x7a}}, // \xe6\xa9\x8b
{0x6a58,{0x1a,0x7f,0x7a,0x37,0x5f,0x33,0x76}}, // \xe6\xa9\x98
{0x6a59,{0x1a,0x7f,0x45,0x5b,0x69,0x5a,0x45}}, // \xe6\xa9\x99
{0x6a5f,{0x1a,0x7f,0x4a,0x3d,0x48,0x3a,0x55}}, // \xe6\xa9\x9f
{0x6a61,{0x1a,0x7f,0x22,0x5e,0x7d,0x2f,0x50}}, // \xe6\xa9\xa1
{0x6a62,{0x1a,0x7f,0x25,0x1b,0x7e,0x3b,0x7a}}, // \xe6\xa9\xa2
{0x6a66,{0x1a,0x7f,0x4a,0x5e,0x7b,0x5e,0x4a}}, // \xe6\xa9\xa6
{0x6a72,{0x1a,0x7f,0x12,0x7e,0x57,0x7e,0x12}}, // \xe6\xa9\xb2
{0x6a78,{0x1a,0x7f,0x78,0x7f,0x05,0x7f,0x78}}, // \xe6\xa9\xb8
{0x6a7f,{0x1a,0x7f,0x02,0x49,0x7f,0x7f,0x49}}, // \xe6\xa9\xbf
{0x6a80,{0x1a,0x7f,0x4e,0x7e,0x5b,0x7e,0x4e}}, // \xe6\xaa\x80
{0x6a84,{0x1a,0x7f,0x2e,0x5f,0x7c,0x23,0x5e}}, // \xe6\xaa\x84
{0x6a8d,{0x1a,0x7f,0x6a,0x3e,0x5b,0x5e,0x6a}}, // \xe6\xaa\x8d
{0x6a8e,{0x1a,0x7f,0x7a,0x4e,0x7d,0x2e,0x7a}}, // \xe6\xaa\x8e
{0x6a90,{0x1a,0x7f,0x3c,0x2e,0x75,0x7f,0x2c}}, // \xe6\xaa\x90
{0x6a97,{0x54,0x5f,0x3b,0x70,0x36,0x5b,0x56}}, // \xe6\xaa\x97
{0x6a9c,{0x1a,0x7f,0x1c,0x76,0x5d,0x76,0x1c}}, // \xe6\xaa\x9c
{0x6aa0,{0x5a,0x57,0x36,0x7f,0x3a,0x55,0x5b}}, // \xe6\xaa\xa0
{0x6aa2,{0x1a,0x7f,0x5c,0x36,0x5d,0x36,0x5c}}, // \xe6\xaa\xa2
{0x6aa3,{0x1a,0x7f,0x7a,0x76,0x5b,0x76,0x7a}}, // \xe6\xaa\xa3
{0x6aaa,{0x1a,0x7f,0x55,0x36,0x79,0x36,0x55}}, // \xe6\xaa\xaa
{0x6aac,{0x1a,0x7f,0x2a,0x5f,0x7a,0x2f,0x5a}}, // \xe6\xaa\xac
{0x6aae,{0x1a,0x7f,0x34,0x36,0x5f,0x76,0x14}}, // \xe6\xaa\xae
{0x6ab3,{0x1a,0x7f,0x4e,0x3a,0x37,0x3a,0x46}}, // \xe6\xaa\xb3
{0x6ab8,{0x1a,0x7f,0x16,0x5e,0x7f,0x1a,0x16}}, // \xe6\xaa\xb8
{0x6abb,{0x1a,0x7f,0x4f,0x69,0x60,0x6b,0x4a}}, // \xe6\xaa\xbb
{0x6ac1,{0x1a,0x7f,0x56,0x5a,0x77,0x5a,0x66}}, // \xe6\xab\x81
{0x6ac2,{0x1a,0x7f,0x21,0x7b,0x50,0x79,0x53}}, // \xe6\xab\x82
{0x6ac3,{0x1a,0x7f,0x7f,0x65,0x5f,0x5f,0x65}}, // \xe6\xab\x83
{0x6ad1,{0x1a,0x7f,0x70,0x77,0x07,0x77,0x70}}, // \xe6\xab\x91
{0x6ad3,{0x1a,0x7f,0x12,0x6e,0x7d,0x6f,0x10}}, // \xe6\xab\x93
{0x6ada,{0x1a,0x7f,0x7f,0x73,0x5c,0x57,0x7f}}, // \xe6\xab\x9a
{0x6adb,{0x1a,0x7f,0x7b,0x5e,0x00,0x7b,0x1e}}, // \xe6\xab\x9b
{0x6ade,{0x1a,0x7f,0x2a,0x75,0x2c,0x5e,0x77}}, // \xe6\xab\x9e
{0x6adf,{0x1a,0x7f,0x5a,0x35,0x7f,0x3a,0x55}}, // \xe6\xab\x9f
{0x6ae8,{0x1a,0x7f,0x22,0x5c,0x64,0x6f,0x4a}}, // \xe6\xab\xa8
{0x6aea,{0x1a,0x7f,0x5f,0x6f,0x45,0x6f,0x45}}, // \xe6\xab\xaa
{0x6afa,{0x1a,0x7f,0x66,0x03,0x6f,0x03,0x66}}, // \xe6\xab\xba
{0x6afb,{0x1a,0x7f,0x57,0x7b,0x54,0x33,0x57}}, // \xe6\xab\xbb
{0x6b04,{0x1a,0x7f,0x7f,0x2b,0x7c,0x2b,0x7f}}, // \xe6\xac\x84
{0x6b05,{0x1a,0x7f,0x2e,0x79,0x7e,0x3d,0x2f}}, // \xe6\xac\x85
{0x6b0a,{0x1a,0x7f,0x26,0x7f,0x52,0x7f,0x56}}, // \xe6\xac\x8a
{0x6b12,{0x4a,0x5d,0x3a,0x77,0x3a,0x5d,0x48}}, // \xe6\xac\x92
{0x6b16,{0x1a,0x7f,0x47,0x3d,0x38,0x7f,0x46}}, // \xe6\xac\x96
{0x6b1d,{0x4a,0x7f,0x7a,0x5d,0x0a,0x5f,0x7a}}, // \xe6\xac\x9d
{0x6b1f,{0x1a,0x7f,0x77,0x7a,0x57,0x3f,0x5f}}, // \xe6\xac\x9f
{0x6b20,{0x48,0x47,0x22,0x1e,0x22,0x42,0x46}}, // \xe6\xac\xa0
{0x6b21,{0x71,0x00,0x44,0x23,0x1e,0x22,0x46}}, // \xe6\xac\xa1
{0x6b23,{0x40,0x3e,0x0a,0x79,0x44,0x3b,0x46}}, // \xe6\xac\xa3
{0x6b27,{0x7f,0x55,0x49,0x14,0x43,0x3e,0x46}}, // \xe6\xac\xa7
{0x6b32,{0x12,0x69,0x64,0x69,0x44,0x3b,0x46}}, // \xe6\xac\xb2
{0x6b37,{0x48,0x2d,0x7a,0x2d,0x64,0x3b,0x46}}, // \xe6\xac\xb7
{0x6b38,{0x56,0x5d,0x34,0x56,0x44,0x3b,0x46}}, // \xe6\xac\xb8
{0x6b39,{0x12,0x5a,0x17,0x7a,0x44,0x3b,0x46}}, // \xe6\xac\xb9
{0x6b3a,{0x52,0x1f,0x1a,0x5f,0x52,0x3b,0x46}}, // \xe6\xac\xba
{0x6b3d,{0x56,0x7d,0x36,0x44,0x43,0x3e,0x46}}, // \xe6\xac\xbd
{0x6b3e,{0x2a,0x6f,0x2a,0x44,0x43,0x3e,0x46}}, // \xe6\xac\xbe
{0x6b43,{0x74,0x56,0x7e,0x75,0x44,0x3b,0x46}}, // \xe6\xad\x83
{0x6b47,{0x30,0x2f,0x4d,0x7f,0x44,0x3b,0x46}}, // \xe6\xad\x87
{0x6b49,{0x52,0x37,0x7e,0x3f,0x44,0x3b,0x46}}, // \xe6\xad\x89
{0x6b4c,{0x2d,0x49,0x7f,0x44,0x43,0x3e,0x46}}, // \xe6\xad\x8c
{0x6b4e,{0x5a,0x5f,0x3a,0x5f,0x44,0x3b,0x46}}, // \xe6\xad\x8e
{0x6b50,{0x7f,0x71,0x47,0x77,0x74,0x3b,0x46}}, // \xe6\xad\x90
{0x6b53,{0x14,0x7b,0x7e,0x4a,0x44,0x3b,0x46}}, // \xe6\xad\x93
{0x6b54,{0x7c,0x44,0x7f,0x2a,0x44,0x3b,0x46}}, // \xe6\xad\x94
{0x6b59,{0x2c,0x7a,0x2d,0x7a,0x44,0x3b,0x46}}, // \xe6\xad\x99
{0x6b5b,{0x5c,0x36,0x5d,0x36,0x5c,0x3b,0x46}}, // \xe6\xad\x9b
{0x6b5f,{0x5e,0x11,0x1e,0x5f,0x44,0x3b,0x46}}, // \xe6\xad\x9f
{0x6b61,{0x26,0x7f,0x7a,0x57,0x44,0x3b,0x46}}, // \xe6\xad\xa1
{0x6b62,{0x40,0x7c,0x40,0x7f,0x44,0x44,0x40}}, // \xe6\xad\xa2
{0x6b63,{0x41,0x79,0x41,0x7f,0x49,0x49,0x41}}, // \xe6\xad\xa3
{0x6b64,{0x7c,0x40,0x3f,0x24,0x7f,0x48,0x64}}, // \xe6\xad\xa4
{0x6b66,{0x44,0x75,0x7d,0x54,0x0f,0x34,0x45}}, // \xe6\xad\xa6
{0x6b69,{0x28,0x5e,0x48,0x7f,0x2a,0x1a,0x28}}, // \xe6\xad\xa9
{0x6b6a,{0x45,0x6d,0x4b,0x7f,0x59,0x5b,0x45}}, // \xe6\xad\xaa
{0x6b6f,{0x04,0x7e,0x6c,0x7f,0x56,0x6e,0x7a}}, // \xe6\xad\xaf
{0x6b73,{0x48,0x3e,0x68,0x2f,0x4a,0x3a,0x58}}, // \xe6\xad\xb3
{0x6b74,{0x40,0x3f,0x45,0x6f,0x45,0x7f,0x55}}, // \xe6\xad\xb4
{0x6b78,{0x6e,0x7b,0x5c,0x18,0x6d,0x3f,0x7a}}, // \xe6\xad\xb8
{0x6b79,{0x01,0x49,0x49,0x37,0x15,0x0d,0x01}}, // \xe6\xad\xb9
{0x6b7b,{0x49,0x37,0x1d,0x01,0x7f,0x49,0x65}}, // \xe6\xad\xbb
{0x6b7f,{0x49,0x37,0x1d,0x44,0x5b,0x2d,0x5b}}, // \xe6\xad\xbf
{0x6b80,{0x49,0x37,0x1d,0x48,0x4a,0x3e,0x49}}, // \xe6\xae\x80
{0x6b83,{0x49,0x37,0x1d,0x48,0x4e,0x3b,0x4e}}, // \xe6\xae\x83
{0x6b84,{0x49,0x37,0x1d,0x42,0x55,0x2a,0x14}}, // \xe6\xae\x84
{0x6b86,{0x49,0x37,0x1d,0x08,0x6c,0x6b,0x6c}}, // \xe6\xae\x86
{0x6b89,{0x49,0x37,0x1d,0x3c,0x2b,0x3e,0x7e}}, // \xe6\xae\x89
{0x6b8a,{0x49,0x37,0x5d,0x2b,0x7f,0x2a,0x48}}, // \xe6\xae\x8a
{0x6b8b,{0x49,0x37,0x1d,0x4a,0x5f,0x2a,0x53}}, // \xe6\xae\x8b
{0x6b8d,{0x49,0x37,0x1d,0x22,0x6b,0x39,0x22}}, // \xe6\xae\x8d
{0x6b95,{0x49,0x37,0x1d,0x0a,0x6e,0x6b,0x6e}}, // \xe6\xae\x95
{0x6b96,{0x49,0x37,0x1d,0x7a,0x42,0x5f,0x5a}}, // \xe6\xae\x96
{0x6b98,{0x49,0x37,0x1d,0x52,0x5b,0x36,0x5b}}, // \xe6\xae\x98
{0x6b9e,{0x49,0x37,0x1d,0x5c,0x17,0x17,0x5c}}, // \xe6\xae\x9e
{0x6ba4,{0x49,0x37,0x1d,0x23,0x5e,0x3e,0x72}}, // \xe6\xae\xa4
{0x6baa,{0x49,0x37,0x1d,0x5a,0x6a,0x6f,0x5a}}, // \xe6\xae\xaa
{0x6bab,{0x49,0x37,0x1d,0x23,0x3f,0x7c,0x23}}, // \xe6\xae\xab
{0x6baf,{0x49,0x37,0x5f,0x3a,0x37,0x3a,0x46}}, // \xe6\xae\xaf
{0x6bb1,{0x49,0x37,0x5d,0x7f,0x54,0x3f,0x55}}, // \xe6\xae\xb1
{0x6bb2,{0x49,0x37,0x5d,0x7e,0x55,0x3f,0x55}}, // \xe6\xae\xb2
{0x6bb3,{0x44,0x4c,0x5b,0x29,0x5f,0x44,0x46}}, // \xe6\xae\xb3
{0x6bb4,{0x7f,0x55,0x49,0x14,0x5b,0x29,0x5b}}, // \xe6\xae\xb4
{0x6bb5,{0x20,0x7e,0x15,0x40,0x5b,0x29,0x5b}}, // \xe6\xae\xb5
{0x6bb7,{0x7e,0x2e,0x6d,0x00,0x5b,0x29,0x5b}}, // \xe6\xae\xb7
{0x6bba,{0x54,0x35,0x7a,0x35,0x5b,0x29,0x5b}}, // \xe6\xae\xba
{0x6bbb,{0x5a,0x2f,0x6a,0x58,0x5b,0x29,0x5b}}, // \xe6\xae\xbb
{0x6bbc,{0x5a,0x37,0x76,0x5a,0x5b,0x29,0x5b}}, // \xe6\xae\xbc
{0x6bbf,{0x40,0x3f,0x5d,0x15,0x5b,0x29,0x5b}}, // \xe6\xae\xbf
{0x6bc0,{0x4e,0x59,0x3a,0x2e,0x5b,0x29,0x5b}}, // \xe6\xaf\x80
{0x6bc5,{0x2a,0x5e,0x7b,0x2e,0x5b,0x29,0x5b}}, // \xe6\xaf\x85
{0x6bc6,{0x7f,0x71,0x47,0x77,0x5b,0x29,0x5b}}, // \xe6\xaf\x86
{0x6bcb,{0x08,0x38,0x2f,0x3f,0x69,0x7f,0x28}}, // \xe6\xaf\x8b
{0x6bcd,{0x08,0x38,0x2f,0x3b,0x69,0x7f,0x28}}, // \xe6\xaf\x8d
{0x6bce,{0x0c,0x3b,0x2e,0x3e,0x6a,0x7e,0x2a}}, // \xe6\xaf\x8e
{0x6bd2,{0x28,0x7a,0x6a,0x7f,0x6a,0x7a,0x28}}, // \xe6\xaf\x92
{0x6bd3,{0x33,0x2e,0x7e,0x12,0x6e,0x0b,0x6a}}, // \xe6\xaf\x93
{0x6bd4,{0x40,0x7f,0x24,0x24,0x7f,0x48,0x64}}, // \xe6\xaf\x94
{0x6bd8,{0x40,0x7f,0x55,0x07,0x7d,0x57,0x50}}, // \xe6\xaf\x98
{0x6bdb,{0x28,0x2a,0x2a,0x7e,0x55,0x55,0x54}}, // \xe6\xaf\x9b
{0x6bdf,{0x24,0x2a,0x28,0x7f,0x54,0x52,0x64}}, // \xe6\xaf\x9f
{0x6beb,{0x1a,0x2e,0x3a,0x7b,0x7a,0x6e,0x5a}}, // \xe6\xaf\xab
{0x6bec,{0x2a,0x7e,0x55,0x6a,0x52,0x7f,0x6a}}, // \xe6\xaf\xac
{0x6bef,{0x2a,0x7e,0x55,0x6a,0x68,0x57,0x6a}}, // \xe6\xaf\xaf
{0x6bf3,{0x24,0x74,0x55,0x0f,0x2b,0x7a,0x52}}, // \xe6\xaf\xb3
{0x6c08,{0x4e,0x7e,0x7b,0x2e,0x0a,0x7e,0x55}}, // \xe6\xb0\x88
{0x6c0f,{0x40,0x7e,0x4a,0x0e,0x19,0x29,0x48}}, // \xe6\xb0\x8f
{0x6c11,{0x40,0x7f,0x55,0x1d,0x35,0x57,0x50}}, // \xe6\xb0\x91
{0x6c13,{0x1e,0x23,0x22,0x7f,0x55,0x3d,0x57}}, // \xe6\xb0\x93
{0x6c14,{0x04,0x0b,0x0e,0x0e,0x0e,0x3a,0x42}}, // \xe6\xb0\x94
{0x6c17,{0x44,0x5b,0x2e,0x5e,0x0e,0x3a,0x42}}, // \xe6\xb0\x97
{0x6c1b,{0x14,0x4b,0x2e,0x6e,0x1e,0x3a,0x42}}, // \xe6\xb0\x9b
{0x6c23,{0x54,0x2b,0x7e,0x2e,0x5e,0x3a,0x42}}, // \xe6\xb0\xa3
{0x6c24,{0x0c,0x7b,0x6e,0x5e,0x7e,0x3a,0x42}}, // \xe6\xb0\xa4
{0x6c34,{0x24,0x14,0x4c,0x7f,0x08,0x14,0x22}}, // \xe6\xb0\xb4
{0x6c37,{0x24,0x15,0x4c,0x7f,0x08,0x14,0x22}}, // \xe6\xb0\xb7
{0x6c38,{0x28,0x18,0x45,0x7d,0x10,0x28,0x44}}, // \xe6\xb0\xb8
{0x6c3e,{0x75,0x00,0x3f,0x41,0x49,0x4f,0x60}}, // \xe6\xb0\xbe
{0x6c40,{0x75,0x00,0x01,0x41,0x7f,0x01,0x01}}, // \xe6\xb1\x80
{0x6c41,{0x75,0x00,0x04,0x04,0x7f,0x04,0x04}}, // \xe6\xb1\x81
{0x6c42,{0x22,0x2a,0x52,0x7f,0x12,0x2b,0x42}}, // \xe6\xb1\x82
{0x6c4e,{0x75,0x40,0x3f,0x05,0x09,0x7f,0x40}}, // \xe6\xb1\x8e
{0x6c50,{0x75,0x00,0x48,0x44,0x2b,0x12,0x0e}}, // \xe6\xb1\x90
{0x6c55,{0x75,0x00,0x7c,0x40,0x7f,0x40,0x7c}}, // \xe6\xb1\x95
{0x6c57,{0x75,0x00,0x08,0x09,0x7f,0x09,0x08}}, // \xe6\xb1\x97
{0x6c5a,{0x75,0x00,0x05,0x1f,0x15,0x55,0x75}}, // \xe6\xb1\x9a
{0x6c5d,{0x75,0x00,0x44,0x5c,0x37,0x2c,0x44}}, // \xe6\xb1\x9d
{0x6c5e,{0x54,0x35,0x45,0x7f,0x15,0x25,0x54}}, // \xe6\xb1\x9e
{0x6c5f,{0x75,0x00,0x42,0x42,0x7e,0x42,0x42}}, // \xe6\xb1\x9f
{0x6c60,{0x75,0x00,0x08,0x7e,0x44,0x5f,0x6c}}, // \xe6\xb1\xa0
{0x6c62,{0x75,0x00,0x40,0x44,0x7f,0x44,0x40}}, // \xe6\xb1\xa2
{0x6c68,{0x75,0x00,0x7f,0x49,0x49,0x49,0x7f}}, // \xe6\xb1\xa8
{0x6c6a,{0x75,0x00,0x41,0x49,0x7f,0x49,0x41}}, // \xe6\xb1\xaa
{0x6c70,{0x75,0x00,0x44,0x24,0x5f,0x24,0x44}}, // \xe6\xb1\xb0
{0x6c72,{0x75,0x40,0x31,0x4f,0x51,0x27,0x5c}}, // \xe6\xb1\xb2
{0x6c73,{0x75,0x40,0x3f,0x45,0x5d,0x25,0x5d}}, // \xe6\xb1\xb3
{0x6c7a,{0x75,0x00,0x48,0x4a,0x3f,0x4e,0x48}}, // \xe6\xb1\xba
{0x6c7d,{0x75,0x04,0x0b,0x0e,0x0e,0x3a,0x42}}, // \xe6\xb1\xbd
{0x6c7e,{0x75,0x00,0x44,0x3b,0x48,0x7b,0x04}}, // \xe6\xb1\xbe
{0x6c81,{0x75,0x20,0x18,0x7d,0x42,0x68,0x10}}, // \xe6\xb2\x81
{0x6c82,{0x75,0x40,0x3e,0x0a,0x0a,0x79,0x08}}, // \xe6\xb2\x82
{0x6c83,{0x75,0x00,0x48,0x4a,0x3e,0x49,0x48}}, // \xe6\xb2\x83
{0x6c88,{0x75,0x00,0x46,0x22,0x1f,0x7a,0x46}}, // \xe6\xb2\x88
{0x6c8c,{0x75,0x00,0x1a,0x12,0x7f,0x52,0x5a}}, // \xe6\xb2\x8c
{0x6c8d,{0x75,0x00,0x41,0x59,0x57,0x75,0x4d}}, // \xe6\xb2\x8d
{0x6c90,{0x75,0x00,0x22,0x1a,0x7f,0x1a,0x22}}, // \xe6\xb2\x90
{0x6c92,{0x75,0x00,0x44,0x5b,0x29,0x5d,0x47}}, // \xe6\xb2\x92
{0x6c93,{0x0a,0x7a,0x56,0x5f,0x54,0x7a,0x08}}, // \xe6\xb2\x93
{0x6c96,{0x75,0x00,0x1e,0x12,0x7f,0x12,0x1e}}, // \xe6\xb2\x96
{0x6c99,{0x75,0x00,0x08,0x46,0x5f,0x22,0x14}}, // \xe6\xb2\x99
{0x6c9a,{0x75,0x40,0x7c,0x40,0x7f,0x44,0x40}}, // \xe6\xb2\x9a
{0x6c9b,{0x75,0x00,0x3a,0x0a,0x7f,0x0a,0x3a}}, // \xe6\xb2\x9b
{0x6ca1,{0x75,0x00,0x44,0x5b,0x29,0x5f,0x44}}, // \xe6\xb2\xa1
{0x6ca2,{0x75,0x40,0x3f,0x05,0x1d,0x25,0x47}}, // \xe6\xb2\xa2
{0x6cab,{0x75,0x00,0x42,0x2a,0x7f,0x2a,0x42}}, // \xe6\xb2\xab
{0x6cae,{0x75,0x40,0x7f,0x55,0x55,0x7f,0x40}}, // \xe6\xb2\xae
{0x6cb1,{0x75,0x00,0x06,0x7a,0x53,0x4a,0x66}}, // \xe6\xb2\xb1
{0x6cb3,{0x75,0x00,0x1d,0x15,0x1d,0x41,0x7f}}, // \xe6\xb2\xb3
{0x6cb8,{0x75,0x00,0x5a,0x3f,0x16,0x7f,0x36}}, // \xe6\xb2\xb8
{0x6cb9,{0x75,0x00,0x7e,0x4a,0x7f,0x4a,0x7e}}, // \xe6\xb2\xb9
{0x6cba,{0x75,0x00,0x7f,0x49,0x7f,0x49,0x7f}}, // \xe6\xb2\xba
{0x6cbb,{0x75,0x00,0x08,0x6c,0x6b,0x64,0x08}}, // \xe6\xb2\xbb
{0x6cbc,{0x75,0x00,0x09,0x75,0x53,0x59,0x7f}}, // \xe6\xb2\xbc
{0x6cbd,{0x75,0x00,0x04,0x74,0x5f,0x74,0x04}}, // \xe6\xb2\xbd
{0x6cbe,{0x75,0x00,0x70,0x50,0x5f,0x54,0x74}}, // \xe6\xb2\xbe
{0x6cbf,{0x75,0x00,0x08,0x77,0x50,0x77,0x08}}, // \xe6\xb2\xbf
{0x6cc1,{0x75,0x00,0x4f,0x39,0x09,0x79,0x4f}}, // \xe6\xb3\x81
{0x6cc4,{0x75,0x00,0x7f,0x44,0x5f,0x54,0x5f}}, // \xe6\xb3\x84
{0x6cc5,{0x75,0x00,0x7f,0x51,0x4d,0x51,0x7f}}, // \xe6\xb3\x85
{0x6cc9,{0x50,0x3e,0x4a,0x7b,0x1a,0x2e,0x50}}, // \xe6\xb3\x89
{0x6cca,{0x75,0x00,0x7e,0x4a,0x4b,0x4a,0x7e}}, // \xe6\xb3\x8a
{0x6ccc,{0x75,0x00,0x58,0x3d,0x52,0x48,0x56}}, // \xe6\xb3\x8c
{0x6cd3,{0x75,0x00,0x5d,0x77,0x70,0x4f,0x60}}, // \xe6\xb3\x93
{0x6cd5,{0x75,0x00,0x48,0x6a,0x5f,0x2a,0x48}}, // \xe6\xb3\x95
{0x6cd7,{0x75,0x00,0x7f,0x4f,0x41,0x4f,0x7f}}, // \xe6\xb3\x97
{0x6cd9,{0x75,0x00,0x15,0x13,0x7f,0x13,0x15}}, // \xe6\xb3\x99
{0x6cdb,{0x75,0x40,0x35,0x25,0x57,0x4d,0x40}}, // \xe6\xb3\x9b
{0x6cdd,{0x75,0x40,0x3e,0x0a,0x1a,0x79,0x28}}, // \xe6\xb3\x9d
{0x6ce1,{0x75,0x00,0x04,0x77,0x5e,0x42,0x5e}}, // \xe6\xb3\xa1
{0x6ce2,{0x75,0x40,0x3e,0x5a,0x2f,0x5a,0x46}}, // \xe6\xb3\xa2
{0x6ce3,{0x75,0x00,0x42,0x7e,0x63,0x5e,0x42}}, // \xe6\xb3\xa3
{0x6ce5,{0x75,0x40,0x3f,0x05,0x7d,0x55,0x57}}, // \xe6\xb3\xa5
{0x6ce8,{0x75,0x00,0x44,0x55,0x7e,0x54,0x44}}, // \xe6\xb3\xa8
{0x6cea,{0x75,0x00,0x7f,0x55,0x55,0x55,0x7f}}, // \xe6\xb3\xaa
{0x6cef,{0x75,0x00,0x7f,0x55,0x1d,0x35,0x57}}, // \xe6\xb3\xaf
{0x6cf0,{0x48,0x5a,0x2e,0x77,0x2e,0x5a,0x48}}, // \xe6\xb3\xb0
{0x6cf1,{0x75,0x00,0x48,0x4e,0x3b,0x4e,0x48}}, // \xe6\xb3\xb1
{0x6cf3,{0x75,0x28,0x18,0x45,0x7d,0x10,0x28}}, // \xe6\xb3\xb3
{0x6d0b,{0x75,0x00,0x22,0x2b,0x7e,0x2b,0x22}}, // \xe6\xb4\x8b
{0x6d0c,{0x75,0x00,0x49,0x37,0x1d,0x4e,0x7f}}, // \xe6\xb4\x8c
{0x6d12,{0x75,0x00,0x7d,0x5f,0x45,0x5f,0x7d}}, // \xe6\xb4\x92
{0x6d17,{0x75,0x00,0x4c,0x3b,0x0f,0x7a,0x4a}}, // \xe6\xb4\x97
{0x6d19,{0x75,0x00,0x4c,0x2b,0x7f,0x2a,0x48}}, // \xe6\xb4\x99
{0x6d1b,{0x75,0x00,0x10,0x6a,0x65,0x6b,0x10}}, // \xe6\xb4\x9b
{0x6d1e,{0x75,0x00,0x7f,0x35,0x35,0x41,0x7f}}, // \xe6\xb4\x9e
{0x6d1f,{0x75,0x02,0x5e,0x56,0x3f,0x56,0x72}}, // \xe6\xb4\x9f
{0x6d25,{0x75,0x00,0x2a,0x2a,0x7f,0x2e,0x24}}, // \xe6\xb4\xa5
{0x6d29,{0x75,0x00,0x4e,0x4a,0x5f,0x2e,0x50}}, // \xe6\xb4\xa9
{0x6d2a,{0x75,0x00,0x52,0x1f,0x12,0x1f,0x52}}, // \xe6\xb4\xaa
{0x6d2b,{0x75,0x40,0x7e,0x43,0x7e,0x7e,0x40}}, // \xe6\xb4\xab
{0x6d32,{0x75,0x4c,0x3f,0x0c,0x7f,0x0c,0x7f}}, // \xe6\xb4\xb2
{0x6d33,{0x75,0x5c,0x37,0x2c,0x7e,0x42,0x7e}}, // \xe6\xb4\xb3
{0x6d35,{0x75,0x00,0x04,0x3f,0x2a,0x3e,0x7e}}, // \xe6\xb4\xb5
{0x6d36,{0x75,0x00,0x04,0x37,0x2a,0x36,0x7e}}, // \xe6\xb4\xb6
{0x6d38,{0x75,0x00,0x4a,0x38,0x0f,0x78,0x4a}}, // \xe6\xb4\xb8
{0x6d3b,{0x75,0x00,0x04,0x76,0x5e,0x75,0x04}}, // \xe6\xb4\xbb
{0x6d3d,{0x75,0x00,0x04,0x72,0x55,0x76,0x04}}, // \xe6\xb4\xbd
{0x6d3e,{0x75,0x40,0x3e,0x7a,0x0a,0x35,0x54}}, // \xe6\xb4\xbe
{0x6d41,{0x75,0x00,0x4a,0x3e,0x7b,0x06,0x6a}}, // \xe6\xb5\x81
{0x6d44,{0x75,0x08,0x2a,0x6e,0x7d,0x2f,0x3c}}, // \xe6\xb5\x84
{0x6d45,{0x75,0x00,0x4a,0x4a,0x5f,0x2a,0x53}}, // \xe6\xb5\x85
{0x6d59,{0x75,0x00,0x52,0x7f,0x3e,0x0a,0x79}}, // \xe6\xb5\x99
{0x6d5a,{0x75,0x00,0x2a,0x57,0x32,0x5e,0x4b}}, // \xe6\xb5\x9a
{0x6d5c,{0x75,0x00,0x50,0x1e,0x16,0x1d,0x54}}, // \xe6\xb5\x9c
{0x6d63,{0x75,0x00,0x56,0x32,0x17,0x76,0x56}}, // \xe6\xb5\xa3
{0x6d64,{0x75,0x00,0x56,0x6a,0x5f,0x4a,0x6e}}, // \xe6\xb5\xa4
{0x6d66,{0x75,0x00,0x7a,0x2a,0x7f,0x2a,0x7b}}, // \xe6\xb5\xa6
{0x6d69,{0x75,0x00,0x0c,0x6b,0x6f,0x6a,0x08}}, // \xe6\xb5\xa9
{0x6d6a,{0x75,0x00,0x7e,0x5a,0x3b,0x5e,0x40}}, // \xe6\xb5\xaa
{0x6d6c,{0x75,0x00,0x5f,0x55,0x7f,0x55,0x5f}}, // \xe6\xb5\xac
{0x6d6e,{0x75,0x00,0x22,0x2a,0x69,0x3b,0x21}}, // \xe6\xb5\xae
{0x6d74,{0x75,0x00,0x12,0x69,0x64,0x69,0x12}}, // \xe6\xb5\xb4
{0x6d77,{0x75,0x08,0x3b,0x3e,0x6e,0x7e,0x2a}}, // \xe6\xb5\xb7
{0x6d78,{0x75,0x00,0x58,0x5d,0x2d,0x5f,0x58}}, // \xe6\xb5\xb8
{0x6d79,{0x75,0x00,0x52,0x4e,0x3f,0x4e,0x52}}, // \xe6\xb5\xb9
{0x6d85,{0x75,0x00,0x47,0x55,0x7d,0x55,0x47}}, // \xe6\xb6\x85
{0x6d88,{0x75,0x00,0x7d,0x14,0x17,0x54,0x7d}}, // \xe6\xb6\x88
{0x6d8c,{0x75,0x00,0x7d,0x15,0x7d,0x17,0x7d}}, // \xe6\xb6\x8c
{0x6d8e,{0x75,0x00,0x55,0x3b,0x52,0x5e,0x55}}, // \xe6\xb6\x8e
{0x6d93,{0x75,0x00,0x78,0x2b,0x2b,0x2b,0x78}}, // \xe6\xb6\x93
{0x6d95,{0x75,0x00,0x5a,0x2b,0x7e,0x2b,0x6e}}, // \xe6\xb6\x95
{0x6d99,{0x75,0x00,0x21,0x5f,0x55,0x3d,0x57}}, // \xe6\xb6\x99
{0x6d9b,{0x75,0x50,0x34,0x5e,0x17,0x7e,0x14}}, // \xe6\xb6\x9b
{0x6d9c,{0x75,0x00,0x5a,0x2a,0x0f,0x6a,0x5a}}, // \xe6\xb6\x9c
{0x6daf,{0x75,0x40,0x3f,0x41,0x55,0x7f,0x55}}, // \xe6\xb6\xaf
{0x6db2,{0x75,0x00,0x12,0x7e,0x53,0x2a,0x5a}}, // \xe6\xb6\xb2
{0x6db5,{0x75,0x00,0x7d,0x5b,0x7f,0x59,0x7d}}, // \xe6\xb6\xb5
{0x6db8,{0x75,0x00,0x7f,0x75,0x6f,0x75,0x7f}}, // \xe6\xb6\xb8
{0x6dbc,{0x75,0x00,0x22,0x4e,0x7b,0x0e,0x22}}, // \xe6\xb6\xbc
{0x6dc0,{0x75,0x00,0x46,0x32,0x46,0x7f,0x56}}, // \xe6\xb7\x80
{0x6dc5,{0x75,0x00,0x1a,0x7f,0x3e,0x0a,0x79}}, // \xe6\xb7\x85
{0x6dc6,{0x75,0x28,0x19,0x7d,0x2a,0x7d,0x08}}, // \xe6\xb7\x86
{0x6dc7,{0x75,0x00,0x52,0x1f,0x1a,0x1f,0x52}}, // \xe6\xb7\x87
{0x6dcb,{0x75,0x22,0x1a,0x7f,0x1a,0x7f,0x12}}, // \xe6\xb7\x8b
{0x6dcc,{0x75,0x00,0x7a,0x09,0x6e,0x69,0x7a}}, // \xe6\xb7\x8c
{0x6dd1,{0x75,0x28,0x7f,0x2a,0x4d,0x31,0x4f}}, // \xe6\xb7\x91
{0x6dd2,{0x75,0x00,0x52,0x7a,0x5f,0x3e,0x52}}, // \xe6\xb7\x92
{0x6dd5,{0x75,0x00,0x54,0x4e,0x67,0x5e,0x54}}, // \xe6\xb7\x95
{0x6dd8,{0x75,0x00,0x64,0x4b,0x7e,0x6a,0x7e}}, // \xe6\xb7\x98
{0x6dd9,{0x75,0x00,0x56,0x12,0x77,0x16,0x56}}, // \xe6\xb7\x99
{0x6dde,{0x75,0x1a,0x7f,0x0a,0x63,0x58,0x63}}, // \xe6\xb7\x9e
{0x6de1,{0x75,0x00,0x55,0x22,0x19,0x22,0x55}}, // \xe6\xb7\xa1
{0x6de4,{0x75,0x00,0x62,0x1f,0x7a,0x29,0x52}}, // \xe6\xb7\xa4
{0x6de6,{0x75,0x00,0x54,0x76,0x7d,0x76,0x54}}, // \xe6\xb7\xa6
{0x6de8,{0x75,0x00,0x12,0x55,0x7f,0x3d,0x12}}, // \xe6\xb7\xa8
{0x6dea,{0x75,0x00,0x74,0x32,0x75,0x36,0x74}}, // \xe6\xb7\xaa
{0x6deb,{0x75,0x00,0x56,0x52,0x76,0x51,0x55}}, // \xe6\xb7\xab
{0x6dec,{0x75,0x00,0x32,0x2e,0x73,0x2e,0x32}}, // \xe6\xb7\xac
{0x6dee,{0x75,0x00,0x04,0x7f,0x4a,0x7f,0x4a}}, // \xe6\xb7\xae
{0x6df1,{0x75,0x00,0x5b,0x35,0x71,0x3d,0x5b}}, // \xe6\xb7\xb1
{0x6df3,{0x75,0x00,0x22,0x2e,0x6b,0x3e,0x22}}, // \xe6\xb7\xb3
{0x6df5,{0x75,0x40,0x3f,0x14,0x77,0x14,0x7f}}, // \xe6\xb7\xb5
{0x6df7,{0x75,0x00,0x7f,0x55,0x05,0x7d,0x57}}, // \xe6\xb7\xb7
{0x6df9,{0x75,0x00,0x0a,0x36,0x3b,0x76,0x4a}}, // \xe6\xb7\xb9
{0x6dfa,{0x75,0x00,0x12,0x5a,0x5b,0x36,0x5b}}, // \xe6\xb7\xba
{0x6dfb,{0x75,0x00,0x54,0x0e,0x66,0x0d,0x54}}, // \xe6\xb7\xbb
{0x6e05,{0x75,0x00,0x08,0x7a,0x2f,0x7a,0x08}}, // \xe6\xb8\x85
{0x6e07,{0x75,0x00,0x10,0x3f,0x2d,0x4f,0x78}}, // \xe6\xb8\x87
{0x6e08,{0x75,0x00,0x52,0x36,0x2b,0x76,0x12}}, // \xe6\xb8\x88
{0x6e09,{0x75,0x08,0x5e,0x48,0x7f,0x2a,0x18}}, // \xe6\xb8\x89
{0x6e0a,{0x75,0x40,0x3f,0x2a,0x7f,0x2a,0x7f}}, // \xe6\xb8\x8a
{0x6e0b,{0x75,0x00,0x58,0x2e,0x08,0x2f,0x5a}}, // \xe6\xb8\x8b
{0x6e13,{0x75,0x00,0x56,0x5a,0x3e,0x59,0x55}}, // \xe6\xb8\x93
{0x6e15,{0x75,0x00,0x55,0x3c,0x55,0x0e,0x7f}}, // \xe6\xb8\x95
{0x6e19,{0x75,0x00,0x52,0x5d,0x3d,0x5f,0x50}}, // \xe6\xb8\x99
{0x6e1a,{0x75,0x00,0x28,0x1a,0x6f,0x6a,0x69}}, // \xe6\xb8\x9a
{0x6e1b,{0x75,0x40,0x3e,0x6a,0x6a,0x3f,0x52}}, // \xe6\xb8\x9b
{0x6e1d,{0x75,0x00,0x75,0x33,0x75,0x26,0x54}}, // \xe6\xb8\x9d
{0x6e1f,{0x75,0x18,0x0a,0x5e,0x7b,0x1e,0x1a}}, // \xe6\xb8\x9f
{0x6e20,{0x55,0x50,0x3f,0x7b,0x3b,0x5f,0x59}}, // \xe6\xb8\xa0
{0x6e21,{0x75,0x40,0x3e,0x4a,0x5f,0x2e,0x5a}}, // \xe6\xb8\xa1
{0x6e23,{0x75,0x00,0x4a,0x76,0x7f,0x76,0x4a}}, // \xe6\xb8\xa3
{0x6e24,{0x75,0x0c,0x26,0x77,0x2e,0x1f,0x7e}}, // \xe6\xb8\xa4
{0x6e25,{0x75,0x20,0x5f,0x5d,0x75,0x4d,0x57}}, // \xe6\xb8\xa5
{0x6e26,{0x75,0x00,0x78,0x6f,0x69,0x0f,0x78}}, // \xe6\xb8\xa6
{0x6e29,{0x75,0x40,0x77,0x55,0x75,0x77,0x40}}, // \xe6\xb8\xa9
{0x6e2b,{0x75,0x00,0x5f,0x32,0x77,0x36,0x57}}, // \xe6\xb8\xab
{0x6e2c,{0x75,0x00,0x5f,0x15,0x5f,0x0e,0x7f}}, // \xe6\xb8\xac
{0x6e2d,{0x75,0x00,0x0f,0x7d,0x2f,0x7d,0x0f}}, // \xe6\xb8\xad
{0x6e2e,{0x75,0x00,0x0a,0x6f,0x6a,0x0f,0x7a}}, // \xe6\xb8\xae
{0x6e2f,{0x75,0x28,0x1a,0x6f,0x5a,0x4f,0x1a}}, // \xe6\xb8\xaf
{0x6e38,{0x75,0x62,0x1f,0x7a,0x27,0x76,0x2e}}, // \xe6\xb8\xb8
{0x6e3a,{0x75,0x00,0x7f,0x55,0x7f,0x46,0x2f}}, // \xe6\xb8\xba
{0x6e3e,{0x75,0x00,0x27,0x3d,0x7f,0x3d,0x27}}, // \xe6\xb8\xbe
{0x6e43,{0x75,0x00,0x4a,0x3e,0x15,0x7f,0x15}}, // \xe6\xb9\x83
{0x6e4a,{0x75,0x28,0x1a,0x4e,0x3f,0x4e,0x1a}}, // \xe6\xb9\x8a
{0x6e4d,{0x75,0x00,0x6b,0x3a,0x6b,0x2a,0x6b}}, // \xe6\xb9\x8d
{0x6e4e,{0x75,0x00,0x7d,0x7d,0x57,0x7d,0x7d}}, // \xe6\xb9\x8e
{0x6e56,{0x75,0x3a,0x2f,0x3a,0x7f,0x15,0x7f}}, // \xe6\xb9\x96
{0x6e58,{0x75,0x1a,0x7f,0x0a,0x7f,0x55,0x7f}}, // \xe6\xb9\x98
{0x6e5b,{0x75,0x00,0x72,0x5f,0x72,0x5f,0x52}}, // \xe6\xb9\x9b
{0x6e5f,{0x75,0x00,0x50,0x5e,0x7b,0x5e,0x50}}, // \xe6\xb9\x9f
{0x6e67,{0x75,0x00,0x50,0x5d,0x3d,0x57,0x7d}}, // \xe6\xb9\xa7
{0x6e6b,{0x75,0x00,0x35,0x7f,0x4c,0x3f,0x44}}, // \xe6\xb9\xab
{0x6e6e,{0x75,0x00,0x5d,0x5f,0x75,0x5f,0x5d}}, // \xe6\xb9\xae
{0x6e6f,{0x75,0x00,0x24,0x5f,0x35,0x57,0x74}}, // \xe6\xb9\xaf
{0x6e72,{0x75,0x00,0x42,0x29,0x5b,0x29,0x5a}}, // \xe6\xb9\xb2
{0x6e76,{0x75,0x00,0x50,0x3e,0x7b,0x2e,0x50}}, // \xe6\xb9\xb6
{0x6e7e,{0x75,0x00,0x0a,0x3e,0x33,0x3e,0x6a}}, // \xe6\xb9\xbe
{0x6e7f,{0x75,0x00,0x57,0x7d,0x45,0x7d,0x57}}, // \xe6\xb9\xbf
{0x6e80,{0x75,0x08,0x7a,0x2f,0x3a,0x2f,0x7a}}, // \xe6\xba\x80
{0x6e82,{0x75,0x42,0x2e,0x7f,0x2a,0x4e,0x7f}}, // \xe6\xba\x82
{0x6e8c,{0x75,0x00,0x55,0x3b,0x19,0x7a,0x55}}, // \xe6\xba\x8c
{0x6e8f,{0x75,0x40,0x3e,0x12,0x77,0x5e,0x6a}}, // \xe6\xba\x8f
{0x6e90,{0x75,0x40,0x3f,0x21,0x4d,0x7f,0x2d}}, // \xe6\xba\x90
{0x6e96,{0x35,0x20,0x24,0x7f,0x2a,0x2f,0x2a}}, // \xe6\xba\x96
{0x6e98,{0x75,0x00,0x54,0x7e,0x77,0x6e,0x54}}, // \xe6\xba\x98
{0x6e9c,{0x75,0x00,0x0e,0x7a,0x79,0x77,0x0f}}, // \xe6\xba\x9c
{0x6e9d,{0x75,0x00,0x2a,0x7f,0x3a,0x7f,0x2a}}, // \xe6\xba\x9d
{0x6e9f,{0x75,0x00,0x53,0x1d,0x15,0x1d,0x53}}, // \xe6\xba\x9f
{0x6ea2,{0x75,0x00,0x4a,0x77,0x72,0x77,0x4a}}, // \xe6\xba\xa2
{0x6ea5,{0x75,0x00,0x12,0x3e,0x57,0x7e,0x13}}, // \xe6\xba\xa5
{0x6eaa,{0x75,0x00,0x52,0x55,0x3b,0x51,0x52}}, // \xe6\xba\xaa
{0x6eaf,{0x75,0x1a,0x53,0x3e,0x3f,0x15,0x7f}}, // \xe6\xba\xaf
{0x6eb2,{0x75,0x00,0x4e,0x59,0x2e,0x59,0x4f}}, // \xe6\xba\xb2
{0x6eb6,{0x75,0x00,0x26,0x16,0x6b,0x76,0x26}}, // \xe6\xba\xb6
{0x6eb7,{0x75,0x00,0x7f,0x6b,0x77,0x5b,0x7f}}, // \xe6\xba\xb7
{0x6eba,{0x75,0x20,0x5d,0x77,0x20,0x5d,0x77}}, // \xe6\xba\xba
{0x6ebd,{0x75,0x08,0x17,0x3d,0x57,0x7f,0x15}}, // \xe6\xba\xbd
{0x6ec2,{0x75,0x00,0x1a,0x4e,0x3b,0x6e,0x1a}}, // \xe6\xbb\x82
{0x6ec4,{0x75,0x00,0x24,0x1e,0x6d,0x62,0x04}}, // \xe6\xbb\x84
{0x6ec5,{0x75,0x3e,0x56,0x3e,0x56,0x3f,0x52}}, // \xe6\xbb\x85
{0x6ec9,{0x75,0x00,0x54,0x33,0x1f,0x73,0x54}}, // \xe6\xbb\x89
{0x6ecb,{0x75,0x00,0x6a,0x57,0x02,0x6b,0x56}}, // \xe6\xbb\x8b
{0x6ecc,{0x75,0x0c,0x7f,0x3e,0x2b,0x76,0x2a}}, // \xe6\xbb\x8c
{0x6ed1,{0x75,0x00,0x0c,0x77,0x35,0x77,0x0c}}, // \xe6\xbb\x91
{0x6ed3,{0x75,0x26,0x2a,0x3a,0x6f,0x3a,0x2e}}, // \xe6\xbb\x93
{0x6ed4,{0x75,0x00,0x72,0x69,0x43,0x69,0x7a}}, // \xe6\xbb\x94
{0x6ed5,{0x7f,0x15,0x7f,0x2d,0x76,0x2d,0x56}}, // \xe6\xbb\x95
{0x6edd,{0x75,0x00,0x0a,0x3e,0x3b,0x7e,0x4a}}, // \xe6\xbb\x9d
{0x6ede,{0x75,0x00,0x1a,0x6f,0x3a,0x6f,0x1a}}, // \xe6\xbb\x9e
{0x6eec,{0x75,0x00,0x21,0x1f,0x7b,0x5f,0x5b}}, // \xe6\xbb\xac
{0x6eef,{0x75,0x00,0x3a,0x17,0x7a,0x17,0x3a}}, // \xe6\xbb\xaf
{0x6ef2,{0x75,0x00,0x1a,0x4f,0x5a,0x2d,0x1a}}, // \xe6\xbb\xb2
{0x6ef4,{0x75,0x00,0x7a,0x6e,0x5b,0x6e,0x7a}}, // \xe6\xbb\xb4
{0x6ef7,{0x75,0x00,0x7c,0x6c,0x57,0x6e,0x7a}}, // \xe6\xbb\xb7
{0x6ef8,{0x75,0x00,0x6b,0x6a,0x17,0x7e,0x12}}, // \xe6\xbb\xb8
{0x6efe,{0x75,0x02,0x2a,0x7e,0x5b,0x26,0x4a}}, // \xe6\xbb\xbe
{0x6eff,{0x75,0x00,0x7a,0x3f,0x7a,0x3f,0x7a}}, // \xe6\xbb\xbf
{0x6f01,{0x75,0x00,0x42,0x1e,0x5d,0x17,0x5c}}, // \xe6\xbc\x81
{0x6f02,{0x75,0x00,0x51,0x17,0x77,0x17,0x51}}, // \xe6\xbc\x82
{0x6f06,{0x75,0x40,0x2a,0x56,0x7f,0x36,0x4a}}, // \xe6\xbc\x86
{0x6f09,{0x75,0x40,0x3e,0x6a,0x4f,0x6e,0x42}}, // \xe6\xbc\x89
{0x6f0f,{0x75,0x20,0x1f,0x6b,0x7b,0x2b,0x6b}}, // \xe6\xbc\x8f
{0x6f11,{0x75,0x00,0x7f,0x2e,0x49,0x3f,0x4f}}, // \xe6\xbc\x91
{0x6f13,{0x75,0x00,0x72,0x5e,0x7b,0x3e,0x72}}, // \xe6\xbc\x93
{0x6f14,{0x75,0x00,0x56,0x2a,0x3b,0x2a,0x56}}, // \xe6\xbc\x94
{0x6f15,{0x75,0x00,0x1a,0x7f,0x5a,0x7f,0x1a}}, // \xe6\xbc\x95
{0x6f20,{0x75,0x00,0x52,0x5f,0x36,0x5f,0x52}}, // \xe6\xbc\xa0
{0x6f22,{0x75,0x12,0x5e,0x5b,0x3e,0x5b,0x5e}}, // \xe6\xbc\xa2
{0x6f23,{0x75,0x00,0x79,0x52,0x5e,0x7f,0x52}}, // \xe6\xbc\xa3
{0x6f2b,{0x75,0x00,0x4c,0x5f,0x2d,0x5f,0x4c}}, // \xe6\xbc\xab
{0x6f2c,{0x75,0x00,0x48,0x3a,0x3f,0x3a,0x48}}, // \xe6\xbc\xac
{0x6f31,{0x75,0x42,0x2e,0x7f,0x4e,0x3b,0x46}}, // \xe6\xbc\xb1
{0x6f32,{0x75,0x00,0x5d,0x77,0x70,0x3f,0x55}}, // \xe6\xbc\xb2
{0x6f38,{0x75,0x00,0x2d,0x7f,0x3e,0x0a,0x79}}, // \xe6\xbc\xb8
{0x6f3e,{0x75,0x00,0x52,0x37,0x7e,0x27,0x52}}, // \xe6\xbc\xbe
{0x6f3f,{0x4b,0x56,0x3f,0x74,0x26,0x5d,0x47}}, // \xe6\xbc\xbf
{0x6f41,{0x57,0x3a,0x7a,0x29,0x5d,0x17,0x5d}}, // \xe6\xbd\x81
{0x6f45,{0x75,0x00,0x14,0x7b,0x4e,0x7a,0x4a}}, // \xe6\xbd\x85
{0x6f54,{0x75,0x00,0x5a,0x1f,0x7a,0x17,0x5f}}, // \xe6\xbd\x94
{0x6f58,{0x75,0x00,0x15,0x6f,0x7d,0x6f,0x15}}, // \xe6\xbd\x98
{0x6f5b,{0x75,0x00,0x14,0x6f,0x76,0x6f,0x16}}, // \xe6\xbd\x9b
{0x6f5c,{0x75,0x00,0x0a,0x77,0x5a,0x77,0x0a}}, // \xe6\xbd\x9c
{0x6f5f,{0x75,0x20,0x56,0x1d,0x54,0x17,0x70}}, // \xe6\xbd\x9f
{0x6f64,{0x75,0x7f,0x03,0x57,0x7c,0x57,0x7f}}, // \xe6\xbd\xa4
{0x6f66,{0x75,0x00,0x4a,0x1e,0x6b,0x1e,0x4a}}, // \xe6\xbd\xa6
{0x6f6d,{0x75,0x00,0x21,0x3b,0x6b,0x3b,0x21}}, // \xe6\xbd\xad
{0x6f6e,{0x75,0x00,0x2d,0x7f,0x3f,0x15,0x7f}}, // \xe6\xbd\xae
{0x6f6f,{0x75,0x00,0x14,0x3d,0x57,0x7f,0x1a}}, // \xe6\xbd\xaf
{0x6f70,{0x75,0x08,0x4e,0x3a,0x3f,0x3a,0x4e}}, // \xe6\xbd\xb0
{0x6f74,{0x75,0x00,0x55,0x3e,0x1a,0x6f,0x6a}}, // \xe6\xbd\xb4
{0x6f78,{0x75,0x00,0x0a,0x77,0x3a,0x77,0x0a}}, // \xe6\xbd\xb8
{0x6f7a,{0x75,0x40,0x3f,0x53,0x3b,0x57,0x33}}, // \xe6\xbd\xba
{0x6f7c,{0x75,0x00,0x4a,0x5e,0x7b,0x5e,0x4a}}, // \xe6\xbd\xbc
{0x6f80,{0x75,0x40,0x7d,0x53,0x05,0x7b,0x57}}, // \xe6\xbe\x80
{0x6f81,{0x75,0x48,0x78,0x5e,0x08,0x7f,0x5a}}, // \xe6\xbe\x81
{0x6f82,{0x75,0x00,0x56,0x77,0x56,0x3f,0x5e}}, // \xe6\xbe\x82
{0x6f84,{0x65,0x10,0x45,0x5b,0x69,0x5a,0x45}}, // \xe6\xbe\x84
{0x6f86,{0x75,0x00,0x5c,0x3e,0x17,0x7e,0x5c}}, // \xe6\xbe\x86
{0x6f8e,{0x75,0x00,0x5a,0x6f,0x5a,0x4a,0x25}}, // \xe6\xbe\x8e
{0x6f91,{0x75,0x00,0x7d,0x5f,0x71,0x5f,0x7d}}, // \xe6\xbe\x91
{0x6f97,{0x75,0x00,0x7f,0x03,0x38,0x3b,0x7f}}, // \xe6\xbe\x97
{0x6fa1,{0x75,0x00,0x5c,0x37,0x7d,0x37,0x5c}}, // \xe6\xbe\xa1
{0x6fa3,{0x75,0x00,0x2d,0x7f,0x2a,0x79,0x2a}}, // \xe6\xbe\xa3
{0x6fa4,{0x75,0x00,0x2b,0x3b,0x6f,0x3b,0x2b}}, // \xe6\xbe\xa4
{0x6faa,{0x75,0x00,0x16,0x1b,0x77,0x1b,0x36}}, // \xe6\xbe\xaa
{0x6fb1,{0x75,0x20,0x5f,0x1d,0x57,0x29,0x5b}}, // \xe6\xbe\xb1
{0x6fb3,{0x75,0x00,0x50,0x5e,0x3f,0x56,0x5e}}, // \xe6\xbe\xb3
{0x6fb9,{0x75,0x40,0x3c,0x2e,0x75,0x7f,0x2c}}, // \xe6\xbe\xb9
{0x6fc0,{0x75,0x48,0x2e,0x5f,0x7c,0x23,0x5e}}, // \xe6\xbf\x80
{0x6fc1,{0x75,0x00,0x4b,0x75,0x77,0x25,0x7f}}, // \xe6\xbf\x81
{0x6fc2,{0x75,0x20,0x5e,0x36,0x7f,0x3e,0x4a}}, // \xe6\xbf\x82
{0x6fc3,{0x75,0x40,0x36,0x77,0x56,0x37,0x56}}, // \xe6\xbf\x83
{0x6fc6,{0x75,0x00,0x4a,0x3e,0x2b,0x3e,0x4a}}, // \xe6\xbf\x86
{0x6fd4,{0x75,0x00,0x7d,0x2b,0x7f,0x2b,0x7d}}, // \xe6\xbf\x94
{0x6fd5,{0x75,0x00,0x5b,0x17,0x43,0x1b,0x57}}, // \xe6\xbf\x95
{0x6fd8,{0x75,0x00,0x16,0x5e,0x7f,0x1a,0x16}}, // \xe6\xbf\x98
{0x6fdb,{0x75,0x18,0x2a,0x5f,0x7a,0x2f,0x5a}}, // \xe6\xbf\x9b
{0x6fdf,{0x75,0x00,0x4a,0x36,0x2b,0x76,0x0a}}, // \xe6\xbf\x9f
{0x6fe0,{0x75,0x18,0x2a,0x5e,0x7b,0x2e,0x5a}}, // \xe6\xbf\xa0
{0x6fe1,{0x75,0x00,0x66,0x2b,0x7f,0x2b,0x66}}, // \xe6\xbf\xa1
{0x6fe4,{0x75,0x00,0x34,0x36,0x5f,0x76,0x14}}, // \xe6\xbf\xa4
{0x6feb,{0x75,0x00,0x4f,0x69,0x60,0x6b,0x4a}}, // \xe6\xbf\xab
{0x6fec,{0x75,0x00,0x2c,0x14,0x6f,0x76,0x2e}}, // \xe6\xbf\xac
{0x6fee,{0x75,0x0c,0x7f,0x5e,0x3b,0x5e,0x4b}}, // \xe6\xbf\xae
{0x6fef,{0x75,0x00,0x25,0x7f,0x50,0x7d,0x57}}, // \xe6\xbf\xaf
{0x6ff1,{0x75,0x00,0x4e,0x3a,0x37,0x3a,0x46}}, // \xe6\xbf\xb1
{0x6ff3,{0x75,0x00,0x17,0x6e,0x77,0x6e,0x16}}, // \xe6\xbf\xb3
{0x6ff6,{0x75,0x7f,0x0b,0x6c,0x5f,0x6b,0x7f}}, // \xe6\xbf\xb6
{0x6ffa,{0x75,0x00,0x5f,0x1f,0x5a,0x37,0x5a}}, // \xe6\xbf\xba
{0x6ffe,{0x75,0x40,0x3c,0x64,0x3f,0x5a,0x6a}}, // \xe6\xbf\xbe
{0x7001,{0x75,0x28,0x1a,0x7b,0x3e,0x5b,0x2a}}, // \xe7\x80\x81
{0x7009,{0x75,0x00,0x26,0x5a,0x17,0x5e,0x76}}, // \xe7\x80\x89
{0x700b,{0x75,0x00,0x56,0x3a,0x77,0x7a,0x36}}, // \xe7\x80\x8b
{0x700f,{0x75,0x00,0x26,0x55,0x6a,0x57,0x7f}}, // \xe7\x80\x8f
{0x7011,{0x75,0x00,0x5b,0x2f,0x7b,0x2f,0x5b}}, // \xe7\x80\x91
{0x7015,{0x75,0x48,0x5f,0x2a,0x5d,0x17,0x5d}}, // \xe7\x80\x95
{0x7018,{0x75,0x40,0x3c,0x44,0x6f,0x6a,0x4a}}, // \xe7\x80\x98
{0x701a,{0x75,0x00,0x2d,0x7f,0x2a,0x19,0x7a}}, // \xe7\x80\x9a
{0x701b,{0x75,0x42,0x3e,0x5a,0x2b,0x7a,0x4a}}, // \xe7\x80\x9b
{0x701d,{0x75,0x20,0x5f,0x6f,0x45,0x6f,0x45}}, // \xe7\x80\x9d
{0x701e,{0x75,0x7a,0x2f,0x7a,0x2a,0x7d,0x3b}}, // \xe7\x80\x9e
{0x701f,{0x75,0x48,0x3a,0x6f,0x06,0x6f,0x7a}}, // \xe7\x80\x9f
{0x7026,{0x75,0x28,0x55,0x3f,0x1a,0x6f,0x6a}}, // \xe7\x80\xa6
{0x7027,{0x75,0x0a,0x7e,0x2b,0x7e,0x77,0x5d}}, // \xe7\x80\xa7
{0x702c,{0x75,0x2e,0x7f,0x2e,0x5d,0x17,0x5d}}, // \xe7\x80\xac
{0x7030,{0x75,0x00,0x5d,0x77,0x7d,0x2b,0x7d}}, // \xe7\x80\xb0
{0x7032,{0x75,0x3c,0x56,0x3d,0x56,0x3f,0x5e}}, // \xe7\x80\xb2
{0x703e,{0x75,0x00,0x7f,0x2b,0x7c,0x2b,0x7f}}, // \xe7\x80\xbe
{0x704c,{0x75,0x00,0x26,0x7f,0x52,0x7f,0x56}}, // \xe7\x81\x8c
{0x7051,{0x75,0x20,0x7f,0x55,0x1e,0x7d,0x57}}, // \xe7\x81\x91
{0x7058,{0x75,0x5b,0x3e,0x5b,0x7f,0x7e,0x55}}, // \xe7\x81\x98
{0x7063,{0x75,0x00,0x0a,0x3d,0x3f,0x3a,0x6d}}, // \xe7\x81\xa3
{0x706b,{0x40,0x4c,0x20,0x1f,0x28,0x44,0x40}}, // \xe7\x81\xab
{0x706f,{0x4c,0x3f,0x24,0x01,0x41,0x7f,0x01}}, // \xe7\x81\xaf
{0x7070,{0x40,0x3f,0x4d,0x21,0x1f,0x29,0x45}}, // \xe7\x81\xb0
{0x7078,{0x48,0x5a,0x29,0x15,0x25,0x5b,0x48}}, // \xe7\x81\xb8
{0x707c,{0x4c,0x3f,0x24,0x0b,0x12,0x42,0x7e}}, // \xe7\x81\xbc
{0x707d,{0x42,0x55,0x20,0x1a,0x25,0x52,0x45}}, // \xe7\x81\xbd
{0x7089,{0x4c,0x3f,0x40,0x3d,0x15,0x15,0x1d}}, // \xe7\x82\x89
{0x708a,{0x4c,0x3f,0x44,0x23,0x1e,0x22,0x46}}, // \xe7\x82\x8a
{0x708e,{0x48,0x5a,0x24,0x13,0x24,0x5a,0x48}}, // \xe7\x82\x8e
{0x7092,{0x4c,0x3f,0x24,0x46,0x5f,0x22,0x14}}, // \xe7\x82\x92
{0x7099,{0x48,0x5a,0x2a,0x15,0x25,0x53,0x40}}, // \xe7\x82\x99
{0x70ac,{0x4c,0x3f,0x24,0x7f,0x55,0x55,0x5d}}, // \xe7\x82\xac
{0x70ad,{0x43,0x3e,0x5a,0x43,0x3e,0x52,0x4b}}, // \xe7\x82\xad
{0x70ae,{0x4c,0x3f,0x24,0x04,0x7b,0x5a,0x5e}}, // \xe7\x82\xae
{0x70af,{0x4c,0x3f,0x7f,0x1d,0x15,0x5d,0x7f}}, // \xe7\x82\xaf
{0x70b3,{0x4c,0x3f,0x7d,0x15,0x0f,0x55,0x7d}}, // \xe7\x82\xb3
{0x70b8,{0x4c,0x3f,0x24,0x03,0x7e,0x2a,0x2a}}, // \xe7\x82\xb8
{0x70b9,{0x40,0x18,0x58,0x1f,0x5a,0x1a,0x40}}, // \xe7\x82\xb9
{0x70ba,{0x20,0x52,0x1b,0x56,0x17,0x5c,0x70}}, // \xe7\x82\xba
{0x70c8,{0x49,0x17,0x4d,0x01,0x46,0x10,0x5f}}, // \xe7\x83\x88
{0x70cb,{0x44,0x1e,0x53,0x0a,0x5f,0x0a,0x52}}, // \xe7\x83\x8b
{0x70cf,{0x40,0x1e,0x5a,0x1b,0x5a,0x1e,0x70}}, // \xe7\x83\x8f
{0x70d9,{0x4c,0x3f,0x10,0x6a,0x65,0x6b,0x10}}, // \xe7\x83\x99
{0x70dd,{0x54,0x2d,0x61,0x3d,0x63,0x29,0x54}}, // \xe7\x83\x9d
{0x70df,{0x4c,0x3f,0x7f,0x55,0x4f,0x55,0x7f}}, // \xe7\x83\x9f
{0x70f1,{0x4c,0x3f,0x7f,0x3b,0x29,0x3b,0x7f}}, // \xe7\x83\xb1
{0x70f9,{0x42,0x0e,0x4a,0x0b,0x5a,0x0e,0x42}}, // \xe7\x83\xb9
{0x70fd,{0x4c,0x3f,0x28,0x2a,0x75,0x2b,0x28}}, // \xe7\x83\xbd
{0x7109,{0x49,0x1d,0x59,0x1f,0x5b,0x1b,0x79}}, // \xe7\x84\x89
{0x7114,{0x4c,0x3f,0x24,0x7a,0x01,0x7d,0x7b}}, // \xe7\x84\x94
{0x7119,{0x4c,0x3f,0x0a,0x6e,0x6b,0x6e,0x0a}}, // \xe7\x84\x99
{0x711a,{0x4a,0x56,0x2f,0x1a,0x26,0x5f,0x4a}}, // \xe7\x84\x9a
{0x711c,{0x4c,0x3f,0x7f,0x55,0x05,0x7d,0x57}}, // \xe7\x84\x9c
{0x7121,{0x6b,0x3e,0x6a,0x3e,0x6a,0x3e,0x6a}}, // \xe7\x84\xa1
{0x7126,{0x48,0x04,0x5f,0x16,0x5f,0x16,0x52}}, // \xe7\x84\xa6
{0x7136,{0x54,0x13,0x4d,0x07,0x52,0x0f,0x52}}, // \xe7\x84\xb6
{0x713c,{0x4c,0x3f,0x54,0x3e,0x17,0x7e,0x54}}, // \xe7\x84\xbc
{0x7149,{0x4c,0x3f,0x42,0x2e,0x7f,0x2e,0x42}}, // \xe7\x85\x89
{0x714c,{0x4c,0x3f,0x50,0x5e,0x7b,0x5e,0x50}}, // \xe7\x85\x8c
{0x714e,{0x42,0x1e,0x4b,0x1e,0x42,0x1f,0x42}}, // \xe7\x85\x8e
{0x7155,{0x5f,0x11,0x5b,0x15,0x40,0x1f,0x57}}, // \xe7\x85\x95
{0x7156,{0x4c,0x3f,0x42,0x29,0x5b,0x29,0x5a}}, // \xe7\x85\x96
{0x7159,{0x4c,0x3f,0x24,0x5d,0x5f,0x7f,0x5d}}, // \xe7\x85\x99
{0x7162,{0x0d,0x26,0x2d,0x7c,0x2d,0x3e,0x4d}}, // \xe7\x85\xa2
{0x7164,{0x4c,0x3f,0x52,0x3f,0x7a,0x3f,0x52}}, // \xe7\x85\xa4
{0x7165,{0x4c,0x3f,0x52,0x5d,0x3d,0x5f,0x50}}, // \xe7\x85\xa5
{0x7166,{0x5f,0x15,0x5f,0x04,0x5b,0x1a,0x5e}}, // \xe7\x85\xa6
{0x7167,{0x5f,0x15,0x5f,0x05,0x5b,0x19,0x5f}}, // \xe7\x85\xa7
{0x7169,{0x4c,0x3f,0x24,0x5d,0x17,0x15,0x5d}}, // \xe7\x85\xa9
{0x716c,{0x4c,0x3f,0x24,0x5f,0x35,0x57,0x74}}, // \xe7\x85\xac
{0x716e,{0x48,0x1a,0x4a,0x1f,0x5e,0x1b,0x48}}, // \xe7\x85\xae
{0x717d,{0x4c,0x3f,0x41,0x3f,0x5b,0x2b,0x79}}, // \xe7\x85\xbd
{0x7184,{0x4c,0x3f,0x60,0x2e,0x4f,0x4e,0x60}}, // \xe7\x86\x84
{0x7188,{0x50,0x0f,0x5f,0x1f,0x40,0x1f,0x57}}, // \xe7\x86\x88
{0x718a,{0x42,0x1f,0x4a,0x1f,0x40,0x1b,0x52}}, // \xe7\x86\x8a
{0x718f,{0x52,0x1e,0x5f,0x1f,0x5f,0x1e,0x52}}, // \xe7\x86\x8f
{0x7194,{0x4c,0x3f,0x26,0x16,0x6b,0x76,0x26}}, // \xe7\x86\x94
{0x7195,{0x4c,0x3f,0x44,0x3d,0x2f,0x3d,0x44}}, // \xe7\x86\x95
{0x7199,{0x5f,0x15,0x5b,0x15,0x40,0x1f,0x57}}, // \xe7\x86\x99
{0x719f,{0x52,0x0e,0x5b,0x0e,0x5f,0x1e,0x50}}, // \xe7\x86\x9f
{0x71a8,{0x48,0x57,0x2f,0x13,0x26,0x5a,0x4f}}, // \xe7\x86\xa8
{0x71ac,{0x54,0x0e,0x5f,0x06,0x54,0x0b,0x56}}, // \xe7\x86\xac
{0x71b1,{0x54,0x0e,0x5f,0x14,0x4b,0x1e,0x50}}, // \xe7\x86\xb1
{0x71b9,{0x4a,0x3a,0x6e,0x2f,0x6e,0x3a,0x4a}}, // \xe7\x86\xb9
{0x71be,{0x4c,0x3f,0x4a,0x6f,0x6e,0x3f,0x55}}, // \xe7\x86\xbe
{0x71c3,{0x4c,0x3f,0x54,0x0b,0x56,0x0f,0x52}}, // \xe7\x87\x83
{0x71c8,{0x4c,0x3f,0x45,0x5b,0x69,0x5a,0x45}}, // \xe7\x87\x88
{0x71c9,{0x4c,0x3f,0x2e,0x7b,0x56,0x3f,0x5e}}, // \xe7\x87\x89
{0x71ce,{0x4c,0x3f,0x4a,0x1e,0x6b,0x1e,0x4a}}, // \xe7\x87\x8e
{0x71d0,{0x4c,0x3f,0x55,0x32,0x27,0x72,0x25}}, // \xe7\x87\x90
{0x71d2,{0x4c,0x3f,0x5c,0x3e,0x17,0x7e,0x5c}}, // \xe7\x87\x92
{0x71d4,{0x4c,0x3f,0x15,0x6f,0x7d,0x6f,0x15}}, // \xe7\x87\x94
{0x71d5,{0x56,0x1e,0x43,0x1e,0x57,0x1e,0x56}}, // \xe7\x87\x95
{0x71d7,{0x4c,0x3f,0x7f,0x23,0x18,0x3b,0x7f}}, // \xe7\x87\x97
{0x71df,{0x0d,0x66,0x6d,0x7c,0x6d,0x66,0x0d}}, // \xe7\x87\x9f
{0x71e0,{0x4c,0x3f,0x50,0x5e,0x3f,0x56,0x5e}}, // \xe7\x87\xa0
{0x71e5,{0x4c,0x3f,0x5c,0x37,0x7d,0x37,0x5c}}, // \xe7\x87\xa5
{0x71e6,{0x4c,0x3f,0x54,0x2b,0x75,0x2a,0x56}}, // \xe7\x87\xa6
{0x71e7,{0x4c,0x3f,0x65,0x52,0x6d,0x7d,0x56}}, // \xe7\x87\xa7
{0x71ec,{0x4c,0x3f,0x56,0x7d,0x57,0x29,0x5b}}, // \xe7\x87\xac
{0x71ed,{0x4c,0x3f,0x4b,0x75,0x77,0x25,0x7f}}, // \xe7\x87\xad
{0x71ee,{0x4a,0x47,0x5a,0x2d,0x5a,0x47,0x4a}}, // \xe7\x87\xae
{0x71f5,{0x4c,0x3f,0x69,0x54,0x5e,0x77,0x5e}}, // \xe7\x87\xb5
{0x71f9,{0x45,0x5b,0x2d,0x10,0x25,0x5b,0x4d}}, // \xe7\x87\xb9
{0x71fb,{0x4c,0x3f,0x52,0x1f,0x5f,0x1f,0x52}}, // \xe7\x87\xbb
{0x71fc,{0x4c,0x3f,0x54,0x6a,0x7f,0x6e,0x54}}, // \xe7\x87\xbc
{0x71ff,{0x4c,0x3f,0x21,0x7b,0x50,0x79,0x53}}, // \xe7\x87\xbf
{0x7206,{0x4c,0x3f,0x5b,0x2f,0x7b,0x2f,0x5b}}, // \xe7\x88\x86
{0x720d,{0x4c,0x3f,0x5a,0x35,0x7f,0x3a,0x55}}, // \xe7\x88\x8d
{0x7210,{0x4c,0x3f,0x20,0x5c,0x64,0x6f,0x4a}}, // \xe7\x88\x90
{0x721b,{0x4c,0x3f,0x7f,0x2b,0x7c,0x2b,0x7f}}, // \xe7\x88\x9b
{0x7228,{0x2c,0x16,0x5d,0x36,0x5d,0x17,0x2c}}, // \xe7\x88\xa8
{0x722a,{0x40,0x3e,0x02,0x7e,0x01,0x3d,0x40}}, // \xe7\x88\xaa
{0x722c,{0x40,0x3e,0x7e,0x3d,0x40,0x5e,0x56}}, // \xe7\x88\xac
{0x722d,{0x14,0x13,0x55,0x7f,0x35,0x3d,0x12}}, // \xe7\x88\xad
{0x7230,{0x44,0x2b,0x5d,0x5f,0x2d,0x5d,0x4a}}, // \xe7\x88\xb0
{0x7232,{0x44,0x23,0x5d,0x17,0x55,0x1d,0x72}}, // \xe7\x88\xb2
{0x7235,{0x41,0x7f,0x5d,0x6f,0x0d,0x5f,0x7d}}, // \xe7\x88\xb5
{0x7236,{0x42,0x42,0x2d,0x10,0x2d,0x42,0x42}}, // \xe7\x88\xb6
{0x723a,{0x2a,0x3a,0x35,0x74,0x05,0x7a,0x2a}}, // \xe7\x88\xba
{0x723b,{0x40,0x45,0x5d,0x22,0x5a,0x45,0x40}}, // \xe7\x88\xbb
{0x723c,{0x55,0x22,0x55,0x7f,0x55,0x7f,0x40}}, // \xe7\x88\xbc
{0x723d,{0x42,0x56,0x2a,0x1f,0x2a,0x56,0x42}}, // \xe7\x88\xbd
{0x723e,{0x7d,0x57,0x2d,0x7f,0x55,0x2f,0x7d}}, // \xe7\x88\xbe
{0x723f,{0x00,0x50,0x37,0x14,0x14,0x7f,0x00}}, // \xe7\x88\xbf
{0x7240,{0x57,0x34,0x7f,0x1a,0x7f,0x1a,0x22}}, // \xe7\x89\x80
{0x7246,{0x57,0x34,0x7f,0x76,0x5b,0x76,0x7a}}, // \xe7\x89\x86
{0x7247,{0x40,0x3f,0x14,0x14,0x17,0x74,0x04}}, // \xe7\x89\x87
{0x7248,{0x7f,0x14,0x77,0x20,0x5f,0x25,0x5d}}, // \xe7\x89\x88
{0x724b,{0x7f,0x14,0x77,0x12,0x5b,0x36,0x5b}}, // \xe7\x89\x8b
{0x724c,{0x7f,0x14,0x77,0x2e,0x3f,0x7a,0x2e}}, // \xe7\x89\x8c
{0x7252,{0x7f,0x14,0x77,0x3e,0x73,0x36,0x57}}, // \xe7\x89\x92
{0x7258,{0x7f,0x14,0x77,0x4e,0x3e,0x3b,0x4e}}, // \xe7\x89\x98
{0x7259,{0x28,0x2f,0x19,0x49,0x7f,0x09,0x08}}, // \xe7\x89\x99
{0x725b,{0x14,0x13,0x12,0x7f,0x12,0x12,0x10}}, // \xe7\x89\x9b
{0x725d,{0x14,0x13,0x7f,0x0a,0x7f,0x48,0x64}}, // \xe7\x89\x9d
{0x725f,{0x24,0x34,0x2e,0x7d,0x2c,0x2a,0x24}}, // \xe7\x89\x9f
{0x7261,{0x14,0x13,0x7f,0x0a,0x44,0x7f,0x44}}, // \xe7\x89\xa1
{0x7262,{0x36,0x2e,0x2a,0x7f,0x2a,0x2a,0x26}}, // \xe7\x89\xa2
{0x7267,{0x17,0x7f,0x44,0x5f,0x22,0x5e,0x42}}, // \xe7\x89\xa7
{0x7269,{0x17,0x7f,0x24,0x53,0x2e,0x5e,0x7e}}, // \xe7\x89\xa9
{0x7272,{0x17,0x7f,0x44,0x53,0x7f,0x52,0x42}}, // \xe7\x89\xb2
{0x7274,{0x17,0x7f,0x12,0x7e,0x4a,0x5e,0x69}}, // \xe7\x89\xb4
{0x7279,{0x17,0x7f,0x28,0x6a,0x2f,0x7a,0x28}}, // \xe7\x89\xb9
{0x727d,{0x1a,0x2e,0x3e,0x7b,0x3a,0x2e,0x1a}}, // \xe7\x89\xbd
{0x727e,{0x17,0x7f,0x14,0x7d,0x57,0x7d,0x10}}, // \xe7\x89\xbe
{0x7280,{0x40,0x3f,0x2b,0x3b,0x33,0x7f,0x2b}}, // \xe7\x8a\x80
{0x7281,{0x2a,0x27,0x3f,0x7a,0x37,0x30,0x2f}}, // \xe7\x8a\x81
{0x7282,{0x2a,0x27,0x3f,0x76,0x3b,0x36,0x2e}}, // \xe7\x8a\x82
{0x7287,{0x24,0x3f,0x76,0x27,0x3e,0x76,0x24}}, // \xe7\x8a\x87
{0x7292,{0x17,0x7f,0x72,0x1e,0x5b,0x1e,0x72}}, // \xe7\x8a\x92
{0x7296,{0x2d,0x26,0x3d,0x7c,0x35,0x36,0x2d}}, // \xe7\x8a\x96
{0x72a0,{0x17,0x7f,0x2a,0x7b,0x2e,0x3b,0x5a}}, // \xe7\x8a\xa0
{0x72a2,{0x17,0x7f,0x4e,0x3e,0x3b,0x3e,0x4e}}, // \xe7\x8a\xa2
{0x72a7,{0x17,0x7f,0x0a,0x5b,0x6e,0x3b,0x5a}}, // \xe7\x8a\xa7
{0x72ac,{0x44,0x44,0x24,0x1f,0x24,0x45,0x44}}, // \xe7\x8a\xac
{0x72af,{0x55,0x4a,0x3d,0x7f,0x41,0x49,0x6f}}, // \xe7\x8a\xaf
{0x72b2,{0x55,0x4a,0x3d,0x22,0x52,0x7f,0x0a}}, // \xe7\x8a\xb2
{0x72b6,{0x14,0x7f,0x44,0x24,0x1f,0x24,0x45}}, // \xe7\x8a\xb6
{0x72b9,{0x55,0x4a,0x3d,0x42,0x3f,0x7a,0x43}}, // \xe7\x8a\xb9
{0x72c2,{0x55,0x4a,0x3d,0x40,0x49,0x7f,0x49}}, // \xe7\x8b\x82
{0x72c3,{0x55,0x3e,0x49,0x7f,0x49,0x7f,0x48}}, // \xe7\x8b\x83
{0x72c4,{0x55,0x4a,0x3d,0x4c,0x40,0x3f,0x44}}, // \xe7\x8b\x84
{0x72c6,{0x55,0x4a,0x3d,0x1e,0x12,0x7f,0x1e}}, // \xe7\x8b\x86
{0x72ce,{0x55,0x3e,0x1f,0x15,0x7f,0x15,0x1f}}, // \xe7\x8b\x8e
{0x72d0,{0x55,0x3e,0x41,0x3e,0x42,0x3e,0x61}}, // \xe7\x8b\x90
{0x72d2,{0x55,0x3e,0x5a,0x3f,0x16,0x7f,0x36}}, // \xe7\x8b\x92
{0x72d7,{0x55,0x4a,0x3d,0x04,0x1b,0x5a,0x7e}}, // \xe7\x8b\x97
{0x72d9,{0x55,0x3e,0x41,0x7f,0x55,0x7f,0x40}}, // \xe7\x8b\x99
{0x72db,{0x55,0x3e,0x01,0x7e,0x4b,0x4a,0x7e}}, // \xe7\x8b\x9b
{0x72e0,{0x55,0x3e,0x01,0x7f,0x55,0x35,0x5f}}, // \xe7\x8b\xa0
{0x72e1,{0x55,0x3e,0x4a,0x56,0x23,0x56,0x4a}}, // \xe7\x8b\xa1
{0x72e2,{0x55,0x3e,0x11,0x6a,0x65,0x6b,0x10}}, // \xe7\x8b\xa2
{0x72e9,{0x55,0x3e,0x11,0x36,0x53,0x7a,0x16}}, // \xe7\x8b\xa9
{0x72ec,{0x55,0x4a,0x3d,0x4e,0x7f,0x4a,0x6e}}, // \xe7\x8b\xac
{0x72ed,{0x55,0x3e,0x5b,0x52,0x3f,0x52,0x5a}}, // \xe7\x8b\xad
{0x72f7,{0x55,0x4a,0x3d,0x78,0x2b,0x2b,0x78}}, // \xe7\x8b\xb7
{0x72f8,{0x55,0x3e,0x5f,0x55,0x7f,0x55,0x5f}}, // \xe7\x8b\xb8
{0x72f9,{0x55,0x3e,0x52,0x4e,0x3f,0x4e,0x52}}, // \xe7\x8b\xb9
{0x72fc,{0x55,0x3e,0x01,0x7e,0x5a,0x3b,0x5e}}, // \xe7\x8b\xbc
{0x72fd,{0x55,0x4a,0x3d,0x5f,0x15,0x15,0x5f}}, // \xe7\x8b\xbd
{0x730a,{0x55,0x3e,0x5e,0x35,0x10,0x75,0x5f}}, // \xe7\x8c\x8a
{0x7316,{0x55,0x4a,0x3d,0x7c,0x57,0x57,0x7c}}, // \xe7\x8c\x96
{0x7317,{0x55,0x3e,0x12,0x5a,0x17,0x7a,0x12}}, // \xe7\x8c\x97
{0x731b,{0x55,0x3e,0x45,0x74,0x7d,0x77,0x44}}, // \xe7\x8c\x9b
{0x731c,{0x55,0x3e,0x09,0x7a,0x3f,0x7a,0x08}}, // \xe7\x8c\x9c
{0x731d,{0x55,0x3e,0x32,0x2e,0x73,0x2e,0x32}}, // \xe7\x8c\x9d
{0x731f,{0x55,0x4a,0x3d,0x14,0x7d,0x16,0x7d}}, // \xe7\x8c\x9f
{0x7325,{0x55,0x4a,0x3d,0x77,0x55,0x37,0x57}}, // \xe7\x8c\xa5
{0x7329,{0x55,0x4a,0x3d,0x48,0x57,0x7d,0x57}}, // \xe7\x8c\xa9
{0x732a,{0x55,0x3e,0x29,0x1a,0x6f,0x6a,0x69}}, // \xe7\x8c\xaa
{0x732b,{0x55,0x3e,0x7a,0x5f,0x7a,0x5f,0x7a}}, // \xe7\x8c\xab
{0x732e,{0x7a,0x3a,0x6f,0x7a,0x44,0x3f,0x45}}, // \xe7\x8c\xae
{0x732f,{0x55,0x3e,0x6b,0x3a,0x6b,0x2a,0x6b}}, // \xe7\x8c\xaf
{0x7334,{0x55,0x3e,0x7f,0x54,0x5d,0x37,0x54}}, // \xe7\x8c\xb4
{0x7336,{0x55,0x3e,0x7a,0x5f,0x4a,0x5f,0x7a}}, // \xe7\x8c\xb6
{0x7337,{0x7a,0x5f,0x4e,0x7b,0x44,0x3f,0x45}}, // \xe7\x8c\xb7
{0x733e,{0x55,0x3e,0x0c,0x77,0x35,0x77,0x0c}}, // \xe7\x8c\xbe
{0x733f,{0x55,0x4a,0x3d,0x7e,0x57,0x36,0x5c}}, // \xe7\x8c\xbf
{0x7344,{0x55,0x4a,0x3d,0x6b,0x6a,0x3f,0x45}}, // \xe7\x8d\x84
{0x7345,{0x55,0x4a,0x3f,0x36,0x1d,0x7f,0x1d}}, // \xe7\x8d\x85
{0x734e,{0x5b,0x56,0x5f,0x34,0x56,0x5d,0x57}}, // \xe7\x8d\x8e
{0x734f,{0x55,0x3e,0x52,0x5f,0x36,0x5f,0x52}}, // \xe7\x8d\x8f
{0x7357,{0x55,0x3e,0x5b,0x35,0x4b,0x3d,0x4d}}, // \xe7\x8d\x97
{0x7363,{0x11,0x77,0x56,0x77,0x44,0x3f,0x45}}, // \xe7\x8d\xa3
{0x7368,{0x55,0x3e,0x4b,0x75,0x77,0x25,0x7f}}, // \xe7\x8d\xa8
{0x736a,{0x55,0x3e,0x1d,0x76,0x5d,0x76,0x1c}}, // \xe7\x8d\xaa
{0x7370,{0x55,0x3e,0x17,0x5e,0x7f,0x1a,0x16}}, // \xe7\x8d\xb0
{0x7372,{0x55,0x3e,0x42,0x5f,0x2e,0x5f,0x4a}}, // \xe7\x8d\xb2
{0x7375,{0x55,0x3e,0x41,0x3e,0x75,0x2e,0x7d}}, // \xe7\x8d\xb5
{0x7378,{0x13,0x7f,0x5f,0x7f,0x44,0x3f,0x45}}, // \xe7\x8d\xb8
{0x737a,{0x55,0x3e,0x2e,0x7f,0x5a,0x19,0x5b}}, // \xe7\x8d\xba
{0x737b,{0x7c,0x74,0x3f,0x6a,0x44,0x3f,0x45}}, // \xe7\x8d\xbb
{0x7384,{0x42,0x4a,0x6e,0x53,0x4a,0x22,0x42}}, // \xe7\x8e\x84
{0x7387,{0x22,0x36,0x2a,0x77,0x22,0x36,0x22}}, // \xe7\x8e\x87
{0x7389,{0x41,0x49,0x49,0x7f,0x49,0x69,0x41}}, // \xe7\x8e\x89
{0x738b,{0x41,0x49,0x49,0x7f,0x49,0x49,0x41}}, // \xe7\x8e\x8b
{0x7396,{0x29,0x3f,0x29,0x44,0x23,0x1a,0x66}}, // \xe7\x8e\x96
{0x73a9,{0x29,0x3f,0x44,0x3d,0x05,0x7d,0x44}}, // \xe7\x8e\xa9
{0x73b2,{0x29,0x3f,0x15,0x12,0x75,0x16,0x34}}, // \xe7\x8e\xb2
{0x73b3,{0x29,0x3f,0x7e,0x01,0x04,0x3f,0x45}}, // \xe7\x8e\xb3
{0x73bb,{0x29,0x3f,0x7e,0x5a,0x2f,0x5a,0x46}}, // \xe7\x8e\xbb
{0x73c0,{0x29,0x3f,0x15,0x7e,0x4b,0x4a,0x7e}}, // \xe7\x8f\x80
{0x73c2,{0x29,0x3f,0x29,0x1d,0x15,0x5d,0x7f}}, // \xe7\x8f\x82
{0x73c8,{0x29,0x3f,0x62,0x1f,0x7e,0x42,0x7e}}, // \xe7\x8f\x88
{0x73ca,{0x29,0x3f,0x08,0x7f,0x3f,0x09,0x7f}}, // \xe7\x8f\x8a
{0x73cd,{0x29,0x3f,0x15,0x42,0x55,0x2a,0x14}}, // \xe7\x8f\x8d
{0x73ce,{0x29,0x3f,0x24,0x5b,0x7e,0x0a,0x32}}, // \xe7\x8f\x8e
{0x73de,{0x29,0x3f,0x11,0x6a,0x65,0x6b,0x10}}, // \xe7\x8f\x9e
{0x73e0,{0x29,0x3f,0x4c,0x2b,0x7f,0x2a,0x48}}, // \xe7\x8f\xa0
{0x73e5,{0x29,0x3f,0x21,0x3f,0x2d,0x7f,0x21}}, // \xe7\x8f\xa5
{0x73ea,{0x29,0x3f,0x49,0x5a,0x7f,0x5a,0x48}}, // \xe7\x8f\xaa
{0x73ed,{0x29,0x3f,0x4d,0x20,0x5e,0x7f,0x49}}, // \xe7\x8f\xad
{0x73ee,{0x29,0x3f,0x7f,0x35,0x7d,0x35,0x7f}}, // \xe7\x8f\xae
{0x73f1,{0x29,0x3f,0x49,0x58,0x2d,0x3a,0x49}}, // \xe7\x8f\xb1
{0x73f8,{0x29,0x3f,0x14,0x7d,0x57,0x7d,0x10}}, // \xe7\x8f\xb8
{0x73fe,{0x29,0x3f,0x29,0x5f,0x35,0x75,0x5f}}, // \xe7\x8f\xbe
{0x7403,{0x29,0x3f,0x2a,0x52,0x7f,0x12,0x2b}}, // \xe7\x90\x83
{0x7405,{0x29,0x3f,0x15,0x7e,0x5a,0x3b,0x5e}}, // \xe7\x90\x85
{0x7406,{0x29,0x3f,0x5f,0x55,0x7f,0x55,0x5f}}, // \xe7\x90\x86
{0x7409,{0x29,0x3f,0x4a,0x3e,0x7b,0x06,0x6a}}, // \xe7\x90\x89
{0x7422,{0x29,0x3f,0x29,0x57,0x7d,0x19,0x25}}, // \xe7\x90\xa2
{0x7425,{0x29,0x3f,0x29,0x5c,0x24,0x6f,0x4a}}, // \xe7\x90\xa5
{0x7432,{0x29,0x3f,0x2a,0x7f,0x00,0x7f,0x2a}}, // \xe7\x90\xb2
{0x7433,{0x29,0x3f,0x1a,0x7f,0x1a,0x7f,0x12}}, // \xe7\x90\xb3
{0x7434,{0x15,0x17,0x2d,0x28,0x6d,0x17,0x15}}, // \xe7\x90\xb4
{0x7435,{0x45,0x7f,0x55,0x00,0x7d,0x57,0x55}}, // \xe7\x90\xb5
{0x7436,{0x05,0x3f,0x55,0x5c,0x55,0x5f,0x65}}, // \xe7\x90\xb6
{0x743a,{0x29,0x3f,0x75,0x00,0x6a,0x5f,0x4a}}, // \xe7\x90\xba
{0x743f,{0x29,0x3f,0x27,0x3d,0x7f,0x3d,0x27}}, // \xe7\x90\xbf
{0x7441,{0x29,0x3f,0x07,0x79,0x55,0x7d,0x07}}, // \xe7\x91\x81
{0x7455,{0x29,0x3f,0x7f,0x2b,0x58,0x2d,0x5f}}, // \xe7\x91\x95
{0x7459,{0x29,0x3f,0x15,0x7a,0x6d,0x5a,0x7d}}, // \xe7\x91\x99
{0x745a,{0x29,0x3f,0x3a,0x2f,0x7a,0x3f,0x7f}}, // \xe7\x91\x9a
{0x745b,{0x29,0x3f,0x5a,0x57,0x3a,0x57,0x5a}}, // \xe7\x91\x9b
{0x745c,{0x29,0x3f,0x04,0x73,0x75,0x26,0x54}}, // \xe7\x91\x9c
{0x745e,{0x29,0x3f,0x6b,0x3a,0x6b,0x2a,0x6b}}, // \xe7\x91\x9e
{0x745f,{0x55,0x47,0x3d,0x50,0x4d,0x47,0x55}}, // \xe7\x91\x9f
{0x7460,{0x29,0x3f,0x0e,0x7a,0x79,0x77,0x0f}}, // \xe7\x91\xa0
{0x7463,{0x29,0x3f,0x42,0x3d,0x36,0x3d,0x42}}, // \xe7\x91\xa3
{0x7464,{0x29,0x3f,0x11,0x6a,0x4d,0x7b,0x68}}, // \xe7\x91\xa4
{0x7469,{0x4d,0x56,0x55,0x7c,0x55,0x76,0x4d}}, // \xe7\x91\xa9
{0x746a,{0x29,0x3f,0x5f,0x15,0x5f,0x15,0x71}}, // \xe7\x91\xaa
{0x746f,{0x29,0x3f,0x7e,0x4b,0x2e,0x7f,0x1b}}, // \xe7\x91\xaf
{0x7470,{0x29,0x3f,0x5e,0x2b,0x7e,0x6a,0x5e}}, // \xe7\x91\xb0
{0x7473,{0x29,0x3f,0x4a,0x3b,0x5e,0x7b,0x5a}}, // \xe7\x91\xb3
{0x7476,{0x29,0x3f,0x69,0x4a,0x7e,0x49,0x6b}}, // \xe7\x91\xb6
{0x747e,{0x29,0x3f,0x5a,0x5f,0x7a,0x5f,0x5a}}, // \xe7\x91\xbe
{0x7483,{0x29,0x3f,0x72,0x5e,0x7b,0x3e,0x72}}, // \xe7\x92\x83
{0x748b,{0x29,0x3f,0x2a,0x3e,0x7b,0x3e,0x2a}}, // \xe7\x92\x8b
{0x749e,{0x29,0x3f,0x4b,0x5e,0x3b,0x5e,0x4b}}, // \xe7\x92\x9e
{0x74a2,{0x29,0x3f,0x7d,0x5f,0x71,0x5f,0x7d}}, // \xe7\x92\xa2
{0x74a7,{0x54,0x5f,0x7b,0x70,0x76,0x7b,0x56}}, // \xe7\x92\xa7
{0x74b0,{0x29,0x3f,0x47,0x3d,0x6f,0x3d,0x47}}, // \xe7\x92\xb0
{0x74bd,{0x5d,0x77,0x6d,0x7f,0x75,0x6f,0x5d}}, // \xe7\x92\xbd
{0x74ca,{0x29,0x3f,0x29,0x52,0x5d,0x2f,0x5e}}, // \xe7\x93\x8a
{0x74cf,{0x29,0x3f,0x7e,0x2b,0x7e,0x77,0x5d}}, // \xe7\x93\x8f
{0x74d4,{0x29,0x3f,0x57,0x7b,0x54,0x33,0x57}}, // \xe7\x93\x94
{0x74dc,{0x40,0x3e,0x42,0x7e,0x41,0x3d,0x40}}, // \xe7\x93\x9c
{0x74e0,{0x0a,0x57,0x6a,0x3e,0x62,0x1e,0x61}}, // \xe7\x93\xa0
{0x74e2,{0x51,0x17,0x77,0x3f,0x42,0x3e,0x61}}, // \xe7\x93\xa2
{0x74e3,{0x56,0x3b,0x7e,0x7f,0x16,0x7b,0x16}}, // \xe7\x93\xa3
{0x74e6,{0x41,0x71,0x4f,0x15,0x7d,0x41,0x61}}, // \xe7\x93\xa6
{0x74e7,{0x41,0x7f,0x3d,0x41,0x44,0x7f,0x44}}, // \xe7\x93\xa7
{0x74e9,{0x41,0x7f,0x3d,0x41,0x4a,0x7e,0x49}}, // \xe7\x93\xa9
{0x74ee,{0x4a,0x4a,0x7d,0x58,0x19,0x7a,0x4a}}, // \xe7\x93\xae
{0x74f0,{0x41,0x7f,0x3d,0x41,0x6a,0x59,0x7a}}, // \xe7\x93\xb0
{0x74f1,{0x41,0x7f,0x3d,0x41,0x4a,0x7e,0x65}}, // \xe7\x93\xb1
{0x74f2,{0x41,0x3f,0x7d,0x5a,0x52,0x7f,0x6a}}, // \xe7\x93\xb2
{0x74f6,{0x55,0x3e,0x7d,0x7f,0x55,0x3d,0x41}}, // \xe7\x93\xb6
{0x74f7,{0x59,0x50,0x74,0x5b,0x16,0x7a,0x56}}, // \xe7\x93\xb7
{0x74f8,{0x41,0x7f,0x3d,0x40,0x7d,0x6b,0x7d}}, // \xe7\x93\xb8
{0x7503,{0x5a,0x56,0x7e,0x55,0x1a,0x77,0x5a}}, // \xe7\x94\x83
{0x7504,{0x5d,0x7f,0x5d,0x41,0x7f,0x3d,0x41}}, // \xe7\x94\x84
{0x7505,{0x41,0x7f,0x3d,0x50,0x6f,0x7d,0x6d}}, // \xe7\x94\x85
{0x750c,{0x7f,0x71,0x47,0x77,0x7f,0x3d,0x41}}, // \xe7\x94\x8c
{0x750d,{0x5a,0x4e,0x7b,0x5e,0x1b,0x7e,0x5a}}, // \xe7\x94\x8d
{0x750e,{0x52,0x1f,0x7e,0x41,0x7f,0x3d,0x41}}, // \xe7\x94\x8e
{0x7511,{0x6d,0x6c,0x4d,0x7f,0x55,0x3d,0x41}}, // \xe7\x94\x91
{0x7513,{0x54,0x5f,0x7b,0x50,0x16,0x7b,0x56}}, // \xe7\x94\x93
{0x7515,{0x5a,0x56,0x72,0x5f,0x1e,0x7e,0x5a}}, // \xe7\x94\x95
{0x7518,{0x02,0x7f,0x4a,0x4a,0x4a,0x7f,0x02}}, // \xe7\x94\x98
{0x751a,{0x12,0x72,0x5f,0x7a,0x5f,0x72,0x52}}, // \xe7\x94\x9a
{0x751c,{0x76,0x5e,0x75,0x02,0x7f,0x4a,0x7f}}, // \xe7\x94\x9c
{0x751e,{0x16,0x7b,0x56,0x57,0x56,0x7b,0x16}}, // \xe7\x94\x9e
{0x751f,{0x44,0x53,0x52,0x7f,0x52,0x52,0x42}}, // \xe7\x94\x9f
{0x7523,{0x42,0x3a,0x4e,0x5b,0x7a,0x5e,0x4a}}, // \xe7\x94\xa3
{0x7525,{0x2b,0x3f,0x2a,0x5f,0x35,0x5f,0x7f}}, // \xe7\x94\xa5
{0x7526,{0x5d,0x3f,0x4d,0x64,0x6b,0x7f,0x6a}}, // \xe7\x94\xa6
{0x7528,{0x40,0x3f,0x15,0x7f,0x15,0x55,0x7f}}, // \xe7\x94\xa8
{0x752b,{0x02,0x7a,0x2a,0x7f,0x2a,0x7b,0x02}}, // \xe7\x94\xab
{0x752c,{0x00,0x7d,0x15,0x7d,0x15,0x57,0x7d}}, // \xe7\x94\xac
{0x7530,{0x7f,0x49,0x49,0x7f,0x49,0x49,0x7f}}, // \xe7\x94\xb0
{0x7531,{0x7e,0x4a,0x4a,0x7f,0x4a,0x4a,0x7e}}, // \xe7\x94\xb1
{0x7532,{0x1f,0x15,0x15,0x7f,0x15,0x15,0x1f}}, // \xe7\x94\xb2
{0x7533,{0x3e,0x2a,0x2a,0x7f,0x2a,0x2a,0x3e}}, // \xe7\x94\xb3
{0x7537,{0x50,0x5f,0x35,0x1f,0x15,0x5f,0x70}}, // \xe7\x94\xb7
{0x7538,{0x04,0x3f,0x2a,0x3e,0x2a,0x3e,0x7e}}, // \xe7\x94\xb8
{0x753a,{0x3f,0x25,0x3f,0x3f,0x42,0x7e,0x02}}, // \xe7\x94\xba
{0x753b,{0x7d,0x41,0x5d,0x5f,0x5d,0x41,0x7d}}, // \xe7\x94\xbb
{0x753c,{0x10,0x1f,0x55,0x7f,0x15,0x1f,0x10}}, // \xe7\x94\xbc
{0x7544,{0x00,0x7d,0x54,0x7d,0x54,0x56,0x7d}}, // \xe7\x95\x84
{0x7546,{0x7a,0x7b,0x7a,0x40,0x70,0x4f,0x60}}, // \xe7\x95\x86
{0x7549,{0x3e,0x3e,0x3e,0x48,0x4a,0x3f,0x4a}}, // \xe7\x95\x89
{0x754a,{0x3e,0x3e,0x3e,0x52,0x3f,0x12,0x7f}}, // \xe7\x95\x8a
{0x754b,{0x3e,0x3e,0x3e,0x44,0x5f,0x22,0x5e}}, // \xe7\x95\x8b
{0x754c,{0x20,0x5f,0x35,0x1f,0x75,0x1f,0x20}}, // \xe7\x95\x8c
{0x754d,{0x3e,0x3e,0x3e,0x44,0x3a,0x01,0x7a}}, // \xe7\x95\x8d
{0x754f,{0x50,0x7f,0x55,0x1f,0x35,0x5f,0x50}}, // \xe7\x95\x8f
{0x7551,{0x4c,0x3f,0x24,0x7f,0x49,0x7f,0x7f}}, // \xe7\x95\x91
{0x7554,{0x3e,0x3e,0x3e,0x2a,0x28,0x7f,0x2a}}, // \xe7\x95\x94
{0x7559,{0x0e,0x7a,0x59,0x74,0x59,0x77,0x0f}}, // \xe7\x95\x99
{0x755a,{0x14,0x0e,0x77,0x76,0x55,0x7e,0x14}}, // \xe7\x95\x9a
{0x755b,{0x3e,0x3e,0x3e,0x42,0x55,0x2a,0x14}}, // \xe7\x95\x9b
{0x755c,{0x12,0x76,0x56,0x7b,0x52,0x72,0x1a}}, // \xe7\x95\x9c
{0x755d,{0x7a,0x7b,0x7a,0x44,0x23,0x1a,0x66}}, // \xe7\x95\x9d
{0x7560,{0x70,0x5e,0x5a,0x7b,0x5a,0x5e,0x70}}, // \xe7\x95\xa0
{0x7562,{0x28,0x3f,0x2d,0x7f,0x2d,0x3f,0x28}}, // \xe7\x95\xa2
{0x7564,{0x3e,0x3e,0x3e,0x6a,0x2f,0x7a,0x28}}, // \xe7\x95\xa4
{0x7565,{0x3e,0x3e,0x3e,0x10,0x6a,0x65,0x6b}}, // \xe7\x95\xa5
{0x7566,{0x3e,0x3e,0x3e,0x48,0x5a,0x7f,0x5a}}, // \xe7\x95\xa6
{0x7567,{0x20,0x27,0x6d,0x57,0x6d,0x27,0x20}}, // \xe7\x95\xa7
{0x7569,{0x3e,0x3e,0x3e,0x7a,0x4f,0x32,0x4a}}, // \xe7\x95\xa9
{0x756a,{0x15,0x77,0x6d,0x7f,0x6d,0x77,0x15}}, // \xe7\x95\xaa
{0x756b,{0x50,0x7a,0x5a,0x7f,0x5a,0x7e,0x54}}, // \xe7\x95\xab
{0x756d,{0x3e,0x3e,0x3e,0x54,0x16,0x7d,0x56}}, // \xe7\x95\xad
{0x7570,{0x50,0x57,0x1d,0x17,0x1d,0x57,0x50}}, // \xe7\x95\xb0
{0x7573,{0x58,0x4f,0x7d,0x5f,0x7d,0x4f,0x58}}, // \xe7\x95\xb3
{0x7574,{0x3e,0x3e,0x3e,0x5e,0x17,0x7e,0x14}}, // \xe7\x95\xb4
{0x7576,{0x06,0x73,0x5e,0x7b,0x5e,0x73,0x06}}, // \xe7\x95\xb6
{0x7577,{0x3e,0x3e,0x5d,0x2b,0x5d,0x2b,0x5d}}, // \xe7\x95\xb7
{0x7578,{0x3e,0x3e,0x3e,0x12,0x5a,0x17,0x7a}}, // \xe7\x95\xb8
{0x757f,{0x6a,0x6d,0x68,0x0f,0x5a,0x2d,0x50}}, // \xe7\x95\xbf
{0x7582,{0x5a,0x4c,0x7b,0x5b,0x7b,0x4c,0x5a}}, // \xe7\x96\x82
{0x7586,{0x51,0x7d,0x37,0x49,0x7f,0x7f,0x49}}, // \xe7\x96\x86
{0x7587,{0x3e,0x3e,0x3e,0x36,0x5f,0x76,0x14}}, // \xe7\x96\x87
{0x7589,{0x5c,0x6c,0x5f,0x6b,0x5f,0x4c,0x5c}}, // \xe7\x96\x89
{0x758a,{0x5c,0x4c,0x7f,0x5b,0x7f,0x4c,0x5c}}, // \xe7\x96\x8a
{0x758b,{0x41,0x39,0x41,0x7f,0x49,0x49,0x43}}, // \xe7\x96\x8b
{0x758e,{0x71,0x7d,0x4b,0x2e,0x7f,0x2a,0x4e}}, // \xe7\x96\x8e
{0x758f,{0x71,0x7d,0x4b,0x3e,0x7b,0x06,0x6a}}, // \xe7\x96\x8f
{0x7591,{0x57,0x3a,0x5a,0x65,0x3d,0x57,0x4d}}, // \xe7\x96\x91
{0x7594,{0x54,0x3e,0x0a,0x4a,0x7b,0x0a,0x0a}}, // \xe7\x96\x94
{0x759a,{0x54,0x3e,0x42,0x4a,0x27,0x5e,0x42}}, // \xe7\x96\x9a
{0x759d,{0x54,0x3e,0x72,0x42,0x7b,0x42,0x72}}, // \xe7\x96\x9d
{0x75a3,{0x54,0x3e,0x4a,0x4a,0x3f,0x7a,0x4a}}, // \xe7\x96\xa3
{0x75a5,{0x54,0x3e,0x52,0x3a,0x07,0x7a,0x12}}, // \xe7\x96\xa5
{0x75ab,{0x54,0x3e,0x52,0x4e,0x37,0x7e,0x52}}, // \xe7\x96\xab
{0x75b1,{0x54,0x3e,0x12,0x0e,0x7b,0x5a,0x5a}}, // \xe7\x96\xb1
{0x75b2,{0x54,0x3e,0x42,0x3a,0x5b,0x2e,0x5a}}, // \xe7\x96\xb2
{0x75b3,{0x54,0x3e,0x0a,0x7e,0x4b,0x7e,0x0a}}, // \xe7\x96\xb3
{0x75b5,{0x54,0x3e,0x72,0x7e,0x2b,0x7e,0x4a}}, // \xe7\x96\xb5
{0x75b8,{0x54,0x3e,0x42,0x5e,0x57,0x5e,0x42}}, // \xe7\x96\xb8
{0x75b9,{0x54,0x3e,0x12,0x4a,0x57,0x2a,0x12}}, // \xe7\x96\xb9
{0x75bc,{0x54,0x3e,0x22,0x2a,0x57,0x1e,0x22}}, // \xe7\x96\xbc
{0x75bd,{0x54,0x3e,0x42,0x7e,0x57,0x7e,0x42}}, // \xe7\x96\xbd
{0x75be,{0x54,0x3e,0x52,0x5e,0x3b,0x5a,0x52}}, // \xe7\x96\xbe
{0x75c2,{0x54,0x3e,0x4a,0x3e,0x7b,0x4a,0x7a}}, // \xe7\x97\x82
{0x75c3,{0x54,0x3e,0x4a,0x5a,0x6f,0x4a,0x6a}}, // \xe7\x97\x83
{0x75c5,{0x54,0x3e,0x7a,0x2e,0x1f,0x2e,0x7a}}, // \xe7\x97\x85
{0x75c7,{0x54,0x3e,0x42,0x76,0x47,0x7e,0x56}}, // \xe7\x97\x87
{0x75ca,{0x54,0x3e,0x52,0x5a,0x77,0x5a,0x52}}, // \xe7\x97\x8a
{0x75cd,{0x54,0x3e,0x46,0x5e,0x3f,0x56,0x72}}, // \xe7\x97\x8d
{0x75d2,{0x54,0x3e,0x2a,0x2e,0x7b,0x2e,0x2a}}, // \xe7\x97\x92
{0x75d4,{0x54,0x3e,0x12,0x36,0x5f,0x76,0x12}}, // \xe7\x97\x94
{0x75d5,{0x54,0x3e,0x02,0x7e,0x57,0x3e,0x42}}, // \xe7\x97\x95
{0x75d8,{0x54,0x3e,0x02,0x5a,0x6b,0x6a,0x5a}}, // \xe7\x97\x98
{0x75d9,{0x54,0x3e,0x52,0x5a,0x77,0x5a,0x56}}, // \xe7\x97\x99
{0x75db,{0x54,0x3e,0x7a,0x2a,0x7b,0x2e,0x7a}}, // \xe7\x97\x9b
{0x75de,{0x54,0x3e,0x22,0x16,0x6f,0x7e,0x16}}, // \xe7\x97\x9e
{0x75e2,{0x54,0x3e,0x2a,0x7a,0x27,0x5a,0x7a}}, // \xe7\x97\xa2
{0x75e3,{0x54,0x3e,0x62,0x36,0x5f,0x56,0x62}}, // \xe7\x97\xa3
{0x75e9,{0x54,0x3e,0x4a,0x5e,0x2f,0x5e,0x4a}}, // \xe7\x97\xa9
{0x75f0,{0x54,0x3e,0x56,0x52,0x2f,0x52,0x56}}, // \xe7\x97\xb0
{0x75f2,{0x54,0x3e,0x3a,0x7e,0x3b,0x7e,0x3a}}, // \xe7\x97\xb2
{0x75f3,{0x54,0x3e,0x2a,0x7e,0x2b,0x7e,0x2a}}, // \xe7\x97\xb3
{0x75f4,{0x54,0x3e,0x52,0x3e,0x4b,0x3a,0x3a}}, // \xe7\x97\xb4
{0x75fa,{0x54,0x3e,0x02,0x2e,0x3f,0x7a,0x2e}}, // \xe7\x97\xba
{0x75fc,{0x54,0x3e,0x7e,0x6a,0x5f,0x6a,0x7e}}, // \xe7\x97\xbc
{0x75fe,{0x54,0x3e,0x7e,0x36,0x1b,0x5a,0x7e}}, // \xe7\x97\xbe
{0x75ff,{0x54,0x3e,0x5a,0x76,0x5f,0x36,0x5a}}, // \xe7\x97\xbf
{0x7601,{0x54,0x3e,0x36,0x2e,0x77,0x2e,0x36}}, // \xe7\x98\x81
{0x7609,{0x54,0x3e,0x12,0x7a,0x77,0x2a,0x52}}, // \xe7\x98\x89
{0x760b,{0x54,0x7e,0x3e,0x5a,0x7b,0x3e,0x42}}, // \xe7\x98\x8b
{0x760d,{0x54,0x3e,0x52,0x3e,0x5b,0x3e,0x72}}, // \xe7\x98\x8d
{0x761f,{0x54,0x3e,0x02,0x5e,0x7b,0x76,0x5e}}, // \xe7\x98\x9f
{0x7620,{0x54,0x3e,0x16,0x76,0x2b,0x76,0x16}}, // \xe7\x98\xa0
{0x7621,{0x54,0x3e,0x52,0x3a,0x77,0x6a,0x12}}, // \xe7\x98\xa1
{0x7622,{0x54,0x3e,0x7a,0x7e,0x5b,0x2a,0x5a}}, // \xe7\x98\xa2
{0x7624,{0x54,0x3e,0x1a,0x76,0x73,0x6e,0x1e}}, // \xe7\x98\xa4
{0x7627,{0x54,0x3e,0x42,0x3a,0x2f,0x76,0x52}}, // \xe7\x98\xa7
{0x7630,{0x54,0x3e,0x52,0x1e,0x7f,0x1e,0x52}}, // \xe7\x98\xb0
{0x7634,{0x54,0x3e,0x2a,0x3e,0x7b,0x3e,0x2a}}, // \xe7\x98\xb4
{0x763b,{0x54,0x3e,0x5a,0x7e,0x5f,0x3e,0x5a}}, // \xe7\x98\xbb
{0x7642,{0x54,0x3e,0x4a,0x1e,0x6b,0x1e,0x4a}}, // \xe7\x99\x82
{0x7646,{0x54,0x3e,0x36,0x5a,0x37,0x7a,0x36}}, // \xe7\x99\x86
{0x7647,{0x54,0x3e,0x7e,0x46,0x33,0x76,0x7e}}, // \xe7\x99\x87
{0x7648,{0x54,0x3e,0x56,0x2e,0x5f,0x2a,0x56}}, // \xe7\x99\x88
{0x764c,{0x54,0x3e,0x7a,0x5e,0x67,0x5e,0x7a}}, // \xe7\x99\x8c
{0x7652,{0x54,0x3e,0x5a,0x3a,0x47,0x5a,0x6a}}, // \xe7\x99\x92
{0x7656,{0x54,0x3e,0x7e,0x6e,0x3b,0x6e,0x3a}}, // \xe7\x99\x96
{0x7658,{0x54,0x3e,0x6a,0x3e,0x7b,0x7e,0x6a}}, // \xe7\x99\x98
{0x765c,{0x54,0x3e,0x5e,0x16,0x5b,0x2a,0x5a}}, // \xe7\x99\x9c
{0x7661,{0x54,0x3e,0x5e,0x3a,0x5b,0x36,0x5e}}, // \xe7\x99\xa1
{0x7662,{0x54,0x3e,0x2a,0x7e,0x3b,0x5e,0x2a}}, // \xe7\x99\xa2
{0x7667,{0x54,0x3e,0x42,0x3e,0x4f,0x66,0x4e}}, // \xe7\x99\xa7
{0x7668,{0x54,0x3e,0x2a,0x76,0x7f,0x56,0x4a}}, // \xe7\x99\xa8
{0x7669,{0x54,0x3e,0x7e,0x2e,0x43,0x1a,0x5e}}, // \xe7\x99\xa9
{0x766a,{0x54,0x3e,0x36,0x7e,0x4b,0x1e,0x5a}}, // \xe7\x99\xaa
{0x766c,{0x54,0x3e,0x5a,0x5e,0x2b,0x72,0x2a}}, // \xe7\x99\xac
{0x7670,{0x54,0x3e,0x6a,0x76,0x4b,0x7e,0x56}}, // \xe7\x99\xb0
{0x7672,{0x54,0x3e,0x5e,0x1a,0x43,0x1e,0x5e}}, // \xe7\x99\xb2
{0x7676,{0x14,0x0a,0x06,0x02,0x04,0x0a,0x14}}, // \xe7\x99\xb6
{0x7678,{0x4a,0x55,0x5b,0x39,0x5a,0x55,0x4a}}, // \xe7\x99\xb8
{0x767a,{0x4a,0x55,0x3b,0x19,0x7a,0x55,0x4a}}, // \xe7\x99\xba
{0x767b,{0x4a,0x45,0x5b,0x69,0x5a,0x45,0x4a}}, // \xe7\x99\xbb
{0x767c,{0x0a,0x55,0x6b,0x01,0x5a,0x2d,0x5a}}, // \xe7\x99\xbc
{0x767d,{0x00,0x7e,0x4a,0x4b,0x4a,0x4a,0x7e}}, // \xe7\x99\xbd
{0x767e,{0x01,0x7d,0x55,0x57,0x55,0x7d,0x01}}, // \xe7\x99\xbe
{0x7680,{0x00,0x3e,0x5a,0x5b,0x4a,0x4e,0x60}}, // \xe7\x9a\x80
{0x7683,{0x40,0x5e,0x3a,0x1b,0x7a,0x5e,0x60}}, // \xe7\x9a\x83
{0x7684,{0x3e,0x2b,0x3e,0x04,0x0b,0x52,0x7e}}, // \xe7\x9a\x84
{0x7686,{0x08,0x6f,0x6a,0x70,0x6f,0x6a,0x0a}}, // \xe7\x9a\x86
{0x7687,{0x50,0x5e,0x5a,0x7b,0x5a,0x5e,0x50}}, // \xe7\x9a\x87
{0x7688,{0x3e,0x2b,0x3e,0x5f,0x5d,0x25,0x5d}}, // \xe7\x9a\x88
{0x768b,{0x28,0x1e,0x2a,0x7b,0x2a,0x1e,0x28}}, // \xe7\x9a\x8b
{0x768e,{0x3e,0x2b,0x3e,0x4a,0x56,0x23,0x56}}, // \xe7\x9a\x8e
{0x7690,{0x28,0x2e,0x26,0x7f,0x26,0x2e,0x28}}, // \xe7\x9a\x90
{0x7693,{0x3e,0x2b,0x3e,0x0c,0x6b,0x6f,0x6a}}, // \xe7\x9a\x93
{0x7696,{0x3e,0x2b,0x3e,0x56,0x32,0x77,0x56}}, // \xe7\x9a\x96
{0x7699,{0x0a,0x66,0x6f,0x7a,0x67,0x6d,0x05}}, // \xe7\x9a\x99
{0x769a,{0x3e,0x2b,0x3e,0x5b,0x6a,0x6b,0x5b}}, // \xe7\x9a\x9a
{0x76ae,{0x40,0x3e,0x4a,0x5a,0x2f,0x5a,0x46}}, // \xe7\x9a\xae
{0x76b0,{0x7e,0x2f,0x5a,0x04,0x7b,0x5a,0x5e}}, // \xe7\x9a\xb0
{0x76b4,{0x4a,0x27,0x52,0x37,0x7e,0x2f,0x5a}}, // \xe7\x9a\xb4
{0x76b7,{0x5a,0x77,0x2a,0x7e,0x5a,0x2f,0x5e}}, // \xe7\x9a\xb7
{0x76b8,{0x27,0x3d,0x7f,0x27,0x7e,0x2f,0x5a}}, // \xe7\x9a\xb8
{0x76b9,{0x7e,0x2f,0x5a,0x27,0x3d,0x7f,0x27}}, // \xe7\x9a\xb9
{0x76ba,{0x24,0x5b,0x36,0x7e,0x5a,0x2f,0x5e}}, // \xe7\x9a\xba
{0x76bf,{0x40,0x7e,0x42,0x7e,0x42,0x7e,0x40}}, // \xe7\x9a\xbf
{0x76c2,{0x44,0x75,0x5d,0x7f,0x55,0x75,0x44}}, // \xe7\x9b\x82
{0x76c3,{0x49,0x79,0x55,0x7f,0x51,0x75,0x49}}, // \xe7\x9b\x83
{0x76c6,{0x44,0x76,0x5d,0x74,0x5d,0x72,0x44}}, // \xe7\x9b\x86
{0x76c8,{0x49,0x75,0x5b,0x75,0x5b,0x72,0x4e}}, // \xe7\x9b\x88
{0x76ca,{0x4a,0x76,0x53,0x72,0x52,0x77,0x4a}}, // \xe7\x9b\x8a
{0x76cd,{0x54,0x76,0x7e,0x77,0x76,0x6e,0x54}}, // \xe7\x9b\x8d
{0x76d2,{0x44,0x74,0x5e,0x7d,0x5e,0x74,0x44}}, // \xe7\x9b\x92
{0x76d6,{0x4a,0x7a,0x5b,0x7e,0x5a,0x7b,0x4a}}, // \xe7\x9b\x96
{0x76d7,{0x49,0x70,0x54,0x7b,0x56,0x7a,0x46}}, // \xe7\x9b\x97
{0x76db,{0x48,0x76,0x5e,0x72,0x5a,0x77,0x4a}}, // \xe7\x9b\x9b
{0x76dc,{0x55,0x40,0x74,0x7b,0x56,0x7a,0x46}}, // \xe7\x9b\x9c
{0x76de,{0x4a,0x6a,0x76,0x77,0x6a,0x6b,0x54}}, // \xe7\x9b\x9e
{0x76df,{0x47,0x75,0x57,0x78,0x57,0x75,0x4f}}, // \xe7\x9b\x9f
{0x76e1,{0x50,0x6a,0x7a,0x6f,0x7a,0x6e,0x54}}, // \xe7\x9b\xa1
{0x76e3,{0x4f,0x7f,0x59,0x74,0x53,0x7a,0x4a}}, // \xe7\x9b\xa3
{0x76e4,{0x4c,0x77,0x5f,0x74,0x5b,0x75,0x4b}}, // \xe7\x9b\xa4
{0x76e5,{0x5e,0x75,0x6a,0x7f,0x6a,0x75,0x5f}}, // \xe7\x9b\xa5
{0x76e7,{0x40,0x3c,0x44,0x74,0x7f,0x7a,0x4a}}, // \xe7\x9b\xa7
{0x76ea,{0x55,0x60,0x74,0x6f,0x75,0x6f,0x5c}}, // \xe7\x9b\xaa
{0x76ee,{0x00,0x7f,0x55,0x55,0x55,0x55,0x7f}}, // \xe7\x9b\xae
{0x76f2,{0x02,0x7e,0x5a,0x5b,0x5a,0x7a,0x02}}, // \xe7\x9b\xb2
{0x76f4,{0x7a,0x42,0x7a,0x6f,0x6a,0x7a,0x42}}, // \xe7\x9b\xb4
{0x76f8,{0x22,0x1a,0x7f,0x0a,0x7f,0x55,0x7f}}, // \xe7\x9b\xb8
{0x76fb,{0x7f,0x55,0x7f,0x04,0x1e,0x55,0x76}}, // \xe7\x9b\xbb
{0x76fe,{0x40,0x3e,0x06,0x76,0x7e,0x75,0x05}}, // \xe7\x9b\xbe
{0x7701,{0x14,0x12,0x78,0x6f,0x68,0x7a,0x04}}, // \xe7\x9c\x81
{0x7704,{0x7f,0x55,0x7f,0x1c,0x11,0x5f,0x7d}}, // \xe7\x9c\x84
{0x7707,{0x7f,0x55,0x7f,0x46,0x5f,0x22,0x14}}, // \xe7\x9c\x87
{0x7708,{0x7f,0x55,0x7f,0x46,0x3f,0x72,0x46}}, // \xe7\x9c\x88
{0x7709,{0x40,0x3f,0x05,0x7d,0x57,0x55,0x7f}}, // \xe7\x9c\x89
{0x770b,{0x28,0x1a,0x7e,0x5e,0x5d,0x7d,0x08}}, // \xe7\x9c\x8b
{0x770c,{0x5e,0x10,0x1f,0x75,0x15,0x1f,0x50}}, // \xe7\x9c\x8c
{0x771b,{0x7f,0x55,0x7f,0x2a,0x7f,0x2a,0x48}}, // \xe7\x9c\x9b
{0x771e,{0x58,0x53,0x1e,0x1e,0x1e,0x52,0x50}}, // \xe7\x9c\x9e
{0x771f,{0x52,0x52,0x1e,0x1f,0x1e,0x52,0x52}}, // \xe7\x9c\x9f
{0x7720,{0x7f,0x55,0x7f,0x7f,0x55,0x3d,0x57}}, // \xe7\x9c\xa0
{0x7724,{0x7f,0x55,0x7f,0x3f,0x05,0x7d,0x57}}, // \xe7\x9c\xa4
{0x7725,{0x0e,0x78,0x7f,0x7a,0x70,0x7f,0x0a}}, // \xe7\x9c\xa5
{0x7726,{0x7f,0x55,0x7f,0x7f,0x24,0x7f,0x44}}, // \xe7\x9c\xa6
{0x7729,{0x7f,0x55,0x7f,0x4a,0x6e,0x53,0x6a}}, // \xe7\x9c\xa9
{0x7737,{0x2a,0x19,0x6c,0x6b,0x6c,0x19,0x2a}}, // \xe7\x9c\xb7
{0x7738,{0x7f,0x55,0x7f,0x36,0x2d,0x7c,0x2e}}, // \xe7\x9c\xb8
{0x773a,{0x7f,0x55,0x7f,0x3f,0x00,0x7f,0x4a}}, // \xe7\x9c\xba
{0x773c,{0x7f,0x55,0x7f,0x7f,0x55,0x35,0x5f}}, // \xe7\x9c\xbc
{0x7740,{0x4a,0x3a,0x0b,0x7e,0x7a,0x7b,0x0a}}, // \xe7\x9d\x80
{0x7747,{0x7f,0x55,0x7f,0x5a,0x2b,0x7e,0x6f}}, // \xe7\x9d\x87
{0x775a,{0x7f,0x55,0x7f,0x3f,0x55,0x7f,0x55}}, // \xe7\x9d\x9a
{0x775b,{0x7f,0x55,0x7f,0x08,0x7a,0x3f,0x7a}}, // \xe7\x9d\x9b
{0x7761,{0x7f,0x55,0x7f,0x14,0x5d,0x7f,0x55}}, // \xe7\x9d\xa1
{0x7763,{0x0c,0x74,0x5f,0x56,0x5b,0x75,0x0b}}, // \xe7\x9d\xa3
{0x7765,{0x7f,0x55,0x7f,0x2e,0x3f,0x7a,0x2e}}, // \xe7\x9d\xa5
{0x7766,{0x7f,0x55,0x7f,0x4e,0x67,0x5e,0x54}}, // \xe7\x9d\xa6
{0x7768,{0x7f,0x55,0x7f,0x5e,0x35,0x72,0x5e}}, // \xe7\x9d\xa8
{0x776b,{0x7f,0x55,0x7f,0x4a,0x2a,0x7f,0x56}}, // \xe7\x9d\xab
{0x7779,{0x7f,0x55,0x7f,0x28,0x1a,0x6f,0x6a}}, // \xe7\x9d\xb9
{0x777e,{0x28,0x2e,0x3a,0x6f,0x3a,0x2e,0x28}}, // \xe7\x9d\xbe
{0x777f,{0x2c,0x14,0x7c,0x77,0x7e,0x16,0x2c}}, // \xe7\x9d\xbf
{0x778b,{0x7f,0x55,0x7f,0x58,0x1f,0x1e,0x52}}, // \xe7\x9e\x8b
{0x778e,{0x7f,0x55,0x7f,0x26,0x6a,0x7f,0x6e}}, // \xe7\x9e\x8e
{0x7791,{0x7f,0x55,0x7f,0x53,0x1d,0x1d,0x53}}, // \xe7\x9e\x91
{0x779e,{0x7f,0x55,0x7f,0x7a,0x3f,0x7a,0x7f}}, // \xe7\x9e\x9e
{0x77a0,{0x7f,0x55,0x7f,0x5e,0x7b,0x5e,0x55}}, // \xe7\x9e\xa0
{0x77a5,{0x0d,0x76,0x7e,0x75,0x7a,0x75,0x0b}}, // \xe7\x9e\xa5
{0x77ac,{0x7f,0x55,0x7f,0x37,0x25,0x77,0x2d}}, // \xe7\x9e\xac
{0x77ad,{0x7f,0x55,0x7f,0x1e,0x6b,0x1e,0x4a}}, // \xe7\x9e\xad
{0x77b0,{0x7f,0x55,0x7f,0x27,0x7d,0x3f,0x5e}}, // \xe7\x9e\xb0
{0x77b3,{0x7f,0x55,0x7f,0x4a,0x5e,0x7b,0x5e}}, // \xe7\x9e\xb3
{0x77b6,{0x7f,0x55,0x7f,0x4e,0x3a,0x3f,0x4e}}, // \xe7\x9e\xb6
{0x77b9,{0x7f,0x55,0x7f,0x2f,0x55,0x37,0x4d}}, // \xe7\x9e\xb9
{0x77bb,{0x7f,0x55,0x7f,0x3e,0x6d,0x77,0x2c}}, // \xe7\x9e\xbb
{0x77bc,{0x7f,0x55,0x7f,0x36,0x5d,0x36,0x5c}}, // \xe7\x9e\xbc
{0x77bd,{0x1a,0x77,0x6a,0x60,0x76,0x6b,0x16}}, // \xe7\x9e\xbd
{0x77bf,{0x10,0x0b,0x7f,0x54,0x7f,0x57,0x44}}, // \xe7\x9e\xbf
{0x77c7,{0x7f,0x55,0x7f,0x5f,0x7a,0x2f,0x5a}}, // \xe7\x9f\x87
{0x77cd,{0x48,0x47,0x5f,0x2c,0x5f,0x4b,0x48}}, // \xe7\x9f\x8d
{0x77d7,{0x70,0x7a,0x52,0x1f,0x7e,0x72,0x50}}, // \xe7\x9f\x97
{0x77da,{0x7f,0x55,0x7f,0x5b,0x7f,0x3b,0x77}}, // \xe7\x9f\x9a
{0x77db,{0x28,0x29,0x5b,0x7d,0x0b,0x09,0x18}}, // \xe7\x9f\x9b
{0x77dc,{0x29,0x5d,0x7b,0x12,0x55,0x36,0x14}}, // \xe7\x9f\x9c
{0x77e2,{0x4c,0x4b,0x2a,0x1e,0x2a,0x4a,0x48}}, // \xe7\x9f\xa2
{0x77e3,{0x44,0x54,0x5e,0x35,0x54,0x52,0x44}}, // \xe7\x9f\xa3
{0x77e5,{0x44,0x2b,0x1e,0x2a,0x7e,0x42,0x7e}}, // \xe7\x9f\xa5
{0x77e7,{0x4b,0x3e,0x2a,0x5d,0x77,0x00,0x7f}}, // \xe7\x9f\xa7
{0x77e9,{0x44,0x2b,0x1e,0x2a,0x7f,0x55,0x5d}}, // \xe7\x9f\xa9
{0x77ed,{0x4b,0x3e,0x2a,0x5d,0x75,0x75,0x5d}}, // \xe7\x9f\xad
{0x77ee,{0x4b,0x3e,0x5a,0x77,0x5f,0x37,0x5a}}, // \xe7\x9f\xae
{0x77ef,{0x4b,0x3e,0x7a,0x17,0x5b,0x17,0x7a}}, // \xe7\x9f\xaf
{0x77f3,{0x11,0x09,0x7f,0x49,0x49,0x79,0x01}}, // \xe7\x9f\xb3
{0x77fc,{0x09,0x37,0x31,0x42,0x42,0x7e,0x42}}, // \xe7\x9f\xbc
{0x7802,{0x09,0x37,0x31,0x46,0x5f,0x22,0x14}}, // \xe7\xa0\x82
{0x780c,{0x09,0x37,0x31,0x1e,0x54,0x3f,0x7f}}, // \xe7\xa0\x8c
{0x7812,{0x09,0x37,0x31,0x7f,0x24,0x7f,0x44}}, // \xe7\xa0\x92
{0x7814,{0x09,0x37,0x31,0x49,0x3f,0x09,0x7f}}, // \xe7\xa0\x94
{0x7815,{0x09,0x37,0x31,0x2a,0x77,0x2e,0x28}}, // \xe7\xa0\x95
{0x7820,{0x09,0x37,0x31,0x40,0x7f,0x55,0x7f}}, // \xe7\xa0\xa0
{0x7825,{0x09,0x37,0x31,0x7e,0x4a,0x5e,0x69}}, // \xe7\xa0\xa5
{0x7826,{0x2e,0x18,0x6f,0x6a,0x68,0x6f,0x0a}}, // \xe7\xa0\xa6
{0x7827,{0x09,0x37,0x31,0x70,0x5f,0x54,0x74}}, // \xe7\xa0\xa7
{0x7832,{0x09,0x37,0x31,0x04,0x73,0x56,0x5e}}, // \xe7\xa0\xb2
{0x7834,{0x09,0x37,0x31,0x3e,0x5a,0x2f,0x5e}}, // \xe7\xa0\xb4
{0x783a,{0x09,0x37,0x31,0x1f,0x65,0x1d,0x75}}, // \xe7\xa0\xba
{0x783f,{0x09,0x37,0x31,0x1e,0x62,0x5b,0x62}}, // \xe7\xa0\xbf
{0x7845,{0x09,0x37,0x31,0x48,0x5a,0x7f,0x5a}}, // \xe7\xa1\x85
{0x785d,{0x09,0x37,0x31,0x7d,0x14,0x57,0x7d}}, // \xe7\xa1\x9d
{0x786b,{0x09,0x37,0x31,0x4a,0x6e,0x0b,0x6a}}, // \xe7\xa1\xab
{0x786c,{0x09,0x37,0x31,0x41,0x57,0x3f,0x47}}, // \xe7\xa1\xac
{0x786f,{0x09,0x37,0x31,0x5f,0x35,0x75,0x5f}}, // \xe7\xa1\xaf
{0x7872,{0x09,0x37,0x32,0x09,0x64,0x69,0x12}}, // \xe7\xa1\xb2
{0x7874,{0x09,0x37,0x32,0x7b,0x02,0x7f,0x52}}, // \xe7\xa1\xb4
{0x787c,{0x09,0x37,0x3f,0x55,0x3f,0x55,0x7f}}, // \xe7\xa1\xbc
{0x7881,{0x28,0x5a,0x2f,0x6a,0x6f,0x1a,0x28}}, // \xe7\xa2\x81
{0x7886,{0x55,0x30,0x78,0x56,0x5a,0x77,0x1a}}, // \xe7\xa2\x86
{0x7887,{0x09,0x37,0x31,0x46,0x32,0x7f,0x56}}, // \xe7\xa2\x87
{0x788c,{0x09,0x37,0x74,0x26,0x7d,0x27,0x55}}, // \xe7\xa2\x8c
{0x788d,{0x09,0x37,0x31,0x34,0x57,0x7f,0x14}}, // \xe7\xa2\x8d
{0x788e,{0x09,0x37,0x32,0x2e,0x73,0x2e,0x32}}, // \xe7\xa2\x8e
{0x7891,{0x09,0x37,0x31,0x2e,0x3f,0x7a,0x2e}}, // \xe7\xa2\x91
{0x7893,{0x09,0x37,0x31,0x7f,0x4a,0x7f,0x4a}}, // \xe7\xa2\x93
{0x7895,{0x09,0x37,0x31,0x5a,0x17,0x7a,0x12}}, // \xe7\xa2\x95
{0x7897,{0x09,0x37,0x31,0x56,0x2a,0x7b,0x5e}}, // \xe7\xa2\x97
{0x789a,{0x09,0x37,0x31,0x0a,0x6e,0x6b,0x6e}}, // \xe7\xa2\x9a
{0x78a3,{0x09,0x37,0x31,0x3f,0x2d,0x4f,0x78}}, // \xe7\xa2\xa3
{0x78a7,{0x55,0x3f,0x75,0x50,0x5e,0x7b,0x1e}}, // \xe7\xa2\xa7
{0x78a9,{0x09,0x37,0x31,0x5d,0x17,0x15,0x5d}}, // \xe7\xa2\xa9
{0x78aa,{0x09,0x37,0x72,0x5f,0x72,0x5f,0x52}}, // \xe7\xa2\xaa
{0x78af,{0x09,0x37,0x31,0x7a,0x6d,0x5a,0x7d}}, // \xe7\xa2\xaf
{0x78b5,{0x09,0x37,0x31,0x40,0x3c,0x3f,0x42}}, // \xe7\xa2\xb5
{0x78ba,{0x09,0x37,0x31,0x16,0x7a,0x7f,0x56}}, // \xe7\xa2\xba
{0x78bc,{0x09,0x37,0x31,0x5f,0x15,0x5f,0x75}}, // \xe7\xa2\xbc
{0x78be,{0x09,0x37,0x3f,0x75,0x5d,0x3d,0x57}}, // \xe7\xa2\xbe
{0x78c1,{0x09,0x37,0x31,0x6a,0x57,0x6a,0x57}}, // \xe7\xa3\x81
{0x78c5,{0x09,0x37,0x3a,0x4e,0x3b,0x6e,0x1a}}, // \xe7\xa3\x85
{0x78c6,{0x09,0x37,0x31,0x0c,0x77,0x35,0x7f}}, // \xe7\xa3\x86
{0x78ca,{0x50,0x35,0x73,0x5f,0x3b,0x7f,0x71}}, // \xe7\xa3\x8a
{0x78cb,{0x09,0x37,0x31,0x2a,0x5b,0x7e,0x5b}}, // \xe7\xa3\x8b
{0x78d0,{0x5c,0x37,0x7f,0x54,0x5b,0x75,0x1b}}, // \xe7\xa3\x90
{0x78d1,{0x09,0x37,0x31,0x5b,0x6a,0x6b,0x5b}}, // \xe7\xa3\x91
{0x78d4,{0x09,0x37,0x51,0x3a,0x75,0x36,0x5f}}, // \xe7\xa3\x94
{0x78da,{0x09,0x37,0x31,0x12,0x3e,0x5f,0x7a}}, // \xe7\xa3\x9a
{0x78e7,{0x09,0x37,0x31,0x4a,0x3a,0x3f,0x4a}}, // \xe7\xa3\xa7
{0x78e8,{0x40,0x3e,0x4a,0x3e,0x6b,0x7e,0x2a}}, // \xe7\xa3\xa8
{0x78ec,{0x5a,0x36,0x77,0x52,0x5b,0x75,0x1b}}, // \xe7\xa3\xac
{0x78ef,{0x09,0x37,0x72,0x3d,0x48,0x3a,0x55}}, // \xe7\xa3\xaf
{0x78f4,{0x09,0x37,0x31,0x45,0x5b,0x6a,0x5d}}, // \xe7\xa3\xb4
{0x78fd,{0x09,0x37,0x31,0x5c,0x3e,0x77,0x5e}}, // \xe7\xa3\xbd
{0x7901,{0x09,0x37,0x31,0x44,0x1f,0x5e,0x53}}, // \xe7\xa4\x81
{0x7907,{0x09,0x37,0x31,0x5e,0x5f,0x36,0x5e}}, // \xe7\xa4\x87
{0x790e,{0x09,0x37,0x31,0x4a,0x37,0x7a,0x57}}, // \xe7\xa4\x8e
{0x7911,{0x09,0x37,0x75,0x5e,0x7b,0x5e,0x75}}, // \xe7\xa4\x91
{0x7912,{0x09,0x37,0x31,0x2a,0x7b,0x2e,0x5b}}, // \xe7\xa4\x92
{0x7919,{0x09,0x37,0x57,0x3a,0x5a,0x3d,0x57}}, // \xe7\xa4\x99
{0x7926,{0x09,0x37,0x31,0x1e,0x4a,0x1f,0x5e}}, // \xe7\xa4\xa6
{0x792a,{0x09,0x37,0x31,0x1f,0x6d,0x3f,0x6d}}, // \xe7\xa4\xaa
{0x792b,{0x09,0x37,0x5a,0x35,0x7f,0x3a,0x55}}, // \xe7\xa4\xab
{0x792c,{0x2a,0x5f,0x3a,0x75,0x7a,0x1f,0x2a}}, // \xe7\xa4\xac
{0x793a,{0x24,0x15,0x45,0x7d,0x05,0x15,0x24}}, // \xe7\xa4\xba
{0x793c,{0x12,0x7b,0x16,0x00,0x7f,0x40,0x60}}, // \xe7\xa4\xbc
{0x793e,{0x12,0x7b,0x16,0x40,0x44,0x7f,0x44}}, // \xe7\xa4\xbe
{0x7940,{0x35,0x7d,0x15,0x7f,0x49,0x49,0x6f}}, // \xe7\xa5\x80
{0x7941,{0x12,0x7b,0x16,0x00,0x7f,0x25,0x1b}}, // \xe7\xa5\x81
{0x7947,{0x12,0x7b,0x16,0x7e,0x4a,0x3e,0x49}}, // \xe7\xa5\x87
{0x7948,{0x12,0x7b,0x16,0x40,0x3e,0x0a,0x79}}, // \xe7\xa5\x88
{0x7949,{0x12,0x7b,0x16,0x7c,0x40,0x7f,0x44}}, // \xe7\xa5\x89
{0x7950,{0x12,0x7b,0x16,0x12,0x7f,0x4a,0x7a}}, // \xe7\xa5\x90
{0x7953,{0x35,0x7d,0x15,0x22,0x5f,0x22,0x5b}}, // \xe7\xa5\x93
{0x7955,{0x35,0x7d,0x58,0x3d,0x52,0x48,0x56}}, // \xe7\xa5\x95
{0x7956,{0x12,0x7b,0x56,0x7f,0x55,0x7f,0x40}}, // \xe7\xa5\x96
{0x7957,{0x35,0x7d,0x15,0x7e,0x4a,0x5e,0x69}}, // \xe7\xa5\x97
{0x795a,{0x35,0x7d,0x15,0x04,0x7f,0x2a,0x2a}}, // \xe7\xa5\x9a
{0x795d,{0x12,0x7b,0x16,0x4f,0x39,0x79,0x4f}}, // \xe7\xa5\x9d
{0x795e,{0x12,0x7b,0x3e,0x2a,0x7f,0x2a,0x3e}}, // \xe7\xa5\x9e
{0x795f,{0x4c,0x3b,0x5a,0x7f,0x1a,0x3b,0x4c}}, // \xe7\xa5\x9f
{0x7960,{0x35,0x7d,0x00,0x35,0x35,0x41,0x7f}}, // \xe7\xa5\xa0
{0x7962,{0x12,0x7b,0x16,0x24,0x5b,0x7e,0x32}}, // \xe7\xa5\xa2
{0x7965,{0x12,0x7b,0x16,0x22,0x2b,0x7e,0x2b}}, // \xe7\xa5\xa5
{0x7968,{0x51,0x37,0x55,0x77,0x15,0x37,0x51}}, // \xe7\xa5\xa8
{0x796d,{0x54,0x2b,0x55,0x73,0x14,0x2d,0x53}}, // \xe7\xa5\xad
{0x7977,{0x12,0x7b,0x36,0x5e,0x17,0x7e,0x14}}, // \xe7\xa5\xb7
{0x797a,{0x35,0x7d,0x52,0x1f,0x1a,0x1f,0x52}}, // \xe7\xa5\xba
{0x797f,{0x35,0x7d,0x54,0x26,0x7d,0x27,0x55}}, // \xe7\xa5\xbf
{0x7980,{0x52,0x3e,0x5e,0x7b,0x1e,0x3e,0x52}}, // \xe7\xa6\x80
{0x7981,{0x5a,0x36,0x5f,0x7a,0x16,0x3f,0x5a}}, // \xe7\xa6\x81
{0x7984,{0x12,0x7b,0x56,0x25,0x7d,0x27,0x54}}, // \xe7\xa6\x84
{0x7985,{0x12,0x7b,0x16,0x2d,0x2d,0x7e,0x2d}}, // \xe7\xa6\x85
{0x798a,{0x35,0x7d,0x56,0x5f,0x36,0x53,0x57}}, // \xe7\xa6\x8a
{0x798d,{0x12,0x7b,0x16,0x78,0x6f,0x09,0x7f}}, // \xe7\xa6\x8d
{0x798e,{0x12,0x7b,0x16,0x40,0x3c,0x3f,0x42}}, // \xe7\xa6\x8e
{0x798f,{0x12,0x7b,0x16,0x71,0x57,0x77,0x71}}, // \xe7\xa6\x8f
{0x799d,{0x35,0x7d,0x54,0x53,0x2b,0x5f,0x44}}, // \xe7\xa6\x9d
{0x79a6,{0x4a,0x3d,0x53,0x7e,0x1a,0x3f,0x47}}, // \xe7\xa6\xa6
{0x79a7,{0x35,0x7d,0x12,0x7e,0x57,0x7e,0x12}}, // \xe7\xa6\xa7
{0x79aa,{0x35,0x7d,0x23,0x3f,0x7c,0x3f,0x23}}, // \xe7\xa6\xaa
{0x79ae,{0x35,0x7d,0x15,0x5e,0x6f,0x6e,0x5f}}, // \xe7\xa6\xae
{0x79b0,{0x12,0x7b,0x16,0x7d,0x57,0x2f,0x7d}}, // \xe7\xa6\xb0
{0x79b3,{0x35,0x7d,0x36,0x7e,0x5b,0x3e,0x56}}, // \xe7\xa6\xb3
{0x79b9,{0x72,0x1e,0x56,0x7e,0x35,0x5d,0x70}}, // \xe7\xa6\xb9
{0x79ba,{0x70,0x1f,0x55,0x7f,0x35,0x5f,0x70}}, // \xe7\xa6\xba
{0x79bd,{0x72,0x1e,0x7a,0x55,0x3a,0x5e,0x72}}, // \xe7\xa6\xbd
{0x79be,{0x24,0x26,0x16,0x7e,0x15,0x25,0x24}}, // \xe7\xa6\xbe
{0x79bf,{0x4a,0x4a,0x37,0x0f,0x77,0x4a,0x6a}}, // \xe7\xa6\xbf
{0x79c0,{0x4a,0x5a,0x37,0x1f,0x37,0x6a,0x0a}}, // \xe7\xa7\x80
{0x79c1,{0x24,0x15,0x7f,0x15,0x70,0x4f,0x60}}, // \xe7\xa7\x81
{0x79c9,{0x42,0x56,0x37,0x7f,0x3f,0x5e,0x4a}}, // \xe7\xa7\x89
{0x79cb,{0x35,0x7f,0x4c,0x20,0x1f,0x28,0x44}}, // \xe7\xa7\x8b
{0x79d1,{0x35,0x7f,0x25,0x2a,0x20,0x7f,0x10}}, // \xe7\xa7\x91
{0x79d2,{0x35,0x7f,0x08,0x46,0x5f,0x22,0x14}}, // \xe7\xa7\x92
{0x79d5,{0x35,0x7f,0x40,0x7f,0x24,0x7f,0x44}}, // \xe7\xa7\x95
{0x79d8,{0x35,0x7f,0x58,0x3d,0x52,0x48,0x56}}, // \xe7\xa7\x98
{0x79df,{0x35,0x7f,0x40,0x7f,0x55,0x7f,0x40}}, // \xe7\xa7\x9f
{0x79e1,{0x35,0x7f,0x15,0x22,0x5f,0x22,0x5b}}, // \xe7\xa7\xa1
{0x79e3,{0x35,0x7f,0x42,0x2a,0x7f,0x2a,0x42}}, // \xe7\xa7\xa3
{0x79e4,{0x35,0x7f,0x15,0x11,0x7f,0x11,0x15}}, // \xe7\xa7\xa4
{0x79e6,{0x48,0x5a,0x2e,0x7f,0x2e,0x5a,0x48}}, // \xe7\xa7\xa6
{0x79e7,{0x35,0x7f,0x48,0x4e,0x3b,0x4e,0x48}}, // \xe7\xa7\xa7
{0x79e9,{0x35,0x7f,0x4c,0x2b,0x1f,0x2a,0x48}}, // \xe7\xa7\xa9
{0x79ec,{0x35,0x7f,0x15,0x7f,0x55,0x55,0x5d}}, // \xe7\xa7\xac
{0x79f0,{0x35,0x7f,0x24,0x5b,0x7e,0x0a,0x32}}, // \xe7\xa7\xb0
{0x79fb,{0x35,0x7f,0x15,0x4a,0x55,0x2b,0x18}}, // \xe7\xa7\xbb
{0x7a00,{0x35,0x7f,0x48,0x2d,0x7a,0x2d,0x68}}, // \xe7\xa8\x80
{0x7a08,{0x35,0x7f,0x28,0x2f,0x7d,0x2f,0x28}}, // \xe7\xa8\x88
{0x7a0b,{0x35,0x7f,0x44,0x57,0x7d,0x57,0x44}}, // \xe7\xa8\x8b
{0x7a0d,{0x35,0x7f,0x02,0x7d,0x2a,0x7d,0x02}}, // \xe7\xa8\x8d
{0x7a0e,{0x35,0x7f,0x4e,0x3b,0x0a,0x7b,0x4e}}, // \xe7\xa8\x8e
{0x7a14,{0x35,0x7f,0x64,0x2a,0x4d,0x5e,0x64}}, // \xe7\xa8\x94
{0x7a17,{0x35,0x7f,0x2e,0x3a,0x2f,0x7a,0x2e}}, // \xe7\xa8\x97
{0x7a18,{0x35,0x7f,0x52,0x1f,0x1a,0x1f,0x52}}, // \xe7\xa8\x98
{0x7a19,{0x35,0x7f,0x15,0x7a,0x42,0x5f,0x5a}}, // \xe7\xa8\x99
{0x7a1a,{0x35,0x7f,0x15,0x7f,0x4a,0x7f,0x4a}}, // \xe7\xa8\x9a
{0x7a1c,{0x35,0x7f,0x28,0x5a,0x2f,0x5a,0x48}}, // \xe7\xa8\x9c
{0x7a1f,{0x52,0x5e,0x3e,0x7b,0x3e,0x5e,0x52}}, // \xe7\xa8\x9f
{0x7a20,{0x35,0x7f,0x7f,0x35,0x2f,0x35,0x7f}}, // \xe7\xa8\xa0
{0x7a2e,{0x35,0x7f,0x44,0x5e,0x7e,0x5d,0x44}}, // \xe7\xa8\xae
{0x7a31,{0x35,0x7f,0x22,0x79,0x3f,0x79,0x22}}, // \xe7\xa8\xb1
{0x7a32,{0x35,0x7f,0x15,0x72,0x06,0x71,0x75}}, // \xe7\xa8\xb2
{0x7a37,{0x35,0x7f,0x54,0x53,0x2b,0x5f,0x44}}, // \xe7\xa8\xb7
{0x7a3b,{0x35,0x7f,0x72,0x69,0x43,0x69,0x7a}}, // \xe7\xa8\xbb
{0x7a3c,{0x35,0x7f,0x26,0x5a,0x7b,0x2a,0x56}}, // \xe7\xa8\xbc
{0x7a3d,{0x35,0x7f,0x0a,0x76,0x6f,0x6a,0x6b}}, // \xe7\xa8\xbd
{0x7a3e,{0x5a,0x4a,0x3e,0x77,0x3e,0x4a,0x5a}}, // \xe7\xa8\xbe
{0x7a3f,{0x35,0x7f,0x72,0x1e,0x5b,0x1e,0x72}}, // \xe7\xa8\xbf
{0x7a40,{0x5a,0x2a,0x7f,0x2a,0x5b,0x29,0x5b}}, // \xe7\xa9\x80
{0x7a42,{0x35,0x7f,0x62,0x2e,0x4f,0x4e,0x62}}, // \xe7\xa9\x82
{0x7a43,{0x35,0x7f,0x26,0x16,0x6b,0x76,0x26}}, // \xe7\xa9\x83
{0x7a46,{0x35,0x7f,0x08,0x46,0x5f,0x56,0x28}}, // \xe7\xa9\x86
{0x7a49,{0x35,0x7f,0x3f,0x2b,0x33,0x7f,0x2b}}, // \xe7\xa9\x89
{0x7a4d,{0x35,0x7f,0x48,0x3a,0x3f,0x3a,0x48}}, // \xe7\xa9\x8d
{0x7a4e,{0x57,0x3a,0x7a,0x30,0x5d,0x17,0x5d}}, // \xe7\xa9\x8e
{0x7a4f,{0x35,0x7f,0x66,0x3a,0x5e,0x59,0x65}}, // \xe7\xa9\x8f
{0x7a50,{0x35,0x7f,0x15,0x3a,0x2d,0x7f,0x58}}, // \xe7\xa9\x90
{0x7a57,{0x35,0x7f,0x62,0x2e,0x4f,0x46,0x6a}}, // \xe7\xa9\x97
{0x7a61,{0x35,0x7f,0x7a,0x76,0x5b,0x76,0x7a}}, // \xe7\xa9\xa1
{0x7a62,{0x35,0x7f,0x48,0x3e,0x48,0x3f,0x5a}}, // \xe7\xa9\xa2
{0x7a63,{0x35,0x7f,0x1a,0x7e,0x53,0x3e,0x5a}}, // \xe7\xa9\xa3
{0x7a69,{0x35,0x7f,0x62,0x35,0x5f,0x5d,0x6a}}, // \xe7\xa9\xa9
{0x7a6b,{0x35,0x7f,0x42,0x5f,0x2e,0x5f,0x4a}}, // \xe7\xa9\xab
{0x7a70,{0x35,0x7f,0x36,0x7e,0x5b,0x3e,0x56}}, // \xe7\xa9\xb0
{0x7a74,{0x46,0x22,0x1a,0x03,0x1a,0x22,0x46}}, // \xe7\xa9\xb4
{0x7a76,{0x56,0x5a,0x36,0x13,0x7e,0x4a,0x66}}, // \xe7\xa9\xb6
{0x7a79,{0x06,0x3a,0x36,0x33,0x3e,0x2a,0x66}}, // \xe7\xa9\xb9
{0x7a7a,{0x46,0x4a,0x56,0x73,0x5e,0x4a,0x46}}, // \xe7\xa9\xba
{0x7a7d,{0x26,0x3a,0x76,0x33,0x3e,0x7a,0x36}}, // \xe7\xa9\xbd
{0x7a7f,{0x26,0x6a,0x36,0x33,0x7e,0x2a,0x26}}, // \xe7\xa9\xbf
{0x7a81,{0x56,0x5a,0x56,0x33,0x5e,0x5a,0x56}}, // \xe7\xaa\x81
{0x7a83,{0x16,0x7a,0x56,0x03,0x5e,0x3a,0x76}}, // \xe7\xaa\x83
{0x7a84,{0x26,0x1a,0x16,0x73,0x3e,0x2a,0x26}}, // \xe7\xaa\x84
{0x7a88,{0x46,0x6a,0x56,0x03,0x56,0x3a,0x76}}, // \xe7\xaa\x88
{0x7a92,{0x46,0x5a,0x56,0x7b,0x5e,0x4a,0x56}}, // \xe7\xaa\x92
{0x7a93,{0x66,0x2a,0x56,0x53,0x6e,0x0a,0x66}}, // \xe7\xaa\x93
{0x7a95,{0x56,0x5a,0x3e,0x07,0x7a,0x4e,0x56}}, // \xe7\xaa\x95
{0x7a96,{0x26,0x32,0x6e,0x7f,0x6a,0x2e,0x26}}, // \xe7\xaa\x96
{0x7a97,{0x06,0x7a,0x6e,0x5f,0x7a,0x7e,0x06}}, // \xe7\xaa\x97
{0x7a98,{0x56,0x52,0x3e,0x7f,0x5a,0x5e,0x76}}, // \xe7\xaa\x98
{0x7a9f,{0x46,0x3a,0x7e,0x5f,0x7a,0x5e,0x66}}, // \xe7\xaa\x9f
{0x7aa9,{0x66,0x3a,0x6e,0x6f,0x7a,0x3e,0x66}}, // \xe7\xaa\xa9
{0x7aaa,{0x56,0x0a,0x56,0x53,0x7e,0x5a,0x56}}, // \xe7\xaa\xaa
{0x7aae,{0x56,0x5a,0x2e,0x7f,0x02,0x5e,0x76}}, // \xe7\xaa\xae
{0x7aaf,{0x66,0x2a,0x6e,0x3b,0x6e,0x2a,0x66}}, // \xe7\xaa\xaf
{0x7ab0,{0x26,0x2a,0x7e,0x57,0x7a,0x56,0x66}}, // \xe7\xaa\xb0
{0x7ab6,{0x56,0x5a,0x7e,0x57,0x3e,0x5a,0x56}}, // \xe7\xaa\xb6
{0x7aba,{0x56,0x3a,0x56,0x43,0x3e,0x7a,0x5e}}, // \xe7\xaa\xba
{0x7abf,{0x7e,0x3a,0x56,0x57,0x6a,0x5e,0x56}}, // \xe7\xaa\xbf
{0x7ac3,{0x06,0x3a,0x36,0x3b,0x7e,0x7a,0x46}}, // \xe7\xab\x83
{0x7ac4,{0x46,0x7a,0x16,0x73,0x56,0x3e,0x46}}, // \xe7\xab\x84
{0x7ac5,{0x56,0x3a,0x7e,0x07,0x52,0x2e,0x5e}}, // \xe7\xab\x85
{0x7ac7,{0x46,0x5a,0x3e,0x3f,0x3a,0x5e,0x46}}, // \xe7\xab\x87
{0x7ac8,{0x06,0x3a,0x76,0x4b,0x7e,0x7a,0x46}}, // \xe7\xab\x88
{0x7aca,{0x56,0x3a,0x7e,0x27,0x72,0x3e,0x76}}, // \xe7\xab\x8a
{0x7acb,{0x42,0x46,0x7a,0x43,0x72,0x4e,0x42}}, // \xe7\xab\x8b
{0x7acd,{0x2e,0x33,0x2e,0x04,0x04,0x7f,0x04}}, // \xe7\xab\x8d
{0x7acf,{0x2e,0x33,0x2e,0x08,0x0a,0x7e,0x09}}, // \xe7\xab\x8f
{0x7ad2,{0x08,0x7a,0x5e,0x7b,0x0e,0x7a,0x08}}, // \xe7\xab\x92
{0x7ad3,{0x2e,0x33,0x2e,0x2a,0x7e,0x55,0x55}}, // \xe7\xab\x93
{0x7ad5,{0x2e,0x33,0x2e,0x44,0x3b,0x48,0x7b}}, // \xe7\xab\x95
{0x7ad9,{0x2e,0x33,0x2e,0x70,0x5f,0x54,0x74}}, // \xe7\xab\x99
{0x7ada,{0x2e,0x33,0x2e,0x06,0x4a,0x7b,0x0e}}, // \xe7\xab\x9a
{0x7adc,{0x08,0x3a,0x2e,0x3b,0x6e,0x7a,0x48}}, // \xe7\xab\x9c
{0x7add,{0x2e,0x33,0x2e,0x42,0x7e,0x63,0x5e}}, // \xe7\xab\x9d
{0x7adf,{0x48,0x4a,0x3e,0x3b,0x7e,0x4a,0x68}}, // \xe7\xab\x9f
{0x7ae0,{0x28,0x3a,0x2e,0x6b,0x2e,0x3a,0x28}}, // \xe7\xab\xa0
{0x7ae1,{0x2e,0x33,0x2e,0x7d,0x57,0x55,0x7d}}, // \xe7\xab\xa1
{0x7ae2,{0x2e,0x33,0x2e,0x56,0x5d,0x34,0x56}}, // \xe7\xab\xa2
{0x7ae3,{0x2e,0x33,0x2e,0x57,0x32,0x5e,0x4b}}, // \xe7\xab\xa3
{0x7ae5,{0x48,0x5a,0x5e,0x7b,0x5e,0x5a,0x48}}, // \xe7\xab\xa5
{0x7ae6,{0x2e,0x33,0x4e,0x2e,0x7f,0x2a,0x4e}}, // \xe7\xab\xa6
{0x7aea,{0x47,0x57,0x75,0x58,0x7b,0x55,0x4b}}, // \xe7\xab\xaa
{0x7aed,{0x2e,0x33,0x1e,0x37,0x2d,0x4f,0x78}}, // \xe7\xab\xad
{0x7aef,{0x2e,0x33,0x6f,0x3a,0x6b,0x2a,0x6b}}, // \xe7\xab\xaf
{0x7af0,{0x2e,0x33,0x1e,0x4f,0x5d,0x7d,0x5d}}, // \xe7\xab\xb0
{0x7af6,{0x4a,0x3e,0x6b,0x5e,0x3e,0x6b,0x5e}}, // \xe7\xab\xb6
{0x7af8,{0x4a,0x3e,0x7b,0x5e,0x3e,0x7b,0x5e}}, // \xe7\xab\xb8
{0x7af9,{0x04,0x03,0x7e,0x04,0x43,0x7e,0x02}}, // \xe7\xab\xb9
{0x7afa,{0x44,0x53,0x56,0x54,0x53,0x56,0x42}}, // \xe7\xab\xba
{0x7aff,{0x24,0x2b,0x2e,0x7c,0x2b,0x2e,0x22}}, // \xe7\xab\xbf
{0x7b02,{0x44,0x53,0x3e,0x54,0x13,0x76,0x42}}, // \xe7\xac\x82
{0x7b04,{0x24,0x6b,0x3e,0x2c,0x7b,0x2e,0x22}}, // \xe7\xac\x84
{0x7b06,{0x04,0x3f,0x56,0x5c,0x57,0x5e,0x62}}, // \xe7\xac\x86
{0x7b08,{0x44,0x4b,0x2e,0x5c,0x2b,0x5e,0x42}}, // \xe7\xac\x88
{0x7b0a,{0x44,0x3b,0x0e,0x7c,0x07,0x36,0x42}}, // \xe7\xac\x8a
{0x7b0b,{0x54,0x53,0x36,0x1c,0x17,0x1e,0x0a}}, // \xe7\xac\x8b
{0x7b0f,{0x24,0x5b,0x3e,0x4c,0x3b,0x4e,0x7a}}, // \xe7\xac\x8f
{0x7b11,{0x54,0x53,0x56,0x3c,0x53,0x56,0x52}}, // \xe7\xac\x91
{0x7b18,{0x04,0x63,0x66,0x7c,0x6b,0x6e,0x02}}, // \xe7\xac\x98
{0x7b19,{0x54,0x4b,0x5e,0x7c,0x5b,0x5e,0x4a}}, // \xe7\xac\x99
{0x7b1b,{0x04,0x73,0x56,0x7c,0x53,0x76,0x02}}, // \xe7\xac\x9b
{0x7b1e,{0x14,0x73,0x5e,0x54,0x53,0x76,0x12}}, // \xe7\xac\x9e
{0x7b20,{0x44,0x53,0x76,0x5c,0x73,0x56,0x42}}, // \xe7\xac\xa0
{0x7b25,{0x04,0x6b,0x6e,0x6c,0x0b,0x4e,0x7a}}, // \xe7\xac\xa5
{0x7b26,{0x14,0x7b,0x06,0x2c,0x4b,0x7e,0x0a}}, // \xe7\xac\xa6
{0x7b28,{0x2c,0x1b,0x2e,0x7c,0x2b,0x1e,0x2a}}, // \xe7\xac\xa8
{0x7b2c,{0x44,0x5b,0x2e,0x7c,0x2b,0x2e,0x62}}, // \xe7\xac\xac
{0x7b33,{0x54,0x3b,0x56,0x74,0x73,0x56,0x72}}, // \xe7\xac\xb3
{0x7b35,{0x54,0x03,0x3e,0x4c,0x4b,0x5e,0x62}}, // \xe7\xac\xb5
{0x7b36,{0x44,0x53,0x5e,0x34,0x53,0x56,0x42}}, // \xe7\xac\xb6
{0x7b39,{0x14,0x13,0x7e,0x54,0x7b,0x7e,0x52}}, // \xe7\xac\xb9
{0x7b45,{0x54,0x5b,0x36,0x1c,0x77,0x56,0x52}}, // \xe7\xad\x85
{0x7b46,{0x24,0x2b,0x2e,0x7c,0x2b,0x3e,0x2a}}, // \xe7\xad\x86
{0x7b48,{0x24,0x2b,0x6e,0x7c,0x6b,0x26,0x22}}, // \xe7\xad\x88
{0x7b49,{0x14,0x13,0x36,0x5c,0x7b,0x16,0x12}}, // \xe7\xad\x89
{0x7b4b,{0x44,0x3b,0x7e,0x54,0x3b,0x56,0x72}}, // \xe7\xad\x8b
{0x7b4c,{0x54,0x57,0x5e,0x74,0x5b,0x56,0x52}}, // \xe7\xad\x8c
{0x7b4d,{0x14,0x0b,0x7e,0x54,0x7f,0x06,0x7e}}, // \xe7\xad\x8d
{0x7b4f,{0x14,0x7b,0x06,0x54,0x53,0x3e,0x4a}}, // \xe7\xad\x8f
{0x7b50,{0x04,0x7b,0x4e,0x5c,0x7b,0x5e,0x4a}}, // \xe7\xad\x90
{0x7b51,{0x54,0x73,0x56,0x44,0x33,0x76,0x42}}, // \xe7\xad\x91
{0x7b52,{0x7c,0x0b,0x6e,0x6c,0x6b,0x0e,0x7a}}, // \xe7\xad\x92
{0x7b54,{0x14,0x13,0x6e,0x6c,0x6b,0x16,0x12}}, // \xe7\xad\x94
{0x7b56,{0x5c,0x4b,0x2e,0x7c,0x2b,0x4e,0x5a}}, // \xe7\xad\x96
{0x7b5d,{0x14,0x1b,0x56,0x74,0x3f,0x36,0x12}}, // \xe7\xad\x9d
{0x7b65,{0x04,0x63,0x6e,0x7c,0x6f,0x66,0x02}}, // \xe7\xad\xa5
{0x7b67,{0x44,0x43,0x3e,0x3c,0x7b,0x46,0x62}}, // \xe7\xad\xa7
{0x7b6c,{0x44,0x3b,0x56,0x34,0x47,0x3e,0x56}}, // \xe7\xad\xac
{0x7b6e,{0x54,0x4b,0x56,0x7c,0x57,0x4e,0x52}}, // \xe7\xad\xae
{0x7b70,{0x14,0x7b,0x06,0x14,0x7b,0x2e,0x2a}}, // \xe7\xad\xb0
{0x7b71,{0x14,0x7b,0x3e,0x04,0x53,0x2e,0x5a}}, // \xe7\xad\xb1
{0x7b74,{0x54,0x4b,0x56,0x3c,0x57,0x4e,0x52}}, // \xe7\xad\xb4
{0x7b75,{0x54,0x2b,0x46,0x74,0x63,0x7e,0x6a}}, // \xe7\xad\xb5
{0x7b7a,{0x04,0x7b,0x4e,0x5c,0x7b,0x5e,0x6a}}, // \xe7\xad\xba
{0x7b86,{0x44,0x7f,0x56,0x0c,0x77,0x5e,0x52}}, // \xe7\xae\x86
{0x7b87,{0x7c,0x4b,0x6e,0x5c,0x6b,0x4e,0x7a}}, // \xe7\xae\x87
{0x7b8b,{0x14,0x53,0x56,0x3c,0x3b,0x56,0x6a}}, // \xe7\xae\x8b
{0x7b8d,{0x54,0x7b,0x06,0x7c,0x5f,0x7e,0x5a}}, // \xe7\xae\x8d
{0x7b8f,{0x14,0x1b,0x56,0x7c,0x37,0x3a,0x12}}, // \xe7\xae\x8f
{0x7b92,{0x1c,0x6b,0x2e,0x7c,0x2f,0x6e,0x1a}}, // \xe7\xae\x92
{0x7b94,{0x54,0x03,0x76,0x54,0x5b,0x56,0x72}}, // \xe7\xae\x94
{0x7b95,{0x24,0x6b,0x3e,0x2c,0x3b,0x6e,0x22}}, // \xe7\xae\x95
{0x7b97,{0x24,0x7b,0x2e,0x2c,0x6b,0x3e,0x22}}, // \xe7\xae\x97
{0x7b98,{0x7c,0x6b,0x5e,0x7c,0x5b,0x6e,0x7a}}, // \xe7\xae\x98
{0x7b99,{0x44,0x3b,0x7e,0x04,0x7b,0x2e,0x5a}}, // \xe7\xae\x99
{0x7b9a,{0x24,0x13,0x6e,0x74,0x1b,0x46,0x7a}}, // \xe7\xae\x9a
{0x7b9c,{0x4c,0x57,0x6e,0x64,0x7f,0x56,0x4e}}, // \xe7\xae\x9c
{0x7b9d,{0x54,0x7b,0x16,0x7c,0x53,0x7e,0x12}}, // \xe7\xae\x9d
{0x7b9f,{0x44,0x73,0x5e,0x0c,0x7f,0x5e,0x52}}, // \xe7\xae\x9f
{0x7ba1,{0x1c,0x0b,0x7e,0x7c,0x6b,0x6e,0x1a}}, // \xe7\xae\xa1
{0x7baa,{0x24,0x3b,0x36,0x7c,0x33,0x3e,0x22}}, // \xe7\xae\xaa
{0x7bad,{0x0c,0x7b,0x2e,0x7c,0x0b,0x7e,0x0a}}, // \xe7\xae\xad
{0x7bb1,{0x54,0x33,0x7e,0x34,0x7b,0x56,0x7a}}, // \xe7\xae\xb1
{0x7bb4,{0x44,0x3b,0x6e,0x6c,0x4b,0x3e,0x5a}}, // \xe7\xae\xb4
{0x7bb8,{0x54,0x53,0x36,0x7c,0x5b,0x76,0x12}}, // \xe7\xae\xb8
{0x7bc0,{0x7c,0x5b,0x5e,0x24,0x7b,0x0e,0x3a}}, // \xe7\xaf\x80
{0x7bc1,{0x44,0x53,0x5e,0x74,0x5f,0x52,0x42}}, // \xe7\xaf\x81
{0x7bc4,{0x2c,0x3b,0x7e,0x2c,0x7b,0x4e,0x5a}}, // \xe7\xaf\x84
{0x7bc6,{0x54,0x53,0x3e,0x54,0x7f,0x36,0x52}}, // \xe7\xaf\x86
{0x7bc7,{0x4c,0x3b,0x1e,0x7c,0x7b,0x2e,0x6a}}, // \xe7\xaf\x87
{0x7bc9,{0x54,0x5b,0x36,0x64,0x3b,0x5e,0x52}}, // \xe7\xaf\x89
{0x7bcb,{0x04,0x7b,0x5e,0x6c,0x5b,0x6e,0x4a}}, // \xe7\xaf\x8b
{0x7bcc,{0x14,0x7b,0x06,0x54,0x37,0x5e,0x52}}, // \xe7\xaf\x8c
{0x7bcf,{0x14,0x7b,0x56,0x7c,0x5b,0x36,0x52}}, // \xe7\xaf\x8f
{0x7bdd,{0x2c,0x7b,0x3e,0x3c,0x3b,0x7e,0x2a}}, // \xe7\xaf\x9d
{0x7be0,{0x14,0x7b,0x56,0x34,0x7b,0x36,0x52}}, // \xe7\xaf\xa0
{0x7be4,{0x44,0x1b,0x56,0x1c,0x57,0x16,0x72}}, // \xe7\xaf\xa4
{0x7be5,{0x54,0x5f,0x36,0x7c,0x37,0x5e,0x56}}, // \xe7\xaf\xa5
{0x7be6,{0x44,0x7f,0x5e,0x1c,0x7f,0x5e,0x52}}, // \xe7\xaf\xa6
{0x7be9,{0x7c,0x6b,0x6e,0x34,0x17,0x7e,0x36}}, // \xe7\xaf\xa9
{0x7bed,{0x14,0x13,0x3e,0x34,0x7b,0x56,0x52}}, // \xe7\xaf\xad
{0x7bf3,{0x14,0x33,0x3e,0x7c,0x3f,0x32,0x12}}, // \xe7\xaf\xb3
{0x7bf6,{0x54,0x1b,0x52,0x1e,0x57,0x16,0x72}}, // \xe7\xaf\xb6
{0x7bf7,{0x54,0x33,0x46,0x54,0x5b,0x7e,0x52}}, // \xe7\xaf\xb7
{0x7c00,{0x4c,0x7b,0x3e,0x3c,0x3f,0x7a,0x4a}}, // \xe7\xb0\x80
{0x7c07,{0x4c,0x3b,0x6e,0x04,0x5b,0x36,0x52}}, // \xe7\xb0\x87
{0x7c0d,{0x54,0x5b,0x7e,0x5c,0x3f,0x5a,0x52}}, // \xe7\xb0\x8d
{0x7c11,{0x2c,0x2b,0x7e,0x54,0x3f,0x4a,0x4a}}, // \xe7\xb0\x91
{0x7c12,{0x54,0x33,0x5e,0x7c,0x3b,0x56,0x32}}, // \xe7\xb0\x92
{0x7c13,{0x44,0x3b,0x6e,0x7c,0x03,0x56,0x2a}}, // \xe7\xb0\x93
{0x7c14,{0x2c,0x2b,0x7e,0x5c,0x3f,0x4a,0x4a}}, // \xe7\xb0\x94
{0x7c17,{0x54,0x5b,0x36,0x74,0x3b,0x56,0x5e}}, // \xe7\xb0\x97
{0x7c1f,{0x24,0x2f,0x3e,0x6c,0x3f,0x2e,0x22}}, // \xe7\xb0\x9f
{0x7c21,{0x7c,0x1b,0x7e,0x64,0x7b,0x1e,0x7a}}, // \xe7\xb0\xa1
{0x7c23,{0x54,0x7f,0x36,0x3c,0x37,0x7e,0x52}}, // \xe7\xb0\xa3
{0x7c27,{0x4c,0x7b,0x2e,0x3c,0x2b,0x7e,0x4a}}, // \xe7\xb0\xa7
{0x7c2a,{0x14,0x6b,0x7e,0x74,0x6f,0x7e,0x12}}, // \xe7\xb0\xaa
{0x7c2b,{0x44,0x3b,0x6e,0x04,0x6f,0x2e,0x7a}}, // \xe7\xb0\xab
{0x7c37,{0x44,0x3f,0x2e,0x74,0x77,0x7e,0x2a}}, // \xe7\xb0\xb7
{0x7c38,{0x54,0x1b,0x56,0x3c,0x5b,0x2e,0x5a}}, // \xe7\xb0\xb8
{0x7c3d,{0x4c,0x3b,0x36,0x44,0x37,0x3a,0x4a}}, // \xe7\xb0\xbd
{0x7c3e,{0x44,0x3b,0x56,0x3c,0x7f,0x36,0x5e}}, // \xe7\xb0\xbe
{0x7c3f,{0x54,0x03,0x16,0x3c,0x5b,0x7e,0x12}}, // \xe7\xb0\xbf
{0x7c40,{0x54,0x7b,0x06,0x1c,0x77,0x6a,0x1a}}, // \xe7\xb1\x80
{0x7c43,{0x44,0x5b,0x7e,0x64,0x6b,0x4e,0x4a}}, // \xe7\xb1\x83
{0x7c4c,{0x14,0x77,0x7e,0x1c,0x5f,0x76,0x12}}, // \xe7\xb1\x8c
{0x7c4d,{0x54,0x33,0x7e,0x3c,0x6b,0x7e,0x2a}}, // \xe7\xb1\x8d
{0x7c4f,{0x4c,0x3b,0x6e,0x54,0x3f,0x3e,0x52}}, // \xe7\xb1\x8f
{0x7c50,{0x7c,0x2b,0x7e,0x34,0x7b,0x2e,0x52}}, // \xe7\xb1\x90
{0x7c54,{0x54,0x7b,0x5e,0x3c,0x53,0x2e,0x5a}}, // \xe7\xb1\x94
{0x7c56,{0x54,0x7b,0x7e,0x34,0x5b,0x36,0x52}}, // \xe7\xb1\x96
{0x7c58,{0x7c,0x2b,0x7e,0x2c,0x7b,0x3e,0x5a}}, // \xe7\xb1\x98
{0x7c5f,{0x44,0x2f,0x7e,0x2c,0x5b,0x1e,0x5a}}, // \xe7\xb1\x9f
{0x7c60,{0x14,0x7f,0x36,0x7c,0x13,0x6e,0x5a}}, // \xe7\xb1\xa0
{0x7c64,{0x54,0x7b,0x76,0x3c,0x5b,0x36,0x52}}, // \xe7\xb1\xa4
{0x7c65,{0x14,0x73,0x3e,0x74,0x3b,0x76,0x12}}, // \xe7\xb1\xa5
{0x7c6c,{0x74,0x5f,0x76,0x2c,0x7f,0x7e,0x52}}, // \xe7\xb1\xac
{0x7c73,{0x24,0x25,0x14,0x7f,0x14,0x25,0x24}}, // \xe7\xb1\xb3
{0x7c75,{0x35,0x7e,0x15,0x04,0x04,0x7f,0x04}}, // \xe7\xb1\xb5
{0x7c7e,{0x35,0x7e,0x15,0x49,0x3f,0x51,0x7f}}, // \xe7\xb1\xbe
{0x7c81,{0x35,0x7e,0x15,0x08,0x0a,0x7e,0x09}}, // \xe7\xb2\x81
{0x7c82,{0x48,0x5a,0x35,0x7d,0x35,0x5b,0x48}}, // \xe7\xb2\x82
{0x7c83,{0x35,0x7e,0x15,0x7f,0x24,0x7f,0x44}}, // \xe7\xb2\x83
{0x7c89,{0x35,0x7e,0x45,0x3b,0x48,0x7b,0x04}}, // \xe7\xb2\x89
{0x7c8b,{0x35,0x7e,0x2b,0x26,0x73,0x2e,0x28}}, // \xe7\xb2\x8b
{0x7c8d,{0x35,0x7e,0x15,0x2a,0x2a,0x7e,0x55}}, // \xe7\xb2\x8d
{0x7c90,{0x35,0x7e,0x15,0x40,0x3d,0x15,0x1d}}, // \xe7\xb2\x90
{0x7c92,{0x35,0x7e,0x43,0x7e,0x63,0x5e,0x42}}, // \xe7\xb2\x92
{0x7c95,{0x35,0x7e,0x15,0x7e,0x4b,0x4a,0x7e}}, // \xe7\xb2\x95
{0x7c97,{0x35,0x7e,0x41,0x7f,0x55,0x7f,0x40}}, // \xe7\xb2\x97
{0x7c98,{0x35,0x7e,0x15,0x70,0x5f,0x54,0x74}}, // \xe7\xb2\x98
{0x7c9b,{0x48,0x3a,0x2a,0x7f,0x2a,0x5e,0x74}}, // \xe7\xb2\x9b
{0x7c9f,{0x51,0x5b,0x33,0x7f,0x33,0x5b,0x51}}, // \xe7\xb2\x9f
{0x7ca1,{0x35,0x7e,0x01,0x7f,0x35,0x35,0x7f}}, // \xe7\xb2\xa1
{0x7ca2,{0x59,0x50,0x34,0x7b,0x36,0x5a,0x56}}, // \xe7\xb2\xa2
{0x7ca4,{0x10,0x1e,0x1a,0x5f,0x56,0x7e,0x10}}, // \xe7\xb2\xa4
{0x7ca5,{0x5d,0x77,0x2a,0x7f,0x2a,0x5d,0x77}}, // \xe7\xb2\xa5
{0x7ca7,{0x35,0x7e,0x55,0x3e,0x4a,0x7f,0x4a}}, // \xe7\xb2\xa7
{0x7ca8,{0x35,0x7e,0x01,0x7d,0x57,0x55,0x7d}}, // \xe7\xb2\xa8
{0x7cab,{0x35,0x7e,0x7d,0x07,0x7d,0x05,0x7d}}, // \xe7\xb2\xab
{0x7cad,{0x35,0x7e,0x15,0x00,0x76,0x55,0x76}}, // \xe7\xb2\xad
{0x7cae,{0x35,0x7e,0x15,0x7e,0x5a,0x3b,0x5e}}, // \xe7\xb2\xae
{0x7cb1,{0x55,0x50,0x39,0x77,0x39,0x5f,0x54}}, // \xe7\xb2\xb1
{0x7cb2,{0x54,0x5c,0x3b,0x76,0x3b,0x55,0x5b}}, // \xe7\xb2\xb2
{0x7cb3,{0x35,0x7e,0x41,0x57,0x3f,0x47,0x41}}, // \xe7\xb2\xb3
{0x7cb9,{0x35,0x7e,0x33,0x2e,0x73,0x2e,0x32}}, // \xe7\xb2\xb9
{0x7cbd,{0x35,0x7e,0x56,0x12,0x77,0x16,0x56}}, // \xe7\xb2\xbd
{0x7cbe,{0x35,0x7e,0x09,0x7a,0x2f,0x7a,0x08}}, // \xe7\xb2\xbe
{0x7cc0,{0x35,0x7e,0x12,0x7b,0x02,0x7f,0x52}}, // \xe7\xb3\x80
{0x7cc2,{0x35,0x7e,0x72,0x5f,0x72,0x5f,0x52}}, // \xe7\xb3\x82
{0x7cc5,{0x35,0x7e,0x5a,0x37,0x7f,0x33,0x56}}, // \xe7\xb3\x85
{0x7cca,{0x35,0x7e,0x3a,0x2f,0x7a,0x3f,0x7f}}, // \xe7\xb3\x8a
{0x7cce,{0x35,0x7e,0x15,0x4f,0x5d,0x7d,0x5d}}, // \xe7\xb3\x8e
{0x7cd2,{0x35,0x7e,0x1a,0x6f,0x2a,0x6f,0x6a}}, // \xe7\xb3\x92
{0x7cd6,{0x35,0x7e,0x3e,0x12,0x77,0x5e,0x6a}}, // \xe7\xb3\x96
{0x7cd8,{0x35,0x7e,0x26,0x5a,0x7b,0x2a,0x56}}, // \xe7\xb3\x98
{0x7cdc,{0x40,0x3e,0x56,0x3e,0x77,0x3e,0x56}}, // \xe7\xb3\x9c
{0x7cde,{0x2a,0x67,0x3a,0x3f,0x3a,0x67,0x2a}}, // \xe7\xb3\x9e
{0x7cdf,{0x35,0x7e,0x1a,0x7f,0x5a,0x7f,0x1a}}, // \xe7\xb3\x9f
{0x7ce0,{0x35,0x7e,0x3e,0x52,0x7f,0x2e,0x56}}, // \xe7\xb3\xa0
{0x7ce2,{0x35,0x7e,0x52,0x5f,0x36,0x5f,0x52}}, // \xe7\xb3\xa2
{0x7ce7,{0x35,0x7e,0x45,0x5f,0x7d,0x5f,0x44}}, // \xe7\xb3\xa7
{0x7cef,{0x35,0x7e,0x66,0x2b,0x7f,0x2b,0x66}}, // \xe7\xb3\xaf
{0x7cf2,{0x35,0x7e,0x25,0x1f,0x6d,0x3f,0x6d}}, // \xe7\xb3\xb2
{0x7cf4,{0x34,0x7b,0x14,0x21,0x7b,0x71,0x5b}}, // \xe7\xb3\xb4
{0x7cf6,{0x37,0x7e,0x17,0x21,0x7b,0x71,0x5b}}, // \xe7\xb3\xb6
{0x7cf8,{0x50,0x12,0x1a,0x75,0x14,0x0a,0x50}}, // \xe7\xb3\xb8
{0x7cfa,{0x2a,0x75,0x28,0x00,0x7f,0x40,0x60}}, // \xe7\xb3\xba
{0x7cfb,{0x50,0x15,0x15,0x7b,0x11,0x09,0x50}}, // \xe7\xb3\xbb
{0x7cfe,{0x2a,0x75,0x20,0x3e,0x20,0x7f,0x10}}, // \xe7\xb3\xbe
{0x7d00,{0x2a,0x75,0x28,0x79,0x49,0x49,0x6f}}, // \xe7\xb4\x80
{0x7d02,{0x2a,0x75,0x22,0x0a,0x52,0x7f,0x02}}, // \xe7\xb4\x82
{0x7d04,{0x2a,0x75,0x28,0x04,0x0b,0x52,0x7e}}, // \xe7\xb4\x84
{0x7d05,{0x2a,0x75,0x28,0x42,0x42,0x7e,0x42}}, // \xe7\xb4\x85
{0x7d06,{0x2a,0x75,0x28,0x09,0x49,0x7f,0x09}}, // \xe7\xb4\x86
{0x7d0a,{0x52,0x12,0x36,0x6b,0x36,0x12,0x52}}, // \xe7\xb4\x8a
{0x7d0b,{0x2a,0x75,0x42,0x2e,0x13,0x2e,0x42}}, // \xe7\xb4\x8b
{0x7d0d,{0x2a,0x75,0x7e,0x12,0x0f,0x52,0x7e}}, // \xe7\xb4\x8d
{0x7d10,{0x2a,0x75,0x49,0x7f,0x49,0x7f,0x48}}, // \xe7\xb4\x90
{0x7d14,{0x2a,0x75,0x1a,0x12,0x7f,0x52,0x5a}}, // \xe7\xb4\x94
{0x7d15,{0x2a,0x75,0x40,0x7f,0x24,0x7f,0x44}}, // \xe7\xb4\x95
{0x7d17,{0x2a,0x75,0x28,0x46,0x5f,0x22,0x14}}, // \xe7\xb4\x97
{0x7d18,{0x2a,0x75,0x22,0x5a,0x67,0x52,0x6a}}, // \xe7\xb4\x98
{0x7d19,{0x2a,0x75,0x28,0x7e,0x4a,0x3e,0x49}}, // \xe7\xb4\x99
{0x7d1a,{0x2a,0x75,0x21,0x5f,0x51,0x27,0x5c}}, // \xe7\xb4\x9a
{0x7d1b,{0x2a,0x75,0x44,0x3b,0x48,0x7b,0x04}}, // \xe7\xb4\x9b
{0x7d1c,{0x2a,0x75,0x28,0x44,0x65,0x5d,0x65}}, // \xe7\xb4\x9c
{0x7d20,{0x54,0x16,0x1e,0x77,0x16,0x0e,0x54}}, // \xe7\xb4\xa0
{0x7d21,{0x2a,0x75,0x28,0x42,0x3e,0x4b,0x7a}}, // \xe7\xb4\xa1
{0x7d22,{0x4c,0x16,0x1e,0x77,0x0e,0x16,0x4c}}, // \xe7\xb4\xa2
{0x7d2b,{0x4e,0x18,0x1f,0x7a,0x10,0x0f,0x5a}}, // \xe7\xb4\xab
{0x7d2c,{0x2a,0x75,0x7e,0x4a,0x7f,0x4a,0x7e}}, // \xe7\xb4\xac
{0x7d2e,{0x4a,0x16,0x1f,0x76,0x1f,0x18,0x4c}}, // \xe7\xb4\xae
{0x7d2f,{0x50,0x17,0x1d,0x77,0x15,0x0f,0x50}}, // \xe7\xb4\xaf
{0x7d30,{0x2a,0x75,0x28,0x7f,0x49,0x7f,0x7f}}, // \xe7\xb4\xb0
{0x7d32,{0x2a,0x75,0x7f,0x44,0x5f,0x54,0x5f}}, // \xe7\xb4\xb2
{0x7d33,{0x2a,0x75,0x3e,0x2a,0x7f,0x2a,0x3e}}, // \xe7\xb4\xb3
{0x7d35,{0x2a,0x75,0x28,0x06,0x4a,0x7b,0x0e}}, // \xe7\xb4\xb5
{0x7d39,{0x2a,0x75,0x28,0x75,0x53,0x59,0x7f}}, // \xe7\xb4\xb9
{0x7d3a,{0x2a,0x75,0x02,0x7f,0x4a,0x7f,0x02}}, // \xe7\xb4\xba
{0x7d3f,{0x2a,0x75,0x08,0x6c,0x6b,0x64,0x08}}, // \xe7\xb4\xbf
{0x7d42,{0x2a,0x75,0x28,0x0a,0x55,0x4b,0x08}}, // \xe7\xb5\x82
{0x7d43,{0x2a,0x75,0x4a,0x6e,0x53,0x2a,0x42}}, // \xe7\xb5\x83
{0x7d44,{0x2a,0x75,0x48,0x7f,0x55,0x7f,0x40}}, // \xe7\xb5\x84
{0x7d45,{0x2a,0x75,0x7f,0x1d,0x15,0x5d,0x7f}}, // \xe7\xb5\x85
{0x7d46,{0x2a,0x75,0x2a,0x29,0x7c,0x29,0x2a}}, // \xe7\xb5\x86
{0x7d4b,{0x2a,0x75,0x20,0x1e,0x62,0x5b,0x62}}, // \xe7\xb5\x8b
{0x7d4c,{0x2a,0x75,0x49,0x5b,0x75,0x5b,0x48}}, // \xe7\xb5\x8c
{0x7d4e,{0x2a,0x75,0x28,0x7d,0x00,0x45,0x7d}}, // \xe7\xb5\x8e
{0x7d4f,{0x2a,0x75,0x2e,0x4a,0x5f,0x2e,0x50}}, // \xe7\xb5\x8f
{0x7d50,{0x2a,0x75,0x02,0x6a,0x6f,0x6a,0x02}}, // \xe7\xb5\x90
{0x7d56,{0x2a,0x75,0x4a,0x38,0x0f,0x78,0x4a}}, // \xe7\xb5\x96
{0x7d5b,{0x04,0x7e,0x5f,0x1a,0x75,0x1b,0x50}}, // \xe7\xb5\x9b
{0x7d5e,{0x2a,0x75,0x4a,0x56,0x23,0x56,0x4a}}, // \xe7\xb5\x9e
{0x7d61,{0x2a,0x75,0x10,0x6a,0x65,0x6b,0x10}}, // \xe7\xb5\xa1
{0x7d62,{0x2a,0x75,0x2c,0x3f,0x2a,0x3e,0x7e}}, // \xe7\xb5\xa2
{0x7d63,{0x2a,0x75,0x54,0x3d,0x14,0x7d,0x14}}, // \xe7\xb5\xa3
{0x7d66,{0x2a,0x75,0x04,0x72,0x55,0x76,0x04}}, // \xe7\xb5\xa6
{0x7d68,{0x2a,0x75,0x0a,0x3e,0x4a,0x3f,0x52}}, // \xe7\xb5\xa8
{0x7d6e,{0x4a,0x1e,0x1b,0x76,0x1f,0x19,0x4f}}, // \xe7\xb5\xae
{0x7d71,{0x2a,0x75,0x4a,0x3e,0x0b,0x76,0x4a}}, // \xe7\xb5\xb1
{0x7d72,{0x2a,0x75,0x28,0x00,0x2a,0x75,0x28}}, // \xe7\xb5\xb2
{0x7d73,{0x2a,0x75,0x28,0x2a,0x35,0x7b,0x28}}, // \xe7\xb5\xb3
{0x7d75,{0x2a,0x75,0x54,0x72,0x55,0x36,0x54}}, // \xe7\xb5\xb5
{0x7d76,{0x2a,0x75,0x2a,0x7e,0x5d,0x57,0x5c}}, // \xe7\xb5\xb6
{0x7d79,{0x2a,0x75,0x28,0x78,0x2b,0x2b,0x78}}, // \xe7\xb5\xb9
{0x7d7d,{0x2a,0x75,0x28,0x77,0x5d,0x55,0x77}}, // \xe7\xb5\xbd
{0x7d89,{0x2a,0x75,0x5a,0x37,0x1f,0x37,0x6a}}, // \xe7\xb6\x89
{0x7d8f,{0x2a,0x75,0x52,0x71,0x5b,0x31,0x52}}, // \xe7\xb6\x8f
{0x7d93,{0x2a,0x75,0x28,0x55,0x5b,0x75,0x5b}}, // \xe7\xb6\x93
{0x7d99,{0x2a,0x75,0x28,0x7f,0x55,0x4e,0x55}}, // \xe7\xb6\x99
{0x7d9a,{0x2a,0x75,0x5a,0x2a,0x0f,0x6a,0x5a}}, // \xe7\xb6\x9a
{0x7d9b,{0x2a,0x75,0x69,0x2b,0x45,0x4b,0x6f}}, // \xe7\xb6\x9b
{0x7d9c,{0x2a,0x75,0x56,0x12,0x77,0x16,0x56}}, // \xe7\xb6\x9c
{0x7d9f,{0x2a,0x75,0x21,0x5f,0x55,0x3d,0x57}}, // \xe7\xb6\x9f
{0x7da2,{0x2a,0x75,0x7f,0x35,0x2f,0x35,0x7f}}, // \xe7\xb6\xa2
{0x7da3,{0x2a,0x75,0x16,0x6d,0x56,0x4d,0x16}}, // \xe7\xb6\xa3
{0x7dab,{0x2a,0x75,0x28,0x52,0x5b,0x36,0x5b}}, // \xe7\xb6\xab
{0x7dac,{0x2a,0x75,0x4d,0x57,0x35,0x57,0x4d}}, // \xe7\xb6\xac
{0x7dad,{0x2a,0x75,0x28,0x7f,0x4a,0x7f,0x4a}}, // \xe7\xb6\xad
{0x7dae,{0x49,0x17,0x15,0x77,0x1a,0x15,0x4b}}, // \xe7\xb6\xae
{0x7daf,{0x2a,0x75,0x64,0x4b,0x7e,0x6a,0x7e}}, // \xe7\xb6\xaf
{0x7db0,{0x2a,0x75,0x28,0x06,0x7a,0x5b,0x76}}, // \xe7\xb6\xb0
{0x7db1,{0x2a,0x75,0x7f,0x35,0x29,0x35,0x7f}}, // \xe7\xb6\xb1
{0x7db2,{0x2a,0x7d,0x7f,0x0d,0x39,0x2d,0x7f}}, // \xe7\xb6\xb2
{0x7db4,{0x2a,0x75,0x5d,0x2b,0x5d,0x2b,0x5d}}, // \xe7\xb6\xb4
{0x7db5,{0x2a,0x75,0x52,0x31,0x7b,0x31,0x52}}, // \xe7\xb6\xb5
{0x7db8,{0x2a,0x75,0x24,0x72,0x35,0x76,0x74}}, // \xe7\xb6\xb8
{0x7dba,{0x2a,0x75,0x12,0x5a,0x17,0x7a,0x12}}, // \xe7\xb6\xba
{0x7dbb,{0x2a,0x75,0x46,0x32,0x46,0x7f,0x56}}, // \xe7\xb6\xbb
{0x7dbd,{0x2a,0x75,0x20,0x3c,0x77,0x3e,0x22}}, // \xe7\xb6\xbd
{0x7dbe,{0x2a,0x75,0x28,0x5a,0x2f,0x5a,0x48}}, // \xe7\xb6\xbe
{0x7dbf,{0x2a,0x75,0x30,0x1e,0x7b,0x1e,0x30}}, // \xe7\xb6\xbf
{0x7dc7,{0x2a,0x75,0x28,0x7a,0x5d,0x7a,0x7d}}, // \xe7\xb7\x87
{0x7dca,{0x57,0x17,0x1d,0x70,0x1b,0x15,0x5b}}, // \xe7\xb7\x8a
{0x7dcb,{0x2a,0x75,0x2a,0x7f,0x00,0x7f,0x2a}}, // \xe7\xb7\x8b
{0x7dcf,{0x2a,0x75,0x6a,0x2d,0x48,0x45,0x6a}}, // \xe7\xb7\x8f
{0x7dd1,{0x2a,0x75,0x54,0x25,0x7d,0x27,0x54}}, // \xe7\xb7\x91
{0x7dd2,{0x2a,0x75,0x28,0x1a,0x6f,0x6a,0x69}}, // \xe7\xb7\x92
{0x7dd5,{0x2a,0x75,0x52,0x36,0x2b,0x76,0x12}}, // \xe7\xb7\x95
{0x7dd8,{0x2a,0x75,0x3e,0x6a,0x6a,0x3f,0x52}}, // \xe7\xb7\x98
{0x7dda,{0x2a,0x75,0x50,0x3e,0x7b,0x2e,0x50}}, // \xe7\xb7\x9a
{0x7ddc,{0x30,0x1e,0x7b,0x1e,0x35,0x7b,0x31}}, // \xe7\xb7\x9c
{0x7ddd,{0x2a,0x75,0x24,0x3f,0x2d,0x7f,0x24}}, // \xe7\xb7\x9d
{0x7dde,{0x2a,0x75,0x7e,0x15,0x5b,0x29,0x5b}}, // \xe7\xb7\x9e
{0x7de0,{0x2a,0x75,0x1a,0x6e,0x3b,0x6e,0x1a}}, // \xe7\xb7\xa0
{0x7de1,{0x2a,0x75,0x28,0x1f,0x75,0x6d,0x77}}, // \xe7\xb7\xa1
{0x7de4,{0x2a,0x75,0x5f,0x32,0x77,0x36,0x57}}, // \xe7\xb7\xa4
{0x7de8,{0x2a,0x75,0x21,0x1f,0x75,0x37,0x71}}, // \xe7\xb7\xa8
{0x7de9,{0x2a,0x75,0x46,0x2a,0x5e,0x29,0x5d}}, // \xe7\xb7\xa9
{0x7dec,{0x2a,0x75,0x28,0x7d,0x57,0x7d,0x7d}}, // \xe7\xb7\xac
{0x7def,{0x2a,0x75,0x28,0x3a,0x2f,0x7a,0x2e}}, // \xe7\xb7\xaf
{0x7df2,{0x2a,0x75,0x7f,0x55,0x7f,0x46,0x2f}}, // \xe7\xb7\xb2
{0x7df4,{0x2a,0x75,0x42,0x2e,0x7f,0x2e,0x42}}, // \xe7\xb7\xb4
{0x7dfb,{0x2a,0x75,0x2d,0x3b,0x69,0x3f,0x5e}}, // \xe7\xb7\xbb
{0x7e01,{0x2a,0x75,0x24,0x5d,0x75,0x27,0x54}}, // \xe7\xb8\x81
{0x7e04,{0x2a,0x75,0x08,0x3f,0x2d,0x77,0x5c}}, // \xe7\xb8\x84
{0x7e05,{0x2a,0x75,0x7e,0x2e,0x56,0x3f,0x52}}, // \xe7\xb8\x85
{0x7e09,{0x2a,0x75,0x0f,0x7d,0x59,0x7f,0x0d}}, // \xe7\xb8\x89
{0x7e0a,{0x2a,0x75,0x52,0x6d,0x64,0x6d,0x52}}, // \xe7\xb8\x8a
{0x7e0b,{0x2a,0x75,0x28,0x75,0x40,0x7e,0x77}}, // \xe7\xb8\x8b
{0x7e12,{0x2a,0x75,0x4a,0x3b,0x5e,0x7b,0x5a}}, // \xe7\xb8\x92
{0x7e1b,{0x2a,0x75,0x12,0x3e,0x5f,0x7e,0x13}}, // \xe7\xb8\x9b
{0x7e1e,{0x2a,0x75,0x72,0x1e,0x5b,0x1e,0x72}}, // \xe7\xb8\x9e
{0x7e1f,{0x2a,0x75,0x18,0x37,0x5f,0x7b,0x15}}, // \xe7\xb8\x9f
{0x7e21,{0x2a,0x75,0x2e,0x3a,0x6f,0x3a,0x2e}}, // \xe7\xb8\xa1
{0x7e22,{0x7f,0x15,0x7f,0x1d,0x76,0x0d,0x56}}, // \xe7\xb8\xa2
{0x7e23,{0x5e,0x17,0x77,0x50,0x15,0x7b,0x51}}, // \xe7\xb8\xa3
{0x7e26,{0x2a,0x75,0x0a,0x7d,0x23,0x7e,0x4b}}, // \xe7\xb8\xa6
{0x7e2b,{0x2a,0x75,0x48,0x39,0x5a,0x75,0x5b}}, // \xe7\xb8\xab
{0x7e2e,{0x2a,0x75,0x16,0x7a,0x0b,0x7a,0x6e}}, // \xe7\xb8\xae
{0x7e31,{0x2a,0x75,0x0a,0x7d,0x22,0x79,0x52}}, // \xe7\xb8\xb1
{0x7e32,{0x2a,0x75,0x57,0x1d,0x77,0x15,0x57}}, // \xe7\xb8\xb2
{0x7e35,{0x2a,0x75,0x4c,0x5f,0x2d,0x5f,0x4c}}, // \xe7\xb8\xb5
{0x7e37,{0x2a,0x75,0x54,0x7e,0x5b,0x3e,0x54}}, // \xe7\xb8\xb7
{0x7e39,{0x2a,0x75,0x51,0x17,0x77,0x17,0x51}}, // \xe7\xb8\xb9
{0x7e3a,{0x2a,0x75,0x28,0x75,0x5e,0x7f,0x52}}, // \xe7\xb8\xba
{0x7e3b,{0x40,0x3e,0x56,0x1e,0x77,0x0e,0x56}}, // \xe7\xb8\xbb
{0x7e3d,{0x2a,0x75,0x68,0x2e,0x4f,0x4e,0x6e}}, // \xe7\xb8\xbd
{0x7e3e,{0x2a,0x75,0x48,0x3a,0x3f,0x3a,0x48}}, // \xe7\xb8\xbe
{0x7e41,{0x4b,0x1e,0x1e,0x76,0x1a,0x15,0x4b}}, // \xe7\xb9\x81
{0x7e43,{0x2a,0x75,0x3b,0x7a,0x43,0x3a,0x7b}}, // \xe7\xb9\x83
{0x7e46,{0x2a,0x75,0x11,0x4b,0x54,0x29,0x13}}, // \xe7\xb9\x86
{0x7e4a,{0x2a,0x75,0x4a,0x7f,0x2a,0x3f,0x55}}, // \xe7\xb9\x8a
{0x7e4b,{0x4a,0x1e,0x1f,0x76,0x1b,0x15,0x4b}}, // \xe7\xb9\x8b
{0x7e4d,{0x2a,0x75,0x4a,0x3a,0x7f,0x2e,0x74}}, // \xe7\xb9\x8d
{0x7e54,{0x2a,0x75,0x0a,0x6f,0x6e,0x3f,0x55}}, // \xe7\xb9\x94
{0x7e55,{0x2a,0x75,0x2a,0x7b,0x6e,0x7b,0x2a}}, // \xe7\xb9\x95
{0x7e56,{0x2a,0x75,0x0a,0x7f,0x7e,0x23,0x5e}}, // \xe7\xb9\x96
{0x7e59,{0x2a,0x75,0x15,0x6f,0x7d,0x6f,0x15}}, // \xe7\xb9\x99
{0x7e5a,{0x2a,0x75,0x4a,0x1e,0x6b,0x1e,0x4a}}, // \xe7\xb9\x9a
{0x7e5d,{0x2a,0x75,0x7f,0x23,0x18,0x3b,0x7f}}, // \xe7\xb9\x9d
{0x7e5e,{0x2a,0x75,0x5c,0x3e,0x17,0x7e,0x5c}}, // \xe7\xb9\x9e
{0x7e66,{0x2a,0x75,0x5d,0x77,0x5b,0x7d,0x5b}}, // \xe7\xb9\xa6
{0x7e67,{0x2a,0x75,0x56,0x73,0x57,0x33,0x56}}, // \xe7\xb9\xa7
{0x7e69,{0x2a,0x75,0x1b,0x7f,0x41,0x7f,0x5b}}, // \xe7\xb9\xa9
{0x7e6a,{0x2a,0x75,0x1c,0x76,0x5d,0x76,0x1c}}, // \xe7\xb9\xaa
{0x7e6d,{0x7a,0x2a,0x5f,0x7a,0x2f,0x7a,0x7a}}, // \xe7\xb9\xad
{0x7e70,{0x2a,0x75,0x5c,0x37,0x7d,0x37,0x5c}}, // \xe7\xb9\xb0
{0x7e79,{0x2a,0x75,0x2b,0x3b,0x6f,0x3b,0x2b}}, // \xe7\xb9\xb9
{0x7e7b,{0x2a,0x75,0x66,0x2b,0x7f,0x2b,0x66}}, // \xe7\xb9\xbb
{0x7e7c,{0x2a,0x75,0x7f,0x6a,0x5d,0x6a,0x5d}}, // \xe7\xb9\xbc
{0x7e7d,{0x2a,0x75,0x4e,0x3a,0x37,0x3a,0x46}}, // \xe7\xb9\xbd
{0x7e7f,{0x2a,0x75,0x4f,0x69,0x60,0x6b,0x4a}}, // \xe7\xb9\xbf
{0x7e82,{0x54,0x13,0x3e,0x6c,0x2f,0x16,0x52}}, // \xe7\xba\x82
{0x7e83,{0x2a,0x75,0x4a,0x36,0x2b,0x76,0x0a}}, // \xe7\xba\x83
{0x7e88,{0x2a,0x75,0x2a,0x6f,0x6a,0x1f,0x5d}}, // \xe7\xba\x88
{0x7e89,{0x2a,0x75,0x4a,0x37,0x3a,0x37,0x4a}}, // \xe7\xba\x89
{0x7e8c,{0x2a,0x75,0x4e,0x3e,0x3b,0x3e,0x4e}}, // \xe7\xba\x8c
{0x7e8e,{0x2a,0x75,0x54,0x7f,0x54,0x3f,0x55}}, // \xe7\xba\x8e
{0x7e8f,{0x2a,0x75,0x3e,0x5a,0x6f,0x5e,0x5a}}, // \xe7\xba\x8f
{0x7e90,{0x2a,0x75,0x56,0x23,0x56,0x1f,0x5d}}, // \xe7\xba\x90
{0x7e92,{0x2a,0x75,0x20,0x5f,0x4b,0x63,0x49}}, // \xe7\xba\x92
{0x7e93,{0x2a,0x75,0x57,0x7b,0x54,0x33,0x57}}, // \xe7\xba\x93
{0x7e94,{0x2a,0x75,0x28,0x52,0x2d,0x7f,0x56}}, // \xe7\xba\x94
{0x7e96,{0x2a,0x75,0x55,0x7e,0x55,0x3f,0x55}}, // \xe7\xba\x96
{0x7e9b,{0x34,0x7e,0x3e,0x4f,0x3e,0x6e,0x34}}, // \xe7\xba\x9b
{0x7e9c,{0x2a,0x75,0x47,0x3d,0x38,0x7f,0x46}}, // \xe7\xba\x9c
{0x7f36,{0x08,0x6c,0x4b,0x7e,0x4a,0x6a,0x08}}, // \xe7\xbc\xb6
{0x7f38,{0x6c,0x4b,0x7e,0x6a,0x42,0x7e,0x42}}, // \xe7\xbc\xb8
{0x7f3a,{0x6c,0x4b,0x7e,0x6a,0x4a,0x3f,0x4e}}, // \xe7\xbc\xba
{0x7f45,{0x6b,0x7e,0x6a,0x3c,0x54,0x7f,0x1a}}, // \xe7\xbd\x85
{0x7f4c,{0x14,0x73,0x5b,0x7c,0x5b,0x7b,0x14}}, // \xe7\xbd\x8c
{0x7f4d,{0x1c,0x7c,0x5f,0x7b,0x5f,0x7c,0x1c}}, // \xe7\xbd\x8d
{0x7f4e,{0x6b,0x7e,0x4a,0x6c,0x57,0x3f,0x4c}}, // \xe7\xbd\x8e
{0x7f50,{0x6b,0x7e,0x26,0x7f,0x52,0x7f,0x56}}, // \xe7\xbd\x90
{0x7f51,{0x7f,0x25,0x19,0x25,0x19,0x25,0x7f}}, // \xe7\xbd\x91
{0x7f54,{0x7f,0x15,0x77,0x5d,0x57,0x15,0x7f}}, // \xe7\xbd\x94
{0x7f55,{0x23,0x25,0x2b,0x79,0x2f,0x25,0x23}}, // \xe7\xbd\x95
{0x7f58,{0x57,0x55,0x37,0x75,0x17,0x35,0x57}}, // \xe7\xbd\x98
{0x7f5f,{0x17,0x75,0x57,0x5d,0x57,0x75,0x17}}, // \xe7\xbd\x9f
{0x7f60,{0x47,0x7d,0x57,0x15,0x37,0x5d,0x57}}, // \xe7\xbd\xa0
{0x7f67,{0x57,0x35,0x7f,0x55,0x37,0x7d,0x57}}, // \xe7\xbd\xa7
{0x7f68,{0x17,0x0d,0x37,0x3d,0x77,0x4d,0x57}}, // \xe7\xbd\xa8
{0x7f69,{0x27,0x35,0x37,0x7d,0x3f,0x2d,0x27}}, // \xe7\xbd\xa9
{0x7f6a,{0x2b,0x6b,0x3f,0x03,0x7f,0x2b,0x2b}}, // \xe7\xbd\xaa
{0x7f6b,{0x57,0x7d,0x57,0x05,0x7f,0x15,0x27}}, // \xe7\xbd\xab
{0x7f6e,{0x77,0x45,0x7f,0x55,0x57,0x7d,0x47}}, // \xe7\xbd\xae
{0x7f70,{0x67,0x6d,0x6f,0x05,0x1f,0x45,0x7f}}, // \xe7\xbd\xb0
{0x7f72,{0x57,0x55,0x3f,0x7d,0x5f,0x75,0x17}}, // \xe7\xbd\xb2
{0x7f75,{0x47,0x1d,0x57,0x1d,0x57,0x15,0x77}}, // \xe7\xbd\xb5
{0x7f77,{0x17,0x7d,0x37,0x7d,0x07,0x7d,0x57}}, // \xe7\xbd\xb7
{0x7f78,{0x6f,0x6d,0x17,0x35,0x57,0x7d,0x17}}, // \xe7\xbd\xb8
{0x7f79,{0x37,0x7d,0x07,0x7d,0x57,0x7d,0x57}}, // \xe7\xbd\xb9
{0x7f82,{0x2f,0x75,0x27,0x75,0x3f,0x3d,0x77}}, // \xe7\xbe\x82
{0x7f83,{0x57,0x35,0x7f,0x7d,0x3f,0x75,0x37}}, // \xe7\xbe\x83
{0x7f85,{0x2f,0x75,0x27,0x7d,0x57,0x7d,0x57}}, // \xe7\xbe\x85
{0x7f86,{0x47,0x1d,0x4f,0x1d,0x47,0x1d,0x57}}, // \xe7\xbe\x86
{0x7f87,{0x2f,0x75,0x2f,0x55,0x1f,0x7d,0x17}}, // \xe7\xbe\x87
{0x7f88,{0x2f,0x75,0x2f,0x45,0x1f,0x5d,0x77}}, // \xe7\xbe\x88
{0x7f8a,{0x22,0x2a,0x2b,0x7e,0x2a,0x2b,0x22}}, // \xe7\xbe\x8a
{0x7f8c,{0x52,0x56,0x37,0x1e,0x76,0x57,0x52}}, // \xe7\xbe\x8c
{0x7f8e,{0x52,0x56,0x57,0x3e,0x56,0x57,0x52}}, // \xe7\xbe\x8e
{0x7f94,{0x52,0x16,0x57,0x1e,0x56,0x17,0x52}}, // \xe7\xbe\x94
{0x7f9a,{0x55,0x3e,0x15,0x12,0x75,0x16,0x34}}, // \xe7\xbe\x9a
{0x7f9d,{0x55,0x3e,0x15,0x7e,0x4a,0x5e,0x69}}, // \xe7\xbe\x9d
{0x7f9e,{0x4a,0x3a,0x5b,0x7e,0x5a,0x7b,0x4a}}, // \xe7\xbe\x9e
{0x7fa3,{0x2a,0x2a,0x37,0x7f,0x3b,0x2b,0x2e}}, // \xe7\xbe\xa3
{0x7fa4,{0x25,0x7f,0x75,0x6f,0x2b,0x7e,0x2b}}, // \xe7\xbe\xa4
{0x7fa8,{0x5a,0x0a,0x4b,0x5e,0x3a,0x5b,0x4a}}, // \xe7\xbe\xa8
{0x7fa9,{0x2a,0x2a,0x7b,0x2e,0x7a,0x2b,0x5a}}, // \xe7\xbe\xa9
{0x7fae,{0x4a,0x56,0x5f,0x36,0x5e,0x57,0x4a}}, // \xe7\xbe\xae
{0x7faf,{0x55,0x3e,0x15,0x3f,0x2d,0x4f,0x78}}, // \xe7\xbe\xaf
{0x7fb2,{0x0a,0x5a,0x7b,0x2e,0x7a,0x2b,0x5a}}, // \xe7\xbe\xb2
{0x7fb6,{0x55,0x3e,0x15,0x4e,0x7e,0x7b,0x4e}}, // \xe7\xbe\xb6
{0x7fb8,{0x42,0x3e,0x7a,0x6b,0x3a,0x7a,0x72}}, // \xe7\xbe\xb8
{0x7fb9,{0x4a,0x56,0x7f,0x36,0x7e,0x57,0x4a}}, // \xe7\xbe\xb9
{0x7fbd,{0x21,0x25,0x51,0x7f,0x25,0x51,0x7f}}, // \xe7\xbe\xbd
{0x7fc1,{0x4a,0x5a,0x2d,0x78,0x59,0x2a,0x7a}}, // \xe7\xbf\x81
{0x7fc5,{0x5a,0x2f,0x5a,0x55,0x7f,0x55,0x7f}}, // \xe7\xbf\x85
{0x7fc6,{0x21,0x35,0x2f,0x64,0x3d,0x31,0x3b}}, // \xe7\xbf\x86
{0x7fca,{0x2e,0x33,0x2e,0x15,0x7f,0x15,0x7f}}, // \xe7\xbf\x8a
{0x7fcc,{0x49,0x5b,0x75,0x5f,0x7b,0x55,0x4f}}, // \xe7\xbf\x8c
{0x7fd2,{0x09,0x6b,0x75,0x6f,0x6b,0x65,0x0f}}, // \xe7\xbf\x92
{0x7fd4,{0x55,0x3e,0x29,0x15,0x7f,0x15,0x7f}}, // \xe7\xbf\x94
{0x7fd5,{0x54,0x34,0x7e,0x0d,0x5e,0x34,0x74}}, // \xe7\xbf\x95
{0x7fe0,{0x29,0x3b,0x2d,0x7f,0x2b,0x3d,0x2f}}, // \xe7\xbf\xa0
{0x7fe1,{0x2a,0x5a,0x2f,0x78,0x5f,0x2a,0x7a}}, // \xe7\xbf\xa1
{0x7fe6,{0x52,0x3e,0x77,0x0e,0x52,0x3f,0x72}}, // \xe7\xbf\xa6
{0x7fe9,{0x7d,0x35,0x70,0x15,0x7f,0x15,0x7f}}, // \xe7\xbf\xa9
{0x7feb,{0x05,0x6f,0x75,0x6f,0x44,0x3d,0x45}}, // \xe7\xbf\xab
{0x7ff0,{0x2d,0x77,0x4d,0x2a,0x79,0x2a,0x7c}}, // \xe7\xbf\xb0
{0x7ff3,{0x5f,0x37,0x7d,0x15,0x5b,0x35,0x7b}}, // \xe7\xbf\xb3
{0x7ff9,{0x5e,0x37,0x7e,0x55,0x7f,0x55,0x7f}}, // \xe7\xbf\xb9
{0x7ffb,{0x15,0x6f,0x7f,0x35,0x7f,0x35,0x7f}}, // \xe7\xbf\xbb
{0x7ffc,{0x51,0x5b,0x15,0x1f,0x1b,0x55,0x57}}, // \xe7\xbf\xbc
{0x8000,{0x4a,0x38,0x3f,0x2a,0x75,0x7f,0x57}}, // \xe8\x80\x80
{0x8001,{0x28,0x2a,0x1a,0x7f,0x5e,0x5a,0x49}}, // \xe8\x80\x81
{0x8003,{0x28,0x2a,0x1a,0x3f,0x2e,0x2a,0x69}}, // \xe8\x80\x83
{0x8004,{0x28,0x2a,0x36,0x7f,0x5a,0x59,0x48}}, // \xe8\x80\x84
{0x8005,{0x28,0x2a,0x1a,0x6f,0x6e,0x6a,0x09}}, // \xe8\x80\x85
{0x8006,{0x14,0x16,0x6e,0x7f,0x76,0x75,0x14}}, // \xe8\x80\x86
{0x800b,{0x48,0x5a,0x56,0x7f,0x5a,0x59,0x48}}, // \xe8\x80\x8b
{0x800c,{0x7d,0x05,0x7d,0x07,0x7d,0x05,0x7d}}, // \xe8\x80\x8c
{0x8010,{0x7d,0x07,0x7d,0x05,0x7d,0x1a,0x7f}}, // \xe8\x80\x90
{0x8012,{0x52,0x56,0x36,0x7f,0x36,0x55,0x50}}, // \xe8\x80\x92
{0x8015,{0x2a,0x7f,0x52,0x3f,0x12,0x7f,0x12}}, // \xe8\x80\x95
{0x8017,{0x2a,0x7f,0x2a,0x2a,0x7e,0x55,0x54}}, // \xe8\x80\x97
{0x8018,{0x2a,0x7f,0x29,0x44,0x65,0x5d,0x65}}, // \xe8\x80\x98
{0x8019,{0x2a,0x7f,0x29,0x7f,0x49,0x4f,0x6f}}, // \xe8\x80\x99
{0x801c,{0x2a,0x7f,0x29,0x7f,0x55,0x57,0x70}}, // \xe8\x80\x9c
{0x8021,{0x2a,0x7f,0x3f,0x2a,0x7e,0x1f,0x7c}}, // \xe8\x80\xa1
{0x8028,{0x2a,0x7f,0x18,0x37,0x5f,0x7b,0x15}}, // \xe8\x80\xa8
{0x8033,{0x21,0x21,0x3f,0x2d,0x2d,0x7f,0x21}}, // \xe8\x80\xb3
{0x8036,{0x21,0x3f,0x2d,0x7f,0x01,0x7f,0x1b}}, // \xe8\x80\xb6
{0x803b,{0x21,0x3f,0x7f,0x7c,0x40,0x7f,0x44}}, // \xe8\x80\xbb
{0x803d,{0x21,0x3f,0x7f,0x46,0x3f,0x72,0x46}}, // \xe8\x80\xbd
{0x803f,{0x21,0x3f,0x7f,0x4c,0x40,0x3f,0x44}}, // \xe8\x80\xbf
{0x8046,{0x21,0x3f,0x7f,0x12,0x75,0x16,0x34}}, // \xe8\x81\x86
{0x804a,{0x21,0x3f,0x7f,0x5e,0x31,0x7e,0x1e}}, // \xe8\x81\x8a
{0x8052,{0x21,0x3f,0x7f,0x04,0x76,0x5e,0x75}}, // \xe8\x81\x92
{0x8056,{0x45,0x57,0x57,0x7d,0x57,0x55,0x47}}, // \xe8\x81\x96
{0x8058,{0x21,0x3f,0x7f,0x08,0x1e,0x5f,0x6e}}, // \xe8\x81\x98
{0x805a,{0x45,0x57,0x2f,0x75,0x2b,0x55,0x4b}}, // \xe8\x81\x9a
{0x805e,{0x7f,0x2b,0x3b,0x38,0x7b,0x0b,0x7f}}, // \xe8\x81\x9e
{0x805f,{0x24,0x2b,0x36,0x2a,0x2e,0x7a,0x2e}}, // \xe8\x81\x9f
{0x8061,{0x21,0x3f,0x7f,0x6a,0x2d,0x48,0x6b}}, // \xe8\x81\xa1
{0x8062,{0x21,0x3f,0x7f,0x32,0x46,0x7f,0x56}}, // \xe8\x81\xa2
{0x8068,{0x21,0x3f,0x7f,0x52,0x3d,0x7a,0x15}}, // \xe8\x81\xa8
{0x806f,{0x21,0x3f,0x7f,0x5a,0x35,0x7a,0x35}}, // \xe8\x81\xaf
{0x8070,{0x21,0x3f,0x7f,0x6e,0x2f,0x4e,0x6e}}, // \xe8\x81\xb0
{0x8072,{0x2a,0x26,0x37,0x32,0x3b,0x75,0x2b}}, // \xe8\x81\xb2
{0x8073,{0x2a,0x2d,0x3a,0x29,0x2e,0x7d,0x2a}}, // \xe8\x81\xb3
{0x8074,{0x21,0x3f,0x7f,0x62,0x2e,0x4f,0x6e}}, // \xe8\x81\xb4
{0x8076,{0x2c,0x3d,0x7f,0x07,0x2f,0x3d,0x7c}}, // \xe8\x81\xb6
{0x8077,{0x21,0x3f,0x7f,0x6b,0x4e,0x3f,0x55}}, // \xe8\x81\xb7
{0x8079,{0x21,0x3f,0x7f,0x16,0x5e,0x7b,0x16}}, // \xe8\x81\xb9
{0x807d,{0x29,0x3f,0x7f,0x6a,0x2e,0x4f,0x6e}}, // \xe8\x81\xbd
{0x807e,{0x2a,0x3e,0x2b,0x3e,0x32,0x7b,0x2d}}, // \xe8\x81\xbe
{0x807f,{0x28,0x2a,0x2a,0x7f,0x2a,0x2e,0x24}}, // \xe8\x81\xbf
{0x8084,{0x57,0x3a,0x5a,0x20,0x2a,0x7f,0x2e}}, // \xe8\x82\x84
{0x8085,{0x48,0x3a,0x6e,0x07,0x6e,0x2e,0x74}}, // \xe8\x82\x85
{0x8086,{0x50,0x7f,0x55,0x71,0x2a,0x7f,0x2e}}, // \xe8\x82\x86
{0x8087,{0x29,0x37,0x35,0x77,0x3b,0x35,0x2b}}, // \xe8\x82\x87
{0x8089,{0x7e,0x02,0x2a,0x17,0x2a,0x42,0x7e}}, // \xe8\x82\x89
{0x808b,{0x7f,0x15,0x7f,0x42,0x3f,0x42,0x7e}}, // \xe8\x82\x8b
{0x808c,{0x7f,0x15,0x7f,0x3f,0x01,0x7f,0x40}}, // \xe8\x82\x8c
{0x8093,{0x02,0x7e,0x2a,0x2b,0x2a,0x7a,0x02}}, // \xe8\x82\x93
{0x8096,{0x00,0x7d,0x16,0x17,0x14,0x56,0x7d}}, // \xe8\x82\x96
{0x8098,{0x7f,0x15,0x7f,0x0a,0x52,0x7f,0x02}}, // \xe8\x82\x98
{0x809a,{0x7f,0x15,0x7f,0x40,0x44,0x7f,0x44}}, // \xe8\x82\x9a
{0x809b,{0x7f,0x15,0x7f,0x40,0x42,0x7e,0x42}}, // \xe8\x82\x9b
{0x809d,{0x7f,0x15,0x7f,0x08,0x09,0x7f,0x09}}, // \xe8\x82\x9d
{0x80a1,{0x7f,0x15,0x7f,0x40,0x5b,0x29,0x5b}}, // \xe8\x82\xa1
{0x80a2,{0x7f,0x15,0x7f,0x42,0x5a,0x2f,0x5a}}, // \xe8\x82\xa2
{0x80a5,{0x7f,0x15,0x7f,0x49,0x4f,0x49,0x6f}}, // \xe8\x82\xa5
{0x80a9,{0x41,0x3f,0x05,0x7d,0x2d,0x7f,0x01}}, // \xe8\x82\xa9
{0x80aa,{0x7f,0x15,0x7f,0x42,0x3e,0x4b,0x7a}}, // \xe8\x82\xaa
{0x80ac,{0x7f,0x15,0x7f,0x42,0x3f,0x7a,0x43}}, // \xe8\x82\xac
{0x80ad,{0x7f,0x15,0x7f,0x7c,0x15,0x4f,0x7c}}, // \xe8\x82\xad
{0x80af,{0x08,0x7e,0x28,0x2f,0x2a,0x7a,0x08}}, // \xe8\x82\xaf
{0x80b1,{0x7f,0x15,0x7f,0x4a,0x67,0x52,0x6a}}, // \xe8\x82\xb1
{0x80b2,{0x0a,0x7a,0x2e,0x2b,0x2a,0x76,0x0a}}, // \xe8\x82\xb2
{0x80b4,{0x28,0x19,0x7d,0x2a,0x2a,0x7d,0x08}}, // \xe8\x82\xb4
{0x80ba,{0x7f,0x15,0x7f,0x3a,0x0a,0x7f,0x3a}}, // \xe8\x82\xba
{0x80c3,{0x07,0x7d,0x2d,0x2f,0x2d,0x7d,0x07}}, // \xe8\x83\x83
{0x80c4,{0x0e,0x7a,0x2a,0x2f,0x2a,0x7a,0x0e}}, // \xe8\x83\x84
{0x80c6,{0x7f,0x15,0x7f,0x00,0x5f,0x55,0x5f}}, // \xe8\x83\x86
{0x80cc,{0x0a,0x7a,0x2f,0x28,0x2f,0x7a,0x0a}}, // \xe8\x83\x8c
{0x80ce,{0x7f,0x15,0x7f,0x08,0x6c,0x6b,0x6c}}, // \xe8\x83\x8e
{0x80d6,{0x7f,0x15,0x7f,0x2a,0x29,0x7c,0x29}}, // \xe8\x83\x96
{0x80d9,{0x7f,0x15,0x7f,0x04,0x7f,0x2a,0x2a}}, // \xe8\x83\x99
{0x80da,{0x7f,0x15,0x7f,0x49,0x45,0x7f,0x49}}, // \xe8\x83\x9a
{0x80db,{0x7f,0x15,0x7f,0x1f,0x15,0x7f,0x1f}}, // \xe8\x83\x9b
{0x80dd,{0x7f,0x15,0x7f,0x7e,0x4a,0x5e,0x69}}, // \xe8\x83\x9d
{0x80de,{0x7f,0x15,0x7f,0x04,0x73,0x56,0x5e}}, // \xe8\x83\x9e
{0x80e1,{0x3a,0x2f,0x3a,0x40,0x3f,0x55,0x7f}}, // \xe8\x83\xa1
{0x80e4,{0x40,0x3f,0x7a,0x2d,0x78,0x7f,0x40}}, // \xe8\x83\xa4
{0x80e5,{0x09,0x75,0x29,0x2f,0x2b,0x79,0x0b}}, // \xe8\x83\xa5
{0x80ef,{0x7f,0x15,0x7f,0x0a,0x1e,0x57,0x6a}}, // \xe8\x83\xaf
{0x80f1,{0x7f,0x15,0x7f,0x4a,0x38,0x7f,0x4a}}, // \xe8\x83\xb1
{0x80f4,{0x7f,0x15,0x7f,0x7f,0x35,0x35,0x7f}}, // \xe8\x83\xb4
{0x80f8,{0x7f,0x15,0x7f,0x34,0x2b,0x36,0x7e}}, // \xe8\x83\xb8
{0x80fc,{0x7f,0x15,0x7f,0x54,0x3d,0x14,0x7d}}, // \xe8\x83\xbc
{0x80fd,{0x04,0x7e,0x2d,0x7e,0x00,0x7f,0x5a}}, // \xe8\x83\xbd
{0x8102,{0x7f,0x15,0x7f,0x00,0x6f,0x6a,0x6d}}, // \xe8\x84\x82
{0x8105,{0x28,0x1a,0x6e,0x3b,0x2a,0x7e,0x18}}, // \xe8\x84\x85
{0x8106,{0x7f,0x15,0x7f,0x3e,0x7d,0x4f,0x5c}}, // \xe8\x84\x86
{0x8107,{0x7f,0x15,0x7f,0x22,0x77,0x22,0x76}}, // \xe8\x84\x87
{0x8108,{0x7f,0x15,0x7f,0x7a,0x0a,0x35,0x54}}, // \xe8\x84\x88
{0x8109,{0x7f,0x15,0x7f,0x28,0x5d,0x7d,0x28}}, // \xe8\x84\x89
{0x810a,{0x15,0x75,0x28,0x2f,0x28,0x75,0x15}}, // \xe8\x84\x8a
{0x811a,{0x7f,0x15,0x7f,0x6a,0x5f,0x7f,0x1f}}, // \xe8\x84\x9a
{0x811b,{0x7f,0x15,0x7f,0x55,0x5b,0x75,0x5b}}, // \xe8\x84\x9b
{0x8123,{0x08,0x77,0x3f,0x3b,0x37,0x7b,0x09}}, // \xe8\x84\xa3
{0x8129,{0x04,0x7e,0x3f,0x7a,0x2d,0x7b,0x08}}, // \xe8\x84\xa9
{0x812f,{0x7f,0x15,0x7f,0x7a,0x7f,0x2a,0x7b}}, // \xe8\x84\xaf
{0x8131,{0x7f,0x15,0x7f,0x4e,0x3b,0x7a,0x4f}}, // \xe8\x84\xb1
{0x8133,{0x7f,0x15,0x7f,0x75,0x49,0x54,0x7b}}, // \xe8\x84\xb3
{0x8139,{0x7f,0x15,0x7f,0x10,0x7f,0x35,0x51}}, // \xe8\x84\xb9
{0x813e,{0x7f,0x15,0x7f,0x2e,0x3f,0x7a,0x2e}}, // \xe8\x84\xbe
{0x8146,{0x7f,0x15,0x7f,0x5e,0x1f,0x1a,0x5f}}, // \xe8\x85\x86
{0x814b,{0x7f,0x15,0x7f,0x12,0x7e,0x2b,0x5a}}, // \xe8\x85\x8b
{0x814e,{0x07,0x77,0x35,0x30,0x3b,0x75,0x0b}}, // \xe8\x85\x8e
{0x8150,{0x40,0x3e,0x7a,0x56,0x3b,0x5e,0x72}}, // \xe8\x85\x90
{0x8151,{0x7f,0x15,0x7f,0x3e,0x7a,0x13,0x7a}}, // \xe8\x85\x91
{0x8153,{0x7f,0x15,0x7f,0x2a,0x7f,0x7f,0x2a}}, // \xe8\x85\x93
{0x8154,{0x7f,0x15,0x7f,0x46,0x56,0x73,0x56}}, // \xe8\x85\x94
{0x8155,{0x7f,0x15,0x7f,0x56,0x2a,0x7b,0x5e}}, // \xe8\x85\x95
{0x815f,{0x7f,0x15,0x7f,0x56,0x5a,0x6b,0x56}}, // \xe8\x85\x9f
{0x8165,{0x7f,0x15,0x7f,0x48,0x57,0x7d,0x57}}, // \xe8\x85\xa5
{0x8166,{0x7f,0x15,0x7f,0x7a,0x6d,0x5a,0x7d}}, // \xe8\x85\xa6
{0x816b,{0x7f,0x15,0x7f,0x44,0x5e,0x7e,0x5d}}, // \xe8\x85\xab
{0x816e,{0x7f,0x15,0x7f,0x6f,0x2d,0x4f,0x6f}}, // \xe8\x85\xae
{0x8170,{0x7f,0x15,0x7f,0x51,0x7f,0x37,0x51}}, // \xe8\x85\xb0
{0x8171,{0x7f,0x15,0x7f,0x49,0x37,0x4a,0x5f}}, // \xe8\x85\xb1
{0x8174,{0x7f,0x15,0x7f,0x5e,0x55,0x3e,0x5e}}, // \xe8\x85\xb4
{0x8178,{0x7f,0x15,0x7f,0x24,0x5f,0x35,0x77}}, // \xe8\x85\xb8
{0x8179,{0x7f,0x15,0x7f,0x53,0x2e,0x5e,0x42}}, // \xe8\x85\xb9
{0x817a,{0x7f,0x15,0x7f,0x3e,0x7b,0x2e,0x50}}, // \xe8\x85\xba
{0x817f,{0x7f,0x15,0x7f,0x79,0x50,0x4f,0x57}}, // \xe8\x85\xbf
{0x8180,{0x7f,0x15,0x7f,0x4e,0x3b,0x6e,0x1a}}, // \xe8\x86\x80
{0x8182,{0x0a,0x77,0x3e,0x34,0x3f,0x76,0x0a}}, // \xe8\x86\x82
{0x8183,{0x7f,0x15,0x7f,0x4f,0x6d,0x6b,0x4f}}, // \xe8\x86\x83
{0x8188,{0x7f,0x15,0x7f,0x79,0x2f,0x6f,0x79}}, // \xe8\x86\x88
{0x818a,{0x7f,0x15,0x7f,0x3e,0x57,0x7e,0x13}}, // \xe8\x86\x8a
{0x818f,{0x1a,0x6e,0x3a,0x3b,0x3a,0x6e,0x1a}}, // \xe8\x86\x8f
{0x8193,{0x7f,0x15,0x7f,0x24,0x5f,0x3e,0x72}}, // \xe8\x86\x93
{0x8195,{0x7f,0x15,0x7f,0x6d,0x4f,0x55,0x7f}}, // \xe8\x86\x95
{0x819a,{0x40,0x3c,0x04,0x7c,0x3f,0x3a,0x7a}}, // \xe8\x86\x9a
{0x819c,{0x7f,0x15,0x7f,0x52,0x5f,0x3e,0x53}}, // \xe8\x86\x9c
{0x819d,{0x7f,0x15,0x7f,0x2a,0x56,0x7f,0x2a}}, // \xe8\x86\x9d
{0x81a0,{0x7f,0x15,0x7f,0x11,0x4b,0x55,0x2b}}, // \xe8\x86\xa0
{0x81a3,{0x7f,0x15,0x7f,0x06,0x5a,0x77,0x56}}, // \xe8\x86\xa3
{0x81a4,{0x7f,0x15,0x7f,0x06,0x53,0x77,0x26}}, // \xe8\x86\xa4
{0x81a8,{0x7f,0x15,0x7f,0x5a,0x7f,0x4a,0x25}}, // \xe8\x86\xa8
{0x81a9,{0x7f,0x15,0x7f,0x36,0x72,0x3f,0x42}}, // \xe8\x86\xa9
{0x81b0,{0x7f,0x15,0x7f,0x15,0x6f,0x7f,0x15}}, // \xe8\x86\xb0
{0x81b3,{0x7f,0x15,0x7f,0x2a,0x7b,0x6e,0x7b}}, // \xe8\x86\xb3
{0x81b5,{0x7f,0x15,0x7f,0x2f,0x72,0x2f,0x32}}, // \xe8\x86\xb5
{0x81b8,{0x7f,0x15,0x7f,0x65,0x4a,0x7f,0x7a}}, // \xe8\x86\xb8
{0x81ba,{0x40,0x3e,0x0e,0x72,0x3f,0x3e,0x7a}}, // \xe8\x86\xba
{0x81bd,{0x7f,0x15,0x7f,0x3e,0x75,0x7f,0x2c}}, // \xe8\x86\xbd
{0x81be,{0x7f,0x15,0x7f,0x16,0x7d,0x76,0x1c}}, // \xe8\x86\xbe
{0x81bf,{0x7f,0x15,0x7f,0x76,0x57,0x36,0x57}}, // \xe8\x86\xbf
{0x81c0,{0x08,0x77,0x3b,0x37,0x3b,0x75,0x0b}}, // \xe8\x87\x80
{0x81c2,{0x04,0x7f,0x3b,0x30,0x36,0x7b,0x06}}, // \xe8\x87\x82
{0x81c6,{0x7f,0x15,0x7f,0x6e,0x3b,0x5e,0x6a}}, // \xe8\x87\x86
{0x81c8,{0x7f,0x15,0x7f,0x32,0x2f,0x4e,0x7b}}, // \xe8\x87\x88
{0x81c9,{0x7f,0x15,0x7f,0x36,0x5d,0x36,0x5c}}, // \xe8\x87\x89
{0x81cd,{0x7f,0x15,0x7f,0x36,0x2b,0x76,0x0a}}, // \xe8\x87\x8d
{0x81d1,{0x7f,0x15,0x7f,0x66,0x2b,0x7f,0x6e}}, // \xe8\x87\x91
{0x81d3,{0x7f,0x15,0x7f,0x7b,0x4a,0x3f,0x4a}}, // \xe8\x87\x93
{0x81d8,{0x7f,0x15,0x7f,0x72,0x5d,0x2e,0x7d}}, // \xe8\x87\x98
{0x81d9,{0x7f,0x15,0x7f,0x52,0x1f,0x56,0x5f}}, // \xe8\x87\x99
{0x81da,{0x7f,0x15,0x7f,0x5c,0x64,0x6f,0x4a}}, // \xe8\x87\x9a
{0x81df,{0x7f,0x15,0x7f,0x6f,0x7a,0x3f,0x4a}}, // \xe8\x87\x9f
{0x81e0,{0x7a,0x1d,0x5a,0x37,0x5a,0x1d,0x78}}, // \xe8\x87\xa0
{0x81e3,{0x7f,0x55,0x55,0x77,0x55,0x5d,0x41}}, // \xe8\x87\xa3
{0x81e5,{0x7f,0x55,0x77,0x5d,0x40,0x3f,0x40}}, // \xe8\x87\xa5
{0x81e7,{0x36,0x54,0x3e,0x7a,0x4a,0x3f,0x52}}, // \xe8\x87\xa7
{0x81e8,{0x7f,0x55,0x77,0x5d,0x64,0x6f,0x6e}}, // \xe8\x87\xa8
{0x81ea,{0x00,0x7e,0x4a,0x5b,0x5a,0x52,0x7e}}, // \xe8\x87\xaa
{0x81ed,{0x50,0x5e,0x5a,0x3b,0x5a,0x5e,0x50}}, // \xe8\x87\xad
{0x81f3,{0x41,0x55,0x57,0x7d,0x53,0x55,0x41}}, // \xe8\x87\xb3
{0x81f4,{0x49,0x5d,0x3b,0x2d,0x5c,0x23,0x5e}}, // \xe8\x87\xb4
{0x81fa,{0x5a,0x6a,0x7e,0x6f,0x5e,0x6a,0x5a}}, // \xe8\x87\xba
{0x81fb,{0x55,0x7b,0x5d,0x2a,0x7f,0x2e,0x5a}}, // \xe8\x87\xbb
{0x81fc,{0x7e,0x4a,0x49,0x40,0x4a,0x4a,0x7e}}, // \xe8\x87\xbc
{0x81fe,{0x5e,0x55,0x20,0x1f,0x20,0x55,0x5f}}, // \xe8\x87\xbe
{0x8201,{0x20,0x6e,0x3d,0x28,0x7d,0x2f,0x20}}, // \xe8\x88\x81
{0x8202,{0x28,0x1a,0x6e,0x5f,0x4e,0x7a,0x28}}, // \xe8\x88\x82
{0x8205,{0x50,0x5e,0x35,0x1c,0x15,0x5f,0x70}}, // \xe8\x88\x85
{0x8207,{0x5e,0x55,0x1b,0x12,0x1e,0x55,0x5f}}, // \xe8\x88\x87
{0x8208,{0x5e,0x55,0x1e,0x1a,0x1e,0x55,0x5f}}, // \xe8\x88\x88
{0x8209,{0x28,0x1e,0x29,0x7e,0x2d,0x1f,0x28}}, // \xe8\x88\x89
{0x820a,{0x0a,0x66,0x7f,0x56,0x7f,0x76,0x12}}, // \xe8\x88\x8a
{0x820c,{0x04,0x76,0x56,0x5e,0x55,0x75,0x04}}, // \xe8\x88\x8c
{0x820d,{0x14,0x74,0x56,0x5d,0x56,0x74,0x14}}, // \xe8\x88\x8d
{0x820e,{0x14,0x74,0x5a,0x5d,0x5a,0x74,0x14}}, // \xe8\x88\x8e
{0x8210,{0x76,0x5e,0x75,0x7e,0x4a,0x3e,0x49}}, // \xe8\x88\x90
{0x8212,{0x6a,0x5d,0x6a,0x09,0x4b,0x7d,0x1b}}, // \xe8\x88\x92
{0x8216,{0x6a,0x5d,0x7a,0x2a,0x7f,0x2a,0x7b}}, // \xe8\x88\x96
{0x8217,{0x6a,0x6d,0x7a,0x2a,0x7f,0x2a,0x7b}}, // \xe8\x88\x97
{0x8218,{0x6a,0x5d,0x6a,0x06,0x7a,0x5b,0x76}}, // \xe8\x88\x98
{0x821b,{0x48,0x47,0x2a,0x1e,0x12,0x7f,0x12}}, // \xe8\x88\x9b
{0x821c,{0x4d,0x57,0x2d,0x1f,0x35,0x77,0x2d}}, // \xe8\x88\x9c
{0x821e,{0x2b,0x5e,0x2a,0x3e,0x2a,0x7e,0x2a}}, // \xe8\x88\x9e
{0x821f,{0x50,0x3e,0x12,0x77,0x12,0x7e,0x10}}, // \xe8\x88\x9f
{0x8229,{0x7e,0x13,0x7e,0x63,0x58,0x23,0x44}}, // \xe8\x88\xa9
{0x822a,{0x7e,0x13,0x7e,0x7a,0x0b,0x7a,0x42}}, // \xe8\x88\xaa
{0x822b,{0x7e,0x13,0x7e,0x42,0x3e,0x4b,0x7a}}, // \xe8\x88\xab
{0x822c,{0x7e,0x13,0x7e,0x40,0x5b,0x29,0x5b}}, // \xe8\x88\xac
{0x822e,{0x7e,0x13,0x7e,0x41,0x3d,0x15,0x1d}}, // \xe8\x88\xae
{0x8233,{0x7e,0x13,0x7e,0x4a,0x7f,0x4a,0x7e}}, // \xe8\x88\xb3
{0x8235,{0x7e,0x13,0x7e,0x06,0x7a,0x53,0x56}}, // \xe8\x88\xb5
{0x8236,{0x7e,0x13,0x7e,0x7e,0x4b,0x4a,0x7e}}, // \xe8\x88\xb6
{0x8237,{0x7e,0x13,0x7e,0x4a,0x6e,0x53,0x6a}}, // \xe8\x88\xb7
{0x8238,{0x7e,0x13,0x7e,0x1d,0x15,0x5d,0x7f}}, // \xe8\x88\xb8
{0x8239,{0x7e,0x13,0x7e,0x08,0x77,0x50,0x77}}, // \xe8\x88\xb9
{0x8240,{0x7e,0x13,0x7e,0x21,0x6b,0x39,0x22}}, // \xe8\x89\x80
{0x8247,{0x7e,0x7f,0x55,0x3b,0x6a,0x7e,0x69}}, // \xe8\x89\x87
{0x8258,{0x7e,0x13,0x7e,0x4e,0x59,0x2e,0x5e}}, // \xe8\x89\x98
{0x8259,{0x7e,0x13,0x7e,0x24,0x1e,0x6d,0x62}}, // \xe8\x89\x99
{0x825a,{0x7e,0x13,0x7e,0x1a,0x7f,0x5a,0x7f}}, // \xe8\x89\x9a
{0x825d,{0x7e,0x13,0x7e,0x06,0x53,0x77,0x26}}, // \xe8\x89\x9d
{0x825f,{0x7e,0x13,0x7e,0x4a,0x5e,0x7b,0x5e}}, // \xe8\x89\x9f
{0x8262,{0x7e,0x13,0x7e,0x76,0x5b,0x76,0x7a}}, // \xe8\x89\xa2
{0x8264,{0x7e,0x13,0x7e,0x2a,0x7b,0x2e,0x5b}}, // \xe8\x89\xa4
{0x8266,{0x7e,0x13,0x7e,0x4f,0x60,0x6b,0x4a}}, // \xe8\x89\xa6
{0x8268,{0x7e,0x13,0x7e,0x5f,0x7a,0x2f,0x5a}}, // \xe8\x89\xa8
{0x826a,{0x7e,0x13,0x7e,0x12,0x7d,0x6f,0x10}}, // \xe8\x89\xaa
{0x826b,{0x7e,0x13,0x7e,0x5c,0x64,0x6f,0x4a}}, // \xe8\x89\xab
{0x826e,{0x40,0x7f,0x55,0x15,0x35,0x5f,0x40}}, // \xe8\x89\xae
{0x826f,{0x40,0x7e,0x5a,0x1b,0x3a,0x5e,0x40}}, // \xe8\x89\xaf
{0x8271,{0x5b,0x3e,0x5b,0x7f,0x55,0x35,0x5f}}, // \xe8\x89\xb1
{0x8272,{0x02,0x3e,0x55,0x5d,0x57,0x5c,0x60}}, // \xe8\x89\xb2
{0x8276,{0x5e,0x77,0x76,0x2f,0x7a,0x5d,0x5b}}, // \xe8\x89\xb6
{0x8277,{0x5f,0x6e,0x6f,0x3f,0x7a,0x5d,0x5b}}, // \xe8\x89\xb7
{0x8278,{0x1e,0x50,0x3f,0x1e,0x10,0x7f,0x1e}}, // \xe8\x89\xb8
{0x827e,{0x42,0x42,0x57,0x22,0x57,0x42,0x42}}, // \xe8\x89\xbe
{0x828b,{0x22,0x2a,0x6f,0x7a,0x2f,0x2a,0x22}}, // \xe8\x8a\x8b
{0x828d,{0x12,0x0a,0x1f,0x2a,0x0f,0x4a,0x7a}}, // \xe8\x8a\x8d
{0x8292,{0x0a,0x3a,0x4b,0x4e,0x4b,0x4a,0x4a}}, // \xe8\x8a\x92
{0x8299,{0x52,0x5a,0x5b,0x3e,0x5b,0x5a,0x52}}, // \xe8\x8a\x99
{0x829d,{0x42,0x2a,0x4b,0x6e,0x5b,0x4a,0x42}}, // \xe8\x8a\x9d
{0x829f,{0x4a,0x46,0x5b,0x2a,0x5b,0x4e,0x4a}}, // \xe8\x8a\x9f
{0x82a5,{0x12,0x52,0x3b,0x06,0x7b,0x12,0x12}}, // \xe8\x8a\xa5
{0x82a6,{0x4a,0x3a,0x2f,0x2a,0x2f,0x3a,0x0a}}, // \xe8\x8a\xa6
{0x82ab,{0x52,0x56,0x37,0x16,0x77,0x56,0x52}}, // \xe8\x8a\xab
{0x82ac,{0x12,0x4a,0x57,0x32,0x57,0x7a,0x12}}, // \xe8\x8a\xac
{0x82ad,{0x02,0x3e,0x57,0x5e,0x57,0x5e,0x62}}, // \xe8\x8a\xad
{0x82af,{0x42,0x32,0x7f,0x42,0x67,0x12,0x62}}, // \xe8\x8a\xaf
{0x82b1,{0x12,0x7a,0x07,0x02,0x7f,0x52,0x6a}}, // \xe8\x8a\xb1
{0x82b3,{0x4a,0x4a,0x3b,0x2e,0x2b,0x6a,0x0a}}, // \xe8\x8a\xb3
{0x82b8,{0x52,0x5a,0x7f,0x5a,0x5f,0x3a,0x52}}, // \xe8\x8a\xb8
{0x82b9,{0x42,0x3a,0x1f,0x1a,0x77,0x16,0x12}}, // \xe8\x8a\xb9
{0x82bb,{0x24,0x5b,0x7e,0x36,0x12,0x5a,0x7e}}, // \xe8\x8a\xbb
{0x82bd,{0x52,0x5e,0x37,0x56,0x7f,0x16,0x12}}, // \xe8\x8a\xbd
{0x82c5,{0x42,0x2a,0x13,0x2e,0x1b,0x42,0x7e}}, // \xe8\x8b\x85
{0x82d1,{0x52,0x5a,0x2f,0x1a,0x7f,0x4a,0x5a}}, // \xe8\x8b\x91
{0x82d2,{0x22,0x7e,0x2b,0x3e,0x2b,0x7e,0x22}}, // \xe8\x8b\x92
{0x82d3,{0x12,0x12,0x1b,0x76,0x1b,0x12,0x32}}, // \xe8\x8b\x93
{0x82d4,{0x12,0x72,0x5b,0x56,0x53,0x6a,0x12}}, // \xe8\x8b\x94
{0x82d7,{0x02,0x7a,0x5f,0x7a,0x5f,0x7a,0x02}}, // \xe8\x8b\x97
{0x82d9,{0x4a,0x4a,0x7b,0x4e,0x6b,0x5a,0x4a}}, // \xe8\x8b\x99
{0x82db,{0x0a,0x7a,0x5f,0x7a,0x0f,0x7a,0x0a}}, // \xe8\x8b\x9b
{0x82dc,{0x02,0x7e,0x57,0x56,0x57,0x7e,0x02}}, // \xe8\x8b\x9c
{0x82de,{0x0a,0x06,0x7f,0x56,0x5f,0x42,0x5e}}, // \xe8\x8b\x9e
{0x82df,{0x12,0x0a,0x6f,0x6a,0x0f,0x4a,0x7a}}, // \xe8\x8b\x9f
{0x82e1,{0x22,0x1e,0x53,0x46,0x2b,0x3e,0x42}}, // \xe8\x8b\xa1
{0x82e3,{0x02,0x7e,0x57,0x56,0x57,0x5e,0x46}}, // \xe8\x8b\xa3
{0x82e5,{0x2a,0x1a,0x6f,0x6a,0x6b,0x6a,0x0a}}, // \xe8\x8b\xa5
{0x82e6,{0x0a,0x6a,0x6f,0x7a,0x6f,0x6a,0x0a}}, // \xe8\x8b\xa6
{0x82e7,{0x1a,0x0a,0x5f,0x7a,0x1f,0x0a,0x1a}}, // \xe8\x8b\xa7
{0x82eb,{0x02,0x62,0x63,0x7e,0x6b,0x6a,0x02}}, // \xe8\x8b\xab
{0x82f1,{0x52,0x5a,0x57,0x3a,0x57,0x5a,0x52}}, // \xe8\x8b\xb1
{0x82f3,{0x22,0x2a,0x2b,0x56,0x1f,0x22,0x22}}, // \xe8\x8b\xb3
{0x82f4,{0x42,0x7e,0x57,0x56,0x57,0x7e,0x42}}, // \xe8\x8b\xb4
{0x82f9,{0x22,0x2a,0x27,0x7e,0x27,0x2a,0x22}}, // \xe8\x8b\xb9
{0x82fa,{0x0a,0x3a,0x2f,0x3e,0x6b,0x7e,0x2a}}, // \xe8\x8b\xba
{0x82fb,{0x12,0x7a,0x07,0x2a,0x4b,0x7e,0x0a}}, // \xe8\x8b\xbb
{0x8302,{0x42,0x3a,0x0f,0x4a,0x5f,0x2a,0x5a}}, // \xe8\x8c\x82
{0x8303,{0x56,0x02,0x3f,0x46,0x57,0x5e,0x62}}, // \xe8\x8c\x83
{0x8304,{0x52,0x3a,0x57,0x72,0x77,0x52,0x72}}, // \xe8\x8c\x84
{0x8305,{0x52,0x36,0x57,0x76,0x1f,0x16,0x32}}, // \xe8\x8c\x85
{0x8306,{0x3a,0x6a,0x37,0x02,0x7f,0x06,0x3e}}, // \xe8\x8c\x86
{0x8309,{0x4a,0x5a,0x3b,0x7e,0x3b,0x5a,0x4a}}, // \xe8\x8c\x89
{0x830e,{0x12,0x52,0x57,0x6a,0x57,0x52,0x12}}, // \xe8\x8c\x8e
{0x8316,{0x22,0x2a,0x6b,0x56,0x6f,0x22,0x22}}, // \xe8\x8c\x96
{0x8317,{0x22,0x2a,0x2b,0x76,0x57,0x5e,0x72}}, // \xe8\x8c\x97
{0x8318,{0x52,0x36,0x5f,0x76,0x37,0x5e,0x72}}, // \xe8\x8c\x98
{0x831c,{0x0a,0x7a,0x5f,0x4a,0x5f,0x7a,0x0a}}, // \xe8\x8c\x9c
{0x8323,{0x52,0x5a,0x53,0x3e,0x57,0x5e,0x52}}, // \xe8\x8c\xa3
{0x8328,{0x4a,0x02,0x53,0x4e,0x3b,0x4a,0x5a}}, // \xe8\x8c\xa8
{0x832b,{0x56,0x02,0x0b,0x7a,0x4f,0x4a,0x4a}}, // \xe8\x8c\xab
{0x832f,{0x12,0x7a,0x07,0x4a,0x4b,0x3e,0x4a}}, // \xe8\x8c\xaf
{0x8331,{0x52,0x5a,0x37,0x7e,0x37,0x56,0x52}}, // \xe8\x8c\xb1
{0x8332,{0x6a,0x56,0x63,0x02,0x6b,0x56,0x62}}, // \xe8\x8c\xb2
{0x8334,{0x7e,0x46,0x7f,0x6e,0x7f,0x46,0x7e}}, // \xe8\x8c\xb4
{0x8335,{0x7e,0x42,0x6b,0x5e,0x6b,0x42,0x7e}}, // \xe8\x8c\xb5
{0x8336,{0x52,0x12,0x1b,0x76,0x1b,0x12,0x52}}, // \xe8\x8c\xb6
{0x8338,{0x2a,0x2a,0x3f,0x2a,0x2f,0x7a,0x2a}}, // \xe8\x8c\xb8
{0x8339,{0x4a,0x5a,0x2f,0x5a,0x7b,0x4a,0x7a}}, // \xe8\x8c\xb9
{0x8340,{0x12,0x0a,0x7f,0x56,0x7f,0x06,0x7e}}, // \xe8\x8d\x80
{0x8345,{0x12,0x72,0x5b,0x56,0x5b,0x72,0x12}}, // \xe8\x8d\x85
{0x8349,{0x22,0x3e,0x37,0x76,0x37,0x3e,0x22}}, // \xe8\x8d\x89
{0x834a,{0x56,0x3e,0x17,0x7e,0x1b,0x42,0x7a}}, // \xe8\x8d\x8a
{0x834f,{0x12,0x7a,0x17,0x56,0x7f,0x56,0x12}}, // \xe8\x8d\x8f
{0x8350,{0x12,0x7a,0x17,0x52,0x77,0x1e,0x12}}, // \xe8\x8d\x90
{0x8352,{0x42,0x2e,0x0b,0x6a,0x0b,0x6a,0x42}}, // \xe8\x8d\x92
{0x8358,{0x2a,0x7e,0x13,0x52,0x7b,0x52,0x12}}, // \xe8\x8d\x98
{0x8373,{0x4a,0x5a,0x6f,0x6a,0x6f,0x5a,0x4a}}, // \xe8\x8d\xb3
{0x8375,{0x62,0x36,0x57,0x4e,0x57,0x1e,0x62}}, // \xe8\x8d\xb5
{0x8377,{0x12,0x7a,0x07,0x6a,0x6f,0x0a,0x7a}}, // \xe8\x8d\xb7
{0x837b,{0x56,0x4a,0x37,0x5a,0x43,0x3e,0x4a}}, // \xe8\x8d\xbb
{0x837c,{0x4a,0x3a,0x57,0x7e,0x17,0x3a,0x4a}}, // \xe8\x8d\xbc
{0x8385,{0x12,0x7a,0x07,0x4a,0x7b,0x6e,0x5a}}, // \xe8\x8e\x85
{0x8387,{0x42,0x7e,0x57,0x3e,0x4b,0x3e,0x7a}}, // \xe8\x8e\x87
{0x8389,{0x52,0x36,0x7f,0x36,0x1b,0x42,0x7a}}, // \xe8\x8e\x89
{0x838a,{0x5a,0x32,0x7f,0x12,0x53,0x7a,0x52}}, // \xe8\x8e\x8a
{0x838e,{0x56,0x02,0x13,0x4a,0x5f,0x2a,0x12}}, // \xe8\x8e\x8e
{0x8393,{0x0a,0x36,0x2f,0x3e,0x6b,0x7e,0x2a}}, // \xe8\x8e\x93
{0x8396,{0x5a,0x56,0x53,0x7a,0x57,0x5a,0x56}}, // \xe8\x8e\x96
{0x839a,{0x56,0x2e,0x43,0x76,0x67,0x7e,0x6a}}, // \xe8\x8e\x9a
{0x839e,{0x56,0x52,0x37,0x16,0x77,0x52,0x56}}, // \xe8\x8e\x9e
{0x839f,{0x0a,0x6a,0x67,0x6a,0x7b,0x66,0x0a}}, // \xe8\x8e\x9f
{0x83a0,{0x4a,0x5a,0x37,0x1e,0x37,0x6a,0x0a}}, // \xe8\x8e\xa0
{0x83a2,{0x52,0x4e,0x53,0x3e,0x53,0x4e,0x52}}, // \xe8\x8e\xa2
{0x83a8,{0x42,0x7e,0x57,0x16,0x37,0x5e,0x42}}, // \xe8\x8e\xa8
{0x83aa,{0x2a,0x2e,0x7f,0x0a,0x5f,0x2a,0x56}}, // \xe8\x8e\xaa
{0x83ab,{0x52,0x5e,0x57,0x36,0x57,0x5e,0x52}}, // \xe8\x8e\xab
{0x83b1,{0x52,0x56,0x33,0x7e,0x33,0x56,0x52}}, // \xe8\x8e\xb1
{0x83b5,{0x42,0x5e,0x37,0x1e,0x77,0x5e,0x62}}, // \xe8\x8e\xb5
{0x83bd,{0x2a,0x6a,0x37,0x22,0x77,0x2a,0x2a}}, // \xe8\x8e\xbd
{0x83c1,{0x0a,0x7a,0x2f,0x3e,0x2f,0x7a,0x0a}}, // \xe8\x8f\x81
{0x83c5,{0x1a,0x0a,0x7f,0x7a,0x6f,0x6a,0x1a}}, // \xe8\x8f\x85
{0x83ca,{0x12,0x5e,0x2b,0x7a,0x2b,0x5a,0x7a}}, // \xe8\x8f\x8a
{0x83cc,{0x7a,0x6a,0x5f,0x7a,0x5f,0x6a,0x7a}}, // \xe8\x8f\x8c
{0x83ce,{0x42,0x7e,0x5b,0x0a,0x7b,0x5e,0x52}}, // \xe8\x8f\x8e
{0x83d3,{0x52,0x5e,0x37,0x7e,0x37,0x5e,0x52}}, // \xe8\x8f\x93
{0x83d6,{0x72,0x5e,0x57,0x56,0x57,0x5e,0x72}}, // \xe8\x8f\x96
{0x83d8,{0x2a,0x7e,0x4b,0x66,0x53,0x26,0x4a}}, // \xe8\x8f\x98
{0x83dc,{0x52,0x56,0x33,0x76,0x3b,0x56,0x52}}, // \xe8\x8f\x9c
{0x83df,{0x4a,0x5a,0x37,0x1e,0x77,0x5e,0x62}}, // \xe8\x8f\x9f
{0x83e0,{0x56,0x02,0x43,0x3a,0x5b,0x2e,0x5a}}, // \xe8\x8f\xa0
{0x83e9,{0x12,0x76,0x5f,0x56,0x5f,0x76,0x12}}, // \xe8\x8f\xa9
{0x83eb,{0x52,0x5e,0x57,0x7e,0x57,0x5e,0x52}}, // \xe8\x8f\xab
{0x83ef,{0x2a,0x3e,0x2b,0x7e,0x2b,0x3e,0x2a}}, // \xe8\x8f\xaf
{0x83f0,{0x56,0x6e,0x43,0x3e,0x47,0x3e,0x66}}, // \xe8\x8f\xb0
{0x83f1,{0x2a,0x5a,0x5f,0x2e,0x3f,0x5a,0x52}}, // \xe8\x8f\xb1
{0x83f2,{0x2a,0x6a,0x3f,0x02,0x7f,0x2a,0x2a}}, // \xe8\x8f\xb2
{0x83f4,{0x0a,0x3a,0x37,0x3a,0x77,0x7a,0x4a}}, // \xe8\x8f\xb4
{0x83f7,{0x1a,0x6a,0x2f,0x7e,0x2f,0x6e,0x1a}}, // \xe8\x8f\xb7
{0x83fb,{0x2a,0x1a,0x7f,0x2a,0x1b,0x7e,0x2a}}, // \xe8\x8f\xbb
{0x83fd,{0x52,0x12,0x7f,0x16,0x5b,0x2a,0x5a}}, // \xe8\x8f\xbd
{0x8403,{0x32,0x2e,0x33,0x62,0x33,0x2e,0x32}}, // \xe8\x90\x83
{0x8404,{0x12,0x6e,0x57,0x7e,0x57,0x66,0x7e}}, // \xe8\x90\x84
{0x8407,{0x12,0x52,0x7f,0x56,0x37,0x56,0x52}}, // \xe8\x90\x87
{0x840b,{0x52,0x5a,0x7b,0x5e,0x3b,0x5e,0x52}}, // \xe8\x90\x8b
{0x840c,{0x3e,0x2a,0x3f,0x42,0x3f,0x2a,0x7e}}, // \xe8\x90\x8c
{0x840d,{0x56,0x02,0x37,0x2e,0x7f,0x2e,0x36}}, // \xe8\x90\x8d
{0x840e,{0x52,0x5a,0x77,0x5e,0x37,0x5a,0x52}}, // \xe8\x90\x8e
{0x8413,{0x5a,0x4a,0x7b,0x5e,0x7b,0x4a,0x5a}}, // \xe8\x90\x93
{0x8420,{0x42,0x3e,0x57,0x7e,0x3f,0x56,0x7e}}, // \xe8\x90\xa0
{0x8422,{0x56,0x02,0x0b,0x76,0x5f,0x46,0x5e}}, // \xe8\x90\xa2
{0x8429,{0x2a,0x7a,0x27,0x5a,0x43,0x3e,0x4a}}, // \xe8\x90\xa9
{0x842a,{0x2a,0x7a,0x17,0x22,0x2b,0x7e,0x22}}, // \xe8\x90\xaa
{0x842c,{0x72,0x1e,0x5b,0x7e,0x3b,0x5e,0x72}}, // \xe8\x90\xac
{0x8431,{0x5a,0x4a,0x7f,0x7a,0x7f,0x4a,0x5a}}, // \xe8\x90\xb1
{0x8435,{0x72,0x1e,0x73,0x5e,0x77,0x1e,0x72}}, // \xe8\x90\xb5
{0x8438,{0x5a,0x56,0x43,0x3e,0x43,0x56,0x5e}}, // \xe8\x90\xb8
{0x843c,{0x12,0x16,0x1f,0x5a,0x5f,0x76,0x12}}, // \xe8\x90\xbc
{0x843d,{0x56,0x02,0x2b,0x6a,0x57,0x6e,0x22}}, // \xe8\x90\xbd
{0x8446,{0x0a,0x7e,0x53,0x3e,0x7b,0x3e,0x52}}, // \xe8\x91\x86
{0x8449,{0x52,0x5e,0x33,0x76,0x37,0x56,0x52}}, // \xe8\x91\x89
{0x844e,{0x2a,0x76,0x2b,0x2a,0x7f,0x3a,0x22}}, // \xe8\x91\x8e
{0x8457,{0x52,0x52,0x37,0x7e,0x5f,0x76,0x12}}, // \xe8\x91\x97
{0x845b,{0x22,0x1e,0x7b,0x5a,0x1b,0x5e,0x72}}, // \xe8\x91\x9b
{0x8461,{0x0a,0x76,0x37,0x7e,0x77,0x06,0x7e}}, // \xe8\x91\xa1
{0x8462,{0x52,0x76,0x6f,0x76,0x6f,0x76,0x52}}, // \xe8\x91\xa2
{0x8463,{0x4a,0x7a,0x6f,0x7e,0x6f,0x7a,0x4a}}, // \xe8\x91\xa3
{0x8466,{0x2a,0x3a,0x2f,0x2a,0x7b,0x2e,0x2a}}, // \xe8\x91\xa6
{0x8469,{0x7a,0x56,0x7b,0x02,0x7f,0x4e,0x6e}}, // \xe8\x91\xa9
{0x846b,{0x6a,0x5e,0x6b,0x42,0x3f,0x56,0x7e}}, // \xe8\x91\xab
{0x846c,{0x2a,0x76,0x2f,0x22,0x7f,0x36,0x32}}, // \xe8\x91\xac
{0x846d,{0x7e,0x2a,0x2f,0x02,0x5b,0x2e,0x5e}}, // \xe8\x91\xad
{0x846e,{0x22,0x7e,0x17,0x4a,0x5f,0x2e,0x5a}}, // \xe8\x91\xae
{0x846f,{0x2a,0x76,0x23,0x12,0x2f,0x4a,0x7a}}, // \xe8\x91\xaf
{0x8471,{0x6a,0x36,0x4f,0x56,0x6f,0x1e,0x62}}, // \xe8\x91\xb1
{0x8475,{0x56,0x4e,0x57,0x32,0x57,0x4a,0x56}}, // \xe8\x91\xb5
{0x8477,{0x26,0x3a,0x2b,0x7e,0x2b,0x3a,0x26}}, // \xe8\x91\xb7
{0x8479,{0x4a,0x3e,0x6b,0x12,0x7f,0x4a,0x5a}}, // \xe8\x91\xb9
{0x847a,{0x2a,0x2e,0x3b,0x2a,0x2b,0x7e,0x2a}}, // \xe8\x91\xba
{0x8482,{0x1a,0x6a,0x2f,0x7a,0x2b,0x6e,0x1a}}, // \xe8\x92\x82
{0x8484,{0x56,0x36,0x77,0x52,0x6b,0x7e,0x46}}, // \xe8\x92\x84
{0x848b,{0x2a,0x7e,0x17,0x32,0x57,0x7a,0x16}}, // \xe8\x92\x8b
{0x8490,{0x42,0x5a,0x3b,0x1e,0x7b,0x5a,0x62}}, // \xe8\x92\x90
{0x8494,{0x3a,0x3a,0x13,0x36,0x5f,0x76,0x12}}, // \xe8\x92\x94
{0x8499,{0x5a,0x5a,0x2f,0x5a,0x7f,0x2a,0x5a}}, // \xe8\x92\x99
{0x849c,{0x2a,0x7e,0x2f,0x02,0x2b,0x7e,0x2e}}, // \xe8\x92\x9c
{0x849f,{0x5a,0x6e,0x5b,0x0a,0x37,0x36,0x7e}}, // \xe8\x92\x9f
{0x84a1,{0x5a,0x4a,0x3f,0x2a,0x2b,0x6e,0x1a}}, // \xe8\x92\xa1
{0x84ad,{0x2a,0x56,0x7f,0x36,0x13,0x5a,0x7e}}, // \xe8\x92\xad
{0x84b2,{0x56,0x02,0x7b,0x2a,0x7f,0x2a,0x7a}}, // \xe8\x92\xb2
{0x84b8,{0x6a,0x3a,0x67,0x3e,0x63,0x2a,0x76}}, // \xe8\x92\xb8
{0x84b9,{0x52,0x36,0x7f,0x16,0x7f,0x2e,0x4a}}, // \xe8\x92\xb9
{0x84bb,{0x5a,0x2a,0x6f,0x02,0x5b,0x2a,0x6e}}, // \xe8\x92\xbb
{0x84bc,{0x4a,0x26,0x1b,0x7a,0x7b,0x66,0x0a}}, // \xe8\x92\xbc
{0x84bf,{0x72,0x16,0x7f,0x56,0x7f,0x16,0x72}}, // \xe8\x92\xbf
{0x84c1,{0x4a,0x5a,0x2f,0x7e,0x2f,0x5a,0x4a}}, // \xe8\x93\x81
{0x84c4,{0x12,0x76,0x57,0x7a,0x53,0x72,0x1a}}, // \xe8\x93\x84
{0x84c6,{0x42,0x3e,0x6b,0x2e,0x7b,0x2e,0x6a}}, // \xe8\x93\x86
{0x84c9,{0x26,0x2a,0x77,0x6a,0x77,0x2a,0x26}}, // \xe8\x93\x89
{0x84ca,{0x5a,0x3a,0x77,0x12,0x57,0x3a,0x7a}}, // \xe8\x93\x8a
{0x84cb,{0x4a,0x7a,0x5f,0x7e,0x5b,0x76,0x4a}}, // \xe8\x93\x8b
{0x84cd,{0x12,0x16,0x6f,0x7e,0x77,0x72,0x12}}, // \xe8\x93\x8d
{0x84d0,{0x22,0x1e,0x37,0x5e,0x7f,0x16,0x1a}}, // \xe8\x93\x90
{0x84d1,{0x2a,0x2a,0x7f,0x56,0x3f,0x4a,0x4a}}, // \xe8\x93\x91
{0x84d6,{0x42,0x7e,0x57,0x1a,0x77,0x5e,0x52}}, // \xe8\x93\x96
{0x84d9,{0x42,0x3e,0x4b,0x56,0x7b,0x56,0x4a}}, // \xe8\x93\x99
{0x84da,{0x12,0x7a,0x3f,0x12,0x4f,0x56,0x2a}}, // \xe8\x93\x9a
{0x84ec,{0x52,0x36,0x4b,0x5a,0x77,0x4e,0x52}}, // \xe8\x93\xac
{0x84ee,{0x52,0x36,0x43,0x52,0x5f,0x7e,0x52}}, // \xe8\x93\xae
{0x84f4,{0x12,0x12,0x3f,0x5e,0x77,0x1a,0x12}}, // \xe8\x93\xb4
{0x84fc,{0x12,0x16,0x4f,0x5a,0x2f,0x16,0x12}}, // \xe8\x93\xbc
{0x84ff,{0x16,0x7a,0x03,0x6a,0x7b,0x6a,0x6e}}, // \xe8\x93\xbf
{0x8500,{0x2a,0x7a,0x6f,0x7a,0x2b,0x7e,0x36}}, // \xe8\x94\x80
{0x8506,{0x56,0x02,0x2b,0x5e,0x2f,0x5e,0x4a}}, // \xe8\x94\x86
{0x8511,{0x42,0x3e,0x2b,0x0e,0x5b,0x2e,0x5a}}, // \xe8\x94\x91
{0x8513,{0x42,0x5a,0x5f,0x2e,0x5f,0x5a,0x42}}, // \xe8\x94\x93
{0x8514,{0x0a,0x66,0x7b,0x7a,0x6b,0x02,0x7e}}, // \xe8\x94\x94
{0x8515,{0x1a,0x76,0x3f,0x7a,0x37,0x7e,0x1a}}, // \xe8\x94\x95
{0x8517,{0x42,0x3e,0x4b,0x1e,0x5b,0x1e,0x4a}}, // \xe8\x94\x97
{0x8518,{0x2a,0x1a,0x4f,0x5a,0x2b,0x16,0x2a}}, // \xe8\x94\x98
{0x851a,{0x42,0x3e,0x6f,0x2e,0x1b,0x4a,0x7e}}, // \xe8\x94\x9a
{0x851f,{0x4a,0x3e,0x6b,0x12,0x5f,0x3a,0x5a}}, // \xe8\x94\x9f
{0x8521,{0x52,0x2e,0x57,0x72,0x17,0x2a,0x56}}, // \xe8\x94\xa1
{0x8526,{0x42,0x1a,0x5b,0x1e,0x5b,0x12,0x72}}, // \xe8\x94\xa6
{0x852c,{0x66,0x76,0x4f,0x3a,0x6b,0x2e,0x6a}}, // \xe8\x94\xac
{0x852d,{0x7e,0x36,0x53,0x7a,0x57,0x3a,0x52}}, // \xe8\x94\xad
{0x8535,{0x42,0x3a,0x7f,0x7a,0x4f,0x3a,0x52}}, // \xe8\x94\xb5
{0x853d,{0x76,0x5a,0x2b,0x76,0x53,0x2e,0x5a}}, // \xe8\x94\xbd
{0x8540,{0x5a,0x2a,0x7f,0x5a,0x2b,0x7e,0x5a}}, // \xe8\x95\x80
{0x8541,{0x2a,0x3a,0x6b,0x26,0x7f,0x6e,0x3a}}, // \xe8\x95\x81
{0x8543,{0x2a,0x1e,0x6b,0x7e,0x6b,0x1e,0x2a}}, // \xe8\x95\x83
{0x8548,{0x22,0x2e,0x3b,0x6e,0x3b,0x2e,0x22}}, // \xe8\x95\x88
{0x8549,{0x4a,0x06,0x5f,0x16,0x5f,0x16,0x52}}, // \xe8\x95\x89
{0x854a,{0x6a,0x3e,0x53,0x56,0x3b,0x46,0x6a}}, // \xe8\x95\x8a
{0x854b,{0x6a,0x4e,0x7b,0x6e,0x4f,0x7e,0x5a}}, // \xe8\x95\x8b
{0x854e,{0x7a,0x1a,0x7f,0x56,0x7f,0x1a,0x7a}}, // \xe8\x95\x8e
{0x8555,{0x56,0x4a,0x37,0x7a,0x57,0x76,0x7a}}, // \xe8\x95\x95
{0x8557,{0x6e,0x76,0x2f,0x6a,0x57,0x6e,0x22}}, // \xe8\x95\x97
{0x8558,{0x5a,0x5e,0x3f,0x16,0x7f,0x5e,0x5a}}, // \xe8\x95\x98
{0x855a,{0x12,0x1a,0x1f,0x56,0x5f,0x7a,0x12}}, // \xe8\x95\x9a
{0x8563,{0x5a,0x6e,0x5b,0x3e,0x2b,0x7e,0x3a}}, // \xe8\x95\xa3
{0x8568,{0x42,0x3e,0x57,0x3a,0x4f,0x3a,0x5a}}, // \xe8\x95\xa8
{0x8569,{0x56,0x02,0x23,0x5e,0x3b,0x5e,0x72}}, // \xe8\x95\xa9
{0x856a,{0x6a,0x3e,0x6b,0x3a,0x6b,0x3a,0x6a}}, // \xe8\x95\xaa
{0x856d,{0x4a,0x3a,0x6f,0x06,0x6f,0x2e,0x7a}}, // \xe8\x95\xad
{0x8577,{0x12,0x56,0x7f,0x32,0x47,0x1e,0x5e}}, // \xe8\x95\xb7
{0x857e,{0x0a,0x76,0x5f,0x7e,0x57,0x7e,0x0a}}, // \xe8\x95\xbe
{0x8580,{0x56,0x02,0x5f,0x7a,0x77,0x7a,0x5e}}, // \xe8\x96\x80
{0x8584,{0x56,0x02,0x13,0x3e,0x5f,0x7e,0x12}}, // \xe8\x96\x84
{0x8587,{0x2a,0x76,0x53,0x36,0x57,0x3e,0x5e}}, // \xe8\x96\x87
{0x8588,{0x0a,0x7e,0x57,0x5e,0x57,0x7e,0x0a}}, // \xe8\x96\x88
{0x858a,{0x4a,0x16,0x5f,0x02,0x1b,0x42,0x7e}}, // \xe8\x96\x8a
{0x8590,{0x2a,0x7a,0x17,0x2a,0x5f,0x2e,0x5a}}, // \xe8\x96\x90
{0x8591,{0x42,0x56,0x7f,0x7e,0x7f,0x56,0x42}}, // \xe8\x96\x91
{0x8594,{0x1a,0x76,0x7b,0x5e,0x7b,0x76,0x1a}}, // \xe8\x96\x94
{0x8597,{0x7e,0x66,0x5f,0x76,0x5f,0x66,0x7e}}, // \xe8\x96\x97
{0x8599,{0x52,0x3e,0x4b,0x12,0x7f,0x7a,0x56}}, // \xe8\x96\x99
{0x859b,{0x7e,0x6e,0x6f,0x2a,0x3b,0x6e,0x3a}}, // \xe8\x96\x9b
{0x859c,{0x12,0x7e,0x6f,0x2a,0x3b,0x6e,0x3a}}, // \xe8\x96\x9c
{0x85a4,{0x56,0x2e,0x57,0x7e,0x43,0x7e,0x56}}, // \xe8\x96\xa4
{0x85a6,{0x42,0x3e,0x4b,0x1e,0x5b,0x1e,0x72}}, // \xe8\x96\xa6
{0x85a8,{0x5a,0x6e,0x3b,0x1e,0x7b,0x5e,0x5a}}, // \xe8\x96\xa8
{0x85a9,{0x7e,0x36,0x43,0x3a,0x5f,0x7e,0x4a}}, // \xe8\x96\xa9
{0x85aa,{0x52,0x36,0x7b,0x36,0x3f,0x16,0x72}}, // \xe8\x96\xaa
{0x85ab,{0x6a,0x3a,0x6f,0x3e,0x6f,0x3a,0x6a}}, // \xe8\x96\xab
{0x85ac,{0x56,0x5a,0x3f,0x76,0x3f,0x5a,0x56}}, // \xe8\x96\xac
{0x85ae,{0x56,0x6a,0x5f,0x36,0x5b,0x26,0x5e}}, // \xe8\x96\xae
{0x85af,{0x22,0x6e,0x3b,0x7e,0x7b,0x6e,0x2a}}, // \xe8\x96\xaf
{0x85b9,{0x5a,0x6a,0x7f,0x6e,0x5f,0x6a,0x5a}}, // \xe8\x96\xb9
{0x85ba,{0x4a,0x36,0x2f,0x2a,0x2f,0x76,0x0a}}, // \xe8\x96\xba
{0x85c1,{0x5a,0x4a,0x3f,0x76,0x3f,0x4a,0x5a}}, // \xe8\x97\x81
{0x85c9,{0x52,0x36,0x7f,0x3e,0x6b,0x7e,0x2a}}, // \xe8\x97\x89
{0x85cd,{0x42,0x5e,0x77,0x62,0x6f,0x4a,0x4a}}, // \xe8\x97\x8d
{0x85cf,{0x5a,0x72,0x3b,0x7a,0x5b,0x3e,0x4a}}, // \xe8\x97\x8f
{0x85d0,{0x2a,0x5a,0x77,0x42,0x3b,0x6e,0x5a}}, // \xe8\x97\x90
{0x85d5,{0x2a,0x7e,0x2b,0x72,0x5f,0x3e,0x72}}, // \xe8\x97\x95
{0x85dc,{0x2a,0x66,0x3f,0x6a,0x37,0x6a,0x2e}}, // \xe8\x97\x9c
{0x85dd,{0x52,0x5a,0x7f,0x5a,0x57,0x3e,0x5a}}, // \xe8\x97\x9d
{0x85e4,{0x7a,0x2a,0x7f,0x2a,0x77,0x2a,0x56}}, // \xe8\x97\xa4
{0x85e5,{0x5a,0x56,0x3f,0x76,0x3f,0x5a,0x56}}, // \xe8\x97\xa5
{0x85e9,{0x56,0x02,0x2b,0x1e,0x6f,0x7e,0x2a}}, // \xe8\x97\xa9
{0x85ea,{0x56,0x7e,0x5f,0x3e,0x5b,0x26,0x5e}}, // \xe8\x97\xaa
{0x85f7,{0x6a,0x6e,0x43,0x2a,0x7f,0x6e,0x6a}}, // \xe8\x97\xb7
{0x85f9,{0x6a,0x6e,0x23,0x7e,0x57,0x1e,0x72}}, // \xe8\x97\xb9
{0x85fa,{0x7e,0x26,0x7b,0x52,0x7b,0x56,0x7e}}, // \xe8\x97\xba
{0x85fb,{0x56,0x02,0x5b,0x36,0x7b,0x36,0x5a}}, // \xe8\x97\xbb
{0x85fe,{0x42,0x2e,0x7f,0x2e,0x47,0x1a,0x5e}}, // \xe8\x97\xbe
{0x8602,{0x5a,0x4e,0x37,0x7a,0x2b,0x56,0x5a}}, // \xe8\x98\x82
{0x8606,{0x42,0x3a,0x4b,0x6a,0x7f,0x76,0x52}}, // \xe8\x98\x86
{0x8607,{0x4a,0x16,0x5f,0x2a,0x1f,0x7e,0x2a}}, // \xe8\x98\x87
{0x860a,{0x2a,0x76,0x23,0x5e,0x7b,0x76,0x5e}}, // \xe8\x98\x8a
{0x860b,{0x1a,0x52,0x5f,0x2a,0x47,0x1e,0x5e}}, // \xe8\x98\x8b
{0x8613,{0x2a,0x7a,0x47,0x3a,0x77,0x3e,0x42}}, // \xe8\x98\x93
{0x8616,{0x42,0x5e,0x37,0x72,0x3f,0x5a,0x4e}}, // \xe8\x98\x96
{0x8617,{0x4a,0x5e,0x37,0x72,0x3f,0x5a,0x4e}}, // \xe8\x98\x97
{0x861a,{0x4a,0x36,0x7f,0x2a,0x2f,0x7a,0x2e}}, // \xe8\x98\x9a
{0x8622,{0x16,0x7e,0x37,0x7e,0x17,0x6e,0x5a}}, // \xe8\x98\xa2
{0x862d,{0x7e,0x56,0x37,0x7a,0x37,0x56,0x7e}}, // \xe8\x98\xad
{0x862f,{0x56,0x62,0x73,0x6e,0x7b,0x6e,0x5a}}, // \xe8\x98\xaf
{0x8630,{0x2a,0x76,0x23,0x5a,0x5f,0x2e,0x5a}}, // \xe8\x98\xb0
{0x863f,{0x2e,0x76,0x27,0x7e,0x57,0x7e,0x56}}, // \xe8\x98\xbf
{0x864d,{0x40,0x3c,0x14,0x7f,0x56,0x56,0x6c}}, // \xe8\x99\x8d
{0x864e,{0x40,0x3c,0x44,0x24,0x0f,0x6a,0x4a}}, // \xe8\x99\x8e
{0x8650,{0x40,0x3c,0x04,0x74,0x5f,0x5a,0x5a}}, // \xe8\x99\x90
{0x8654,{0x40,0x3c,0x44,0x5c,0x2f,0x5a,0x4a}}, // \xe8\x99\x94
{0x8655,{0x40,0x3c,0x54,0x2c,0x5f,0x7a,0x4a}}, // \xe8\x99\x95
{0x865a,{0x40,0x3c,0x44,0x64,0x4f,0x6a,0x4a}}, // \xe8\x99\x9a
{0x865c,{0x40,0x3c,0x54,0x5c,0x3f,0x5a,0x7a}}, // \xe8\x99\x9c
{0x865e,{0x40,0x3c,0x34,0x64,0x3f,0x7a,0x2a}}, // \xe8\x99\x9e
{0x865f,{0x5b,0x6b,0x3c,0x44,0x2f,0x6a,0x4a}}, // \xe8\x99\x9f
{0x8667,{0x7c,0x74,0x7f,0x5a,0x05,0x5f,0x75}}, // \xe8\x99\xa7
{0x866b,{0x40,0x5e,0x52,0x7f,0x52,0x3e,0x40}}, // \xe8\x99\xab
{0x8671,{0x5d,0x55,0x7f,0x55,0x5d,0x3f,0x40}}, // \xe8\x99\xb1
{0x8679,{0x4e,0x7b,0x2e,0x40,0x42,0x7e,0x42}}, // \xe8\x99\xb9
{0x867b,{0x4e,0x7b,0x2e,0x3e,0x42,0x43,0x42}}, // \xe8\x99\xbb
{0x868a,{0x4e,0x7f,0x42,0x2e,0x13,0x2e,0x42}}, // \xe8\x9a\x8a
{0x868b,{0x4e,0x7b,0x7e,0x15,0x0f,0x54,0x7c}}, // \xe8\x9a\x8b
{0x868c,{0x4e,0x7b,0x2e,0x22,0x2a,0x7f,0x2a}}, // \xe8\x9a\x8c
{0x8693,{0x4e,0x7b,0x2e,0x5d,0x77,0x00,0x7f}}, // \xe8\x9a\x93
{0x8695,{0x45,0x5d,0x55,0x7b,0x55,0x3d,0x45}}, // \xe8\x9a\x95
{0x86a3,{0x4e,0x7b,0x44,0x63,0x58,0x23,0x44}}, // \xe8\x9a\xa3
{0x86a4,{0x48,0x59,0x57,0x7d,0x55,0x3b,0x48}}, // \xe8\x9a\xa4
{0x86a9,{0x44,0x5f,0x56,0x7f,0x56,0x3f,0x44}}, // \xe8\x9a\xa9
{0x86aa,{0x4e,0x7b,0x2e,0x2a,0x20,0x7f,0x10}}, // \xe8\x9a\xaa
{0x86ab,{0x4e,0x7b,0x2e,0x04,0x7b,0x5a,0x5e}}, // \xe8\x9a\xab
{0x86af,{0x4e,0x7b,0x4e,0x7e,0x4a,0x79,0x48}}, // \xe8\x9a\xaf
{0x86b0,{0x4e,0x7b,0x2e,0x7e,0x4a,0x7f,0x7e}}, // \xe8\x9a\xb0
{0x86b6,{0x4e,0x7b,0x2e,0x02,0x7f,0x4a,0x7f}}, // \xe8\x9a\xb6
{0x86c4,{0x4e,0x7b,0x2e,0x04,0x74,0x5f,0x74}}, // \xe8\x9b\x84
{0x86c6,{0x4e,0x7b,0x4e,0x7f,0x55,0x7f,0x40}}, // \xe8\x9b\x86
{0x86c7,{0x4e,0x7b,0x2e,0x06,0x7a,0x53,0x56}}, // \xe8\x9b\x87
{0x86c9,{0x4e,0x7b,0x2e,0x12,0x75,0x16,0x34}}, // \xe8\x9b\x89
{0x86cb,{0x49,0x45,0x59,0x7f,0x5b,0x29,0x4b}}, // \xe8\x9b\x8b
{0x86cd,{0x46,0x5b,0x5a,0x7f,0x5a,0x3b,0x46}}, // \xe8\x9b\x8d
{0x86ce,{0x4e,0x7b,0x2e,0x1f,0x65,0x1d,0x75}}, // \xe8\x9b\x8e
{0x86d4,{0x4e,0x7b,0x2e,0x7f,0x5d,0x55,0x7f}}, // \xe8\x9b\x94
{0x86d9,{0x4e,0x7b,0x2e,0x48,0x5a,0x7f,0x5a}}, // \xe8\x9b\x99
{0x86db,{0x4e,0x7f,0x4c,0x2b,0x7f,0x2a,0x48}}, // \xe8\x9b\x9b
{0x86de,{0x4e,0x7b,0x2e,0x04,0x76,0x5e,0x75}}, // \xe8\x9b\x9e
{0x86df,{0x4e,0x7f,0x4a,0x56,0x23,0x56,0x4a}}, // \xe8\x9b\x9f
{0x86e4,{0x4e,0x7b,0x2e,0x00,0x76,0x55,0x76}}, // \xe8\x9b\xa4
{0x86e9,{0x45,0x47,0x5d,0x7c,0x5b,0x27,0x44}}, // \xe8\x9b\xa9
{0x86ec,{0x54,0x4e,0x5f,0x7e,0x5f,0x2e,0x54}}, // \xe8\x9b\xac
{0x86ed,{0x4e,0x7b,0x2e,0x45,0x57,0x7d,0x55}}, // \xe8\x9b\xad
{0x86ee,{0x4a,0x42,0x5e,0x7b,0x5e,0x22,0x4a}}, // \xe8\x9b\xae
{0x86ef,{0x4e,0x7f,0x28,0x1a,0x6f,0x5a,0x49}}, // \xe8\x9b\xaf
{0x86f8,{0x4e,0x7b,0x2e,0x7d,0x14,0x57,0x7d}}, // \xe8\x9b\xb8
{0x86f9,{0x4e,0x7b,0x2e,0x7d,0x15,0x7f,0x7d}}, // \xe8\x9b\xb9
{0x86fb,{0x4e,0x7b,0x2e,0x5d,0x34,0x75,0x5e}}, // \xe8\x9b\xbb
{0x86fe,{0x4e,0x7b,0x26,0x7e,0x25,0x3f,0x55}}, // \xe8\x9b\xbe
{0x8700,{0x4b,0x45,0x5f,0x7d,0x5f,0x25,0x7f}}, // \xe8\x9c\x80
{0x8702,{0x4e,0x7b,0x2e,0x2a,0x75,0x2b,0x28}}, // \xe8\x9c\x82
{0x8703,{0x48,0x47,0x7f,0x7b,0x77,0x2b,0x49}}, // \xe8\x9c\x83
{0x8706,{0x4e,0x7b,0x2e,0x5f,0x35,0x75,0x5f}}, // \xe8\x9c\x86
{0x8708,{0x4e,0x7b,0x2e,0x56,0x34,0x5f,0x53}}, // \xe8\x9c\x88
{0x8709,{0x4e,0x7b,0x2e,0x21,0x6b,0x39,0x22}}, // \xe8\x9c\x89
{0x870a,{0x4e,0x7f,0x35,0x7f,0x15,0x4e,0x7f}}, // \xe8\x9c\x8a
{0x870d,{0x4e,0x7b,0x54,0x16,0x7d,0x16,0x54}}, // \xe8\x9c\x8d
{0x8711,{0x55,0x5b,0x70,0x7a,0x72,0x3e,0x55}}, // \xe8\x9c\x91
{0x8712,{0x4e,0x7f,0x55,0x3b,0x52,0x5e,0x55}}, // \xe8\x9c\x92
{0x8718,{0x4e,0x7f,0x4b,0x3e,0x4a,0x3e,0x3e}}, // \xe8\x9c\x98
{0x871a,{0x4a,0x5a,0x7f,0x70,0x7f,0x2a,0x4a}}, // \xe8\x9c\x9a
{0x871c,{0x56,0x4a,0x5e,0x7b,0x5e,0x2a,0x46}}, // \xe8\x9c\x9c
{0x8725,{0x4e,0x7f,0x1a,0x7f,0x3e,0x0a,0x79}}, // \xe8\x9c\xa5
{0x8729,{0x4e,0x7b,0x7f,0x35,0x2f,0x35,0x7f}}, // \xe8\x9c\xa9
{0x8734,{0x4e,0x7b,0x4e,0x27,0x5d,0x35,0x77}}, // \xe8\x9c\xb4
{0x8737,{0x4e,0x7b,0x16,0x6d,0x56,0x4d,0x16}}, // \xe8\x9c\xb7
{0x873b,{0x4e,0x7b,0x2e,0x08,0x7a,0x3f,0x7a}}, // \xe8\x9c\xbb
{0x873f,{0x4e,0x7b,0x56,0x2a,0x7b,0x4a,0x5e}}, // \xe8\x9c\xbf
{0x8749,{0x4e,0x7b,0x2d,0x2c,0x7d,0x2e,0x2d}}, // \xe8\x9d\x89
{0x874b,{0x4e,0x7b,0x3d,0x14,0x7d,0x16,0x7d}}, // \xe8\x9d\x8b
{0x874c,{0x4e,0x7b,0x35,0x7f,0x25,0x2a,0x7f}}, // \xe8\x9d\x8c
{0x874e,{0x4e,0x7f,0x10,0x3f,0x2d,0x4f,0x78}}, // \xe8\x9d\x8e
{0x8753,{0x4e,0x7f,0x05,0x73,0x75,0x26,0x54}}, // \xe8\x9d\x93
{0x8755,{0x7a,0x5d,0x22,0x4e,0x7f,0x4a,0x6e}}, // \xe8\x9d\x95
{0x8757,{0x4e,0x7b,0x2e,0x50,0x5e,0x7b,0x5e}}, // \xe8\x9d\x97
{0x8759,{0x4e,0x7b,0x2e,0x11,0x7f,0x35,0x77}}, // \xe8\x9d\x99
{0x875f,{0x4e,0x7b,0x0f,0x7d,0x2f,0x7d,0x0f}}, // \xe8\x9d\x9f
{0x8760,{0x4e,0x7b,0x2e,0x71,0x57,0x77,0x71}}, // \xe8\x9d\xa0
{0x8763,{0x4e,0x7f,0x62,0x1f,0x7a,0x77,0x2e}}, // \xe8\x9d\xa3
{0x8766,{0x4e,0x7b,0x7f,0x2b,0x58,0x2d,0x5f}}, // \xe8\x9d\xa6
{0x8768,{0x44,0x75,0x3d,0x47,0x75,0x37,0x48}}, // \xe8\x9d\xa8
{0x876a,{0x4e,0x7b,0x26,0x5f,0x35,0x57,0x74}}, // \xe8\x9d\xaa
{0x876e,{0x4e,0x7b,0x4e,0x53,0x2e,0x5e,0x42}}, // \xe8\x9d\xae
{0x8774,{0x4e,0x7f,0x3a,0x2f,0x7a,0x3f,0x7f}}, // \xe8\x9d\xb4
{0x8776,{0x4e,0x7b,0x5f,0x32,0x77,0x36,0x57}}, // \xe8\x9d\xb6
{0x8778,{0x4e,0x7b,0x2e,0x78,0x6f,0x09,0x7f}}, // \xe8\x9d\xb8
{0x877f,{0x4e,0x7b,0x4e,0x38,0x2f,0x77,0x5c}}, // \xe8\x9d\xbf
{0x8782,{0x4e,0x7b,0x3e,0x2b,0x0e,0x7f,0x1b}}, // \xe8\x9e\x82
{0x878d,{0x79,0x2f,0x6f,0x79,0x4e,0x7b,0x6e}}, // \xe8\x9e\x8d
{0x879f,{0x4e,0x7b,0x2e,0x53,0x1d,0x1d,0x53}}, // \xe8\x9e\x9f
{0x87a2,{0x4d,0x46,0x5d,0x7c,0x5d,0x26,0x4d}}, // \xe8\x9e\xa2
{0x87ab,{0x4a,0x47,0x7f,0x76,0x7a,0x25,0x4b}}, // \xe8\x9e\xab
{0x87af,{0x54,0x4e,0x7f,0x74,0x7a,0x25,0x4b}}, // \xe8\x9e\xaf
{0x87b3,{0x4e,0x7f,0x55,0x5e,0x7b,0x5e,0x55}}, // \xe8\x9e\xb3
{0x87ba,{0x4e,0x7b,0x57,0x1d,0x77,0x15,0x57}}, // \xe8\x9e\xba
{0x87bb,{0x4e,0x7f,0x54,0x7e,0x5b,0x3e,0x54}}, // \xe8\x9e\xbb
{0x87bd,{0x48,0x7a,0x36,0x4d,0x77,0x38,0x48}}, // \xe8\x9e\xbd
{0x87c0,{0x4e,0x7f,0x36,0x2a,0x77,0x2a,0x36}}, // \xe8\x9f\x80
{0x87c4,{0x44,0x4e,0x7f,0x7a,0x77,0x2e,0x48}}, // \xe8\x9f\x84
{0x87c6,{0x4e,0x7f,0x52,0x5f,0x36,0x5f,0x52}}, // \xe8\x9f\x86
{0x87c7,{0x2a,0x5a,0x5f,0x7e,0x5f,0x3a,0x52}}, // \xe8\x9f\x87
{0x87cb,{0x4e,0x7f,0x55,0x2f,0x5d,0x4f,0x55}}, // \xe8\x9f\x8b
{0x87d0,{0x4e,0x7b,0x35,0x1e,0x7b,0x1e,0x35}}, // \xe8\x9f\x90
{0x87d2,{0x4e,0x7f,0x2a,0x77,0x22,0x77,0x2a}}, // \xe8\x9f\x92
{0x87e0,{0x4e,0x7f,0x15,0x6f,0x7d,0x6f,0x15}}, // \xe8\x9f\xa0
{0x87ef,{0x4e,0x7b,0x5c,0x3e,0x17,0x7e,0x5c}}, // \xe8\x9f\xaf
{0x87f2,{0x48,0x7e,0x3e,0x4f,0x7e,0x36,0x48}}, // \xe8\x9f\xb2
{0x87f6,{0x4e,0x7b,0x45,0x57,0x7f,0x55,0x47}}, // \xe8\x9f\xb6
{0x87f7,{0x4e,0x7b,0x75,0x5e,0x7b,0x5e,0x75}}, // \xe8\x9f\xb7
{0x87f9,{0x52,0x4d,0x5f,0x78,0x5d,0x3b,0x4f}}, // \xe8\x9f\xb9
{0x87fb,{0x4e,0x7f,0x2a,0x7b,0x2e,0x3b,0x5a}}, // \xe8\x9f\xbb
{0x87fe,{0x4e,0x7b,0x3c,0x2e,0x75,0x7f,0x2c}}, // \xe8\x9f\xbe
{0x8805,{0x4e,0x7f,0x1b,0x7f,0x41,0x7f,0x5b}}, // \xe8\xa0\x85
{0x880d,{0x4e,0x7f,0x37,0x2d,0x5f,0x3b,0x46}}, // \xe8\xa0\x8d
{0x880e,{0x4e,0x7f,0x2a,0x67,0x3a,0x77,0x2a}}, // \xe8\xa0\x8e
{0x880f,{0x4e,0x7f,0x42,0x3d,0x7f,0x31,0x7b}}, // \xe8\xa0\x8f
{0x8811,{0x4e,0x7b,0x4d,0x36,0x7d,0x36,0x4d}}, // \xe8\xa0\x91
{0x8815,{0x4e,0x7f,0x66,0x2b,0x7f,0x2b,0x66}}, // \xe8\xa0\x95
{0x8816,{0x4e,0x7f,0x42,0x5f,0x2e,0x5f,0x4a}}, // \xe8\xa0\x96
{0x8821,{0x4a,0x7a,0x36,0x4b,0x7f,0x37,0x4a}}, // \xe8\xa0\xa1
{0x8822,{0x4a,0x76,0x33,0x4f,0x7f,0x36,0x4a}}, // \xe8\xa0\xa2
{0x8823,{0x4e,0x7b,0x2e,0x1f,0x6d,0x3f,0x6d}}, // \xe8\xa0\xa3
{0x8827,{0x4a,0x76,0x3e,0x4f,0x7e,0x36,0x4a}}, // \xe8\xa0\xa7
{0x8831,{0x50,0x7e,0x6e,0x77,0x7e,0x6e,0x54}}, // \xe8\xa0\xb1
{0x8836,{0x45,0x73,0x3f,0x4d,0x7b,0x37,0x45}}, // \xe8\xa0\xb6
{0x8839,{0x4a,0x76,0x3a,0x5f,0x7a,0x36,0x4a}}, // \xe8\xa0\xb9
{0x883b,{0x4a,0x5d,0x7a,0x77,0x7a,0x3d,0x48}}, // \xe8\xa0\xbb
{0x8840,{0x40,0x7e,0x43,0x7e,0x42,0x7e,0x40}}, // \xe8\xa1\x80
{0x8842,{0x40,0x7e,0x3f,0x45,0x3f,0x51,0x7f}}, // \xe8\xa1\x82
{0x8844,{0x40,0x7e,0x3f,0x49,0x7f,0x49,0x7f}}, // \xe8\xa1\x84
{0x8846,{0x54,0x2e,0x06,0x7f,0x16,0x26,0x54}}, // \xe8\xa1\x86
{0x884c,{0x0a,0x7d,0x04,0x05,0x45,0x7d,0x04}}, // \xe8\xa1\x8c
{0x884d,{0x0a,0x7d,0x00,0x75,0x00,0x45,0x7d}}, // \xe8\xa1\x8d
{0x8852,{0x0a,0x7d,0x2a,0x37,0x2a,0x45,0x7d}}, // \xe8\xa1\x92
{0x8853,{0x0a,0x7d,0x1a,0x7f,0x1a,0x45,0x7d}}, // \xe8\xa1\x93
{0x8857,{0x0a,0x7d,0x2a,0x3f,0x2a,0x45,0x7d}}, // \xe8\xa1\x97
{0x8859,{0x0a,0x7d,0x00,0x6d,0x6f,0x05,0x7d}}, // \xe8\xa1\x99
{0x885b,{0x0a,0x7d,0x2a,0x77,0x2e,0x45,0x7d}}, // \xe8\xa1\x9b
{0x885d,{0x0a,0x7d,0x5a,0x7e,0x59,0x05,0x7d}}, // \xe8\xa1\x9d
{0x885e,{0x0a,0x7d,0x3a,0x77,0x3e,0x45,0x7d}}, // \xe8\xa1\x9e
{0x8861,{0x0a,0x7d,0x5a,0x3d,0x5b,0x05,0x7d}}, // \xe8\xa1\xa1
{0x8862,{0x0a,0x7d,0x23,0x7b,0x70,0x5b,0x7d}}, // \xe8\xa1\xa2
{0x8863,{0x12,0x52,0x7a,0x47,0x1a,0x32,0x4a}}, // \xe8\xa1\xa3
{0x8868,{0x28,0x2a,0x7a,0x4f,0x1a,0x2a,0x50}}, // \xe8\xa1\xa8
{0x886b,{0x12,0x7b,0x36,0x00,0x4a,0x4a,0x25}}, // \xe8\xa1\xab
{0x8870,{0x2a,0x2a,0x7e,0x57,0x3e,0x4a,0x4a}}, // \xe8\xa1\xb0
{0x8872,{0x12,0x7b,0x36,0x7c,0x15,0x4f,0x7c}}, // \xe8\xa1\xb2
{0x8875,{0x12,0x7b,0x36,0x7f,0x49,0x49,0x7f}}, // \xe8\xa1\xb5
{0x8877,{0x22,0x2e,0x7a,0x4f,0x1a,0x2e,0x52}}, // \xe8\xa1\xb7
{0x887d,{0x12,0x7b,0x36,0x08,0x4a,0x7e,0x49}}, // \xe8\xa1\xbd
{0x887e,{0x54,0x34,0x76,0x55,0x3e,0x54,0x54}}, // \xe8\xa1\xbe
{0x887f,{0x12,0x7b,0x36,0x12,0x55,0x36,0x14}}, // \xe8\xa1\xbf
{0x8881,{0x44,0x3e,0x76,0x57,0x36,0x5e,0x44}}, // \xe8\xa2\x81
{0x8882,{0x12,0x7b,0x36,0x48,0x4a,0x3f,0x4e}}, // \xe8\xa2\x82
{0x8888,{0x5a,0x37,0x7a,0x5e,0x3e,0x5a,0x5e}}, // \xe8\xa2\x88
{0x888b,{0x54,0x3e,0x71,0x5a,0x33,0x56,0x5b}}, // \xe8\xa2\x8b
{0x888d,{0x12,0x7b,0x36,0x04,0x7b,0x5a,0x5e}}, // \xe8\xa2\x8d
{0x8892,{0x12,0x7b,0x36,0x40,0x5f,0x55,0x5f}}, // \xe8\xa2\x92
{0x8896,{0x12,0x7b,0x36,0x7e,0x4a,0x7f,0x7e}}, // \xe8\xa2\x96
{0x8897,{0x12,0x7b,0x36,0x42,0x55,0x2a,0x14}}, // \xe8\xa2\x97
{0x8899,{0x12,0x7b,0x36,0x7e,0x4b,0x4a,0x7e}}, // \xe8\xa2\x99
{0x889e,{0x2a,0x26,0x7a,0x5b,0x3a,0x46,0x4a}}, // \xe8\xa2\x9e
{0x88a2,{0x12,0x7b,0x36,0x2a,0x29,0x7c,0x29}}, // \xe8\xa2\xa2
{0x88a4,{0x52,0x36,0x6e,0x5f,0x2e,0x4a,0x5a}}, // \xe8\xa2\xa4
{0x88ab,{0x12,0x7b,0x36,0x7e,0x5a,0x2f,0x5e}}, // \xe8\xa2\xab
{0x88ae,{0x12,0x7b,0x36,0x24,0x5b,0x7e,0x32}}, // \xe8\xa2\xae
{0x88b0,{0x54,0x3c,0x77,0x5f,0x35,0x5f,0x54}}, // \xe8\xa2\xb0
{0x88b1,{0x12,0x7b,0x7e,0x01,0x44,0x3f,0x45}}, // \xe8\xa2\xb1
{0x88b4,{0x12,0x7b,0x36,0x0a,0x1e,0x57,0x6a}}, // \xe8\xa2\xb4
{0x88b5,{0x12,0x7b,0x7e,0x01,0x4a,0x7e,0x49}}, // \xe8\xa2\xb5
{0x88b7,{0x12,0x7b,0x36,0x00,0x76,0x55,0x76}}, // \xe8\xa2\xb7
{0x88bf,{0x12,0x7b,0x36,0x48,0x5a,0x7f,0x5a}}, // \xe8\xa2\xbf
{0x88c1,{0x28,0x7a,0x5f,0x2a,0x4f,0x38,0x5a}}, // \xe8\xa3\x81
{0x88c2,{0x55,0x3b,0x77,0x51,0x36,0x50,0x5f}}, // \xe8\xa3\x82
{0x88c3,{0x12,0x7b,0x36,0x08,0x7f,0x1a,0x2a}}, // \xe8\xa3\x83
{0x88c4,{0x12,0x7b,0x36,0x7d,0x00,0x45,0x7d}}, // \xe8\xa3\x84
{0x88c5,{0x5a,0x3f,0x72,0x5a,0x3f,0x5a,0x52}}, // \xe8\xa3\x85
{0x88cf,{0x52,0x3e,0x7a,0x5f,0x3a,0x5e,0x52}}, // \xe8\xa3\x8f
{0x88d4,{0x7a,0x36,0x1e,0x7b,0x76,0x1a,0x7a}}, // \xe8\xa3\x94
{0x88d5,{0x12,0x7b,0x36,0x09,0x64,0x69,0x12}}, // \xe8\xa3\x95
{0x88d8,{0x5a,0x36,0x7a,0x5f,0x36,0x5b,0x52}}, // \xe8\xa3\x98
{0x88d9,{0x12,0x7b,0x36,0x25,0x7f,0x75,0x6f}}, // \xe8\xa3\x99
{0x88dc,{0x12,0x7b,0x36,0x7a,0x7f,0x2a,0x7b}}, // \xe8\xa3\x9c
{0x88dd,{0x5b,0x36,0x7f,0x52,0x3a,0x5f,0x5a}}, // \xe8\xa3\x9d
{0x88df,{0x55,0x30,0x7a,0x58,0x37,0x54,0x52}}, // \xe8\xa3\x9f
{0x88e1,{0x12,0x7b,0x36,0x5f,0x55,0x7f,0x5f}}, // \xe8\xa3\xa1
{0x88e8,{0x12,0x7b,0x36,0x2e,0x3f,0x7a,0x2e}}, // \xe8\xa3\xa8
{0x88f2,{0x12,0x7b,0x36,0x7d,0x35,0x7f,0x7d}}, // \xe8\xa3\xb2
{0x88f3,{0x56,0x33,0x7e,0x5b,0x3e,0x53,0x56}}, // \xe8\xa3\xb3
{0x88f4,{0x56,0x36,0x7f,0x50,0x3f,0x56,0x56}}, // \xe8\xa3\xb4
{0x88f8,{0x12,0x7b,0x57,0x35,0x7f,0x35,0x57}}, // \xe8\xa3\xb8
{0x88f9,{0x52,0x2a,0x7e,0x5f,0x2e,0x4a,0x52}}, // \xe8\xa3\xb9
{0x88fc,{0x12,0x7b,0x36,0x27,0x5d,0x35,0x77}}, // \xe8\xa3\xbc
{0x88fd,{0x54,0x3b,0x7f,0x5a,0x36,0x50,0x5f}}, // \xe8\xa3\xbd
{0x88fe,{0x12,0x7b,0x36,0x1f,0x6b,0x5f,0x6b}}, // \xe8\xa3\xbe
{0x8902,{0x12,0x7b,0x36,0x3f,0x2a,0x7f,0x08}}, // \xe8\xa4\x82
{0x8904,{0x12,0x7b,0x36,0x5a,0x7f,0x3e,0x52}}, // \xe8\xa4\x84
{0x8907,{0x12,0x7b,0x36,0x53,0x2e,0x5e,0x42}}, // \xe8\xa4\x87
{0x890a,{0x12,0x7b,0x36,0x21,0x7f,0x35,0x77}}, // \xe8\xa4\x8a
{0x890c,{0x12,0x7b,0x36,0x27,0x3d,0x7f,0x27}}, // \xe8\xa4\x8c
{0x8910,{0x12,0x7b,0x36,0x3f,0x2d,0x4f,0x78}}, // \xe8\xa4\x90
{0x8912,{0x2a,0x2e,0x72,0x4f,0x1a,0x2e,0x52}}, // \xe8\xa4\x92
{0x8913,{0x12,0x7b,0x7e,0x37,0x7d,0x37,0x50}}, // \xe8\xa4\x93
{0x891d,{0x12,0x7b,0x36,0x2d,0x2d,0x7e,0x2d}}, // \xe8\xa4\x9d
{0x891e,{0x12,0x7b,0x36,0x4f,0x6d,0x6b,0x4f}}, // \xe8\xa4\x9e
{0x8925,{0x12,0x7b,0x3e,0x37,0x5f,0x7b,0x15}}, // \xe8\xa4\xa5
{0x892a,{0x12,0x7b,0x36,0x65,0x50,0x4f,0x57}}, // \xe8\xa4\xaa
{0x892b,{0x12,0x7b,0x3f,0x5d,0x25,0x6f,0x4b}}, // \xe8\xa4\xab
{0x8936,{0x12,0x7b,0x36,0x05,0x6f,0x75,0x6f}}, // \xe8\xa4\xb6
{0x8938,{0x12,0x7b,0x56,0x7e,0x5b,0x3e,0x54}}, // \xe8\xa4\xb8
{0x893b,{0x56,0x3e,0x7e,0x57,0x2e,0x5e,0x52}}, // \xe8\xa4\xbb
{0x8941,{0x12,0x7b,0x36,0x5d,0x77,0x7e,0x5d}}, // \xe8\xa5\x81
{0x8943,{0x2a,0x36,0x72,0x4f,0x1a,0x2e,0x52}}, // \xe8\xa5\x83
{0x8944,{0x52,0x36,0x7e,0x5b,0x3e,0x56,0x52}}, // \xe8\xa5\x84
{0x894c,{0x12,0x7b,0x36,0x23,0x3f,0x7c,0x23}}, // \xe8\xa5\x8c
{0x894d,{0x12,0x7b,0x56,0x3c,0x7b,0x3e,0x5b}}, // \xe8\xa5\x8d
{0x8956,{0x12,0x7b,0x36,0x5e,0x5b,0x36,0x5e}}, // \xe8\xa5\x96
{0x895e,{0x54,0x3f,0x7b,0x50,0x36,0x5b,0x56}}, // \xe8\xa5\x9e
{0x895f,{0x12,0x7b,0x56,0x1f,0x78,0x1a,0x57}}, // \xe8\xa5\x9f
{0x8960,{0x12,0x7b,0x77,0x5e,0x7b,0x5e,0x75}}, // \xe8\xa5\xa0
{0x8964,{0x12,0x7b,0x36,0x4f,0x60,0x6b,0x4a}}, // \xe8\xa5\xa4
{0x8966,{0x12,0x7b,0x76,0x2b,0x7f,0x2b,0x66}}, // \xe8\xa5\xa6
{0x896a,{0x12,0x7b,0x36,0x7a,0x4f,0x3e,0x5b}}, // \xe8\xa5\xaa
{0x896d,{0x12,0x7b,0x36,0x6f,0x6a,0x1f,0x5d}}, // \xe8\xa5\xad
{0x896f,{0x12,0x7b,0x36,0x7b,0x56,0x3f,0x5f}}, // \xe8\xa5\xaf
{0x8972,{0x5a,0x3e,0x7b,0x5e,0x3a,0x57,0x5d}}, // \xe8\xa5\xb2
{0x8974,{0x12,0x7b,0x7f,0x2b,0x7c,0x2b,0x7f}}, // \xe8\xa5\xb4
{0x8977,{0x12,0x7b,0x2e,0x79,0x7e,0x3d,0x2f}}, // \xe8\xa5\xb7
{0x897e,{0x7a,0x0a,0x3e,0x2a,0x3e,0x0a,0x7a}}, // \xe8\xa5\xbe
{0x897f,{0x7d,0x55,0x4f,0x45,0x5f,0x55,0x7d}}, // \xe8\xa5\xbf
{0x8981,{0x51,0x57,0x75,0x5f,0x35,0x57,0x51}}, // \xe8\xa6\x81
{0x8983,{0x21,0x27,0x3b,0x6f,0x3b,0x27,0x21}}, // \xe8\xa6\x83
{0x8986,{0x29,0x77,0x45,0x57,0x2d,0x5f,0x41}}, // \xe8\xa6\x86
{0x8987,{0x29,0x77,0x2d,0x47,0x3d,0x2f,0x79}}, // \xe8\xa6\x87
{0x8988,{0x59,0x3f,0x7b,0x17,0x5b,0x2f,0x59}}, // \xe8\xa6\x88
{0x898a,{0x29,0x77,0x2b,0x47,0x1b,0x5f,0x69}}, // \xe8\xa6\x8a
{0x898b,{0x40,0x5f,0x35,0x15,0x75,0x5f,0x60}}, // \xe8\xa6\x8b
{0x898f,{0x4a,0x3f,0x2a,0x5f,0x35,0x75,0x5f}}, // \xe8\xa6\x8f
{0x8993,{0x44,0x43,0x3d,0x17,0x75,0x5d,0x62}}, // \xe8\xa6\x93
{0x8996,{0x12,0x7b,0x16,0x5f,0x35,0x75,0x5f}}, // \xe8\xa6\x96
{0x8997,{0x35,0x35,0x7f,0x40,0x3f,0x75,0x5f}}, // \xe8\xa6\x97
{0x8998,{0x70,0x5f,0x74,0x5f,0x35,0x75,0x5f}}, // \xe8\xa6\x98
{0x899a,{0x46,0x43,0x3e,0x2b,0x7e,0x43,0x66}}, // \xe8\xa6\x9a
{0x89a1,{0x51,0x4d,0x3f,0x2d,0x5f,0x35,0x5f}}, // \xe8\xa6\xa1
{0x89a6,{0x75,0x73,0x25,0x56,0x3f,0x75,0x5f}}, // \xe8\xa6\xa6
{0x89a7,{0x47,0x47,0x3d,0x38,0x7b,0x46,0x66}}, // \xe8\xa6\xa7
{0x89a9,{0x28,0x1a,0x6f,0x6a,0x5f,0x35,0x5f}}, // \xe8\xa6\xa9
{0x89aa,{0x52,0x36,0x7b,0x36,0x5f,0x35,0x5f}}, // \xe8\xa6\xaa
{0x89ac,{0x4b,0x5a,0x6b,0x5a,0x3f,0x75,0x5f}}, // \xe8\xa6\xac
{0x89af,{0x2a,0x7f,0x3a,0x7f,0x5f,0x35,0x5f}}, // \xe8\xa6\xaf
{0x89b2,{0x5a,0x5f,0x7a,0x5f,0x3f,0x75,0x5f}}, // \xe8\xa6\xb2
{0x89b3,{0x14,0x7b,0x7e,0x4a,0x3f,0x75,0x5f}}, // \xe8\xa6\xb3
{0x89ba,{0x4c,0x46,0x3d,0x2e,0x7d,0x47,0x6c}}, // \xe8\xa6\xba
{0x89bd,{0x47,0x47,0x3d,0x38,0x7f,0x46,0x66}}, // \xe8\xa6\xbd
{0x89bf,{0x4e,0x3e,0x3b,0x4e,0x3f,0x75,0x5f}}, // \xe8\xa6\xbf
{0x89c0,{0x26,0x7f,0x7a,0x57,0x3f,0x75,0x5f}}, // \xe8\xa7\x80
{0x89d2,{0x42,0x3e,0x15,0x1d,0x17,0x54,0x7c}}, // \xe8\xa7\x92
{0x89da,{0x42,0x3d,0x7f,0x3e,0x42,0x3e,0x61}}, // \xe8\xa7\x9a
{0x89dc,{0x4e,0x38,0x2f,0x3a,0x28,0x7f,0x0a}}, // \xe8\xa7\x9c
{0x89dd,{0x42,0x3d,0x7f,0x7e,0x4a,0x5e,0x69}}, // \xe8\xa7\x9d
{0x89e3,{0x42,0x3d,0x5f,0x7c,0x2d,0x7b,0x2f}}, // \xe8\xa7\xa3
{0x89e6,{0x42,0x3d,0x7f,0x4a,0x7f,0x4a,0x6e}}, // \xe8\xa7\xa6
{0x89e7,{0x42,0x3d,0x7f,0x22,0x2b,0x7e,0x2b}}, // \xe8\xa7\xa7
{0x89f4,{0x42,0x3d,0x7f,0x24,0x5f,0x3e,0x72}}, // \xe8\xa7\xb4
{0x89f8,{0x42,0x3d,0x7f,0x4b,0x75,0x37,0x7f}}, // \xe8\xa7\xb8
{0x8a00,{0x02,0x62,0x6b,0x6b,0x6b,0x62,0x02}}, // \xe8\xa8\x80
{0x8a02,{0x6a,0x6b,0x62,0x01,0x41,0x7f,0x01}}, // \xe8\xa8\x82
{0x8a03,{0x6a,0x6b,0x62,0x00,0x7f,0x08,0x10}}, // \xe8\xa8\x83
{0x8a08,{0x6a,0x6b,0x62,0x04,0x04,0x7f,0x04}}, // \xe8\xa8\x88
{0x8a0a,{0x6b,0x62,0x49,0x3f,0x05,0x7f,0x40}}, // \xe8\xa8\x8a
{0x8a0c,{0x6a,0x6b,0x00,0x42,0x42,0x7e,0x42}}, // \xe8\xa8\x8c
{0x8a0e,{0x6a,0x6b,0x00,0x0a,0x52,0x7f,0x02}}, // \xe8\xa8\x8e
{0x8a10,{0x6a,0x63,0x08,0x09,0x7f,0x09,0x08}}, // \xe8\xa8\x90
{0x8a13,{0x6a,0x6b,0x40,0x3f,0x1e,0x00,0x7f}}, // \xe8\xa8\x93
{0x8a16,{0x6a,0x6b,0x04,0x23,0x56,0x4e,0x62}}, // \xe8\xa8\x96
{0x8a17,{0x6a,0x63,0x08,0x0a,0x7e,0x49,0x68}}, // \xe8\xa8\x97
{0x8a18,{0x6a,0x6b,0x02,0x79,0x49,0x49,0x6f}}, // \xe8\xa8\x98
{0x8a1b,{0x6a,0x6b,0x04,0x7e,0x01,0x7f,0x44}}, // \xe8\xa8\x9b
{0x8a1d,{0x6a,0x63,0x28,0x2f,0x59,0x7f,0x09}}, // \xe8\xa8\x9d
{0x8a1f,{0x6a,0x6b,0x44,0x63,0x58,0x23,0x44}}, // \xe8\xa8\x9f
{0x8a23,{0x6a,0x63,0x48,0x4a,0x3f,0x4e,0x48}}, // \xe8\xa8\xa3
{0x8a25,{0x6a,0x6b,0x7c,0x15,0x0f,0x54,0x7c}}, // \xe8\xa8\xa5
{0x8a2a,{0x6a,0x6b,0x42,0x3e,0x0b,0x4a,0x7a}}, // \xe8\xa8\xaa
{0x8a2d,{0x6a,0x6b,0x44,0x5b,0x29,0x5f,0x44}}, // \xe8\xa8\xad
{0x8a31,{0x6a,0x6b,0x14,0x13,0x7e,0x12,0x10}}, // \xe8\xa8\xb1
{0x8a33,{0x6a,0x6b,0x40,0x3f,0x05,0x1d,0x67}}, // \xe8\xa8\xb3
{0x8a34,{0x6a,0x6b,0x40,0x3e,0x1a,0x79,0x28}}, // \xe8\xa8\xb4
{0x8a36,{0x6a,0x6b,0x02,0x1d,0x15,0x5d,0x7f}}, // \xe8\xa8\xb6
{0x8a3a,{0x6a,0x6b,0x04,0x42,0x55,0x2a,0x14}}, // \xe8\xa8\xba
{0x8a3b,{0x6a,0x6b,0x44,0x55,0x7e,0x54,0x44}}, // \xe8\xa8\xbb
{0x8a3c,{0x6a,0x6b,0x42,0x79,0x41,0x7f,0x49}}, // \xe8\xa8\xbc
{0x8a41,{0x6a,0x6b,0x04,0x74,0x5f,0x74,0x04}}, // \xe8\xa9\x81
{0x8a46,{0x6a,0x6b,0x00,0x7e,0x4a,0x5e,0x69}}, // \xe8\xa9\x86
{0x8a48,{0x17,0x75,0x5f,0x5d,0x5f,0x75,0x17}}, // \xe8\xa9\x88
{0x8a50,{0x6a,0x6b,0x04,0x03,0x7e,0x2a,0x2a}}, // \xe8\xa9\x90
{0x8a51,{0x6a,0x6b,0x06,0x7a,0x53,0x4a,0x66}}, // \xe8\xa9\x91
{0x8a52,{0x6a,0x63,0x08,0x6c,0x6b,0x64,0x08}}, // \xe8\xa9\x92
{0x8a54,{0x6a,0x6b,0x02,0x75,0x53,0x59,0x7f}}, // \xe8\xa9\x94
{0x8a55,{0x6b,0x6a,0x15,0x11,0x7f,0x11,0x15}}, // \xe8\xa9\x95
{0x8a5b,{0x6a,0x6b,0x40,0x7f,0x55,0x7f,0x40}}, // \xe8\xa9\x9b
{0x8a5e,{0x6a,0x6b,0x02,0x35,0x35,0x41,0x7f}}, // \xe8\xa9\x9e
{0x8a60,{0x6a,0x63,0x28,0x5d,0x7d,0x10,0x28}}, // \xe8\xa9\xa0
{0x8a62,{0x6a,0x6b,0x04,0x3f,0x2a,0x3e,0x7e}}, // \xe8\xa9\xa2
{0x8a63,{0x6a,0x6b,0x00,0x6f,0x6a,0x6a,0x6d}}, // \xe8\xa9\xa3
{0x8a66,{0x6a,0x6b,0x54,0x74,0x57,0x3c,0x45}}, // \xe8\xa9\xa6
{0x8a69,{0x6a,0x63,0x28,0x6a,0x2f,0x7a,0x28}}, // \xe8\xa9\xa9
{0x8a6b,{0x6a,0x63,0x16,0x1a,0x7b,0x56,0x56}}, // \xe8\xa9\xab
{0x8a6c,{0x6a,0x6b,0x40,0x3e,0x0a,0x6a,0x69}}, // \xe8\xa9\xac
{0x8a6d,{0x6a,0x6b,0x42,0x3e,0x7d,0x4f,0x5c}}, // \xe8\xa9\xad
{0x8a6e,{0x6a,0x6b,0x44,0x56,0x7d,0x56,0x44}}, // \xe8\xa9\xae
{0x8a70,{0x6a,0x6b,0x02,0x6a,0x6f,0x6a,0x02}}, // \xe8\xa9\xb0
{0x8a71,{0x6a,0x6b,0x04,0x76,0x5e,0x75,0x04}}, // \xe8\xa9\xb1
{0x8a72,{0x6a,0x6b,0x00,0x4a,0x56,0x2b,0x52}}, // \xe8\xa9\xb2
{0x8a73,{0x6b,0x6a,0x22,0x2b,0x7e,0x2b,0x22}}, // \xe8\xa9\xb3
{0x8a7c,{0x6a,0x63,0x0a,0x57,0x42,0x3a,0x52}}, // \xe8\xa9\xbc
{0x8a82,{0x6a,0x63,0x4a,0x3f,0x00,0x7f,0x4a}}, // \xe8\xaa\x82
{0x8a84,{0x6a,0x6b,0x52,0x36,0x7f,0x36,0x55}}, // \xe8\xaa\x84
{0x8a85,{0x6a,0x63,0x4c,0x2b,0x7f,0x2a,0x48}}, // \xe8\xaa\x85
{0x8a87,{0x6a,0x63,0x0a,0x16,0x1b,0x56,0x6a}}, // \xe8\xaa\x87
{0x8a89,{0x0a,0x67,0x6a,0x6b,0x6a,0x67,0x0a}}, // \xe8\xaa\x89
{0x8a8c,{0x6a,0x6b,0x42,0x2a,0x4f,0x4a,0x62}}, // \xe8\xaa\x8c
{0x8a8d,{0x6a,0x6b,0x40,0x2b,0x45,0x4b,0x6f}}, // \xe8\xaa\x8d
{0x8a91,{0x6b,0x62,0x55,0x3e,0x49,0x7f,0x49}}, // \xe8\xaa\x91
{0x8a93,{0x2a,0x3f,0x70,0x6e,0x66,0x3d,0x24}}, // \xe8\xaa\x93
{0x8a95,{0x6b,0x62,0x55,0x3b,0x52,0x5e,0x55}}, // \xe8\xaa\x95
{0x8a98,{0x6a,0x63,0x5a,0x37,0x1f,0x37,0x6a}}, // \xe8\xaa\x98
{0x8a9a,{0x6a,0x6b,0x02,0x7d,0x2a,0x7d,0x02}}, // \xe8\xaa\x9a
{0x8a9e,{0x6a,0x6b,0x14,0x7d,0x57,0x7d,0x10}}, // \xe8\xaa\x9e
{0x8aa0,{0x6a,0x63,0x7e,0x2a,0x5a,0x3f,0x52}}, // \xe8\xaa\xa0
{0x8aa1,{0x6a,0x63,0x0a,0x3e,0x4a,0x3f,0x52}}, // \xe8\xaa\xa1
{0x8aa3,{0x6b,0x6a,0x51,0x4d,0x7f,0x4d,0x51}}, // \xe8\xaa\xa3
{0x8aa4,{0x6a,0x6b,0x00,0x56,0x14,0x1f,0x53}}, // \xe8\xaa\xa4
{0x8aa5,{0x6a,0x63,0x0c,0x6b,0x7f,0x6a,0x08}}, // \xe8\xaa\xa5
{0x8aa6,{0x6a,0x6b,0x7c,0x15,0x7d,0x17,0x7d}}, // \xe8\xaa\xa6
{0x8aa8,{0x6a,0x6b,0x14,0x33,0x2e,0x7e,0x12}}, // \xe8\xaa\xa8
{0x8aac,{0x6b,0x62,0x4e,0x3b,0x0a,0x7b,0x4e}}, // \xe8\xaa\xac
{0x8aad,{0x6a,0x63,0x5a,0x2a,0x0f,0x6a,0x5a}}, // \xe8\xaa\xad
{0x8ab0,{0x6a,0x6b,0x04,0x7f,0x4a,0x7f,0x4a}}, // \xe8\xaa\xb0
{0x8ab2,{0x6b,0x6a,0x57,0x35,0x7f,0x35,0x57}}, // \xe8\xaa\xb2
{0x8ab9,{0x6a,0x63,0x2a,0x7f,0x00,0x7f,0x2a}}, // \xe8\xaa\xb9
{0x8abc,{0x6a,0x6b,0x00,0x46,0x7a,0x7b,0x46}}, // \xe8\xaa\xbc
{0x8abf,{0x6b,0x62,0x7f,0x35,0x2f,0x35,0x7f}}, // \xe8\xaa\xbf
{0x8ac2,{0x6a,0x6b,0x00,0x7a,0x41,0x6d,0x7b}}, // \xe8\xab\x82
{0x8ac4,{0x6a,0x6b,0x22,0x2e,0x6b,0x3e,0x22}}, // \xe8\xab\x84
{0x8ac7,{0x6b,0x6a,0x55,0x22,0x19,0x22,0x55}}, // \xe8\xab\x87
{0x8acb,{0x6a,0x63,0x08,0x7a,0x2f,0x7a,0x08}}, // \xe8\xab\x8b
{0x8acc,{0x6a,0x6b,0x42,0x2e,0x7f,0x2e,0x42}}, // \xe8\xab\x8c
{0x8acd,{0x6a,0x6b,0x12,0x55,0x7f,0x3d,0x12}}, // \xe8\xab\x8d
{0x8acf,{0x6b,0x6a,0x21,0x3f,0x7f,0x12,0x2e}}, // \xe8\xab\x8f
{0x8ad2,{0x6a,0x6b,0x22,0x4e,0x7b,0x0e,0x22}}, // \xe8\xab\x92
{0x8ad6,{0x6a,0x6b,0x74,0x32,0x75,0x36,0x74}}, // \xe8\xab\x96
{0x8ada,{0x6a,0x63,0x46,0x32,0x46,0x7f,0x56}}, // \xe8\xab\x9a
{0x8adb,{0x6a,0x63,0x5e,0x55,0x3e,0x52,0x5e}}, // \xe8\xab\x9b
{0x8adc,{0x6b,0x62,0x5f,0x32,0x77,0x36,0x57}}, // \xe8\xab\x9c
{0x8ade,{0x6b,0x6a,0x41,0x3f,0x75,0x37,0x71}}, // \xe8\xab\x9e
{0x8ae0,{0x6a,0x6b,0x00,0x46,0x72,0x77,0x46}}, // \xe8\xab\xa0
{0x8ae1,{0x6a,0x6b,0x42,0x71,0x76,0x7d,0x42}}, // \xe8\xab\xa1
{0x8ae2,{0x6b,0x6a,0x27,0x3d,0x7f,0x3d,0x27}}, // \xe8\xab\xa2
{0x8ae4,{0x6a,0x6b,0x00,0x0b,0x1f,0x5c,0x6b}}, // \xe8\xab\xa4
{0x8ae6,{0x6a,0x63,0x1a,0x6e,0x3b,0x6e,0x1a}}, // \xe8\xab\xa6
{0x8ae7,{0x6b,0x62,0x0f,0x6a,0x70,0x6f,0x0a}}, // \xe8\xab\xa7
{0x8aeb,{0x6a,0x6b,0x42,0x2e,0x7f,0x2e,0x4e}}, // \xe8\xab\xab
{0x8aed,{0x6a,0x6b,0x04,0x72,0x75,0x06,0x74}}, // \xe8\xab\xad
{0x8aee,{0x6b,0x6a,0x11,0x64,0x73,0x6e,0x76}}, // \xe8\xab\xae
{0x8af1,{0x6a,0x63,0x28,0x3a,0x2f,0x7a,0x2e}}, // \xe8\xab\xb1
{0x8af3,{0x6a,0x63,0x0a,0x6e,0x6b,0x6e,0x0a}}, // \xe8\xab\xb3
{0x8af7,{0x6b,0x62,0x3f,0x4d,0x7f,0x2d,0x7f}}, // \xe8\xab\xb7
{0x8af8,{0x6a,0x63,0x28,0x1a,0x6f,0x6a,0x69}}, // \xe8\xab\xb8
{0x8afa,{0x6a,0x63,0x7a,0x0e,0x5b,0x4e,0x2a}}, // \xe8\xab\xba
{0x8afe,{0x6b,0x62,0x2a,0x1f,0x6a,0x6b,0x6a}}, // \xe8\xab\xbe
{0x8b00,{0x6b,0x6a,0x52,0x3f,0x7a,0x3f,0x52}}, // \xe8\xac\x80
{0x8b01,{0x6a,0x6b,0x10,0x3f,0x2d,0x4f,0x78}}, // \xe8\xac\x81
{0x8b02,{0x6b,0x62,0x0f,0x7d,0x2f,0x7d,0x0f}}, // \xe8\xac\x82
{0x8b04,{0x7f,0x15,0x7f,0x15,0x6c,0x6f,0x15}}, // \xe8\xac\x84
{0x8b07,{0x16,0x6a,0x7e,0x7b,0x7e,0x6a,0x16}}, // \xe8\xac\x87
{0x8b0c,{0x6a,0x6b,0x02,0x2d,0x49,0x7f,0x09}}, // \xe8\xac\x8c
{0x8b0e,{0x6b,0x62,0x79,0x54,0x4d,0x7e,0x55}}, // \xe8\xac\x8e
{0x8b10,{0x6a,0x6b,0x54,0x6e,0x79,0x74,0x5a}}, // \xe8\xac\x90
{0x8b14,{0x6a,0x6b,0x42,0x3c,0x74,0x5f,0x5a}}, // \xe8\xac\x94
{0x8b16,{0x6a,0x6b,0x44,0x53,0x2b,0x5f,0x44}}, // \xe8\xac\x96
{0x8b17,{0x6a,0x63,0x1a,0x4e,0x3b,0x6e,0x1a}}, // \xe8\xac\x97
{0x8b19,{0x6b,0x6a,0x52,0x37,0x7e,0x3f,0x4a}}, // \xe8\xac\x99
{0x8b1a,{0x6a,0x6b,0x52,0x6d,0x64,0x6d,0x52}}, // \xe8\xac\x9a
{0x8b1b,{0x6b,0x62,0x2a,0x7f,0x3a,0x7f,0x2a}}, // \xe8\xac\x9b
{0x8b1d,{0x6a,0x63,0x5e,0x2b,0x7e,0x1a,0x7f}}, // \xe8\xac\x9d
{0x8b20,{0x6a,0x6b,0x10,0x6a,0x4d,0x7b,0x68}}, // \xe8\xac\xa0
{0x8b21,{0x6a,0x6b,0x60,0x4a,0x7e,0x49,0x6b}}, // \xe8\xac\xa1
{0x8b26,{0x1a,0x76,0x57,0x52,0x5b,0x75,0x1b}}, // \xe8\xac\xa6
{0x8b28,{0x6b,0x6a,0x52,0x5f,0x36,0x5f,0x52}}, // \xe8\xac\xa8
{0x8b2b,{0x6a,0x63,0x7a,0x6e,0x5b,0x6e,0x7a}}, // \xe8\xac\xab
{0x8b2c,{0x6b,0x6a,0x11,0x4b,0x54,0x29,0x13}}, // \xe8\xac\xac
{0x8b33,{0x6b,0x62,0x7f,0x71,0x47,0x77,0x71}}, // \xe8\xac\xb3
{0x8b39,{0x6b,0x62,0x5a,0x5f,0x7a,0x5f,0x5a}}, // \xe8\xac\xb9
{0x8b3e,{0x6a,0x63,0x4c,0x5f,0x2d,0x5f,0x4c}}, // \xe8\xac\xbe
{0x8b41,{0x6b,0x62,0x2a,0x3f,0x7e,0x3f,0x2a}}, // \xe8\xad\x81
{0x8b49,{0x6b,0x6a,0x45,0x5b,0x69,0x5a,0x45}}, // \xe8\xad\x89
{0x8b4c,{0x6a,0x6b,0x52,0x1d,0x57,0x1d,0x72}}, // \xe8\xad\x8c
{0x8b4e,{0x6a,0x63,0x7a,0x37,0x5f,0x33,0x76}}, // \xe8\xad\x8e
{0x8b4f,{0x6a,0x63,0x4a,0x3d,0x48,0x3a,0x55}}, // \xe8\xad\x8f
{0x8b56,{0x6a,0x63,0x14,0x6f,0x76,0x6f,0x16}}, // \xe8\xad\x96
{0x8b58,{0x6a,0x63,0x0a,0x6f,0x6e,0x3f,0x55}}, // \xe8\xad\x98
{0x8b5a,{0x6b,0x6a,0x21,0x3b,0x6b,0x3b,0x21}}, // \xe8\xad\x9a
{0x8b5b,{0x6b,0x62,0x0a,0x77,0x5a,0x77,0x0a}}, // \xe8\xad\x9b
{0x8b5c,{0x6b,0x62,0x2a,0x7f,0x62,0x7f,0x2a}}, // \xe8\xad\x9c
{0x8b5f,{0x6a,0x63,0x5c,0x37,0x7d,0x37,0x5c}}, // \xe8\xad\x9f
{0x8b66,{0x2a,0x27,0x76,0x7f,0x6a,0x25,0x2b}}, // \xe8\xad\xa6
{0x8b6b,{0x6a,0x63,0x3c,0x2e,0x75,0x7f,0x2c}}, // \xe8\xad\xab
{0x8b6c,{0x04,0x6f,0x6b,0x68,0x6e,0x6b,0x06}}, // \xe8\xad\xac
{0x8b6f,{0x6b,0x62,0x2b,0x3b,0x6f,0x3b,0x2b}}, // \xe8\xad\xaf
{0x8b70,{0x6b,0x62,0x2a,0x7b,0x2e,0x3b,0x5a}}, // \xe8\xad\xb0
{0x8b71,{0x6a,0x6e,0x07,0x7e,0x06,0x6f,0x6a}}, // \xe8\xad\xb1
{0x8b72,{0x6a,0x63,0x1a,0x7e,0x53,0x3e,0x5a}}, // \xe8\xad\xb2
{0x8b74,{0x6b,0x62,0x75,0x4e,0x7a,0x7f,0x6e}}, // \xe8\xad\xb4
{0x8b77,{0x6b,0x6a,0x42,0x5f,0x2e,0x5f,0x4a}}, // \xe8\xad\xb7
{0x8b7d,{0x28,0x1e,0x69,0x6e,0x6d,0x1f,0x28}}, // \xe8\xad\xbd
{0x8b80,{0x6a,0x63,0x4e,0x3e,0x3b,0x3e,0x4e}}, // \xe8\xae\x80
{0x8b83,{0x6b,0x62,0x4a,0x37,0x3a,0x37,0x4a}}, // \xe8\xae\x83
{0x8b8a,{0x52,0x4d,0x5a,0x2f,0x2a,0x5d,0x48}}, // \xe8\xae\x8a
{0x8b8c,{0x6b,0x6a,0x52,0x1f,0x56,0x1f,0x52}}, // \xe8\xae\x8c
{0x8b8e,{0x04,0x7f,0x7e,0x6b,0x6a,0x7e,0x55}}, // \xe8\xae\x8e
{0x8b90,{0x14,0x7f,0x5e,0x5b,0x54,0x7f,0x1a}}, // \xe8\xae\x90
{0x8b92,{0x6a,0x6b,0x52,0x5e,0x2d,0x7f,0x56}}, // \xe8\xae\x92
{0x8b93,{0x6a,0x6b,0x36,0x7e,0x5b,0x3e,0x56}}, // \xe8\xae\x93
{0x8b96,{0x6b,0x6a,0x55,0x7e,0x55,0x3f,0x55}}, // \xe8\xae\x96
{0x8b99,{0x6b,0x6a,0x26,0x7f,0x52,0x7f,0x56}}, // \xe8\xae\x99
{0x8b9a,{0x6b,0x62,0x4b,0x36,0x3b,0x36,0x4a}}, // \xe8\xae\x9a
{0x8c37,{0x10,0x12,0x69,0x64,0x69,0x12,0x10}}, // \xe8\xb0\xb7
{0x8c3a,{0x12,0x69,0x64,0x69,0x2f,0x59,0x7f}}, // \xe8\xb0\xba
{0x8c3f,{0x52,0x5b,0x35,0x5a,0x09,0x64,0x69}}, // \xe8\xb0\xbf
{0x8c41,{0x26,0x6a,0x7f,0x6e,0x09,0x64,0x69}}, // \xe8\xb1\x81
{0x8c46,{0x41,0x5d,0x75,0x55,0x75,0x5d,0x41}}, // \xe8\xb1\x86
{0x8c48,{0x48,0x5b,0x6a,0x6b,0x6a,0x5b,0x48}}, // \xe8\xb1\x88
{0x8c4a,{0x48,0x5e,0x6f,0x6e,0x6f,0x5e,0x48}}, // \xe8\xb1\x8a
{0x8c4c,{0x2d,0x35,0x2d,0x56,0x2a,0x7b,0x5e}}, // \xe8\xb1\x8c
{0x8c4e,{0x4f,0x5f,0x6d,0x68,0x6d,0x5b,0x4d}}, // \xe8\xb1\x8e
{0x8c50,{0x48,0x5f,0x6e,0x6f,0x6e,0x5f,0x48}}, // \xe8\xb1\x90
{0x8c55,{0x29,0x29,0x57,0x4d,0x39,0x15,0x21}}, // \xe8\xb1\x95
{0x8c5a,{0x7f,0x15,0x7f,0x29,0x57,0x7d,0x29}}, // \xe8\xb1\x9a
{0x8c61,{0x52,0x52,0x2d,0x5d,0x7f,0x2c,0x50}}, // \xe8\xb1\xa1
{0x8c62,{0x52,0x59,0x2c,0x5f,0x7c,0x29,0x52}}, // \xe8\xb1\xa2
{0x8c6a,{0x5a,0x5e,0x2a,0x5b,0x7a,0x2e,0x5a}}, // \xe8\xb1\xaa
{0x8c6b,{0x49,0x7d,0x2b,0x5e,0x7d,0x2f,0x50}}, // \xe8\xb1\xab
{0x8c6c,{0x55,0x4b,0x3d,0x1a,0x6f,0x7a,0x69}}, // \xe8\xb1\xac
{0x8c78,{0x00,0x54,0x56,0x2e,0x55,0x3a,0x00}}, // \xe8\xb1\xb8
{0x8c79,{0x2a,0x56,0x3d,0x04,0x0b,0x52,0x7e}}, // \xe8\xb1\xb9
{0x8c7a,{0x2a,0x56,0x3d,0x22,0x52,0x7f,0x0a}}, // \xe8\xb1\xba
{0x8c7c,{0x2a,0x56,0x3d,0x7f,0x24,0x7f,0x44}}, // \xe8\xb1\xbc
{0x8c82,{0x2a,0x56,0x3d,0x00,0x75,0x53,0x77}}, // \xe8\xb2\x82
{0x8c85,{0x2a,0x56,0x3d,0x7f,0x1a,0x7f,0x12}}, // \xe8\xb2\x85
{0x8c89,{0x2a,0x56,0x3d,0x10,0x6a,0x65,0x6b}}, // \xe8\xb2\x89
{0x8c8a,{0x2a,0x56,0x3d,0x7d,0x57,0x55,0x7d}}, // \xe8\xb2\x8a
{0x8c8c,{0x2a,0x56,0x3d,0x5e,0x2b,0x6a,0x5e}}, // \xe8\xb2\x8c
{0x8c8d,{0x2a,0x56,0x3d,0x5f,0x55,0x7f,0x5f}}, // \xe8\xb2\x8d
{0x8c8e,{0x2a,0x56,0x3d,0x5e,0x35,0x72,0x5e}}, // \xe8\xb2\x8e
{0x8c94,{0x2a,0x56,0x3d,0x7e,0x5b,0x76,0x5e}}, // \xe8\xb2\x94
{0x8c98,{0x2a,0x56,0x3d,0x52,0x5f,0x36,0x5f}}, // \xe8\xb2\x98
{0x8c9d,{0x40,0x5f,0x15,0x15,0x15,0x5f,0x40}}, // \xe8\xb2\x9d
{0x8c9e,{0x40,0x7c,0x34,0x37,0x36,0x7e,0x42}}, // \xe8\xb2\x9e
{0x8ca0,{0x42,0x7e,0x35,0x35,0x37,0x7c,0x40}}, // \xe8\xb2\xa0
{0x8ca1,{0x5f,0x15,0x5f,0x22,0x52,0x7f,0x0a}}, // \xe8\xb2\xa1
{0x8ca2,{0x44,0x7d,0x2d,0x2f,0x2d,0x7d,0x44}}, // \xe8\xb2\xa2
{0x8ca7,{0x44,0x76,0x3d,0x34,0x3d,0x72,0x44}}, // \xe8\xb2\xa7
{0x8ca8,{0x44,0x4e,0x31,0x30,0x3f,0x7a,0x4a}}, // \xe8\xb2\xa8
{0x8ca9,{0x5f,0x15,0x5f,0x20,0x5f,0x25,0x5d}}, // \xe8\xb2\xa9
{0x8caa,{0x44,0x74,0x36,0x35,0x3e,0x74,0x44}}, // \xe8\xb2\xaa
{0x8cab,{0x42,0x7f,0x2d,0x2f,0x2d,0x7f,0x42}}, // \xe8\xb2\xab
{0x8cac,{0x48,0x7a,0x2a,0x2f,0x2a,0x7a,0x48}}, // \xe8\xb2\xac
{0x8cad,{0x40,0x3e,0x46,0x3e,0x2e,0x3d,0x45}}, // \xe8\xb2\xad
{0x8cae,{0x44,0x3d,0x3d,0x44,0x0f,0x34,0x45}}, // \xe8\xb2\xae
{0x8caf,{0x5f,0x15,0x5f,0x06,0x4a,0x7b,0x0e}}, // \xe8\xb2\xaf
{0x8cb0,{0x42,0x7f,0x2a,0x2f,0x2a,0x7f,0x4a}}, // \xe8\xb2\xb0
{0x8cb2,{0x4e,0x78,0x2f,0x2a,0x28,0x7f,0x4a}}, // \xe8\xb2\xb2
{0x8cb3,{0x42,0x36,0x36,0x42,0x0f,0x32,0x43}}, // \xe8\xb2\xb3
{0x8cb4,{0x48,0x7e,0x2a,0x2f,0x2a,0x7e,0x48}}, // \xe8\xb2\xb4
{0x8cb6,{0x5f,0x15,0x5f,0x34,0x25,0x57,0x4d}}, // \xe8\xb2\xb6
{0x8cb7,{0x47,0x7d,0x2f,0x2d,0x2f,0x7d,0x47}}, // \xe8\xb2\xb7
{0x8cb8,{0x44,0x4e,0x31,0x32,0x33,0x76,0x4b}}, // \xe8\xb2\xb8
{0x8cbb,{0x5a,0x7a,0x2f,0x2a,0x2f,0x7a,0x4e}}, // \xe8\xb2\xbb
{0x8cbc,{0x5f,0x15,0x5f,0x70,0x5f,0x54,0x74}}, // \xe8\xb2\xbc
{0x8cbd,{0x5f,0x15,0x5f,0x08,0x6c,0x6b,0x6c}}, // \xe8\xb2\xbd
{0x8cbf,{0x46,0x7e,0x2d,0x28,0x2d,0x7b,0x47}}, // \xe8\xb2\xbf
{0x8cc0,{0x4a,0x47,0x3a,0x2e,0x2e,0x7a,0x4e}}, // \xe8\xb3\x80
{0x8cc1,{0x4a,0x7e,0x2a,0x2f,0x2a,0x7e,0x4a}}, // \xe8\xb3\x81
{0x8cc2,{0x5f,0x15,0x5f,0x10,0x6a,0x65,0x6b}}, // \xe8\xb3\x82
{0x8cc3,{0x44,0x4e,0x35,0x36,0x3e,0x75,0x44}}, // \xe8\xb3\x83
{0x8cc4,{0x5f,0x15,0x5f,0x12,0x7f,0x2a,0x7a}}, // \xe8\xb3\x84
{0x8cc7,{0x49,0x70,0x34,0x3b,0x36,0x7a,0x46}}, // \xe8\xb3\x87
{0x8cc8,{0x41,0x7f,0x2d,0x2f,0x2d,0x7f,0x41}}, // \xe8\xb3\x88
{0x8cca,{0x5f,0x1f,0x4a,0x1e,0x4a,0x3f,0x52}}, // \xe8\xb3\x8a
{0x8ccd,{0x5f,0x15,0x5f,0x3e,0x4a,0x7f,0x4a}}, // \xe8\xb3\x8d
{0x8cce,{0x5f,0x15,0x5f,0x0a,0x5f,0x2a,0x53}}, // \xe8\xb3\x8e
{0x8cd1,{0x5f,0x15,0x5f,0x7f,0x51,0x35,0x55}}, // \xe8\xb3\x91
{0x8cd3,{0x46,0x5a,0x36,0x3f,0x36,0x4a,0x46}}, // \xe8\xb3\x93
{0x8cda,{0x4a,0x76,0x3a,0x37,0x3a,0x76,0x4a}}, // \xe8\xb3\x9a
{0x8cdb,{0x4a,0x77,0x3a,0x30,0x3a,0x77,0x4a}}, // \xe8\xb3\x9b
{0x8cdc,{0x5f,0x15,0x5f,0x27,0x5d,0x35,0x77}}, // \xe8\xb3\x9c
{0x8cde,{0x46,0x7b,0x2e,0x2b,0x2e,0x7b,0x46}}, // \xe8\xb3\x9e
{0x8ce0,{0x5f,0x15,0x5f,0x0a,0x6e,0x6b,0x6e}}, // \xe8\xb3\xa0
{0x8ce2,{0x47,0x77,0x35,0x30,0x3b,0x75,0x4b}}, // \xe8\xb3\xa2
{0x8ce3,{0x42,0x7e,0x2a,0x2f,0x2a,0x7e,0x42}}, // \xe8\xb3\xa3
{0x8ce4,{0x5f,0x15,0x5f,0x12,0x5b,0x36,0x5b}}, // \xe8\xb3\xa4
{0x8ce6,{0x5f,0x1f,0x65,0x7d,0x54,0x3f,0x45}}, // \xe8\xb3\xa6
{0x8cea,{0x48,0x46,0x3d,0x28,0x2e,0x7d,0x44}}, // \xe8\xb3\xaa
{0x8ced,{0x5f,0x15,0x5f,0x28,0x1a,0x6f,0x6a}}, // \xe8\xb3\xad
{0x8cfa,{0x5f,0x1f,0x52,0x37,0x7e,0x3f,0x4a}}, // \xe8\xb3\xba
{0x8cfb,{0x5f,0x15,0x5f,0x3e,0x57,0x7e,0x13}}, // \xe8\xb3\xbb
{0x8cfc,{0x5f,0x1f,0x2a,0x7f,0x3a,0x7f,0x2a}}, // \xe8\xb3\xbc
{0x8cfd,{0x56,0x7a,0x2e,0x2b,0x2e,0x7a,0x56}}, // \xe8\xb3\xbd
{0x8d04,{0x44,0x4e,0x3f,0x3a,0x37,0x7e,0x48}}, // \xe8\xb4\x84
{0x8d05,{0x54,0x4e,0x3f,0x34,0x3a,0x75,0x4b}}, // \xe8\xb4\x85
{0x8d07,{0x56,0x4b,0x36,0x3d,0x35,0x7e,0x55}}, // \xe8\xb4\x87
{0x8d08,{0x5f,0x1f,0x4e,0x7b,0x5e,0x7b,0x0e}}, // \xe8\xb4\x88
{0x8d0a,{0x4a,0x77,0x3f,0x3a,0x37,0x7f,0x4a}}, // \xe8\xb4\x8a
{0x8d0b,{0x40,0x3f,0x4d,0x33,0x3d,0x3f,0x4b}}, // \xe8\xb4\x8b
{0x8d0d,{0x5f,0x15,0x5f,0x3e,0x75,0x7f,0x2c}}, // \xe8\xb4\x8d
{0x8d0f,{0x42,0x3e,0x7a,0x3b,0x4a,0x7a,0x72}}, // \xe8\xb4\x8f
{0x8d10,{0x5f,0x15,0x5f,0x6a,0x7f,0x6e,0x54}}, // \xe8\xb4\x90
{0x8d13,{0x5f,0x1f,0x6c,0x3e,0x5a,0x3f,0x52}}, // \xe8\xb4\x93
{0x8d14,{0x40,0x34,0x33,0x43,0x33,0x34,0x40}}, // \xe8\xb4\x94
{0x8d16,{0x5f,0x15,0x5f,0x3e,0x3b,0x3e,0x4e}}, // \xe8\xb4\x96
{0x8d64,{0x28,0x4a,0x3a,0x4f,0x7a,0x0a,0x28}}, // \xe8\xb5\xa4
{0x8d66,{0x28,0x7a,0x0f,0x7a,0x5c,0x23,0x5e}}, // \xe8\xb5\xa6
{0x8d67,{0x58,0x3a,0x7f,0x2a,0x7f,0x2b,0x5b}}, // \xe8\xb5\xa7
{0x8d6b,{0x58,0x3a,0x7f,0x4a,0x3a,0x7f,0x2a}}, // \xe8\xb5\xab
{0x8d6d,{0x58,0x3a,0x7f,0x2a,0x1a,0x6f,0x6a}}, // \xe8\xb5\xad
{0x8d70,{0x48,0x2a,0x4a,0x7f,0x5a,0x5a,0x48}}, // \xe8\xb5\xb0
{0x8d71,{0x44,0x26,0x4e,0x67,0x56,0x4e,0x44}}, // \xe8\xb5\xb1
{0x8d73,{0x6a,0x3f,0x4a,0x5f,0x50,0x7f,0x48}}, // \xe8\xb5\xb3
{0x8d74,{0x4a,0x3a,0x3f,0x5a,0x40,0x5f,0x44}}, // \xe8\xb5\xb4
{0x8d77,{0x4a,0x3a,0x3f,0x4a,0x5d,0x55,0x57}}, // \xe8\xb5\xb7
{0x8d81,{0x6a,0x3f,0x44,0x6a,0x65,0x52,0x44}}, // \xe8\xb6\x81
{0x8d85,{0x4a,0x3a,0x3f,0x4a,0x75,0x53,0x77}}, // \xe8\xb6\x85
{0x8d8a,{0x6a,0x3f,0x4a,0x7e,0x62,0x5f,0x6a}}, // \xe8\xb6\x8a
{0x8d99,{0x6a,0x3f,0x4a,0x7d,0x56,0x7d,0x42}}, // \xe8\xb6\x99
{0x8da3,{0x6a,0x3f,0x4a,0x55,0x7f,0x4a,0x56}}, // \xe8\xb6\xa3
{0x8da8,{0x6a,0x3f,0x4a,0x64,0x5b,0x76,0x76}}, // \xe8\xb6\xa8
{0x8db3,{0x40,0x37,0x45,0x7d,0x55,0x57,0x40}}, // \xe8\xb6\xb3
{0x8dba,{0x77,0x7d,0x57,0x08,0x4a,0x3f,0x4a}}, // \xe8\xb6\xba
{0x8dbe,{0x77,0x7d,0x57,0x7c,0x40,0x7f,0x44}}, // \xe8\xb6\xbe
{0x8dc2,{0x77,0x7d,0x57,0x42,0x5a,0x2f,0x5a}}, // \xe8\xb7\x82
{0x8dcb,{0x77,0x7d,0x57,0x22,0x5f,0x22,0x5b}}, // \xe8\xb7\x8b
{0x8dcc,{0x77,0x7d,0x57,0x4c,0x4b,0x3f,0x4a}}, // \xe8\xb7\x8c
{0x8dcf,{0x77,0x7d,0x66,0x1f,0x7e,0x42,0x7e}}, // \xe8\xb7\x8f
{0x8dd6,{0x77,0x7d,0x57,0x11,0x7f,0x49,0x79}}, // \xe8\xb7\x96
{0x8dda,{0x77,0x7d,0x2b,0x7f,0x3f,0x09,0x7f}}, // \xe8\xb7\x9a
{0x8ddb,{0x77,0x7d,0x57,0x3e,0x5a,0x2f,0x5e}}, // \xe8\xb7\x9b
{0x8ddd,{0x77,0x7d,0x2b,0x7f,0x55,0x55,0x5d}}, // \xe8\xb7\x9d
{0x8ddf,{0x77,0x7d,0x2b,0x7f,0x55,0x35,0x5f}}, // \xe8\xb7\x9f
{0x8de1,{0x77,0x7d,0x5b,0x3e,0x43,0x7e,0x1a}}, // \xe8\xb7\xa1
{0x8de3,{0x77,0x7d,0x57,0x4c,0x3b,0x7f,0x4a}}, // \xe8\xb7\xa3
{0x8de8,{0x77,0x7d,0x57,0x0a,0x1e,0x57,0x6a}}, // \xe8\xb7\xa8
{0x8dea,{0x77,0x7d,0x57,0x3e,0x7d,0x4f,0x5c}}, // \xe8\xb7\xaa
{0x8deb,{0x45,0x27,0x5d,0x7c,0x5b,0x47,0x44}}, // \xe8\xb7\xab
{0x8def,{0x77,0x7d,0x57,0x10,0x6a,0x65,0x6b}}, // \xe8\xb7\xaf
{0x8df3,{0x77,0x7d,0x57,0x3f,0x00,0x7f,0x4a}}, // \xe8\xb7\xb3
{0x8df5,{0x77,0x7d,0x37,0x4a,0x5f,0x2a,0x53}}, // \xe8\xb7\xb5
{0x8dfc,{0x77,0x7d,0x57,0x3f,0x35,0x47,0x7c}}, // \xe8\xb7\xbc
{0x8dff,{0x77,0x7d,0x57,0x28,0x4a,0x7f,0x5a}}, // \xe8\xb7\xbf
{0x8e08,{0x77,0x7d,0x4f,0x2e,0x7f,0x2a,0x4e}}, // \xe8\xb8\x88
{0x8e09,{0x77,0x7d,0x57,0x7e,0x5a,0x3b,0x5e}}, // \xe8\xb8\x89
{0x8e0a,{0x77,0x7d,0x2b,0x7c,0x15,0x7f,0x7d}}, // \xe8\xb8\x8a
{0x8e0f,{0x77,0x7d,0x2b,0x76,0x5f,0x74,0x0a}}, // \xe8\xb8\x8f
{0x8e10,{0x77,0x7d,0x57,0x12,0x5b,0x36,0x5b}}, // \xe8\xb8\x90
{0x8e1d,{0x77,0x7f,0x57,0x35,0x7f,0x35,0x57}}, // \xe8\xb8\x9d
{0x8e1e,{0x77,0x7d,0x57,0x3f,0x6b,0x5f,0x6b}}, // \xe8\xb8\x9e
{0x8e1f,{0x77,0x7d,0x4b,0x3e,0x4a,0x3e,0x3e}}, // \xe8\xb8\x9f
{0x8e2a,{0x77,0x7d,0x56,0x12,0x77,0x16,0x56}}, // \xe8\xb8\xaa
{0x8e30,{0x77,0x7d,0x2b,0x73,0x75,0x26,0x54}}, // \xe8\xb8\xb0
{0x8e34,{0x77,0x7d,0x2b,0x50,0x3d,0x5f,0x7d}}, // \xe8\xb8\xb4
{0x8e35,{0x77,0x7d,0x47,0x5e,0x7e,0x5d,0x44}}, // \xe8\xb8\xb5
{0x8e42,{0x77,0x7d,0x5a,0x37,0x7f,0x33,0x56}}, // \xe8\xb9\x82
{0x8e44,{0x77,0x7d,0x1b,0x6e,0x3b,0x6e,0x1a}}, // \xe8\xb9\x84
{0x8e47,{0x56,0x2a,0x5e,0x7b,0x5e,0x4a,0x56}}, // \xe8\xb9\x87
{0x8e48,{0x77,0x7d,0x72,0x69,0x43,0x69,0x7a}}, // \xe8\xb9\x88
{0x8e49,{0x77,0x7d,0x4a,0x3b,0x5e,0x7b,0x5a}}, // \xe8\xb9\x89
{0x8e4a,{0x77,0x7d,0x2b,0x52,0x5b,0x35,0x5a}}, // \xe8\xb9\x8a
{0x8e4c,{0x77,0x7d,0x57,0x24,0x1e,0x6d,0x62}}, // \xe8\xb9\x8c
{0x8e50,{0x77,0x7d,0x4b,0x15,0x7d,0x2a,0x7d}}, // \xe8\xb9\x90
{0x8e55,{0x77,0x7d,0x2b,0x3f,0x6b,0x3f,0x2b}}, // \xe8\xb9\x95
{0x8e59,{0x50,0x2e,0x5a,0x7e,0x5a,0x4f,0x52}}, // \xe8\xb9\x99
{0x8e5f,{0x77,0x7d,0x4b,0x3a,0x3f,0x3a,0x48}}, // \xe8\xb9\x9f
{0x8e60,{0x77,0x7d,0x5f,0x0e,0x5b,0x1e,0x4a}}, // \xe8\xb9\xa0
{0x8e63,{0x77,0x7d,0x7a,0x3f,0x7a,0x3f,0x7a}}, // \xe8\xb9\xa3
{0x8e64,{0x77,0x7d,0x57,0x7d,0x22,0x79,0x52}}, // \xe8\xb9\xa4
{0x8e72,{0x77,0x7d,0x1e,0x3d,0x54,0x7d,0x1e}}, // \xe8\xb9\xb2
{0x8e74,{0x77,0x7d,0x2e,0x7b,0x2e,0x3f,0x45}}, // \xe8\xb9\xb4
{0x8e76,{0x77,0x7d,0x5f,0x35,0x4b,0x3d,0x4d}}, // \xe8\xb9\xb6
{0x8e7c,{0x77,0x7d,0x4b,0x5e,0x3b,0x5e,0x4b}}, // \xe8\xb9\xbc
{0x8e81,{0x77,0x7f,0x5c,0x37,0x7d,0x37,0x5c}}, // \xe8\xba\x81
{0x8e84,{0x44,0x2f,0x5b,0x78,0x5e,0x5b,0x46}}, // \xe8\xba\x84
{0x8e85,{0x77,0x7f,0x4b,0x75,0x77,0x25,0x7f}}, // \xe8\xba\x85
{0x8e87,{0x77,0x7d,0x52,0x37,0x7e,0x7f,0x12}}, // \xe8\xba\x87
{0x8e8a,{0x77,0x7d,0x37,0x36,0x5f,0x76,0x14}}, // \xe8\xba\x8a
{0x8e8b,{0x77,0x7d,0x4b,0x36,0x2b,0x76,0x0a}}, // \xe8\xba\x8b
{0x8e8d,{0x77,0x7d,0x57,0x20,0x75,0x7f,0x57}}, // \xe8\xba\x8d
{0x8e91,{0x77,0x7d,0x5a,0x39,0x5a,0x7f,0x1b}}, // \xe8\xba\x91
{0x8e93,{0x77,0x7d,0x46,0x3d,0x38,0x3e,0x45}}, // \xe8\xba\x93
{0x8e94,{0x77,0x7d,0x3e,0x5a,0x6f,0x5e,0x5a}}, // \xe8\xba\x94
{0x8e99,{0x77,0x7d,0x7f,0x13,0x3c,0x3b,0x7f}}, // \xe8\xba\x99
{0x8ea1,{0x77,0x7d,0x37,0x75,0x27,0x3f,0x75}}, // \xe8\xba\xa1
{0x8eaa,{0x77,0x7d,0x7e,0x17,0x3a,0x37,0x7e}}, // \xe8\xba\xaa
{0x8eab,{0x10,0x50,0x5e,0x3b,0x5a,0x7e,0x08}}, // \xe8\xba\xab
{0x8eac,{0x50,0x5e,0x2b,0x7e,0x1d,0x55,0x77}}, // \xe8\xba\xac
{0x8eaf,{0x50,0x5e,0x2b,0x7e,0x7f,0x49,0x55}}, // \xe8\xba\xaf
{0x8eb0,{0x5e,0x2b,0x7e,0x12,0x2a,0x7f,0x12}}, // \xe8\xba\xb0
{0x8eb1,{0x5e,0x2b,0x7e,0x35,0x7b,0x35,0x56}}, // \xe8\xba\xb1
{0x8ebe,{0x5e,0x2b,0x7e,0x12,0x57,0x3e,0x57}}, // \xe8\xba\xbe
{0x8ec5,{0x5e,0x2b,0x7e,0x3f,0x79,0x7f,0x55}}, // \xe8\xbb\x85
{0x8ec6,{0x50,0x5e,0x2b,0x7e,0x5f,0x6e,0x5f}}, // \xe8\xbb\x86
{0x8ec8,{0x5e,0x2b,0x7e,0x7e,0x2e,0x4f,0x6a}}, // \xe8\xbb\x88
{0x8eca,{0x22,0x3e,0x2a,0x7f,0x2a,0x3e,0x22}}, // \xe8\xbb\x8a
{0x8ecb,{0x2d,0x7f,0x2d,0x00,0x7f,0x40,0x60}}, // \xe8\xbb\x8b
{0x8ecc,{0x2d,0x7f,0x42,0x3f,0x02,0x7e,0x40}}, // \xe8\xbb\x8c
{0x8ecd,{0x27,0x3d,0x2d,0x7f,0x2d,0x3d,0x27}}, // \xe8\xbb\x8d
{0x8ed2,{0x2d,0x7f,0x2d,0x08,0x09,0x7f,0x09}}, // \xe8\xbb\x92
{0x8edb,{0x2d,0x7f,0x2d,0x1f,0x7d,0x45,0x5d}}, // \xe8\xbb\x9b
{0x8edf,{0x2d,0x7f,0x2d,0x44,0x43,0x3e,0x46}}, // \xe8\xbb\x9f
{0x8ee2,{0x2d,0x7f,0x2d,0x44,0x65,0x5d,0x65}}, // \xe8\xbb\xa2
{0x8ee3,{0x4a,0x5e,0x2a,0x0f,0x2a,0x5e,0x4a}}, // \xe8\xbb\xa3
{0x8eeb,{0x2d,0x7f,0x2d,0x42,0x55,0x2a,0x14}}, // \xe8\xbb\xab
{0x8ef8,{0x2d,0x7f,0x2d,0x7e,0x4a,0x7f,0x7e}}, // \xe8\xbb\xb8
{0x8efb,{0x2d,0x7f,0x2d,0x1d,0x15,0x5d,0x7f}}, // \xe8\xbb\xbb
{0x8efc,{0x2d,0x7f,0x4c,0x2b,0x1f,0x2a,0x48}}, // \xe8\xbb\xbc
{0x8efd,{0x2d,0x7f,0x49,0x5b,0x75,0x5b,0x48}}, // \xe8\xbb\xbd
{0x8efe,{0x2d,0x7f,0x2d,0x54,0x74,0x3f,0x45}}, // \xe8\xbb\xbe
{0x8f03,{0x2d,0x7f,0x4a,0x56,0x23,0x56,0x4a}}, // \xe8\xbc\x83
{0x8f05,{0x2d,0x7f,0x10,0x6a,0x65,0x6b,0x10}}, // \xe8\xbc\x85
{0x8f09,{0x28,0x3a,0x7f,0x2a,0x4f,0x38,0x5a}}, // \xe8\xbc\x89
{0x8f0a,{0x2d,0x7f,0x45,0x57,0x7d,0x53,0x45}}, // \xe8\xbc\x8a
{0x8f0c,{0x2d,0x7f,0x7d,0x35,0x3f,0x35,0x7d}}, // \xe8\xbc\x8c
{0x8f12,{0x2d,0x7f,0x21,0x3f,0x6d,0x7f,0x41}}, // \xe8\xbc\x92
{0x8f13,{0x2d,0x7f,0x5c,0x36,0x1d,0x77,0x5c}}, // \xe8\xbc\x93
{0x8f14,{0x2d,0x7f,0x7a,0x2a,0x7f,0x2a,0x7b}}, // \xe8\xbc\x94
{0x8f15,{0x2d,0x7f,0x2d,0x55,0x5b,0x75,0x5b}}, // \xe8\xbc\x95
{0x8f19,{0x2d,0x7f,0x21,0x3f,0x7f,0x12,0x2e}}, // \xe8\xbc\x99
{0x8f1b,{0x2d,0x7f,0x7d,0x35,0x7f,0x35,0x7d}}, // \xe8\xbc\x9b
{0x8f1c,{0x2d,0x7f,0x2d,0x7a,0x5d,0x7a,0x7d}}, // \xe8\xbc\x9c
{0x8f1d,{0x4a,0x38,0x3f,0x27,0x3d,0x7f,0x27}}, // \xe8\xbc\x9d
{0x8f1f,{0x2d,0x7f,0x5d,0x2b,0x5d,0x2b,0x5d}}, // \xe8\xbc\x9f
{0x8f26,{0x2a,0x37,0x3a,0x70,0x3a,0x37,0x2a}}, // \xe8\xbc\xa6
{0x8f29,{0x2a,0x3a,0x2f,0x78,0x2f,0x3a,0x2a}}, // \xe8\xbc\xa9
{0x8f2a,{0x2d,0x7f,0x2d,0x72,0x35,0x76,0x74}}, // \xe8\xbc\xaa
{0x8f2f,{0x2d,0x7f,0x24,0x3f,0x2d,0x7f,0x24}}, // \xe8\xbc\xaf
{0x8f33,{0x2d,0x7f,0x1a,0x4e,0x3f,0x4e,0x1a}}, // \xe8\xbc\xb3
{0x8f38,{0x2d,0x7f,0x2d,0x72,0x75,0x06,0x74}}, // \xe8\xbc\xb8
{0x8f39,{0x2d,0x7f,0x4d,0x53,0x2e,0x5e,0x42}}, // \xe8\xbc\xb9
{0x8f3b,{0x2d,0x7f,0x2d,0x71,0x57,0x77,0x71}}, // \xe8\xbc\xbb
{0x8f3e,{0x2d,0x7f,0x3f,0x75,0x5d,0x3d,0x57}}, // \xe8\xbc\xbe
{0x8f3f,{0x5e,0x55,0x1a,0x1f,0x1a,0x55,0x5f}}, // \xe8\xbc\xbf
{0x8f42,{0x2a,0x3e,0x7f,0x2e,0x5b,0x29,0x5b}}, // \xe8\xbd\x82
{0x8f44,{0x2d,0x7f,0x26,0x6a,0x7f,0x6a,0x26}}, // \xe8\xbd\x84
{0x8f45,{0x2d,0x7f,0x2d,0x7e,0x57,0x36,0x5c}}, // \xe8\xbd\x85
{0x8f46,{0x2d,0x7f,0x7e,0x5a,0x1f,0x7e,0x5a}}, // \xe8\xbd\x86
{0x8f49,{0x2d,0x7f,0x12,0x3e,0x5f,0x76,0x1a}}, // \xe8\xbd\x89
{0x8f4c,{0x2d,0x7f,0x2d,0x06,0x53,0x77,0x26}}, // \xe8\xbd\x8c
{0x8f4d,{0x2d,0x7f,0x0a,0x77,0x72,0x3f,0x5e}}, // \xe8\xbd\x8d
{0x8f4e,{0x2d,0x7f,0x7a,0x17,0x5b,0x17,0x7a}}, // \xe8\xbd\x8e
{0x8f57,{0x2d,0x7f,0x6e,0x2e,0x42,0x47,0x6a}}, // \xe8\xbd\x97
{0x8f5c,{0x2d,0x7f,0x66,0x2b,0x7f,0x2b,0x66}}, // \xe8\xbd\x9c
{0x8f5f,{0x28,0x3a,0x7e,0x2f,0x3e,0x7a,0x28}}, // \xe8\xbd\x9f
{0x8f61,{0x0a,0x7d,0x6a,0x77,0x6a,0x7d,0x08}}, // \xe8\xbd\xa1
{0x8f62,{0x2d,0x7f,0x5a,0x35,0x7f,0x3a,0x55}}, // \xe8\xbd\xa2
{0x8f63,{0x2d,0x7f,0x5f,0x6f,0x45,0x6f,0x45}}, // \xe8\xbd\xa3
{0x8f64,{0x2d,0x7f,0x2d,0x5c,0x64,0x6f,0x4a}}, // \xe8\xbd\xa4
{0x8f9b,{0x08,0x2a,0x2e,0x7b,0x2e,0x2a,0x08}}, // \xe8\xbe\x9b
{0x8f9c,{0x12,0x3a,0x3e,0x77,0x3e,0x3a,0x12}}, // \xe8\xbe\x9c
{0x8f9e,{0x76,0x5e,0x75,0x2a,0x2e,0x7b,0x2e}}, // \xe8\xbe\x9e
{0x8f9f,{0x10,0x7f,0x77,0x2a,0x2e,0x7b,0x2e}}, // \xe8\xbe\x9f
{0x8fa3,{0x56,0x3b,0x5e,0x2e,0x7f,0x2a,0x4e}}, // \xe8\xbe\xa3
{0x8fa7,{0x56,0x3b,0x56,0x3e,0x7e,0x7b,0x16}}, // \xe8\xbe\xa7
{0x8fa8,{0x56,0x3b,0x56,0x3f,0x16,0x7b,0x16}}, // \xe8\xbe\xa8
{0x8fad,{0x72,0x55,0x37,0x7d,0x2e,0x7b,0x2e}}, // \xe8\xbe\xad
{0x8fae,{0x56,0x3b,0x2e,0x75,0x2e,0x7b,0x16}}, // \xe8\xbe\xae
{0x8faf,{0x56,0x3f,0x6a,0x6b,0x2e,0x7b,0x2e}}, // \xe8\xbe\xaf
{0x8fb0,{0x40,0x3f,0x71,0x55,0x35,0x55,0x51}}, // \xe8\xbe\xb0
{0x8fb1,{0x18,0x17,0x3d,0x57,0x7f,0x17,0x15}}, // \xe8\xbe\xb1
{0x8fb2,{0x40,0x36,0x77,0x56,0x37,0x56,0x50}}, // \xe8\xbe\xb2
{0x8fb7,{0x55,0x30,0x44,0x44,0x44,0x44,0x44}}, // \xe8\xbe\xb7
{0x8fba,{0x49,0x3a,0x51,0x49,0x47,0x51,0x5f}}, // \xe8\xbe\xba
{0x8fbb,{0x49,0x38,0x44,0x44,0x7f,0x44,0x44}}, // \xe8\xbe\xbb
{0x8fbc,{0x49,0x3a,0x50,0x49,0x47,0x48,0x50}}, // \xe8\xbe\xbc
{0x8fbf,{0x49,0x38,0x5e,0x50,0x5f,0x50,0x5e}}, // \xe8\xbe\xbf
{0x8fc2,{0x49,0x38,0x44,0x65,0x7f,0x45,0x44}}, // \xe8\xbf\x82
{0x8fc4,{0x49,0x38,0x44,0x53,0x6e,0x66,0x72}}, // \xe8\xbf\x84
{0x8fc5,{0x49,0x38,0x45,0x5f,0x45,0x4f,0x50}}, // \xe8\xbf\x85
{0x8fce,{0x49,0x38,0x5e,0x51,0x7e,0x42,0x5e}}, // \xe8\xbf\x8e
{0x8fd1,{0x49,0x3a,0x60,0x5e,0x4a,0x79,0x48}}, // \xe8\xbf\x91
{0x8fd4,{0x49,0x3a,0x60,0x5f,0x6d,0x55,0x6d}}, // \xe8\xbf\x94
{0x8fda,{0x55,0x30,0x4e,0x4a,0x7f,0x4a,0x4e}}, // \xe8\xbf\x9a
{0x8fe2,{0x55,0x30,0x45,0x7d,0x6b,0x69,0x7f}}, // \xe8\xbf\xa2
{0x8fe5,{0x55,0x30,0x7f,0x4d,0x4d,0x61,0x7f}}, // \xe8\xbf\xa5
{0x8fe6,{0x49,0x38,0x52,0x4f,0x5e,0x52,0x5e}}, // \xe8\xbf\xa6
{0x8fe9,{0x49,0x38,0x54,0x4b,0x62,0x7e,0x52}}, // \xe8\xbf\xa9
{0x8fea,{0x55,0x30,0x7e,0x6a,0x7f,0x6a,0x7e}}, // \xe8\xbf\xaa
{0x8feb,{0x49,0x3a,0x40,0x7e,0x6b,0x6a,0x7e}}, // \xe8\xbf\xab
{0x8fed,{0x49,0x3a,0x40,0x6c,0x6b,0x5f,0x6a}}, // \xe8\xbf\xad
{0x8fef,{0x55,0x30,0x64,0x5b,0x4e,0x7f,0x44}}, // \xe8\xbf\xaf
{0x8ff0,{0x49,0x38,0x5a,0x42,0x7f,0x42,0x5b}}, // \xe8\xbf\xb0
{0x8ff4,{0x55,0x30,0x7f,0x5d,0x55,0x5d,0x7f}}, // \xe8\xbf\xb4
{0x8ff7,{0x49,0x38,0x55,0x4c,0x7f,0x4c,0x55}}, // \xe8\xbf\xb7
{0x8ff8,{0x55,0x30,0x54,0x7d,0x54,0x7d,0x54}}, // \xe8\xbf\xb8
{0x8ff9,{0x55,0x30,0x6a,0x5e,0x63,0x7e,0x4a}}, // \xe8\xbf\xb9
{0x8ffa,{0x55,0x30,0x7d,0x6f,0x65,0x6f,0x7d}}, // \xe8\xbf\xba
{0x8ffd,{0x49,0x3a,0x40,0x7e,0x57,0x56,0x76}}, // \xe8\xbf\xbd
{0x9000,{0x49,0x3a,0x40,0x7f,0x55,0x75,0x6f}}, // \xe9\x80\x80
{0x9001,{0x49,0x38,0x62,0x6b,0x5e,0x6b,0x62}}, // \xe9\x80\x81
{0x9003,{0x49,0x38,0x6a,0x5f,0x40,0x7f,0x6a}}, // \xe9\x80\x83
{0x9005,{0x55,0x30,0x60,0x5e,0x4a,0x6a,0x69}}, // \xe9\x80\x85
{0x9006,{0x49,0x38,0x5a,0x73,0x5e,0x53,0x5a}}, // \xe9\x80\x86
{0x900b,{0x55,0x30,0x42,0x7a,0x7f,0x5a,0x7b}}, // \xe9\x80\x8b
{0x900d,{0x55,0x30,0x42,0x7d,0x56,0x7d,0x42}}, // \xe9\x80\x8d
{0x900e,{0x55,0x30,0x7d,0x6f,0x65,0x6f,0x7d}}, // \xe9\x80\x8e
{0x900f,{0x49,0x38,0x4a,0x67,0x5f,0x77,0x4a}}, // \xe9\x80\x8f
{0x9010,{0x49,0x3a,0x69,0x57,0x7d,0x49,0x55}}, // \xe9\x80\x90
{0x9011,{0x55,0x30,0x6a,0x52,0x7f,0x52,0x6b}}, // \xe9\x80\x91
{0x9013,{0x49,0x3a,0x60,0x5e,0x4a,0x7e,0x59}}, // \xe9\x80\x93
{0x9014,{0x49,0x38,0x54,0x66,0x7d,0x46,0x54}}, // \xe9\x80\x94
{0x9015,{0x55,0x30,0x40,0x6d,0x6b,0x7d,0x6b}}, // \xe9\x80\x95
{0x9016,{0x55,0x30,0x6b,0x5e,0x65,0x5f,0x64}}, // \xe9\x80\x96
{0x9017,{0x49,0x3a,0x40,0x6d,0x75,0x75,0x6d}}, // \xe9\x80\x97
{0x9019,{0x49,0x3a,0x40,0x62,0x6b,0x6b,0x62}}, // \xe9\x80\x99
{0x901a,{0x49,0x38,0x7d,0x55,0x7d,0x57,0x7d}}, // \xe9\x80\x9a
{0x901d,{0x49,0x38,0x52,0x7f,0x52,0x4e,0x7d}}, // \xe9\x80\x9d
{0x901e,{0x55,0x30,0x44,0x6f,0x7d,0x6f,0x44}}, // \xe9\x80\x9e
{0x901f,{0x49,0x3a,0x6e,0x5a,0x7f,0x5a,0x6e}}, // \xe9\x80\x9f
{0x9020,{0x49,0x38,0x4c,0x7b,0x6f,0x7a,0x48}}, // \xe9\x80\xa0
{0x9021,{0x55,0x30,0x4a,0x67,0x72,0x5e,0x6b}}, // \xe9\x80\xa1
{0x9022,{0x49,0x38,0x52,0x56,0x7d,0x53,0x54}}, // \xe9\x80\xa2
{0x9023,{0x49,0x38,0x52,0x5e,0x7f,0x5e,0x52}}, // \xe9\x80\xa3
{0x9027,{0x55,0x30,0x52,0x49,0x74,0x79,0x52}}, // \xe9\x80\xa7
{0x902e,{0x49,0x38,0x6a,0x56,0x7f,0x56,0x68}}, // \xe9\x80\xae
{0x9031,{0x49,0x38,0x5f,0x75,0x6f,0x75,0x7f}}, // \xe9\x80\xb1
{0x9032,{0x49,0x38,0x44,0x7f,0x6a,0x7f,0x6a}}, // \xe9\x80\xb2
{0x9035,{0x55,0x30,0x54,0x6e,0x77,0x6e,0x6c}}, // \xe9\x80\xb5
{0x9036,{0x55,0x30,0x6a,0x77,0x7f,0x57,0x6a}}, // \xe9\x80\xb6
{0x9038,{0x49,0x38,0x42,0x6e,0x5d,0x77,0x6c}}, // \xe9\x80\xb8
{0x9039,{0x55,0x30,0x54,0x5e,0x77,0x5e,0x54}}, // \xe9\x80\xb9
{0x903c,{0x49,0x3a,0x71,0x57,0x75,0x57,0x71}}, // \xe9\x80\xbc
{0x903e,{0x55,0x30,0x45,0x73,0x75,0x66,0x54}}, // \xe9\x80\xbe
{0x9041,{0x49,0x3a,0x50,0x4e,0x76,0x7e,0x75}}, // \xe9\x81\x81
{0x9042,{0x49,0x38,0x52,0x6b,0x7e,0x53,0x6a}}, // \xe9\x81\x82
{0x9045,{0x49,0x3a,0x60,0x5f,0x5b,0x73,0x5b}}, // \xe9\x81\x85
{0x9047,{0x49,0x3a,0x78,0x6b,0x7f,0x5b,0x78}}, // \xe9\x81\x87
{0x9049,{0x55,0x30,0x60,0x5c,0x5f,0x5e,0x62}}, // \xe9\x81\x89
{0x904a,{0x49,0x38,0x52,0x6f,0x5a,0x77,0x5e}}, // \xe9\x81\x8a
{0x904b,{0x49,0x38,0x53,0x5d,0x7f,0x5d,0x53}}, // \xe9\x81\x8b
{0x904d,{0x49,0x3a,0x51,0x4f,0x7b,0x5b,0x79}}, // \xe9\x81\x8d
{0x904e,{0x49,0x3a,0x40,0x78,0x6f,0x49,0x7f}}, // \xe9\x81\x8e
{0x904f,{0x55,0x30,0x48,0x5f,0x55,0x67,0x7c}}, // \xe9\x81\x8f
{0x9050,{0x55,0x30,0x7f,0x4b,0x6c,0x55,0x6f}}, // \xe9\x81\x90
{0x9051,{0x55,0x30,0x48,0x6e,0x7b,0x6e,0x48}}, // \xe9\x81\x91
{0x9052,{0x55,0x30,0x7a,0x5d,0x4c,0x5d,0x7a}}, // \xe9\x81\x92
{0x9053,{0x49,0x38,0x42,0x7b,0x56,0x7b,0x42}}, // \xe9\x81\x93
{0x9054,{0x49,0x38,0x54,0x5e,0x77,0x5e,0x54}}, // \xe9\x81\x94
{0x9055,{0x49,0x38,0x54,0x5d,0x57,0x7d,0x57}}, // \xe9\x81\x95
{0x9056,{0x55,0x30,0x7a,0x5a,0x6f,0x5a,0x7a}}, // \xe9\x81\x96
{0x9058,{0x55,0x30,0x6a,0x7f,0x7a,0x7f,0x6a}}, // \xe9\x81\x98
{0x9059,{0x55,0x30,0x50,0x6a,0x4d,0x7b,0x68}}, // \xe9\x81\x99
{0x905c,{0x49,0x38,0x6d,0x73,0x55,0x7b,0x51}}, // \xe9\x81\x9c
{0x905e,{0x55,0x30,0x5f,0x6d,0x55,0x7f,0x6b}}, // \xe9\x81\x9e
{0x9060,{0x49,0x38,0x64,0x5e,0x77,0x5e,0x64}}, // \xe9\x81\xa0
{0x9061,{0x49,0x3a,0x57,0x4e,0x5f,0x45,0x5f}}, // \xe9\x81\xa1
{0x9063,{0x49,0x38,0x4e,0x7a,0x7f,0x7a,0x6e}}, // \xe9\x81\xa3
{0x9065,{0x49,0x38,0x6a,0x4a,0x7e,0x49,0x6b}}, // \xe9\x81\xa5
{0x9068,{0x55,0x30,0x56,0x6f,0x7c,0x53,0x6e}}, // \xe9\x81\xa8
{0x9069,{0x49,0x38,0x7a,0x6e,0x5b,0x6e,0x7a}}, // \xe9\x81\xa9
{0x906d,{0x49,0x38,0x5a,0x7f,0x5a,0x7f,0x5a}}, // \xe9\x81\xad
{0x906e,{0x49,0x38,0x6e,0x4a,0x6f,0x4e,0x6a}}, // \xe9\x81\xae
{0x906f,{0x55,0x30,0x7f,0x55,0x7f,0x7b,0x55}}, // \xe9\x81\xaf
{0x9072,{0x55,0x30,0x7f,0x57,0x5b,0x7f,0x57}}, // \xe9\x81\xb2
{0x9075,{0x49,0x3a,0x5e,0x57,0x72,0x77,0x5e}}, // \xe9\x81\xb5
{0x9076,{0x55,0x30,0x6c,0x5e,0x4f,0x7e,0x6c}}, // \xe9\x81\xb6
{0x9077,{0x49,0x3a,0x49,0x77,0x6f,0x67,0x49}}, // \xe9\x81\xb7
{0x9078,{0x49,0x38,0x6d,0x5b,0x50,0x5d,0x6b}}, // \xe9\x81\xb8
{0x907a,{0x49,0x38,0x6e,0x5a,0x5f,0x5a,0x6e}}, // \xe9\x81\xba
{0x907c,{0x49,0x38,0x6a,0x5e,0x6b,0x5e,0x6a}}, // \xe9\x81\xbc
{0x907d,{0x55,0x30,0x5c,0x6c,0x7f,0x5a,0x6a}}, // \xe9\x81\xbd
{0x907f,{0x49,0x38,0x5f,0x5b,0x56,0x7b,0x56}}, // \xe9\x81\xbf
{0x9080,{0x55,0x30,0x56,0x6f,0x7c,0x53,0x6e}}, // \xe9\x82\x80
{0x9081,{0x55,0x30,0x7a,0x6f,0x7a,0x5f,0x7a}}, // \xe9\x82\x81
{0x9082,{0x55,0x30,0x62,0x5d,0x7f,0x51,0x7b}}, // \xe9\x82\x82
{0x9083,{0x55,0x30,0x66,0x56,0x6b,0x76,0x56}}, // \xe9\x82\x83
{0x9084,{0x49,0x38,0x63,0x5f,0x77,0x5f,0x63}}, // \xe9\x82\x84
{0x9087,{0x55,0x30,0x45,0x7f,0x57,0x6d,0x7f}}, // \xe9\x82\x87
{0x9089,{0x55,0x30,0x58,0x6e,0x5d,0x6e,0x58}}, // \xe9\x82\x89
{0x908a,{0x55,0x30,0x58,0x6e,0x5d,0x7e,0x58}}, // \xe9\x82\x8a
{0x908f,{0x55,0x30,0x57,0x7b,0x53,0x7f,0x6b}}, // \xe9\x82\x8f
{0x9091,{0x3c,0x57,0x55,0x5d,0x57,0x5c,0x60}}, // \xe9\x82\x91
{0x90a3,{0x55,0x3f,0x55,0x7f,0x00,0x7f,0x1b}}, // \xe9\x82\xa3
{0x90a6,{0x2a,0x6a,0x3f,0x2a,0x7f,0x25,0x1b}}, // \xe9\x82\xa6
{0x90a8,{0x1a,0x7f,0x52,0x1a,0x7f,0x25,0x1b}}, // \xe9\x82\xa8
{0x90aa,{0x2f,0x59,0x7f,0x09,0x7f,0x25,0x1b}}, // \xe9\x82\xaa
{0x90af,{0x02,0x7f,0x4a,0x7f,0x02,0x7f,0x1b}}, // \xe9\x82\xaf
{0x90b1,{0x40,0x7e,0x4a,0x39,0x28,0x7f,0x1b}}, // \xe9\x82\xb1
{0x90b5,{0x75,0x53,0x59,0x7f,0x00,0x7f,0x1b}}, // \xe9\x82\xb5
{0x90b8,{0x7e,0x4a,0x5e,0x29,0x40,0x7f,0x1b}}, // \xe9\x82\xb8
{0x90c1,{0x12,0x7f,0x2a,0x7a,0x7f,0x25,0x1b}}, // \xe9\x83\x81
{0x90ca,{0x4a,0x56,0x23,0x56,0x7f,0x25,0x1b}}, // \xe9\x83\x8a
{0x90ce,{0x7e,0x4b,0x6e,0x00,0x7f,0x25,0x1b}}, // \xe9\x83\x8e
{0x90db,{0x22,0x29,0x6b,0x39,0x22,0x7f,0x1b}}, // \xe9\x83\x9b
{0x90e1,{0x25,0x7f,0x75,0x6f,0x04,0x7f,0x1b}}, // \xe9\x83\xa1
{0x90e2,{0x44,0x57,0x7d,0x37,0x24,0x7f,0x1b}}, // \xe9\x83\xa2
{0x90e4,{0x12,0x69,0x64,0x09,0x7f,0x25,0x1b}}, // \xe9\x83\xa4
{0x90e8,{0x0a,0x6e,0x6b,0x0e,0x7f,0x25,0x1b}}, // \xe9\x83\xa8
{0x90ed,{0x22,0x2e,0x7b,0x1e,0x7f,0x25,0x1b}}, // \xe9\x83\xad
{0x90f5,{0x54,0x5d,0x7f,0x55,0x7f,0x25,0x1b}}, // \xe9\x83\xb5
{0x90f7,{0x5a,0x35,0x7e,0x4a,0x2e,0x7f,0x1b}}, // \xe9\x83\xb7
{0x90fd,{0x28,0x1a,0x6f,0x6a,0x7f,0x25,0x1b}}, // \xe9\x83\xbd
{0x9102,{0x0b,0x5f,0x6c,0x0b,0x7f,0x25,0x1b}}, // \xe9\x84\x82
{0x9112,{0x24,0x5b,0x36,0x36,0x7f,0x25,0x1b}}, // \xe9\x84\x92
{0x9119,{0x08,0x7b,0x7d,0x7b,0x08,0x7f,0x1b}}, // \xe9\x84\x99
{0x912d,{0x5e,0x57,0x32,0x57,0x5e,0x7f,0x1b}}, // \xe9\x84\xad
{0x9130,{0x55,0x32,0x27,0x72,0x25,0x7f,0x1b}}, // \xe9\x84\xb0
{0x9132,{0x23,0x3f,0x7c,0x23,0x7f,0x25,0x1b}}, // \xe9\x84\xb2
{0x9149,{0x7d,0x75,0x6f,0x65,0x7f,0x75,0x7d}}, // \xe9\x85\x89
{0x914a,{0x7d,0x6f,0x7d,0x01,0x41,0x7f,0x01}}, // \xe9\x85\x8a
{0x914b,{0x02,0x7a,0x5f,0x4a,0x5e,0x7b,0x02}}, // \xe9\x85\x8b
{0x914c,{0x7d,0x6f,0x7d,0x04,0x0b,0x52,0x7e}}, // \xe9\x85\x8c
{0x914d,{0x7d,0x6f,0x7d,0x00,0x79,0x49,0x6f}}, // \xe9\x85\x8d
{0x914e,{0x7d,0x6f,0x7d,0x0a,0x52,0x7f,0x02}}, // \xe9\x85\x8e
{0x9152,{0x75,0x00,0x7d,0x6f,0x65,0x6f,0x7d}}, // \xe9\x85\x92
{0x9154,{0x7d,0x6f,0x7d,0x2a,0x77,0x2e,0x28}}, // \xe9\x85\x94
{0x9156,{0x7d,0x6f,0x7d,0x46,0x3f,0x72,0x46}}, // \xe9\x85\x96
{0x9158,{0x7d,0x6f,0x7d,0x40,0x5b,0x29,0x5b}}, // \xe9\x85\x98
{0x9162,{0x7d,0x6f,0x7d,0x04,0x7f,0x2a,0x2a}}, // \xe9\x85\xa2
{0x9163,{0x7d,0x6f,0x7d,0x02,0x7f,0x4a,0x7f}}, // \xe9\x85\xa3
{0x9165,{0x7d,0x6f,0x7d,0x24,0x15,0x7f,0x25}}, // \xe9\x85\xa5
{0x9169,{0x7d,0x6f,0x7d,0x14,0x7b,0x55,0x73}}, // \xe9\x85\xa9
{0x916a,{0x7d,0x6f,0x7d,0x10,0x6a,0x65,0x6b}}, // \xe9\x85\xaa
{0x916c,{0x7d,0x6f,0x7d,0x0c,0x7f,0x0c,0x7f}}, // \xe9\x85\xac
{0x9172,{0x7d,0x6f,0x7d,0x08,0x5b,0x7d,0x57}}, // \xe9\x85\xb2
{0x9173,{0x7d,0x6f,0x7d,0x08,0x7a,0x2d,0x78}}, // \xe9\x85\xb3
{0x9175,{0x7d,0x7f,0x29,0x1a,0x2f,0x7a,0x29}}, // \xe9\x85\xb5
{0x9177,{0x7d,0x6f,0x7d,0x0c,0x6b,0x6f,0x6a}}, // \xe9\x85\xb7
{0x9178,{0x7d,0x6f,0x7d,0x2a,0x57,0x32,0x4f}}, // \xe9\x85\xb8
{0x9182,{0x7d,0x6f,0x7d,0x1a,0x7f,0x1a,0x7f}}, // \xe9\x86\x82
{0x9187,{0x7d,0x6f,0x7d,0x22,0x2e,0x6b,0x3e}}, // \xe9\x86\x87
{0x9189,{0x7d,0x6f,0x7d,0x2e,0x73,0x2e,0x32}}, // \xe9\x86\x89
{0x918b,{0x7d,0x6f,0x7d,0x0a,0x7f,0x5a,0x7f}}, // \xe9\x86\x8b
{0x918d,{0x7d,0x6f,0x7d,0x34,0x47,0x7f,0x54}}, // \xe9\x86\x8d
{0x9190,{0x7d,0x7f,0x3a,0x2f,0x7a,0x3f,0x7f}}, // \xe9\x86\x90
{0x9192,{0x7d,0x6f,0x7d,0x48,0x57,0x7d,0x57}}, // \xe9\x86\x92
{0x9197,{0x7d,0x7f,0x55,0x3b,0x19,0x7a,0x55}}, // \xe9\x86\x97
{0x919c,{0x7d,0x6f,0x7d,0x5e,0x3f,0x7a,0x5e}}, // \xe9\x86\x9c
{0x91a2,{0x7d,0x6f,0x7d,0x4a,0x67,0x7a,0x5a}}, // \xe9\x86\xa2
{0x91a4,{0x0a,0x7f,0x59,0x4b,0x5d,0x7f,0x09}}, // \xe9\x86\xa4
{0x91aa,{0x7d,0x6f,0x7d,0x11,0x4b,0x55,0x2b}}, // \xe9\x86\xaa
{0x91ab,{0x1f,0x77,0x7d,0x55,0x7b,0x75,0x1b}}, // \xe9\x86\xab
{0x91af,{0x7d,0x6f,0x7d,0x52,0x6e,0x7b,0x5a}}, // \xe9\x86\xaf
{0x91b4,{0x7d,0x6f,0x7d,0x5e,0x6f,0x6e,0x5f}}, // \xe9\x86\xb4
{0x91b5,{0x7d,0x6f,0x7d,0x2c,0x57,0x7a,0x2a}}, // \xe9\x86\xb5
{0x91b8,{0x7d,0x7f,0x1a,0x7e,0x53,0x3e,0x5a}}, // \xe9\x86\xb8
{0x91ba,{0x7d,0x6f,0x7d,0x52,0x1f,0x5f,0x52}}, // \xe9\x86\xba
{0x91c0,{0x7d,0x7f,0x36,0x7e,0x5b,0x3e,0x56}}, // \xe9\x87\x80
{0x91c1,{0x44,0x3e,0x55,0x36,0x75,0x3f,0x44}}, // \xe9\x87\x81
{0x91c6,{0x4a,0x4e,0x2a,0x7e,0x29,0x4d,0x49}}, // \xe9\x87\x86
{0x91c7,{0x52,0x56,0x32,0x76,0x39,0x55,0x51}}, // \xe9\x87\x87
{0x91c8,{0x55,0x31,0x7f,0x55,0x3f,0x19,0x67}}, // \xe9\x87\x88
{0x91c9,{0x55,0x31,0x7f,0x35,0x7c,0x7f,0x7c}}, // \xe9\x87\x89
{0x91cb,{0x55,0x31,0x7f,0x2b,0x3b,0x6f,0x3b}}, // \xe9\x87\x8b
{0x91cc,{0x40,0x5f,0x55,0x7f,0x55,0x5f,0x40}}, // \xe9\x87\x8c
{0x91cd,{0x42,0x5e,0x6b,0x7f,0x6b,0x5e,0x42}}, // \xe9\x87\x8d
{0x91ce,{0x5f,0x55,0x7f,0x5f,0x49,0x7d,0x1b}}, // \xe9\x87\x8e
{0x91cf,{0x44,0x5f,0x55,0x7d,0x55,0x5f,0x44}}, // \xe9\x87\x8f
{0x91d0,{0x44,0x3e,0x5f,0x7e,0x7a,0x75,0x5b}}, // \xe9\x87\x90
{0x91d1,{0x54,0x74,0x56,0x7d,0x56,0x74,0x54}}, // \xe9\x87\x91
{0x91d6,{0x56,0x7d,0x36,0x41,0x3f,0x41,0x7f}}, // \xe9\x87\x96
{0x91d8,{0x56,0x7d,0x36,0x01,0x41,0x7f,0x01}}, // \xe9\x87\x98
{0x91db,{0x56,0x7d,0x36,0x42,0x3f,0x42,0x7e}}, // \xe9\x87\x9b
{0x91dc,{0x4a,0x6a,0x55,0x7c,0x55,0x6a,0x4a}}, // \xe9\x87\x9c
{0x91dd,{0x56,0x7d,0x36,0x04,0x04,0x7f,0x04}}, // \xe9\x87\x9d
{0x91df,{0x56,0x7d,0x56,0x3f,0x00,0x3f,0x40}}, // \xe9\x87\x9f
{0x91e1,{0x48,0x6a,0x59,0x74,0x59,0x6a,0x48}}, // \xe9\x87\xa1
{0x91e3,{0x56,0x7d,0x36,0x04,0x0b,0x52,0x7e}}, // \xe9\x87\xa3
{0x91e6,{0x54,0x76,0x7d,0x36,0x7e,0x42,0x7e}}, // \xe9\x87\xa6
{0x91e7,{0x56,0x7d,0x56,0x3f,0x1e,0x00,0x7f}}, // \xe9\x87\xa7
{0x91f5,{0x56,0x7d,0x57,0x29,0x13,0x29,0x47}}, // \xe9\x87\xb5
{0x91f6,{0x56,0x7d,0x36,0x7e,0x44,0x5f,0x6c}}, // \xe9\x87\xb6
{0x91fc,{0x56,0x7d,0x36,0x45,0x3f,0x51,0x7f}}, // \xe9\x87\xbc
{0x91ff,{0x56,0x7d,0x36,0x40,0x3e,0x0a,0x79}}, // \xe9\x87\xbf
{0x920d,{0x56,0x7d,0x1a,0x12,0x7f,0x52,0x5a}}, // \xe9\x88\x8d
{0x920e,{0x56,0x7d,0x36,0x34,0x2b,0x22,0x7e}}, // \xe9\x88\x8e
{0x9211,{0x56,0x7d,0x36,0x5f,0x5d,0x25,0x5d}}, // \xe9\x88\x91
{0x9214,{0x56,0x7d,0x2a,0x46,0x5f,0x22,0x14}}, // \xe9\x88\x94
{0x9215,{0x56,0x7d,0x4b,0x7f,0x49,0x7f,0x48}}, // \xe9\x88\x95
{0x921e,{0x56,0x7d,0x36,0x04,0x2b,0x52,0x7e}}, // \xe9\x88\x9e
{0x9229,{0x56,0x7d,0x36,0x41,0x3d,0x15,0x1d}}, // \xe9\x88\xa9
{0x922c,{0x56,0x7d,0x56,0x3f,0x05,0x1d,0x67}}, // \xe9\x88\xac
{0x9234,{0x56,0x7d,0x36,0x12,0x75,0x16,0x34}}, // \xe9\x88\xb4
{0x9237,{0x56,0x7d,0x36,0x04,0x74,0x5f,0x74}}, // \xe9\x88\xb7
{0x923f,{0x56,0x7d,0x36,0x7f,0x49,0x7f,0x7f}}, // \xe9\x88\xbf
{0x9244,{0x56,0x7d,0x36,0x4c,0x4b,0x3f,0x4a}}, // \xe9\x89\x84
{0x9245,{0x56,0x7d,0x36,0x7f,0x55,0x55,0x5d}}, // \xe9\x89\x85
{0x9248,{0x56,0x7d,0x36,0x06,0x7a,0x53,0x56}}, // \xe9\x89\x88
{0x9249,{0x56,0x7d,0x36,0x4a,0x6e,0x53,0x6a}}, // \xe9\x89\x89
{0x924b,{0x56,0x7d,0x36,0x04,0x7b,0x5a,0x5e}}, // \xe9\x89\x8b
{0x9250,{0x56,0x7d,0x36,0x11,0x7f,0x49,0x79}}, // \xe9\x89\x90
{0x9257,{0x56,0x7d,0x36,0x02,0x7f,0x4a,0x7f}}, // \xe9\x89\x97
{0x925a,{0x56,0x7d,0x5e,0x3d,0x00,0x7f,0x1f}}, // \xe9\x89\x9a
{0x925b,{0x56,0x7d,0x36,0x08,0x77,0x50,0x77}}, // \xe9\x89\x9b
{0x925e,{0x56,0x7d,0x36,0x7e,0x42,0x3f,0x52}}, // \xe9\x89\x9e
{0x9262,{0x56,0x7d,0x12,0x2a,0x7f,0x2a,0x12}}, // \xe9\x89\xa2
{0x9264,{0x56,0x7d,0x36,0x04,0x1b,0x5a,0x7e}}, // \xe9\x89\xa4
{0x9266,{0x56,0x7d,0x36,0x79,0x41,0x7f,0x49}}, // \xe9\x89\xa6
{0x9271,{0x56,0x7d,0x36,0x1e,0x62,0x5b,0x62}}, // \xe9\x89\xb1
{0x927e,{0x56,0x7d,0x36,0x2e,0x7d,0x2c,0x26}}, // \xe9\x89\xbe
{0x9280,{0x56,0x7d,0x36,0x7f,0x55,0x35,0x5f}}, // \xe9\x8a\x80
{0x9283,{0x56,0x7d,0x4a,0x3e,0x0b,0x76,0x4a}}, // \xe9\x8a\x83
{0x9285,{0x56,0x7d,0x36,0x7f,0x35,0x35,0x7f}}, // \xe9\x8a\x85
{0x9291,{0x56,0x7d,0x4e,0x3b,0x0f,0x7a,0x48}}, // \xe9\x8a\x91
{0x9293,{0x56,0x7d,0x36,0x45,0x57,0x7d,0x56}}, // \xe9\x8a\x93
{0x9295,{0x56,0x7d,0x36,0x5e,0x3f,0x56,0x72}}, // \xe9\x8a\x95
{0x9296,{0x56,0x7d,0x4e,0x2b,0x7f,0x2a,0x48}}, // \xe9\x8a\x96
{0x9298,{0x56,0x7d,0x36,0x14,0x7b,0x55,0x73}}, // \xe9\x8a\x98
{0x929a,{0x56,0x7d,0x76,0x3f,0x00,0x7f,0x4a}}, // \xe9\x8a\x9a
{0x929b,{0x56,0x7d,0x36,0x04,0x76,0x5e,0x75}}, // \xe9\x8a\x9b
{0x929c,{0x0a,0x7d,0x56,0x7d,0x36,0x45,0x7d}}, // \xe9\x8a\x9c
{0x92ad,{0x56,0x7d,0x36,0x4a,0x5f,0x2a,0x53}}, // \xe9\x8a\xad
{0x92b7,{0x56,0x7d,0x02,0x7d,0x2a,0x7d,0x02}}, // \xe9\x8a\xb7
{0x92b9,{0x56,0x7d,0x5a,0x37,0x1f,0x37,0x6a}}, // \xe9\x8a\xb9
{0x92cf,{0x56,0x7d,0x56,0x4e,0x3f,0x4e,0x52}}, // \xe9\x8b\x8f
{0x92d2,{0x56,0x7d,0x2a,0x2a,0x75,0x2b,0x28}}, // \xe9\x8b\x92
{0x92e4,{0x56,0x7d,0x7e,0x2a,0x7e,0x1f,0x7c}}, // \xe9\x8b\xa4
{0x92e9,{0x56,0x7d,0x36,0x0a,0x7b,0x4e,0x4b}}, // \xe9\x8b\xa9
{0x92ea,{0x56,0x7d,0x7a,0x2a,0x7f,0x2a,0x7b}}, // \xe9\x8b\xaa
{0x92ed,{0x56,0x7d,0x4e,0x3b,0x0a,0x7b,0x4e}}, // \xe9\x8b\xad
{0x92f2,{0x56,0x7d,0x52,0x1e,0x16,0x1d,0x54}}, // \xe9\x8b\xb2
{0x92f3,{0x56,0x7d,0x36,0x5e,0x17,0x7e,0x14}}, // \xe9\x8b\xb3
{0x92f8,{0x56,0x7d,0x36,0x1f,0x6b,0x5f,0x6b}}, // \xe9\x8b\xb8
{0x92fa,{0x56,0x7d,0x56,0x2a,0x7b,0x4a,0x5e}}, // \xe9\x8b\xba
{0x92fc,{0x56,0x7d,0x7f,0x35,0x29,0x35,0x7f}}, // \xe9\x8b\xbc
{0x9306,{0x56,0x7d,0x36,0x08,0x7a,0x2f,0x7a}}, // \xe9\x8c\x86
{0x930f,{0x56,0x7d,0x5f,0x77,0x41,0x77,0x5d}}, // \xe9\x8c\x8f
{0x9310,{0x56,0x7d,0x36,0x7f,0x4a,0x7f,0x4a}}, // \xe9\x8c\x90
{0x9318,{0x56,0x7d,0x56,0x5d,0x77,0x5d,0x54}}, // \xe9\x8c\x98
{0x9319,{0x56,0x7d,0x36,0x7a,0x5d,0x7a,0x7d}}, // \xe9\x8c\x99
{0x931a,{0x56,0x7d,0x12,0x55,0x7f,0x3d,0x12}}, // \xe9\x8c\x9a
{0x9320,{0x56,0x7d,0x46,0x32,0x46,0x7f,0x56}}, // \xe9\x8c\xa0
{0x9322,{0x56,0x7d,0x36,0x52,0x5b,0x36,0x5b}}, // \xe9\x8c\xa2
{0x9323,{0x56,0x7d,0x5f,0x2b,0x5d,0x2b,0x5d}}, // \xe9\x8c\xa3
{0x9326,{0x56,0x7d,0x32,0x1e,0x7b,0x1e,0x30}}, // \xe9\x8c\xa6
{0x9328,{0x56,0x7d,0x7a,0x5f,0x7a,0x5f,0x7a}}, // \xe9\x8c\xa8
{0x932b,{0x56,0x7d,0x36,0x27,0x5d,0x35,0x77}}, // \xe9\x8c\xab
{0x932c,{0x56,0x7d,0x42,0x2e,0x7f,0x2e,0x42}}, // \xe9\x8c\xac
{0x932e,{0x56,0x7d,0x7f,0x75,0x6f,0x75,0x7f}}, // \xe9\x8c\xae
{0x932f,{0x56,0x7d,0x0a,0x7f,0x5a,0x7f,0x0a}}, // \xe9\x8c\xaf
{0x9332,{0x56,0x7d,0x56,0x25,0x7d,0x27,0x54}}, // \xe9\x8c\xb2
{0x9335,{0x56,0x7d,0x36,0x7b,0x02,0x7f,0x52}}, // \xe9\x8c\xb5
{0x933a,{0x56,0x7d,0x36,0x4a,0x3b,0x2e,0x6b}}, // \xe9\x8c\xba
{0x933b,{0x56,0x7d,0x36,0x75,0x65,0x3e,0x45}}, // \xe9\x8c\xbb
{0x9344,{0x56,0x7d,0x22,0x4e,0x7b,0x0e,0x22}}, // \xe9\x8d\x84
{0x934b,{0x56,0x7d,0x36,0x78,0x6f,0x09,0x7f}}, // \xe9\x8d\x8b
{0x934d,{0x56,0x7d,0x3e,0x4a,0x5f,0x2e,0x5a}}, // \xe9\x8d\x8d
{0x9354,{0x56,0x7d,0x36,0x0b,0x1f,0x5c,0x6b}}, // \xe9\x8d\x94
{0x9356,{0x56,0x7d,0x72,0x5f,0x72,0x5f,0x52}}, // \xe9\x8d\x96
{0x935b,{0x56,0x7d,0x36,0x7e,0x55,0x2b,0x5b}}, // \xe9\x8d\x9b
{0x935c,{0x56,0x7d,0x7f,0x2b,0x58,0x2d,0x5f}}, // \xe9\x8d\x9c
{0x9360,{0x56,0x7d,0x36,0x50,0x5e,0x7b,0x5e}}, // \xe9\x8d\xa0
{0x936c,{0x56,0x7d,0x36,0x7f,0x4c,0x3f,0x44}}, // \xe9\x8d\xac
{0x936e,{0x56,0x7d,0x36,0x73,0x75,0x26,0x54}}, // \xe9\x8d\xae
{0x9375,{0x56,0x7d,0x36,0x49,0x37,0x4a,0x5f}}, // \xe9\x8d\xb5
{0x937c,{0x56,0x7d,0x3e,0x6a,0x6a,0x3f,0x52}}, // \xe9\x8d\xbc
{0x937e,{0x56,0x7d,0x36,0x44,0x5e,0x7e,0x5d}}, // \xe9\x8d\xbe
{0x938c,{0x56,0x7d,0x52,0x37,0x7e,0x3f,0x4a}}, // \xe9\x8e\x8c
{0x9394,{0x56,0x7d,0x26,0x16,0x6b,0x76,0x26}}, // \xe9\x8e\x94
{0x9396,{0x56,0x7d,0x36,0x5d,0x14,0x17,0x5d}}, // \xe9\x8e\x96
{0x9397,{0x56,0x7d,0x36,0x44,0x3e,0x6d,0x62}}, // \xe9\x8e\x97
{0x939a,{0x56,0x7d,0x36,0x79,0x40,0x7e,0x77}}, // \xe9\x8e\x9a
{0x93a7,{0x56,0x7d,0x36,0x5b,0x6a,0x6b,0x5b}}, // \xe9\x8e\xa7
{0x93ac,{0x56,0x7d,0x72,0x1e,0x5b,0x1e,0x72}}, // \xe9\x8e\xac
{0x93ad,{0x56,0x7d,0x36,0x58,0x1f,0x1e,0x52}}, // \xe9\x8e\xad
{0x93ae,{0x56,0x7d,0x36,0x52,0x1e,0x1f,0x52}}, // \xe9\x8e\xae
{0x93b0,{0x56,0x7d,0x52,0x6d,0x64,0x6d,0x52}}, // \xe9\x8e\xb0
{0x93b9,{0x56,0x7d,0x36,0x75,0x6a,0x59,0x6a}}, // \xe9\x8e\xb9
{0x93c3,{0x56,0x7d,0x62,0x1f,0x7a,0x3f,0x56}}, // \xe9\x8f\x83
{0x93c8,{0x56,0x7d,0x32,0x65,0x5e,0x7f,0x52}}, // \xe9\x8f\x88
{0x93d0,{0x56,0x7d,0x36,0x11,0x4b,0x55,0x2b}}, // \xe9\x8f\x90
{0x93d1,{0x56,0x7d,0x7a,0x6e,0x5b,0x6e,0x7a}}, // \xe9\x8f\x91
{0x93d6,{0x10,0x4e,0x6a,0x5e,0x7f,0x5e,0x6a}}, // \xe9\x8f\x96
{0x93d7,{0x56,0x7d,0x47,0x57,0x7b,0x55,0x4b}}, // \xe9\x8f\x97
{0x93d8,{0x56,0x7d,0x36,0x7f,0x2a,0x4d,0x7b}}, // \xe9\x8f\x98
{0x93dd,{0x56,0x7d,0x36,0x4c,0x5f,0x2d,0x5f}}, // \xe9\x8f\x9d
{0x93e1,{0x56,0x7d,0x4a,0x3e,0x3b,0x7e,0x4a}}, // \xe9\x8f\xa1
{0x93e4,{0x56,0x7d,0x56,0x7e,0x5b,0x3e,0x54}}, // \xe9\x8f\xa4
{0x93e5,{0x56,0x7d,0x36,0x76,0x0b,0x7a,0x6e}}, // \xe9\x8f\xa5
{0x93e8,{0x5a,0x7e,0x5f,0x7a,0x57,0x7d,0x55}}, // \xe9\x8f\xa8
{0x9403,{0x56,0x7d,0x5e,0x3e,0x17,0x7e,0x5c}}, // \xe9\x90\x83
{0x9407,{0x56,0x7d,0x36,0x15,0x6f,0x7f,0x15}}, // \xe9\x90\x87
{0x9410,{0x56,0x7d,0x4a,0x1e,0x6b,0x1e,0x4a}}, // \xe9\x90\x90
{0x9413,{0x56,0x7d,0x2e,0x7b,0x56,0x3f,0x5e}}, // \xe9\x90\x93
{0x9414,{0x56,0x7d,0x36,0x21,0x3b,0x7b,0x21}}, // \xe9\x90\x94
{0x9418,{0x56,0x7d,0x4a,0x5e,0x7b,0x5e,0x4a}}, // \xe9\x90\x98
{0x9419,{0x56,0x7d,0x46,0x5b,0x69,0x5a,0x45}}, // \xe9\x90\x99
{0x941a,{0x56,0x7d,0x36,0x6d,0x2f,0x4f,0x6d}}, // \xe9\x90\x9a
{0x9421,{0x56,0x7d,0x5e,0x6f,0x5e,0x3f,0x55}}, // \xe9\x90\xa1
{0x942b,{0x56,0x7d,0x76,0x1f,0x2a,0x1f,0x7a}}, // \xe9\x90\xab
{0x9435,{0x56,0x7d,0x5e,0x77,0x5e,0x3f,0x55}}, // \xe9\x90\xb5
{0x9436,{0x56,0x7d,0x36,0x7f,0x55,0x37,0x5f}}, // \xe9\x90\xb6
{0x9438,{0x56,0x7d,0x2b,0x3b,0x6f,0x3b,0x2b}}, // \xe9\x90\xb8
{0x943a,{0x56,0x7d,0x77,0x5e,0x7b,0x5e,0x75}}, // \xe9\x90\xba
{0x9441,{0x56,0x7d,0x2f,0x5d,0x2a,0x5d,0x4f}}, // \xe9\x91\x81
{0x9444,{0x56,0x7d,0x36,0x36,0x5f,0x76,0x14}}, // \xe9\x91\x84
{0x9451,{0x56,0x7d,0x36,0x4f,0x60,0x6b,0x4a}}, // \xe9\x91\x91
{0x9452,{0x57,0x77,0x5d,0x78,0x5f,0x76,0x56}}, // \xe9\x91\x92
{0x9453,{0x56,0x7d,0x36,0x79,0x46,0x7f,0x76}}, // \xe9\x91\x93
{0x945a,{0x56,0x7d,0x4a,0x37,0x3a,0x37,0x4a}}, // \xe9\x91\x9a
{0x945b,{0x56,0x7d,0x3e,0x4a,0x3f,0x3e,0x4a}}, // \xe9\x91\x9b
{0x945e,{0x56,0x7d,0x56,0x3e,0x75,0x2e,0x7d}}, // \xe9\x91\x9e
{0x9460,{0x56,0x7d,0x5a,0x35,0x7f,0x3a,0x55}}, // \xe9\x91\xa0
{0x9462,{0x56,0x7d,0x3e,0x64,0x3f,0x5a,0x6a}}, // \xe9\x91\xa2
{0x946a,{0x56,0x7d,0x36,0x5c,0x64,0x6f,0x4a}}, // \xe9\x91\xaa
{0x9470,{0x56,0x7d,0x76,0x3e,0x7d,0x3e,0x74}}, // \xe9\x91\xb0
{0x9475,{0x56,0x7d,0x26,0x7f,0x52,0x7f,0x56}}, // \xe9\x91\xb5
{0x9477,{0x56,0x7d,0x36,0x75,0x27,0x3f,0x75}}, // \xe9\x91\xb7
{0x947c,{0x56,0x7d,0x2f,0x75,0x27,0x7d,0x57}}, // \xe9\x91\xbc
{0x947d,{0x56,0x7d,0x4b,0x36,0x3b,0x36,0x4a}}, // \xe9\x91\xbd
{0x947e,{0x4a,0x6d,0x5a,0x77,0x5a,0x6d,0x48}}, // \xe9\x91\xbe
{0x947f,{0x55,0x7e,0x5f,0x7e,0x5b,0x75,0x5b}}, // \xe9\x91\xbf
{0x9481,{0x56,0x7d,0x43,0x5f,0x2c,0x5f,0x4b}}, // \xe9\x92\x81
{0x9577,{0x10,0x50,0x7f,0x55,0x35,0x51,0x50}}, // \xe9\x95\xb7
{0x9580,{0x7f,0x05,0x07,0x00,0x07,0x45,0x7f}}, // \xe9\x96\x80
{0x9582,{0x7f,0x05,0x17,0x10,0x17,0x45,0x7f}}, // \xe9\x96\x82
{0x9583,{0x7f,0x45,0x27,0x18,0x27,0x45,0x7f}}, // \xe9\x96\x83
{0x9587,{0x7f,0x05,0x0f,0x78,0x2f,0x05,0x7f}}, // \xe9\x96\x87
{0x9589,{0x7f,0x55,0x37,0x78,0x17,0x45,0x7f}}, // \xe9\x96\x89
{0x958a,{0x7f,0x35,0x27,0x38,0x27,0x35,0x7f}}, // \xe9\x96\x8a
{0x958b,{0x7f,0x2b,0x7b,0x28,0x7b,0x2b,0x7f}}, // \xe9\x96\x8b
{0x958f,{0x7f,0x05,0x57,0x7c,0x57,0x05,0x7f}}, // \xe9\x96\x8f
{0x9591,{0x7f,0x2b,0x1b,0x7c,0x1b,0x2b,0x7f}}, // \xe9\x96\x91
{0x9593,{0x7f,0x05,0x7f,0x54,0x7f,0x05,0x7f}}, // \xe9\x96\x93
{0x9594,{0x7f,0x4b,0x5b,0x2c,0x5b,0x4b,0x7f}}, // \xe9\x96\x94
{0x9596,{0x7f,0x55,0x37,0x78,0x27,0x55,0x7f}}, // \xe9\x96\x96
{0x9598,{0x7f,0x05,0x37,0x70,0x37,0x05,0x7f}}, // \xe9\x96\x98
{0x9599,{0x7f,0x0b,0x3b,0x7c,0x1b,0x3b,0x7f}}, // \xe9\x96\x99
{0x95a0,{0x7f,0x05,0x57,0x7c,0x57,0x25,0x7f}}, // \xe9\x96\xa0
{0x95a2,{0x7f,0x13,0x57,0x38,0x57,0x13,0x7f}}, // \xe9\x96\xa2
{0x95a3,{0x7f,0x23,0x6b,0x54,0x6f,0x23,0x7f}}, // \xe9\x96\xa3
{0x95a4,{0x7f,0x13,0x7b,0x54,0x7b,0x13,0x7f}}, // \xe9\x96\xa4
{0x95a5,{0x7f,0x13,0x7b,0x50,0x3b,0x4b,0x7f}}, // \xe9\x96\xa5
{0x95a7,{0x7f,0x6b,0x3f,0x28,0x3f,0x6b,0x7f}}, // \xe9\x96\xa7
{0x95a8,{0x7f,0x53,0x7b,0x7c,0x7b,0x53,0x7f}}, // \xe9\x96\xa8
{0x95ad,{0x7f,0x73,0x5f,0x54,0x7f,0x03,0x7f}}, // \xe9\x96\xad
{0x95b2,{0x7f,0x43,0x5f,0x28,0x7f,0x43,0x7f}}, // \xe9\x96\xb2
{0x95b9,{0x7f,0x2b,0x1b,0x3c,0x7b,0x5b,0x7f}}, // \xe9\x96\xb9
{0x95bb,{0x7f,0x03,0x6b,0x54,0x5f,0x73,0x7f}}, // \xe9\x96\xbb
{0x95bc,{0x7f,0x4b,0x3f,0x68,0x57,0x2b,0x7f}}, // \xe9\x96\xbc
{0x95be,{0x7f,0x5b,0x5b,0x08,0x3f,0x4b,0x7f}}, // \xe9\x96\xbe
{0x95c3,{0x7f,0x53,0x5f,0x34,0x5f,0x53,0x7f}}, // \xe9\x97\x83
{0x95c7,{0x7f,0x2b,0x7b,0x6c,0x7b,0x2b,0x7f}}, // \xe9\x97\x87
{0x95ca,{0x7f,0x57,0x0b,0x6c,0x5f,0x6b,0x7f}}, // \xe9\x97\x8a
{0x95cc,{0x7f,0x4b,0x3b,0x7c,0x3b,0x4b,0x7f}}, // \xe9\x97\x8c
{0x95cd,{0x7f,0x53,0x3b,0x7c,0x7b,0x17,0x7f}}, // \xe9\x97\x8d
{0x95d4,{0x7f,0x03,0x5b,0x7c,0x6f,0x5b,0x7f}}, // \xe9\x97\x94
{0x95d5,{0x7f,0x57,0x3b,0x4c,0x3b,0x5b,0x7f}}, // \xe9\x97\x95
{0x95d6,{0x7f,0x43,0x1f,0x5c,0x17,0x73,0x7f}}, // \xe9\x97\x96
{0x95d8,{0x7f,0x5b,0x6b,0x58,0x13,0x7b,0x7f}}, // \xe9\x97\x98
{0x95dc,{0x7f,0x5b,0x37,0x10,0x7b,0x37,0x7f}}, // \xe9\x97\x9c
{0x95e1,{0x7f,0x27,0x3f,0x78,0x3f,0x27,0x7f}}, // \xe9\x97\xa1
{0x95e2,{0x7f,0x7f,0x6f,0x38,0x6f,0x3b,0x7f}}, // \xe9\x97\xa2
{0x95e5,{0x7f,0x57,0x33,0x58,0x7f,0x5b,0x7f}}, // \xe9\x97\xa5
{0x961c,{0x20,0x3e,0x2a,0x6b,0x2e,0x38,0x20}}, // \xe9\x98\x9c
{0x9621,{0x7f,0x25,0x1b,0x08,0x0a,0x7e,0x09}}, // \xe9\x98\xa1
{0x9628,{0x7f,0x1b,0x40,0x3f,0x7d,0x45,0x5d}}, // \xe9\x98\xa8
{0x962a,{0x7f,0x1b,0x20,0x5f,0x5d,0x25,0x5d}}, // \xe9\x98\xaa
{0x962e,{0x7f,0x1b,0x44,0x3d,0x05,0x7d,0x44}}, // \xe9\x98\xae
{0x962f,{0x7f,0x1b,0x40,0x7c,0x40,0x7f,0x44}}, // \xe9\x98\xaf
{0x9632,{0x7f,0x25,0x1b,0x42,0x3e,0x4b,0x7a}}, // \xe9\x98\xb2
{0x963b,{0x7f,0x1b,0x40,0x7f,0x55,0x7f,0x40}}, // \xe9\x98\xbb
{0x963f,{0x7f,0x25,0x1b,0x1d,0x15,0x5d,0x7f}}, // \xe9\x98\xbf
{0x9640,{0x7f,0x25,0x1b,0x06,0x7a,0x53,0x56}}, // \xe9\x99\x80
{0x9642,{0x7f,0x1b,0x40,0x3e,0x5a,0x2f,0x5e}}, // \xe9\x99\x82
{0x9644,{0x7f,0x25,0x1b,0x7e,0x09,0x42,0x7f}}, // \xe9\x99\x84
{0x964b,{0x7f,0x25,0x1b,0x7c,0x55,0x4f,0x5d}}, // \xe9\x99\x8b
{0x964c,{0x7f,0x1b,0x00,0x7d,0x57,0x55,0x7d}}, // \xe9\x99\x8c
{0x964d,{0x7f,0x1b,0x28,0x3a,0x35,0x7b,0x28}}, // \xe9\x99\x8d
{0x964f,{0x7f,0x25,0x1b,0x12,0x7f,0x2a,0x7a}}, // \xe9\x99\x8f
{0x9650,{0x7f,0x25,0x1b,0x7f,0x55,0x35,0x5f}}, // \xe9\x99\x90
{0x965b,{0x7f,0x1b,0x4f,0x5a,0x70,0x5f,0x4a}}, // \xe9\x99\x9b
{0x965c,{0x7f,0x1b,0x52,0x4e,0x3f,0x4e,0x52}}, // \xe9\x99\x9c
{0x965d,{0x7f,0x1b,0x52,0x4e,0x3f,0x4e,0x52}}, // \xe9\x99\x9d
{0x965e,{0x7f,0x1b,0x56,0x4e,0x65,0x5f,0x44}}, // \xe9\x99\x9e
{0x965f,{0x7f,0x25,0x1b,0x4e,0x58,0x2f,0x1a}}, // \xe9\x99\x9f
{0x9662,{0x7f,0x1b,0x56,0x32,0x17,0x76,0x56}}, // \xe9\x99\xa2
{0x9663,{0x7f,0x1b,0x22,0x3e,0x7f,0x3e,0x22}}, // \xe9\x99\xa3
{0x9664,{0x7f,0x1b,0x54,0x16,0x7d,0x16,0x54}}, // \xe9\x99\xa4
{0x9665,{0x7f,0x25,0x1b,0x7a,0x01,0x7d,0x7b}}, // \xe9\x99\xa5
{0x9666,{0x7f,0x1b,0x34,0x5e,0x17,0x7e,0x14}}, // \xe9\x99\xa6
{0x966a,{0x7f,0x1b,0x0a,0x6e,0x6b,0x6e,0x0a}}, // \xe9\x99\xaa
{0x966c,{0x7f,0x1b,0x21,0x3f,0x7f,0x12,0x2e}}, // \xe9\x99\xac
{0x9670,{0x7f,0x1b,0x54,0x76,0x5d,0x32,0x54}}, // \xe9\x99\xb0
{0x9672,{0x7f,0x1b,0x54,0x5d,0x77,0x5d,0x54}}, // \xe9\x99\xb2
{0x9673,{0x7f,0x1b,0x42,0x2e,0x7f,0x2e,0x42}}, // \xe9\x99\xb3
{0x9675,{0x7f,0x1b,0x28,0x5a,0x2f,0x5a,0x48}}, // \xe9\x99\xb5
{0x9676,{0x7f,0x1b,0x64,0x4b,0x7e,0x6a,0x7e}}, // \xe9\x99\xb6
{0x9677,{0x7f,0x25,0x1b,0x7a,0x41,0x6d,0x7b}}, // \xe9\x99\xb7
{0x9678,{0x7f,0x1b,0x54,0x4e,0x67,0x5e,0x54}}, // \xe9\x99\xb8
{0x967a,{0x7f,0x1b,0x5c,0x56,0x3d,0x56,0x5c}}, // \xe9\x99\xba
{0x967d,{0x7f,0x1b,0x24,0x5f,0x35,0x57,0x74}}, // \xe9\x99\xbd
{0x9685,{0x7f,0x1b,0x78,0x4b,0x7f,0x2b,0x78}}, // \xe9\x9a\x85
{0x9686,{0x7f,0x1b,0x48,0x5a,0x75,0x5b,0x48}}, // \xe9\x9a\x86
{0x9688,{0x7f,0x25,0x1b,0x77,0x55,0x37,0x57}}, // \xe9\x9a\x88
{0x968a,{0x7f,0x1b,0x2a,0x57,0x7a,0x13,0x2a}}, // \xe9\x9a\x8a
{0x968b,{0x7f,0x25,0x1b,0x76,0x3b,0x7e,0x0a}}, // \xe9\x9a\x8b
{0x968d,{0x7f,0x1b,0x50,0x5e,0x7b,0x5e,0x50}}, // \xe9\x9a\x8d
{0x968e,{0x7f,0x25,0x1f,0x6a,0x70,0x6f,0x0a}}, // \xe9\x9a\x8e
{0x968f,{0x7f,0x25,0x5b,0x39,0x4a,0x77,0x72}}, // \xe9\x9a\x8f
{0x9694,{0x7f,0x25,0x1b,0x79,0x2f,0x6f,0x79}}, // \xe9\x9a\x94
{0x9695,{0x7f,0x25,0x1b,0x5c,0x17,0x17,0x5c}}, // \xe9\x9a\x95
{0x9697,{0x7f,0x1b,0x5e,0x2a,0x7f,0x6a,0x5e}}, // \xe9\x9a\x97
{0x9698,{0x7f,0x1b,0x52,0x6d,0x64,0x6d,0x52}}, // \xe9\x9a\x98
{0x9699,{0x7f,0x25,0x1b,0x22,0x4c,0x7f,0x22}}, // \xe9\x9a\x99
{0x969b,{0x7f,0x1b,0x4a,0x15,0x73,0x15,0x4b}}, // \xe9\x9a\x9b
{0x969c,{0x7f,0x1b,0x2a,0x3e,0x7b,0x3e,0x2a}}, // \xe9\x9a\x9c
{0x96a0,{0x7f,0x1b,0x66,0x3a,0x5e,0x59,0x65}}, // \xe9\x9a\xa0
{0x96a3,{0x7f,0x25,0x5b,0x32,0x27,0x72,0x25}}, // \xe9\x9a\xa3
{0x96a7,{0x7f,0x1b,0x75,0x52,0x6d,0x7d,0x56}}, // \xe9\x9a\xa7
{0x96a8,{0x7f,0x25,0x1b,0x65,0x4a,0x7f,0x7a}}, // \xe9\x9a\xa8
{0x96aa,{0x7f,0x1b,0x5c,0x36,0x5d,0x36,0x5c}}, // \xe9\x9a\xaa
{0x96b0,{0x7f,0x1b,0x58,0x17,0x43,0x1b,0x54}}, // \xe9\x9a\xb0
{0x96b1,{0x7f,0x1b,0x62,0x35,0x5f,0x5d,0x6a}}, // \xe9\x9a\xb1
{0x96b2,{0x7f,0x25,0x1b,0x45,0x1c,0x5b,0x69}}, // \xe9\x9a\xb2
{0x96b4,{0x7f,0x1b,0x7e,0x2b,0x7e,0x77,0x5d}}, // \xe9\x9a\xb4
{0x96b6,{0x48,0x5a,0x2a,0x7f,0x2a,0x5e,0x44}}, // \xe9\x9a\xb6
{0x96b7,{0x2a,0x6f,0x2a,0x5a,0x7f,0x2e,0x54}}, // \xe9\x9a\xb7
{0x96b8,{0x4a,0x16,0x7f,0x2a,0x7f,0x2e,0x54}}, // \xe9\x9a\xb8
{0x96b9,{0x08,0x04,0x7f,0x4a,0x7f,0x4a,0x42}}, // \xe9\x9a\xb9
{0x96bb,{0x48,0x44,0x5f,0x2a,0x5f,0x4a,0x4a}}, // \xe9\x9a\xbb
{0x96bc,{0x28,0x24,0x2f,0x7a,0x2f,0x2a,0x2a}}, // \xe9\x9a\xbc
{0x96c0,{0x14,0x12,0x78,0x5f,0x74,0x52,0x54}}, // \xe9\x9b\x80
{0x96c1,{0x40,0x3f,0x7d,0x0b,0x7d,0x7f,0x55}}, // \xe9\x9b\x81
{0x96c4,{0x22,0x5a,0x67,0x52,0x7f,0x7e,0x4b}}, // \xe9\x9b\x84
{0x96c5,{0x2f,0x59,0x7f,0x04,0x7f,0x7e,0x4b}}, // \xe9\x9b\x85
{0x96c6,{0x54,0x52,0x3f,0x7a,0x3f,0x5a,0x50}}, // \xe9\x9b\x86
{0x96c7,{0x41,0x3f,0x25,0x7d,0x55,0x7f,0x51}}, // \xe9\x9b\x87
{0x96c9,{0x44,0x2b,0x1e,0x2a,0x7f,0x7e,0x4b}}, // \xe9\x9b\x89
{0x96cb,{0x74,0x12,0x3f,0x2a,0x3f,0x5a,0x7a}}, // \xe9\x9b\x8b
{0x96cc,{0x7c,0x7f,0x24,0x7f,0x4a,0x7f,0x4a}}, // \xe9\x9b\x8c
{0x96cd,{0x5a,0x36,0x12,0x7f,0x4a,0x7e,0x4a}}, // \xe9\x9b\x8d
{0x96ce,{0x40,0x7f,0x55,0x3f,0x7f,0x7e,0x4b}}, // \xe9\x9b\x8e
{0x96d1,{0x5a,0x37,0x7e,0x28,0x7f,0x7e,0x4b}}, // \xe9\x9b\x91
{0x96d5,{0x7f,0x35,0x2f,0x35,0x7f,0x7e,0x4b}}, // \xe9\x9b\x95
{0x96d6,{0x5b,0x7d,0x5b,0x7e,0x4b,0x7e,0x4b}}, // \xe9\x9b\x96
{0x96d9,{0x44,0x4f,0x5e,0x2b,0x5e,0x4f,0x4a}}, // \xe9\x9b\x99
{0x96db,{0x24,0x5b,0x36,0x36,0x7f,0x7e,0x4b}}, // \xe9\x9b\x9b
{0x96dc,{0x5a,0x36,0x7b,0x36,0x7f,0x7e,0x4b}}, // \xe9\x9b\x9c
{0x96e2,{0x72,0x5e,0x7b,0x36,0x7f,0x7e,0x4b}}, // \xe9\x9b\xa2
{0x96e3,{0x5a,0x5f,0x3a,0x5f,0x7f,0x7e,0x4b}}, // \xe9\x9b\xa3
{0x96e8,{0x7d,0x05,0x55,0x7f,0x05,0x55,0x7d}}, // \xe9\x9b\xa8
{0x96ea,{0x06,0x52,0x57,0x57,0x53,0x76,0x06}}, // \xe9\x9b\xaa
{0x96eb,{0x16,0x12,0x17,0x77,0x33,0x56,0x16}}, // \xe9\x9b\xab
{0x96f0,{0x16,0x4a,0x57,0x37,0x53,0x7e,0x16}}, // \xe9\x9b\xb0
{0x96f2,{0x56,0x52,0x77,0x57,0x53,0x36,0x56}}, // \xe9\x9b\xb2
{0x96f6,{0x16,0x12,0x1f,0x77,0x1b,0x16,0x36}}, // \xe9\x9b\xb6
{0x96f7,{0x06,0x72,0x57,0x77,0x53,0x76,0x06}}, // \xe9\x9b\xb7
{0x96f9,{0x16,0x12,0x6f,0x6f,0x6b,0x4e,0x5e}}, // \xe9\x9b\xb9
{0x96fb,{0x06,0x3a,0x2f,0x3f,0x6b,0x7e,0x46}}, // \xe9\x9b\xbb
{0x9700,{0x66,0x2a,0x6f,0x3f,0x6b,0x2e,0x66}}, // \xe9\x9c\x80
{0x9704,{0x16,0x0a,0x7f,0x2f,0x7b,0x0e,0x16}}, // \xe9\x9c\x84
{0x9706,{0x56,0x2a,0x47,0x57,0x5b,0x7e,0x56}}, // \xe9\x9c\x86
{0x9707,{0x46,0x3a,0x7f,0x5f,0x3b,0x5e,0x56}}, // \xe9\x9c\x87
{0x9708,{0x56,0x0a,0x6f,0x2f,0x7b,0x2e,0x6e}}, // \xe9\x9c\x88
{0x970a,{0x56,0x62,0x57,0x77,0x53,0x66,0x56}}, // \xe9\x9c\x8a
{0x970d,{0x26,0x12,0x7f,0x57,0x7b,0x56,0x56}}, // \xe9\x9c\x8d
{0x970e,{0x56,0x52,0x7f,0x57,0x3b,0x56,0x56}}, // \xe9\x9c\x8e
{0x970f,{0x36,0x72,0x3f,0x07,0x7b,0x36,0x36}}, // \xe9\x9c\x8f
{0x9711,{0x56,0x02,0x67,0x67,0x7b,0x76,0x16}}, // \xe9\x9c\x91
{0x9713,{0x46,0x5a,0x37,0x17,0x7b,0x5e,0x46}}, // \xe9\x9c\x93
{0x9716,{0x56,0x32,0x7f,0x57,0x33,0x7e,0x56}}, // \xe9\x9c\x96
{0x9719,{0x56,0x5a,0x5f,0x3f,0x5b,0x5e,0x56}}, // \xe9\x9c\x99
{0x971c,{0x56,0x32,0x7f,0x37,0x7b,0x4e,0x7e}}, // \xe9\x9c\x9c
{0x971e,{0x7e,0x2a,0x2f,0x07,0x5b,0x2e,0x5e}}, // \xe9\x9c\x9e
{0x9724,{0x06,0x1a,0x77,0x73,0x6f,0x1e,0x06}}, // \xe9\x9c\xa4
{0x9727,{0x56,0x3a,0x7f,0x17,0x5b,0x2e,0x76}}, // \xe9\x9c\xa7
{0x972a,{0x56,0x02,0x5f,0x5f,0x7b,0x56,0x56}}, // \xe9\x9c\xaa
{0x9730,{0x16,0x7a,0x37,0x7f,0x53,0x2e,0x5e}}, // \xe9\x9c\xb0
{0x9732,{0x5e,0x6a,0x5f,0x27,0x6b,0x56,0x6e}}, // \xe9\x9c\xb2
{0x9738,{0x26,0x3a,0x77,0x3f,0x43,0x36,0x76}}, // \xe9\x9c\xb8
{0x9739,{0x26,0x7a,0x7f,0x2f,0x3b,0x6e,0x3e}}, // \xe9\x9c\xb9
{0x973d,{0x2e,0x5a,0x3f,0x2f,0x7b,0x1e,0x2e}}, // \xe9\x9c\xbd
{0x973e,{0x56,0x6a,0x37,0x07,0x5b,0x7e,0x5e}}, // \xe9\x9c\xbe
{0x9742,{0x46,0x3a,0x5f,0x7f,0x6b,0x5e,0x5e}}, // \xe9\x9d\x82
{0x9744,{0x6e,0x6a,0x07,0x67,0x5b,0x1e,0x76}}, // \xe9\x9d\x84
{0x9746,{0x56,0x73,0x57,0x65,0x52,0x7f,0x56}}, // \xe9\x9d\x86
{0x9748,{0x5e,0x7a,0x5f,0x7f,0x5b,0x7e,0x5e}}, // \xe9\x9d\x88
{0x9749,{0x56,0x73,0x57,0x2f,0x55,0x37,0x4d}}, // \xe9\x9d\x89
{0x9752,{0x08,0x7a,0x2a,0x2f,0x2a,0x7a,0x08}}, // \xe9\x9d\x92
{0x9756,{0x2e,0x33,0x2e,0x08,0x7a,0x2f,0x7a}}, // \xe9\x9d\x96
{0x9759,{0x08,0x7a,0x2f,0x7a,0x2a,0x7d,0x3b}}, // \xe9\x9d\x99
{0x975c,{0x7a,0x3f,0x7a,0x15,0x7f,0x3d,0x12}}, // \xe9\x9d\x9c
{0x975e,{0x2a,0x6a,0x3f,0x00,0x7f,0x2a,0x2a}}, // \xe9\x9d\x9e
{0x9760,{0x24,0x7f,0x36,0x17,0x76,0x3e,0x24}}, // \xe9\x9d\xa0
{0x9761,{0x40,0x3e,0x6a,0x3e,0x0b,0x7e,0x2a}}, // \xe9\x9d\xa1
{0x9762,{0x7d,0x45,0x7d,0x57,0x7d,0x45,0x7d}}, // \xe9\x9d\xa2
{0x9764,{0x7d,0x7d,0x57,0x7d,0x04,0x7b,0x5e}}, // \xe9\x9d\xa4
{0x9766,{0x7d,0x7d,0x57,0x7d,0x5f,0x35,0x5f}}, // \xe9\x9d\xa6
{0x9768,{0x18,0x77,0x7f,0x5d,0x7b,0x77,0x1b}}, // \xe9\x9d\xa8
{0x9769,{0x22,0x3a,0x2f,0x7a,0x2f,0x3a,0x22}}, // \xe9\x9d\xa9
{0x976b,{0x37,0x7e,0x57,0x29,0x13,0x29,0x47}}, // \xe9\x9d\xab
{0x976d,{0x37,0x7e,0x37,0x49,0x3f,0x51,0x7f}}, // \xe9\x9d\xad
{0x9771,{0x37,0x7e,0x37,0x45,0x3f,0x51,0x7f}}, // \xe9\x9d\xb1
{0x9774,{0x37,0x7e,0x37,0x7e,0x01,0x7f,0x44}}, // \xe9\x9d\xb4
{0x9779,{0x37,0x7e,0x37,0x7c,0x15,0x4f,0x7c}}, // \xe9\x9d\xb9
{0x977a,{0x37,0x7e,0x47,0x2a,0x7f,0x2a,0x42}}, // \xe9\x9d\xba
{0x977c,{0x37,0x7e,0x37,0x40,0x5f,0x55,0x5f}}, // \xe9\x9d\xbc
{0x9781,{0x37,0x7e,0x37,0x3e,0x5a,0x2f,0x5e}}, // \xe9\x9e\x81
{0x9784,{0x37,0x7e,0x37,0x04,0x73,0x56,0x5e}}, // \xe9\x9e\x84
{0x9785,{0x37,0x7e,0x37,0x48,0x4e,0x3b,0x4e}}, // \xe9\x9e\x85
{0x9786,{0x37,0x7e,0x37,0x7d,0x15,0x4f,0x7d}}, // \xe9\x9e\x86
{0x978b,{0x37,0x7e,0x37,0x48,0x5a,0x7f,0x5a}}, // \xe9\x9e\x8b
{0x978d,{0x37,0x7e,0x4f,0x5a,0x2f,0x3a,0x4e}}, // \xe9\x9e\x8d
{0x978f,{0x25,0x2f,0x3d,0x7c,0x3b,0x2f,0x24}}, // \xe9\x9e\x8f
{0x9790,{0x37,0x7e,0x37,0x08,0x7f,0x1a,0x2a}}, // \xe9\x9e\x90
{0x9798,{0x37,0x7e,0x37,0x7d,0x14,0x57,0x7d}}, // \xe9\x9e\x98
{0x979c,{0x37,0x7e,0x3b,0x76,0x5f,0x74,0x0a}}, // \xe9\x9e\x9c
{0x97a0,{0x37,0x7e,0x37,0x57,0x3a,0x56,0x7e}}, // \xe9\x9e\xa0
{0x97a3,{0x37,0x7e,0x5b,0x37,0x7f,0x33,0x56}}, // \xe9\x9e\xa3
{0x97a6,{0x37,0x7e,0x37,0x7f,0x4c,0x3f,0x44}}, // \xe9\x9e\xa6
{0x97a8,{0x37,0x7e,0x37,0x3f,0x2d,0x4f,0x78}}, // \xe9\x9e\xa8
{0x97ab,{0x37,0x7e,0x37,0x6c,0x6b,0x02,0x7e}}, // \xe9\x9e\xab
{0x97ad,{0x37,0x7e,0x37,0x7e,0x5d,0x3f,0x4d}}, // \xe9\x9e\xad
{0x97b3,{0x37,0x7e,0x37,0x12,0x7b,0x56,0x7b}}, // \xe9\x9e\xb3
{0x97b4,{0x37,0x7e,0x37,0x1a,0x6f,0x2a,0x6f}}, // \xe9\x9e\xb4
{0x97c3,{0x37,0x7e,0x6b,0x54,0x5e,0x77,0x5e}}, // \xe9\x9f\x83
{0x97c6,{0x37,0x7e,0x77,0x49,0x77,0x6f,0x49}}, // \xe9\x9f\x86
{0x97c8,{0x37,0x7e,0x37,0x7a,0x4f,0x3e,0x5b}}, // \xe9\x9f\x88
{0x97cb,{0x28,0x3a,0x2e,0x2b,0x7a,0x2e,0x28}}, // \xe9\x9f\x8b
{0x97d3,{0x2d,0x77,0x2d,0x3a,0x2f,0x7a,0x2e}}, // \xe9\x9f\x93
{0x97dc,{0x2a,0x77,0x2e,0x79,0x43,0x69,0x7a}}, // \xe9\x9f\x9c
{0x97ed,{0x54,0x54,0x7f,0x40,0x7f,0x54,0x54}}, // \xe9\x9f\xad
{0x97ee,{0x42,0x56,0x7f,0x42,0x7f,0x56,0x42}}, // \xe9\x9f\xae
{0x97f2,{0x4a,0x56,0x7e,0x4b,0x7e,0x56,0x4a}}, // \xe9\x9f\xb2
{0x97f3,{0x08,0x7a,0x5e,0x5b,0x5e,0x7a,0x08}}, // \xe9\x9f\xb3
{0x97f5,{0x0a,0x6e,0x6b,0x0e,0x2b,0x52,0x7e}}, // \xe9\x9f\xb5
{0x97f6,{0x0a,0x6e,0x6b,0x0e,0x75,0x53,0x77}}, // \xe9\x9f\xb6
{0x97fb,{0x0a,0x6e,0x6b,0x5e,0x17,0x17,0x5c}}, // \xe9\x9f\xbb
{0x97ff,{0x2a,0x25,0x7f,0x6b,0x78,0x2f,0x27}}, // \xe9\x9f\xbf
{0x9801,{0x41,0x7d,0x2d,0x2f,0x2d,0x7d,0x41}}, // \xe9\xa0\x81
{0x9802,{0x21,0x3f,0x01,0x5d,0x17,0x15,0x5d}}, // \xe9\xa0\x82
{0x9803,{0x3f,0x24,0x32,0x5d,0x17,0x15,0x5d}}, // \xe9\xa0\x83
{0x9805,{0x22,0x3e,0x12,0x5d,0x17,0x15,0x5d}}, // \xe9\xa0\x85
{0x9806,{0x40,0x3f,0x1e,0x7f,0x5d,0x17,0x5d}}, // \xe9\xa0\x86
{0x9808,{0x4a,0x25,0x00,0x5d,0x17,0x15,0x5d}}, // \xe9\xa0\x88
{0x980c,{0x44,0x63,0x58,0x23,0x5d,0x17,0x5d}}, // \xe9\xa0\x8c
{0x980f,{0x42,0x3a,0x0b,0x7a,0x5d,0x17,0x5d}}, // \xe9\xa0\x8f
{0x9810,{0x49,0x7d,0x1b,0x40,0x1d,0x17,0x5d}}, // \xe9\xa0\x90
{0x9811,{0x24,0x1d,0x3d,0x24,0x5d,0x17,0x5d}}, // \xe9\xa0\x91
{0x9812,{0x44,0x3b,0x48,0x7b,0x5d,0x17,0x5d}}, // \xe9\xa0\x92
{0x9813,{0x1a,0x12,0x7f,0x52,0x5d,0x17,0x5d}}, // \xe9\xa0\x93
{0x9817,{0x7e,0x5a,0x2f,0x5a,0x5d,0x17,0x5d}}, // \xe9\xa0\x97
{0x9818,{0x16,0x75,0x36,0x41,0x1d,0x17,0x5d}}, // \xe9\xa0\x98
{0x981a,{0x49,0x5b,0x35,0x2b,0x5d,0x17,0x5d}}, // \xe9\xa0\x9a
{0x9821,{0x02,0x6a,0x6f,0x0a,0x5d,0x17,0x5d}}, // \xe9\xa0\xa1
{0x9824,{0x7f,0x5d,0x77,0x5d,0x41,0x1f,0x5d}}, // \xe9\xa0\xa4
{0x982c,{0x5a,0x52,0x3f,0x5a,0x5d,0x17,0x5d}}, // \xe9\xa0\xac
{0x982d,{0x2d,0x35,0x2d,0x40,0x1d,0x17,0x5d}}, // \xe9\xa0\xad
{0x9834,{0x57,0x1a,0x7a,0x10,0x5d,0x17,0x5d}}, // \xe9\xa0\xb4
{0x9837,{0x04,0x76,0x5d,0x72,0x5d,0x17,0x5d}}, // \xe9\xa0\xb7
{0x9838,{0x55,0x5b,0x75,0x5b,0x5d,0x17,0x5d}}, // \xe9\xa0\xb8
{0x983b,{0x5e,0x48,0x3f,0x1a,0x5d,0x17,0x5d}}, // \xe9\xa0\xbb
{0x983c,{0x42,0x2e,0x7f,0x2e,0x5d,0x17,0x5d}}, // \xe9\xa0\xbc
{0x983d,{0x4a,0x37,0x1f,0x76,0x5d,0x17,0x5d}}, // \xe9\xa0\xbd
{0x9846,{0x57,0x35,0x7f,0x37,0x5d,0x17,0x5d}}, // \xe9\xa1\x86
{0x984b,{0x6f,0x2d,0x4f,0x6f,0x5d,0x17,0x5d}}, // \xe9\xa1\x8b
{0x984c,{0x44,0x37,0x3f,0x54,0x6d,0x4f,0x6d}}, // \xe9\xa1\x8c
{0x984d,{0x26,0x6a,0x57,0x6e,0x5d,0x17,0x5d}}, // \xe9\xa1\x8d
{0x984e,{0x0b,0x5f,0x6c,0x0b,0x5d,0x17,0x5d}}, // \xe9\xa1\x8e
{0x984f,{0x7a,0x0e,0x5f,0x2a,0x5d,0x17,0x5d}}, // \xe9\xa1\x8f
{0x9854,{0x7a,0x0e,0x5b,0x2e,0x5d,0x17,0x5d}}, // \xe9\xa1\x94
{0x9855,{0x4b,0x7d,0x3d,0x2b,0x5d,0x17,0x5d}}, // \xe9\xa1\x95
{0x9858,{0x7f,0x2d,0x7f,0x2d,0x5d,0x17,0x5d}}, // \xe9\xa1\x98
{0x985b,{0x52,0x1e,0x1f,0x52,0x1d,0x17,0x5d}}, // \xe9\xa1\x9b
{0x985e,{0x55,0x52,0x3f,0x52,0x5d,0x17,0x5d}}, // \xe9\xa1\x9e
{0x9867,{0x11,0x7f,0x7d,0x57,0x41,0x1f,0x5d}}, // \xe9\xa1\xa7
{0x986b,{0x4e,0x7e,0x7b,0x2e,0x5d,0x17,0x5d}}, // \xe9\xa1\xab
{0x986f,{0x6b,0x37,0x6b,0x37,0x5d,0x17,0x5d}}, // \xe9\xa1\xaf
{0x9870,{0x26,0x2c,0x3f,0x76,0x39,0x23,0x2b}}, // \xe9\xa1\xb0
{0x9871,{0x7c,0x44,0x6f,0x6a,0x5d,0x17,0x5d}}, // \xe9\xa1\xb1
{0x9873,{0x35,0x77,0x3f,0x75,0x5d,0x17,0x5d}}, // \xe9\xa1\xb3
{0x9874,{0x26,0x7f,0x52,0x7f,0x5d,0x17,0x5d}}, // \xe9\xa1\xb4
{0x98a8,{0x40,0x3f,0x4d,0x7f,0x2d,0x7f,0x40}}, // \xe9\xa2\xa8
{0x98aa,{0x41,0x3d,0x55,0x77,0x6f,0x3d,0x41}}, // \xe9\xa2\xaa
{0x98af,{0x2e,0x33,0x7f,0x4d,0x7f,0x2d,0x7f}}, // \xe9\xa2\xaf
{0x98b1,{0x7f,0x4d,0x3f,0x7f,0x46,0x5d,0x5c}}, // \xe9\xa2\xb1
{0x98b6,{0x7f,0x4d,0x3f,0x7f,0x54,0x47,0x57}}, // \xe9\xa2\xb6
{0x98c3,{0x7f,0x4d,0x3f,0x7f,0x51,0x77,0x57}}, // \xe9\xa3\x83
{0x98c4,{0x51,0x17,0x77,0x3f,0x4d,0x3f,0x7f}}, // \xe9\xa3\x84
{0x98c6,{0x5a,0x37,0x7a,0x3f,0x4d,0x3f,0x7f}}, // \xe9\xa3\x86
{0x98db,{0x55,0x3f,0x09,0x7f,0x09,0x3b,0x54}}, // \xe9\xa3\x9b
{0x98dc,{0x15,0x6f,0x7f,0x35,0x7f,0x3b,0x54}}, // \xe9\xa3\x9c
{0x98df,{0x04,0x44,0x7a,0x5d,0x22,0x54,0x44}}, // \xe9\xa3\x9f
{0x98e2,{0x7a,0x5d,0x42,0x3f,0x01,0x7f,0x40}}, // \xe9\xa3\xa2
{0x98e9,{0x7e,0x2d,0x2e,0x12,0x7f,0x52,0x5a}}, // \xe9\xa3\xa9
{0x98eb,{0x7e,0x2d,0x4a,0x4a,0x3e,0x49,0x48}}, // \xe9\xa3\xab
{0x98ed,{0x7e,0x2d,0x2e,0x54,0x3b,0x52,0x72}}, // \xe9\xa3\xad
{0x98ee,{0x7e,0x2d,0x2e,0x44,0x43,0x3e,0x46}}, // \xe9\xa3\xae
{0x98ef,{0x7a,0x5d,0x42,0x3f,0x5d,0x25,0x5d}}, // \xe9\xa3\xaf
{0x98f2,{0x7a,0x5d,0x5a,0x04,0x43,0x3e,0x46}}, // \xe9\xa3\xb2
{0x98f4,{0x7a,0x5d,0x5a,0x08,0x6c,0x6b,0x6c}}, // \xe9\xa3\xb4
{0x98fc,{0x7a,0x5d,0x42,0x35,0x35,0x41,0x7f}}, // \xe9\xa3\xbc
{0x98fd,{0x7a,0x5d,0x5a,0x04,0x73,0x56,0x5e}}, // \xe9\xa3\xbd
{0x98fe,{0x7a,0x5d,0x42,0x34,0x13,0x7e,0x32}}, // \xe9\xa3\xbe
{0x9903,{0x7e,0x2d,0x4a,0x56,0x23,0x56,0x4a}}, // \xe9\xa4\x83
{0x9905,{0x7a,0x5d,0x56,0x3d,0x14,0x7d,0x14}}, // \xe9\xa4\x85
{0x9909,{0x7e,0x2d,0x02,0x7e,0x3b,0x2a,0x7e}}, // \xe9\xa4\x89
{0x990a,{0x2a,0x1a,0x7b,0x7e,0x5a,0x2b,0x5a}}, // \xe9\xa4\x8a
{0x990c,{0x7a,0x5d,0x5a,0x21,0x3f,0x2d,0x7f}}, // \xe9\xa4\x8c
{0x9910,{0x14,0x54,0x7b,0x5e,0x2b,0x55,0x5b}}, // \xe9\xa4\x90
{0x9912,{0x7e,0x2d,0x52,0x71,0x5b,0x31,0x52}}, // \xe9\xa4\x92
{0x9913,{0x7a,0x59,0x26,0x7e,0x25,0x3f,0x55}}, // \xe9\xa4\x93
{0x9914,{0x7e,0x2d,0x2e,0x7a,0x7f,0x2a,0x7b}}, // \xe9\xa4\x94
{0x9918,{0x7e,0x2d,0x2e,0x54,0x16,0x7d,0x56}}, // \xe9\xa4\x98
{0x991d,{0x7e,0x2d,0x4a,0x3b,0x2e,0x2b,0x6a}}, // \xe9\xa4\x9d
{0x991e,{0x7e,0x2d,0x2e,0x52,0x5b,0x36,0x5b}}, // \xe9\xa4\x9e
{0x9920,{0x7e,0x2d,0x56,0x3d,0x16,0x7d,0x14}}, // \xe9\xa4\xa0
{0x9921,{0x7e,0x2d,0x2e,0x7a,0x41,0x6d,0x7b}}, // \xe9\xa4\xa1
{0x9924,{0x7e,0x2d,0x2e,0x55,0x44,0x3b,0x55}}, // \xe9\xa4\xa4
{0x9928,{0x7a,0x5d,0x5a,0x06,0x7a,0x5b,0x76}}, // \xe9\xa4\xa8
{0x992c,{0x7e,0x2d,0x3a,0x2f,0x7a,0x3f,0x7f}}, // \xe9\xa4\xac
{0x992e,{0x15,0x57,0x7b,0x5d,0x2a,0x55,0x52}}, // \xe9\xa4\xae
{0x993d,{0x7e,0x2d,0x5e,0x2a,0x7f,0x6a,0x5e}}, // \xe9\xa4\xbd
{0x993e,{0x7e,0x2d,0x0e,0x7a,0x79,0x77,0x0f}}, // \xe9\xa4\xbe
{0x9942,{0x7e,0x2d,0x2e,0x4f,0x6d,0x6b,0x4f}}, // \xe9\xa5\x82
{0x9945,{0x7e,0x2d,0x4e,0x5f,0x2d,0x5f,0x4c}}, // \xe9\xa5\x85
{0x9949,{0x7e,0x2d,0x5a,0x5f,0x7a,0x5f,0x5a}}, // \xe9\xa5\x89
{0x994b,{0x7e,0x2d,0x4e,0x3a,0x3f,0x3a,0x4e}}, // \xe9\xa5\x8b
{0x994c,{0x7e,0x2d,0x4f,0x1b,0x10,0x1f,0x4b}}, // \xe9\xa5\x8c
{0x9950,{0x7e,0x2d,0x2e,0x5a,0x6a,0x6f,0x5a}}, // \xe9\xa5\x90
{0x9951,{0x7e,0x2d,0x4a,0x3d,0x48,0x3a,0x55}}, // \xe9\xa5\x91
{0x9952,{0x7e,0x2d,0x5e,0x3e,0x17,0x7e,0x5c}}, // \xe9\xa5\x92
{0x9955,{0x14,0x57,0x7f,0x58,0x2e,0x5f,0x55}}, // \xe9\xa5\x95
{0x9957,{0x1a,0x55,0x7f,0x7b,0x28,0x57,0x53}}, // \xe9\xa5\x97
{0x9996,{0x02,0x7a,0x5b,0x5e,0x5a,0x7b,0x02}}, // \xe9\xa6\x96
{0x9997,{0x42,0x3f,0x7e,0x42,0x7b,0x56,0x7b}}, // \xe9\xa6\x97
{0x9998,{0x7b,0x56,0x7b,0x5a,0x42,0x3f,0x52}}, // \xe9\xa6\x98
{0x9999,{0x14,0x76,0x6e,0x7e,0x6d,0x75,0x14}}, // \xe9\xa6\x99
{0x99a5,{0x14,0x6d,0x7f,0x6d,0x57,0x2e,0x5a}}, // \xe9\xa6\xa5
{0x99a8,{0x2a,0x26,0x77,0x5a,0x7b,0x25,0x2b}}, // \xe9\xa6\xa8
{0x99ac,{0x40,0x1f,0x55,0x1f,0x55,0x15,0x71}}, // \xe9\xa6\xac
{0x99ad,{0x5f,0x1f,0x75,0x40,0x4d,0x31,0x4f}}, // \xe9\xa6\xad
{0x99ae,{0x71,0x00,0x5f,0x15,0x5f,0x15,0x71}}, // \xe9\xa6\xae
{0x99b3,{0x5f,0x1f,0x75,0x7e,0x44,0x5f,0x6c}}, // \xe9\xa6\xb3
{0x99b4,{0x5f,0x1f,0x75,0x3f,0x1e,0x00,0x7f}}, // \xe9\xa6\xb4
{0x99bc,{0x5f,0x1f,0x75,0x42,0x4e,0x33,0x4e}}, // \xe9\xa6\xbc
{0x99c1,{0x5f,0x1f,0x75,0x40,0x55,0x22,0x55}}, // \xe9\xa7\x81
{0x99c4,{0x5f,0x1f,0x75,0x40,0x24,0x5f,0x64}}, // \xe9\xa7\x84
{0x99c5,{0x5f,0x1f,0x75,0x40,0x3f,0x19,0x67}}, // \xe9\xa7\x85
{0x99c6,{0x5f,0x1f,0x75,0x00,0x7f,0x49,0x55}}, // \xe9\xa7\x86
{0x99c8,{0x5f,0x1f,0x75,0x7e,0x4a,0x79,0x48}}, // \xe9\xa7\x88
{0x99d0,{0x5f,0x1f,0x75,0x00,0x55,0x7e,0x54}}, // \xe9\xa7\x90
{0x99d1,{0x52,0x0e,0x5b,0x16,0x5b,0x15,0x7b}}, // \xe9\xa7\x91
{0x99d2,{0x5f,0x1f,0x75,0x04,0x1b,0x5a,0x7e}}, // \xe9\xa7\x92
{0x99d5,{0x4a,0x07,0x5a,0x16,0x5e,0x1a,0x7e}}, // \xe9\xa7\x95
{0x99d8,{0x5f,0x1f,0x75,0x08,0x6c,0x6b,0x6c}}, // \xe9\xa7\x98
{0x99db,{0x5f,0x1f,0x75,0x4e,0x5a,0x3f,0x4e}}, // \xe9\xa7\x9b
{0x99dd,{0x5f,0x1f,0x75,0x06,0x7a,0x53,0x56}}, // \xe9\xa7\x9d
{0x99df,{0x5f,0x1f,0x75,0x7f,0x51,0x4f,0x7f}}, // \xe9\xa7\x9f
{0x99e2,{0x5f,0x1f,0x75,0x54,0x3d,0x14,0x7d}}, // \xe9\xa7\xa2
{0x99ed,{0x5f,0x1f,0x75,0x4a,0x56,0x2b,0x52}}, // \xe9\xa7\xad
{0x99ee,{0x5f,0x1f,0x75,0x4a,0x56,0x23,0x56}}, // \xe9\xa7\xae
{0x99f1,{0x5f,0x1f,0x75,0x10,0x6a,0x65,0x6b}}, // \xe9\xa7\xb1
{0x99f2,{0x5f,0x1f,0x75,0x4c,0x3f,0x0c,0x7f}}, // \xe9\xa7\xb2
{0x99f8,{0x5f,0x1f,0x75,0x58,0x5d,0x2f,0x5a}}, // \xe9\xa7\xb8
{0x99fb,{0x5f,0x1f,0x75,0x28,0x2f,0x7d,0x2f}}, // \xe9\xa7\xbb
{0x99ff,{0x5f,0x1f,0x75,0x2a,0x57,0x32,0x4f}}, // \xe9\xa7\xbf
{0x9a01,{0x5f,0x1f,0x75,0x08,0x1e,0x5f,0x6e}}, // \xe9\xa8\x81
{0x9a05,{0x5f,0x1f,0x75,0x7f,0x4a,0x7f,0x4a}}, // \xe9\xa8\x85
{0x9a0e,{0x5f,0x1f,0x75,0x12,0x5a,0x17,0x7a}}, // \xe9\xa8\x8e
{0x9a0f,{0x5f,0x1f,0x75,0x52,0x1f,0x1a,0x5f}}, // \xe9\xa8\x8f
{0x9a12,{0x5f,0x1f,0x75,0x49,0x5b,0x7d,0x5b}}, // \xe9\xa8\x92
{0x9a13,{0x5f,0x1f,0x7d,0x56,0x3d,0x56,0x5c}}, // \xe9\xa8\x93
{0x9a19,{0x5f,0x1f,0x75,0x21,0x7f,0x35,0x77}}, // \xe9\xa8\x99
{0x9a28,{0x5f,0x1f,0x75,0x2c,0x2d,0x7e,0x2d}}, // \xe9\xa8\xa8
{0x9a2b,{0x56,0x0a,0x5e,0x1b,0x5e,0x1a,0x76}}, // \xe9\xa8\xab
{0x9a30,{0x7f,0x15,0x7f,0x45,0x1c,0x5f,0x75}}, // \xe9\xa8\xb0
{0x9a37,{0x5f,0x1f,0x75,0x48,0x7b,0x75,0x5b}}, // \xe9\xa8\xb7
{0x9a3e,{0x5f,0x1f,0x77,0x1d,0x77,0x15,0x57}}, // \xe9\xa8\xbe
{0x9a40,{0x4a,0x06,0x5f,0x16,0x5f,0x16,0x7a}}, // \xe9\xa9\x80
{0x9a42,{0x5f,0x1f,0x7a,0x4f,0x5a,0x2d,0x1a}}, // \xe9\xa9\x82
{0x9a43,{0x5f,0x1f,0x75,0x11,0x77,0x17,0x51}}, // \xe9\xa9\x83
{0x9a45,{0x5f,0x1f,0x75,0x7f,0x47,0x77,0x71}}, // \xe9\xa9\x85
{0x9a4d,{0x5f,0x1f,0x75,0x5c,0x3e,0x77,0x5e}}, // \xe9\xa9\x8d
{0x9a55,{0x5f,0x1f,0x7a,0x17,0x5b,0x17,0x7a}}, // \xe9\xa9\x95
{0x9a57,{0x5f,0x1f,0x7d,0x36,0x5d,0x36,0x5c}}, // \xe9\xa9\x97
{0x9a5a,{0x4a,0x07,0x5e,0x1f,0x5a,0x15,0x7b}}, // \xe9\xa9\x9a
{0x9a5b,{0x5f,0x1f,0x75,0x2b,0x3b,0x6f,0x3b}}, // \xe9\xa9\x9b
{0x9a5f,{0x5f,0x1f,0x75,0x2b,0x7f,0x25,0x4b}}, // \xe9\xa9\x9f
{0x9a62,{0x5f,0x1f,0x75,0x5c,0x64,0x6f,0x4a}}, // \xe9\xa9\xa2
{0x9a64,{0x5f,0x1f,0x77,0x7e,0x5b,0x3e,0x56}}, // \xe9\xa9\xa4
{0x9a65,{0x5f,0x1f,0x75,0x5a,0x3f,0x3f,0x5a}}, // \xe9\xa9\xa5
{0x9a69,{0x5f,0x1f,0x77,0x7f,0x52,0x7f,0x56}}, // \xe9\xa9\xa9
{0x9a6a,{0x5f,0x1f,0x7f,0x55,0x1e,0x7d,0x57}}, // \xe9\xa9\xaa
{0x9a6b,{0x48,0x77,0x3d,0x77,0x7d,0x35,0x6c}}, // \xe9\xa9\xab
{0x9aa8,{0x0c,0x7f,0x15,0x15,0x57,0x7f,0x0c}}, // \xe9\xaa\xa8
{0x9aad,{0x0c,0x77,0x35,0x7f,0x09,0x7f,0x09}}, // \xe9\xaa\xad
{0x9ab0,{0x0c,0x77,0x35,0x7f,0x5b,0x29,0x5b}}, // \xe9\xaa\xb0
{0x9ab8,{0x0c,0x77,0x35,0x7f,0x56,0x2b,0x52}}, // \xe9\xaa\xb8
{0x9abc,{0x0c,0x77,0x35,0x7f,0x0a,0x65,0x6b}}, // \xe9\xaa\xbc
{0x9ac0,{0x0c,0x77,0x7f,0x2e,0x3f,0x7a,0x2e}}, // \xe9\xab\x80
{0x9ac4,{0x0c,0x77,0x3f,0x79,0x4a,0x77,0x72}}, // \xe9\xab\x84
{0x9acf,{0x0c,0x77,0x7f,0x7e,0x5b,0x3e,0x54}}, // \xe9\xab\x8f
{0x9ad1,{0x0c,0x77,0x7f,0x4b,0x75,0x37,0x7f}}, // \xe9\xab\x91
{0x9ad3,{0x0c,0x77,0x7f,0x65,0x4a,0x7f,0x7a}}, // \xe9\xab\x93
{0x9ad4,{0x0c,0x77,0x7f,0x5e,0x6f,0x6e,0x5f}}, // \xe9\xab\x94
{0x9ad8,{0x72,0x12,0x7e,0x5b,0x7e,0x12,0x72}}, // \xe9\xab\x98
{0x9ade,{0x72,0x3f,0x7e,0x37,0x7d,0x37,0x5c}}, // \xe9\xab\x9e
{0x9adf,{0x50,0x7f,0x55,0x35,0x50,0x4a,0x25}}, // \xe9\xab\x9f
{0x9ae2,{0x24,0x2f,0x7d,0x5d,0x70,0x7a,0x55}}, // \xe9\xab\xa2
{0x9ae3,{0x14,0x5f,0x5d,0x3d,0x30,0x7a,0x15}}, // \xe9\xab\xa3
{0x9ae6,{0x24,0x2f,0x3d,0x7d,0x50,0x5a,0x55}}, // \xe9\xab\xa6
{0x9aea,{0x44,0x4f,0x2d,0x5d,0x38,0x5a,0x4d}}, // \xe9\xab\xaa
{0x9aeb,{0x24,0x2f,0x1d,0x6d,0x68,0x6a,0x1d}}, // \xe9\xab\xab
{0x9aed,{0x64,0x4f,0x7d,0x55,0x00,0x7a,0x55}}, // \xe9\xab\xad
{0x9aee,{0x44,0x4f,0x2d,0x5d,0x28,0x5a,0x4d}}, // \xe9\xab\xae
{0x9aef,{0x24,0x7f,0x2d,0x3d,0x28,0x7a,0x25}}, // \xe9\xab\xaf
{0x9af1,{0x14,0x17,0x6d,0x6d,0x68,0x4a,0x5d}}, // \xe9\xab\xb1
{0x9af4,{0x44,0x5f,0x3d,0x2d,0x7c,0x2a,0x65}}, // \xe9\xab\xb4
{0x9af7,{0x74,0x57,0x7d,0x55,0x70,0x5a,0x75}}, // \xe9\xab\xb7
{0x9afb,{0x04,0x6f,0x6d,0x7d,0x68,0x6a,0x05}}, // \xe9\xab\xbb
{0x9b06,{0x54,0x3f,0x7d,0x3d,0x68,0x52,0x69}}, // \xe9\xac\x86
{0x9b18,{0x44,0x5f,0x5d,0x2d,0x5c,0x5a,0x45}}, // \xe9\xac\x98
{0x9b1a,{0x54,0x2f,0x05,0x4d,0x38,0x3a,0x4d}}, // \xe9\xac\x9a
{0x9b1f,{0x54,0x37,0x7d,0x5d,0x38,0x5a,0x55}}, // \xe9\xac\x9f
{0x9b22,{0x4c,0x57,0x3d,0x3d,0x3c,0x76,0x4d}}, // \xe9\xac\xa2
{0x9b23,{0x44,0x7f,0x5d,0x3d,0x58,0x3a,0x45}}, // \xe9\xac\xa3
{0x9b25,{0x7f,0x07,0x05,0x00,0x05,0x47,0x7f}}, // \xe9\xac\xa5
{0x9b27,{0x7f,0x0b,0x39,0x7c,0x19,0x3b,0x7f}}, // \xe9\xac\xa7
{0x9b28,{0x7f,0x6b,0x3d,0x28,0x3d,0x6b,0x7f}}, // \xe9\xac\xa8
{0x9b29,{0x7f,0x03,0x59,0x34,0x71,0x5b,0x7f}}, // \xe9\xac\xa9
{0x9b2a,{0x7f,0x5b,0x69,0x58,0x11,0x7b,0x7f}}, // \xe9\xac\xaa
{0x9b2e,{0x7f,0x0b,0x39,0x74,0x7d,0x43,0x7f}}, // \xe9\xac\xae
{0x9b2f,{0x0f,0x3d,0x5a,0x5d,0x5a,0x4d,0x6f}}, // \xe9\xac\xaf
{0x9b31,{0x1a,0x7f,0x5e,0x5d,0x0e,0x57,0x2a}}, // \xe9\xac\xb1
{0x9b32,{0x79,0x2f,0x1d,0x6d,0x3d,0x2f,0x79}}, // \xe9\xac\xb2
{0x9b3b,{0x6d,0x3f,0x2a,0x6f,0x2a,0x3d,0x6f}}, // \xe9\xac\xbb
{0x9b3c,{0x40,0x5e,0x3a,0x1f,0x7a,0x6e,0x50}}, // \xe9\xac\xbc
{0x9b41,{0x4e,0x3f,0x7e,0x55,0x50,0x7f,0x48}}, // \xe9\xad\x81
{0x9b42,{0x35,0x2d,0x35,0x5e,0x3f,0x7a,0x5e}}, // \xe9\xad\x82
{0x9b43,{0x4e,0x3f,0x7e,0x52,0x6f,0x52,0x6b}}, // \xe9\xad\x83
{0x9b44,{0x3e,0x2b,0x3e,0x5e,0x3f,0x7a,0x5e}}, // \xe9\xad\x84
{0x9b45,{0x4e,0x3f,0x6e,0x5a,0x7f,0x5a,0x68}}, // \xe9\xad\x85
{0x9b4d,{0x4e,0x3f,0x7e,0x7f,0x5b,0x55,0x7f}}, // \xe9\xad\x8d
{0x9b4e,{0x4e,0x3f,0x7e,0x7d,0x65,0x5f,0x7d}}, // \xe9\xad\x8e
{0x9b4f,{0x5a,0x77,0x3f,0x56,0x3f,0x7a,0x5e}}, // \xe9\xad\x8f
{0x9b51,{0x4e,0x3f,0x7e,0x72,0x5e,0x7f,0x72}}, // \xe9\xad\x91
{0x9b54,{0x40,0x3e,0x4a,0x3e,0x3b,0x7e,0x4a}}, // \xe9\xad\x94
{0x9b58,{0x50,0x4f,0x3f,0x2d,0x7b,0x77,0x4b}}, // \xe9\xad\x98
{0x9b5a,{0x42,0x1e,0x55,0x1d,0x57,0x1c,0x40}}, // \xe9\xad\x9a
{0x9b6f,{0x12,0x6e,0x7d,0x6d,0x7f,0x6c,0x10}}, // \xe9\xad\xaf
{0x9b74,{0x42,0x1d,0x5f,0x42,0x3e,0x4b,0x7a}}, // \xe9\xad\xb4
{0x9b83,{0x42,0x1d,0x5f,0x15,0x13,0x7f,0x15}}, // \xe9\xae\x83
{0x9b8e,{0x42,0x1d,0x5f,0x70,0x5f,0x54,0x74}}, // \xe9\xae\x8e
{0x9b91,{0x42,0x1d,0x5f,0x04,0x7b,0x5a,0x5e}}, // \xe9\xae\x91
{0x9b92,{0x42,0x1d,0x5f,0x7e,0x09,0x42,0x7f}}, // \xe9\xae\x92
{0x9b93,{0x42,0x1d,0x5f,0x04,0x7f,0x2a,0x2a}}, // \xe9\xae\x93
{0x9b96,{0x42,0x1d,0x5f,0x11,0x7f,0x49,0x79}}, // \xe9\xae\x96
{0x9b97,{0x42,0x1d,0x5f,0x08,0x0a,0x55,0x4b}}, // \xe9\xae\x97
{0x9b9f,{0x42,0x1d,0x5f,0x5a,0x2f,0x3a,0x4e}}, // \xe9\xae\x9f
{0x9ba0,{0x42,0x1d,0x5f,0x3e,0x7d,0x4f,0x5c}}, // \xe9\xae\xa0
{0x9ba8,{0x42,0x1d,0x5f,0x00,0x6f,0x6a,0x6d}}, // \xe9\xae\xa8
{0x9baa,{0x42,0x1d,0x5f,0x12,0x7f,0x2a,0x7a}}, // \xe9\xae\xaa
{0x9bab,{0x42,0x1d,0x5f,0x4a,0x56,0x23,0x56}}, // \xe9\xae\xab
{0x9bad,{0x42,0x1d,0x5f,0x08,0x5a,0x7f,0x5a}}, // \xe9\xae\xad
{0x9bae,{0x42,0x1d,0x5f,0x22,0x2b,0x7e,0x2b}}, // \xe9\xae\xae
{0x9bb4,{0x42,0x1d,0x5f,0x7f,0x1a,0x7f,0x1a}}, // \xe9\xae\xb4
{0x9bb9,{0x5d,0x1f,0x42,0x7d,0x2a,0x7d,0x02}}, // \xe9\xae\xb9
{0x9bc0,{0x42,0x1d,0x5f,0x15,0x7b,0x11,0x59}}, // \xe9\xaf\x80
{0x9bc6,{0x42,0x1d,0x5f,0x7a,0x7f,0x2a,0x7b}}, // \xe9\xaf\x86
{0x9bc9,{0x42,0x1d,0x5f,0x55,0x7f,0x55,0x5f}}, // \xe9\xaf\x89
{0x9bca,{0x55,0x30,0x7a,0x38,0x77,0x34,0x42}}, // \xe9\xaf\x8a
{0x9bcf,{0x42,0x1d,0x5f,0x35,0x7f,0x0e,0x7f}}, // \xe9\xaf\x8f
{0x9bd1,{0x42,0x1d,0x5f,0x2d,0x7a,0x2d,0x68}}, // \xe9\xaf\x91
{0x9bd2,{0x42,0x1d,0x5f,0x7c,0x15,0x7f,0x7d}}, // \xe9\xaf\x92
{0x9bd4,{0x42,0x1d,0x5f,0x7a,0x5d,0x7a,0x7d}}, // \xe9\xaf\x94
{0x9bd6,{0x42,0x1d,0x5f,0x08,0x7a,0x2f,0x7a}}, // \xe9\xaf\x96
{0x9bdb,{0x5d,0x1f,0x7f,0x35,0x2f,0x35,0x7f}}, // \xe9\xaf\x9b
{0x9be1,{0x5d,0x1f,0x6a,0x3f,0x00,0x7f,0x2a}}, // \xe9\xaf\xa1
{0x9be2,{0x42,0x1d,0x5f,0x5e,0x35,0x72,0x5e}}, // \xe9\xaf\xa2
{0x9be3,{0x42,0x1d,0x5f,0x27,0x5d,0x35,0x77}}, // \xe9\xaf\xa3
{0x9be4,{0x42,0x1d,0x7f,0x55,0x05,0x7d,0x57}}, // \xe9\xaf\xa4
{0x9be8,{0x42,0x1d,0x5f,0x22,0x4e,0x7b,0x2e}}, // \xe9\xaf\xa8
{0x9bf0,{0x42,0x1d,0x5f,0x2a,0x4d,0x5e,0x64}}, // \xe9\xaf\xb0
{0x9bf1,{0x42,0x1d,0x5f,0x7c,0x24,0x6f,0x4a}}, // \xe9\xaf\xb1
{0x9bf2,{0x5d,0x1f,0x62,0x1f,0x7a,0x29,0x52}}, // \xe9\xaf\xb2
{0x9bf5,{0x42,0x1d,0x5f,0x14,0x4e,0x55,0x2a}}, // \xe9\xaf\xb5
{0x9c04,{0x42,0x1d,0x7f,0x2e,0x56,0x3f,0x52}}, // \xe9\xb0\x84
{0x9c06,{0x42,0x1d,0x5f,0x1a,0x6f,0x7e,0x2a}}, // \xe9\xb0\x86
{0x9c08,{0x42,0x1d,0x5f,0x32,0x77,0x36,0x57}}, // \xe9\xb0\x88
{0x9c09,{0x42,0x1d,0x5f,0x10,0x5e,0x7b,0x5e}}, // \xe9\xb0\x89
{0x9c0a,{0x42,0x1d,0x5f,0x2e,0x7f,0x2e,0x4e}}, // \xe9\xb0\x8a
{0x9c0c,{0x42,0x1d,0x5f,0x76,0x7d,0x7d,0x76}}, // \xe9\xb0\x8c
{0x9c0d,{0x5d,0x1f,0x35,0x7f,0x4c,0x3f,0x44}}, // \xe9\xb0\x8d
{0x9c10,{0x42,0x1d,0x5f,0x0b,0x1f,0x5c,0x6b}}, // \xe9\xb0\x90
{0x9c12,{0x42,0x1d,0x5f,0x53,0x2e,0x5e,0x42}}, // \xe9\xb0\x92
{0x9c13,{0x42,0x1d,0x5f,0x2d,0x4f,0x4d,0x6f}}, // \xe9\xb0\x93
{0x9c14,{0x42,0x1d,0x7f,0x6a,0x6a,0x3f,0x52}}, // \xe9\xb0\x94
{0x9c15,{0x42,0x1d,0x7f,0x2b,0x58,0x2d,0x5f}}, // \xe9\xb0\x95
{0x9c1b,{0x42,0x1d,0x5f,0x47,0x75,0x75,0x47}}, // \xe9\xb0\x9b
{0x9c21,{0x42,0x1d,0x5f,0x0e,0x69,0x66,0x0e}}, // \xe9\xb0\xa1
{0x9c24,{0x42,0x1d,0x7f,0x36,0x1d,0x7f,0x1d}}, // \xe9\xb0\xa4
{0x9c25,{0x42,0x1d,0x5f,0x2b,0x77,0x2b,0x53}}, // \xe9\xb0\xa5
{0x9c2d,{0x42,0x1d,0x5f,0x0a,0x67,0x7e,0x75}}, // \xe9\xb0\xad
{0x9c2e,{0x42,0x1d,0x5f,0x4f,0x6d,0x6b,0x4f}}, // \xe9\xb0\xae
{0x9c2f,{0x5d,0x1f,0x5d,0x77,0x20,0x5d,0x77}}, // \xe9\xb0\xaf
{0x9c30,{0x5d,0x1f,0x35,0x7d,0x3e,0x6b,0x3e}}, // \xe9\xb0\xb0
{0x9c32,{0x54,0x3e,0x7f,0x34,0x7a,0x35,0x4b}}, // \xe9\xb0\xb2
{0x9c39,{0x5d,0x1f,0x47,0x57,0x7b,0x55,0x4b}}, // \xe9\xb0\xb9
{0x9c3a,{0x5d,0x1f,0x5a,0x4f,0x5a,0x2d,0x1a}}, // \xe9\xb0\xba
{0x9c3b,{0x5d,0x1f,0x4c,0x5f,0x2d,0x5f,0x4c}}, // \xe9\xb0\xbb
{0x9c3e,{0x42,0x1d,0x5f,0x11,0x77,0x17,0x51}}, // \xe9\xb0\xbe
{0x9c46,{0x42,0x1d,0x5f,0x2a,0x3e,0x7b,0x2e}}, // \xe9\xb1\x86
{0x9c47,{0x42,0x1d,0x3f,0x52,0x7f,0x2e,0x56}}, // \xe9\xb1\x87
{0x9c48,{0x42,0x1d,0x5f,0x06,0x53,0x57,0x76}}, // \xe9\xb1\x88
{0x9c52,{0x42,0x1d,0x5f,0x1e,0x37,0x52,0x7f}}, // \xe9\xb1\x92
{0x9c57,{0x5d,0x1f,0x55,0x32,0x27,0x72,0x25}}, // \xe9\xb1\x97
{0x9c5a,{0x5d,0x1f,0x52,0x7e,0x57,0x7e,0x12}}, // \xe9\xb1\x9a
{0x9c60,{0x42,0x1d,0x5f,0x76,0x5d,0x76,0x1c}}, // \xe9\xb1\xa0
{0x9c67,{0x42,0x1d,0x5f,0x5e,0x6f,0x6e,0x5f}}, // \xe9\xb1\xa7
{0x9c76,{0x5d,0x1f,0x2a,0x7b,0x3e,0x5b,0x2a}}, // \xe9\xb1\xb6
{0x9c78,{0x42,0x1d,0x5f,0x5c,0x64,0x6f,0x4a}}, // \xe9\xb1\xb8
{0x9ce5,{0x40,0x1e,0x56,0x17,0x56,0x16,0x70}}, // \xe9\xb3\xa5
{0x9ce7,{0x50,0x4e,0x3e,0x2f,0x3e,0x68,0x58}}, // \xe9\xb3\xa7
{0x9ce9,{0x22,0x1f,0x3e,0x20,0x5e,0x17,0x76}}, // \xe9\xb3\xa9
{0x9ceb,{0x40,0x3f,0x41,0x1d,0x5f,0x1d,0x71}}, // \xe9\xb3\xab
{0x9cec,{0x40,0x46,0x36,0x17,0x76,0x44,0x6c}}, // \xe9\xb3\xac
{0x9cf0,{0x31,0x0f,0x10,0x5e,0x17,0x56,0x70}}, // \xe9\xb3\xb0
{0x9cf3,{0x40,0x3f,0x5d,0x1f,0x71,0x7f,0x40}}, // \xe9\xb3\xb3
{0x9cf4,{0x1e,0x1e,0x40,0x1e,0x57,0x16,0x70}}, // \xe9\xb3\xb4
{0x9cf6,{0x42,0x1a,0x5a,0x1e,0x5b,0x16,0x7b}}, // \xe9\xb3\xb6
{0x9d03,{0x5e,0x17,0x76,0x48,0x4a,0x3f,0x4e}}, // \xe9\xb4\x83
{0x9d06,{0x46,0x3f,0x72,0x46,0x1e,0x57,0x76}}, // \xe9\xb4\x86
{0x9d07,{0x2f,0x7a,0x2a,0x5e,0x17,0x56,0x70}}, // \xe9\xb4\x87
{0x9d08,{0x40,0x3f,0x7d,0x03,0x5d,0x1f,0x71}}, // \xe9\xb4\x88
{0x9d09,{0x2f,0x59,0x7f,0x09,0x5e,0x17,0x76}}, // \xe9\xb4\x89
{0x9d0e,{0x7f,0x55,0x49,0x14,0x5e,0x17,0x76}}, // \xe9\xb4\x8e
{0x9d12,{0x16,0x75,0x36,0x00,0x5e,0x17,0x76}}, // \xe9\xb4\x92
{0x9d15,{0x5e,0x17,0x70,0x06,0x7a,0x53,0x56}}, // \xe9\xb4\x95
{0x9d1b,{0x4a,0x0b,0x5d,0x1b,0x5f,0x19,0x7b}}, // \xe9\xb4\x9b
{0x9d1f,{0x7e,0x4a,0x5e,0x29,0x5e,0x17,0x76}}, // \xe9\xb4\x9f
{0x9d23,{0x3a,0x2f,0x3a,0x40,0x1e,0x57,0x76}}, // \xe9\xb4\xa3
{0x9d26,{0x54,0x0e,0x5e,0x1f,0x56,0x1e,0x74}}, // \xe9\xb4\xa6
{0x9d28,{0x0f,0x7f,0x0f,0x5e,0x17,0x56,0x70}}, // \xe9\xb4\xa8
{0x9d2a,{0x46,0x3a,0x03,0x3a,0x5e,0x17,0x76}}, // \xe9\xb4\xaa
{0x9d2b,{0x3e,0x3e,0x3e,0x40,0x1e,0x57,0x76}}, // \xe9\xb4\xab
{0x9d2c,{0x46,0x03,0x5a,0x1f,0x5a,0x13,0x76}}, // \xe9\xb4\xac
{0x9d3b,{0x75,0x22,0x3e,0x52,0x1e,0x57,0x76}}, // \xe9\xb4\xbb
{0x9d3e,{0x36,0x2d,0x7c,0x2e,0x5e,0x17,0x76}}, // \xe9\xb4\xbe
{0x9d3f,{0x76,0x55,0x76,0x00,0x5e,0x17,0x76}}, // \xe9\xb4\xbf
{0x9d41,{0x4a,0x56,0x23,0x56,0x1e,0x57,0x76}}, // \xe9\xb5\x81
{0x9d44,{0x49,0x5d,0x3b,0x2d,0x5e,0x17,0x76}}, // \xe9\xb5\x84
{0x9d46,{0x0a,0x7d,0x5e,0x17,0x70,0x05,0x7d}}, // \xe9\xb5\x86
{0x9d48,{0x21,0x3f,0x2d,0x7f,0x5e,0x17,0x76}}, // \xe9\xb5\x88
{0x9d50,{0x51,0x4d,0x3f,0x2d,0x5e,0x17,0x76}}, // \xe9\xb5\x90
{0x9d51,{0x78,0x2b,0x2b,0x78,0x5e,0x17,0x76}}, // \xe9\xb5\x91
{0x9d59,{0x5f,0x15,0x5f,0x00,0x5e,0x17,0x76}}, // \xe9\xb5\x99
{0x9d5c,{0x5a,0x2b,0x7e,0x2b,0x5e,0x17,0x76}}, // \xe9\xb5\x9c
{0x9d5d,{0x26,0x7e,0x25,0x7f,0x5e,0x17,0x76}}, // \xe9\xb5\x9d
{0x9d5e,{0x4a,0x0f,0x5f,0x1a,0x5b,0x16,0x7b}}, // \xe9\xb5\x9e
{0x9d60,{0x0c,0x6b,0x6f,0x0a,0x5e,0x17,0x76}}, // \xe9\xb5\xa0
{0x9d61,{0x75,0x65,0x3e,0x45,0x5e,0x17,0x76}}, // \xe9\xb5\xa1
{0x9d64,{0x42,0x3d,0x5f,0x7c,0x5e,0x17,0x76}}, // \xe9\xb5\xa4
{0x9d6c,{0x7f,0x15,0x7f,0x7f,0x5e,0x17,0x76}}, // \xe9\xb5\xac
{0x9d6f,{0x2e,0x3f,0x7a,0x2e,0x5e,0x17,0x76}}, // \xe9\xb5\xaf
{0x9d72,{0x0a,0x6f,0x6a,0x0f,0x5e,0x17,0x76}}, // \xe9\xb5\xb2
{0x9d7a,{0x12,0x7e,0x2b,0x5a,0x1e,0x57,0x76}}, // \xe9\xb5\xba
{0x9d87,{0x42,0x2e,0x7f,0x2a,0x5e,0x17,0x76}}, // \xe9\xb6\x87
{0x9d89,{0x22,0x2e,0x7b,0x1e,0x5e,0x17,0x76}}, // \xe9\xb6\x89
{0x9d8f,{0x55,0x39,0x55,0x00,0x5e,0x17,0x76}}, // \xe9\xb6\x8f
{0x9d9a,{0x0b,0x5f,0x6c,0x0b,0x5e,0x17,0x76}}, // \xe9\xb6\x9a
{0x9da4,{0x27,0x3d,0x7f,0x27,0x5e,0x17,0x76}}, // \xe9\xb6\xa4
{0x9da9,{0x4a,0x07,0x5f,0x1d,0x5a,0x15,0x7b}}, // \xe9\xb6\xa9
{0x9dab,{0x42,0x2e,0x7f,0x2e,0x5e,0x17,0x76}}, // \xe9\xb6\xab
{0x9daf,{0x4d,0x06,0x5d,0x1c,0x5d,0x16,0x7d}}, // \xe9\xb6\xaf
{0x9db2,{0x5a,0x2d,0x58,0x29,0x7a,0x1f,0x76}}, // \xe9\xb6\xb2
{0x9db4,{0x16,0x7a,0x7f,0x4a,0x1e,0x57,0x76}}, // \xe9\xb6\xb4
{0x9db8,{0x5d,0x77,0x5d,0x77,0x5e,0x17,0x76}}, // \xe9\xb6\xb8
{0x9dba,{0x15,0x7d,0x2a,0x7d,0x5e,0x17,0x76}}, // \xe9\xb6\xba
{0x9dbb,{0x0c,0x77,0x35,0x77,0x5e,0x17,0x76}}, // \xe9\xb6\xbb
{0x9dc1,{0x52,0x6d,0x6d,0x52,0x1e,0x57,0x76}}, // \xe9\xb7\x81
{0x9dc2,{0x6a,0x4d,0x7b,0x68,0x5e,0x17,0x76}}, // \xe9\xb7\x82
{0x9dc4,{0x52,0x55,0x3b,0x51,0x1e,0x57,0x76}}, // \xe9\xb7\x84
{0x9dc6,{0x58,0x1f,0x1e,0x52,0x1e,0x57,0x76}}, // \xe9\xb7\x86
{0x9dcf,{0x52,0x1e,0x1f,0x52,0x1e,0x57,0x76}}, // \xe9\xb7\x8f
{0x9dd3,{0x7e,0x4a,0x1f,0x5a,0x5e,0x17,0x76}}, // \xe9\xb7\x93
{0x9dd9,{0x44,0x0e,0x5f,0x1a,0x57,0x1e,0x78}}, // \xe9\xb7\x99
{0x9de6,{0x44,0x1f,0x5e,0x13,0x5e,0x17,0x76}}, // \xe9\xb7\xa6
{0x9ded,{0x15,0x6f,0x7d,0x6f,0x5e,0x17,0x76}}, // \xe9\xb7\xad
{0x9def,{0x4a,0x1e,0x6b,0x1e,0x5e,0x17,0x76}}, // \xe9\xb7\xaf
{0x9df2,{0x52,0x0e,0x5b,0x1e,0x5a,0x17,0x7a}}, // \xe9\xb7\xb2
{0x9df8,{0x7a,0x37,0x5f,0x73,0x5e,0x17,0x76}}, // \xe9\xb7\xb8
{0x9df9,{0x40,0x3e,0x4e,0x12,0x5f,0x1e,0x7a}}, // \xe9\xb7\xb9
{0x9dfa,{0x4b,0x0d,0x5b,0x16,0x5d,0x1f,0x74}}, // \xe9\xb7\xba
{0x9dfd,{0x4c,0x06,0x5d,0x1e,0x5d,0x17,0x7c}}, // \xe9\xb7\xbd
{0x9e1a,{0x57,0x7b,0x54,0x33,0x5f,0x16,0x77}}, // \xe9\xb8\x9a
{0x9e1b,{0x26,0x7f,0x52,0x7f,0x5e,0x17,0x76}}, // \xe9\xb8\x9b
{0x9e1e,{0x4a,0x1d,0x5a,0x17,0x5a,0x1d,0x78}}, // \xe9\xb8\x9e
{0x9e75,{0x00,0x7c,0x54,0x6f,0x56,0x6e,0x7a}}, // \xe9\xb9\xb5
{0x9e78,{0x7c,0x47,0x7a,0x56,0x3d,0x56,0x5c}}, // \xe9\xb9\xb8
{0x9e79,{0x7c,0x47,0x7a,0x7e,0x6a,0x3f,0x52}}, // \xe9\xb9\xb9
{0x9e7d,{0x4f,0x7f,0x59,0x74,0x5f,0x7e,0x4e}}, // \xe9\xb9\xbd
{0x9e7f,{0x40,0x3e,0x7a,0x5e,0x0b,0x7e,0x52}}, // \xe9\xb9\xbf
{0x9e81,{0x42,0x3e,0x75,0x5d,0x17,0x7c,0x54}}, // \xe9\xba\x81
{0x9e88,{0x40,0x3e,0x5a,0x76,0x67,0x7e,0x52}}, // \xe9\xba\x88
{0x9e8b,{0x48,0x56,0x3e,0x7a,0x3f,0x5e,0x4a}}, // \xe9\xba\x8b
{0x9e8c,{0x28,0x36,0x6e,0x3a,0x3f,0x6e,0x2a}}, // \xe9\xba\x8c
{0x9e91,{0x48,0x76,0x2e,0x2a,0x2f,0x7e,0x4a}}, // \xe9\xba\x91
{0x9e92,{0x7e,0x3b,0x2e,0x52,0x1f,0x1a,0x5f}}, // \xe9\xba\x92
{0x9e93,{0x42,0x3f,0x76,0x5c,0x16,0x7f,0x56}}, // \xe9\xba\x93
{0x9e95,{0x08,0x76,0x7e,0x7a,0x5f,0x7e,0x0a}}, // \xe9\xba\x95
{0x9e97,{0x43,0x3d,0x77,0x5c,0x17,0x7d,0x57}}, // \xe9\xba\x97
{0x9e9d,{0x48,0x36,0x5e,0x7a,0x2f,0x4e,0x7a}}, // \xe9\xba\x9d
{0x9e9f,{0x7e,0x3b,0x2e,0x55,0x32,0x27,0x75}}, // \xe9\xba\x9f
{0x9ea5,{0x4a,0x56,0x2a,0x57,0x3a,0x56,0x4a}}, // \xe9\xba\xa5
{0x9ea6,{0x48,0x2a,0x5a,0x2f,0x5a,0x4a,0x48}}, // \xe9\xba\xa6
{0x9ea9,{0x2a,0x56,0x2f,0x5a,0x6a,0x5f,0x6a}}, // \xe9\xba\xa9
{0x9eaa,{0x2a,0x56,0x2f,0x5a,0x4d,0x6f,0x7d}}, // \xe9\xba\xaa
{0x9ead,{0x2a,0x56,0x2f,0x5a,0x44,0x7b,0x5e}}, // \xe9\xba\xad
{0x9eb8,{0x52,0x2f,0x5a,0x40,0x6a,0x5f,0x6a}}, // \xe9\xba\xb8
{0x9eb9,{0x52,0x2f,0x5a,0x57,0x7a,0x56,0x7e}}, // \xe9\xba\xb9
{0x9eba,{0x52,0x2f,0x5a,0x7d,0x57,0x7d,0x7d}}, // \xe9\xba\xba
{0x9ebb,{0x40,0x3e,0x2a,0x7e,0x2b,0x7e,0x2a}}, // \xe9\xba\xbb
{0x9ebc,{0x40,0x3e,0x5a,0x6e,0x5b,0x2e,0x4a}}, // \xe9\xba\xbc
{0x9ebe,{0x40,0x3e,0x2a,0x2e,0x7b,0x5e,0x4a}}, // \xe9\xba\xbe
{0x9ebf,{0x40,0x3e,0x6a,0x7e,0x6b,0x7e,0x6a}}, // \xe9\xba\xbf
{0x9ec4,{0x4a,0x7a,0x2f,0x3a,0x2f,0x7a,0x4a}}, // \xe9\xbb\x84
{0x9ecc,{0x4c,0x56,0x3d,0x36,0x3d,0x57,0x4c}}, // \xe9\xbb\x8c
{0x9ecd,{0x2a,0x6a,0x37,0x6f,0x37,0x6a,0x2a}}, // \xe9\xbb\x8d
{0x9ece,{0x2a,0x67,0x3f,0x6a,0x37,0x6a,0x2e}}, // \xe9\xbb\x8e
{0x9ecf,{0x5a,0x37,0x7f,0x3a,0x70,0x5f,0x74}}, // \xe9\xbb\x8f
{0x9ed0,{0x5a,0x37,0x7f,0x3a,0x7e,0x3f,0x72}}, // \xe9\xbb\x90
{0x9ed2,{0x50,0x17,0x55,0x1f,0x55,0x17,0x50}}, // \xe9\xbb\x92
{0x9ed4,{0x57,0x1f,0x57,0x12,0x55,0x36,0x14}}, // \xe9\xbb\x94
{0x9ed8,{0x57,0x1f,0x57,0x24,0x1f,0x24,0x45}}, // \xe9\xbb\x98
{0x9ed9,{0x57,0x1f,0x57,0x12,0x4f,0x12,0x53}}, // \xe9\xbb\x99
{0x9edb,{0x64,0x2e,0x79,0x3a,0x7b,0x26,0x6b}}, // \xe9\xbb\x9b
{0x9edc,{0x57,0x1f,0x57,0x76,0x44,0x7f,0x76}}, // \xe9\xbb\x9c
{0x9edd,{0x57,0x1f,0x64,0x5b,0x64,0x1f,0x7e}}, // \xe9\xbb\x9d
{0x9ede,{0x57,0x1f,0x57,0x70,0x5f,0x54,0x74}}, // \xe9\xbb\x9e
{0x9ee0,{0x57,0x1f,0x57,0x02,0x6a,0x6f,0x6a}}, // \xe9\xbb\xa0
{0x9ee5,{0x57,0x1f,0x57,0x22,0x4e,0x7b,0x2e}}, // \xe9\xbb\xa5
{0x9ee8,{0x56,0x1b,0x5e,0x17,0x5e,0x1b,0x56}}, // \xe9\xbb\xa8
{0x9eef,{0x57,0x1f,0x57,0x0a,0x6e,0x6b,0x6e}}, // \xe9\xbb\xaf
{0x9ef4,{0x0a,0x7d,0x56,0x1f,0x56,0x3f,0x5e}}, // \xe9\xbb\xb4
{0x9ef6,{0x68,0x27,0x7f,0x3d,0x7b,0x27,0x6b}}, // \xe9\xbb\xb6
{0x9ef7,{0x57,0x1f,0x57,0x3e,0x3b,0x3e,0x4e}}, // \xe9\xbb\xb7
{0x9ef9,{0x0b,0x76,0x33,0x7e,0x33,0x76,0x0b}}, // \xe9\xbb\xb9
{0x9efb,{0x75,0x3e,0x75,0x22,0x5f,0x22,0x5b}}, // \xe9\xbb\xbb
{0x9efc,{0x75,0x3e,0x75,0x7a,0x7f,0x2a,0x7b}}, // \xe9\xbb\xbc
{0x9efd,{0x18,0x1b,0x7f,0x41,0x7f,0x5b,0x58}}, // \xe9\xbb\xbd
{0x9f07,{0x14,0x3e,0x7f,0x4c,0x7a,0x7d,0x4b}}, // \xe9\xbc\x87
{0x9f08,{0x02,0x3d,0x7e,0x4d,0x7a,0x75,0x4b}}, // \xe9\xbc\x88
{0x9f0e,{0x4e,0x28,0x7f,0x07,0x7f,0x28,0x6e}}, // \xe9\xbc\x8e
{0x9f13,{0x5a,0x77,0x2a,0x40,0x5a,0x2f,0x5a}}, // \xe9\xbc\x93
{0x9f15,{0x2a,0x2f,0x3e,0x5a,0x16,0x2f,0x2a}}, // \xe9\xbc\x95
{0x9f20,{0x40,0x7e,0x55,0x2c,0x55,0x3f,0x40}}, // \xe9\xbc\xa0
{0x9f21,{0x40,0x3d,0x14,0x7d,0x16,0x7d,0x40}}, // \xe9\xbc\xa1
{0x9f2c,{0x7e,0x59,0x2a,0x7e,0x5e,0x5f,0x5e}}, // \xe9\xbc\xac
{0x9f3b,{0x20,0x78,0x2e,0x3b,0x6e,0x38,0x20}}, // \xe9\xbc\xbb
{0x9f3e,{0x38,0x6e,0x3b,0x7e,0x09,0x7f,0x09}}, // \xe9\xbc\xbe
{0x9f4a,{0x4a,0x36,0x2e,0x2b,0x2e,0x76,0x0a}}, // \xe9\xbd\x8a
{0x9f4b,{0x4a,0x36,0x2e,0x6b,0x2e,0x76,0x0a}}, // \xe9\xbd\x8b
{0x9f4e,{0x4a,0x36,0x7e,0x3b,0x7e,0x76,0x0a}}, // \xe9\xbd\x8e
{0x9f4f,{0x4a,0x36,0x5e,0x7b,0x5e,0x76,0x0a}}, // \xe9\xbd\x8f
{0x9f52,{0x04,0x7e,0x54,0x6f,0x56,0x6e,0x7a}}, // \xe9\xbd\x92
{0x9f54,{0x7e,0x6c,0x57,0x7a,0x7f,0x48,0x64}}, // \xe9\xbd\x94
{0x9f5f,{0x7e,0x6c,0x57,0x7a,0x7f,0x55,0x7f}}, // \xe9\xbd\x9f
{0x9f60,{0x7e,0x6c,0x57,0x7a,0x75,0x53,0x77}}, // \xe9\xbd\xa0
{0x9f61,{0x7e,0x6c,0x57,0x7a,0x16,0x75,0x36}}, // \xe9\xbd\xa1
{0x9f62,{0x7e,0x54,0x6f,0x7a,0x16,0x75,0x36}}, // \xe9\xbd\xa2
{0x9f63,{0x7e,0x6c,0x57,0x7a,0x04,0x5b,0x7e}}, // \xe9\xbd\xa3
{0x9f66,{0x7e,0x6c,0x57,0x7a,0x7f,0x35,0x5f}}, // \xe9\xbd\xa6
{0x9f67,{0x0a,0x7f,0x6e,0x58,0x6d,0x5b,0x7f}}, // \xe9\xbd\xa7
{0x9f6a,{0x7e,0x6c,0x57,0x7a,0x27,0x7d,0x57}}, // \xe9\xbd\xaa
{0x9f6c,{0x7e,0x6c,0x57,0x7a,0x05,0x6f,0x6d}}, // \xe9\xbd\xac
{0x9f72,{0x7e,0x6c,0x57,0x7a,0x7e,0x3f,0x71}}, // \xe9\xbd\xb2
{0x9f76,{0x7e,0x54,0x6f,0x7a,0x0f,0x5c,0x6b}}, // \xe9\xbd\xb6
{0x9f77,{0x7c,0x57,0x6a,0x7f,0x5b,0x77,0x53}}, // \xe9\xbd\xb7
{0x9f8d,{0x0a,0x7e,0x2b,0x7e,0x0a,0x77,0x5d}}, // \xe9\xbe\x8d
{0x9f95,{0x2a,0x7a,0x2e,0x7d,0x2e,0x76,0x5a}}, // \xe9\xbe\x95
{0x9f9c,{0x2a,0x3e,0x7d,0x45,0x7f,0x7c,0x58}}, // \xe9\xbe\x9c
{0x9f9d,{0x35,0x7f,0x2a,0x7e,0x45,0x7f,0x5c}}, // \xe9\xbe\x9d
{0x9fa0,{0x1c,0x74,0x3e,0x75,0x3e,0x74,0x1c}}, // \xe9\xbe\xa0
{0xff01,{0x00,0x00,0x00,0x5f,0x00,0x00,0x00}}, // \xef\xbc\x81
{0xff03,{0x20,0x62,0x3e,0x63,0x3e,0x23,0x02}}, // \xef\xbc\x83
{0xff04,{0x00,0x24,0x2a,0x7a,0x2f,0x2a,0x12}}, // \xef\xbc\x84
{0xff05,{0x42,0x25,0x12,0x08,0x24,0x52,0x21}}, // \xef\xbc\x85
{0xff06,{0x20,0x56,0x49,0x55,0x22,0x58,0x40}}, // \xef\xbc\x86
{0xff08,{0x00,0x00,0x00,0x00,0x1c,0x22,0x41}}, // \xef\xbc\x88
{0xff09,{0x41,0x22,0x1c,0x00,0x00,0x00,0x00}}, // \xef\xbc\x89
{0xff0a,{0x00,0x22,0x14,0x7f,0x14,0x22,0x00}}, // \xef\xbc\x8a
{0xff0b,{0x08,0x08,0x08,0x7f,0x08,0x08,0x08}}, // \xef\xbc\x8b
{0xff0c,{0x50,0x30,0x00,0x00,0x00,0x00,0x00}}, // \xef\xbc\x8c
{0xff0e,{0x60,0x60,0x00,0x00,0x00,0x00,0x00}}, // \xef\xbc\x8e
{0xff0f,{0x40,0x20,0x10,0x08,0x04,0x02,0x01}}, // \xef\xbc\x8f
{0xff10,{0x00,0x3e,0x41,0x41,0x41,0x41,0x3e}}, // \xef\xbc\x90
{0xff11,{0x00,0x00,0x42,0x7f,0x40,0x00,0x00}}, // \xef\xbc\x91
{0xff12,{0x00,0x62,0x51,0x51,0x49,0x49,0x46}}, // \xef\xbc\x92
{0xff13,{0x00,0x22,0x41,0x49,0x49,0x49,0x36}}, // \xef\xbc\x93
{0xff14,{0x00,0x30,0x28,0x24,0x22,0x7f,0x20}}, // \xef\xbc\x94
{0xff15,{0x00,0x2f,0x45,0x45,0x45,0x45,0x39}}, // \xef\xbc\x95
{0xff16,{0x00,0x3e,0x49,0x49,0x49,0x49,0x32}}, // \xef\xbc\x96
{0xff17,{0x00,0x01,0x01,0x61,0x19,0x05,0x03}}, // \xef\xbc\x97
{0xff18,{0x00,0x36,0x49,0x49,0x49,0x49,0x36}}, // \xef\xbc\x98
{0xff19,{0x00,0x26,0x49,0x49,0x49,0x49,0x3e}}, // \xef\xbc\x99
{0xff1a,{0x00,0x00,0x36,0x36,0x00,0x00,0x00}}, // \xef\xbc\x9a
{0xff1b,{0x00,0x00,0x56,0x36,0x00,0x00,0x00}}, // \xef\xbc\x9b
{0xff1c,{0x08,0x08,0x14,0x14,0x14,0x22,0x22}}, // \xef\xbc\x9c
{0xff1d,{0x14,0x14,0x14,0x14,0x14,0x14,0x14}}, // \xef\xbc\x9d
{0xff1e,{0x22,0x22,0x14,0x14,0x14,0x08,0x08}}, // \xef\xbc\x9e
{0xff1f,{0x00,0x02,0x01,0x51,0x09,0x09,0x06}}, // \xef\xbc\x9f
{0xff20,{0x1c,0x22,0x59,0x55,0x4d,0x12,0x0c}}, // \xef\xbc\xa0
{0xff21,{0x60,0x18,0x16,0x11,0x16,0x18,0x60}}, // \xef\xbc\xa1
{0xff22,{0x00,0x7f,0x49,0x49,0x49,0x49,0x36}}, // \xef\xbc\xa2
{0xff23,{0x00,0x1c,0x22,0x41,0x41,0x41,0x22}}, // \xef\xbc\xa3
{0xff24,{0x00,0x7f,0x41,0x41,0x41,0x22,0x1c}}, // \xef\xbc\xa4
{0xff25,{0x00,0x7f,0x49,0x49,0x49,0x49,0x41}}, // \xef\xbc\xa5
{0xff26,{0x00,0x7f,0x09,0x09,0x09,0x09,0x01}}, // \xef\xbc\xa6
{0xff27,{0x00,0x1c,0x22,0x41,0x49,0x49,0x3a}}, // \xef\xbc\xa7
{0xff28,{0x00,0x7f,0x08,0x08,0x08,0x08,0x7f}}, // \xef\xbc\xa8
{0xff29,{0x00,0x00,0x41,0x7f,0x41,0x00,0x00}}, // \xef\xbc\xa9
{0xff2a,{0x00,0x20,0x40,0x40,0x40,0x40,0x3f}}, // \xef\xbc\xaa
{0xff2b,{0x00,0x7f,0x10,0x08,0x14,0x22,0x41}}, // \xef\xbc\xab
{0xff2c,{0x00,0x7f,0x40,0x40,0x40,0x40,0x40}}, // \xef\xbc\xac
{0xff2d,{0x7f,0x02,0x0c,0x30,0x0c,0x02,0x7f}}, // \xef\xbc\xad
{0xff2e,{0x00,0x7f,0x02,0x04,0x08,0x10,0x7f}}, // \xef\xbc\xae
{0xff2f,{0x00,0x1c,0x22,0x41,0x41,0x22,0x1c}}, // \xef\xbc\xaf
{0xff30,{0x00,0x7f,0x09,0x09,0x09,0x09,0x06}}, // \xef\xbc\xb0
{0xff31,{0x00,0x1c,0x22,0x41,0x51,0x22,0x5c}}, // \xef\xbc\xb1
{0xff32,{0x00,0x7f,0x09,0x09,0x19,0x29,0x46}}, // \xef\xbc\xb2
{0xff33,{0x00,0x26,0x49,0x49,0x49,0x49,0x32}}, // \xef\xbc\xb3
{0xff34,{0x01,0x01,0x01,0x7f,0x01,0x01,0x01}}, // \xef\xbc\xb4
{0xff35,{0x00,0x3f,0x40,0x40,0x40,0x40,0x3f}}, // \xef\xbc\xb5
{0xff36,{0x03,0x0c,0x30,0x40,0x30,0x0c,0x03}}, // \xef\xbc\xb6
{0xff37,{0x1f,0x60,0x18,0x06,0x18,0x60,0x1f}}, // \xef\xbc\xb7
{0xff38,{0x41,0x22,0x14,0x08,0x14,0x22,0x41}}, // \xef\xbc\xb8
{0xff39,{0x01,0x02,0x04,0x78,0x04,0x02,0x01}}, // \xef\xbc\xb9
{0xff3a,{0x00,0x41,0x61,0x51,0x49,0x45,0x43}}, // \xef\xbc\xba
{0xff3b,{0x00,0x00,0x00,0x00,0x7f,0x41,0x41}}, // \xef\xbc\xbb
{0xff3c,{0x01,0x02,0x04,0x08,0x10,0x20,0x40}}, // \xef\xbc\xbc
{0xff3d,{0x41,0x41,0x7f,0x00,0x00,0x00,0x00}}, // \xef\xbc\xbd
{0xff3e,{0x00,0x00,0x02,0x01,0x02,0x00,0x00}}, // \xef\xbc\xbe
{0xff3f,{0x40,0x40,0x40,0x40,0x40,0x40,0x40}}, // \xef\xbc\xbf
{0xff40,{0x00,0x00,0x01,0x02,0x00,0x00,0x00}}, // \xef\xbd\x80
{0xff41,{0x00,0x20,0x54,0x54,0x54,0x78,0x00}}, // \xef\xbd\x81
{0xff42,{0x00,0x7f,0x48,0x44,0x44,0x38,0x00}}, // \xef\xbd\x82
{0xff43,{0x00,0x38,0x44,0x44,0x44,0x28,0x00}}, // \xef\xbd\x83
{0xff44,{0x00,0x38,0x44,0x44,0x48,0x7f,0x00}}, // \xef\xbd\x84
{0xff45,{0x00,0x38,0x54,0x54,0x54,0x18,0x00}}, // \xef\xbd\x85
{0xff46,{0x00,0x00,0x04,0x7e,0x05,0x01,0x00}}, // \xef\xbd\x86
{0xff47,{0x00,0x08,0x54,0x54,0x54,0x3c,0x00}}, // \xef\xbd\x87
{0xff48,{0x00,0x7f,0x08,0x04,0x04,0x78,0x00}}, // \xef\xbd\x88
{0xff49,{0x00,0x00,0x00,0x7d,0x00,0x00,0x00}}, // \xef\xbd\x89
{0xff4a,{0x00,0x20,0x40,0x40,0x3d,0x00,0x00}}, // \xef\xbd\x8a
{0xff4b,{0x00,0x00,0x7f,0x10,0x28,0x44,0x00}}, // \xef\xbd\x8b
{0xff4c,{0x00,0x00,0x01,0x7f,0x00,0x00,0x00}}, // \xef\xbd\x8c
{0xff4d,{0x00,0x7c,0x04,0x78,0x04,0x78,0x00}}, // \xef\xbd\x8d
{0xff4e,{0x00,0x7c,0x08,0x04,0x04,0x78,0x00}}, // \xef\xbd\x8e
{0xff4f,{0x00,0x38,0x44,0x44,0x44,0x38,0x00}}, // \xef\xbd\x8f
{0xff50,{0x00,0x7c,0x14,0x14,0x14,0x08,0x00}}, // \xef\xbd\x90
{0xff51,{0x00,0x08,0x14,0x14,0x14,0x7c,0x00}}, // \xef\xbd\x91
{0xff52,{0x00,0x7c,0x08,0x04,0x04,0x08,0x00}}, // \xef\xbd\x92
{0xff53,{0x00,0x48,0x54,0x54,0x54,0x24,0x00}}, // \xef\xbd\x93
{0xff54,{0x00,0x04,0x3e,0x44,0x44,0x20,0x00}}, // \xef\xbd\x94
{0xff55,{0x00,0x3c,0x40,0x40,0x20,0x7c,0x00}}, // \xef\xbd\x95
{0xff56,{0x00,0x0c,0x30,0x40,0x30,0x0c,0x00}}, // \xef\xbd\x96
{0xff57,{0x00,0x1c,0x60,0x18,0x60,0x1c,0x00}}, // \xef\xbd\x97
{0xff58,{0x00,0x44,0x28,0x10,0x28,0x44,0x00}}, // \xef\xbd\x98
{0xff59,{0x00,0x44,0x58,0x20,0x18,0x04,0x00}}, // \xef\xbd\x99
{0xff5a,{0x00,0x44,0x64,0x54,0x4c,0x44,0x00}}, // \xef\xbd\x9a
{0xff5b,{0x00,0x00,0x00,0x08,0x36,0x41,0x41}}, // \xef\xbd\x9b
{0xff5c,{0x00,0x00,0x00,0x7f,0x00,0x00,0x00}}, // \xef\xbd\x9c
{0xff5d,{0x41,0x41,0x36,0x08,0x00,0x00,0x00}}, // \xef\xbd\x9d
{0xffe3,{0x01,0x01,0x01,0x01,0x01,0x01,0x01}}, // \xef\xbf\xa3
{0xffe5,{0x00,0x2b,0x2c,0x78,0x2c,0x2b,0x00}}, // \xef\xbf\xa5
};

void font_8x8(uint8_t buf[], uint32_t unicode) {
    buf[7] = 0x00;
    int head = 0;
    int tail = sizeof(misaki_gothic)/sizeof(stfont) - 1;
    while(1) {
        int i = (head + tail) / 2;
        if (misaki_gothic[i].unicode == unicode) {
            memcpy(buf, misaki_gothic[i].bitmap, 7);
            return;
        } else if (misaki_gothic[i].unicode < unicode) {
            head = i+1;
        } else {
            tail = i-1;
        }
        if (head > tail) {
            break;
        }
    }     
    memset(buf, 0x55, 7); // not found.
}

