// GraphicOLED.cpp
#include "GraphicOLED.h"

extern void font_4x8(uint8_t buf[], int c); // misaki_4x8_jis201.cpp
extern void font_8x8(uint8_t buf[], uint32_t unicode); // misaki_8x8_unicode.cpp

GraphicOLED::GraphicOLED(PinName rs, PinName e, PinName d4, PinName d5, PinName d6, PinName d7) :  _rs(rs), _e(e), _d(d4, d5, d6, d7) {
    _e  = 1;
    _rs = 0;            // command mode

    wait_ms(500);       // Wait For Stabilization 500ms

    writeCommand(0x00); // 0x0 x 5, sync 4bit-mode
    writeCommand(0x00);
    writeCommand(0x02); // function set
    writeCommand(0x28); // N=1 2-line display
    writeCommand(0x0c); // D=1 display on
    writeCommand(0x14); // S/C=0 R/L=1
    writeCommand(0x1f); // G/C=1 graphic mode

    _uni_len = 0;
}

void GraphicOLED::g_write(uint8_t pat, int x, int y) {
    writeCommand(0x80 + (x&0x7f)); // x position
    writeCommand(0x40 + (y&0x01)); //y position
    writeData(pat);
}

void GraphicOLED::g_write(uint8_t *buf, int len, int x, int y) {
    for(int i = 0; i < len; i++) {
        g_write(*buf++, x++, y);
    }
}

void GraphicOLED::writeCommand(uint8_t command) {
    _rs = 0;
    writeByte(command);
}

void GraphicOLED::writeData(uint8_t data) {
    _rs = 1;
    writeByte(data);
}

void GraphicOLED::writeByte(uint8_t value) {
    _d = value >> 4;
    wait_us(40);  // most instructions take 40us
    _e = 0;
    wait_us(40);
    _e = 1;
    _d = value >> 0;
    wait_us(40);
    _e = 0;
    wait_us(40);  // most instructions take 40us
    _e = 1;
}

void GraphicOLED::cls() {
    for(int y = 0; y < rows(); y++) {
        for(int x = 0; x < 100; x++) {
            g_write(0x00, x, y);
        }
    }
    locate(0,0);
    _uni_len = 0;
}

void GraphicOLED::locate(int column, int row) {
    _column = column;
    _row = row;
}

int GraphicOLED::columns() {
     return 25;
}

int GraphicOLED::rows() {
    return 2;
}

int GraphicOLED::_putc(int value)
{
    int step = 0;
    if (value == '\n') {
        _column = 0;
        _row++;
        if (_row >= rows()) {
            _row = 0;
        }
        _uni_len = 0;
    } else if (value <= 0x7f) {
        step = character(_column, _row, value);
    } else if (value >= 0xc2 && value <= 0xdf) {
        _unicode = value & 0x1f;
        _uni_len = 1;
    } else if (value >= 0xe0 && value <= 0xef) {
        _unicode = value & 0x0f;
        _uni_len = 2;
    } else if (value >= 0xf0 && value <= 0xf7) {
        _unicode = value & 0x07;
        _uni_len = 3;
    } else if (value >= 0xf8 && value <= 0xfb) {
        _unicode = value & 0x03;
        _uni_len = 4;
    } else if (value >= 0xfc && value <= 0xfd) {
        _unicode = value & 0x01;
        _uni_len = 5;
    } else if (_uni_len >= 1 && value >= 0x80 && value <= 0xbf) {
        _unicode = (_unicode<<6) | (value&0x3f);
        if (--_uni_len == 0) {
            step = character(_column, _row, _unicode);
        }
    } else {
        _uni_len = 0;
    }
    if (step > 0) {
        _column += step;
        if (_column >= columns()) {
            _column = 0;
            if (++_row >= rows()) {
                _row = 0;
            }
        }
        _uni_len = 0;
    }
    return value;
}

int GraphicOLED::_getc() {
    return -1;
}

int GraphicOLED::character(int column, int row, int c) {
    if (c <= 0x7f) { // 半角
        uint8_t buf[4];
        font_4x8(buf, c);
        g_write(buf, sizeof(buf), column*4, row);
        return 1;
    } else if (c >= 0xff61 && c <= 0xff9f) { // 半角カタカナ
        int i = c - 0xff61 + 0xa1;
        uint8_t buf[4];
        font_4x8(buf, i);
        g_write(buf, sizeof(buf), column*4, row);
        return 1;
    } else { // 全角
        uint8_t buf[8];
        font_8x8(buf, c);
        g_write(buf, sizeof(buf), column*4, row);
        return 2;
    }
}

