#include "mbed.h"
#include "USBHostMouse.h"

DigitalOut led(LED1);

void onMouseEvent(uint8_t buttons, int8_t x, int8_t y, int8_t z) {
    printf("buttons: %d, x: %d, y: %d, z: %d\r\n", buttons, x, y, z);
}

int main() {
    USBHostMouse mouse;
    // connect a USB mouse
    if (!mouse.connect()) {
        error("USB mouse not found.\n");
    }
    // when connected, attach handler called on mouse event
    mouse.attachEvent(onMouseEvent);
    Timer t;
    t.reset();
    t.start();
    for(;;) {
        if (t.read_ms() > 500) {
            led = !led;
            t.reset();
        }
        USBHost::poll();
    }
}
