#include "USBHostMSD.h"

DigitalOut led1(LED1);

int main() {
    USBHostMSD msd("usb");
    if (!msd.connect()) {
        error("USB Flash drive not found.\n");
    }    
    FILE* fp = fopen("/usb/test1.txt", "a");
    if (fp) {
        fprintf(fp, "Hello from mbed.\n");
        for(int i = 0; i < 21; i++) {
            fprintf(fp, " %d", i);
            led1 = !led1;
        }
        fprintf(fp, "\n");
        fclose(fp);
    }
    fp = fopen("/usb/test1.txt", "r");
    if (fp) {
        int n = 0;
        while(1) {
            int c = fgetc(fp);
            if (c == EOF) {
                break;
            }
            printf("%c", c);
            n++;
            led1 = !led1;
        }
        fclose(fp);
        printf("%d bytes\n", n);
    }

    while(1) {
        led1 = !led1;
        wait_ms(200);
    }
}
