// main.cpp 2016/1/20
#include "mbed.h"
#include "USBDAP.h"
#include "BaseDAP.h"

SWD swd(D7, D6, D3); // SWDIO,SWCLK,nRESET
DigitalOut connected(LED1); // D13
DigitalOut running(D12);
const int LED_ON  = 1;
const int LED_OFF = 0;

class myDAP : public BaseDAP {
public:
    myDAP(SWD* swd):BaseDAP(swd){};
    virtual void infoLED(int select, int value) {
        switch(select) {
            case 0:
                connected = value ? LED_ON : LED_OFF; 
                break;
            case 1: 
                running = value ? LED_ON : LED_OFF; 
                break;
        }
    } 
};

int main() {
   USBDAP* hid = new USBDAP("F042K6 CMSIS-DAP");
   myDAP* dap = new myDAP(&swd);
   while(1) {
        HID_REPORT recv_report;
        if(hid->readNB(&recv_report)) {
            HID_REPORT send_report;
            dap->Command(recv_report.data, send_report.data);
            send_report.length = 64;
            hid->send(&send_report);
        }
    }    
}

