#ifndef MYUDPSOCKET_H
#define MYUDPSOCKET_H
#include "UDPSocket.h"

#ifdef DEBUG
#define PRINT_FUNC() printf("%d:%s\n", __LINE__,__PRETTY_FUNCTION__)
#else //DEBUG
#define PRINT_FUNC()
#endif //DEBUG

class MyUDPSocket {
    int _socket;
    void (*m_pCb)(UDPSocketEvent);
public:
    MyUDPSocket() {
        _socket = 7;
        W5100.writeSnMR(_socket, SnMR::UDP); // set UDP mode
    }

    UDPSocketErr bind(const Host& me) {
        if (! me.getIp().isNull()) {
            uint8_t ip[4];
            ip[0] = me.getIp()[0];
            ip[1] = me.getIp()[1];
            ip[2] = me.getIp()[2];
            ip[3] = me.getIp()[3];
            W5100.setIPAddress(ip);
        }
        int port = me.getPort();
        if (port) {
            W5100.writeSnPORT(_socket, port);
        }
        W5100.execCmdSn( _socket, Sock_OPEN); // set OPEN command
        return UDPSOCKET_OK;
    }

    int /*if < 0 : UDPSocketErr*/ sendto(const char* buf, int len, Host* pHost) {
#ifdef DEBUG
        PRINT_FUNC();
        printHex((u8*)buf, len);
#endif //DEBUG
        uint8_t ip[4];
        ip[0] = pHost->getIp()[0];
        ip[1] = pHost->getIp()[1];
        ip[2] = pHost->getIp()[2];
        ip[3] = pHost->getIp()[3];
        int port = pHost->getPort();
        W5100.writeSnDIPR(_socket, ip);
        W5100.writeSnDPORT(_socket, port);
        W5100.send_data_processing(_socket, (uint8_t*)buf, len);
        W5100.execCmdSn(_socket, Sock_SEND);
#ifdef DEBUG
        W5100.getIPAddress(ip);
        printf("SIPR: %d.%d.%d.%d Sn_PORT:%d\n", ip[0], ip[1], ip[2], ip[3], W5100.readSnPORT(_socket));
        W5100.readSnDIPR(_socket, ip);
        printf("Sn_DIPR: %d.%d.%d.%d Sn_DPORT:%d\n", ip[0], ip[1], ip[2], ip[3], W5100.readSnDPORT(_socket));
#endif //DEBUG
        return len;
    }

    int /*if < 0 : UDPSocketErr*/ recvfrom(char* buf, int len, Host* pHost) {
        int size = W5100.getRXReceivedSize(_socket);
        if (size < 8) {
            return -1;
        }
        uint8_t info[8];
        W5100.recv_data_processing(_socket, info, 8);
        W5100.execCmdSn(_socket, Sock_RECV);
        pHost->setIp(IpAddr(info[0],info[1],info[2],info[3]));
        pHost->setPort(info[4]<<8|info[5]);
        size -= 8;
        if (size > len) {
            size = len;
        }    
        W5100.recv_data_processing(_socket, (uint8_t*)buf, size);
        W5100.execCmdSn(_socket, Sock_RECV);
#ifdef DEBUG
        printfBytes("UDP PACKET-INFO", (u8*)info, 8);
        printHex((u8*)buf, size);
#endif //DEBUG
        return size;
    }
    
    UDPSocketErr close()
    {
        W5100.execCmdSn(_socket, Sock_CLOSE);
        return UDPSOCKET_OK;
    }
    
    void setOnEvent(void (*pMethod)(UDPSocketEvent))
    {
        m_pCb = pMethod;
    }
    
    void resetOnEvent() {
        m_pCb = NULL;
    }
    
    void poll()
    {
        PRINT_FUNC();
#ifdef DEBUG
        printf("socket:%d SnMR:%02x SnIR:%02x SnSR:%02x\n", _socket, 
            W5100.readSnMR(_socket), W5100.readSnIR(_socket), W5100.readSnSR(_socket));
        uint8_t ip[4];
        W5100.readSnDIPR(_socket, ip);
        printf("Sn_DIPR: %d.%d.%d.%d Sn_DPORT: %d\n", ip[0], ip[1], ip[2], ip[3], W5100.readSnDPORT(_socket));
        uint8_t mac[6];
        W5100.readSnDHAR(_socket, mac);
        printf("Sn_DHAR: %02x:%02x:%02x:%02x:%02x:%02x\n", mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);
        printf("Sn_RX_RSR:%d, Sn_RX_RD:%d, Sn_RX_WR:%d\n",
                    W5100.readSnRX_RSR(_socket), W5100.readSnRX_RD(_socket), W5100.readSnRX_WR(_socket));
        printf("Sn_TX_FSR:%d, Sn_TX_RD:%d, Sn_TX_WR:%d\n",
                    W5100.readSnTX_FSR(_socket), W5100.readSnTX_RD(_socket), W5100.readSnTX_WR(_socket));
#endif //DEBUG
        if (m_pCb == NULL) {
            return;
        }
        if (W5100.getRXReceivedSize(_socket) > 0) {
            m_pCb(UDPSOCKET_READABLE);
            return;
        }
     }
};    
#endif // MYUDPSOCKET_H
