// MyEthernetNetIf.h 2012/4/10
// EthernetNetIf for WIZ820io(W5200)
#include "mbed.h"
#include "MyEthernetNetIf.h"
#include "DHCPClient.h"
#include "w5100.h"

extern W5100Class W5100; // w5100.cpp

bool wait_linkup(int timeout = 3000) {
    Timer link_t;
    link_t.start();
    while(link_t.read_ms() < timeout) {
        if (0x20 & W5100.readPHYSTATUS()) {
            return true;
        }
         wait_ms(50);
    }  
    return false;
}

void MyEthernetNetIf::hardware_setup(){
    W5100.hardware_reset();
    W5100.init();
    wait_linkup();
}

MyEthernetNetIf::MyEthernetNetIf(IpAddr ip, IpAddr netmask, IpAddr gateway, IpAddr dns) {
    m_ip = ip;
    m_netmask = netmask;
    m_gateway = gateway;
    m_dns = dns;
    m_useDhcp = false;
}

MyEthernetNetIf:: MyEthernetNetIf() {
    m_useDhcp = true;
}

EthernetErr MyEthernetNetIf::setup(int timeout_ms)
{
    hardware_setup();
    uint8_t mac[6] = {0x00,0x00,0x5e,0x00,0x01,0x01};
    W5100.setMACAddress(mac);
    printf("HW Addr is : %02x:%02x:%02x:%02x:%02x:%02x.\n", mac[0],mac[1],mac[2],mac[3],mac[4],mac[5]);
    uint8_t u[4];
    u[0] = m_ip[0];
    u[1] = m_ip[1];
    u[2] = m_ip[2];
    u[3] = m_ip[3];
    W5100.setIPAddress(u);
    u[0] = m_netmask[0];
    u[1] = m_netmask[1];
    u[2] = m_netmask[2];
    u[3] = m_netmask[3];
    W5100.setSubnetMask(u);
    u[0] = m_gateway[0];
    u[1] = m_gateway[1];
    u[2] = m_gateway[2];
    u[3] = m_gateway[3];
    W5100.setGatewayIp(u);
    if (! m_useDhcp) {
        return ETH_OK;
    }
    printf("DHCP Started, waiting for IP...\n");  
    DHCPClient* dhcp;
    EthernetErr err;
    dhcp = new DHCPClient;
    int r = dhcp->setup(timeout_ms);
    if (r == (-1)) {
        printf("Timeout.\n");
        err = ETH_TIMEOUT;  
    } else {
        W5100.writeSIPR(dhcp->yiaddr);
        W5100.writeSUBR(dhcp->netmask);
        W5100.writeGAR(dhcp->gateway);
        m_ip = IpAddr(dhcp->yiaddr[0],dhcp->yiaddr[1],dhcp->yiaddr[2],dhcp->yiaddr[3]);
        m_dns = IpAddr(dhcp->dnsaddr[0],dhcp->dnsaddr[1],dhcp->dnsaddr[2],dhcp->dnsaddr[3]);
        printf("Connected, IP: %d.%d.%d.%d\n", dhcp->yiaddr[0], dhcp->yiaddr[1], dhcp->yiaddr[2], dhcp->yiaddr[3]);
        err = ETH_OK;
    }
    delete dhcp;
    return err;
}
