// C12832_KANJI.h
#pragma once
#include "mbed.h"

/** C12832 interface
 *
 * Currently support UTF-8 KANJI(misaki font) 
 *
 * @code
 * #include "mbed.h"
 * #include "C12832_KANJI.h"
 * 
 * C12832_KANJI lcd(p5, p7, p6, p8, p11);
 * 
 * int main() {
 *     led.printf("Hello World!\n");
 * }
 * @endcode
 */
class C12832_KANJI : public Stream {
public:
    /** Create a C12832_KANJI interface
     */
    C12832_KANJI(PinName mosi, PinName sck, PinName reset, PinName a0, PinName ncs);

#if DOXYGEN_ONLY
    /** Write a character to the LCD
     *
     * @param c The character to write to the display
     */
    int putc(int c);

    /** Write a formated string to the LCD
     *
     * @param format A printf-style format string, followed by the
     *               variables to use in formating the string.
     */
    int printf(const char* format, ...);
#endif

    /** Locate to a screen column and row
     *
     * @param column  The horizontal position from the left, indexed from 0
     * @param row     The vertical position from the top, indexed from 0
     */
    void locate(int column, int row);

    /** Clear the screen and locate to 0,0 */
    void cls();

    int rows();
    int columns();

    void g_write(uint8_t pat, int x, int y);
    void g_write(uint8_t *buf, int len, int x, int y);
       
private:
    int _uni_len;
    uint32_t _unicode;

    // Stream implementation functions
    virtual int _putc(int value);
    virtual int _getc();

    int character(int column, int row, int c);
    void writeByte(uint8_t value);
    void writeCommand(uint8_t command);
    void writeData(uint8_t data);

    SPI _spi;
    DigitalOut _reset,_A0,_CS;

    int _column;
    int _row;
};

