// C12832_KANJI.cpp
#include "C12832_KANJI.h"

extern void font_4x8(uint8_t buf[], int c); // misaki_4x8_jis201.cpp
extern void font_8x8(uint8_t buf[], uint32_t unicode); // misaki_8x8_unicode.cpp

C12832_KANJI::C12832_KANJI(PinName mosi, PinName sck, PinName reset, PinName a0, PinName ncs) : _spi(mosi,NC,sck),_reset(reset),_A0(a0),_CS(ncs) {

    _spi.format(8,3);                 // 8 bit spi mode 3
    //_spi.frequency(20000000);          // 19,2 Mhz SPI clock
    _A0 = 0;
    _CS = 1;
    _reset = 0;                        // display reset
    wait_us(50);
    _reset = 1;                       // end reset
    wait_ms(5);
 
    /* Start Initial Sequence ----------------------------------------------------*/
 
    writeCommand(0xAE);   //  display off
    writeCommand(0xA2);   //  bias voltage
 
    writeCommand(0xA0);
    writeCommand(0xC8);   //  colum normal
 
    writeCommand(0x22);   //  voltage resistor ratio
    writeCommand(0x2F);   //  power on
    //writeCommand(0xA4);   //  LCD display ram
    writeCommand(0x40);   // start line = 0
    writeCommand(0xAF);     // display ON
 
    writeCommand(0x81);   //  set contrast
    writeCommand(0x17);   //  set contrast
 
    writeCommand(0xA6);     // display normal

    _uni_len = 0;
}

void C12832_KANJI::g_write(uint8_t pat, int x, int y) {
    writeCommand(0x00 + ( x    &0x0f)); // set column low nibble 0
    writeCommand(0x10 + ((x>>4)&0x0f)); // set column hi  nibble 0
    writeCommand(0xB0 + y); // set page address

    writeData(pat);
}

void C12832_KANJI::g_write(uint8_t *buf, int len, int x, int y) {
    for(int i = 0; i < len; i++) {
        g_write(*buf++, x++, y);
    }
}

void C12832_KANJI::writeCommand(uint8_t command) {
    _A0 = 0;
    writeByte(command);
}

void C12832_KANJI::writeData(uint8_t data) {
    _A0 = 1;
    writeByte(data);
}

void C12832_KANJI::writeByte(uint8_t value) {
    _CS = 0;
    _spi.write(value);
    _CS = 1;
}

void C12832_KANJI::cls() {
    for(int y = 0; y < rows(); y++) {
        for(int x = 0; x < 128; x++) {
            g_write(0x00, x, y);
        }
    }
    locate(0,0);
    _uni_len = 0;
}

void C12832_KANJI::locate(int column, int row) {
    _column = column;
    _row = row;
}

int C12832_KANJI::columns() {
     return 128/4;
}

int C12832_KANJI::rows() {
    return 4;
}

int C12832_KANJI::_putc(int value)
{
    int step = 0;
    if (value == '\n') {
        _column = 0;
        _row++;
        if (_row >= rows()) {
            _row = 0;
        }
        _uni_len = 0;
    } else if (value <= 0x7f) {
        step = character(_column, _row, value);
    } else if (value >= 0xc2 && value <= 0xdf) {
        _unicode = value & 0x1f;
        _uni_len = 1;
    } else if (value >= 0xe0 && value <= 0xef) {
        _unicode = value & 0x0f;
        _uni_len = 2;
    } else if (value >= 0xf0 && value <= 0xf7) {
        _unicode = value & 0x07;
        _uni_len = 3;
    } else if (value >= 0xf8 && value <= 0xfb) {
        _unicode = value & 0x03;
        _uni_len = 4;
    } else if (value >= 0xfc && value <= 0xfd) {
        _unicode = value & 0x01;
        _uni_len = 5;
    } else if (_uni_len >= 1 && value >= 0x80 && value <= 0xbf) {
        _unicode = (_unicode<<6) | (value&0x3f);
        if (--_uni_len == 0) {
            step = character(_column, _row, _unicode);
        }
    } else {
        _uni_len = 0;
    }
    if (step > 0) {
        _column += step;
        if (_column >= columns()) {
            _column = 0;
            if (++_row >= rows()) {
                _row = 0;
            }
        }
        _uni_len = 0;
    }
    return value;
}

int C12832_KANJI::_getc() {
    return -1;
}

int C12832_KANJI::character(int column, int row, int c) {
    if (c <= 0x7f) { // 半角
        uint8_t buf[4];
        font_4x8(buf, c);
        g_write(buf, sizeof(buf), column*4, row);
        return 1;
    } else if (c >= 0xff61 && c <= 0xff9f) { // 半角カタカナ
        int i = c - 0xff61 + 0xa1;
        uint8_t buf[4];
        font_4x8(buf, i);
        g_write(buf, sizeof(buf), column*4, row);
        return 1;
    } else { // 全角
        uint8_t buf[8];
        font_8x8(buf, c);
        g_write(buf, sizeof(buf), column*4, row);
        return 2;
    }
}

