// LogitechC270.cpp 2013/1/25
#include "mbed.h"
#include "rtos.h"
#include "BaseUsbHost.h"
//#define DEBUG
#include "BaseUsbHostDebug.h"
#define TEST
#include "BaseUsbHostTest.h"
#include "LogitechC270.h"

LogitechC270::LogitechC270(int formatIndex, int frameIndex, uint32_t interval, ControlEp* ctlEp)
{
    uint8_t buf[26];
    
    if (ctlEp == NULL) { // root hub
        DBG_OHCI(LPC_USB->HcRhPortStatus1);
        TEST_ASSERT_FALSE(LPC_USB->HcRhPortStatus1 & 0x200);
        ctlEp = new ControlEp();
        TEST_ASSERT_TRUE(ctlEp);
    }
    bool r = check(ctlEp);
    TEST_ASSERT(r);
    m_ctlEp = ctlEp;
    
    int addr = m_ctlEp->GetAddr();
    m_isoEp = new IsochronousEp(addr, C270_EN, C270_MPS);
    TEST_ASSERT_TRUE(m_isoEp);

    int rc = Control(GET_INFO, VS_PROBE_CONTROL, 1, buf, 1);
    TEST_ASSERT(rc == USB_OK);
    DBG_BYTES("GET_INFO Prob", buf, 1);

    rc = Control(GET_DEF, VS_PROBE_CONTROL, 1, buf, 26);
    TEST_ASSERT(rc == USB_OK);
    DBG_BYTES("GET_DEF Probe", buf, 26);

    rc = Control(GET_MIN, VS_PROBE_CONTROL, 1, buf, 26);
    TEST_ASSERT(rc == USB_OK);
    DBG_BYTES("GET_MIN Probe", buf, 26);

    rc = Control(GET_MAX, VS_PROBE_CONTROL, 1, buf, 26);
    TEST_ASSERT(rc == USB_OK);
    DBG_BYTES("GET_MAX Probe", buf, 26);

    rc = Control(GET_CUR, VS_PROBE_CONTROL, 1, buf, 26);
    TEST_ASSERT(rc == USB_OK);
    DBG_BYTES("GET_CUR Probe", buf, 26);

    memset(buf, 0, 26);
    buf[2] = formatIndex;
    buf[3] = frameIndex;
    *reinterpret_cast<uint32_t*>(buf+4) = interval;
    
    DBG_BYTES("SET_CUR Commit", buf, 26);
    rc = Control(SET_CUR, VS_COMMIT_CONTROL, 1, buf, 26);
    TEST_ASSERT(rc == USB_OK);

    rc = Control(GET_CUR, VS_COMMIT_CONTROL, 1, buf, 26);
    TEST_ASSERT(rc == USB_OK);
    TEST_ASSERT_EQUAL(buf[2], formatIndex);
    TEST_ASSERT_EQUAL(buf[3], frameIndex);
    TEST_ASSERT_EQUAL(*reinterpret_cast<uint32_t*>(buf+4), interval);
    DBG_BYTES("GET_CUR Commit", buf, 26);

    int value;
    rc = m_ctlEp->GetConfiguration(&value);
    TEST_ASSERT_EQUAL(rc, USB_OK);
    DBG("config: %d\n", value);

    rc = m_ctlEp->SetConfiguration(1);
    TEST_ASSERT_EQUAL(rc, USB_OK);

    rc = m_ctlEp->GetConfiguration(&value);
    TEST_ASSERT_EQUAL(rc, USB_OK);
    DBG("config: %d\n", value);
    TEST_ASSERT_EQUAL(value, 1);

    rc = m_ctlEp->GetInterface(1, &value);
    TEST_ASSERT_EQUAL(rc, USB_OK);
    DBG("alt: %d\n", value);

    rc = m_ctlEp->SetInterfaceAlternate(1, C270_IF_ALT); // alt=1 packet size = 192
    TEST_ASSERT_EQUAL(rc, USB_OK);

    rc = m_ctlEp->GetInterface(1, &value);
    TEST_ASSERT_EQUAL(rc, USB_OK);
    DBG("alt: %d\n", value);
    TEST_ASSERT_EQUAL(value, C270_IF_ALT);

    for(int i = 0; i < 16; i++) {
        report_cc_count[i] = 0;
        report_ps_cc_count[i] = 0;
    }
  
    LPC_USB->HcControl |= OR_CONTROL_PLE; // PeriodicListEnable
    LPC_USB->HcControl |= OR_CONTROL_IE;  // IsochronousEnable
}

bool LogitechC270::check(ControlEp* ctlEp)
{
    if (ctlEp == NULL) {
        return false;
    }
    uint8_t buf[18];
    int r = ctlEp->GetDescriptor(1, 0, buf, 8);
    if (r != USB_OK) {
        return false;
    }
    DBG_HEX(buf, 8);
    const uint8_t desc[] = {0x12,0x01,0x00,0x02,0xef,0x02,0x01,0x40};
    if (memcmp(buf, desc, sizeof(desc)) != 0) {
        return false;
    }
    r = ctlEp->GetDescriptor(1, 0, buf, 18);
    if (r != USB_OK) {
        return false;
    }
    DBG_HEX(buf, 18);
    uint16_t vid = *reinterpret_cast<uint16_t*>(buf+8);
    uint16_t pid = *reinterpret_cast<uint16_t*>(buf+10);
    DBG("VID PID: %04X %04X\n", vid, pid);
    if (vid == C270_VID && pid == C270_PID) {
        return true;
    }
    return false;
}
