// usbFlashDrive.h 2013/1/8
#pragma once

#include "FATFileSystem.h"

#define  SCSI_CMD_REQUEST_SENSE      0x03
#define  SCSI_CMD_TEST_UNIT_READY    0x00
#define  SCSI_CMD_INQUIRY            0x12
#define  SCSI_CMD_READ_10            0x28
#define  SCSI_CMD_READ_CAPACITY      0x25
#define  SCSI_CMD_WRITE_10           0x2A

#pragma pack(push,1)
struct CBW {
    uint32_t dCBWSignature;
    uint32_t dCBWTag;
    uint32_t dCBWDataTraansferLength;
    uint8_t bmCBWFlags;
    uint8_t bCBWLUN;
    uint8_t bCBWCBLength;
    uint8_t CBWCB[16];
};

struct CSW {
    uint32_t dCSWSignature;
    uint32_t dCSWTag;
    uint32_t dCSWDataResidue;
    uint8_t  bCSWStatus;
};
#pragma pack(pop)

class UsbFlashDrive : public FATFileSystem {
public:
    UsbFlashDrive(const char* name, ControlEp* ctlEp = NULL);
    static bool check(ControlEp* ctlEp);
    virtual int disk_initialize();
    virtual int disk_write(const uint8_t* buffer, uint64_t sector);
    virtual int disk_read(uint8_t* buffer, uint64_t sector);    
    virtual int disk_status();
    virtual int disk_sync();
    virtual uint64_t disk_sectors();
private:
    int setup(ControlEp* ctlEp, int timeout = 9000);
    int ParseConfiguration(ControlEp* ctlEp);
    int BulkOnlyMassStorageReset(ControlEp* ctlEp);
    int GetMaxLUN(ControlEp* ctlEp);
    int ReadCapacity();
    int GetSenseInfo();
    int TestUnitReady();
    int Inquire();
    int MS_BulkRecv(uint32_t block_number, int num_blocks, uint8_t* user_buffer);
    int MS_BulkSend(uint32_t block_number, int num_blocks, const uint8_t* user_buffer);
    int CommandTransport(const uint8_t* cdb, int size);
    int StatusTransport();
    int _bulkRecv(uint8_t* buf, int size);
    int _bulkSend(const uint8_t* buf, int size);
    const char* m_name;
    int m_drive;
    uint32_t m_numBlocks;
    int m_BlockSize;
    int m_lun;
    int m_MaxLUN;
    int m_interface;
    uint32_t m_tag;
    CBW m_CBW;
    CSW m_CSW;
    // endpoint
    BulkEp* m_pEpBulkIn;
    BulkEp* m_pEpBulkOut;
    // report
    uint32_t m_report_disk_write;
    uint32_t m_report_disk_read;
    uint32_t m_report_disk_status;
    uint32_t m_report_disk_sync;
};
