// BaseUsbHostIntEp.cpp 2012/12/24
#include "mbed.h"
#include "rtos.h"
#include "BaseUsbHost.h"
#define DEBUG
#include "BaseUsbHostDebug.h"
#define TEST
#include "BaseUsbHostTest.h"

InterruptEp::InterruptEp(int addr, uint8_t ep, uint16_t size, int lowSpeed)
    :BaseEp(addr, ep, size, lowSpeed)
{
    HCTD* td = new HCTD(this);
    m_pED->HeadTd = td; 
    m_pED->TailTd = td;
    TEST_ASSERT(td);
    if (td == NULL) {
        return;
    }
    HCCA* pHcca = reinterpret_cast<HCCA*>(LPC_USB->HcHCCA);
    TEST_ASSERT(pHcca);
    if (pHcca == NULL) {
        return;
    }
    int n = 0;
    m_pED->Next = pHcca->InterruptTable[n];
    pHcca->InterruptTable[n] = m_pED;

    DBG_ED(m_pED);
}

void InterruptEp::enable()
{
    LPC_USB->HcControl |= OR_CONTROL_PLE;
}
    
int InterruptEp::interruptReceive(uint8_t* buf, int len, int millisec)
{
    return send_receive(buf, len, millisec);
}
