// BaseUsbHostUvc.cpp 2013/1/11
#include "mbed.h"
#include "rtos.h"
#include "BaseUsbHost.h"
#define DEBUG
#include "BaseUsbHostDebug.h"
#define TEST
#include "BaseUsbHostTest.h"

void BaseUvc::poll(int millisec)
{
    HCITD* itd = m_isoEp->isochronousReveive(millisec);
    if (itd) {
        uint8_t cc = itd->ConditionCode();
        report_cc_count[cc]++;
        if (cc == 0) {
            uint16_t frame = itd->StartingFrame();
            int fc = itd->FrameCount();
            uint8_t* buf = const_cast<uint8_t*>(itd->buf); 
            int mps = m_isoEp->m_PacketSize;
            for(int i = 0; i < fc; i++) {
                uint16_t psw = itd->OffsetPSW[i];
                cc = psw>>12;
                if (cc == 0 || cc == 9) {
                    int len = psw & 0x7ff;
                    onResult(frame, buf, len);
               }
               report_ps_cc_count[cc]++;
               buf += mps;
               frame++;
            }
        }
        delete itd;
    }
}

int BaseUvc::Control(int req, int cs, int index, uint8_t* buf, int size)
{
    TEST_ASSERT(m_ctlEp);
    if (m_ctlEp == NULL) {
        return USB_ERROR;
    }
    int rc;
    if (req == SET_CUR) {    
        rc = m_ctlEp->controlSend(
                    USB_HOST_TO_DEVICE | USB_REQUEST_TYPE_CLASS | USB_RECIPIENT_INTERFACE, 
                    req, cs<<8, index, buf, size);
        return rc;
    }
    rc = m_ctlEp->controlReceive(
                USB_DEVICE_TO_HOST | USB_REQUEST_TYPE_CLASS | USB_RECIPIENT_INTERFACE, 
                req, cs<<8, index, buf, size);
    return rc;
}

void BaseUvc::onResult(uint16_t frame, uint8_t* buf, int len)
{
  if(m_pCbItem && m_pCbMeth)
    (m_pCbItem->*m_pCbMeth)(frame, buf, len);
  else if(m_pCb)
    m_pCb(frame, buf, len);
}

void BaseUvc::setOnResult( void (*pMethod)(uint16_t, uint8_t*, int) )
{
    m_pCb = pMethod;
    m_pCbItem = NULL;
    m_pCbMeth = NULL;
}
    
void BaseUvc::clearOnResult()
{
    m_pCb = NULL;
    m_pCbItem = NULL;
    m_pCbMeth = NULL;
}
