// BaseUsbHostIsoEp.cpp 2013/1/25
#include "mbed.h"
#include "rtos.h"
#include "BaseUsbHost.h"
//#define DEBUG
#include "BaseUsbHostDebug.h"
#define TEST
#include "BaseUsbHostTest.h"

HCITD::HCITD(BaseEp* obj, uint16_t FrameNumber, int FrameCount, uint16_t PacketSize) {
    Control = 0xe0000000           | // CC ConditionCode NOT ACCESSED
             ((FrameCount-1) << 24)| // FC FrameCount
                  TD_DELAY_INT(0)  | // DI DelayInterrupt
                 FrameNumber;        // SF StartingFrame
    BufferPage0 = const_cast<uint8_t*>(buf);
    BufferEnd = const_cast<uint8_t*>(buf) + PacketSize * FrameCount - 1;
    Next = NULL; 
    ep = obj;
    uint32_t addr = reinterpret_cast<uint32_t>(buf);
    for(int i = 0; i < FrameCount; i++) {
        uint16_t offset = addr & 0x0fff;
        if ((addr&0xfffff000) == (reinterpret_cast<uint32_t>(BufferEnd)&0xfffff000)) {
            offset |= 0x1000;
        }
        OffsetPSW[i] = 0xe000|offset;
        addr += PacketSize;
    }
}

IsochronousEp::IsochronousEp(int addr, uint8_t ep, uint16_t size):BaseEp(addr, ep, size)
{
    DBG("%p FA:%d EP:%02X MPS:%d\n", this, addr, ep, size);
    TEST_ASSERT(m_pED);
    
    m_pED->Control |= (1 << 15); // F Format ITD

    TEST_ASSERT(size >= 128 && size <= 1023);
    m_PacketSize = size;
    m_FrameCount = 4; // 1-8
    TEST_ASSERT(m_FrameCount >= 1 && m_FrameCount <= 8);
    m_itd_queue_count = 0;
    reset();
    HCITD* itd = new_HCITD(this);
    m_pED->TailTd = reinterpret_cast<HCTD*>(itd);
    m_pED->HeadTd = reinterpret_cast<HCTD*>(itd); 
    TEST_ASSERT(itd);
    if (itd == NULL) {
        return;
    }
    HCCA* hcca = reinterpret_cast<HCCA*>(LPC_USB->HcHCCA);
    TEST_ASSERT(hcca);
    if (hcca == NULL) {
        return;
    }
    for(int i = 0; i < 32; i++) {
        if (hcca->InterruptTable[i] == NULL) {
            hcca->InterruptTable[i] = m_pED;
        } else {
            HCED* nextEd = hcca->InterruptTable[i];
            while(nextEd->Next && nextEd->Next != m_pED) {
                nextEd = nextEd->Next;
            }
            nextEd->Next = m_pED;
        }
    }
    DBG_ED(m_pED);
}

void IsochronousEp::reset(int delay_ms)
{
    m_FrameNumber = LPC_USB->HcFmNumber + delay_ms;
}

HCITD* IsochronousEp::new_HCITD(BaseEp* obj)
{
    HCITD* itd = new(m_PacketSize*m_FrameCount)HCITD(obj, m_FrameNumber, m_FrameCount, m_PacketSize);
    if (itd == NULL) {
        return NULL;
    } 
    m_FrameNumber += m_FrameCount;
    return itd;
}

HCITD* IsochronousEp::isochronousReveive(int millisec)
{
    TEST_ASSERT(m_itd_queue_count >= 0);
    while(m_itd_queue_count < 3 && m_itd_queue_count < HCTD_QUEUE_SIZE) {
        HCITD* itd = reinterpret_cast<HCITD*>(m_pED->TailTd);
        TEST_ASSERT(itd);
        if (itd == NULL) {
            return NULL;
        }
        HCITD* blank_itd = new_HCITD(this);
        TEST_ASSERT(blank_itd);
        if (blank_itd == NULL) {
            return NULL;
        }
        itd->Next = blank_itd;
        m_pED->TailTd = reinterpret_cast<HCTD*>(blank_itd);
        m_itd_queue_count++;
        //DBG_IED(m_pED);
        enable(); // Enable Periodic
    }
    
    HCITD* itd = get_queue_HCITD(millisec);
    if (itd) {
        m_itd_queue_count--;
    }
    return itd;
}

HCITD* IsochronousEp::get_queue_HCITD(int millisec)
{
    for(int i = 0; i < 16; i++) {
        osEvent evt = m_queue.get(millisec);
        if (evt.status == osEventMessage) {
            HCITD* itd = reinterpret_cast<HCITD*>(evt.value.p);
            TEST_ASSERT(itd);
            return itd;
        } else if (evt.status == osOK) {
            continue;
        } else if (evt.status == osEventTimeout) {
            return NULL;
        } else {
            DBG("evt.status: %02x\n", evt.status);
            TEST_ASSERT(evt.status == osEventMessage);
            return NULL;
        }
    }
    return NULL;
}

void IsochronousEp::enable()
{
    LPC_USB->HcControl |= OR_CONTROL_PLE;
}
