// BaseUsbHostBlkEp.cpp 2013/1/25
#include "mbed.h"
#include "rtos.h"
#include "BaseUsbHost.h"
//#define DEBUG
#include "BaseUsbHostDebug.h"
#define TEST
#include "BaseUsbHostTest.h"

BulkEp::BulkEp(int addr, uint8_t ep, uint16_t size): BaseEp(addr, ep, size)
{
    HCTD* td = new HCTD(this);
    m_pED->TailTd = td;
    m_pED->HeadTd = td; 
    TEST_ASSERT(td);
    if (td == NULL) {
        return;
    }
    m_pED->Next = reinterpret_cast<HCED*>(LPC_USB->HcBulkHeadED);
    LPC_USB->HcBulkHeadED = reinterpret_cast<uint32_t>(m_pED);
  
    DBG_OHCI(LPC_USB->HcBulkHeadED);
    DBG_ED(m_pED);
}

void BulkEp::enable()
{
    LPC_USB->HcCommandStatus |= OR_CMD_STATUS_BLF;
    LPC_USB->HcControl |= OR_CONTROL_BLE;
}

int BulkEp::bulkReceive(uint8_t* buf, int len, int millisec)
{
    return send_receive(buf, len, millisec);
}

int BulkEp::bulkSend(const uint8_t* buf, int len, int millisec)
{
    return send_receive(const_cast<uint8_t*>(buf), len, millisec);
}
