// BaseUsbHostTest.h 2013/1/5
#pragma once

#ifndef CTASSERT
template <bool>struct CtAssert;
template <>struct CtAssert<true> {};
#define CTASSERT(A) CtAssert<A>();
#endif //CTASSERT

#ifdef TEST
#define TEST_ASSERT(A) while(!(A)){fprintf(stderr,"\n\n%s@%d %s ASSERT!\n\n",__PRETTY_FUNCTION__,__LINE__,#A);exit(1);};
#define TEST_ASSERT_TRUE(A) while(!(A)){fprintf(stderr,"\n\n%s@%d %s ASSERT!\n\n",__PRETTY_FUNCTION__,__LINE__,#A);exit(1);};
#define TEST_ASSERT_FALSE(A) while((A)){fprintf(stderr,"\n\n%s@%d %s ASSERT!\n\n",__PRETTY_FUNCTION__,__LINE__,#A);exit(1);};
#define TEST_ASSERT_EQUAL(A,B) while(!(A == B)){fprintf(stderr,"\n\n%s@%d %s ASSERT!\n\n",__PRETTY_FUNCTION__,__LINE__,#A);exit(1);};
#else
#define TEST_ASSERT(A)
#define TEST_ASSERT_TRUE(A) while(0);
#define TEST_ASSERT_FALSE(A) while(0);
#define TEST_ASSERT_EQUAL(A,B) while(0);
#endif
