// MyThread.h 2012/12/9
#ifndef MY_THREAD_H
#define MY_THREAD_H

#define MAGIC_WORD 0xE25A2EA5
static void thread_handler(void const *argument);

class MyThread {
public:
    MyThread() {
        m_stack_size = DEFAULT_STACK_SIZE;
        m_stack_pointer = NULL;
    }
    void set_stack(uint32_t stack_size=DEFAULT_STACK_SIZE, uint8_t* stack_pointer = NULL) {
        m_stack_size = stack_size;
        m_stack_pointer = stack_pointer;
    }
    virtual void run() = 0;
    Thread* start(osPriority priority=osPriorityNormal) {
        if (m_stack_pointer == NULL) {
            m_stack_pointer = reinterpret_cast<uint8_t*>(malloc(m_stack_size));
        }
        for(int i = 0; i < m_stack_size-64; i += 4) {
            *reinterpret_cast<uint32_t*>(m_stack_pointer+i) = MAGIC_WORD;
        }
        return th = new Thread(thread_handler, this, priority, m_stack_size, m_stack_pointer);
    }

    int stack_used() {
        int i;
        for(i = 0; i < m_stack_size; i += 4) {
            if(*reinterpret_cast<uint32_t*>(m_stack_pointer+i) != MAGIC_WORD) {
                break;
            }
        }
        return m_stack_size - i;       
    }

    int stack_size() { return m_stack_size; }
protected:
    Thread* th;
    uint32_t m_stack_size;
    uint8_t* m_stack_pointer;
};
static void thread_handler(void const *argument) {
    MyThread* th = (MyThread*)argument;
    if (th) {
        th->run();
    }    
}

#endif //MY_THREAD_H
