#if 0
//
// split jpeg to bmp files
//
#include "mbed.h"
#include "SimpleJpegDecode.h"
#include "bmp24.h"
#include "uvc.h"
#include "msc.h"

#define ASSERT(A) while(!(A)){fprintf(stderr,"\n\n%s@%d %s ASSERT!\n\n",__PRETTY_FUNCTION__,__LINE__,#A);exit(1);};

DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);
Serial pc(USBTX, USBRX);

SimpleJpegDecode* decode = NULL;
bmp24* bmp = NULL;

int offset_x = 0;
int offset_y = 0;

void callbackRGB(int x, int y, uint8_t* rgb)
{
    led1 = !led1;
    if (bmp) {
        bmp->point(x - offset_x, y - offset_y, rgb);
    }
}

int main() {
    pc.baud(921600);
    printf("%s\n", __FILE__);
    
    msc* usb = new msc("usb");
    int r = usb->setup();
    ASSERT(r == 0);

    bmp = new bmp24;
    ASSERT(bmp);

    decode = new SimpleJpegDecode();
    ASSERT(decode);

    const char* input_file = "/usb/input.jpg";

    FILE *fp = fopen(input_file, "rb");
    ASSERT(fp != NULL);
    Timer benchmark_t;
    benchmark_t.reset();
    benchmark_t.start();
    while(!feof(fp)) {
        int c = fgetc(fp);
        led2 = !led2;
    }
    benchmark_t.stop();
    fclose(fp);
    printf("input: %s, %d ms\n", input_file, benchmark_t.read_ms());
    
    decode->clear();
    fp = fopen(input_file, "rb");
    ASSERT(fp != NULL);
    benchmark_t.reset();
    benchmark_t.start();
    while(!feof(fp)) {
        int c = fgetc(fp);
        decode->input(c);
        led2 = !led2;
    }
    benchmark_t.stop();
    fclose(fp);
    printf("width: %d, height: %d, yblock: %d, %d ms\n", decode->width, decode->height, 
                                                         decode->yblock, benchmark_t.read_ms());

    decode->setOnResult(callbackRGB);
    int n = 0;
    for(offset_y = 0; offset_y < decode->height; offset_y += bmp->height) {
        for(offset_x = 0; offset_x < decode->width; offset_x += bmp->width) {
            bmp->clear();
            decode->clear();
            fp = fopen(input_file, "rb");
            ASSERT(fp != NULL);
            benchmark_t.reset();
            benchmark_t.start();
            while(!feof(fp)) {
                int c = fgetc(fp);
                decode->input(c);
                led2 = !led2;
            }
            benchmark_t.stop();
            fclose(fp);
            char path[32];
            sprintf(path, "/usb/output%02d.bmp", n++);
            printf("offset: (%3d,%3d), size:(%3d,%3d), %s %d ms\n", 
                offset_x, offset_y, bmp->width, bmp->height, 
                path, benchmark_t.read_ms());
            bmp->writeFile(path);
            led3 = !led3;
        }
        led4 = !led4;
    }
    printf("done\n");
    exit(1);     
}
#endif
