#if 1
//
// simple color tracking
//
#include "mbed.h"
#include "BaseJpegDecode.h"
#include "uvc.h"
#include "Terminal.h"

// Logitech C270
#define WIDTH  320
//#define HEIGHT 176

// LifeCam
#define HEIGHT 240

#define THRESHOLD 100

#define ASSERT(A) while(!(A)){fprintf(stderr,"\n\n%s@%d %s ASSERT!\n\n",__PRETTY_FUNCTION__,__LINE__,#A);exit(1);};

DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);
Terminal term(USBTX, USBRX);

class CalcCenter : public BaseJpegDecode {
public:
    int y_center, x_center;
    int m_x_sum, m_y_sum, m_sum;
    int16_t m_buf[WIDTH/16*HEIGHT/8];
    virtual void outputDC(int mcu, int block, int value) {
        if (mcu >= (WIDTH/16*HEIGHT/8)) {
            return;
        }
        if (block == 3) { // 0-1:Y 2:Cb 3:Cr
            value *= qt[1][0];
            ASSERT(value < 32367 && value > -32368);
            m_buf[mcu] = value; // debug
            if (value >= THRESHOLD) { // red
                m_x_sum += value*(mcu%(WIDTH/16));
                m_y_sum += value*(mcu/(WIDTH/16));
                m_sum += value;
            }
        }
    }
    virtual void outputAC(int mcu, int block, int scan, int value){};
    virtual void outputMARK(uint8_t c){
        if (c == 0xd9) { // EOI
            if(m_sum == 0) {
                x_center = y_center = -1; // not found
            } else {
                x_center = m_x_sum / m_sum;
                y_center = m_y_sum / m_sum;
            }
            m_x_sum = m_y_sum = m_sum = 0; // reset
            led2 = !led2;
        }
    };
};

CalcCenter* calc = NULL;

void callback_motion_jpeg(uint16_t frame, uint8_t* buf, int len)
{
    if (calc) {
        calc->input(buf+12, len-12);
    }
    led1 = buf[1]&1; // FID
}

int main() {
    term.baud(921600);
    term.printf("%s\n", __FILE__);

    calc = new CalcCenter;
    ASSERT(calc);
    uvc* cam = new uvc;
    ASSERT(cam);
    cam->SetImageSize(WIDTH, HEIGHT);
    cam->SetFrameInterval(2000000); // 5.0fps
    cam->setOnResult(callback_motion_jpeg);
    ASSERT(cam->setup() >= 0);
    term.cls();
    int fg, old_fg = 0xffffff;
    while(1) {
        int y;
        for(y = 0; y < HEIGHT/8; y++) {
            term.locate(0, y);
            for(int x = 0; x < WIDTH/16; x++) {
                int value = calc->m_buf[y*WIDTH/16+x];
                if (value >= THRESHOLD) {
                    fg = 0xff0000; // red
                } else {
                    fg = 0xffffff; // white
                }
                if (fg != old_fg) {
                    term.foreground(fg);
                    old_fg = fg;
                }
                term.printf("%+4d,", value);
                cam->poll();
            }
        }
        term.locate(0, y);
        term.printf("Cr:(%d,%d)", calc->x_center, calc->y_center);
        cam->wait_ms(500);
        led3 = !led3;
    }
}
#endif
