#ifndef BMP24_H
#define BMP24_H

#define BMP24_WIDTH  (16*4)
#define BMP24_HEIGHT (16*3)

class bmp24 {
public:
    int width;
    int height;

    bmp24() {
        width = BMP24_WIDTH;
        height = BMP24_HEIGHT;
    }
    
    void clear() {
        memset(m_bitmap, 0, sizeof(m_bitmap));
    }
    
    void point(int x, int y, uint8_t* rgb) {
        if (x >= 0 && x < width && y >= 0 && y < height) {
            int pos = y*width*3+x*3;
            m_bitmap[pos++] = rgb[0];
            m_bitmap[pos++] = rgb[1];
            m_bitmap[pos]   = rgb[2];
        }
    }
    
    void LE32write(uint8_t* buf, int value) {
        *buf++ = value & 0xff;
        *buf++ = (value>>8) & 0xff;
        *buf++ = (value>>16) & 0xff;
        *buf   = (value>>24) & 0xff;
    }
    
    void writeFile(const char *path) {
        FILE *fp = fopen(path, "wb");
        if (fp == NULL) {
            return;
        }
        uint8_t header[] = {
0x42,0x4d,0x36,0xe1,0x00,0x00,0x00,0x00,0x00,0x00,0x36,0x00,0x00,0x00,0x28,0x00,
0x00,0x00,0xa0,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x01,0x00,0x18,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
        int file_size = sizeof(header) + sizeof(m_bitmap);
        LE32write(header+2, file_size);
        LE32write(header+18, width);
        LE32write(header+22, height);
        
        fwrite(header, 1, sizeof(header), fp);
        for(int y = height-1; y >=0; y--) {
            for(int x = 0; x < width; x++) {
                fputc(m_bitmap[y*width*3+x*3+2], fp);
                fputc(m_bitmap[y*width*3+x*3+1], fp);
                fputc(m_bitmap[y*width*3+x*3+0], fp);
            }
        }    
        fclose(fp);
    }
    
    uint8_t m_bitmap[BMP24_WIDTH*BMP24_HEIGHT*3];
};

#endif // BMP24_H
