#ifndef BASE_JPEG_DECODE_H
#define BASE_JPEG_DECODE_H
#include "HuffmanDecode.h"
#include "BitPattern.h"

#define JPEG_MCU_YBLOCKS 2

class BaseJpegDecode {
public:
    BaseJpegDecode();
    void clear();
    void input(uint8_t c);
    void input(uint8_t* buf, int len);
    virtual void outputDC(int mcu, int block, int value) = 0;
    virtual void outputAC(int mcu, int block, int scan, int value) = 0;
    virtual void outputMARK(uint8_t c) = 0;
private:
    void inputScan(uint8_t c);
    void restart();
protected:
    int m_seq;
    int m_mcu;
    int m_block;
    int m_scan;
    Huff* m_huff;
    int m_old_DC_value[2];
    BitPattern m_bitpat;
    int m_skip;
    uint8_t m_mark;
    HuffmanDecode* pHD;
    int m_yblocks;
};
#endif // BASE_JPEG_DECODE_H
