#include "mbed.h"
#include "HuffmanDecode.h"
#include "HuffmanCodeTable.h"
#if 1
#define DBG(...) do{fprintf(stderr,"[%s@%d] ",__PRETTY_FUNCTION__,__LINE__);fprintf(stderr,__VA_ARGS__);} while(0);
#define DBG_ASSERT(A) while(!(A)){fprintf(stderr,"\n\n%s@%d %s ASSERT!\n\n",__PRETTY_FUNCTION__,__LINE__,#A);exit(1);};
#else
#define DBG(...)
#define DBG_ASSERT(A) 
#endif

const Huff HT_DC_0[] = {
/* 0 */ {0,0,2,0x0},
/* 1 */ {0,1,3,0x2},
/* 2 */ {0,2,3,0x3},
/* 3 */ {0,3,3,0x4},
/* 4 */ {0,4,3,0x5},
/* 5 */ {0,5,3,0x6},
/* 6 */ {0,6,4,0xe},
/* 7 */ {0,7,5,0x1e},
/* 8 */ {0,8,6,0x3e},
/* 9 */ {0,9,7,0x7e},
/* 10 */ {0,10,8,0xfe},
/* 11 */ {0,11,9,0x1fe},
};
const Huff HT_AC_0[] = {
/* 0 */ {0,1,2,0x0},
/* 1 */ {0,2,2,0x1},
/* 2 */ {0,3,3,0x4},
/* 3 */ {0,0,4,0xa},
/* 4 */ {0,4,4,0xb},
/* 5 */ {1,1,4,0xc},
/* 6 */ {0,5,5,0x1a},
/* 7 */ {1,2,5,0x1b},
/* 8 */ {2,1,5,0x1c},
/* 9 */ {3,1,6,0x3a},
/* 10 */ {4,1,6,0x3b},
/* 11 */ {0,6,7,0x78},
/* 12 */ {1,3,7,0x79},
/* 13 */ {5,1,7,0x7a},
/* 14 */ {6,1,7,0x7b},
/* 15 */ {0,7,8,0xf8},
/* 16 */ {2,2,8,0xf9},
/* 17 */ {7,1,8,0xfa},
/* 18 */ {1,4,9,0x1f6},
/* 19 */ {3,2,9,0x1f7},
/* 20 */ {8,1,9,0x1f8},
/* 21 */ {9,1,9,0x1f9},
/* 22 */ {10,1,9,0x1fa},
/* 23 */ {0,8,10,0x3f6},
/* 24 */ {2,3,10,0x3f7},
/* 25 */ {4,2,10,0x3f8},
/* 26 */ {11,1,10,0x3f9},
/* 27 */ {12,1,10,0x3fa},
/* 28 */ {1,5,11,0x7f6},
/* 29 */ {5,2,11,0x7f7},
/* 30 */ {13,1,11,0x7f8},
/* 31 */ {15,0,11,0x7f9},
/* 32 */ {2,4,12,0xff4},
/* 33 */ {3,3,12,0xff5},
/* 34 */ {6,2,12,0xff6},
/* 35 */ {7,2,12,0xff7},
/* 36 */ {8,2,15,0x7fc0},
/* 37 */ {0,9,16,0xff82},
/* 38 */ {0,10,16,0xff83},
/* 39 */ {1,6,16,0xff84},
/* 40 */ {1,7,16,0xff85},
/* 41 */ {1,8,16,0xff86},
/* 42 */ {1,9,16,0xff87},
/* 43 */ {1,10,16,0xff88},
/* 44 */ {2,5,16,0xff89},
/* 45 */ {2,6,16,0xff8a},
/* 46 */ {2,7,16,0xff8b},
/* 47 */ {2,8,16,0xff8c},
/* 48 */ {2,9,16,0xff8d},
/* 49 */ {2,10,16,0xff8e},
/* 50 */ {3,4,16,0xff8f},
/* 51 */ {3,5,16,0xff90},
/* 52 */ {3,6,16,0xff91},
/* 53 */ {3,7,16,0xff92},
/* 54 */ {3,8,16,0xff93},
/* 55 */ {3,9,16,0xff94},
/* 56 */ {3,10,16,0xff95},
/* 57 */ {4,3,16,0xff96},
/* 58 */ {4,4,16,0xff97},
/* 59 */ {4,5,16,0xff98},
/* 60 */ {4,6,16,0xff99},
/* 61 */ {4,7,16,0xff9a},
/* 62 */ {4,8,16,0xff9b},
/* 63 */ {4,9,16,0xff9c},
/* 64 */ {4,10,16,0xff9d},
/* 65 */ {5,3,16,0xff9e},
/* 66 */ {5,4,16,0xff9f},
/* 67 */ {5,5,16,0xffa0},
/* 68 */ {5,6,16,0xffa1},
/* 69 */ {5,7,16,0xffa2},
/* 70 */ {5,8,16,0xffa3},
/* 71 */ {5,9,16,0xffa4},
/* 72 */ {5,10,16,0xffa5},
/* 73 */ {6,3,16,0xffa6},
/* 74 */ {6,4,16,0xffa7},
/* 75 */ {6,5,16,0xffa8},
/* 76 */ {6,6,16,0xffa9},
/* 77 */ {6,7,16,0xffaa},
/* 78 */ {6,8,16,0xffab},
/* 79 */ {6,9,16,0xffac},
/* 80 */ {6,10,16,0xffad},
/* 81 */ {7,3,16,0xffae},
/* 82 */ {7,4,16,0xffaf},
/* 83 */ {7,5,16,0xffb0},
/* 84 */ {7,6,16,0xffb1},
/* 85 */ {7,7,16,0xffb2},
/* 86 */ {7,8,16,0xffb3},
/* 87 */ {7,9,16,0xffb4},
/* 88 */ {7,10,16,0xffb5},
/* 89 */ {8,3,16,0xffb6},
/* 90 */ {8,4,16,0xffb7},
/* 91 */ {8,5,16,0xffb8},
/* 92 */ {8,6,16,0xffb9},
/* 93 */ {8,7,16,0xffba},
/* 94 */ {8,8,16,0xffbb},
/* 95 */ {8,9,16,0xffbc},
/* 96 */ {8,10,16,0xffbd},
/* 97 */ {9,2,16,0xffbe},
/* 98 */ {9,3,16,0xffbf},
/* 99 */ {9,4,16,0xffc0},
/* 100 */ {9,5,16,0xffc1},
/* 101 */ {9,6,16,0xffc2},
/* 102 */ {9,7,16,0xffc3},
/* 103 */ {9,8,16,0xffc4},
/* 104 */ {9,9,16,0xffc5},
/* 105 */ {9,10,16,0xffc6},
/* 106 */ {10,2,16,0xffc7},
/* 107 */ {10,3,16,0xffc8},
/* 108 */ {10,4,16,0xffc9},
/* 109 */ {10,5,16,0xffca},
/* 110 */ {10,6,16,0xffcb},
/* 111 */ {10,7,16,0xffcc},
/* 112 */ {10,8,16,0xffcd},
/* 113 */ {10,9,16,0xffce},
/* 114 */ {10,10,16,0xffcf},
/* 115 */ {11,2,16,0xffd0},
/* 116 */ {11,3,16,0xffd1},
/* 117 */ {11,4,16,0xffd2},
/* 118 */ {11,5,16,0xffd3},
/* 119 */ {11,6,16,0xffd4},
/* 120 */ {11,7,16,0xffd5},
/* 121 */ {11,8,16,0xffd6},
/* 122 */ {11,9,16,0xffd7},
/* 123 */ {11,10,16,0xffd8},
/* 124 */ {12,2,16,0xffd9},
/* 125 */ {12,3,16,0xffda},
/* 126 */ {12,4,16,0xffdb},
/* 127 */ {12,5,16,0xffdc},
/* 128 */ {12,6,16,0xffdd},
/* 129 */ {12,7,16,0xffde},
/* 130 */ {12,8,16,0xffdf},
/* 131 */ {12,9,16,0xffe0},
/* 132 */ {12,10,16,0xffe1},
/* 133 */ {13,2,16,0xffe2},
/* 134 */ {13,3,16,0xffe3},
/* 135 */ {13,4,16,0xffe4},
/* 136 */ {13,5,16,0xffe5},
/* 137 */ {13,6,16,0xffe6},
/* 138 */ {13,7,16,0xffe7},
/* 139 */ {13,8,16,0xffe8},
/* 140 */ {13,9,16,0xffe9},
/* 141 */ {13,10,16,0xffea},
/* 142 */ {14,1,16,0xffeb},
/* 143 */ {14,2,16,0xffec},
/* 144 */ {14,3,16,0xffed},
/* 145 */ {14,4,16,0xffee},
/* 146 */ {14,5,16,0xffef},
/* 147 */ {14,6,16,0xfff0},
/* 148 */ {14,7,16,0xfff1},
/* 149 */ {14,8,16,0xfff2},
/* 150 */ {14,9,16,0xfff3},
/* 151 */ {14,10,16,0xfff4},
/* 152 */ {15,1,16,0xfff5},
/* 153 */ {15,2,16,0xfff6},
/* 154 */ {15,3,16,0xfff7},
/* 155 */ {15,4,16,0xfff8},
/* 156 */ {15,5,16,0xfff9},
/* 157 */ {15,6,16,0xfffa},
/* 158 */ {15,7,16,0xfffb},
/* 159 */ {15,8,16,0xfffc},
/* 160 */ {15,9,16,0xfffd},
/* 161 */ {15,10,16,0xfffe},
};
const Huff HT_DC_1[] = {
/* 0 */ {0,0,2,0x0},
/* 1 */ {0,1,2,0x1},
/* 2 */ {0,2,2,0x2},
/* 3 */ {0,3,3,0x6},
/* 4 */ {0,4,4,0xe},
/* 5 */ {0,5,5,0x1e},
/* 6 */ {0,6,6,0x3e},
/* 7 */ {0,7,7,0x7e},
/* 8 */ {0,8,8,0xfe},
/* 9 */ {0,9,9,0x1fe},
/* 10 */ {0,10,10,0x3fe},
/* 11 */ {0,11,11,0x7fe},
};
const Huff HT_AC_1[] = {
/* 0 */ {0,0,2,0x0},
/* 1 */ {0,1,2,0x1},
/* 2 */ {0,2,3,0x4},
/* 3 */ {0,3,4,0xa},
/* 4 */ {1,1,4,0xb},
/* 5 */ {0,4,5,0x18},
/* 6 */ {0,5,5,0x19},
/* 7 */ {2,1,5,0x1a},
/* 8 */ {3,1,5,0x1b},
/* 9 */ {0,6,6,0x38},
/* 10 */ {1,2,6,0x39},
/* 11 */ {4,1,6,0x3a},
/* 12 */ {5,1,6,0x3b},
/* 13 */ {0,7,7,0x78},
/* 14 */ {6,1,7,0x79},
/* 15 */ {7,1,7,0x7a},
/* 16 */ {1,3,8,0xf6},
/* 17 */ {2,2,8,0xf7},
/* 18 */ {3,2,8,0xf8},
/* 19 */ {8,1,8,0xf9},
/* 20 */ {0,8,9,0x1f4},
/* 21 */ {1,4,9,0x1f5},
/* 22 */ {4,2,9,0x1f6},
/* 23 */ {9,1,9,0x1f7},
/* 24 */ {10,1,9,0x1f8},
/* 25 */ {11,1,9,0x1f9},
/* 26 */ {12,1,9,0x1fa},
/* 27 */ {0,9,10,0x3f6},
/* 28 */ {2,3,10,0x3f7},
/* 29 */ {3,3,10,0x3f8},
/* 30 */ {5,2,10,0x3f9},
/* 31 */ {15,0,10,0x3fa},
/* 32 */ {1,5,11,0x7f6},
/* 33 */ {6,2,11,0x7f7},
/* 34 */ {7,2,11,0x7f8},
/* 35 */ {13,1,11,0x7f9},
/* 36 */ {0,10,12,0xff4},
/* 37 */ {1,6,12,0xff5},
/* 38 */ {2,4,12,0xff6},
/* 39 */ {3,4,12,0xff7},
/* 40 */ {14,1,14,0x3fe0},
/* 41 */ {2,5,15,0x7fc2},
/* 42 */ {15,1,15,0x7fc3},
/* 43 */ {1,7,16,0xff88},
/* 44 */ {1,8,16,0xff89},
/* 45 */ {1,9,16,0xff8a},
/* 46 */ {1,10,16,0xff8b},
/* 47 */ {2,6,16,0xff8c},
/* 48 */ {2,7,16,0xff8d},
/* 49 */ {2,8,16,0xff8e},
/* 50 */ {2,9,16,0xff8f},
/* 51 */ {2,10,16,0xff90},
/* 52 */ {3,5,16,0xff91},
/* 53 */ {3,6,16,0xff92},
/* 54 */ {3,7,16,0xff93},
/* 55 */ {3,8,16,0xff94},
/* 56 */ {3,9,16,0xff95},
/* 57 */ {3,10,16,0xff96},
/* 58 */ {4,3,16,0xff97},
/* 59 */ {4,4,16,0xff98},
/* 60 */ {4,5,16,0xff99},
/* 61 */ {4,6,16,0xff9a},
/* 62 */ {4,7,16,0xff9b},
/* 63 */ {4,8,16,0xff9c},
/* 64 */ {4,9,16,0xff9d},
/* 65 */ {4,10,16,0xff9e},
/* 66 */ {5,3,16,0xff9f},
/* 67 */ {5,4,16,0xffa0},
/* 68 */ {5,5,16,0xffa1},
/* 69 */ {5,6,16,0xffa2},
/* 70 */ {5,7,16,0xffa3},
/* 71 */ {5,8,16,0xffa4},
/* 72 */ {5,9,16,0xffa5},
/* 73 */ {5,10,16,0xffa6},
/* 74 */ {6,3,16,0xffa7},
/* 75 */ {6,4,16,0xffa8},
/* 76 */ {6,5,16,0xffa9},
/* 77 */ {6,6,16,0xffaa},
/* 78 */ {6,7,16,0xffab},
/* 79 */ {6,8,16,0xffac},
/* 80 */ {6,9,16,0xffad},
/* 81 */ {6,10,16,0xffae},
/* 82 */ {7,3,16,0xffaf},
/* 83 */ {7,4,16,0xffb0},
/* 84 */ {7,5,16,0xffb1},
/* 85 */ {7,6,16,0xffb2},
/* 86 */ {7,7,16,0xffb3},
/* 87 */ {7,8,16,0xffb4},
/* 88 */ {7,9,16,0xffb5},
/* 89 */ {7,10,16,0xffb6},
/* 90 */ {8,2,16,0xffb7},
/* 91 */ {8,3,16,0xffb8},
/* 92 */ {8,4,16,0xffb9},
/* 93 */ {8,5,16,0xffba},
/* 94 */ {8,6,16,0xffbb},
/* 95 */ {8,7,16,0xffbc},
/* 96 */ {8,8,16,0xffbd},
/* 97 */ {8,9,16,0xffbe},
/* 98 */ {8,10,16,0xffbf},
/* 99 */ {9,2,16,0xffc0},
/* 100 */ {9,3,16,0xffc1},
/* 101 */ {9,4,16,0xffc2},
/* 102 */ {9,5,16,0xffc3},
/* 103 */ {9,6,16,0xffc4},
/* 104 */ {9,7,16,0xffc5},
/* 105 */ {9,8,16,0xffc6},
/* 106 */ {9,9,16,0xffc7},
/* 107 */ {9,10,16,0xffc8},
/* 108 */ {10,2,16,0xffc9},
/* 109 */ {10,3,16,0xffca},
/* 110 */ {10,4,16,0xffcb},
/* 111 */ {10,5,16,0xffcc},
/* 112 */ {10,6,16,0xffcd},
/* 113 */ {10,7,16,0xffce},
/* 114 */ {10,8,16,0xffcf},
/* 115 */ {10,9,16,0xffd0},
/* 116 */ {10,10,16,0xffd1},
/* 117 */ {11,2,16,0xffd2},
/* 118 */ {11,3,16,0xffd3},
/* 119 */ {11,4,16,0xffd4},
/* 120 */ {11,5,16,0xffd5},
/* 121 */ {11,6,16,0xffd6},
/* 122 */ {11,7,16,0xffd7},
/* 123 */ {11,8,16,0xffd8},
/* 124 */ {11,9,16,0xffd9},
/* 125 */ {11,10,16,0xffda},
/* 126 */ {12,2,16,0xffdb},
/* 127 */ {12,3,16,0xffdc},
/* 128 */ {12,4,16,0xffdd},
/* 129 */ {12,5,16,0xffde},
/* 130 */ {12,6,16,0xffdf},
/* 131 */ {12,7,16,0xffe0},
/* 132 */ {12,8,16,0xffe1},
/* 133 */ {12,9,16,0xffe2},
/* 134 */ {12,10,16,0xffe3},
/* 135 */ {13,2,16,0xffe4},
/* 136 */ {13,3,16,0xffe5},
/* 137 */ {13,4,16,0xffe6},
/* 138 */ {13,5,16,0xffe7},
/* 139 */ {13,6,16,0xffe8},
/* 140 */ {13,7,16,0xffe9},
/* 141 */ {13,8,16,0xffea},
/* 142 */ {13,9,16,0xffeb},
/* 143 */ {13,10,16,0xffec},
/* 144 */ {14,2,16,0xffed},
/* 145 */ {14,3,16,0xffee},
/* 146 */ {14,4,16,0xffef},
/* 147 */ {14,5,16,0xfff0},
/* 148 */ {14,6,16,0xfff1},
/* 149 */ {14,7,16,0xfff2},
/* 150 */ {14,8,16,0xfff3},
/* 151 */ {14,9,16,0xfff4},
/* 152 */ {14,10,16,0xfff5},
/* 153 */ {15,2,16,0xfff6},
/* 154 */ {15,3,16,0xfff7},
/* 155 */ {15,4,16,0xfff8},
/* 156 */ {15,5,16,0xfff9},
/* 157 */ {15,6,16,0xfffa},
/* 158 */ {15,7,16,0xfffb},
/* 159 */ {15,8,16,0xfffc},
/* 160 */ {15,9,16,0xfffd},
/* 161 */ {15,10,16,0xfffe},
};

Huff* HuffmanDecode::Lookup(int tc, int th, BitPattern* bitpat)
{
    Huff* huff;
    int size;

    if (tc == 0) {
        if (th == 0) {
            huff = (Huff*)HT_DC_0;
            size = sizeof(HT_DC_0) / sizeof(Huff);
        } else {
            huff = (Huff*)HT_DC_1;
            size = sizeof(HT_DC_1) / sizeof(Huff);
        }
    } else {
        if (th == 0) {
            huff = (Huff*)HT_AC_0;
            size = sizeof(HT_AC_0) / sizeof(Huff);
        } else {
            huff = (Huff*)HT_AC_1;
            size = sizeof(HT_AC_1) / sizeof(Huff);
        }
    }

    for(int i = 0; i < size; i++) {
        //DBG("%d %p\n", i, huff);
        if (huff->code_size > bitpat->size()) {
            return NULL;
        }
        BitPattern tmp(huff->code, huff->code_size);
        if (bitpat->match(tmp)) {
            return huff;
        }
        huff++;
    }
    return NULL;
}

struct sthtinfo {
    const Huff* huff_table;
    const uint8_t* index_table;
    int max_code_size;
};

const struct sthtinfo htinfo[2][2] = {
    {{HT_DC_0, HT_DC_0_index,  9}, {HT_DC_1, HT_DC_1_index, 11}},
    {{HT_AC_0, HT_AC_0_index, 16}, {HT_AC_1, HT_AC_1_index, 16}},
};

Huff* HuffmanDecode::Lookup2(int tc, int th, BitPattern* bitpat)
{
    const struct sthtinfo* info = &htinfo[tc][th];

    int pat_size = bitpat->size();
    uint32_t pat = bitpat->peek(pat_size);
    if (pat_size > info->max_code_size) {
        pat >>= (pat_size-info->max_code_size);
    } else if (pat_size < info->max_code_size) {
        pat <<= (info->max_code_size-pat_size);
    }
    int index = info->index_table[pat];
    if (index == 0xff) {
        return NULL;
    }
    Huff* huff = (Huff*)&(info->huff_table[index]);
    if (huff->code_size > pat_size) {
        return NULL;
    }
    return huff;
}

int HuffmanDecode::getValue(Huff* huff, BitPattern* bitpat)
{
    int value = bitpat->get(huff->value_size);
    if (huff->value_size == 0) {
        return 0;
    }
    if (value & (1<<(huff->value_size-1))) {
        return value;
    }
    value -= (1<<huff->value_size)-1;
    return value;
}
