#if 0
#include "mbed.h"
#include "BaseJpegDecode.h"
#include "uvc.h"

#define WIDTH  160
#define HEIGHT 120

//#define WIDTH  320
//#define HEIGHT 240

#define ASSERT(A) while(!(A)){fprintf(stderr,"\n\n%s@%d %s ASSERT!\n\n",__PRETTY_FUNCTION__,__LINE__,#A);exit(1);};

DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);
Serial pc(USBTX, USBRX);

class JpegDecode : public BaseJpegDecode {
public:
    int8_t m_buf[WIDTH/8*HEIGHT/8];
    virtual void outputDC(int mcu, int block, int value) {
        if (mcu < (WIDTH/8*HEIGHT/8/2)) {
            if (block <= 1) { // 0-1:Y 2:Cb 3:Cr
                m_buf[mcu*2+block] = value;
            }
        }
    }
    virtual void outputAC(int mcu, int block, int scan, int value){};
    virtual void outputMARK(uint8_t c){};
};

JpegDecode* decode = NULL;

void callback_motion_jpeg(uint16_t frame, uint8_t* buf, int len)
{
    if (decode) {
        decode->input(buf+12, len-12);
    }
    led1 = buf[1]&1; // FID
}

int main() {
    pc.baud(921600);
    printf("%s\n", __FILE__);

    decode = new JpegDecode;
    ASSERT(decode);
    uvc* cam = new uvc;
    ASSERT(cam);
    cam->SetImageSize(WIDTH, HEIGHT);
    cam->setOnResult(callback_motion_jpeg);
    ASSERT(cam->setup() >= 0);
    while(1) {
        printf("\n"); // start
        for(int y = 0; y < HEIGHT/8; y++) {
            for(int x = 0; x < WIDTH/8; x++) {
                printf("%+4d,", decode->m_buf[y*WIDTH/8+x]);
                cam->poll();
            }
            printf("\n");
        }
        cam->wait_ms(500);
        led2 = !led2;
    }
}
#endif
