#if 0
#include "mbed.h"
#include "BaseJpegDecode.h"
#include <vector>

#define DBG(...) do{fprintf(stderr,"[%s@%d] ",__PRETTY_FUNCTION__,__LINE__);fprintf(stderr,__VA_ARGS__);} while(0);
#define ASSERT(A) while(!(A)){fprintf(stderr,"\n\n%s@%d %s ASSERT!\n\n",__PRETTY_FUNCTION__,__LINE__,#A);exit(1);};

LocalFileSystem local("local");
DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);

class JpegDecode : public BaseJpegDecode {
public:
    JpegDecode();
    virtual void outputDC(int mcu, int block, int value);
    virtual void outputAC(int mcu, int block, int scan, int value);
    virtual void outputMARK(uint8_t c);
    int DC_count;
    int AC_count;
};

JpegDecode::JpegDecode()
{
    DC_count = 0;
    AC_count = 0;
}

void JpegDecode::outputDC(int mcu, int block, int value)
{
    DC_count++;
}

void JpegDecode::outputAC(int mcu, int block, int scan, int value)
{
    AC_count++;
}

void JpegDecode::outputMARK(uint8_t c)
{
}

int main() {
    pc.baud(921600);
    printf("%s\n", __FILE__);

    JpegDecode* decode = new JpegDecode;
    ASSERT(decode);
    while(1) {
        char path[128];
        printf("JPEG file: ");
        gets(path);
        FILE* fp = fopen(path, "rb");
        if (fp == NULL) {
            printf("file open error %s\n", path);
            continue;
        }
        vector<uint8_t> image;
        while(1) {
            int c = fgetc(fp);
            if (c == EOF) {
                break;
            }
            image.push_back(c);
        }
        fclose(fp);
        printf("%s %d bytes\n", path, image.size());
        decode->DC_count = 0;
        decode->AC_count = 0;
        Timer t;
        t.reset();
        t.start();
        decode->clear();    
        for(int i = 0; i < image.size(); i++) {
            decode->input(image[i]);
        }
        t.stop();
        printf("DC: %d AC: %d benchmark: %d ms\n", decode->DC_count, decode->AC_count, t.read_ms());
    }     
}

#endif