#ifndef INVERSE_DCT_TABLE_H
#define INVERSE_DCT_TABLE_H

const int8_t idct_table[] = {
//  0
  64,   64,   64,   64,   64,   64,   64,   64,
  64,   64,   64,   64,   64,   64,   64,   64,
  64,   64,   64,   64,   64,   64,   64,   64,
  64,   64,   64,   64,   64,   64,   64,   64,
  64,   64,   64,   64,   64,   64,   64,   64,
  64,   64,   64,   64,   64,   64,   64,   64,
  64,   64,   64,   64,   64,   64,   64,   64,
  64,   64,   64,   64,   64,   64,   64,   64,
//  1
  89,   75,   50,   18,  -18,  -50,  -75,  -89,
  89,   75,   50,   18,  -18,  -50,  -75,  -89,
  89,   75,   50,   18,  -18,  -50,  -75,  -89,
  89,   75,   50,   18,  -18,  -50,  -75,  -89,
  89,   75,   50,   18,  -18,  -50,  -75,  -89,
  89,   75,   50,   18,  -18,  -50,  -75,  -89,
  89,   75,   50,   18,  -18,  -50,  -75,  -89,
  89,   75,   50,   18,  -18,  -50,  -75,  -89,
//  2
  89,   89,   89,   89,   89,   89,   89,   89,
  75,   75,   75,   75,   75,   75,   75,   75,
  50,   50,   50,   50,   50,   50,   50,   50,
  18,   18,   18,   18,   18,   18,   18,   18,
 -18,  -18,  -18,  -18,  -18,  -18,  -18,  -18,
 -50,  -50,  -50,  -50,  -50,  -50,  -50,  -50,
 -75,  -75,  -75,  -75,  -75,  -75,  -75,  -75,
 -89,  -89,  -89,  -89,  -89,  -89,  -89,  -89,
//  3
  84,   84,   84,   84,   84,   84,   84,   84,
  35,   35,   35,   35,   35,   35,   35,   35,
 -35,  -35,  -35,  -35,  -35,  -35,  -35,  -35,
 -84,  -84,  -84,  -84,  -84,  -84,  -84,  -84,
 -84,  -84,  -84,  -84,  -84,  -84,  -84,  -84,
 -35,  -35,  -35,  -35,  -35,  -35,  -35,  -35,
  35,   35,   35,   35,   35,   35,   35,   35,
  84,   84,   84,   84,   84,   84,   84,   84,
//  4
 123,  104,   70,   24,  -24,  -70, -104, -123,
 104,   88,   59,   21,  -21,  -59,  -88, -104,
  70,   59,   40,   14,  -14,  -40,  -59,  -70,
  24,   21,   14,    5,   -5,  -14,  -21,  -24,
 -24,  -21,  -14,   -5,    5,   14,   21,   24,
 -70,  -59,  -40,  -14,   14,   40,   59,   70,
-104,  -88,  -59,  -21,   21,   59,   88,  104,
-123, -104,  -70,  -24,   24,   70,  104,  123,
//  5
  84,   35,  -35,  -84,  -84,  -35,   35,   84,
  84,   35,  -35,  -84,  -84,  -35,   35,   84,
  84,   35,  -35,  -84,  -84,  -35,   35,   84,
  84,   35,  -35,  -84,  -84,  -35,   35,   84,
  84,   35,  -35,  -84,  -84,  -35,   35,   84,
  84,   35,  -35,  -84,  -84,  -35,   35,   84,
  84,   35,  -35,  -84,  -84,  -35,   35,   84,
  84,   35,  -35,  -84,  -84,  -35,   35,   84,
//  6
  75,  -18,  -89,  -50,   50,   89,   18,  -75,
  75,  -18,  -89,  -50,   50,   89,   18,  -75,
  75,  -18,  -89,  -50,   50,   89,   18,  -75,
  75,  -18,  -89,  -50,   50,   89,   18,  -75,
  75,  -18,  -89,  -50,   50,   89,   18,  -75,
  75,  -18,  -89,  -50,   50,   89,   18,  -75,
  75,  -18,  -89,  -50,   50,   89,   18,  -75,
  75,  -18,  -89,  -50,   50,   89,   18,  -75,
//  7
 116,   48,  -48, -116, -116,  -48,   48,  116,
  98,   41,  -41,  -98,  -98,  -41,   41,   98,
  66,   27,  -27,  -66,  -66,  -27,   27,   66,
  23,   10,  -10,  -23,  -23,  -10,   10,   23,
 -23,  -10,   10,   23,   23,   10,  -10,  -23,
 -66,  -27,   27,   66,   66,   27,  -27,  -66,
 -98,  -41,   41,   98,   98,   41,  -41,  -98,
-116,  -48,   48,  116,  116,   48,  -48, -116,
//  8
 116,   98,   66,   23,  -23,  -66,  -98, -116,
  48,   41,   27,   10,  -10,  -27,  -41,  -48,
 -48,  -41,  -27,  -10,   10,   27,   41,   48,
-116,  -98,  -66,  -23,   23,   66,   98,  116,
-116,  -98,  -66,  -23,   23,   66,   98,  116,
 -48,  -41,  -27,  -10,   10,   27,   41,   48,
  48,   41,   27,   10,  -10,  -27,  -41,  -48,
 116,   98,   66,   23,  -23,  -66,  -98, -116,
//  9
  75,   75,   75,   75,   75,   75,   75,   75,
 -18,  -18,  -18,  -18,  -18,  -18,  -18,  -18,
 -89,  -89,  -89,  -89,  -89,  -89,  -89,  -89,
 -50,  -50,  -50,  -50,  -50,  -50,  -50,  -50,
  50,   50,   50,   50,   50,   50,   50,   50,
  89,   89,   89,   89,   89,   89,   89,   89,
  18,   18,   18,   18,   18,   18,   18,   18,
 -75,  -75,  -75,  -75,  -75,  -75,  -75,  -75,
// 10
  64,   64,   64,   64,   64,   64,   64,   64,
 -64,  -64,  -64,  -64,  -64,  -64,  -64,  -64,
 -64,  -64,  -64,  -64,  -64,  -64,  -64,  -64,
  64,   64,   64,   64,   64,   64,   64,   64,
  64,   64,   64,   64,   64,   64,   64,   64,
 -64,  -64,  -64,  -64,  -64,  -64,  -64,  -64,
 -64,  -64,  -64,  -64,  -64,  -64,  -64,  -64,
  64,   64,   64,   64,   64,   64,   64,   64,
// 11
 104,   88,   59,   21,  -21,  -59,  -88, -104,
 -24,  -21,  -14,   -5,    5,   14,   21,   24,
-123, -104,  -70,  -24,   24,   70,  104,  123,
 -70,  -59,  -40,  -14,   14,   40,   59,   70,
  70,   59,   40,   14,  -14,  -40,  -59,  -70,
 123,  104,   70,   24,  -24,  -70, -104, -123,
  24,   21,   14,    5,   -5,  -14,  -21,  -24,
-104,  -88,  -59,  -21,   21,   59,   88,  104,
// 12
 109,   45,  -45, -109, -109,  -45,   45,  109,
  45,   19,  -19,  -45,  -45,  -19,   19,   45,
 -45,  -19,   19,   45,   45,   19,  -19,  -45,
-109,  -45,   45,  109,  109,   45,  -45, -109,
-109,  -45,   45,  109,  109,   45,  -45, -109,
 -45,  -19,   19,   45,   45,   19,  -19,  -45,
  45,   19,  -19,  -45,  -45,  -19,   19,   45,
 109,   45,  -45, -109, -109,  -45,   45,  109,
// 13
 104,  -24, -123,  -70,   70,  123,   24, -104,
  88,  -21, -104,  -59,   59,  104,   21,  -88,
  59,  -14,  -70,  -40,   40,   70,   14,  -59,
  21,   -5,  -24,  -14,   14,   24,    5,  -21,
 -21,    5,   24,   14,  -14,  -24,   -5,   21,
 -59,   14,   70,   40,  -40,  -70,  -14,   59,
 -88,   21,  104,   59,  -59, -104,  -21,   88,
-104,   24,  123,   70,  -70, -123,  -24,  104,
// 14
  64,  -64,  -64,   64,   64,  -64,  -64,   64,
  64,  -64,  -64,   64,   64,  -64,  -64,   64,
  64,  -64,  -64,   64,   64,  -64,  -64,   64,
  64,  -64,  -64,   64,   64,  -64,  -64,   64,
  64,  -64,  -64,   64,   64,  -64,  -64,   64,
  64,  -64,  -64,   64,   64,  -64,  -64,   64,
  64,  -64,  -64,   64,   64,  -64,  -64,   64,
  64,  -64,  -64,   64,   64,  -64,  -64,   64,
// 15
  50,  -89,   18,   75,  -75,  -18,   89,  -50,
  50,  -89,   18,   75,  -75,  -18,   89,  -50,
  50,  -89,   18,   75,  -75,  -18,   89,  -50,
  50,  -89,   18,   75,  -75,  -18,   89,  -50,
  50,  -89,   18,   75,  -75,  -18,   89,  -50,
  50,  -89,   18,   75,  -75,  -18,   89,  -50,
  50,  -89,   18,   75,  -75,  -18,   89,  -50,
  50,  -89,   18,   75,  -75,  -18,   89,  -50,
// 16
  89,  -89,  -89,   89,   89,  -89,  -89,   89,
  75,  -75,  -75,   75,   75,  -75,  -75,   75,
  50,  -50,  -50,   50,   50,  -50,  -50,   50,
  18,  -18,  -18,   18,   18,  -18,  -18,   18,
 -18,   18,   18,  -18,  -18,   18,   18,  -18,
 -50,   50,   50,  -50,  -50,   50,   50,  -50,
 -75,   75,   75,  -75,  -75,   75,   75,  -75,
 -89,   89,   89,  -89,  -89,   89,   89,  -89,
// 17
  98,  -23, -116,  -66,   66,  116,   23,  -98,
  41,  -10,  -48,  -27,   27,   48,   10,  -41,
 -41,   10,   48,   27,  -27,  -48,  -10,   41,
 -98,   23,  116,   66,  -66, -116,  -23,   98,
 -98,   23,  116,   66,  -66, -116,  -23,   98,
 -41,   10,   48,   27,  -27,  -48,  -10,   41,
  41,  -10,  -48,  -27,   27,   48,   10,  -41,
  98,  -23, -116,  -66,   66,  116,   23,  -98,
// 18
  98,   41,  -41,  -98,  -98,  -41,   41,   98,
 -23,  -10,   10,   23,   23,   10,  -10,  -23,
-116,  -48,   48,  116,  116,   48,  -48, -116,
 -66,  -27,   27,   66,   66,   27,  -27,  -66,
  66,   27,  -27,  -66,  -66,  -27,   27,   66,
 116,   48,  -48, -116, -116,  -48,   48,  116,
  23,   10,  -10,  -23,  -23,  -10,   10,   23,
 -98,  -41,   41,   98,   98,   41,  -41,  -98,
// 19
  89,   75,   50,   18,  -18,  -50,  -75,  -89,
 -89,  -75,  -50,  -18,   18,   50,   75,   89,
 -89,  -75,  -50,  -18,   18,   50,   75,   89,
  89,   75,   50,   18,  -18,  -50,  -75,  -89,
  89,   75,   50,   18,  -18,  -50,  -75,  -89,
 -89,  -75,  -50,  -18,   18,   50,   75,   89,
 -89,  -75,  -50,  -18,   18,   50,   75,   89,
  89,   75,   50,   18,  -18,  -50,  -75,  -89,
// 20
  50,   50,   50,   50,   50,   50,   50,   50,
 -89,  -89,  -89,  -89,  -89,  -89,  -89,  -89,
  18,   18,   18,   18,   18,   18,   18,   18,
  75,   75,   75,   75,   75,   75,   75,   75,
 -75,  -75,  -75,  -75,  -75,  -75,  -75,  -75,
 -18,  -18,  -18,  -18,  -18,  -18,  -18,  -18,
  89,   89,   89,   89,   89,   89,   89,   89,
 -50,  -50,  -50,  -50,  -50,  -50,  -50,  -50,
// 21
  35,   35,   35,   35,   35,   35,   35,   35,
 -84,  -84,  -84,  -84,  -84,  -84,  -84,  -84,
  84,   84,   84,   84,   84,   84,   84,   84,
 -35,  -35,  -35,  -35,  -35,  -35,  -35,  -35,
 -35,  -35,  -35,  -35,  -35,  -35,  -35,  -35,
  84,   84,   84,   84,   84,   84,   84,   84,
 -84,  -84,  -84,  -84,  -84,  -84,  -84,  -84,
  35,   35,   35,   35,   35,   35,   35,   35,
// 22
  70,   59,   40,   14,  -14,  -40,  -59,  -70,
-123, -104,  -70,  -24,   24,   70,  104,  123,
  24,   21,   14,    5,   -5,  -14,  -21,  -24,
 104,   88,   59,   21,  -21,  -59,  -88, -104,
-104,  -88,  -59,  -21,   21,   59,   88,  104,
 -24,  -21,  -14,   -5,    5,   14,   21,   24,
 123,  104,   70,   24,  -24,  -70, -104, -123,
 -70,  -59,  -40,  -14,   14,   40,   59,   70,
// 23
  84,   35,  -35,  -84,  -84,  -35,   35,   84,
 -84,  -35,   35,   84,   84,   35,  -35,  -84,
 -84,  -35,   35,   84,   84,   35,  -35,  -84,
  84,   35,  -35,  -84,  -84,  -35,   35,   84,
  84,   35,  -35,  -84,  -84,  -35,   35,   84,
 -84,  -35,   35,   84,   84,   35,  -35,  -84,
 -84,  -35,   35,   84,   84,   35,  -35,  -84,
  84,   35,  -35,  -84,  -84,  -35,   35,   84,
// 24
  88,  -21, -104,  -59,   59,  104,   21,  -88,
 -21,    5,   24,   14,  -14,  -24,   -5,   21,
-104,   24,  123,   70,  -70, -123,  -24,  104,
 -59,   14,   70,   40,  -40,  -70,  -14,   59,
  59,  -14,  -70,  -40,   40,   70,   14,  -59,
 104,  -24, -123,  -70,   70,  123,   24, -104,
  21,   -5,  -24,  -14,   14,   24,    5,  -21,
 -88,   21,  104,   59,  -59, -104,  -21,   88,
// 25
  84,  -84,  -84,   84,   84,  -84,  -84,   84,
  35,  -35,  -35,   35,   35,  -35,  -35,   35,
 -35,   35,   35,  -35,  -35,   35,   35,  -35,
 -84,   84,   84,  -84,  -84,   84,   84,  -84,
 -84,   84,   84,  -84,  -84,   84,   84,  -84,
 -35,   35,   35,  -35,  -35,   35,   35,  -35,
  35,  -35,  -35,   35,   35,  -35,  -35,   35,
  84,  -84,  -84,   84,   84,  -84,  -84,   84,
// 26
  70, -123,   24,  104, -104,  -24,  123,  -70,
  59, -104,   21,   88,  -88,  -21,  104,  -59,
  40,  -70,   14,   59,  -59,  -14,   70,  -40,
  14,  -24,    5,   21,  -21,   -5,   24,  -14,
 -14,   24,   -5,  -21,   21,    5,  -24,   14,
 -40,   70,  -14,  -59,   59,   14,  -70,   40,
 -59,  104,  -21,  -88,   88,   21, -104,   59,
 -70,  123,  -24, -104,  104,   24, -123,   70,
// 27
  35,  -84,   84,  -35,  -35,   84,  -84,   35,
  35,  -84,   84,  -35,  -35,   84,  -84,   35,
  35,  -84,   84,  -35,  -35,   84,  -84,   35,
  35,  -84,   84,  -35,  -35,   84,  -84,   35,
  35,  -84,   84,  -35,  -35,   84,  -84,   35,
  35,  -84,   84,  -35,  -35,   84,  -84,   35,
  35,  -84,   84,  -35,  -35,   84,  -84,   35,
  35,  -84,   84,  -35,  -35,   84,  -84,   35,
// 28
  18,  -50,   75,  -89,   89,  -75,   50,  -18,
  18,  -50,   75,  -89,   89,  -75,   50,  -18,
  18,  -50,   75,  -89,   89,  -75,   50,  -18,
  18,  -50,   75,  -89,   89,  -75,   50,  -18,
  18,  -50,   75,  -89,   89,  -75,   50,  -18,
  18,  -50,   75,  -89,   89,  -75,   50,  -18,
  18,  -50,   75,  -89,   89,  -75,   50,  -18,
  18,  -50,   75,  -89,   89,  -75,   50,  -18,
// 29
  48, -116,  116,  -48,  -48,  116, -116,   48,
  41,  -98,   98,  -41,  -41,   98,  -98,   41,
  27,  -66,   66,  -27,  -27,   66,  -66,   27,
  10,  -23,   23,  -10,  -10,   23,  -23,   10,
 -10,   23,  -23,   10,   10,  -23,   23,  -10,
 -27,   66,  -66,   27,   27,  -66,   66,  -27,
 -41,   98,  -98,   41,   41,  -98,   98,  -41,
 -48,  116, -116,   48,   48, -116,  116,  -48,
// 30
  66, -116,   23,   98,  -98,  -23,  116,  -66,
  27,  -48,   10,   41,  -41,  -10,   48,  -27,
 -27,   48,  -10,  -41,   41,   10,  -48,   27,
 -66,  116,  -23,  -98,   98,   23, -116,   66,
 -66,  116,  -23,  -98,   98,   23, -116,   66,
 -27,   48,  -10,  -41,   41,   10,  -48,   27,
  27,  -48,   10,   41,  -41,  -10,   48,  -27,
  66, -116,   23,   98,  -98,  -23,  116,  -66,
// 31
  75,  -75,  -75,   75,   75,  -75,  -75,   75,
 -18,   18,   18,  -18,  -18,   18,   18,  -18,
 -89,   89,   89,  -89,  -89,   89,   89,  -89,
 -50,   50,   50,  -50,  -50,   50,   50,  -50,
  50,  -50,  -50,   50,   50,  -50,  -50,   50,
  89,  -89,  -89,   89,   89,  -89,  -89,   89,
  18,  -18,  -18,   18,   18,  -18,  -18,   18,
 -75,   75,   75,  -75,  -75,   75,   75,  -75,
// 32
  75,  -18,  -89,  -50,   50,   89,   18,  -75,
 -75,   18,   89,   50,  -50,  -89,  -18,   75,
 -75,   18,   89,   50,  -50,  -89,  -18,   75,
  75,  -18,  -89,  -50,   50,   89,   18,  -75,
  75,  -18,  -89,  -50,   50,   89,   18,  -75,
 -75,   18,   89,   50,  -50,  -89,  -18,   75,
 -75,   18,   89,   50,  -50,  -89,  -18,   75,
  75,  -18,  -89,  -50,   50,   89,   18,  -75,
// 33
  66,   27,  -27,  -66,  -66,  -27,   27,   66,
-116,  -48,   48,  116,  116,   48,  -48, -116,
  23,   10,  -10,  -23,  -23,  -10,   10,   23,
  98,   41,  -41,  -98,  -98,  -41,   41,   98,
 -98,  -41,   41,   98,   98,   41,  -41,  -98,
 -23,  -10,   10,   23,   23,   10,  -10,  -23,
 116,   48,  -48, -116, -116,  -48,   48,  116,
 -66,  -27,   27,   66,   66,   27,  -27,  -66,
// 34
  48,   41,   27,   10,  -10,  -27,  -41,  -48,
-116,  -98,  -66,  -23,   23,   66,   98,  116,
 116,   98,   66,   23,  -23,  -66,  -98, -116,
 -48,  -41,  -27,  -10,   10,   27,   41,   48,
 -48,  -41,  -27,  -10,   10,   27,   41,   48,
 116,   98,   66,   23,  -23,  -66,  -98, -116,
-116,  -98,  -66,  -23,   23,   66,   98,  116,
  48,   41,   27,   10,  -10,  -27,  -41,  -48,
// 35
  18,   18,   18,   18,   18,   18,   18,   18,
 -50,  -50,  -50,  -50,  -50,  -50,  -50,  -50,
  75,   75,   75,   75,   75,   75,   75,   75,
 -89,  -89,  -89,  -89,  -89,  -89,  -89,  -89,
  89,   89,   89,   89,   89,   89,   89,   89,
 -75,  -75,  -75,  -75,  -75,  -75,  -75,  -75,
  50,   50,   50,   50,   50,   50,   50,   50,
 -18,  -18,  -18,  -18,  -18,  -18,  -18,  -18,
// 36
  24,   21,   14,    5,   -5,  -14,  -21,  -24,
 -70,  -59,  -40,  -14,   14,   40,   59,   70,
 104,   88,   59,   21,  -21,  -59,  -88, -104,
-123, -104,  -70,  -24,   24,   70,  104,  123,
 123,  104,   70,   24,  -24,  -70, -104, -123,
-104,  -88,  -59,  -21,   21,   59,   88,  104,
  70,   59,   40,   14,  -14,  -40,  -59,  -70,
 -24,  -21,  -14,   -5,    5,   14,   21,   24,
// 37
  45,   19,  -19,  -45,  -45,  -19,   19,   45,
-109,  -45,   45,  109,  109,   45,  -45, -109,
 109,   45,  -45, -109, -109,  -45,   45,  109,
 -45,  -19,   19,   45,   45,   19,  -19,  -45,
 -45,  -19,   19,   45,   45,   19,  -19,  -45,
 109,   45,  -45, -109, -109,  -45,   45,  109,
-109,  -45,   45,  109,  109,   45,  -45, -109,
  45,   19,  -19,  -45,  -45,  -19,   19,   45,
// 38
  59,  -14,  -70,  -40,   40,   70,   14,  -59,
-104,   24,  123,   70,  -70, -123,  -24,  104,
  21,   -5,  -24,  -14,   14,   24,    5,  -21,
  88,  -21, -104,  -59,   59,  104,   21,  -88,
 -88,   21,  104,   59,  -59, -104,  -21,   88,
 -21,    5,   24,   14,  -14,  -24,   -5,   21,
 104,  -24, -123,  -70,   70,  123,   24, -104,
 -59,   14,   70,   40,  -40,  -70,  -14,   59,
// 39
  64,  -64,  -64,   64,   64,  -64,  -64,   64,
 -64,   64,   64,  -64,  -64,   64,   64,  -64,
 -64,   64,   64,  -64,  -64,   64,   64,  -64,
  64,  -64,  -64,   64,   64,  -64,  -64,   64,
  64,  -64,  -64,   64,   64,  -64,  -64,   64,
 -64,   64,   64,  -64,  -64,   64,   64,  -64,
 -64,   64,   64,  -64,  -64,   64,   64,  -64,
  64,  -64,  -64,   64,   64,  -64,  -64,   64,
// 40
  59, -104,   21,   88,  -88,  -21,  104,  -59,
 -14,   24,   -5,  -21,   21,    5,  -24,   14,
 -70,  123,  -24, -104,  104,   24, -123,   70,
 -40,   70,  -14,  -59,   59,   14,  -70,   40,
  40,  -70,   14,   59,  -59,  -14,   70,  -40,
  70, -123,   24,  104, -104,  -24,  123,  -70,
  14,  -24,    5,   21,  -21,   -5,   24,  -14,
 -59,  104,  -21,  -88,   88,   21, -104,   59,
// 41
  45, -109,  109,  -45,  -45,  109, -109,   45,
  19,  -45,   45,  -19,  -19,   45,  -45,   19,
 -19,   45,  -45,   19,   19,  -45,   45,  -19,
 -45,  109, -109,   45,   45, -109,  109,  -45,
 -45,  109, -109,   45,   45, -109,  109,  -45,
 -19,   45,  -45,   19,   19,  -45,   45,  -19,
  19,  -45,   45,  -19,  -19,   45,  -45,   19,
  45, -109,  109,  -45,  -45,  109, -109,   45,
// 42
  24,  -70,  104, -123,  123, -104,   70,  -24,
  21,  -59,   88, -104,  104,  -88,   59,  -21,
  14,  -40,   59,  -70,   70,  -59,   40,  -14,
   5,  -14,   21,  -24,   24,  -21,   14,   -5,
  -5,   14,  -21,   24,  -24,   21,  -14,    5,
 -14,   40,  -59,   70,  -70,   59,  -40,   14,
 -21,   59,  -88,  104, -104,   88,  -59,   21,
 -24,   70, -104,  123, -123,  104,  -70,   24,
// 43
  23,  -66,   98, -116,  116,  -98,   66,  -23,
  10,  -27,   41,  -48,   48,  -41,   27,  -10,
 -10,   27,  -41,   48,  -48,   41,  -27,   10,
 -23,   66,  -98,  116, -116,   98,  -66,   23,
 -23,   66,  -98,  116, -116,   98,  -66,   23,
 -10,   27,  -41,   48,  -48,   41,  -27,   10,
  10,  -27,   41,  -48,   48,  -41,   27,  -10,
  23,  -66,   98, -116,  116,  -98,   66,  -23,
// 44
  41,  -98,   98,  -41,  -41,   98,  -98,   41,
 -10,   23,  -23,   10,   10,  -23,   23,  -10,
 -48,  116, -116,   48,   48, -116,  116,  -48,
 -27,   66,  -66,   27,   27,  -66,   66,  -27,
  27,  -66,   66,  -27,  -27,   66,  -66,   27,
  48, -116,  116,  -48,  -48,  116, -116,   48,
  10,  -23,   23,  -10,  -10,   23,  -23,   10,
 -41,   98,  -98,   41,   41,  -98,   98,  -41,
// 45
  50,  -89,   18,   75,  -75,  -18,   89,  -50,
 -50,   89,  -18,  -75,   75,   18,  -89,   50,
 -50,   89,  -18,  -75,   75,   18,  -89,   50,
  50,  -89,   18,   75,  -75,  -18,   89,  -50,
  50,  -89,   18,   75,  -75,  -18,   89,  -50,
 -50,   89,  -18,  -75,   75,   18,  -89,   50,
 -50,   89,  -18,  -75,   75,   18,  -89,   50,
  50,  -89,   18,   75,  -75,  -18,   89,  -50,
// 46
  50,  -50,  -50,   50,   50,  -50,  -50,   50,
 -89,   89,   89,  -89,  -89,   89,   89,  -89,
  18,  -18,  -18,   18,   18,  -18,  -18,   18,
  75,  -75,  -75,   75,   75,  -75,  -75,   75,
 -75,   75,   75,  -75,  -75,   75,   75,  -75,
 -18,   18,   18,  -18,  -18,   18,   18,  -18,
  89,  -89,  -89,   89,   89,  -89,  -89,   89,
 -50,   50,   50,  -50,  -50,   50,   50,  -50,
// 47
  41,  -10,  -48,  -27,   27,   48,   10,  -41,
 -98,   23,  116,   66,  -66, -116,  -23,   98,
  98,  -23, -116,  -66,   66,  116,   23,  -98,
 -41,   10,   48,   27,  -27,  -48,  -10,   41,
 -41,   10,   48,   27,  -27,  -48,  -10,   41,
  98,  -23, -116,  -66,   66,  116,   23,  -98,
 -98,   23,  116,   66,  -66, -116,  -23,   98,
  41,  -10,  -48,  -27,   27,   48,   10,  -41,
// 48
  23,   10,  -10,  -23,  -23,  -10,   10,   23,
 -66,  -27,   27,   66,   66,   27,  -27,  -66,
  98,   41,  -41,  -98,  -98,  -41,   41,   98,
-116,  -48,   48,  116,  116,   48,  -48, -116,
 116,   48,  -48, -116, -116,  -48,   48,  116,
 -98,  -41,   41,   98,   98,   41,  -41,  -98,
  66,   27,  -27,  -66,  -66,  -27,   27,   66,
 -23,  -10,   10,   23,   23,   10,  -10,  -23,
// 49
  21,   -5,  -24,  -14,   14,   24,    5,  -21,
 -59,   14,   70,   40,  -40,  -70,  -14,   59,
  88,  -21, -104,  -59,   59,  104,   21,  -88,
-104,   24,  123,   70,  -70, -123,  -24,  104,
 104,  -24, -123,  -70,   70,  123,   24, -104,
 -88,   21,  104,   59,  -59, -104,  -21,   88,
  59,  -14,  -70,  -40,   40,   70,   14,  -59,
 -21,    5,   24,   14,  -14,  -24,   -5,   21,
// 50
  35,  -35,  -35,   35,   35,  -35,  -35,   35,
 -84,   84,   84,  -84,  -84,   84,   84,  -84,
  84,  -84,  -84,   84,   84,  -84,  -84,   84,
 -35,   35,   35,  -35,  -35,   35,   35,  -35,
 -35,   35,   35,  -35,  -35,   35,   35,  -35,
  84,  -84,  -84,   84,   84,  -84,  -84,   84,
 -84,   84,   84,  -84,  -84,   84,   84,  -84,
  35,  -35,  -35,   35,   35,  -35,  -35,   35,
// 51
  40,  -70,   14,   59,  -59,  -14,   70,  -40,
 -70,  123,  -24, -104,  104,   24, -123,   70,
  14,  -24,    5,   21,  -21,   -5,   24,  -14,
  59, -104,   21,   88,  -88,  -21,  104,  -59,
 -59,  104,  -21,  -88,   88,   21, -104,   59,
 -14,   24,   -5,  -21,   21,    5,  -24,   14,
  70, -123,   24,  104, -104,  -24,  123,  -70,
 -40,   70,  -14,  -59,   59,   14,  -70,   40,
// 52
  35,  -84,   84,  -35,  -35,   84,  -84,   35,
 -35,   84,  -84,   35,   35,  -84,   84,  -35,
 -35,   84,  -84,   35,   35,  -84,   84,  -35,
  35,  -84,   84,  -35,  -35,   84,  -84,   35,
  35,  -84,   84,  -35,  -35,   84,  -84,   35,
 -35,   84,  -84,   35,   35,  -84,   84,  -35,
 -35,   84,  -84,   35,   35,  -84,   84,  -35,
  35,  -84,   84,  -35,  -35,   84,  -84,   35,
// 53
  21,  -59,   88, -104,  104,  -88,   59,  -21,
  -5,   14,  -21,   24,  -24,   21,  -14,    5,
 -24,   70, -104,  123, -123,  104,  -70,   24,
 -14,   40,  -59,   70,  -70,   59,  -40,   14,
  14,  -40,   59,  -70,   70,  -59,   40,  -14,
  24,  -70,  104, -123,  123, -104,   70,  -24,
   5,  -14,   21,  -24,   24,  -21,   14,   -5,
 -21,   59,  -88,  104, -104,   88,  -59,   21,
// 54
  18,  -50,   75,  -89,   89,  -75,   50,  -18,
 -18,   50,  -75,   89,  -89,   75,  -50,   18,
 -18,   50,  -75,   89,  -89,   75,  -50,   18,
  18,  -50,   75,  -89,   89,  -75,   50,  -18,
  18,  -50,   75,  -89,   89,  -75,   50,  -18,
 -18,   50,  -75,   89,  -89,   75,  -50,   18,
 -18,   50,  -75,   89,  -89,   75,  -50,   18,
  18,  -50,   75,  -89,   89,  -75,   50,  -18,
// 55
  27,  -66,   66,  -27,  -27,   66,  -66,   27,
 -48,  116, -116,   48,   48, -116,  116,  -48,
  10,  -23,   23,  -10,  -10,   23,  -23,   10,
  41,  -98,   98,  -41,  -41,   98,  -98,   41,
 -41,   98,  -98,   41,   41,  -98,   98,  -41,
 -10,   23,  -23,   10,   10,  -23,   23,  -10,
  48, -116,  116,  -48,  -48,  116, -116,   48,
 -27,   66,  -66,   27,   27,  -66,   66,  -27,
// 56
  27,  -48,   10,   41,  -41,  -10,   48,  -27,
 -66,  116,  -23,  -98,   98,   23, -116,   66,
  66, -116,   23,   98,  -98,  -23,  116,  -66,
 -27,   48,  -10,  -41,   41,   10,  -48,   27,
 -27,   48,  -10,  -41,   41,   10,  -48,   27,
  66, -116,   23,   98,  -98,  -23,  116,  -66,
 -66,  116,  -23,  -98,   98,   23, -116,   66,
  27,  -48,   10,   41,  -41,  -10,   48,  -27,
// 57
  18,  -18,  -18,   18,   18,  -18,  -18,   18,
 -50,   50,   50,  -50,  -50,   50,   50,  -50,
  75,  -75,  -75,   75,   75,  -75,  -75,   75,
 -89,   89,   89,  -89,  -89,   89,   89,  -89,
  89,  -89,  -89,   89,   89,  -89,  -89,   89,
 -75,   75,   75,  -75,  -75,   75,   75,  -75,
  50,  -50,  -50,   50,   50,  -50,  -50,   50,
 -18,   18,   18,  -18,  -18,   18,   18,  -18,
// 58
  14,  -24,    5,   21,  -21,   -5,   24,  -14,
 -40,   70,  -14,  -59,   59,   14,  -70,   40,
  59, -104,   21,   88,  -88,  -21,  104,  -59,
 -70,  123,  -24, -104,  104,   24, -123,   70,
  70, -123,   24,  104, -104,  -24,  123,  -70,
 -59,  104,  -21,  -88,   88,   21, -104,   59,
  40,  -70,   14,   59,  -59,  -14,   70,  -40,
 -14,   24,   -5,  -21,   21,    5,  -24,   14,
// 59
  19,  -45,   45,  -19,  -19,   45,  -45,   19,
 -45,  109, -109,   45,   45, -109,  109,  -45,
  45, -109,  109,  -45,  -45,  109, -109,   45,
 -19,   45,  -45,   19,   19,  -45,   45,  -19,
 -19,   45,  -45,   19,   19,  -45,   45,  -19,
  45, -109,  109,  -45,  -45,  109, -109,   45,
 -45,  109, -109,   45,   45, -109,  109,  -45,
  19,  -45,   45,  -19,  -19,   45,  -45,   19,
// 60
  14,  -40,   59,  -70,   70,  -59,   40,  -14,
 -24,   70, -104,  123, -123,  104,  -70,   24,
   5,  -14,   21,  -24,   24,  -21,   14,   -5,
  21,  -59,   88, -104,  104,  -88,   59,  -21,
 -21,   59,  -88,  104, -104,   88,  -59,   21,
  -5,   14,  -21,   24,  -24,   21,  -14,    5,
  24,  -70,  104, -123,  123, -104,   70,  -24,
 -14,   40,  -59,   70,  -70,   59,  -40,   14,
// 61
  10,  -27,   41,  -48,   48,  -41,   27,  -10,
 -23,   66,  -98,  116, -116,   98,  -66,   23,
  23,  -66,   98, -116,  116,  -98,   66,  -23,
 -10,   27,  -41,   48,  -48,   41,  -27,   10,
 -10,   27,  -41,   48,  -48,   41,  -27,   10,
  23,  -66,   98, -116,  116,  -98,   66,  -23,
 -23,   66,  -98,  116, -116,   98,  -66,   23,
  10,  -27,   41,  -48,   48,  -41,   27,  -10,
// 62
  10,  -23,   23,  -10,  -10,   23,  -23,   10,
 -27,   66,  -66,   27,   27,  -66,   66,  -27,
  41,  -98,   98,  -41,  -41,   98,  -98,   41,
 -48,  116, -116,   48,   48, -116,  116,  -48,
  48, -116,  116,  -48,  -48,  116, -116,   48,
 -41,   98,  -98,   41,   41,  -98,   98,  -41,
  27,  -66,   66,  -27,  -27,   66,  -66,   27,
 -10,   23,  -23,   10,   10,  -23,   23,  -10,
// 63
   5,  -14,   21,  -24,   24,  -21,   14,   -5,
 -14,   40,  -59,   70,  -70,   59,  -40,   14,
  21,  -59,   88, -104,  104,  -88,   59,  -21,
 -24,   70, -104,  123, -123,  104,  -70,   24,
  24,  -70,  104, -123,  123, -104,   70,  -24,
 -21,   59,  -88,  104, -104,   88,  -59,   21,
  14,  -40,   59,  -70,   70,  -59,   40,  -14,
  -5,   14,  -21,   24,  -24,   21,  -14,    5,
};

#endif // INVERSE_DCT_TABLE_H