#if 0
//*****************************************************************************
//
// led_counter demo - uses the BTstack run loop to blink an LED
//
//*****************************************************************************
#include "mbed.h"
#include <btstack/run_loop.h>

Serial pc(USBTX, USBRX);
DigitalOut led1(LED1), led2(LED2);

#define HEARTBEAT_PERIOD_MS 1000

static void  heartbeat_handler(struct timer *ts){

    // increment counter
    static int counter = 0;
    char lineBuffer[30];
    sprintf(lineBuffer, "BTstack counter %04u\n\r", ++counter);
    printf(lineBuffer);
    
    // toggle LED
    led2 = !led2;
    
    run_loop_set_timer(ts, HEARTBEAT_PERIOD_MS);
    run_loop_add_timer(ts);
} 

// main
int main(void)
{
    pc.baud(921600);
    printf("%s\n", __FILE__);

    // init LEDs
    led1 = led2 = 1;
    
    /// GET STARTED with BTstack ///
    run_loop_init(RUN_LOOP_EMBEDDED);
        
    // set one-shot timer
    timer_source_t heartbeat;
    heartbeat.process = &heartbeat_handler;
    run_loop_set_timer(&heartbeat, HEARTBEAT_PERIOD_MS);
    run_loop_add_timer(&heartbeat);
    
    printf("Run...\n\r");

    // go!
    run_loop_execute();    
    
    // happy compiler!
    return 0;
}
#endif