/*mobile project 
GROUP MEMBERS:
1)UWIZEYIMANA ABDULKARIM REG NBER:220020691
2)AMOUR SALIM MOHAMMED REG NBER: 221027397
3)SHAAME M. BAKAR      REG NBER: 220020578
4)UMUGWANEZA ANGELIQUE REG NBER: 221004229*/
 
#include "mbed.h"
#include "C12832.h"
#include "mbed_trace.h"
#include "mbed_events.h"
#include "LoRaWANInterface.h"
#include "Sht31.h"
#include "SX1276_LoRaRadio.h"
#include <string>
#include "time.h"
 time_t startTime;
 time_t stopTime;
 time_t startReading;
 time_t  stopReading;
 int  readingDuration;
Serial device (p9,p10);
C12832 lcd(SPI_MOSI, SPI_SCK, SPI_MISO, p8, p11);
Sht31 theo(I2C_SDA, I2C_SCL);
DigitalOut led(p13);
DigitalOut bed(p12);
DigitalOut wed(p14);
InterruptIn  btn(p15);
InterruptIn  swt(p11);
Timeout t;
Ticker k;
Ticker topicTicker;
Ticker durationTime;
Ticker resetted;
int direction=0;
int i=0;
int pushDuration;
int Situation=0;
int state=0;
 
string str1 = "Menu of the Day";
string str2 = "Welcome to Rwanda Food\n Services Ltd";
string str3="Rwanda Food Services Ltd,click Btn to browseMenu";
string topics[]={"1.Out Side catering services",
"2.Restaurent Services","3.fast Food Services",
"4.Online ordering Food Services",
"5.Cook Training Services "
};
string content[]={"11.online bookings buffet\n package for 80+ guests   with\t 10 percent off",
"22.Pilawo,\t biriyani,\n African food,\t western food","33.fried chicken with salad,\nfried fish with salad,\nNyama choma",
"44.African food,\t westen food,\t fast food,\t pilawo,\t biriyani",
"55.bread,\t samosa cooking and\t smoothies preparation "
};
// Device credentials, register device as OTAA in The Things Network and copy credentials here
static uint8_t DEV_EUI[] = { 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18 };
static uint8_t APP_EUI[] = { 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18 };
static uint8_t APP_KEY[] = { 0x51, 0xEA, 0x6E, 0x8B, 0x30, 0x44, 0xE6, 0x4A, 0xBD, 0xD3, 0xFD, 0xD0, 0x4A, 0x1C, 0x4D, 0x2F };


// The port we're sending and receiving on
#define MBED_CONF_LORA_APP_PORT     15

// Peripherals (LoRa radio, temperature sensor and button)
SX1276_LoRaRadio radio(D11, D12, D13, D10, A0, D2, D3, D4, D5, D8, D9, NC, NC, NC, NC, A4, NC, NC);
Sht31 sht31(I2C_SDA, I2C_SCL);


// EventQueue is required to dispatch events around
static EventQueue ev_queue;

// Constructing Mbed LoRaWANInterface and passing it down the radio object.
static LoRaWANInterface lorawan(radio);

// Application specific callbacks
static lorawan_app_callbacks_t callbacks;

// LoRaWAN stack event handler
static void lora_event_handler(lorawan_event_t event);
//function to enable display to work
void display(string sms){
    lcd.cls(); // change dane here
    lcd.locate(0,0);
    lcd.printf(sms.c_str());
}
 //function to display time and temp
void PrintState1(){
        float temp = theo.readTemperature();
        time_t seconds = time(NULL);
        char buffer[32];
        strftime(buffer, 32, "%I:%M %p\n", localtime(&seconds));
        lcd.locate(5, 20); // get cursor to position x=3px and y=5px
        lcd.cls(); 
        lcd.set_auto_up(0);
        lcd.locate(5, 1);
        lcd.printf("Local Time: %s",buffer);
        lcd.locate(5, 9);
        lcd.printf("Temperature: %.2f C", temp);
} 
 //function to blink white led
 void whiteled()
{
    wed=!wed;
}
//message to display when in forward mode
void forwards(){
   display(topics[i]);
   Situation=i;
   i+=1;
   if(i>4){
       i=0;
   }
}
//message to display in backward mode
void backwards(){
  display(topics[i]);
  Situation=i;
  i-=1;
  if(i<0){
      i=4;
  }
}
//direction control function
void PrintState2(){
     if(direction==0){
         i=0;
          bed=1;
    led=0;
         topicTicker.attach(ev_queue.event(&forwards),2.0f);
     }
     else{
         i=4;
  led=1;
   bed=0;
         topicTicker.attach(ev_queue.event(& backwards),2.0f);
     }
 }
 //message to call when button has been let go
  void fallBtn(){
     state = 0;
     durationTime.detach();
 
 }
 //message to display after welcome message on the screen
 void mode1(){
    k.attach(ev_queue.event(& whiteled),1.0f);
     PrintState1();
     t.attach(ev_queue.event(&PrintState2),3.0f);
    
 }
 //message to be displayed on the screen while on start up
 void welcomeMsg(){
    display(str2);
    t.attach(ev_queue.event(&mode1),5.0f);
}
  //message to call when switch is rised
void riseSwt(){
    time(&startReading);
     display(content[Situation]);
    topicTicker.detach();
}
// declaration messages to be sent on the cloud 
 static uint8_t* create_message(char device[], int topic, int duration) {
     // initialize the buffer
     uint8_t tx_buffer[50] = { 0 };
     // Writing string data into a buffer
     sprintf((char*) tx_buffer, "{\"device\":\"%s\",\"topic\":%d,\"duration\":%d }", device, topic,duration);
     return tx_buffer;
}
// Send a message over LoRaWAN
static void send_message(uint8_t *tx_buffer) {
   
    int packet_len = strlen((char*) tx_buffer);

    printf("Sending %d bytes: \"%s\"\n", packet_len, tx_buffer);


    int16_t retcode = lorawan.send(MBED_CONF_LORA_APP_PORT, tx_buffer, packet_len, MSG_UNCONFIRMED_FLAG);

    // for some reason send() returns -1... I cannot find out why, the stack returns the right number. I feel that this is some weird Emscripten quirk
    if (retcode < 0) {
        retcode == LORAWAN_STATUS_WOULD_BLOCK ? printf("send - duty cycle violation\n")
                : printf("send() - Error code %d\n", retcode);
        return;
    }

    printf("%d bytes scheduled for transmission\n", retcode);
}
//action to be processed when the button has been let go
void fallSwt(){
    topicTicker.detach();
    time(&stopReading);
    readingDuration=stopReading-startReading;
    printf("Reading time is:%d \n",readingDuration);
    if(readingDuration>5){
        
        printf("message sent,Item Id is:%d \n",Situation+1);
       char device[] = "mobile";
      int topic = Situation+1; // topic identifier
    
        send_message(create_message(device,topic,readingDuration));
        
    }
    PrintState2();    
}
//count how long the button have been pushed
void countDuration(){
     time(&stopTime);
         pushDuration=stopTime-startTime;
            if(pushDuration>5){
            display("System resetting......\n");
            durationTime.detach();
             topicTicker.detach();
              direction=!direction;
            resetted.attach(ev_queue.event(&welcomeMsg),10.0f);
            }
        else if(pushDuration>=3 && state==0 ){
             state =1;
             direction=!direction;
             PrintState2();
         }
 }
 //action to be done when button is pushed
 void riseBtn(){
     time(&startTime);
     durationTime.attach(ev_queue.event(&countDuration),0.5f);
 
 }

int main() {
    
   
    if (DEV_EUI[0] == 0x0 && DEV_EUI[1] == 0x0 && DEV_EUI[2] == 0x0 && DEV_EUI[3] == 0x0 && DEV_EUI[4] == 0x0 && DEV_EUI[5] == 0x0 && DEV_EUI[6] == 0x0 && DEV_EUI[7] == 0x0) {
        printf("Set your LoRaWAN credentials first!\n");
        return -1;
    }
    mbed_trace_init();

    if (lorawan.initialize(&ev_queue) != LORAWAN_STATUS_OK) {
        printf("LoRa initialization failed!\n");
        return -1;
    }

    // Fire a message when the button is pressed
    //btn.fall(ev_queue.event(&send_data_button_isr));
      btn.rise(ev_queue.event(&riseBtn));
     btn.fall(ev_queue.event(&fallBtn));
     swt.rise(ev_queue.event(&riseSwt));
     swt.fall(ev_queue.event(&fallSwt));

    // prepare application callbacks
    callbacks.events = mbed::callback(lora_event_handler);
    lorawan.add_app_callbacks(&callbacks);

    // Disable adaptive data rating
    if (lorawan.disable_adaptive_datarate() != LORAWAN_STATUS_OK) {
        printf("disable_adaptive_datarate failed!\n");
        return -1;
    }

    lorawan.set_datarate(5); // SF7BW125

    lorawan_connect_t connect_params;
    connect_params.connect_type = LORAWAN_CONNECTION_OTAA;
    connect_params.connection_u.otaa.dev_eui = DEV_EUI;
    connect_params.connection_u.otaa.app_eui = APP_EUI;
    connect_params.connection_u.otaa.app_key = APP_KEY;
    connect_params.connection_u.otaa.nb_trials = 3;

    lorawan_status_t retcode = lorawan.connect(connect_params);

    if (retcode == LORAWAN_STATUS_OK ||
        retcode == LORAWAN_STATUS_CONNECT_IN_PROGRESS) {
    } else {
        printf("Connection error, code = %d\n", retcode);
        return -1;
    }

    printf("Connection - In Progress ...\r\n");
    display("Connection - In Progress ...\r\nPlease wait...");

    // make your event queue dispatching events forever
    ev_queue.dispatch_forever();

    return 0;
}

// This is called from RX_DONE, so whenever a message came in
static void receive_message()
{
    uint8_t rx_buffer[50] = { 0 };
    int16_t retcode;
    retcode = lorawan.receive(MBED_CONF_LORA_APP_PORT, rx_buffer,
                              sizeof(rx_buffer),
                              MSG_CONFIRMED_FLAG|MSG_UNCONFIRMED_FLAG);

    if (retcode < 0) {
        printf("receive() - Error code %d\n", retcode);
        return;
    }

    printf("Data received on port %d (length %d): ", MBED_CONF_LORA_APP_PORT, retcode);

    for (uint8_t i = 0; i < retcode; i++) {
        printf("%02x ", rx_buffer[i]);
    }
    printf("\n");
}

// Event handler
static void lora_event_handler(lorawan_event_t event) {
    switch (event) {
        case CONNECTED:
            printf("Connection - Successful\n");
            display("Connection - Successful\n");
            wait_ms(3000);
                welcomeMsg();

            break;
        case DISCONNECTED:
            ev_queue.break_dispatch();
            printf("unable to connect\n");
            display("unable to connect\n");
            break;
        case TX_DONE:
            printf("Message Sent to Network Server\n");
            break;
        case TX_TIMEOUT:
        case TX_ERROR:
        case TX_CRYPTO_ERROR:
        case TX_SCHEDULING_ERROR:
            printf("Transmission Error - EventCode = %d\n", event);
            break;
        case RX_DONE:
            printf("Received message from Network Server\n");
            receive_message();
            break;
        case RX_TIMEOUT:
        case RX_ERROR:
            printf("Error in reception - Code = %d\n", event);
            break;
        case JOIN_FAILURE:
            printf("OTAA Failed - Check Keys\n");
            break;
        default:
            MBED_ASSERT("Unknown Event");
    }
}
