#include "mbed.h"
#include "ExtendedTimer.h"
#include "SDFileSystem.h"
#include "ISL29125.h"
#include "RGB_Sensor.h"

Serial pc(USBTX, USBRX);

//setting up sd card
SDFileSystem sd(p5, p6, p7, p8, "drive");

DigitalOut Alarm(p21);

//UV Sensors are connected to p15 and p16
AnalogIn UVSensor1(p15);
AnalogIn UVSensor2(p16);

//PV cells connected to p20
AnalogIn PV(p20);

//Temperature sensor; connected to p28 and p27 (with UVSensor2)
I2C tempsensor(p28, p27);
const int addr = 0x90;
char config_t[3];
char temp_read[2];
float temp;

//setting up the timer
ExtendedTimer t;

int main(){
    t.start();//starts the timer
    int alarmCount = 0;
    //Filesystem setting
    bool mountFailure = sd.mount();
    if (mountFailure !=0){
        pc.printf("Failed to mount the SD card.\r\n");
        return -1;
    }

    FILE* fp = fopen("/drive/data.txt", "a"); //"a" is for append
    if (fp == NULL){
        pc.printf("Failed to open file.\r\n");
        sd.unmount();
        return -1;
    }
    
    //Temperature Sensor settings
    config_t[0] = 0x01;
    config_t[1] = 0x60;
    config_t[2] = 0xA0;
    tempsensor.write(addr, config_t, 3);
    config_t[0] = 0x00;
    tempsensor.write(addr, config_t, 1);
    
    //For Red Green Blue values
    uint16_t rgb1[3];
    uint16_t rgb2[3];
    
    pc.printf("Time\tTemp\tUV1\tUV2\tR1\tG1\tB1\tR2\tG2\tB2\tPV\r\n");//printing out titles
    fprintf(fp, "Time\tTemp\tUV1\tUV2\tR1\tG1\tB1\tR2\tG2\tB2\tPV\r\n");
    while(1){
        if ((t.read_ms()%1000)==0){
            tempsensor.read(addr, temp_read, 2);
            temp = 0.0625 * (((temp_read[0] << 8) + temp_read[1]) >> 4);
            if(temp>120){
                temp = temp-256+0.0625;
            }
            pc.printf("%d\t%.2f\t", t.read_ms()/1000, temp);
            fprintf(fp, "%d\t%.2f\t", t.read_ms()/1000, temp);
            pc.printf("%.4f\t%.4f", UVSensor1.read(), UVSensor2.read());
            fprintf(fp, "%.4f\t%.4f", UVSensor1.read(), UVSensor2.read());
            get_rgb1(rgb1);
            get_rgb2(rgb2);
            pc.printf("\t%d\t%d\t%d\t%d\t%d\t%d\t%.4f\r\n", rgb1[0], rgb1[1], rgb1[2], rgb2[0], rgb2[1], rgb2[2], PV.read());
            fprintf(fp, "\t%d\t%d\t%d\t%d\t%d\t%d\t%.4f\r\n", rgb1[0], rgb1[1], rgb1[2], rgb2[0], rgb2[1], rgb2[2], PV.read());
            
            if (alarmCount>36){
                while(1)
                {
                    Alarm = 1;
                    wait(0.1);
                    Alarm = 0;
                    wait(0.5);
                }
            }
            
            int tempTime = t.read_ms()%300000;
            if (tempTime < 10000){
                alarmCount++;
                fclose(fp);
                FILE* fp = fopen("/drive/data.txt", "a");
                pc.printf("File reopen...\r\n");  
            }
        }
    }
    fclose(fp);
    sd.unmount();
}