// twitter client test
// written by utaani@ueno.org

#include "mbed.h"
#include "HTTPClient.h"
#define DEBUG

DigitalOut led(LED1);    // for finised indicator
HTTPClient http;         // twitter client

#ifdef DEBUG
Serial pc(USBTX, USBRX); // for debug
#endif

AnalogIn seed(p15);      // for random seed

const char user[] = "username";
const char pass[] = "password";
const char url[]  = "http://twitter.com/statuses/update.xml";

int main(void) {
    char response[4096]; // buffer for results
    char msg[1024];      // buffer for messages
    int  result,i;
    
    srand(seed.read_u16()); // init random with AnalogIn (for multipul post)
    sprintf(msg, "status=This is test from mbed.(%d)", rand()%100); // make message

    #ifdef DEBUG
    pc.printf("started\r\n"); 
    #endif

    http.auth(user, pass);
    result = http.post(url, msg, response, 4096);

    #ifdef DEBUG
    pc.printf("result=%d\r\n",result);
    for(i=0;i<result;i++) {
     pc.putc(response[i]);
    }
    pc.printf("\r\n");
    #endif    

    // finished loop
    while(1) {
        led = !led;
        wait(0.2);
    }
}
