#include "mbed.h"
#include "USBKeyboard.h"
#include "joystick.h"
 
DebounceIn Up(p19);
DebounceIn Down(D2);
DebounceIn Left(D3);
DebounceIn Right(D4);
DebounceIn Jump(p16);
DebounceIn Fire1(p17);
DebounceIn Fire2(D7);

BusOut leds(LED1, LED2, LED3);
 
//USBKeyboard
USBKeyboard keyboard;

//Serial uart(USBTX, USBRX);
Serial uart(p28, p27); 
GPIOJoystick joy; 
 
int main(void) {
    uart.baud(57600);
    uart.putc('A');
    int k = 0 ;
    while(k<3) {

        //Printf is also completely supported
        int i = 100;
        float f = 0.5;
        char h = 0x05;
        uart.printf("i = %d, f = %f, h = %02X \r\n", i, f, h);
        wait(3);
        k++;
    }
    wait(2);
    joy.init();
} 
