#include "mbed.h"
#include "USBKeyboard.h"

/*
* Supported Event Types
*/
enum events{
    MOVE_UP,    //up arrow event
    MOVE_DOWN,  //down arrow event
    MOVE_LEFT,  //left arrow event
    MOVE_RIGHT, //right arrow event
    FIRE1,      //CTRL key event
    FIRE2,
    JUMP,       //ALT key event
    COIN1,      //5 key event
    START,      //1 key event
    BACK,       //ESC key event
    USER,       //ESC key event
    PASS,       //ESC key event
    RUN

};

/*
* USB/device wrapper for Keyboard
* handles signals from josytick and route them to correspoding 
* device USB master/host. 
* 
*/
class SignalRouter
{
private:
    USBKeyboard* kdev;
public:
    SignalRouter(USBKeyboard& dev);
    
    /*
    *routes specific keboard event
    */
    void sendEvent(int event);

};