#include "joystick.h"

//#define DELAY_ENABLED 1

SerialJoystick::SerialJoystick()
{

}

void SerialJoystick::init()
{
    bool quit = false ;
    while(1) {
        char ch = uart.getc();
        switch(ch) {
            case 'a':
                pressLeft();
                break;
            case 's':
                pressDown();
                break;
            case 'd':
                pressRight();
                break;
            case 'w':
                pressUp();
                break;
            case ' ':
                pressJump();
                break;
            case 'n':
                pressFire1();
                break;
            case 'm':
                pressFire2();
                break;
            case '\n':
                pressMenuSelect1();
                break;
            case '\r':
                pressMenuSelect1();
                break;
            case '1':
                pressMenuSelect2();
                break;
            case 0x1b:
                pressMenuSelect3();
                break;
            case 'u':
                uart.printf("pi\r\n");
                router.sendEvent(USER);
                break;
            case 'p':
                uart.printf("raspberry\r\n");
                router.sendEvent(PASS);
                break;
            case 'k':
                uart.printf("/home/pi/mame/mame4all_comp/mame_run/mame  \r\n");
                router.sendEvent(RUN);
                break;
            case 'q':
                uart.printf("Quitting now !! \r\n");
                quit = true ;
                break;

        }
        if(quit) break;
    }
}

void SerialJoystick::pressMenuSelect1()
{
    uart.printf("Pressed Select Coins \r\n");
    #ifdef DELAY_ENABLED
    wait(5);
    #endif
    router.sendEvent(COIN1);
}

void SerialJoystick::pressMenuSelect2()
{
    uart.printf("Pressed Start \r\n");
    #ifdef DELAY_ENABLED
    wait(5);
    #endif
    router.sendEvent(START);
}

void SerialJoystick::pressMenuSelect3()
{
    uart.printf("Pressed Back \r\n");
    #ifdef DELAY_ENABLED
    wait(5);
    #endif
    router.sendEvent(BACK);
}

void SerialJoystick::pressUp()
{
    uart.printf("Pressed Up \r\n");
    #ifdef DELAY_ENABLED
    wait(5);
    #endif
    router.sendEvent(MOVE_UP);
}

void SerialJoystick::pressDown()
{
    uart.printf("Pressed Down \r\n");
    #ifdef DELAY_ENABLED
    wait(5);
    #endif
    router.sendEvent(MOVE_DOWN);
}

void SerialJoystick::pressLeft()
{
    uart.printf("Pressed Left \r\n");
    #ifdef DELAY_ENABLED
    wait(5);
    #endif
    router.sendEvent(MOVE_LEFT);
}

void SerialJoystick::pressRight()
{
    uart.printf("Pressed Right \r\n");
    #ifdef DELAY_ENABLED
    wait(5);
    #endif
    router.sendEvent(MOVE_RIGHT);
}

void SerialJoystick::pressJump()
{
    uart.printf("Pressed Jump \r\n");
    #ifdef DELAY_ENABLED
    wait(5);
    #endif
    router.sendEvent(JUMP);
}

void SerialJoystick::pressFire1()
{
    uart.printf("Pressed Fire1 \r\n");
    #ifdef DELAY_ENABLED
    wait(5);
    #endif
    router.sendEvent(FIRE1);
}

void SerialJoystick::pressFire2()
{
    uart.printf("Pressed Fire2 \r\n");
}