#include "signals.h"

SignalRouter::SignalRouter(USBKeyboard& dev){
        kdev = &dev;    
}

void SignalRouter::sendEvent(int event){
    switch(event){
        case MOVE_UP:
            kdev->keyCode(UP_ARROW);
            break;    
        case MOVE_DOWN:
            kdev->keyCode(DOWN_ARROW);
            break;  
        case MOVE_LEFT:
            kdev->keyCode(LEFT_ARROW);
            break;  
        case MOVE_RIGHT:
            kdev->keyCode(RIGHT_ARROW);
            break;  
        case FIRE1:
            kdev->keyCode(KEY_CTRL);
            break;  
        case FIRE2:
            break;  
        case JUMP:
            kdev->keyCode(KEY_ALT);
            break;  
        case COIN1:
            kdev->printf("5");
            break; 
        case START:
            kdev->printf("1");
            break;  
        case BACK:
            kdev->putc(0x1b);
            break;
        case USER:
            kdev->printf("pi\r\n");
            break;
        case PASS:
            kdev->printf("raspberry\r\n");
            break;
        case RUN:
            kdev->printf("/home/pi/mame/mame4all_comp/mame_run/mame  \r\n");
            break;   
    }
}