#pragma once
#include "mbed.h"
#include "USBSerial.h"
#include "signals.h"
#include "DebounceIn.h"


extern USBKeyboard keyboard;
extern Serial uart;


#define ON 1
extern DebounceIn Up;
extern DebounceIn Down;
extern DebounceIn Left;
extern DebounceIn Right;
extern DebounceIn Jump;
extern DebounceIn Fire1;
extern DebounceIn Fire2;

/*
*Base Joystic controller class
*/
class Joystick
{
protected:
    SignalRouter router;
public:
    Joystick();
    /*
    * init and start Joystick
    *    
    */
    virtual void init()=0;
    
    /*
    * Following 3 functions will be responsible for joytick menu select operations
    * These are in-game menu actions   
    */
    virtual void pressMenuSelect1()=0;
    virtual void pressMenuSelect2()=0;
    virtual void pressMenuSelect3()=0;
    
    /*
    * Following functions will be responsible for  game actions
    * These are used for in-game play   
    */
    
    /*
    * This function is invoked when joytick presses Button UP   
    */
    virtual void pressUp()=0;
    
    /*
    * This function is invoked when joytick presses Button Down   
    */
    virtual void pressDown()=0;
    
    /*
    * This function is invoked when joytick presses Button LEFT   
    */
    virtual void pressLeft()=0;
    
    /*
    * This function is invoked when joytick presses Button RIGHT   
    */
    virtual void pressRight()=0;
    
    /*
    * This function is invoked when joytick presses Button JMP   
    */
    virtual void pressJump()=0;
    
    /*
    * This function is invoked when joytick presses Button1 for  FIRE   
    */
    virtual void pressFire1()=0;
    
    /*
    * This function is invoked when joytick presses Button2 for  FIRE   
    */
    virtual void pressFire2()=0;
};

/*
* Serial joystic controller class
* This is a terminal/uart input (not actual HW input) controlled Joystick
* used as a testbed currently
*/
class SerialJoystick:public Joystick{
public:
    SerialJoystick();
    void init();
    void pressMenuSelect1();
    void pressMenuSelect2();
    void pressMenuSelect3();
    void pressUp();
    void pressDown();
    void pressLeft();
    void pressRight();
    void pressJump();
    void pressFire1();
    void pressFire2();        
};

class GPIOJoystick:public Joystick{
public:
    GPIOJoystick();
    void init();
    void pressMenuSelect1();
    void pressMenuSelect2();
    void pressMenuSelect3();
    void pressUp();
    void pressDown();
    void pressLeft();
    void pressRight();
    void pressJump();
    void pressFire1();
    void pressFire2();        
};
