#include "mbed.h"
#define SIZE (5+3) //데이터 byte 수 (n) + 3 = protocol length
#define STX '1'//0x02
#define ETX '2'//0x03
#define AKN (6+'0')
#define NAK (21+'0')
// 나중에 flag를 전부 class flag로 선언해서 묶고, extern하기 쉽게 만들자.
// 프린터 위치 초기화, 액추에이터 작동, 다음줄 출력시 프린터 위치 아직 설정 안됨

volatile bool TXflag = false;
volatile char Buffer[SIZE] = "";
volatile bool BufferFlag= false;
volatile bool CheckFlag;
volatile int BIndex = 0;
void Flush();
void Echo();

extern class Serial pc;

//수신 인터럽트 (
void RX_ISR()
{
    char temp = 0;
    temp = pc.getc(); // RX에서 문자 scan
    if(temp == STX) {
        BufferFlag =true;   // stx 일 때 문자기록 flag == 1
        BIndex=0;
    } else if(temp == ETX) {
        BufferFlag = false;    //ETX일 때 문자기록 종료, 송신 시작
        TXflag=true;
    }
    if(BufferFlag) { // 문자 기록부분
        Buffer[BIndex] = temp;
        BIndex++; // 한번 기록하면 index가 증가
    }
}

// 수신 후 AKN/NAK 송신
void Echo()
{
    if(Buffer[(SIZE-2)]=='3'){CheckFlag = true; pc.putc((AKN));} // AKN
    else pc.putc((NAK)); // NAK
}
// 배열 지우기
void Flush()
{
    for(int i = 0 ; i<SIZE; i++) {
        Buffer[i]=0;
    }
}
char CheckSum()
{
    char result =0;
    return result;
}
