#include "mbed.h"

#include "string.h"
//#include "RPCFunction.h"
#include "font.h"

//#include "EthernetNetIf.h"
//#include "HTTPServer.h"



#define cell_height 5
#define cell_width 4
#define numberofcolumns 16

#define numberofchars 10

#define string1length 28
#define string2length 36

#define maxtextlength 160

#define numberofbuffercolumns maxtextlength * (cell_width + 1)
#define bufferendspace 16

#define maxdisplayx 10
#define maxdisplayy 4


DigitalOut myLed1(LED1);
DigitalOut myLed2(LED2);
DigitalOut signal1(p8);
DigitalOut signal2(p10);
Serial pc(USBTX, USBRX); // tx, rx


typedef int cellarray[numberofcolumns][cell_height];
typedef int bufferarray[numberofbuffercolumns + bufferendspace][cell_height];


bufferarray bitmap;
cellarray displaybitmap;
    
int fgcolour = 1;
int bgcolour = 0;    

const int bitsPerBulb = 26;
const int numberOfBulbs = 56;
int ten = 10; // Ten microseconds
int twenty = 20; // Twenty microseconds
int coordTable[55] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 , 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33 , 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54};
int bulbBitStream[bitsPerBulb * numberOfBulbs];


void create_bitmap(bufferarray bitmap, char* displaystring, int colour);
void text_update(char * input, char * output);
void fgcol_update(char * input, char * output);
void bgcol_update(char * input, char * output);

void scroll(void);

void create_string(cellarray bitmap, int startbulb, int length, int stringarray[]);

void setBulbValue(int bulbNum, int red, int green, int blue);
void updateString(void);
void setPixel(int xCoord, int yCoord, int red, int green, int blue);

/*
RPCFunction rpc_text_update(&text_update, "text");
RPCFunction rpc_fgcol_update(&fgcol_update, "fgcolour");
RPCFunction rpc_bgcol_update(&bgcol_update, "bgcolour");
*/
char* displaytext;
//EthernetNetIf eth;  
//HTTPServer svr;

int offset = 0;
bool updatetextrequired = false;

#define maxoffset numberofbuffercolumns * cell_height

Ticker scroll_ticker;

int main(void)
{
     
    displaytext = (char*)malloc(maxtextlength * sizeof(char));
/*
    printf("Setting up Ethernet...\n");
    EthernetErr ethErr = eth.setup();
    if(ethErr)
    {
        printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    printf("Ethernet setup OK\n");

    FSHandler::mount("/webfs", "/"); //Mount /webfs path on web root path
    svr.addHandler<FSHandler>("/"); //Default handler

    svr.addHandler<RPCHandler>("/rpc");
    svr.bind(80);
*/
    //enumerate String 1 of bulb bitstream array.
    for (int bulb = 0 ; bulb < numberOfBulbs ; bulb++) {
        setBulbValue(bulb, 0, 0, 0); // all WHITE
    }
    updateString();

/*    while(true)
    {
        Net::poll();
    }

    while (true) {
        for (int y = 0 ; y < 5 ; y++) {
            for  (int x = 0 ; x < 11 ; x++) {
            
                Net::poll();
                setPixel (x, y, 13, 0, 0);
                updateString();
                
                Net::poll();
                setPixel (x, y, 0, 0, 13);
                updateString();
            }
        }
    }*/

    strcpy(displaytext, "ABCDEFGHIJKLMNOPQRSTUVWXYZ ");
   
    create_bitmap(bitmap, displaytext, 1); 
    updatetextrequired = false;
   
    scroll_ticker.attach(&scroll, 0.07);
    
    while(1)
    {
        //Net::poll();
        if(offset == 0 && updatetextrequired == true)
        {
            create_bitmap(bitmap, displaytext, 1); 
            updatetextrequired = false;
        }
    }    

    return(0);
}

void scroll(void)
{
    
    int red;
    int green;
    int blue;
 
//    printf("Scroll function offset %d (maxoffset = %d)\r\n", offset, maxoffset);


    for(int y = 0; y<maxdisplayy+1; y++)
    {
        for(int x =0; x<maxdisplayx+1; x++)
        {   
            int pixelcolour;
            pixelcolour = bitmap[x+offset][y];
//            printf("%d",pixelcolour);
            if (pixelcolour == 1) {pixelcolour = 13;} else {pixelcolour = 0;}
            setPixel(x,y,pixelcolour,pixelcolour,pixelcolour);
            
        }   
//        printf("\r\n");
    }




    updateString();

    offset++;
    if(offset >= 40)
    {
        offset = 0;
    }
}


void text_update(char * input, char * output)
{
    int inputtextlength;
    int displaytextlength;
    
    displaytextlength = maxtextlength;
    inputtextlength = sizeof(input);
    if (inputtextlength < maxtextlength)
    {
        displaytextlength = inputtextlength;
    }
    
    strncpy(displaytext, input, displaytextlength);
    
    updatetextrequired = true;
    
}


void fgcol_update(char * input, char * output)
{
    fgcolour = atoi(input);
    updatetextrequired = true;
}

void bgcol_update(char * input, char * output)
{
    bgcolour = atoi(input);
    updatetextrequired = true;
}

void create_string(bufferarray bitmap, int startbulb, int length, int stringarray[])
{
    int *buff;
    
    buff = (int*)bitmap;
    
    for (int string_iter = 0; string_iter < length; string_iter++)
    {
     //   stringarray[string_iter - startbulb] = bitmap[string_iter];
    }
}

void create_bitmap(bufferarray bitmap, char* displaystring, int colour)
{
    int displaystringlen;
    
    printf("create_bitmap %s\r\n", displaystring);
    
    displaystringlen = strlen(displaystring);
    
    
    if(displaystringlen > numberofchars) {displaystringlen = numberofchars;}
    
    for(int displaychar = 0; displaychar < numberofchars; displaychar++ )
    {
        int fontref = 26; //default to space
        unsigned char asciichar;
        
        
        
        asciichar = (unsigned char)(displaystring[displaychar]);
        
        
        if (asciichar == 32) {fontref = 26;} //convert ascii space to font
        if (asciichar > 64 && asciichar < 91){fontref = asciichar - 65;}// convert uppercase to font
        if (asciichar > 96 && asciichar < 123){fontref = asciichar - 97;}// convert lowercase to font (hacked to upper)
    
        printf("char %c, fontref %d\r\n", asciichar, fontref);
        
            unsigned char mask = 0x10; //MAGIC NUMBER, x=0 == top
        for (int columnoffset = 0; columnoffset < cell_width-1; columnoffset++)
        {
            
            
            for (int row = 0; row < cell_height; row++)
            {
                int bulbcontents=0;
                
                printf("Fontref %x, masked %x (mask %x)\r\n",FONT[fontref][row],(FONT[fontref][row] & mask), mask);
                
                if ((FONT[fontref][row] & mask) !=0) {bulbcontents = fgcolour;} else {bulbcontents = bgcolour;}
            
                bitmap[displaychar * (cell_width + 1) + columnoffset][row] = bulbcontents; //cell_width + 1 for 1 col space between chars             
                
            }
                mask = mask >> 1;   
        }
        
    }
        for(int y=0; y<cell_height; y++)
        {
            for(int x=displaychar * 5; x<100; x++)
            {
                printf("%d ", bitmap[x][y]);
            }
            printf("\r\n");
        }
}

void setPixel(int xCoord, int yCoord, int red, int green, int blue) {
    setBulbValue(coordTable[(yCoord * 11) + xCoord], red, green, blue);
}


void setBulbValue(int bulbNum, int red, int green, int blue) {

    int intensity = 204;

    int bulbBitstreamStart = (bulbNum * bitsPerBulb); // So this seems right.

    // Bulb number
    //pc.printf("Bulb %d ", bulbNum);
    for (int loop = 5 ; loop >= 0 ; loop--) {

        if ((bulbNum % 2) > 0) {
            bulbBitStream[bulbBitstreamStart + loop] = 1;
            //pc.printf("1");
        } else {
            bulbBitStream[bulbBitstreamStart + loop] = 0;
            // pc.printf("0");
        }
        bulbNum = bulbNum / 2;
    }
    // Intensity
    //pc.printf(" Intensity %d ", intensity);
    for (int loop = 13 ; loop >= 6 ; loop--) {

        if ((intensity % 2) > 0) {
            bulbBitStream[bulbBitstreamStart + loop] = 1;
            //pc.printf("1");
        } else {
            bulbBitStream[bulbBitstreamStart + loop] = 0;
            //pc.printf("0");
        }
        intensity = intensity / 2;
    }
    // Blue
    //pc.printf(" Blue %d ", blue);
    for (int loop = 17 ; loop >= 14 ; loop--) {

        if ((blue % 2) > 0) {
            bulbBitStream[bulbBitstreamStart + loop] = 1;
            //pc.printf("1");
        } else {
            bulbBitStream[bulbBitstreamStart + loop] = 0;
            //pc.printf("0");
        }
        blue = blue / 2;

    }
    // Green
    //pc.printf(" Green %d ", green);
    for (int loop = 21 ; loop >= 18 ; loop--) {

        if ((green % 2) > 0) {
            bulbBitStream[bulbBitstreamStart + loop] = 1;
            //pc.printf("1");
        } else {
            bulbBitStream[bulbBitstreamStart + loop] = 0;
            //pc.printf("0");
        }
        green = green / 2;
    }
    // Red
    //pc.printf(" Red %d ", red);
    for (int loop = 25 ; loop >= 22 ; loop--) {

        if ((red % 2) > 0) {
            bulbBitStream[bulbBitstreamStart + loop] = 1;
            //pc.printf("1");
        } else {
            bulbBitStream[bulbBitstreamStart + loop] = 0;
            //pc.printf("0");
        }
        red = red / 2;
    }
}

void updateString(void) {
    // set bus state low for 60 microseconds to make sure we're reset.
    signal1 = 0;
    wait_us(twenty * 3);

    for (int x = 0; x < numberOfBulbs ; x++) //Iterate for as many bulbs are in the string
    {// x
        //Start Bit: High for 10microSeconds
        signal1 = 1;
        wait_us(ten);
        signal1 = 0;

        for (int i = 0; i < bitsPerBulb; i++) { // i
            if (bulbBitStream[i + (x * bitsPerBulb)] == 0) {
                signal1 = 0;
                wait_us(ten);
                signal1 = 1;
                wait_us(twenty);
                signal1 = 0;
            } else {
                signal1 = 0;
                wait_us(twenty);
                signal1 = 1;
                wait_us(ten);
                signal1 = 0;
            }
        } // i
        wait_us(twenty*2); // Wait AT LEAST 30 microseconds to end frame, so 40 in this case.
    }// x


} // end updateString ()