#include "mbed.h"
#include "C12832_lcd/C12832_lcd.h"
#include "LM75B/LM75B.h"

PwmOut spkr(p26);
AnalogIn fine(p19);
AnalogIn coarse(p20);
C12832_LCD lcd("LCD");

int main()
{
    int us, last_us, freq;
    spkr.write(0.5);

    while(1) {
        freq = (int)(50000.0 * coarse.read()) + (1000.0 * fine.read());
        us = 1000000 / freq; 
        lcd.locate(0,3);
        lcd.printf("Freq: %5i Hz", freq);
        lcd.locate(0,12);
        lcd.printf("     (%7i us)", us);

        if (us != last_us) {
            last_us = us;
            spkr.write(0.5);
            spkr.period_us(us);
        }
        wait(0.01);
    }
}