#ifndef Led_H
#define Led_H

#include "mbed.h"

/**
 *  This class manage LED.
 *  She permit to put on/off LED, flash LED, get/set delay to flash and read pin status.
 *  
 * @code                        
 *
 * #include "Led.h"
 *
 * Led led (p12);
 *
 * int main() {
 *
 *  led.on();                               // put on LED
 *  wait(2);                                // wait 2 seconds (operations)
 *  
 *  led.flash();                            // flash LED (flash delay = 0.2);
 *  wait(2);                                // wait 2 seconds
 *  
 *  float delay = led.getFlashDelay();      // delay = flashDelay
 *  led.off();                              // put off LED
 *  wait(2);                                // wait 2 seconds (operations)
 *  
 *  delay *= 2;                             // delay = delay * 2
 *  led.setFlashDelay(delay);               // flashDelay = delay
 *  led.flash();                            // flash LED (flashDelay = 0.4);
 *  wait(2);                                // wait 2 seconds (operations)
 *  
 *  led.on();                               // put on LED
 *  int pinStatus = int(led);               // pinStatus = 1 if LED is lighted, else 0
 *  wait(1);                                // wait 1 second (operations)
 *  
 *  if (pinStatus)  led.flash();            // if LED is lighted, flash LED
 *  wait(2);                                // wait 2 seconds
 *  led.off();                              // put off LED
 *  pinStatus = int(led);                   // pinStatus = 1 if LED is lighted, else 0
 *  if (pinStatus)  led.flash();            // if LED is lighted, flash LED
 *  wait(2);                                // wait 2 seconds (operations)
 *  
 *  led.off();                              // put off LED
 *  
 *  return 0;
 * }
 * @endcode
 */

class Led {


private:
    Ticker     _ticker; // use for flash led
    DigitalOut _pin;
    float      _flashDelay;

    
public:
    
    /** Create a Led interface */
    Led(PinName pin);

    /** Destructor */
    ~Led(void);

    /** put on LED */
    void on(void);
    
    /** put off LED */
    void off(void);
    
    /** launch LED flash */
    void flash(void);
        
    /** get pin status 
     * 
     * @return  _pin
     */
    int read(void);

    /** A shorthand for read() */
    operator int() { return read(); }

    /** get flash delay value 
     * 
     * @return _flashDelay
     */
    float getFlashDelay(void) const;
    
    /** change flash delay value to delay 
     * 
     * @param delay     new delay to flash LED
     */
    void setFlashDelay(float delay);
    
    
private:
    
    // method to change pin status
    // use by flash()
    void flipPin(void);

    // stop LED flash
    // use by on(), off() and flash()
    void stopFlash(void);
};

#endif // Led_H