#include "Led.h"

/********************************************************************************************************
                                         public methods
 ********************************************************************************************************/

/* Create a Led interface */
Led::Led(PinName pin) : _pin(pin) {
    // default the output to 0
    _pin = 0;
    // delay to flip pin (flash led)
    _flashDelay = 0.2;
}

/* Destructor */
Led::~Led()
{
}

/* put on LED */
void Led::on(void) {
    // stop flash LED if forgot
    this->stopFlash();
    _pin = 1;
}

/* put off LED */
void Led::off(void) {
    // stop flash LED
    this->stopFlash();
    _pin = 0;
}

/* launch LED flash */
void Led::flash(void) {
    // stop flash LED if forgot
    this->stopFlash();
    // Attach a function to be called by the Ticker, specifiying the interval delay in seconds.
    // attach flipPin : change pin status each _flashDelay seconds (flash led)
    _ticker.attach(this, &Led::flipPin, _flashDelay);
}

/* get pin status 
 * 
 * @return  _pin
 */
int Led::read(void) {
    return _pin;
}

/* get flash delay value 
 * 
 * @return _flashDelay
 */
float Led::getFlashDelay(void) const {
    return _flashDelay;
}

/* change flash delay value to delay 
 * 
 * @param delay     new delay to flash LED
 */
void Led::setFlashDelay(float delay) {
    _flashDelay = delay;
}

/********************************************************************************************************
                                         private methods
 ********************************************************************************************************/

// flipPin method call by ticker
// flip pin status
// use by flash()
void Led::flipPin(void) {
    // flash LED
    _pin = !_pin;
}

// detach method flipPin
// use by on(), off() and flash()
void Led::stopFlash(void) {
    // Detach the function
    _ticker.detach();
    _pin = 0;
}