#include "mbed.h"
#include "DHT.h"

DigitalOut myled(LED1);

DHT sensor(A2,DHT22); // Use the SEN11301P sensor
Serial pc(SERIAL_TX,SERIAL_RX);
Serial xbee(A0,A1);
int main() {
    int err;
    pc.printf("\r\nDHT Test program");
    pc.printf("\r\n******************\r\n");
    wait(1); // wait 1 second for device stable status
    while (1) {
        myled = 1;
        err = sensor.readData();
        if (err == 0) {
            pc.printf("Temperature is %4.2f C \r\n",sensor.ReadTemperature(CELCIUS));
            pc.printf("Temperature is %4.2f F \r\n",sensor.ReadTemperature(FARENHEIT));
            pc.printf("Temperature is %4.2f K \r\n",sensor.ReadTemperature(KELVIN));
            pc.printf("Humidity is %4.2f \r\n",sensor.ReadHumidity());
            pc.printf("Dew point is %4.2f  \r\n",sensor.CalcdewPoint(sensor.ReadTemperature(CELCIUS), sensor.ReadHumidity()));
            pc.printf("Dew point (fast) is %4.2f  \r\n",sensor.CalcdewPointFast(sensor.ReadTemperature(CELCIUS), sensor.ReadHumidity()));
            xbee.printf("Temperature is %4.2f C \r\n",sensor.ReadTemperature(CELCIUS));
            xbee.printf("Temperature is %4.2f F \r\n",sensor.ReadTemperature(FARENHEIT));
            xbee.printf("Temperature is %4.2f K \r\n",sensor.ReadTemperature(KELVIN));
            xbee.printf("Humidity is %4.2f \r\n",sensor.ReadHumidity());
            xbee.printf("Dew point is %4.2f  \r\n",sensor.CalcdewPoint(sensor.ReadTemperature(CELCIUS), sensor.ReadHumidity()));
            xbee.printf("Dew point (fast) is %4.2f  \r\n",sensor.CalcdewPointFast(sensor.ReadTemperature(CELCIUS), sensor.ReadHumidity()));
        } else
            pc.printf("\r\nErr %i \n",err);
            xbee.printf("\r\nErr %i \n",err);
        
        myled = 0;
        wait(5);
    }
}