#include "mbed.h"
#include "rtos.h"
#include "EFM32_SegmentLCD.h"

// import LCD Library
silabs::EFM32_SegmentLCD segmentDisplay;

//score counter
int32_t g_count;
 
// Hardware Resource
DigitalOut led1(LED1); // LED
DigitalOut led2(LED2); // LED
InterruptIn in1(PB9);  // Push Button
InterruptIn in2(PB10); // Push Button

// for OS Resource 
osThreadId MyThread1; // Thread ID
osThreadId MyThread2; // Thread ID
osThreadId MyThread3; // Thread ID
osThreadId MyThread4; // Thread ID

// Button Handler
void in1_handler() {
    osSignalSet(MyThread1, 3); //set signal for thread1
    g_count++; // Update score for single count
}

// Button Handler
void in2_handler() {
    osSignalSet(MyThread2, 10); // set signal for thread2
    g_count+=2; // Update score for double count
}

// Thread1 
void led1_thread(void const *args) {
    MyThread1 = Thread::gettid();  // Get this thread ID
    while(true) {
        Thread::signal_wait(3, osWaitForever );  // Waiting signal as 3 from BTN1
        led1 = !led1;  //Toggled LED0
        segmentDisplay.Number(g_count); // Display update for current count value 
        Thread::wait(100); // Wait 100ms 
        Thread::yield();  // Dispath Other Thread
    }    
    
}

// Thread2
void led2_thread(void const *args) {
    MyThread2 = Thread::gettid();  // Get this thread ID
    while (true) {
        Thread::signal_wait(10, osWaitForever); // Waiting signal as 10 from BTN2
        led2 = !led2; // Toggled LED1
        segmentDisplay.Number(g_count); //Display update for current count value
        Thread::wait(100); // Wait 100ms
        Thread::yield(); // Dispatch  Other Thread
    }
}

// Thread3 
void btn1_thread(void const *args) {
    int32_t btn_cnt1;  // for Display control
    MyThread3 = Thread::gettid(); // Get This Thread ID
    btn_cnt1 =0; // Status Initialize 
    
    while(true) {
        if(btn_cnt1 == 0) { // Status Check   
            segmentDisplay.Write("Bay-");  // Display Update for Text
            btn_cnt1 = 1;  // Change Status
        }
        else {
            segmentDisplay.Write("Blade"); // Display Update for Text
            btn_cnt1 =0;  // Change Status
        }
        Thread::wait(1000); // Wait 1000ms
        Thread::yield();  // Dispatch Other Thread
    }
}

// Thread4     
void btn2_thread(void const *args) {
    int32_t count;  // for Counter Value
    MyThread4 = Thread::gettid();  // Get Thread ID
    count=0; // Counter Initialize
    while(true) {
        segmentDisplay.ARing(count & 0x7, (count & 0x8) == 0);  // Ring Display Update 
        if(count > 16) count=0;  //Display Counter Value Update
        else count++; // Counter Increment
        Thread::wait(1000); // Wait 1000ms
        Thread::yield(); // Dispatch Other Thread
    }
}

// Main
int main() {
    g_count =0; // Global Counter Clear
    Thread thread1(led1_thread); // Create Thread
    Thread thread2(led2_thread); // Create Thread 
    Thread thread3(btn1_thread); // Create Thread 
    Thread thread4(btn2_thread); // Create Thread
    
    // Initialize pushbutton handler
    in1.rise(NULL); // BTN0 Initialize
    in1.fall(in1_handler); // BTN0 Handler Configuration
    in2.rise(NULL); // BTN1 Initialize
    in2.fall(in2_handler); // BTN1 Handler Configuration
    
    wait(1); // Wait for Display 
    segmentDisplay.Write("Shoot!");  // Display This Message
    
    // Loop
    while (true) {
         wait(1000);
    }
}