#include "mbed.h"

Serial pc(USBTX, USBRX);
Serial lcd(p13, p14);

bool esc;
void setSpark() {
    lcd.printf("%c%c",0xFE,0x01);
    lcd.printf("%c%c",0xFE,0x80);
    lcd.printf("  Sparkfun.com  ");
    lcd.printf("%c%c",0xFE,0xC0);
    lcd.printf("   SerLCD  v2   ");
}
void interrupt() {
    char in = pc.getc();
    if (esc) {
        switch (in) {
            case 'h':
                pc.printf("esc+h - help text\r\n");
                pc.printf("esc+s - sparkfun boot splash\r\n");
                pc.printf("esc+c - clear screen\r\n");
                pc.printf("esc+a - cursor on\r\n");
                pc.printf("esc+z - cursor off\r\n");
                pc.printf("esc+b - set boot splash\r\n");
                pc.printf("esc+d - disable/enable boot splash\r\n");
                break;
            case 'a':
                lcd.printf("%c%c",0xFE,0x0D);
                break;
            case 'z':
                lcd.printf("%c%c",0xFE,0x0C);
                break;
            case 'c':
                lcd.printf("%c%c%c%c",0xFE,0x01,0xFE,0x80);
                break;
            case 'd':
                lcd.printf("%c%c",0x7C,0x09);
                break;
            case 'b':
                lcd.printf("%c%c",0x7C,0x0A);
                break;
            case 's':
                setSpark();
                break;
        }
        esc=0;
    } else {
        switch (in) {
            case 0x1b:
                esc=1;
                break;
            case 0x7C:
            case 0x0d:
                break;
            default :
                esc=0;
                lcd.printf("%c",in);
                pc.printf("%c",in,in);
        }
    }
}
int main() {
    pc.attach(&interrupt);
    while (1) {
        wait(.3);
    }
}

