#include "mbed.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
Serial lcd(p13, p14);

void clearLCD() {
    lcd.printf("%c%c",0xFE,0x01);
}
void setLCDpos(int xpos, int ypos) {
    int pos = 0x80;
    switch (xpos){
    case 1: 
        pos +=0; 
        break;
    case 2: 
        pos +=64; 
        break;
    case 3: 
        pos +=20; 
        break;
    case 4: 
        pos +=84;
        break;
    }
    pos += (ypos-1);
    lcd.printf("%c%c",0xFE,pos);
}
void setBrightness(int lev) {
    lcd.printf("%c%c",0x7C,lev+127);
    wait(.1);
}
int main() {
    wait(2);
    clearLCD();
    unsigned int i=0;
    setLCDpos(1,1);
    lcd.printf("Hello, World!");
    setLCDpos(2,1);
    lcd.printf("Led");
    while (1) {
        wait(.2);
        i++;
        myled = !myled;
        setLCDpos(2,5);
        if (myled) {
            lcd.printf("On ");
        } else {
            lcd.printf("Off");
        }
        setLCDpos(2,9);
        lcd.printf("#%7i",i);
    }
}
