#include "dot_util.h"
#include "RadioEvent.h"
#include "sensors.h"
#include "x_nucleo_nfc04a1_nfctag.h"

/*** @@@@@@@@ Version de programa @@@@@@@@ ***/
#define PROGRAM_BUILD "20200830.1"
#define PROGRAM_VERSION "3.4.3"
/*********************************************/

////// Tipo de programa definido ////////

#ifdef HIBER_DEMO
#define PROGRAM_TYPE "Hiber_DEMO"
#else
#ifdef MODO_TEST_TX
#define PROGRAM_TYPE "TEST"
#else
#ifdef PLACA_BARCO
#define PROGRAM_TYPE "BARCO"
#else
#define PROGRAM_TYPE "SILO"
#endif
#endif
#endif
//////////////////////////////////

#define MAX_MSG 17



/******* @@@@@@@@  Definiciones para la red LoRA @@@@@@@@ ********/

/////////////////////////////////////////////////////////////
// * these options must match the settings on your gateway //
// * edit their values to match your configuration         //
// * frequency sub band is only relevant for the 915 bands //
// * either the network name and passphrase can be used or //
//     the network ID (8 bytes) and KEY (16 bytes)         //
/////////////////////////////////////////////////////////////


//#define CHANNEL_PLAN CP_US915
#define CHANNEL_PLAN CP_EU868

/////////// Para gateway Multitech /////////////
#ifdef OTA_MODE 
static std::string network_name = "pruebalora";
static std::string network_passphrase = "acdc1949";


//Si colocamos sub_band en 0, busca una banda disponible
//static uint8_t frequency_sub_band = 4;
static uint8_t frequency_sub_band = 0;
static bool public_network = false;
static uint8_t ack = 0;
static bool adr = true;
/////////////////////////////////////////////////////

#else 

/////// Modo manual para gateway generico //////////

static uint8_t network_session_key[] = { 0x01, 0x02, 0x03, 0x04, 0x01, 0x02, 0x03, 0x04, 0x01, 0x02, 0x03, 0x04, 0x01, 0x02, 0x03, 0x04 };
static uint8_t data_session_key[] =    { 0x01, 0x02, 0x03, 0x04, 0x01, 0x02, 0x03, 0x04, 0x01, 0x02, 0x03, 0x04, 0x01, 0x02, 0x03, 0x04 };

static uint8_t frequency_sub_band = 2;
static lora::NetworkType network_type = lora::PUBLIC_LORAWAN;
static uint8_t join_delay = 5;
static uint8_t ack = 0;
static bool adr = true;
////////////////////////////////////////////////////

#endif


/************** @@@@@@@@ FIN definiciones red LoRa @@@@@@@@ ****************/


/************ @@@@@@@@ Definiciones para dormir @@@@@@@@ ********************/
// deepsleep consumes slightly less current than sleep
// in sleep mode, IO state is maintained, RAM is retained, and application will 
// resume after waking up
// in deepsleep mode, IOs float, RAM is lost, and application will start from beginning after waking up
// if deep_sleep == true, device will enter deepsleep mode
static bool deep_sleep = true;

//Tiempo de dormir en segundos
#ifndef MODO_TEST_TX
//#define DEFAULT_DELAY_SLEEP 5 //5seg
//#define DEFAULT_DELAY_SLEEP 10 //10seg
//#define DEFAULT_DELAY_SLEEP 30 //30seg
#define DEFAULT_DELAY_SLEEP 60 //1 min
//#define DEFAULT_DELAY_SLEEP 300 //5min
//#define DEFAULT_DELAY_SLEEP 3600 //1hs
//#define DEFAULT_DELAY_SLEEP 10800 //3hs
//#define DEFAULT_DELAY_SLEEP 21600 //6hs


//unsigned int delay_sleep = 21600; //6hs
//unsigned int delay_sleep = 900; //15 min
//unsigned int delay_sleep = 30; //30seg

unsigned int delay_sleep = DEFAULT_DELAY_SLEEP; 

#else
unsigned int delay_sleep = 2;
#endif

/************ @@@@@@@@ Fin definiciones para dormir @@@@@@@@ ******************/

/********* @@@@@@@@ Configuraciones de puertos I/O @@@@@@@@ **************/

#ifdef PLACA_MDOT
Serial pc(USBTX, USBRX);
AnalogIn lux(XBEE_AD0);

//Segun diagrama el PB_O es el A1 en la placa
AnalogIn   a_temp(PB_0);

//Segun diagrama el PC_1 es el A2
AnalogIn   a_hum(PC_1);

DigitalOut alimentacion(D3);
DigitalOut led2(D7);

#endif //De placa MDOT

#ifdef PLACA_XDOT
Serial pc(USBTX, USBRX);
Serial co2sens(UART_TX,UART_RX);

#ifdef DESARROLLO
DigitalOut led2(PA_14);
DigitalOut led1(LED1);

#ifndef USE_SENSOR_I2C
AnalogIn   a_temp(PB_0);
AnalogIn   a_hum(PA_5);

#else
DigitalOut NFCOUT(PB_2);

#endif 


#else 

#ifndef USE_SENSOR_I2C
AnalogIn   a_temp(PA_4); //GPIO0
AnalogIn   a_hum(PB_0); //GPIO2
AnalogIn   a_bat(PA_5); //GPIO1

#else
DigitalOut NFCOUT(PB_2);
#ifdef MEDIR_BAT
AnalogIn   a_vbat(PA_4); //GPIO0
#endif

#endif 


#endif // De desarrollo 

//DigitalOut alimentacion(PB_2); //GPIO3

DigitalOut alimentacion(PB_0); //GPIO2

#endif //De PLACA_XDOT

#ifdef USE_SENSOR_I2C
I2C i2c(I2C_SDA , I2C_SCL ); 
#endif

/*********** @@@@@@@@ Fin de configuraciones puertos I/O  @@@@@@@@ ***********/

/******************** Variables globales *********************/
char co2_buffer[CO2_MAX_BUFFER];
unsigned int co2_index;
Timer t;
time_t sleep_timestamp;
mDot* dot = NULL;
lora::ChannelPlan* plan = NULL;
char retry_i2c;
/*************************************************************/


void flushSerialBuffer(Serial *device) 
{ 
    char char1 = 0; 
    while (device->readable()) 
    { 
        char1 = device->getc(); 
    }
}

void read_co2() 
{       
    //reset_co2_buffer();
    
    while (co2sens.readable() && (co2_index<CO2_MAX_BUFFER) )
    { 
        co2_buffer[co2_index] = co2sens.getc();
        co2_index++;        
    }
    
}

void eui_to_netaddress(uint8_t *device_address)
{
    unsigned int i,j;
    std::vector<uint8_t> node_eui = dot->getDeviceId();
    
    if(node_eui.size()<5)
    {
          for(i=0;i<node_eui.size();i++)
            {
                device_address[i] = node_eui.at(i);
            }
        }
        else
        {
            for(i=4,j=0;(i<node_eui.size())&&j<4;i++,j++)
            {
                device_address[j] = node_eui.at(i);
            }
        }
}

/*******************************************************************/

#ifdef HIBER_DEMO
unsigned int seq;
#endif

    
int main(void) 
{
    // Custom event handler for automatically displaying RX data
    RadioEvent events;
    
    double t_temp, t_hum, temperatura, humedad,t_vbat;
    unsigned int valor_co2, i,j;
    
    uint16_t temp_16, hum_16, co2_16;
    unsigned char bat_8;
    
    std::string texto = "D04DE4F5";
    char bufsend[MAX_MSG];
    char aux[3];
    char cmd[2];
    char data[6] = {0};
    bool done;
    bool enable_tx_data = true;
    bool wakeup_pin;
    unsigned char extra_data;
    char deviceid[MAX_DEVICE_ID];
    char co2_str[4], temp_str[4], hum_str[4];
    float bat_val = 0;
    
#ifndef OTA_MODE
    uint8_t device_address[4];
#endif    
    
#ifdef USE_SENSOR_I2C
    const int addr8bit = I2C_SENSOR_ADDRESS << 1;
#endif
    
//#ifdef MODO_TEST_TX
    uint16_t seq;
    //char seq_str[4];
//#endif

#ifdef USE_SENSOR_I2C
    NFCTAG_StatusTypeDef NFC_STAT;
    NFC_Memory_Layout NFC_Memory;
    bool NFC_Init;
#endif
    
    
    //Abrimos el puerto serie del Co2
    co2sens.baud(CO2_BAUDRATE);
    
    //Attachamos la interrupcion a la funcion de lectura 
    //co2sens.attach(&read_co2);
        
    //Abrimos el puerto de debug
    pc.baud(115200);
    
    
    mts::MTSLog::setLogLevel(mts::MTSLog::TRACE_LEVEL);
    
#if CHANNEL_PLAN == CP_US915
    plan = new lora::ChannelPlan_US915();
#elif CHANNEL_PLAN == CP_AU915
    plan = new lora::ChannelPlan_AU915();
#elif CHANNEL_PLAN == CP_EU868
    plan = new lora::ChannelPlan_EU868();
#elif CHANNEL_PLAN == CP_KR920
    plan = new lora::ChannelPlan_KR920();
#elif CHANNEL_PLAN == CP_AS923
    plan = new lora::ChannelPlan_AS923();
#elif CHANNEL_PLAN == CP_AS923_JAPAN
    plan = new lora::ChannelPlan_AS923_Japan();
#elif CHANNEL_PLAN == CP_IN865
    plan = new lora::ChannelPlan_IN865();
#endif
    assert(plan);

    dot = mDot::getInstance(plan);
    assert(dot);

    // attach the custom events handler
    dot->setEvents(&events);
    
    t.reset();
    t.start();
    
    
    if(!dot->nvmRead(TIME_SLEEP_ADDRESS,&sleep_timestamp, sizeof(time_t)))
    {
        pc.printf("ATENCION: No se pudo cargar sleep_timestamp\r\n");
        sleep_timestamp = time(NULL);        
    }
    
    unsigned int tiempo_sleep = (unsigned int)(time(NULL) - sleep_timestamp);
    
    pc.printf("%s%u%s%u\r\n","Tiempo actual:",(unsigned int)time(NULL)," Tiempo guardado:",(unsigned int)sleep_timestamp);
    
    if( tiempo_sleep < delay_sleep)
    {
        pc.printf("%s\n\n","DESPERTADO POR WAKE PIN"); 
        wakeup_pin = true;
#ifdef DESARROLLO
        led1 = true;
#endif
    }
    else
    {
        wakeup_pin = false;
    }
    
    pc.printf("%s%u%s\r\n","Tiempo dormido: ",tiempo_sleep," seg.");
    
    #ifdef HIBER_DEMO
    if(!dot->nvmRead(SEQ_ADDRESS,&seq, sizeof(uint16_t)))
    {
        pc.printf("ATENCION: No se pudo cargar la secuencia\r\n");
        seq = 0x30;
        
    }
    #endif

    
    pc.printf("\r\n%s%s%s%s%s%s%s\r\n","### Wiagro Lanza v",PROGRAM_VERSION,"-",PROGRAM_TYPE," build ",PROGRAM_BUILD," ###");
    //pc.printf("Sizeof's: float = %d | double = %d | int = %d | long = %d \r\n",sizeof(float),sizeof(double),sizeof(int),sizeof(long int));
    pc.printf("Sleep Time: %d seg = %d min = %d hs \r\n",delay_sleep,delay_sleep/60,delay_sleep/3600);
    
    #ifdef USE_SENSOR_I2C
    //Inicializamos el NFC
    //NFC_STAT = BSP_NFCTAG_Init(&i2c,&NFCOUT);
    NFC_STAT = ST25DV_IO_Init(&i2c,&NFCOUT);
    if(NFC_STAT != NFCTAG_OK)
    {
        pc.printf("%s%d\r\n","NFC NO iniciado. Error: ",NFC_STAT);
        NFC_Init = false;
    }
    else
    {
        pc.printf("NFC OK\r\n");
        NFC_Init = true;
    }
    #endif
    
    memset(deviceid,0,MAX_DEVICE_ID);
    
#ifndef OTA_MODE        
    strncpy(deviceid,"00",MAX_DEVICE_ID);
     
    //Construimos el network address en funcion al EUI del dispositivo   

    eui_to_netaddress(device_address);
        
     pc.printf("\n%s","Device Address = ");     
     for(i=0;i<4;i++)
     {
        pc.printf("%02x ",device_address[i]);
        snprintf(aux,3,"%02x",device_address[i]);
        strncat(deviceid,aux,MAX_DEVICE_ID);
     }
    
     strncat(deviceid,"\r\n",MAX_DEVICE_ID);
     pc.printf("\r\n%s%s","Device Address NFC = ",deviceid);       
   
#endif 
   
    alimentacion = 1;
    //alimentacion2 = 1;
    wait(3);
    
   /* if(!dot->nvmRead(I2C_RETRY_ADDRESS,&retry_i2c, sizeof(char)))
    {
        pc.printf("ATENCION: No se pudo cargar i2c_retry\r\n");
        retry_i2c = 0;
        
    }
    
    */
     
    
//#ifdef MODO_TEST_TX
    if(!dot->nvmRead(SEQ_ADDRESS,&seq, sizeof(uint16_t)))
    {
        pc.printf("ATENCION: No se pudo cargar la secuencia\r\n");
        seq = 0;
        
    }
//#endif
    
    co2_index = reset_co2_buffer(co2_buffer);

    if (!dot->getStandbyFlag()) 
    {
        
        logInfo("mbed-os library version: %d", MBED_LIBRARY_VERSION);

        // start from a well-known state
        logInfo("defaulting Dot configuration");
        dot->resetConfig();
        dot->resetNetworkSession();

        // make sure library logging is turned on
        dot->setLogLevel(mts::MTSLog::INFO_LEVEL);

#ifndef ONLY_SENSORS  
#ifdef  OTA_MODE               
        // update configuration if necessary
        if (dot->getJoinMode() != mDot::OTA) 
        {
            logInfo("changing network join mode to OTA");
            if (dot->setJoinMode(mDot::OTA) != mDot::MDOT_OK) 
            {
                logError("failed to set network join mode to OTA");
            }
        }
        // in OTA and AUTO_OTA join modes, the credentials can be passed to the library as a name and passphrase or an ID and KEY
        // only one method or the other should be used!
        // network ID = crc64(network name)
        // network KEY = cmac(network passphrase)
        update_ota_config_name_phrase(network_name, network_passphrase, frequency_sub_band, public_network, ack);
        //update_ota_config_id_key(network_id, network_key, frequency_sub_band, public_network, ack);

        // configure network link checks
        // network link checks are a good alternative to requiring the gateway to ACK every packet and should allow a single gateway to handle more Dots
        // check the link every count packets
        // declare the Dot disconnected after threshold failed link checks
        // for count = 3 and threshold = 5, the Dot will ask for a link check response every 5 packets and will consider the connection lost if it fails to receive 3 responses in a row
        update_network_link_check_config(3, 5);

        // enable or disable Adaptive Data Rate
        dot->setAdr(adr);
#else
      // update configuration if necessary
        if (dot->getJoinMode() != mDot::MANUAL) 
        {
            logInfo("changing network join mode to MANUAL");
            if (dot->setJoinMode(mDot::MANUAL) != mDot::MDOT_OK) 
            {
                logError("failed to set network join mode to MANUAL");
            }
        }
        // in MANUAL join mode there is no join request/response transaction
        // as long as the Dot is configured correctly and provisioned correctly on the gateway, it should be able to communicate
        // network address - 4 bytes (00000001 - FFFFFFFE)
        // network session key - 16 bytes
        // data session key - 16 bytes
        // to provision your Dot with a Conduit gateway, follow the following steps
        //   * ssh into the Conduit
        //   * provision the Dot using the lora-query application: http://www.multitech.net/developer/software/lora/lora-network-server/
        //      lora-query -a 01020304 A 0102030401020304 <your Dot's device ID> 01020304010203040102030401020304 01020304010203040102030401020304
        //   * if you change the network address, network session key, or data session key, make sure you update them on the gateway
        // to provision your Dot with a 3rd party gateway, see the gateway or network provider documentation
        
        
        
        eui_to_netaddress(device_address);
        
        update_manual_config(device_address, network_session_key, data_session_key, frequency_sub_band, network_type, ack);

        // enable or disable Adaptive Data Rate
        dot->setAdr(adr);

        // Configure the join delay
        dot->setJoinDelay(join_delay);
        
        //std::vector<uint8_t> current_network_address = dot->getNetworkAddress();

#endif //De OTA_MODE

#endif //De ONLY_SENSORS   

        // save changes to configuration
        logInfo("saving configuration");
        if (!dot->saveConfig()) 
        {
            logError("failed to save configuration");
        }

        // display configuration
        display_config();
    } 
    else 
    {
#ifndef ONLY_SENSORS         
        // restore the saved session if the dot woke from deepsleep mode
        // useful to use with deepsleep because session info is otherwise lost when the dot enters deepsleep
        //logInfo("restoring network session from NVM");
        //dot->restoreNetworkSession();
        dot->resetConfig();
        dot->resetNetworkSession();
#endif
        if(!wakeup_pin)
        {
            t.reset();
            pc.printf("Warming up sensores %d seg.\r\n",WARMING_UP_SENSORS);
        }
        else
        {
            pc.printf("Despertado por pin Wakeup: TRANSMISION INSTANTANEA\r\n");
        }
    }

    // LOOP PRINCIPAL
     t.start();
    while (true) 
    {
        //Nos conectamos a la red LoRa si esta habilitado

#ifndef ONLY_SENSORS    
#ifdef OTA_MODE     
        // join network if not joined
        if (!dot->getNetworkJoinStatus()) 
        {     //join_network(config_frequency_sub_band);
                join_network();
                t.reset();
                //alimentacion = 0;
                //pc.printf("Warming up sensores %d seg.\r\n",WARMING_UP_SENSORS);               
        }
#else
  if (dot->getJoinMode() != mDot::MANUAL) {
            logInfo("changing network join mode to MANUAL");
            if (dot->setJoinMode(mDot::MANUAL) != mDot::MDOT_OK) {
                logError("failed to set network join mode to MANUAL");
            }
        }
        // in MANUAL join mode there is no join request/response transaction
        // as long as the Dot is configured correctly and provisioned correctly on the gateway, it should be able to communicate
        // network address - 4 bytes (00000001 - FFFFFFFE)
        // network session key - 16 bytes
        // data session key - 16 bytes
        // to provision your Dot with a Conduit gateway, follow the following steps
        //   * ssh into the Conduit
        //   * provision the Dot using the lora-query application: http://www.multitech.net/developer/software/lora/lora-network-server/
        //      lora-query -a 01020304 A 0102030401020304 <your Dot's device ID> 01020304010203040102030401020304 01020304010203040102030401020304
        //   * if you change the network address, network session key, or data session key, make sure you update them on the gateway
        // to provision your Dot with a 3rd party gateway, see the gateway or network provider documentation
        
        
        eui_to_netaddress(device_address);
        
        /*pc.printf("\n%s","Device Address = ");     
        for(i=0;i<4;i++)
        {
            pc.printf("%02x ",device_address[i]);            
        }
        */
        update_manual_config(device_address, network_session_key, data_session_key, frequency_sub_band, network_type, ack);

        // enable or disable Adaptive Data Rate
        dot->setAdr(adr);

        // Configure the join delay
        dot->setJoinDelay(join_delay);
                
#endif //De OTA_MODE

#endif // de ONLY_SENSORS

        if((t.read() >= WARMING_UP_SENSORS)||(wakeup_pin))
        {
   
            bat_8 = 0x00;

#ifndef HIBER_DEMO           
#ifndef USE_SENSOR_I2C
            t_temp =  average_samples(NUMBER_SAMPLES, a_temp);
            t_hum =  average_samples(NUMBER_SAMPLES, a_hum);
           
            temp_16 = a_temp.read_u16();
            hum_16 = a_hum.read_u16();    
       
            pc.printf("tension Temp (av): %3.3fv \r\n", t_temp);
            pc.printf("normalized: 0x%04X \r\n", temp_16);
            temperatura = volt_to_temp(t_temp);       
            pc.printf("Valor Temp: %3.3fC \r\n", temperatura);
          
            pc.printf("Tension Hum: %3.3fv \r\n", t_hum);
            pc.printf("normalized: 0x%04X \r\n", hum_16);
            humedad = volt_to_hum(t_hum);
            pc.printf("Valor Hum : %3.3f% \r\n", humedad);
#else
            //i2c.frequency(1000);
            done = false;
            pc.printf("I2C Addr=0x%02x(8bit), 0x%02x(7bit)\r\n",addr8bit,I2C_SENSOR_ADDRESS);
        
            cmd[0] = 0x2c;
            cmd[1] = 0x06; 
            
             for(j=0;j<6;j++)
             {
                   data[j] = 0;
             }
             pc.printf("I2C Write = %02x, %02x \r\n",cmd[0],cmd[1]);
             i2c.write(addr8bit, cmd, 2);
             wait(1);    
                
             i2c.read( addr8bit, data, 6);
        
             pc.printf("I2C Read = %02x, %02x, %02x, %02x, %02x, %02x\r\n",data[0],data[1],data[2],data[3],data[4],data[5]);
             done = true;
             /*if((data[0] == 0)&&(data[1] == 0)&&(data[3] == 0)&&(data[4] == 0))
             {
                 alimentacion = 0;
                 wait(1);
                 done = false;                    
                 retry_i2c++;
                 if(retry_i2c>20)
                 {
                     done = true;
                     enable_tx_data = true;
                     delay_sleep = DEFAULT_DELAY_SLEEP;
                     retry_i2c = 0;
                 }
                 else
                 {
                     enable_tx_data = false;
                     delay_sleep = 2;
                 }        
                 
                 alimentacion = 1;
                 wait(1);
                    
                 if(!dot->nvmWrite(I2C_RETRY_ADDRESS,&retry_i2c, sizeof(char)))
                 {
                      pc.printf("NO se pudo guardar retry_i2c\r\n");
                 }
                 else
                 {
                      pc.printf("retry_i2c = %d Guardado en NVRAM\r\n",retry_i2c);
                 }                    

            }
            else
            {
                  //done = true;
                  retry_i2c = 0;
            }              
            */
            
            if(done)
            {
                 temperatura = (((data[0] * 256) + data[1]) * 175.0) / 65535.0 - 45.0;                
                 humedad = (((data[3] * 256) + data[4])) * 100.0 / 65535.0;
                
                 pc.printf("Temperature in Celsius : %.2f C \r\n", temperatura);
                 pc.printf("Relative Humidity is : %.2f RH \r\n", humedad);  
                 
                 snprintf(temp_str,4,"%d",(unsigned int)temperatura); 
                 strncat(temp_str,"C",4);
                 snprintf(hum_str,4,"%d", (unsigned int)humedad); 
                 strncat(hum_str,"%",4);
                 
            }  
#ifdef MEDIR_BAT
            t_vbat =  average_samples(NUMBER_SAMPLES, a_vbat);         
            pc.printf("tension vbat (av): %3.3fv \r\n", t_vbat);    
            bat_8 = (unsigned char)(t_vbat*255/VSAMPLE);            
            pc.printf("tension vbat (char): %02x \r\n", bat_8); 
            if(t_vbat>0.35)
            {
                bat_val = (t_vbat-0.35)/(0.64);
                pc.printf("tension vbat (val): %3.3fv \r\n", bat_val);    
            }            
#endif
            
#endif //De USE_SENSOR_I2C
       
            pc.printf("---------------\r\n");
#ifdef OLD_READ_CO2            
            if(co2sens.readable()) 
            {
                co2sens.gets(co2_buffer,CO2_MAX_BUFFER);
                pc.printf("CO2: %s ",co2_buffer);
                //valor_co2 = (unsigned int)atoi(co2_buffer);
                valor_co2 = convert_co2(co2_buffer);
                
                //Ojo: Truncamos 32 a 16 bits para transmitir
                //Rango del sensor menor a 65536.
                pc.printf("CO2 HEX = 0x%04X\r\n",co2_16);
                co2_index = reset_co2_buffer(co2_buffer);                    
            }
                     
            /*if(co2_buffer[0] != 0)
            {
                pc.printf("CO2: %s \r\n",co2_buffer);
                co2_index = reset_co2_buffer(co2_buffer);                             
            }
            */
            else
            {
                pc.printf("NO hay datos de CO2!\r\n");
                valor_co2 = 0;
            }
            
            co2_16 = valor_co2;
                   
#else
            
            for(i=0;i<3;i++)
            {
                memset(co2_buffer,0,CO2_MAX_BUFFER);
            
                Timer timeout_co2;
                timeout_co2.reset();
                timeout_co2.start();
                char counter = 0;
                while ((timeout_co2.read() < 5)) // give the data up to 5 seconds to arrive.
                { 
                    if (co2sens.readable()) 
                    {
                        co2sens.gets(co2_buffer,CO2_MAX_BUFFER);
                        break;
                    }
                }
                        
                if(co2_buffer[0] == 0)
                {
                    pc.printf("NO hay datos de CO2!\r\n");
                    valor_co2 = 0;                
                }
                else
                {
                     pc.printf("CO2: %s ",co2_buffer);
                     valor_co2 = convert_co2(co2_buffer);
                     co2_16 = valor_co2;
                     pc.printf("CO2 (HEX) = %d | (0x%04X)\r\n",valor_co2,co2_16);
                     co2_index = reset_co2_buffer(co2_buffer);
                     snprintf(co2_str,4,"%d",valor_co2);
                }
                if(valor_co2 != 0)
                {
                    break;
                }
                
                wait(1);
            }
            
#endif
#endif //de #ifndef HIBER_DEMO

#ifdef HIBER_DEMO
            std::vector<uint8_t> tx_data;
            
            tx_data.push_back('W');
            tx_data.push_back('I');
            tx_data.push_back('A');
            tx_data.push_back('G');
            tx_data.push_back('R');
            tx_data.push_back('O');            
            tx_data.push_back('+');
            tx_data.push_back('H');
            tx_data.push_back('I');
            tx_data.push_back('B');
            tx_data.push_back('E');            
            tx_data.push_back('R');
 #ifdef USE_NFC           
    if(NFC_Init)
    {
        init_NFC_data(&NFC_Memory);
        strncpy(NFC_Memory.DEVID,deviceid,NFC_MAX_ID);
        strncpy(NFC_Memory.PAC,"WIAGRO+HIBER",NFC_MAX_ID);
        
        
        seq++;
        if((seq > 0x39)||(seq < 0x30))
        {
             seq = 0x30;
        }
        if(!dot->nvmWrite(SEQ_ADDRESS,&seq, sizeof(uint16_t)))
        {
             pc.printf("NO se pudo guardar la secuencia\r\n");
        }
        else
        {
             pc.printf("seq = %02x Guardado en NVRAM\r\n",seq);
        }
        
        NFC_Memory.sn = seq;
    
        //uint8_t NFC_Data = NFC_Memory;
    
        //NFC_STAT = BSP_NFCTAG_WriteData((uint8_t *)&NFC_Memory,NFC_START_ADDRESS,sizeof(NFC_Memory),&i2c);
        //NFC_STAT = ST25DV_IO_MemWrite((uint8_t *)&NFC_Memory,ST25DV_ADDR_DATA_I2C,NFC_START_ADDRESS,sizeof(NFC_Memory),&i2c);
        NFC_STAT = ST25DV_i2c_WriteData((uint8_t *)&NFC_Memory,NFC_START_ADDRESS,sizeof(NFC_Memory),&i2c);
        //NFC_STAT = ST25DV_i2c_WriteData((uint8_t *)deviceid,NFC_START_ADDRESS,sizeof(deviceid),&i2c);
        if( NFC_STAT == NFCTAG_OK )
        {
            pc.printf("NFC Wrote!\r\n");
        }
        else
        {
            pc.printf("%s%d\r\n","NFC NO escrito. Error: ",NFC_STAT);
        }
    }
    else
    {
        pc.printf("NFC NO iniciado\r\n");
    }            
            
#endif //de NFC
            
#else //De Hiber Demo

            std::vector<uint8_t> tx_data;

            
#ifdef MODO_TEST_TX
            tx_data.push_back((seq >> 8) & 0xFF);
            tx_data.push_back((seq & 0xFF));
#endif
            
            //Enviamos el tipo de lanza y el estado de movimiento
            extra_data = SENSOR_MODE;
            if(wakeup_pin)
            {
                //Activamos el bit de movimiento
                extra_data |= 0x10;
            }
            else
            {
                //Bajamos el bit de movimiento
                extra_data &= 0xef;
            }
            
            tx_data.push_back(extra_data);
            
            
#ifndef USE_SENSOR_I2C
            tx_data.push_back((temp_16 >> 8) & 0xFF);
            tx_data.push_back((temp_16 & 0xFF));
            
            tx_data.push_back((hum_16 >> 8) & 0xFF);
            tx_data.push_back((hum_16 & 0xFF));
#else
            //Temperatura MSB,LSB
            tx_data.push_back(data[1]);
            tx_data.push_back(data[0]);
            
            //Humedad MSB,LSB
            tx_data.push_back(data[4]);
            tx_data.push_back(data[3]);
#endif
            
            tx_data.push_back((co2_16 >> 8) & 0xFF);
            tx_data.push_back((co2_16 & 0xFF));            
            
            tx_data.push_back(bat_8);
            
        seq++;
        if(seq > 9999)
        {
             seq = 0;
        }
        if(!dot->nvmWrite(SEQ_ADDRESS,&seq, sizeof(uint16_t)))
        {
             pc.printf("NO se pudo guardar la secuencia\r\n");
        }
        else
        {
            pc.printf("seq = %d Guardado en NVRAM\r\n",seq);
        }
                    
#ifdef USE_NFC
    if(NFC_Init)
    {
        init_NFC_data(&NFC_Memory);
        //snprintf(seq_str,4,"%04d",seq);
        //strncat(NFC_Memory.PAC,seq_str,NFC_MAX_ID);
        
#ifndef NFC_ORIG_LAYOUT        
        strncpy(NFC_Memory.temp_str,temp_str,4);        
        strncpy(NFC_Memory.hum_str,hum_str,4);
        strncpy(NFC_Memory.co2_str,co2_str,4);        
#endif
        NFC_Memory.medicion_temperatura = fix16_from_float(temperatura);
        NFC_Memory.medicion_humedad = fix16_from_float(humedad);
        NFC_Memory.medicion_bateria = fix16_from_float(bat_val);
        NFC_Memory.medicion_co2 = fix16_from_float((float)valor_co2);
        
        memset(NFC_Memory.DEVID,0,NFC_MAX_ID);        
        strncpy(NFC_Memory.DEVID,deviceid,NFC_MAX_ID);

        strncpy(NFC_Memory.PAC,"L_v",NFC_MAX_ID);        
        strncat(NFC_Memory.PAC,PROGRAM_VERSION,NFC_MAX_ID);
        strncat(NFC_Memory.PAC,"_",NFC_MAX_ID);
        strncat(NFC_Memory.PAC,deviceid+4,NFC_MAX_ID);
        NFC_Memory.PAC[strlen(NFC_Memory.PAC)] = 0;
       
        
        //uint8_t NFC_Data = NFC_Memory;
    
        //NFC_STAT = BSP_NFCTAG_WriteData((uint8_t *)&NFC_Memory,NFC_START_ADDRESS,sizeof(NFC_Memory),&i2c);
        //NFC_STAT = ST25DV_IO_MemWrite((uint8_t *)&NFC_Memory,ST25DV_ADDR_DATA_I2C,NFC_START_ADDRESS,sizeof(NFC_Memory),&i2c);
        NFC_STAT = ST25DV_i2c_WriteData((uint8_t *)&NFC_Memory,NFC_START_ADDRESS,sizeof(NFC_Memory),&i2c);
        //NFC_STAT = ST25DV_i2c_WriteData((uint8_t *)deviceid,NFC_START_ADDRESS,sizeof(deviceid),&i2c);
        if( NFC_STAT == NFCTAG_OK )
        {
            pc.printf("NFC Wrote!\r\n");
        }
        else
        {
            pc.printf("%s%d\r\n","NFC NO escrito. Error: ",NFC_STAT);
        }
    }
    else
    {
        pc.printf("NFC NO iniciado\r\n");
    }
    
#endif
            
#endif //DE Hiber demo            

            pc.printf("Enviando paquete: ");
            for(i=0;i<MAX_MSG;i++)
            {
                bufsend[i] = 0;
            }
            for(i=0;i<tx_data.size();i++)
            {
                sprintf(aux,"%02x",tx_data.at(i));
                strcat(bufsend,aux);
                pc.printf(aux);
            }                 
            pc.printf("\r\n");
            
            std::string bufstr(bufsend);
            
             
            //send_string_data(bufstr);
#ifndef ONLY_SENSORS   
            if(enable_tx_data)            
                send_data(tx_data);
            
#ifdef MODO_TEST_TX
            seq++;
            if(seq > 60000)
            {
                seq = 0;
            }
            if(!dot->nvmWrite(SEQ_ADDRESS,&seq, sizeof(uint16_t)))
            {
                pc.printf("NO se pudo guardar la secuencia\r\n");
            }
            else
            {
                pc.printf("seq = %d Guardado en NVRAM\r\n",seq);
            }
                       
 #endif //De MODO_TEST_TX

 #endif //ONLY_SENSORS          

            if (deep_sleep) 
            {
                //logInfo("saving network session to NVM");
                //dot->saveNetworkSession();           
              
               //Abrimos el puerto serie del Co2
               //co2sens.baud(CO2_BAUDRATE);                
            }   
            
            sleep_timestamp = time(NULL);

            if(!dot->nvmWrite(TIME_SLEEP_ADDRESS,(void*)&sleep_timestamp, sizeof(time_t)))
            {
                pc.printf("NO se pudo guardar sleep_timestamp\r\n");
            }
            else
            {
                pc.printf("sleep_timestamp = %u Guardado en NVRAM\r\n",(unsigned int)sleep_timestamp);
            }   
            printf("## Off sensores ##\r\n");
            
            #ifdef USE_NFC
            BSP_NFCTAG_DeInit();
            #endif 

            //alimentacion = 0;
            alimentacion = 1;      
            
            // ONLY ONE of the three functions below should be uncommented depending on the desired wakeup method
            //sleep_wake_rtc_only(deep_sleep,delay_sleep);
            //sleep_wake_interrupt_only(deep_sleep);
#ifndef NO_SLEEP            
           
           sleep_wake_rtc_or_interrupt(deep_sleep,delay_sleep);
           
           if(!deep_sleep)
           { 
               t.reset();
               pc.printf("Warming up sensores %d seg.\r\n",WARMING_UP_SENSORS);
           }
#else
               t.reset();
               pc.printf("Warming up sensores %d seg.\r\n",WARMING_UP_SENSORS);
#endif

           
          flushSerialBuffer(&pc);
           
        } //Fin del IF WarmingUp
        
#ifdef DESARROLLO
        led1 = !led1;
        wait(0.5);
#endif


        if(pc.readable()) 
        {
            if(pc.getc()=='c')
            {
                config_sensor(&pc,&co2sens,co2_buffer);
            }
            else
            {
                pc.printf("Comando Invalido\r\n");
            }
        }
        
        
        
    } //Fin del loop principal
 
}
